% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_stand.R
\name{validate_fe_stand}
\alias{validate_fe_stand}
\title{Validate an \strong{fe_stand} Object}
\usage{
validate_fe_stand(x)
}
\arguments{
\item{x}{An object that is expected to be a correct \code{fe_stand} object}
}
\value{
Returns \code{x}, but this function is mainly called for its side
effect which is pointing out any violations of the \code{fe_stand} object
specifications. In case of such violations, the function will terminate
with an error.
}
\description{
Regular users will not require this function. Expert users will want to use
it in combination with the constructor \code{\link{new_fe_stand}}. Regular
users, please construct \code{fe_stand} objects with \code{\link{fe_stand}}.
}
\examples{
# Validate the example stands
validate_fe_stand(norway_spruce_1_fe_stand)
validate_fe_stand(european_beech_1_fe_stand)
validate_fe_stand(spruce_beech_1_fe_stand)
selection_forest_1_fe_stand |> validate_fe_stand()

}
