% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelationalData

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{RelationalData}
\alias{RelationalData}
\title{RelationalData}
\description{An abstract class for storing data in the form of a data frame. It enforces core functionality that we want the data we  model to have. This class covers any data which is stored as list.}
\seealso{
Inherits from : \code{\link{FrameData}}

Is inherited by : \code{\link{AbstractRelationalTables}}}
\examples{
library(dplyr)
library(reshape2)
SampleRelationalTables <- R6Class(
  inherit = AbstractRelationalTables,
  public = list(
    initialize = function(...)\{
      private$.tables = list(...)
      if(!all(sapply(private$.tables,function(x)\{is.data.frame(x)\})))\{
        stop("All arguments must be data frames")
      \}
    \},
    updateFrame = function()\{
      private$.frame = Reduce(x = private$.tables,f = left_join)
    \},
    updateArray = function()\{
      val <- names(self$frame)[1]
      dims <- names(self$frame[2:ncol(self$frame)])
      private$.arr <- self$frame \%>\%
        group_by_(.dots=setNames(dims,NULL)) \%>\%
        summarize_all(sum) \%>\% 
        ungroup() \%>\%
        acast(as.formula(paste(dims,collapse='~')),value.var=val)
      mode(private$.arr) = 'numeric'
      private$.dims = dim(private$.arr)
      private$.nrow = private$.dims[1]
      private$.ncol = private$.dims[2]
      private$.ndim = length(private$.dims)
      private$.dnames = dimnames(private$.arr)
    \}
  ),
  active = list(
    mat = function(value)\{
      if(self$ndim <= 2)\{
        return(self$arr)
      \}
      return(extract(private$.arr,indices = rep(self$ndim-2,x=1),dims = 3:self$ndim,drop=TRUE))
    \}
  )
)
}
\section{Fields}{
\describe{
\item{arr}{This is the full array.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{cellData}{A list of metadata associated with the cells of the data.}
\item{cnames}{The names of columns in the data.}
\item{colData}{A list of metadata associated with the columns of the data.}
\item{dimData}{The data associated with each dimension of the array.}
\item{dims}{The size of the array.}
\item{dnames}{The size of the array.}
\item{frame}{The data frame this class is responsible for.}
\item{mat}{This is the matrix.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{metaData}{Any data not part of the main data structure.}
\item{ncol}{The number of columns in the data.}
\item{ndim}{The number of dimensions of the array.}
\item{nrow}{The number of rows in the data}
\item{rnames}{The names of rows in the data.}
\item{rowData}{A list of metadata associated with the rows of the data.}
\item{tables}{The tables which make up the relational database.}
}}
\section{Methods}{
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{initialize(...)}{
This function \bold{should} be extended. Create a new instance of this class.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{This function should take in any arguments just in case.}
}}}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
