% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fi_MLM_func.R
\name{Fi_MLM_func}
\alias{Fi_MLM_func}
\title{Function to generate fisher information at one design point xi for multinomial logit models}
\usage{
Fi_MLM_func(X_x, bvec, link = "continuation")
}
\arguments{
\item{X_x}{model matrix for a specific design point x_i, X_x=h.func(xi)}

\item{bvec}{beta coefficients in the model}

\item{link}{multinomial logit model link function name "baseline", "cumulative", "adjacent", or"continuation", default to be "continuation"}
}
\value{
F_x Fisher information matrix at x_i

U_x U matrix for calculation of Fisher information matrix at x_i (see Corollary 3.1 in Bu, Majumdar, Yang(2020))
}
\description{
Function to generate fisher information at one design point xi for multinomial logit models
}
\examples{
# Reference minimizing surface example in supplementary material
# Section S.3 in Huang, Li, Mandal, Yang (2024)
xi.temp = c(-1, -25, 199.96, -150, -100, 16)
hfunc.temp = function(y){
if(length(y) != 6){stop("Input should have length 6");}
model.mat = matrix(NA, nrow=5, ncol=10, byrow=TRUE)
model.mat[5,]=0
model.mat[1:4,1:4] = diag(4)
model.mat[1:4, 5] =((-1)*y[6])
model.mat[1:4, 6:10] = matrix(((-1)*y[1:5]), nrow=4, ncol=5, byrow=TRUE)
return(model.mat)
}
X_x.temp = hfunc.temp(xi.temp)
bvec.temp = c(-1.77994301, -0.05287782,  1.86852211, 2.76330779, -0.94437464,
0.18504420,  -0.01638597, -0.03543202, -0.07060306, 0.10347917)
link.temp = "cumulative"
Fi_MLM_func(X_x=X_x.temp, bvec=bvec.temp, link=link.temp)


}
