% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FoReco-thief.R
\docType{data}
\name{FoReco-thief}
\alias{FoReco-thief}
\title{Simple examples to compare \code{FoReco} and \code{thief} packages}
\description{
The dataset in the \code{thief} package is used to show how to get the same results with the FoReco package.
In particular, we take the weekly data of Accident and Emergency demand in the UK, \code{AEdemand}, from 1 January
2011 to 31 December 2014.
}
\examples{
\dontrun{
library(thief)
require(FoReco)
dataset <- window(AEdemand[, 12], start = c(2011, 1), end = c(2014, 52))
data <- tsaggregates(dataset)
# Base forecasts
base <- list()
for (i in 1:5) {
  base[[i]] <- forecast(auto.arima(data[[i]]))
}
base[[6]] <- forecast(auto.arima(data[[6]]), h = 2)
# Base forecasts vector
base_vec <- NULL
for (i in 6:1) {
  base_vec <- c(base_vec, base[[i]]$mean)
}
# Residual vector
res <- NULL
for (i in 6:1) {
  res <- c(res, base[[i]]$residuals)
}

# OLS
obj_thief <- thief(dataset, m = 52, h = 2 * 52, comb = "ols", usemodel = "arima")
obj_thief <- tsaggregates(obj_thief$mean)
y_thief <- NULL
for (i in 6:1) {
  y_thief <- c(y_thief, obj_thief[[i]])
}
obj_thief_ols <- reconcilethief(base, comb="ols")
y_thief_ols <- NULL
for (i in 6:1) {
  y_thief_ols <- c(y_thief_ols, obj_thief_ols[[i]]$mean)
}
sum(abs(y_thief_ols - y_thief) > 1e-10)
y_FoReco_ols <- thfrec(base_vec, 52, comb = "ols")$recf
sum(abs(y_FoReco_ols - y_thief_ols) > 1e-10)

# STRUC
obj_thief_struc <- reconcilethief(base, comb="struc")
y_thief_struc <- NULL
for (i in 6:1) {
  y_thief_struc <- c(y_thief_struc, obj_thief_struc[[i]]$mean)
}
y_FoReco_struc <- thfrec(base_vec, 52, comb = "struc")$recf
sum(abs(y_FoReco_struc - y_thief_struc) > 1e-10)

# BU
obj_thief_bu <- reconcilethief(base, comb="bu")
y_thief_bu <- NULL
for (i in 6:1) {
  y_thief_bu <- c(y_thief_bu, obj_thief_bu[[i]]$mean)
}
y_FoReco_bu <- thfrec(base_vec, 52, comb = "bu")$recf
sum(abs(y_FoReco_bu - y_thief_bu) > 1e-10)

# SHR
obj_thief_shr <- reconcilethief(base, comb="shr")
y_thief_shr <- NULL
for (i in 6:1) {
  y_thief_shr <- c(y_thief_shr, obj_thief_shr[[i]]$mean)
}
y_FoReco_shr <- thfrec(base_vec, 52, comb = "shr", res = res)$recf
sum(abs(y_FoReco_shr - y_thief_shr) > 1e-10)
}
}
\references{
Hyndman, R. J., Kourentzes, N. (2018), thief: Temporal HIErarchical Forecasting, \emph{R package version 0.3},
\href{https://cran.r-project.org/package=thief}{https://cran.r-project.org/package=thief}.
}
\keyword{datasets}
