% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoweek.R
\name{isoweek}
\alias{isoweek}
\title{Calculate the ISO week & year for a Date}
\usage{
isoweek(x, type = "both_num", sep = "-", inv = FALSE,
  colnames = c("isoyear", "isoweek"))
}
\arguments{
\item{x}{A vector of class \code{\link{Date}} (of length >=1)}

\item{type}{A string (one of "week", "year", "both_text", "both_num" or "matrix")
that determines the kind of output the function returns. See "Return value".}

\item{sep}{Seperator between year and week, applicable if \code{type="both_text"}}

\item{inv}{If \code{type="both_text"}, and \code{inv=FALSE}, then year comes before
week. If \code{inv=TRUE}, week comes before year.}

\item{colnames}{Names for the matrix columns if \code{type="matrix"}}
}
\value{
Different according to the function's \code{type} argument. If
   \code{"both_num"} (the default), a vector of 6-digit integers is returned, in a
   YYYYWW format. If \code{"week"} or \code{"year"}, only the week number or year is
   returned, respectively. If \code{"both_text"}, then a character vector of the same
   length as \code{x} is returned, containing both the year and week number, seperated
   by \code{sep}, and inverted if \code{inv=TRUE}. Finally, if \code{type="matix"}, both
   year and week numbers are returned in a two-column matrix, with the columns named as
   in \code{colnames}.
}
\description{
This function takes a vector of Date objects and calculates the week and year
according to ISO 8601. It is flexible in its output.
}
\details{
This function calculates the week number according to ISO 8601. Note that
   dates near the start or end of a given year may belong to the previous or next
   year respectively, thus the year needs to be calculated too.
}
\examples{
isoweek(Sys.Date())
isoweek("1980-8-19", "both_text", sep="/", inv=TRUE)
isoweek(c("2004-5-31", "2006-6-10", "2007-8-20"), "matrix")

}
