% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.summary.R
\name{screen.summary}
\alias{screen.summary}
\title{Create a summary screening plot}
\usage{
screen.summary(metrics, type = "h", language = "English")
}
\arguments{
\item{metrics}{output from \code{\link{metrics.all}}}

\item{type}{Character indicating the set of metrics to plot.  Options
are "h" for high flow metrics, "l" for low flow metrics, or "b" for baseflow
metrics.}

\item{language}{Language for plot labels.  Choice of either "English" or
"French". Default is "English".}
}
\description{
Produces summary screening plots of high flow, low flow, or baseflow metrics.  
Each plot shows significant temporal trends and step changes. Intended for use as 
a data quality screening tool aimed at identifying streamflow records with 
anthropogenic impacts or data inhomogeneities.
}
\details{
For the center of volume (COV) plots on the high flow and baseflow screening plots,
  the correlation coefficients for COV and years and for
  mean annual flow (MAF) and years are added to the plot. The ratio of the correlation coefficients 
  (r COV-years / r COV-MAF) is included as a rudimentary indication
  of whether or not the temporal trend in COV is meaningful. See Whitfield (2013) for a
  discussion of COV.
  
  Drought metrics for the low flow plot may not be applicable to intermittent streams, and
  plots will be empty in this case.
  
  Important note:  If "French" is the language wanted for the plot labels, the language
  option must also be specified in \code{\link{metrics.all}}, as this plotting function 
  pulls the metric names from the output metrics.all output.
}
\examples{
# load results from metrics.all function for the Caniapiscau River
data(caniapiscau.res)

# create a summary flow screening plot of the high flow metrics
screen.summary(caniapiscau.res, type="h")
# screen.summary(caniapiscau.res, type = "l")
# screen.summary(caniapiscau.res, type = "b)
}
\references{
Whitfield, P.H. 2013. Is 'Center of Volume' a robust indicator of changes 
  in snowmelt timing? Hydrological Processes 27:2691-8.
}
\author{
Jennifer Dierauer
}
