% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEBoot.R
\name{MLEBoot}
\alias{MLEBoot}
\title{Creating bootstrap samples from observed data and computing MLEs}
\usage{
MLEBoot(x, y, intTol)
}
\arguments{
\item{x}{list of integers: indices of replications.}

\item{y}{numerical vector: observed data.}

\item{intTol}{threshold for stopping the computation of the integral in the normalization
constant: if the integral on the interval from n-1 to n is smaller than intTol, the approximation procedure stops.}
}
\value{
A list with the following elements:

MLE: maximum likelihood estimates obtained from each bootstrap sample.

errors: number of times the MLE algorithm breaks down.
}
\description{
This function creates bootstrap samples of input data and fits a dynamic mixture via
standard maximum likelihood.
}
\details{
MLEs are computed by means of the optim function. When it breaks
down, the sample is discarded and a new one is generated. The function keeps
track of the number of times this happens.
}
\examples{
bootMLEs <- MLEBoot(1,Metro2019,1e-02)
}
\keyword{MLE;}
\keyword{bootstrap.}
\keyword{dynamic}
\keyword{mixture;}
\keyword{non-parametric}
