`ans` <-
structure(list(formula = quote(mse ~ theta | which * n), as.table = FALSE, 
    aspect.fill = TRUE, legend = NULL, panel = function(x,y,subscripts=T){
      panel.xyplot(x,y)
      panel.abline(h=1, lty=2, col="red")
      ciLo<-y-1.96*mse.df$sd[subscripts]
      ciHi<-y+1.96*mse.df$sd[subscripts]
      lsegments(x,ciLo,x,ciHi,lwd=3)
      cat(x, fill=T)
      cat(ciLo, fill=T)
      cat(ciHi, fill=T)
      }
    , page = NULL, layout = NULL, skip = FALSE, strip = function (...) 
    {
        dots <- list(...)
        do.call("strip.default", updateList(dots, args))
    }, strip.left = FALSE, xscale.components = function (lim, 
        packet.number = 0, packet.list = NULL, top = TRUE, ...) 
    {
        comps <- calculateAxisComponents(lim, packet.list = packet.list, 
            packet.number = packet.number, ...)
        list(num.limit = comps$num.limit, bottom = list(ticks = list(at = comps$at, 
            tck = 1), labels = list(at = comps$at, labels = comps$labels, 
            check.overlap = comps$check.overlap)), top = top)
    }, yscale.components = function (lim, packet.number = 0, 
        packet.list = NULL, right = TRUE, ...) 
    {
        comps <- calculateAxisComponents(lim, packet.list = packet.list, 
            packet.number = packet.number, ...)
        list(num.limit = comps$num.limit, left = list(ticks = list(at = comps$at, 
            tck = 1), labels = list(at = comps$at, labels = comps$labels, 
            cex = 1, check.overlap = comps$check.overlap)), right = right)
    }, axis = function (side = c("top", "bottom", "left", "right"), 
        scales, components, as.table, labels = c("default", "yes", 
            "no"), ticks = c("default", "yes", "no"), ...) 
    {
        side <- match.arg(side)
        labels <- match.arg(labels)
        ticks <- match.arg(ticks)
        row <- lattice.getStatus("current.focus.row")
        column <- lattice.getStatus("current.focus.column")
        panel.layout <- trellis.currentLayout("panel")
        layout.dim <- dim(panel.layout)
        determineStatus <- function(x) {
            if (is.null(x) || (is.logical(x) && !x)) 
                FALSE
            else TRUE
        }
        lastPanel <- function() {
            ((pn <- panel.number()) > 0 && pn == max(panel.layout))
        }
        atBoundary <- function() {
            switch(side, top = if (as.table) 
                row == 1
            else row == layout.dim[1], bottom = if (!as.table) 
                row == 1
            else row == layout.dim[1], left = column == 1, right = column == 
                layout.dim[2] || lastPanel())
        }
        do.ticks <- switch(ticks, yes = TRUE, no = FALSE, default = scales$draw && 
            determineStatus(components[[side]]) && (if (scales$relation == 
            "same") 
            atBoundary()
        else TRUE))
        do.labels <- switch(labels, yes = TRUE, no = FALSE, default = scales$draw && 
            (if (scales$relation == "same") {
                atBoundary() && switch(side, top = rep(scales$alternating, 
                  length = column)[column] %in% c(2, 3), bottom = rep(scales$alternating, 
                  length = column)[column] %in% c(1, 3), left = rep(scales$alternating, 
                  length = row)[row] %in% c(1, 3), right = rep(scales$alternating, 
                  length = row)[row] %in% c(2, 3))
            }
            else TRUE))
        if (do.ticks || do.labels) {
            comp.list <- switch(side, top = if (is.logical(components[["top"]]) && 
                components[["top"]]) 
                components[["bottom"]]
            else components[["top"]], bottom = components[["bottom"]], 
                left = components[["left"]], right = if (is.logical(components[["right"]]) && 
                  components[["right"]]) 
                  components[["left"]]
                else components[["right"]])
            scales.tck <- switch(side, left = , bottom = scales$tck[1], 
                right = , top = scales$tck[2])
            panel.axis(side = side, at = comp.list$ticks$at, 
                labels = comp.list$labels$labels, draw.labels = do.labels, 
                check.overlap = comp.list$labels$check.overlap, 
                outside = TRUE, tick = do.ticks, tck = scales.tck * 
                  comp.list$ticks$tck, ...)
        }
    }, xlab = expression(theta[1]), ylab = "relative efficiency", 
    xlab.default = "theta", ylab.default = "mse", main = NULL, 
    sub = NULL, x.between = 0, y.between = 0, par.settings = NULL, 
    plot.args = NULL, lattice.options = NULL, par.strip.text = NULL, 
    index.cond = list(as.integer(c(1, 2)), as.integer(c(1, 2, 
    3, 4))), perm.cond = as.integer(c(1, 2)), condlevels = structure(list(
        which = c("Durbin", "faster"), n = c("50", "100", "200", 
        "400")), .Names = c("which", "n")), call = quote(xyplot.formula(x = mse ~ 
        theta | which * n, data = mse.df, panel = function(x, 
        y, subscripts = T) {
        panel.xyplot(x, y)
        panel.abline(h = 1, lty = 2, col = "red")
        ciLo <- y - 1.96 * mse.df$sd[subscripts]
        ciHi <- y + 1.96 * mse.df$sd[subscripts]
        lsegments(x, ciLo, x, ciHi, lwd = 3)
        cat(x, fill = T)
        cat(ciLo, fill = T)
        cat(ciHi, fill = T)
    }, strip = strip.custom(bg = 0), xlab = expression(theta[1]), 
        ylab = "relative efficiency")), x.scales = structure(list(
        draw = TRUE, axs = "r", tck = c(1, 1), tick.number = 5, 
        lty = FALSE, lwd = FALSE, cex = c(FALSE, FALSE), rot = c(FALSE, 
        FALSE), font = FALSE, fontfamily = FALSE, fontface = FALSE, 
        at = FALSE, labels = FALSE, col = FALSE, col.line = FALSE, 
        alpha = FALSE, alpha.line = FALSE, log = FALSE, alternating = c(1, 
        2), relation = "same", abbreviate = FALSE, minlength = 4, 
        limits = NULL, format = NULL), .Names = c("draw", "axs", 
    "tck", "tick.number", "lty", "lwd", "cex", "rot", "font", 
    "fontfamily", "fontface", "at", "labels", "col", "col.line", 
    "alpha", "alpha.line", "log", "alternating", "relation", 
    "abbreviate", "minlength", "limits", "format")), y.scales = structure(list(
        draw = TRUE, axs = "r", tck = c(1, 1), tick.number = 5, 
        lty = FALSE, lwd = FALSE, cex = c(FALSE, FALSE), rot = c(FALSE, 
        FALSE), font = FALSE, fontfamily = FALSE, fontface = FALSE, 
        at = FALSE, labels = FALSE, col = FALSE, col.line = FALSE, 
        alpha = FALSE, alpha.line = FALSE, log = FALSE, alternating = c(1, 
        2), relation = "same", abbreviate = FALSE, minlength = 4, 
        limits = NULL, format = NULL), .Names = c("draw", "axs", 
    "tck", "tick.number", "lty", "lwd", "cex", "rot", "font", 
    "fontfamily", "fontface", "at", "labels", "col", "col.line", 
    "alpha", "alpha.line", "log", "alternating", "relation", 
    "abbreviate", "minlength", "limits", "format")), panel.args.common = list(), 
    panel.args = list(structure(list(x = c(-1, -0.9, -0.6, -0.3, 
    0, 0.3, 0.6, 0.9, 1), y = c(0.11675274690557, 0.129732606691582, 
    0.224869800307634, 0.255905594541060, 0.256476071493035, 
    0.333151627730394, 0.558285515316407, 0.223460560950291, 
    0.0361318787980603), subscripts = as.integer(c(1, 2, 3, 4, 
    5, 6, 7, 8, 9))), .Names = c("x", "y", "subscripts")), structure(list(
        x = c(-1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1), y = c(0.913337528827138, 
        1.09671643879923, 1.05753636551142, 1.00297775635174, 
        1.01715505624527, 1.13453978617827, 1.57723068560817, 
        1.54455512439716, 0.185443757114687), subscripts = as.integer(c(37, 
        38, 39, 40, 41, 42, 43, 44, 45))), .Names = c("x", "y", 
    "subscripts")), structure(list(x = c(-1, -0.9, -0.6, -0.3, 
    0, 0.3, 0.6, 0.9, 1), y = c(0.156423947104345, 0.52455414752344, 
    0.42580574616558, 0.398787266601439, 0.413516965045608, 0.449220316054786, 
    0.700459052529701, 1.14160987755915, 0.0370537351186443), 
        subscripts = as.integer(c(10, 11, 12, 13, 14, 15, 16, 
        17, 18))), .Names = c("x", "y", "subscripts")), structure(list(
        x = c(-1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1), y = c(0.58591979891721, 
        1.08415368123961, 0.992188012576585, 1.00005102843258, 
        1.00051181076304, 1.00540777521766, 1.09758266972169, 
        2.42096181415489, 0.0911630580745359), subscripts = as.integer(c(46, 
        47, 48, 49, 50, 51, 52, 53, 54))), .Names = c("x", "y", 
    "subscripts")), structure(list(x = c(-1, -0.9, -0.6, -0.3, 
    0, 0.3, 0.6, 0.9, 1), y = c(0.0600041364510462, 0.90050428183714, 
    0.60506303753646, 0.614548516613525, 0.586962456595812, 0.64573842993309, 
    0.717904283345766, 1.85259080504198, 0.0215791273467595), 
        subscripts = as.integer(c(19, 20, 21, 22, 23, 24, 25, 
        26, 27))), .Names = c("x", "y", "subscripts")), structure(list(
        x = c(-1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1), y = c(0.186853760920037, 
        0.962248764510165, 0.99991270668017, 1.00002766065243, 
        1.00011068307345, 1.00082236502501, 1.00861943104796, 
        1.94989933834916, 0.0523313272679457), subscripts = as.integer(c(55, 
        56, 57, 58, 59, 60, 61, 62, 63))), .Names = c("x", "y", 
    "subscripts")), structure(list(x = c(-1, -0.9, -0.6, -0.3, 
    0, 0.3, 0.6, 0.9, 1), y = c(0.0176598056723895, 0.953789162530844, 
    0.76455950109146, 0.779904299143822, 0.795449770079783, 0.752567081666784, 
    0.85301549501212, 1.41974502957715, 0.012564912128548), subscripts = as.integer(c(28, 
    29, 30, 31, 32, 33, 34, 35, 36))), .Names = c("x", "y", "subscripts"
    )), structure(list(x = c(-1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 
    0.9, 1), y = c(0.0639968020757109, 0.9516869119359, 0.999953160848284, 
    1.00007571990428, 0.999959832848587, 1.00021793502312, 1.00222013449796, 
    1.16441526267162, 0.0379471770402344), subscripts = as.integer(c(64, 
    65, 66, 67, 68, 69, 70, 71, 72))), .Names = c("x", "y", "subscripts"
    ))), packet.sizes = structure(c(9, 9, 9, 9, 9, 9, 9, 9), .Dim = structure(as.integer(c(2, 
    4)), .Names = c("which", "n")), .Dimnames = structure(list(
        which = c("Durbin", "faster"), n = c("50", "100", "200", 
        "400")), .Names = c("which", "n"))), x.limits = c(-1.14, 
    1.14), y.limits = c(-0.156022871013296, 2.58954959729673), 
    x.used.at = NULL, y.used.at = NULL, x.num.limit = NULL, y.num.limit = NULL, 
    aspect.ratio = 1, prepanel.default = function (x, y, type, 
        subscripts, groups = NULL, ...) 
    {
        if (any(!is.na(x)) && any(!is.na(y))) {
            ord <- order(as.numeric(x))
            if (!is.null(groups)) {
                gg <- groups[subscripts]
                dx <- unlist(lapply(split(as.numeric(x)[ord], 
                  gg[ord]), diff))
                dy <- unlist(lapply(split(as.numeric(y)[ord], 
                  gg[ord]), diff))
            }
            else {
                dx <- diff(as.numeric(x[ord]))
                dy <- diff(as.numeric(y[ord]))
            }
            list(xlim = if (is.numeric(x)) range(x, finite = TRUE) else levels(x), 
                ylim = if (is.numeric(y)) range(y, finite = TRUE) else levels(y), 
                dx = dx, dy = dy)
        }
        else list(xlim = c(NA, NA), ylim = c(NA, NA), dx = NA, 
            dy = NA)
    }, prepanel = NULL), .Names = c("formula", "as.table", "aspect.fill", 
"legend", "panel", "page", "layout", "skip", "strip", "strip.left", 
"xscale.components", "yscale.components", "axis", "xlab", "ylab", 
"xlab.default", "ylab.default", "main", "sub", "x.between", "y.between", 
"par.settings", "plot.args", "lattice.options", "par.strip.text", 
"index.cond", "perm.cond", "condlevels", "call", "x.scales", 
"y.scales", "panel.args.common", "panel.args", "packet.sizes", 
"x.limits", "y.limits", "x.used.at", "y.used.at", "x.num.limit", 
"y.num.limit", "aspect.ratio", "prepanel.default", "prepanel"
), class = "trellis")
`BiasD` <-
structure(c(-0.0690303126917658, -0.110890543463780, -0.195813806698519, 
-0.0846684220656435, -0.00762767369911398, 0.138429122342300, 
0.172603596196988, 0.133413910796372, 0.105162207923409, -0.110967438223765, 
-0.154576056080638, -0.25844812651337, -0.207160704026511, 0.00503717948896988, 
0.155148737854047, 0.276332124402382, 0.150069477041232, 0.115917648692742, 
-0.0838443889592096, -0.164779279461025, -0.311479210945394, 
-0.235147403044395, 0.0133201563429544, 0.218763795788636, 0.317350470909664, 
0.169136106423357, 0.108738543240135), .Dim = as.integer(c(9, 
3)), .Dimnames = list(c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", 
"0.6", "0.9", "1"), c("50", "100", "200")))
`BiasF` <-
structure(c(-0.974703251797407, -0.895073111017522, -0.570278859547403, 
-0.295977976206187, -0.00325180241045575, 0.387319092212454, 
0.576355057215505, 0.864590639234944, 0.887893809592945, -0.948659708558226, 
-0.913473599597479, -0.599669202616826, -0.368261774822904, -0.00224587735315031, 
0.255714760354340, 0.617526799119699, 0.908749002809955, 0.95647809920068, 
-0.983338598345855, -0.892423731451171, -0.618626815816272, -0.315250157081183, 
0.0216282769685765, 0.296129566185396, 0.577019401636057, 0.896033294320301, 
0.964594775053182), .Dim = as.integer(c(9, 3)), .Dimnames = list(
    c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", "0.6", "0.9", 
    "1"), c("50", "100", "200")))
`BiasMLE` <-
structure(c(-0.979078091289149, -0.900288239954496, -0.570587385865598, 
-0.2960373847592, -0.00323382934460706, 0.387907488043804, 0.583598488220127, 
0.954974104644666, 0.971312372599029, -0.963845108072498, -0.908332066936113, 
-0.599682785539631, -0.368280578196013, -0.00223964837860805, 
0.255865621442613, 0.619632938403792, 0.967354887285601, 0.990077844307588, 
-0.99355897308926, -0.894232282669568, -0.618622948808761, -0.315263104368087, 
0.0216317292605715, 0.296158337829338, 0.577139194464239, 0.924420108966324, 
0.999999534230659), .Dim = as.integer(c(9, 3)), .Dimnames = list(
    c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", "0.6", "0.9", 
    "1"), c("50", "100", "200")))
`cleanws` <-
function(){
rm(list=ls(envir=.GlobalEnv), envir=.GlobalEnv)
load(file=".Rdata", envir=.GlobalEnv)
}

`contents` <-
c("cleanws", "last.warning", "loadws", "savews")
`DurbinMA1` <-
function(z, p){
phis<-c(1, -(ar.burg(z,aic=FALSE, order.max=p)$ar))
p1<-length(phis)
sum(phis[1:(p1-1)]*phis[2:p1])/sum(phis^2)
}

`effD` <-
structure(c(10.3933952928040, 8.09249758881614, 4.3031935448892, 
1.17237894060921, 0.0960621417214903, 0.929123430849498, 3.47886994812772, 
7.8136570677916, 10.0508001192620, 11.2706801095058, 8.78346121330523, 
3.97204024657359, 1.28121252787489, 0.0382457594033912, 0.691863090485676, 
4.04942974418599, 7.6394225816309, 9.18801075221118, 10.5774698071424, 
8.07648172826462, 3.6868152574181, 1.00977169726479, 0.0486416248546263, 
0.866827552159416, 3.70061237655753, 6.98832648176569, 10.0339063711565
), .Dim = as.integer(c(9, 3)))
`effF` <-
structure(c(10.7031814402698, 7.15791025140092, 5.18630684865208, 
1.88616418285361, 0.315059968586675, 1.07919787286359, 3.75730792280817, 
9.11324695487668, 8.99650721146275, 11.5211707655920, 8.59802894517409, 
4.09575139148999, 1.35353560323467, 0.0453305116170846, 0.605895251759884, 
4.01047776306944, 7.79853893787547, 9.7327277994626, 10.5301154411355, 
8.26914333638363, 3.78217717065533, 1.0584263097919, 0.0637302867721177, 
0.896697038366487, 3.76500101517305, 6.83978456502129, 10.1319335788826
), .Dim = as.integer(c(9, 3)))
`effMLE` <-
structure(c(10.7038435574625, 7.15653497705528, 5.1878033701398, 
1.92762214898487, 0.316768429894915, 1.07901590554933, 3.75671878938855, 
9.11209869138059, 8.99599646731858, 11.5249707650290, 8.59823183815812, 
4.09592741362995, 1.35383034132954, 0.0453337399219675, 0.605816988191265, 
4.01035622433275, 7.79846037508116, 9.73264081870544, 10.5301384525958, 
8.26912536746038, 3.78213652547288, 1.05847126605346, 0.0637380875621592, 
0.896662248443934, 3.76501956786495, 6.83969929128132, 10.1318521457164
), .Dim = as.integer(c(9, 3)))
`i` <-
as.integer(1000)
`ith` <-
as.integer(9)
`jn` <-
as.integer(4)
`last.warning` <-
structure(list("one-diml optimization by Nelder-Mead is unreliable: use optimize" = quote(optim(xinit, 
    EntropyARMA, method = "Nelder-Mead"))), .Names = "one-diml optimization by Nelder-Mead is unreliable: use optimize")
`loadws` <-
function(name, d="2007"){
name<-paste(d,name,sep="/")
ws <- paste(paste("d:/r",name,sep="/"),".Rdata",sep="/")
wsH <- paste(paste("d:/r",name,sep="/"),".RHistory",sep="/")
cat(ws, fill=T)
load(ws, .GlobalEnv)
loadhistory(wsH)
cat(paste("loaded: ", ws), fill=T)
cat(paste("loaded: ", wsH), fill=T)
}

`m` <-
structure(c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), .Dim = as.integer(c(9, 
4)), .Dimnames = list(c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", 
"0.6", "0.9", "1"), c("50", "100", "200", "400")))
`MeanD` <-
structure(c(-0.830674961340544, -0.751543308736522, -0.467316909249413, 
-0.178800712103553, 0.0525225131628362, 0.310366466903903, 0.539758305957765, 
0.751389133616283, 0.78810034515066, -0.921833629259487, -0.860282009223144, 
-0.550661923534292, -0.272945408029421, 0.0146847641436594, 0.314945245755121, 
0.597333611650305, 0.856177648854852, 0.897803019855788, -0.94000223204509, 
-0.881879232162987, -0.584260085747275, -0.290189282803636, 0.00486882867447971, 
0.302881704367686, 0.599425817199299, 0.883215341559748, 0.93137363145958, 
-0.946492241824048, -0.890485901207009, -0.591175399156737, -0.293675980119843, 
0.0042046012705598, 0.301061697053718, 0.597884122802736, 0.892127009608985, 
0.945168670918339), .Dim = as.integer(c(9, 4)), .Dimnames = list(
    c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", "0.6", "0.9", 
    "1"), c("50", "100", "200", "400")))
`MeanF` <-
structure(c(-0.957641127850552, -0.901537691470074, -0.614784148585509, 
-0.288440841640044, 0.0267855908236917, 0.337936080172804, 0.649809109491473, 
0.887553713914504, 0.911526208131895, -0.969134405763276, -0.911056821733944, 
-0.599761696959371, -0.298452697010590, 0.0109598921634137, 0.319823822400492, 
0.625533166911334, 0.902933043677017, 0.943792878538226, -0.97301692044341, 
-0.905306122744766, -0.600554989182073, -0.300382487738434, 0.00531562546392288, 
0.307126941909603, 0.610322146766518, 0.906141607241055, 0.962958098109745, 
-0.97600331573128, -0.902534672390357, -0.598421356051181, -0.297495933692955, 
0.00320791988990020, 0.304099766377127, 0.604560672410883, 0.903735685454766, 
0.974529805100112), .Dim = as.integer(c(9, 4)), .Dimnames = list(
    c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", "0.6", "0.9", 
    "1"), c("50", "100", "200", "400")))
`MeanMLE` <-
structure(c(-0.967581873031518, -0.907343608042309, -0.614806448031738, 
-0.28853475153753, 0.0270653715286451, 0.341647069185725, 0.675600167473008, 
0.969801601948802, 0.990341251612978, -0.985122317655478, -0.912958230071708, 
-0.599735209854659, -0.298480955029147, 0.0109724512828785, 0.320113332274474, 
0.628668180818271, 0.951100920227747, 0.994902565375118, -0.991654617191251, 
-0.904805006257844, -0.60056065922812, -0.300391757110132, 0.0053169296618149, 
0.307170371682632, 0.610742587702627, 0.923651558820933, 0.997366345789488, 
-0.996118981145822, -0.902157604982305, -0.598421794283246, -0.297500908487687, 
0.00320798558602943, 0.304113755833665, 0.604645669613779, 0.907800794979088, 
0.99868022738243), .Dim = as.integer(c(9, 4)), .Dimnames = list(
    c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", "0.6", "0.9", 
    "1"), c("50", "100", "200", "400")))
`mse` <-
function(x){sum(x^2)/length(x)}

`mse.df` <-
structure(list(theta = c(-1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 
1, -1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1, -1, -0.9, -0.6, 
-0.3, 0, 0.3, 0.6, 0.9, 1, -1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 
0.9, 1, -1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1, -1, -0.9, 
-0.6, -0.3, 0, 0.3, 0.6, 0.9, 1, -1, -0.9, -0.6, -0.3, 0, 0.3, 
0.6, 0.9, 1, -1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1), mse = c(0.11675274690557, 
0.129732606691582, 0.224869800307634, 0.255905594541060, 0.256476071493035, 
0.333151627730394, 0.558285515316407, 0.223460560950291, 0.0361318787980603, 
0.156423947104345, 0.52455414752344, 0.42580574616558, 0.398787266601439, 
0.413516965045608, 0.449220316054786, 0.700459052529701, 1.14160987755915, 
0.0370537351186443, 0.0600041364510462, 0.90050428183714, 0.60506303753646, 
0.614548516613525, 0.586962456595812, 0.64573842993309, 0.717904283345766, 
1.85259080504198, 0.0215791273467595, 0.0176598056723895, 0.953789162530844, 
0.76455950109146, 0.779904299143822, 0.795449770079783, 0.752567081666784, 
0.85301549501212, 1.41974502957715, 0.012564912128548, 0.913337528827138, 
1.09671643879923, 1.05753636551142, 1.00297775635174, 1.01715505624527, 
1.13453978617827, 1.57723068560817, 1.54455512439716, 0.185443757114687, 
0.58591979891721, 1.08415368123961, 0.992188012576585, 1.00005102843258, 
1.00051181076304, 1.00540777521766, 1.09758266972169, 2.42096181415489, 
0.0911630580745359, 0.186853760920037, 0.962248764510165, 0.99991270668017, 
1.00002766065243, 1.00011068307345, 1.00082236502501, 1.00861943104796, 
1.94989933834916, 0.0523313272679457, 0.0639968020757109, 0.9516869119359, 
0.999953160848284, 1.00007571990428, 0.999959832848587, 1.00021793502312, 
1.00222013449796, 1.16441526267162, 0.0379471770402344), which = structure(as.integer(c(1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2)), .Label = c("Durbin", "faster"), class = "factor"), 
    n = structure(as.integer(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
    2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 
    4, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 
    2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 
    4, 4, 4, 4, 4)), .Label = c("50", "100", "200", "400"), class = "factor"), 
    sd = c(0.00944596679411442, 0.0127781536886754, 0.0150535663224809, 
    0.0149113978963999, 0.0154116611841645, 0.0243419799136147, 
    0.0455538549021493, 0.0158672754781823, 0.00556220750621293, 
    0.0147836623405092, 0.0371189367216821, 0.0283689163302860, 
    0.0229281330038291, 0.0232919805668042, 0.0249050619068718, 
    0.0414850418703185, 0.0727185339265568, 0.00707614751082277, 
    0.00765784200307869, 0.0451597938947851, 0.0274600530673671, 
    0.0257351129293616, 0.0262202539105937, 0.0284706839427150, 
    0.029466187452174, 0.118918747812466, 0.00510756157046645, 
    0.00253517027291038, 0.0367392896330252, 0.0247155201151530, 
    0.0236961507193769, 0.0244489785536281, 0.0255810815239796, 
    0.0229284339772534, 0.0754874330866043, 0.00187010686754213, 
    0.0283177640136421, 0.0181641901896983, 0.00716526222398152, 
    0.00335102693517044, 0.00723069519888006, 0.0205195673169968, 
    0.0424578001386714, 0.0549250738280118, 0.0251859150300943, 
    0.0363718930288547, 0.0286542390115604, 0.0040747026717118, 
    2.96338347922989e-05, 7.339304105775e-05, 0.000684183816863362, 
    0.0224961430715832, 0.0895926273718853, 0.0173283441614964, 
    0.0216048450012685, 0.0338240812813165, 0.000108376467180745, 
    1.27474299584679e-05, 1.24817493379906e-05, 0.000113831326534903, 
    0.00196305624686718, 0.0881260793544163, 0.0119427219412892, 
    0.0080993678380628, 0.0274177834794264, 1.85689222145469e-05, 
    1.47732060306367e-05, 9.70187429956515e-06, 4.11347163271527e-05, 
    0.000247367649218510, 0.0547082624494129, 0.00583797407001605
    )), .Names = c("theta", "mse", "which", "n", "sd"), row.names = as.integer(c(NA, 
72)), class = "data.frame")
`mse2.df` <-
structure(list(theta = c(-1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 
1, -1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1, -1, -0.9, -0.6, 
-0.3, 0, 0.3, 0.6, 0.9, 1, -1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 
0.9, 1, -1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1, -1, -0.9, 
-0.6, -0.3, 0, 0.3, 0.6, 0.9, 1, -1, -0.9, -0.6, -0.3, 0, 0.3, 
0.6, 0.9, 1, -1, -0.9, -0.6, -0.3, 0, 0.3, 0.6, 0.9, 1), mse = c(0.11675274690557, 
0.129732606691582, 0.224869800307634, 0.255905594541060, 0.256476071493035, 
0.333151627730394, 0.558285515316407, 0.223460560950291, 0.0361318787980603, 
0.156423947104345, 0.52455414752344, 0.42580574616558, 0.398787266601439, 
0.413516965045608, 0.449220316054786, 0.700459052529701, 1.14160987755915, 
0.0370537351186443, 0.0600041364510462, 0.90050428183714, 0.60506303753646, 
0.614548516613525, 0.586962456595812, 0.64573842993309, 0.717904283345766, 
1.85259080504198, 0.0215791273467595, 0.0176598056723895, 0.953789162530844, 
0.76455950109146, 0.779904299143822, 0.795449770079783, 0.752567081666784, 
0.85301549501212, 1.41974502957715, 0.012564912128548, 0.913337528827138, 
1.09671643879923, 1.05753636551142, 1.00297775635174, 1.01715505624527, 
1.13453978617827, 1.57723068560817, 1.54455512439716, 0.185443757114687, 
0.58591979891721, 1.08415368123961, 0.992188012576585, 1.00005102843258, 
1.00051181076304, 1.00540777521766, 1.09758266972169, 2.42096181415489, 
0.0911630580745359, 0.186853760920037, 0.962248764510165, 0.99991270668017, 
1.00002766065243, 1.00011068307345, 1.00082236502501, 1.00861943104796, 
1.94989933834916, 0.0523313272679457, 0.0639968020757109, 0.9516869119359, 
0.999953160848284, 1.00007571990428, 0.999959832848587, 1.00021793502312, 
1.00222013449796, 1.16441526267162, 0.0379471770402344), which = structure(as.integer(c(1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2)), .Label = c("Durbin", "faster"), class = "factor"), 
    n = structure(as.integer(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
    2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 
    4, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 
    2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 
    4, 4, 4, 4, 4)), .Label = c("50", "100", "200", "400"), class = "factor"), 
    sd = c(0.00944596679411442, 0.0127781536886754, 0.0150535663224809, 
    0.0149113978963999, 0.0154116611841645, 0.0243419799136147, 
    0.0455538549021493, 0.0158672754781823, 0.00556220750621293, 
    0.0147836623405092, 0.0371189367216821, 0.0283689163302860, 
    0.0229281330038291, 0.0232919805668042, 0.0249050619068718, 
    0.0414850418703185, 0.0727185339265568, 0.00707614751082277, 
    0.00765784200307869, 0.0451597938947851, 0.0274600530673671, 
    0.0257351129293616, 0.0262202539105937, 0.0284706839427150, 
    0.029466187452174, 0.118918747812466, 0.00510756157046645, 
    0.00253517027291038, 0.0367392896330252, 0.0247155201151530, 
    0.0236961507193769, 0.0244489785536281, 0.0255810815239796, 
    0.0229284339772534, 0.0754874330866043, 0.00187010686754213, 
    0.0283177640136421, 0.0181641901896983, 0.00716526222398152, 
    0.00335102693517044, 0.00723069519888006, 0.0205195673169968, 
    0.0424578001386714, 0.0549250738280118, 0.0251859150300943, 
    0.0363718930288547, 0.0286542390115604, 0.0040747026717118, 
    2.96338347922989e-05, 7.339304105775e-05, 0.000684183816863362, 
    0.0224961430715832, 0.0895926273718853, 0.0173283441614964, 
    0.0216048450012685, 0.0338240812813165, 0.000108376467180745, 
    1.27474299584679e-05, 1.24817493379906e-05, 0.000113831326534903, 
    0.00196305624686718, 0.0881260793544163, 0.0119427219412892, 
    0.0080993678380628, 0.0274177834794264, 1.85689222145469e-05, 
    1.47732060306367e-05, 9.70187429956515e-06, 4.11347163271527e-05, 
    0.000247367649218510, 0.0547082624494129, 0.00583797407001605
    )), .Names = c("theta", "mse", "which", "n", "sd"), row.names = as.integer(c(NA, 
72)), class = "data.frame")
`mseD` <-
structure(c(0.0852596219067738, 0.138479576048634, 0.193507136067808, 
0.223529518482184, 0.245455466526454, 0.341558022898709, 0.544813533836584, 
0.210586753758435, 0.0290951016985412, 0.126771578910001, 0.591476138849711, 
0.40232462480872, 0.4268318095596, 0.442718458403334, 0.470541003675002, 
0.670621206216728, 1.14731088927409, 0.0400663303506093, 0.0754028115086399, 
0.836038742450519, 0.618681139676716, 0.610478672783002, 0.60857532886577, 
0.636975551616724, 0.722365673423229, 1.85009248664067, 0.0284136355846793, 
0.0214264548026244, 0.89295045527083, 0.798897190623, 0.789864005985535, 
0.79277653093417, 0.75705003864092, 0.806649607936729, 1.31370459060386, 
0.0108675604782136), .Dim = as.integer(c(9, 4)), .Dimnames = list(
    c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", "0.6", "0.9", 
    "1"), c("50", "100", "200", "400")))
`mseDF` <-
c(0.11675274690557, 0.129732606691582, 0.224869800307634, 0.255905594541060, 
0.256476071493035, 0.333151627730394, 0.558285515316407, 0.223460560950291, 
0.0361318787980603, 0.156423947104345, 0.52455414752344, 0.42580574616558, 
0.398787266601439, 0.413516965045608, 0.449220316054786, 0.700459052529701, 
1.14160987755915, 0.0370537351186443, 0.0600041364510462, 0.90050428183714, 
0.60506303753646, 0.614548516613525, 0.586962456595812, 0.64573842993309, 
0.717904283345766, 1.85259080504198, 0.0215791273467595, 0.0176598056723895, 
0.953789162530844, 0.76455950109146, 0.779904299143822, 0.795449770079783, 
0.752567081666784, 0.85301549501212, 1.41974502957715, 0.012564912128548, 
0.913337528827138, 1.09671643879923, 1.05753636551142, 1.00297775635174, 
1.01715505624527, 1.13453978617827, 1.57723068560817, 1.54455512439716, 
0.185443757114687, 0.58591979891721, 1.08415368123961, 0.992188012576585, 
1.00005102843258, 1.00051181076304, 1.00540777521766, 1.09758266972169, 
2.42096181415489, 0.0911630580745359, 0.186853760920037, 0.962248764510165, 
0.99991270668017, 1.00002766065243, 1.00011068307345, 1.00082236502501, 
1.00861943104796, 1.94989933834916, 0.0523313272679457, 0.0639968020757109, 
0.9516869119359, 0.999953160848284, 1.00007571990428, 0.999959832848587, 
1.00021793502312, 1.00222013449796, 1.16441526267162, 0.0379471770402344
)
`mseF` <-
structure(c(0.877381874465912, 1.09728885346222, 0.997657163610547, 
1.00077812144985, 1.01226537293687, 1.09514496862311, 1.52331411039183, 
1.47165492582176, 0.154645228185468, 0.49549396583126, 1.06916748154167, 
0.995451011685783, 1.00007376701679, 1.00065451633549, 1.00503053891596, 
1.10562358590040, 2.27570392091391, 0.101604046826142, 0.233381317798208, 
0.946287813712347, 1.00003068585311, 1.00001856376777, 1.00007529373951, 
1.00066967519491, 1.01205551384523, 1.97234216473242, 0.0681451156107372, 
0.0688450535834039, 0.877898304302363, 0.999978504751123, 1.00006360858646, 
0.999945490682645, 1.00028543066256, 1.00163191360360, 1.16625077086151, 
0.0336904026560573), .Dim = as.integer(c(9, 4)), .Dimnames = list(
    c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", "0.6", "0.9", 
    "1"), c("50", "100", "200", "400")))
`mseMLE` <-
structure(c(0.0042795962548916, 0.00796845314486918, 0.0190722990869763, 
0.0263320302057868, 0.0258577227539598, 0.0332230711216016, 0.0362531315639889, 
0.0110264857312587, 0.00205082689688391, 0.000989521955609123, 
0.00343209777374729, 0.00778473422329033, 0.0108891861617763, 
0.0121865514834940, 0.0113913547809333, 0.0101181275875402, 0.00653521349036619, 
0.000520281368831264, 0.000309948681922443, 0.00137751298513914, 
0.00336910625174822, 0.00514096145167567, 0.00555991398625583, 
0.00538625523536175, 0.003662503290538, 0.00271944043200138, 
0.000150408361253269, 6.569332846577e-05, 0.000553845490858736, 
0.00164608332859659, 0.0024746949045335, 0.00271669558956974, 
0.00238354524110274, 0.00174965674540721, 0.000769423302249804, 
3.46703070904024e-05), .Dim = as.integer(c(9, 4)), .Dimnames = list(
    c("-1", "-0.9", "-0.6", "-0.3", "0", "0.3", "0.6", "0.9", 
    "1"), c("50", "100", "200", "400")))
`n` <-
400
`ns` <-
c(50, 100, 200, 400)
`NSIM` <-
1000
`p` <-
30
`r` <-
c(50, 50, 50, 50, 50, 50, 50, 50, 50, 100, 100, 100, 100, 100, 
100, 100, 100, 100, 200, 200, 200, 200, 200, 200, 200, 200, 200, 
400, 400, 400, 400, 400, 400, 400, 400, 400, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 100, 100, 100, 100, 100, 100, 100, 100, 100, 
200, 200, 200, 200, 200, 200, 200, 200, 200, 400, 400, 400, 400, 
400, 400, 400, 400, 400)
`savews` <-
function(name=.WSID, d="2007"){
if (!exists(".WSID") && !is.character(name)) stop(".WSID not defined!")
.WSID<<-name
name<-paste(d,name,sep="/")
wsRdata <<- paste(paste("d:/r", name, sep="/"), ".Rdata", sep="/")
wsR <<- paste(paste("d:/r", name, sep="/"), "ws.R", sep="/")
save.image(wsRdata)
dump(ls(envir=.GlobalEnv),wsR)
wsRHistory <<- paste(paste("d:/r", name, sep="/"), ".RHistory", sep="/")
savehistory(wsRHistory)
cat(paste("saved: ", wsRdata), fill=T)
cat(paste("saved: ", wsR), fill=T)
cat(paste("saved: ", wsRHistory), fill=T)
}

`sd` <-
0
`sdD` <-
structure(c(0.00944596679411442, 0.0127781536886754, 0.0150535663224809, 
0.0149113978963999, 0.0154116611841645, 0.0243419799136147, 0.0455538549021493, 
0.0158672754781823, 0.00556220750621293, 0.0147836623405092, 
0.0371189367216821, 0.0283689163302860, 0.0229281330038291, 0.0232919805668042, 
0.0249050619068718, 0.0414850418703185, 0.0727185339265568, 0.00707614751082277, 
0.00765784200307869, 0.0451597938947851, 0.0274600530673671, 
0.0257351129293616, 0.0262202539105937, 0.0284706839427150, 0.029466187452174, 
0.118918747812466, 0.00510756157046645, 0.00253517027291038, 
0.0367392896330252, 0.0247155201151530, 0.0236961507193769, 0.0244489785536281, 
0.0255810815239796, 0.0229284339772534, 0.0754874330866043, 0.00187010686754213
), .Dim = as.integer(c(9, 4)), .Dimnames = list(c("-1", "-0.9", 
"-0.6", "-0.3", "0", "0.3", "0.6", "0.9", "1"), c("50", "100", 
"200", "400")))
`sdF` <-
structure(c(0.0283177640136421, 0.0181641901896983, 0.00716526222398152, 
0.00335102693517044, 0.00723069519888006, 0.0205195673169968, 
0.0424578001386714, 0.0549250738280118, 0.0251859150300943, 0.0363718930288547, 
0.0286542390115604, 0.0040747026717118, 2.96338347922989e-05, 
7.339304105775e-05, 0.000684183816863362, 0.0224961430715832, 
0.0895926273718853, 0.0173283441614964, 0.0216048450012685, 0.0338240812813165, 
0.000108376467180745, 1.27474299584679e-05, 1.24817493379906e-05, 
0.000113831326534903, 0.00196305624686718, 0.0881260793544163, 
0.0119427219412892, 0.0080993678380628, 0.0274177834794264, 1.85689222145469e-05, 
1.47732060306367e-05, 9.70187429956515e-06, 4.11347163271527e-05, 
0.000247367649218510, 0.0547082624494129, 0.00583797407001605
), .Dim = as.integer(c(9, 4)), .Dimnames = list(c("-1", "-0.9", 
"-0.6", "-0.3", "0", "0.3", "0.6", "0.9", "1"), c("50", "100", 
"200", "400")))
`SDRelativeEfficiency` <-
function(x,y){
mx<-mean(x)
my<-mean(y)
sx<-mean((x-mx)^2)
sy<-mean((y-my)^2)
sxy<-mean((x-mx)*(y-my))
v<-(sx/(my^2)) + (sy*mx^2)/(my^4) - (2*sxy*mx)/(my^3)
sqrt(v/length(x))
}

`SimulateMA1` <-
function(n, theta){
a<-rnorm(n+1)
a[2:(n+1)]-theta*a[1:n]
}

`StartTime` <-
c(8779.51, 15.67, 115156.28, NA, NA)
`th` <-
1
`thDurbin` <-
structure(c(-0.505193951500373, -0.732077854756902, -0.845998599575516, 
-0.75787583825544, -0.920525201149673, -0.853241173504917, -0.832747938898339, 
-0.674897159007663, -0.493540325887117, -0.83192117277901, -0.76000522332736, 
-0.96635433899696, -0.815863830546794, -0.599956841301868, -0.91375983447549, 
-0.96514896013175, -0.819525743520686, -0.701655398486551, -0.582218343365621, 
-0.845125624292522, -0.861789399945669, -0.722072194345376, -0.963651912748377, 
-0.920743518531759, -0.920234347272862, -0.776979538004163, -0.942889320184296, 
-0.954744338083838, -0.814483673343487, -0.806093142047087, -0.710239371834969, 
-0.977223972024368, -0.810779846400008, -0.646502113172776, -0.903668883080996, 
-0.867870810625215, -0.783903507666004, -0.842033586993514, -0.901316470965497, 
-0.681529388020762, -0.77474815718757, -0.935987077296026, -0.804077420127322, 
-0.918027464516304, -0.9863556240386, -0.815499693945625, -0.860817669387432, 
-0.967825557669366, -0.673803437265231, -0.974296732020552, -0.778592798306625, 
-0.79704394063562, -0.865477982891128, -0.883005665396508, -0.964507691880035, 
-0.833870550150602, -0.837163323481876, -0.935586552947103, -0.978250621256586, 
-0.835566385332608, -0.892969158791517, -0.885047095606987, -0.865108232282163, 
-0.812935624305868, -0.856004172053413, -0.915182826961843, -0.976568927102892, 
-0.751325061210655, -0.580188165686349, -0.380839418369843, -0.655290519092318, 
-0.600759276897684, -0.870671937100656, -0.538996709253126, -0.785353619466576, 
-0.743365431479297, -0.91630408958022, -0.749540102222822, -0.979924402140706, 
-0.491902302866498, -0.779500327402137, -0.725417674934555, -0.418928309484356, 
-0.564107006247112, -0.93744127232034, -0.922099424679028, -0.990782536828253, 
-0.919100801743047, -0.821271116338102, -0.787867311532247, -0.67355110844241, 
-0.943801376360446, -0.836639978596792, -0.58709755567599, -0.885282006322486, 
-0.721990619529469, -0.97261876649887, -0.948108996261724, -0.924380537701857, 
-0.887436020967435, -0.942516830493222, -0.335954543380580, -0.806151988657837, 
-0.944606670050165, -0.902954832252398, -0.872423040590178, -0.882770347535603, 
-0.888213176625964, -0.76577197684916, -0.573347559930934, -0.78274426379605, 
-0.751737690937824, -0.781351973492307, -0.679147335414466, -0.893561312864474, 
-0.780856488991236, -0.957706574713306, -0.86219484610385, -0.919800541687791, 
-0.82652086235744, -0.731716296296117, -0.678822630613309, -0.861958602240426, 
-0.979217199690015, -0.963113015756236, -0.940918994707124, -0.918810175961153, 
-0.918862465918683, -0.898296863645583, -0.846582989963983, -0.777210381668263, 
-0.815290087241333, -0.561835160471573, -0.987758135347809, -0.600245044541096, 
-0.694012123979297, -0.775320646697061, -0.917998065322853, -0.82290354477612, 
-0.915444190983495, -0.747817568248968, -0.873997193763913, -0.900515676476431, 
-0.858019505498486, -0.845122595208408, -0.893850837406194, -0.853331354925165, 
-0.829496545988353, -0.922457815056405, -0.97783335493004, -0.806824711902849, 
-0.891000350694652, -0.920137539453763, -0.497895754556065, -0.71864838040628, 
-0.97357824167442, -0.93941229140729, -0.654849848421987, -0.931446017005169, 
-0.784002906810984, -0.913534199861873, -0.828248419570262, -0.89409357204391, 
-0.884047633809156, -0.98077115496102, -0.988582438968188, -0.969594424418022, 
-0.968186357353603, -0.819951867362402, -0.96929483489485, -0.95287175565892, 
-0.933044713338012, -0.97361098934006, -0.715792493909543, -0.837209738216221, 
-0.676105650452554, -0.885025011571981, -0.0766394957193315, 
-0.939104587939309, -0.853306712328365, -0.93773436722772, -0.966028868517988, 
-0.86523247782925, -0.792353338548126, -0.9649553195758, -0.734564455303524, 
-0.647516266790045, -0.957854516909462, -0.8921168685546, -0.829713145775937, 
-0.803890112258425, -0.922572388716387, -0.648276456268816, -0.709291658884664, 
-0.950342679356576, -0.899262353041093, -0.915176590199906, -0.837236474246876, 
-0.97115970719555, -0.848879109018911, -0.860695301309642, -0.848924651229635, 
-0.936428635025856, -0.768790842638266, -0.898012776982422, -0.732563204733574, 
-0.851719084001074, -0.829823458702835, -0.79782162112224, -0.713539328650275, 
-0.408939337948523, -0.971871481444237, -0.985362346034677, -0.881659113576722, 
-0.923440193447863, -0.930700400091815, -0.781629126747099, -0.958022414062153, 
-0.825543694179107, -0.853416686250417, -0.89838561861183, -0.693007684933484, 
-0.7792346383689, -0.738379262434406, -0.537163833307247, -0.881750299236127, 
-0.992066741336876, -0.875003492941987, -0.876176848588849, -0.945042679889953, 
-0.975069595309112, -0.737691170063464, -0.886352100945378, -0.829246363257359, 
-0.963063358118843, -0.910073939198325, -0.962801782104806, -0.93931442252634, 
-0.72246329640068, -0.913452890058662, -0.75177442650103, -0.987908228444208, 
-0.809471217943393, -0.860469704798049, -0.790610147632916, -0.892969289860835, 
-0.97806002351601, -0.817946192433287, -0.95925097237291, -0.877039567581552, 
-0.931920102198793, -0.949941460340198, -0.7263224122778, -0.977146170576175, 
-0.874700288663299, -0.830824812044966, -0.824203327819108, 0.531365511570086, 
-0.899401242993352, -0.92005474498062, -0.82475915432243, -0.95217207931158, 
-0.343707184028670, -0.916576861591257, -0.775504425123972, -0.217106349032354, 
-0.903263019729717, -0.949310498813906, -0.935858800346075, -0.725335476621091, 
-0.870125730276145, -0.759374624025206, -0.935871604086666, -0.853632193329195, 
-0.964044001791387, -0.862927562695557, -0.964801440057585, -0.973123307676102, 
-0.694045566290327, -0.801337586641138, -0.882376963088303, -0.708271068901198, 
-0.90347773987355, -0.835428124222355, -0.862031130158417, -0.660479152625794, 
-0.941219464372103, -0.899354464591221, -0.925306534771307, -0.717031850653234, 
-0.89762579349353, -0.932065601173153, -0.829451654510144, -0.498392233016414, 
-0.825796137158774, -0.991713173316504, -0.877705087211034, -0.735071692211295, 
-0.591162430982916, -0.9352404276063, -0.965301932894151, -0.9054658601927, 
-0.950940480467133, -0.891669811335803, -0.84029117407858, -0.931900747752064, 
-0.80261077599462, -0.906732339610074, -0.883452734951945, -0.900315659848182, 
-0.461976232862898, -0.699230896436977, -0.781036956927965, -0.866002379906307, 
-0.885147093096353, -0.972910754618297, -0.972995405849063, -0.616491472904809, 
-0.975758763580571, -0.943291436531307, -0.874122225795455, -0.801686661996552, 
-0.740353168035323, -0.813614624036859, -0.820303612887308, -0.891987524710581, 
-0.672449900010438, -0.974858556729702, -0.789443679934612, -0.96646329927991, 
-0.571494287959933, -0.79754366300185, -0.932453234636662, -0.881372554058385, 
-0.947313476190532, -0.958363361785127, -0.901072315711641, -0.987496955010941, 
-0.702341849405488, -0.982437777334123, -0.9622499015849, -0.60175013500937, 
-0.956010139354214, -0.973880732384635, -0.911822687255986, -0.934418655051872, 
-0.908878876601092, -0.90696383736213, -0.87032046478951, -0.913855470460985, 
-0.645415056468179, -0.954421451291277, -0.886218861666428, -0.903992563568509, 
-0.629137469895515, -0.573188203276988, -0.672131387182386, -0.864757644322859, 
-0.83693686285489, -0.580671902962072, -0.772865805324053, -0.88969913578855, 
-0.908184448899942, -0.795795943846564, -0.947496347021587, -0.735730843203496, 
-0.914334292209934, -0.54972212228936, -0.657505741592161, -0.818347383748862, 
-0.585795193951924, -0.95669963778309, -0.722400106513188, -0.982327600565649, 
-0.9085094253011, -0.74171067214642, -0.81062826437551, -0.509621666773785, 
-0.683207746077971, -0.957832511136135, -0.503975732912929, -0.982454578423944, 
-0.845355433289359, -0.673490857746551, -0.881061606381943, -0.986097027898578, 
-0.853758171973061, -0.961718177427196, -0.607914057584693, -0.946986856730106, 
-0.917671894666795, -0.871229556025138, -0.711047194883198, -0.735194226905011, 
-0.802812357621517, -0.781928318525862, -0.83562693402631, -0.96289787726213, 
-0.867178654994399, -0.972106843060663, -0.901301550092089, -0.77629376196296, 
-0.640474943314265, -0.878123852824118, -0.741499036439163, -0.952591917228748, 
-0.934080909315077, -0.985623455652232, -0.957884980160787, -0.940723245592918, 
-0.906559265426197, -0.897471076735773, -0.922602922065137, -0.855691337771203, 
-0.92924817674128, -0.943621711159502, -0.874051641504167, -0.797561261909646, 
-0.816492304465628, -0.735224010501496, -0.966283526840837, -0.86702952051175, 
-0.979625613346067, -0.902490510986324, -0.834747836096448, -0.898012499542872, 
-0.849225694857929, -0.953617791728731, -0.847266102426487, -0.87784608965466, 
-0.746415860492445, -0.96893497222685, -0.666811650980448, -0.767205217941989, 
-0.961935777023853, -0.88393136956201, -0.981089218762062, -0.94878609643341, 
-0.855840299497032, -0.879862195964546, -0.690385598455226, -0.882586252772568, 
-0.629360010320717, -0.859877049740536, -0.845743348850481, -0.97650876714916, 
-0.90670548108235, -0.916639577784939, -0.772525555040859, -0.942029466380771, 
-0.56470532776094, -0.944579991161686, -0.955158981614894, -0.864556453379116, 
-0.641072781443493, -0.785413185451803, -0.960602585435526, -0.94705950778452, 
-0.967632057016592, -0.706856641973455, -0.840667291158363, -0.854164127592821, 
-0.903520028159754, -0.90149402826995, -0.749706218413063, -0.837261900411028, 
-0.740763221201025, -0.834763029522018, -0.944723126094262, -0.878598735473881, 
-0.874473762656846, -0.863184905180168, -0.964955505666006, -0.930147731693515, 
-0.909388173818699, -0.876683689179865, -0.983814421007863, -0.868288907707351, 
-0.694936398505578, -0.897572345450318, -0.972749834111619, -0.952012065586706, 
-0.723994055348063, -0.44713934950661, -0.959185570548016, -0.939301342015048, 
-0.872056992477747, -0.95423614201191, -0.869334853057476, -0.857740082594001, 
-0.735323266312196, -0.842869621892823, -0.747090931753425, -0.676790559673942, 
-0.96979995683039, -0.807754484804964, -0.989682865814867, -0.887670506284432, 
-0.898712320168676, -0.596123356587808, -0.530471384338305, -0.884691416456518, 
-0.535209812126411, -0.987834116039967, -0.701750374004265, -0.757445715093872, 
-0.802057289758234, -0.716236353882713, -0.962305972296575, -0.904066158704496, 
-0.595234156071576, -0.739119913939797, -0.883034245798885, -0.850925529083689, 
-0.70953531867805, -0.932576327778221, -0.971195052079605, -0.840987570113563, 
-0.629829597117873, -0.96061530338961, -0.8843276830561, -0.775433653354453, 
-0.880798014697482, -0.812750433365427, -0.921239619546314, -0.985397990178081, 
-0.598907608217325, -0.695346808565069, -0.84257849404722, -0.45808334440449, 
-0.927672014784511, -0.99140265048006, -0.947617171335169, -0.965076998958358, 
-0.94362857778325, -0.964674804016417, -0.68302968498946, -0.909740487093623, 
-0.913261567593301, -0.828962439480971, -0.100156047298979, -0.966670385264657, 
-0.908617990534263, -0.615402669620831, -0.964957514579598, -0.631483257067197, 
-0.981395421578746, -0.869570133584383, -0.773674568323367, -0.867821778889129, 
-0.911082710400035, -0.776467732548, -0.975050997660842, -0.889692650243234, 
-0.974233678990665, -0.961127710251282, -0.858706223290722, -0.72771081562213, 
-0.906707061749978, -0.954530277332174, -0.86572467386218, -0.8589232465193, 
-0.727976294851842, -0.891867723400503, -0.904034826947236, -0.843824694353766, 
-0.80762211428928, -0.760251134677825, -0.98307238266191, -0.885100019072284, 
-0.98790515318406, -0.868270443701464, -0.903215914314378, -0.86735699094158, 
-0.736498934797483, -0.85815530048782, -0.930231947164837, -0.757049935331912, 
-0.902429442430069, -0.786063643383493, -0.795646385361419, -0.803417721432965, 
-0.800682453795783, -0.894731893121858, -0.897980762925716, -0.891001205120376, 
-0.987438658412795, -0.801905433527132, -0.897872008926512, -0.247609438395832, 
-0.841966974902587, -0.794245077608518, -0.43458974477856, -0.827676838078481, 
-0.604370655513735, -0.848927017229942, -0.946349697115321, -0.842739697338682, 
-0.97880812547655, -0.891198451034177, -0.68430563713297, -0.86553547439923, 
-0.814634748155953, -0.98686360376773, -0.859669862432573, -0.931349564363318, 
-0.973607235726077, -0.852732399082922, -0.886883181322748, -0.931588794052153, 
-0.72881986891279, -0.533914504662329, -0.816252439654296, -0.918106849451626, 
-0.89714193651551, -0.629706942912479, -0.955732886543652, -0.388717055783149, 
-0.901426239776459, -0.967234703889355, -0.89834532500983, -0.972112149892627, 
-0.900925797265732, -0.939318999374418, -0.93700726602864, -0.83671749672257, 
-0.946011094872365, -0.896213931144237, -0.951454895060123, -0.743425365389583, 
-0.944479576220404, -0.837098947928911, -0.849277203119098, -0.782932552487129, 
-0.409446396388464, -0.949607468593513, -0.811100863566036, -0.910795020519749, 
-0.853991723503206, -0.881986464878569, -0.953893693324506, -0.930826024928033, 
-0.433468115376623, -0.874163381600747, -0.921896768005536, -0.931573976409591, 
-0.973820253664944, -0.794678501316781, -0.955647355439392, -0.788115613654108, 
-0.90639689886171, -0.879378506848255, -0.876187242876956, -0.661014919154672, 
-0.789756335021869, -0.687015338539999, -0.776361463959948, -0.684061483864445, 
-0.79905981148599, -0.84058565402385, -0.732210783244968, -0.972229762002114, 
-0.983751220204057, -0.051065440162887, -0.893069617192466, -0.879722118349403, 
-0.561785836814768, -0.820735133068484, -0.759174477131915, -0.93566605724555, 
-0.671288249349904, -0.816917171513186, -0.915414984325437, -0.953877337244888, 
-0.786589908274742, -0.88580323759623, -0.593296924496723, -0.960464244063025, 
-0.954044461386185, -0.853823966659656, -0.867363018134614, -0.96917368496058, 
-0.717211684293785, -0.772965793871331, -0.587984963683634, -0.790747777122064, 
-0.959952975641905, -0.850910268506312, -0.880039023539653, -0.937812546514821, 
-0.956191449845816, -0.677058558537592, -0.943935389915736, -0.593309543183706, 
-0.868637876641871, -0.972682429112441, -0.844755250963581, -0.661181160053369, 
-0.946291423570679, -0.954018632435202, -0.914568792142403, -0.884831496623268, 
-0.98309523681241, -0.842881644945368, -0.950291722785535, -0.903213234733863, 
-0.927050699891883, -0.950683338746113, -0.942978091416218, -0.923730552646781, 
-0.805232447596342, -0.813765959952967, -0.660100229970718, -0.90084559484604, 
-0.918357969313352, -0.47785456294629, -0.796588521748953, -0.657818419324714, 
-0.700337926451713, -0.94489568431251, -0.867664577025817, -0.83705240235057, 
-0.878236115382982, -0.76603570587944, -0.56352786037552, -0.749067862533518, 
-0.936368856587178, -0.776466521280552, -0.847033514989244, -0.9391122068268, 
-0.913733416189006, -0.910857618647593, -0.924163014319895, -0.697593686955148, 
-0.875512967366325, -0.745039246394917, -0.9170868287303, -0.865011502406374, 
-0.960044958167993, -0.650014626514822, -0.887894589101276, -0.835546699961898, 
-0.859046822818139, -0.924068380998987, -0.95972215695325, -0.893721946643673, 
-0.90496956321412, -0.885822354217694, -0.881913877236475, -0.806535971333841, 
-0.74868284839586, -0.649077028408136, -0.304258084865527, -0.834901852804349, 
-0.762554630317167, -0.889527572752338, -0.955512074673445, -0.843077397173154, 
-0.862973297124582, -0.989183184855517, -0.953393880563667, -0.885621400638687, 
-0.969180146463737, -0.76273172360857, -0.881256838985297, -0.882219796945068, 
-0.520238358322388, -0.874418379823778, -0.768366067294528, -0.960404032216556, 
-0.940339371510577, -0.858037656861341, -0.720845393240397, -0.563496348793937, 
-0.288527253745912, -0.910063575006178, -0.766899991344903, -0.896969361012798, 
-0.85791333212781, -0.877180512985828, -0.368454405070447, -0.81951072800453, 
-0.913811139331178, -0.924810374758226, -0.9830762476826, -0.906396884053626, 
-0.719178035117002, -0.839800133960973, -0.750986482526343, -0.968956584696285, 
-0.925925765126464, -0.839315744599684, -0.962393772541956, -0.945065634957302, 
-0.62256648333548, -0.962581467899575, -0.934643494001687, -0.871997019736322, 
-0.706425352144823, -0.830473129747935, -0.936409171594912, -0.821248247073732, 
-0.901077795515118, -0.915445442402352, -0.892080082439645, -0.898771220740711, 
-0.730806975156888, -0.945936269323039, -0.643901705585016, -0.935771450462952, 
-0.980617269564046, -0.768733008062595, -0.825663881718022, -0.980020302094852, 
-0.845717846169209, -0.86567683459598, -0.90124695827175, -0.806726683630595, 
-0.890182931078304, -0.822082224842645, -0.96048054692408, -0.972644423974906, 
-0.899539753993317, -0.843502945475419, -0.817515524848033, -0.869179350434543, 
-0.227836072462534, -0.710463901582137, -0.812281713113018, -0.959455305562226, 
-0.387313046155594, -0.95896348130687, -0.925819300628163, -0.756185306208752, 
-0.927142469608873, -0.84170647531385, -0.939883432066806, -0.993821423110932, 
-0.438036525156218, -0.713519814332777, -0.758025470855015, -0.731929080773111, 
-0.747546089974157, -0.945877379348893, -0.91146777004673, -0.69276083931977, 
-0.892482450292233, -0.9777030195875, -0.91238755929072, -0.978337798383648, 
-0.913691742579626, -0.82322267645632, -0.868170906257426, -0.953088583867133, 
-0.97430410980099, -0.490357996891223, -0.93169477968185, -0.778842257247844, 
-0.877243797938571, -0.84991599134099, -0.961529563500822, -0.825064278661446, 
-0.895389374083668, -0.602288980042466, -0.984248933333423, -0.941303702394457, 
-0.885554747342233, -0.930183506246128, -0.776013222596006, -0.966459543518363, 
-0.930058480833694, -0.896665843779336, -0.412936457584369, -0.912904559911695, 
-0.699789584329824, -0.958112416404476, -0.484618979272492, -0.97313605712007, 
-0.908898273918225, -0.993116596359197, -0.966128513695126, -0.967820920068995, 
-0.913239128269649, -0.817350719599322, -0.942567322449318, -0.961610087331393, 
-0.752265283227582, -0.765814229444781, -0.919105458318888, -0.910449023764648, 
-0.92739029452419, -0.766698968163748, -0.949454142097577, -0.855250532947135, 
-0.382297924780948, -0.77120927796313, -0.821392488662014, -0.976154311818063, 
-0.82235675060996, -0.863844935300832, -0.9644766732634, -0.86240853777992, 
-0.621661347003829, -0.910397495158525, -0.783521731609269, -0.921853990891048, 
-0.975126671091035, -0.955173542810554, -0.933962129688623, -0.343523975845873, 
-0.0838691176715912, -0.974225277343898, -0.8904834232147, -0.914394222767288, 
-0.699787770195627, -0.734827161251862, -0.86435725831822, -0.893250650965133, 
-0.934264158977328, -0.716786199876466, -0.718566561210046, -0.84282605324301, 
-0.879739251676344, -0.544275715990598, -0.708246464385483, -0.876729157894303, 
-0.817368979342305, -0.933270023073737, -0.648962169580861, -0.9074366479829, 
-0.876030172020438, -0.507785302178054, -0.702594584048455, -0.911171042674973, 
-0.700099461105187, -0.875314932991151, -0.826087497023802, -0.94494312338016, 
-0.819446551208319, -0.733115944174202, -0.78028860040306, -0.87942385654701, 
-0.742955262008671, -0.852169931919285, -0.91330728236642, -0.868186569766716, 
-0.920670366296724, -0.803841892115536, -0.945926460314396, -0.940965837196261, 
-0.541453911806459, -0.874717016864424, -0.746518563897431, -0.921677899097727, 
-0.96030288930331, -0.95365284840333, -0.635683509762851, -0.81392191502849, 
-0.841306657567819, -0.983488810252354, -0.878386961465431, -0.888018407308415, 
-0.671842685527818, -0.907126715897708, -0.75353370596323, -0.95927118129671, 
-0.863074712106056, -0.684500818455939, -0.881603175967123, -0.925541623520868, 
-0.825032516666814, -0.751230507522621, -0.993896657128218, -0.76158902308561, 
-0.969485983069844, -0.917600748728234, -0.858239882244308, -0.751495967997199, 
-0.55709120500676, -0.84163989411125, -0.702870672790224, -0.866606221639935, 
-0.719362297583987, -0.9001670964988, -0.832417725337248, -0.848089012137314, 
-0.8613004460264, -0.836854823818774, -0.853779321759764, -0.816353037433287, 
-0.781174211410409, -0.959638143416023, -0.862019400836608, -0.591393602219732, 
-0.72762711287195, -0.741995755262443, -0.759726363057869, -0.907637092332731, 
-0.472084505656919, -0.845718006435966, -0.402710933537843, -0.774487502580565, 
-0.9019769374904, -0.927371420938567, -0.753863964298817, -0.761541975758507, 
-0.743444024495492, -0.903593378458764, -0.879050416614609, -0.784333547364131, 
-0.669967819745659, -0.855745196722874, -0.737496925648247, -0.665845505000157, 
-0.8694839093354, -0.952448930832376, -0.801213894585966, -0.896763605179465, 
-0.9149339291926, -0.890306660286331, -0.965298571911176, -0.735069335814586, 
-0.712640943692089, -0.72142224915929, -0.759307116298614, -0.665645362675169, 
-0.882318841703365, -0.548216171297223, -0.798651671108999, -0.754734772683838, 
0.539092939610322, -0.980166428736427, -0.985737225645483, -0.892702986252064, 
-0.572924741780352, -0.819530348532786, -0.623263871562244, -0.761028410146709, 
-0.954003885504319, -0.767513896315793, -0.819393380954328, -0.974851234976142, 
-0.473053826306259, -0.656589492017675, -0.606263418754627, -0.774786253254871, 
-0.797651840733526, -0.910877345466939, -0.924840327403855, -0.52154131784863, 
-0.867525124341955, -0.912930552012331, -0.583899291276495, -0.91168013301836, 
-0.834482388916556, -0.894590409690527, -0.778834869929433, -0.609130838866121, 
-0.963488333942354, -0.883617126418177, -0.908529030882438, -0.819424358495861, 
-0.477728257599064, -0.692275435096467, -0.179521731320402, -0.800807971042346, 
-0.859536959989178, -0.784546640577366, -0.80409571006206, -0.496113167765871, 
-0.850240806910801, -0.923445560065655, -0.509979976522986, -0.736131226897262, 
-0.782682990146145, -0.914974943626771, -0.670281052173703, -0.648585456569457, 
-0.831265596715461, -0.842228941975618, -0.979238279505016, -0.571267082978669, 
-0.84388503846914, -0.973236023359347, -0.843744816090885, -0.925959808950988, 
-0.987991462888326, -0.610597057948729, -0.884897985694495, -0.924972802120506, 
-0.691900890433858, -0.586529177502146, -0.965139655981588, -0.755011072919005, 
-0.836888369209108, -0.0439313872310525, -0.707099461359723, 
-0.864447953623749, -0.755363542353071, -0.916896349457407, -0.73999020845463, 
-0.78145526138848, -0.80780437356821, -0.82344669299768, -0.802881612579676, 
-0.702056085828631, -0.918778012736527, -0.843464526871066, -0.86250972472478, 
-0.817398794991337, -0.534910094532363, -0.619839919043356, -0.374033872219004, 
-0.952227836873693, -0.67531594204991, -0.804856346147822, -0.941677790926321, 
-0.456190072050231, 0.6572937906695, -0.864566773467324, -0.624756162033243, 
-0.562366185083178, -0.695785560961623, -0.81250280333885, -0.870606681265066, 
-0.865833335431988, -0.79896632432231, -0.898596415215556, -0.544575396194762, 
-0.409180626390445, -0.798628690922748, -0.758456731566891, -0.936183652326445, 
-0.834812502870273, -0.96283636930950, -0.95396627872896, -0.625307635308412, 
-0.266028660165196, -0.852939849049768, -0.726168039567861, -0.792473294976054, 
-0.620452794815509, -0.94741878708782, -0.787585387708783, -0.9284792104575, 
-0.98002868602753, -0.757373871069991, -0.932304713883638, -0.899217233282333, 
-0.737805590390734, -0.965818767974998, -0.686427980028556, -0.916242097776402, 
-0.800739666673142, -0.84131114989089, -0.87012948706194, -0.759543752249975, 
-0.892405100490902, -0.84785094201706, -0.937474151291439, -0.647650670713889, 
-0.90652150667669, -0.624628307909629, -0.777846190334535, -0.813583252187856, 
-0.847517346758865, -0.537234184399511, -0.500348524052079, -0.90534089664129, 
-0.638447784188324, -0.647282304890343, -0.716053438225186, -0.604591150677935, 
-0.36896194001065, -0.651087203842362, -0.422348364172994, -0.937239626514343, 
-0.69909335836389, -0.717921233228447, -0.738492999233038, -0.939319006214018, 
-0.813483535833392, -0.813329135991198, -0.718426277344717, -0.872427344556484, 
-0.721206853338893, -0.574483763660343, -0.481075100762688, -0.724143257507425, 
-0.947407895375421, -0.966611630437222, -0.764210973059261, -0.668914326051218, 
-0.880782828780416, -0.91258950331696, -0.861350171853723, 0.15143299834235, 
-0.615163066183887, -0.696213724571032, -0.982910738463871, -0.584798273806091, 
-0.9063450613761, -0.662013618376815, -0.830090805946409, -0.830758926913628, 
-0.842399998604104, -0.842974368870169, -0.85973855467517, -0.657738112586317, 
-0.74573458251395, -0.832143475326159, -0.704983624929964, -0.865854448741497, 
-0.711765008743637, -0.539793649761753, -0.669061763583544, -0.892353435738528, 
-0.885624725077639, -0.733733963010129, -0.914361772078506, -0.40303747051148, 
-0.881778499716933, -0.84965449496459, -0.822446811446585, -0.85233823757377, 
-0.794648578204097, -0.567650420944261, -0.971509153173931, -0.487460965392732, 
-0.866436335282264, -0.288310004012358, -0.874801077380607, -0.712296083258775, 
-0.86379412370991, -0.881404939307863, -0.955871740125044, -0.976681640387929, 
-0.79206712174818, -0.73533546466614, -0.956020137267508, -0.46965748940913, 
-0.943038556076851, -0.743033298962618, -0.833580832848937, -0.892472638751502, 
-0.831162229944944, -0.558728494701113, -0.836800197053086, -0.421181525981698, 
-0.927147660822197, -0.664514975145408, -0.932725076290107, -0.821163161017432, 
-0.8870778986155, -0.616887890749054, -0.61881207880087, -0.59953057051182, 
-0.809765824890233, -0.82539872691767, -0.627361655240739, -0.642792431872244, 
-0.896304367675351, -0.337089984320603, -0.52207782083948, -0.944995893458037, 
-0.70504209186228, -0.476665031749794, -0.819719933308869, -0.530228485884353, 
-0.938995643360962, -0.416371871777771, -0.77379566137441, -0.33012151263987, 
-0.90131142762711, -0.961425798486226, -0.900654175725185, -0.97520231562783, 
-0.801946623380833, -0.587827433213164, -0.537642449387551, -0.0623579618410383, 
-0.834916766996821, -0.992474353930111, -0.87542424633031, -0.922821546544043, 
-0.741428514693467, -0.75387876815442, -0.774309070457991, -0.705439487438564, 
-0.925156993648104, -0.80905717343627, -0.795541355871562, -0.75838275989687, 
-0.982490666563213, -0.663946773382624, -0.649656472916575, -0.656954553099313, 
-0.752950930050888, -0.698611218786659, -0.885837960733435, -0.689811303765002, 
-0.773539524605608, -0.983113897166533, -0.939968846898557, -0.567520080763019, 
-0.644939272046955, -0.770113332620038, -0.678331298904983, -0.880817125761454, 
-0.797700400031998, -0.887929915356336, -0.906688309652384, -0.979705637769264, 
-0.96142198985264, -0.930771377455496, -0.86650082004067, -0.923935001718933, 
-0.581675577074914, -0.907175081308788, -0.863692418377014, -0.727281089603726, 
-0.745594578362327, -0.488128900684347, -0.69375468134424, -0.7284109470856, 
-0.810495622417213, -0.357771454108109, -0.8231157217169, -0.886028242608115, 
-0.983503469654747, -0.417074871498509, -0.747501426728562, -0.840626395294783, 
-0.72742853046679, -0.85006502354789, -0.824046171447847, -0.818478224964709, 
-0.571375410894425, -0.608879230766626, -0.498958383108702, -0.721854659783825, 
-0.873485927401983, -0.85941558807833, -0.72672422201678, -0.733572049662384, 
-0.800272458226814, -0.586944706879682, -0.62623039725732, -0.802606498878984, 
-0.664426251609568, -0.51177986438496, -0.783471917457173, -0.722666080576935, 
-0.580907936243072, -0.880378486314573, -0.86652777048807, -0.223760806852802, 
-0.877610615136589, -0.752593139382167, -0.926150415208952, -0.656144174577624, 
-0.588263770391406, -0.817283488398084, -0.902655328742984, -0.94242087737721, 
-0.945929080023814, -0.616124774086941, -0.786652934157421, -0.733148801241235, 
-0.72227541894853, -0.964313253370601, -0.78867257749594, -0.78464287568973, 
-0.85438950046743, -0.854810607233001, -0.819794709517176, -0.888203421104449, 
-0.443109104339883, -0.949743255338705, -0.815885384311048, -0.548563422024135, 
-0.871807220593613, -0.79310541884167, -0.79850865424142, -0.595869841686515, 
-0.551682107808324, -0.872547622665436, -0.843036580847632, -0.80291733190495, 
-0.768963398003496, -0.210617697271525, -0.598721958359703, -0.983466988576236, 
-0.693225063619488, -0.834268740731294, -0.877886839683556, -0.851425099835439, 
-0.758381309727355, -0.711872590342892, -0.522935046141763, -0.457082363303804, 
-0.811842720709633, -0.786607591176831, -0.914911421503076, -0.65089004682116, 
-0.953536673729912, -0.767139441126878, -0.753266636465785, -0.922474645572918, 
-0.83853149218414, -0.81169921644943, -0.783655426279256, -0.788800283900988, 
-0.80622533303675, -0.681078686942041, -0.714752393366004, -0.590319910492164, 
-0.915259756447519, -0.932520973931224, -0.773782144694447, -0.776633128029, 
-0.816869715657951, -0.885405474125648, -0.813276644566509, -0.936171043262118, 
-0.117073987269940, -0.700444268316183, -0.89752970060633, -0.252771318691137, 
-0.970904838881717, -0.763870222496417, -0.887412137566188, -0.905835865382371, 
-0.765561668542388, -0.899410142173213, -0.818366814938274, -0.632745135527202, 
-0.906018439420212, -0.89490254425498, -0.714820249446421, -0.925925365264142, 
0.160226438626992, -0.646718791859453, -0.881191543329287, -0.596633682110805, 
-0.725695719110965, -0.77400353760088, -0.747626015846246, -0.839164971679568, 
-0.717149458095134, -0.683675855853278, -0.734517880080834, -0.424581080099373, 
-0.820198315249136, -0.831442795063332, -0.986594966724035, -0.824118587358911, 
-0.965311998007376, -0.907327697381934, -0.474366929465699, -0.844841523367777, 
-0.378493463524877, -0.805429060018709, -0.906882890588068, -0.89325762231822, 
-0.791707157752427, -0.42050854314278, -0.83973664065629, -0.556379044604911, 
-0.444133405298420, -0.678341010361594, -0.877849232769087, -0.444390967097416, 
-0.613844329681167, -0.640965321086956, -0.537296467825597, -0.899782141781267, 
-0.832316302938794, -0.525592628098773, -0.79433354105878, -0.359566755934005, 
-0.268253079063018, -0.732630653335766, -0.917602257784472, -0.725674506086252, 
-0.564906133543223, -0.6092507639853, -0.99048139576234, -0.905435429348773, 
-0.77430273683387, -0.764601194772692, -0.673392712506861, -0.617973624692335, 
-0.519371041048923, -0.822596796020862, -0.764301723572816, -0.808390864400874, 
-0.85622047840548, -0.805753229486244, -0.738250725264944, -0.683643498682109, 
-0.854490923530344, -0.843465865803843, -0.77391238541527, -0.780844245368962, 
-0.606915563748657, -0.983986835195784, -0.95180555775488, -0.723074524586632, 
-0.754374475083765, -0.947471046454992, -0.671443648106242, -0.916915717507786, 
-0.790859444219627, -0.431638853735315, -0.938678922844273, -0.764169051626719, 
-0.822042484572206, -0.794598622968085, -0.937661842151735, -0.906086402725666, 
-0.802434942841372, -0.795712736485996, -0.920968776269694, -0.622200807854878, 
-0.531912674774558, -0.9302946710254, -0.882733491672623, -0.864437687853448, 
-0.926788540141058, -0.891012579712994, -0.786728923838912, -0.77064462166777, 
-0.350272844142769, -0.356365216163107, -0.8286819480461, -0.471261516915383, 
-0.748532183004583, -0.88351954122245, -0.66874240846573, -0.943244077093778, 
-0.833511320074038, -0.511861889532782, -0.722429439952129, -0.824168944119169, 
-0.635352764778274, -0.663135959523698, -0.902717752608746, -0.890892995663834, 
-0.665588217624332, -0.826633085224308, -0.649013417348297, -0.912029944738933, 
-0.90016399390358, -0.855352711403676, -0.726488047478248, -0.742566183649889, 
-0.909848859442517, -0.872410971153413, -0.454984533612386, -0.902792973304126, 
-0.953943117408319, -0.754598171156038, -0.873699666798787, -0.909549950828874, 
-0.818226595747753, -0.787755228571147, -0.826599215275849, -0.790642632581177, 
-0.727449503452997, -0.910056882076237, -0.983312289274144, -0.905158803927883, 
-0.924632138387755, -0.719239375201068, -0.855676516173319, -0.866359715880434, 
-0.977435235985559, -0.642123248553803, -0.900829971864042, -0.711239141068824, 
-0.383493341331226, -0.381179248238838, -0.98161728792966, -0.306469732998602, 
-0.805363586687729, -0.86512151628419, -0.794085755021584, -0.850049955894495, 
-0.964694292409658, -0.805641075214988, -0.963315085537482, -0.839179678934518, 
-0.84425985059885, -0.8623079319174, -0.94493678559776, -0.792810249954507, 
-0.931988458461075, -0.97033280092095, -0.932559607557764, -0.483400688165801, 
-0.839869520513115, -0.95379035016535, -0.866944728155316, -0.803453203462011, 
-0.355130015797312, -0.330202462306241, -0.857456264502379, -0.803503982704217, 
-0.765517501735517, -0.694710837957916, -0.136379484015320, -0.922256820578752, 
-0.714419539878162, -0.77738707850388, -0.942131369627042, -0.922971680173816, 
-0.930898518652002, -0.893343043476234, -0.0844026091224884, 
-0.977338128810678, -0.919689330738207, -0.869706552023544, -0.649090541562514, 
-0.789416771764552, -0.372051533037797, -0.87212968470175, -0.136269610175660, 
-0.945835872528256, -0.712243903617133, -0.468173551540015, -0.945125653743163, 
-0.983984362594608, -0.93095775002885, -0.509134165892055, -0.891168661524191, 
-0.666615852825697, -0.661223406488425, -0.755315664492923, -0.864100229544587, 
-0.478241723868276, -0.9157380595263, -0.419808069080169, -0.94383395540507, 
-0.642404302315844, -0.767946048885453, -0.812127815862052, -0.918527782235852, 
-0.969255019297226, -0.91873550970802, -0.812407499623665, -0.85775468655608, 
-0.874612040919146, -0.643083835113203, -0.80434228539859, -0.67673023281608, 
-0.59430457768092, -0.918264127449194, -0.78714097518737, -0.902710112764896, 
-0.524133814455113, -0.783134012480277, -0.471935878825652, -0.212865800188888, 
-0.627934698254313, -0.646512234357991, -0.625295244104158, -0.698786678989202, 
-0.797204093523805, -0.424992700804322, -0.831387724690557, -0.672962660564389, 
-0.862721766256028, -0.714621373298751, -0.609208531216918, -0.626973794753086, 
-0.797074182068595, -0.497427302496658, -0.503074491709559, -0.768623794113158, 
-0.622592773969876, -0.842912570423697, -0.832302691562247, -0.646671281020052, 
-0.793246603127015, -0.905069591998343, -0.767369322557513, -0.874636766047793, 
-0.784338607328355, -0.592819905147653, -0.826423664276736, -0.908471438054707, 
-0.797772881584954, -0.0987483606402297, -0.939356659317574, 
-0.677710524529216, -0.887049037668776, -0.711500664231306, -0.953356984734813, 
-0.805153500231899, -0.829091349583737, -0.774963498782752, -0.53485879191812, 
-0.620184581332209, -0.915960624991586, -0.561275350660065, -0.95025720415218, 
-0.853463585962213, -0.812344465955583, -0.807224467459659, -0.932445625656745, 
-0.986321758669341, -0.68690803222563, -0.781311097989247, -0.775276645172611, 
-0.651840135008913, -0.83285881954558, -0.875103538472318, -0.918361895918097, 
-0.819669279278631, -0.982132143720444, -0.596275003811207, -0.533623562022722, 
-0.816673966468954, -0.600722251469108, -0.917520839507038, -0.837258332698005, 
-0.761553775838234, -0.83986170774899, -0.569069486637847, -0.94368499126438, 
-0.637270747744677, -0.82426999691126, -0.56860902164837, -0.672689729732853, 
-0.885240057107817, -0.76953184917528, -0.53995281435544, -0.753317730438788, 
-0.855205946341081, -0.865842826894764, -0.371970207197216, -0.911022670898251, 
-0.69088283992886, -0.832053933533272, -0.874558274777562, -0.836978267117168, 
-0.643638114709958, -0.727612800471768, -0.949125079974596, -0.752356160901396, 
-0.978576617460949, -0.43639584748266, -0.76725332106407, -0.953049845827573, 
-0.626071998825943, -0.909948551819783, -0.662978197318196, -0.841342645470006, 
-0.524899927068877, -0.663439922066639, -0.384779463094857, -0.545266517284394, 
-0.894771712531598, -0.616358429440773, -0.819927837981024, -0.9036713431848, 
-0.935262283039258, -0.52240127312821, -0.905933555199665, -0.636314783128445, 
-0.964143534682644, -0.894006453066329, -0.687435353659047, -0.705332625755803, 
-0.554470231125042, -0.801067605833832, -0.90788691798815, -0.934815668180524, 
-0.867412614117121, 0.158428253246697, -0.494016656090136, -0.964106828795106, 
-0.857086580693192, -0.376535747015008, -0.831934423975195, -0.984180510360833, 
-0.881773331541235, -0.372070437936258, -0.915470910261243, -0.53922060940288, 
-0.736737363105012, -0.85735517425061, -0.914906142033823, -0.719906465546837, 
-0.897452049750625, -0.762557955973625, -0.80495990672605, -0.92670995029293, 
-0.727442515656193, -0.64416512409286, -0.630630045182574, -0.770184620312306, 
-0.950545694633696, -0.815828874833564, -0.92806507138563, -0.969032227420676, 
-0.907128983165532, -0.938280590094177, -0.815897082970666, -0.881743127311234, 
-0.840618204910859, -0.568375251335609, -0.863713227266206, -0.76148788558242, 
-0.579726315821941, -0.811936610607016, -0.914680970876205, -0.784522204320994, 
-0.539413506510189, -0.847064872274684, -0.709976239880475, -0.702066172949372, 
-0.88468710806239, -0.9171738810906, -0.93587147932615, -0.89494876911425, 
-0.85732534852105, -0.65410854564997, -0.774645084696279, -0.642724437296206, 
-0.761683938445967, -0.70982911163057, -0.97242935135875, -0.907486826250085, 
-0.765678538511738, -0.730713545717227, -0.915064865090029, -0.196050557487188, 
-0.888432356961595, -0.344798753378775, -0.725789505805936, -0.921949404449744, 
-0.788375493087977, -0.743307464275071, -0.74836013202964, -0.537166782032423, 
-0.97463834840143, -0.803266766659476, -0.702659282666071, -0.950053982966874, 
-0.827802112934097, -0.897755929902886, -0.643726585939315, -0.988334416464758, 
-0.81790155605106, -0.937110019813444, -0.598236326627156, -0.741873646425911, 
-0.704628121599203, -0.747511723604113, -0.883509199276745, -0.699270070838202, 
-0.91819809651748, -0.625337604987293, -0.97127980474472, -0.633572203040869, 
-0.822826880341615, -0.884020666750969, -0.62607628530383, -0.907876320216347, 
-0.704786899915056, -0.865748745935088, -0.199669559723825, -0.788681137244592, 
-0.75719849482744, -0.911911385278928, -0.788702762445792, -0.445043213426191, 
-0.775910861617947, -0.284703216457963, -0.654011647414293, -0.737876287084253, 
-0.819308219670315, -0.650265834337947, -0.896258765232968, -0.892100621473004, 
-0.937142748281476, -0.778177576843676, -0.946422490223272, -0.732805565095445, 
-0.65338715644426, -0.893974806292659, -0.461100366051078, -0.720993712382645, 
-0.579348850031964, -0.949792959560667, -0.793668918313342, -0.65276574176012, 
-0.96540806464807, -0.768464203247752, -0.8738034030697, -0.408931377943087, 
-0.848397545577775, -0.853894454533155, -0.662027039240761, -0.887127851706393, 
-0.911643324886456, -0.791348991343893, -0.699811299213819, -0.703302644180503, 
-0.638083369650158, -0.745518887682748, -0.735531320437536, -0.568135654963273, 
-0.9860920007648, -0.542832417362608, -0.669793369533715, -0.934911089097602, 
-0.80116192097925, -0.895364102360097, -0.359674491178710, -0.689754407434056, 
-0.737170740073444, -0.250010359805331, -0.781155701093736, -0.75493510285781, 
-0.590220465759624, -0.811743828203964, -0.56671810697839, -0.709833321559464, 
-0.805327327532458, -0.498589732908057, -0.907791027510444, -0.852502887560878, 
-0.958513063294935, -0.310998996625317, -0.90365250541977, -0.71476482464294, 
-0.954394026331, -0.834502416514583, -0.981325072153523, -0.940888268866262, 
-0.837705591581434, -0.732348450545817, -0.681549653828365, -0.734395366855429, 
-0.748305980575464, -0.70628834016314, -0.909100250619947, -0.859150593124996, 
-0.93009704222133, -0.787251462647283, -0.89783888059574, -0.184167861791750, 
-0.455464543978504, -0.51291486624116, -0.7581877592604, -0.623192520824333, 
-0.916096135124756, -0.893279393935037, -0.534347384403982, -0.7787112944657, 
-0.819285871290448, -0.896346890331116, -0.68270349303626, -0.837220471666822, 
-0.657848143440101, -0.909306939249513, -0.793426218008529, -0.793270720111376, 
-0.833289866848256, -0.82893721666106, -0.411421525846542, -0.73388946817378, 
-0.78891654379283, -0.7374368360284, -0.738781706536526, -0.492038260636668, 
-0.367287279805721, -0.686189488991157, -0.393654348299998, -0.728947106106844, 
-0.84390572015203, -0.861960791004902, -0.748622211860155, -0.787015595733494, 
-0.664310797710206, -0.886747289593459, -0.0999116677584854, 
-0.871239944681616, -0.827987091671181, -0.938238983546237, -0.766877806897547, 
-0.870004853906881, -0.595498873610893, -0.572399210003507, -0.810482134546032, 
-0.692859949632844, -0.611470040681444, -0.365072424290265, -0.768855826448518, 
-0.460601472389398, -0.84878582403782, -0.624976285889098, 0.71794190274443, 
-0.147192609467541, -0.433272841207143, -0.677188095809607, -0.144257149679035, 
-0.883846615188958, -0.436893107644327, 0.0785537270107476, -0.342712752786763, 
-0.546106885534765, -0.583282061708924, -0.29459070481394, -0.638947822746882, 
-0.584205446619653, -0.0459919848325001, -0.495278144940112, 
-0.0370127844412026, -0.469819049368206, -0.360511115149821, 
0.154595777078338, -0.869755555084887, -0.756691609800305, -0.807777132552842, 
-0.786619428597217, -0.228796247014531, -0.201002419430135, -0.442842344947951, 
-0.580966594474766, -0.702195056043751, 0.42485478168452, -0.242447593371496, 
0.0691126624122462, -0.232085702816145, -0.429588656035715, -0.239322594029537, 
-0.768290298659099, -0.669565928087888, 0.157272289492945, -0.51243659176484, 
-0.528946104097123, -0.60907024399652, -0.352981127876228, -0.361914637133992, 
-0.826889669132097, -0.56670795936461, -0.590973027132094, -0.546851094856699, 
-0.396588697871852, -0.851064436878993, -0.7166206179296, 0.0319930302064521, 
-0.561703599120058, -0.0374269827951178, -0.541053437746579, 
-0.870335657136063, -0.621376232693956, -0.731063776814604, 0.0268458083313319, 
-0.112703611451298, -0.258838879907933, -0.38703113197256, -0.859418029267744, 
-0.460671087670533, -0.512175741346181, -0.395551570571552, -0.901431407744651, 
-0.134092328894708, -0.374815816902618, -0.602657620223033, -0.38662021612496, 
-0.70312584647909, -0.483446449477857, -0.780310590470062, -0.246066667005289, 
-0.594439386900367, -0.64242244314762, -0.907028277947485, -0.590398453276879, 
-0.603875233306367, -0.378889716093259, -0.370042180171407, -0.708589107030908, 
-0.5669671779196, -0.529607022780151, -0.460953095628379, -0.752740366132302, 
-0.69186717205538, -0.298971824968417, -0.611580853426423, -0.873238488809694, 
-0.80798389033824, -0.5295078158491, -0.755676144058994, -0.518765693383876, 
-0.155132476137231, -0.543356092872729, -0.179371524726423, -0.451566648735143, 
-0.339503862993917, -0.125434238138197, -0.153360472102154, -0.15010937561998, 
0.00888028599074141, -0.570067518533086, -0.420414006346963, 
-0.124369521028389, -0.0865600371588915, -0.347550443989801, 
-0.395855520398485, -0.500014010836016, 0.0582768232030025, 0.149837530427867, 
-0.675304207677357, -0.487561672356065, -0.366716896177250, -0.444489730318610, 
-0.465804038699324, -0.965908175719516, -0.60534293644915, -0.370919713300762, 
-0.596299612047538, 0.0823881326353681, -0.432696220199202, -0.0432913432984695, 
-0.210590263624145, -0.564477157930283, -0.276177964192674, -0.576843661092167, 
-0.42583820553761, -0.75303926444749, -0.0152720827652241, -0.592972092571644, 
-0.416518493813765, -0.582471195389891, -0.633653255591485, -0.703963121142573, 
-0.940088436134824, -0.483092537985855, -0.608205129208365, -0.536785812314801, 
-0.58810618362148, -0.855135188153922, -0.178761274299532, -0.179272153082043, 
-0.891748671753053, -0.603020121105549, 0.198160588903706, -0.675087630234993, 
-0.346108655500092, -0.746501801934398, -0.389575444662569, -0.621810283144533, 
-0.516578590053004, -0.645240339064848, -0.210237591546296, -0.6702670089432, 
-0.574384962956336, -0.668153900997199, -0.561552327948667, -0.713945593544657, 
-0.881938927118395, -0.337371833623468, -0.626028725362585, -0.592141584102958, 
-0.310686174173285, -0.52560675786158, -0.618524195582028, 0.484984088512773, 
0.317890997110671, -0.665598486642246, -0.717688655089996, -0.31954789780258, 
-0.309023447955936, -0.160281392148435, -0.529704372775214, -0.484049358272973, 
-0.527220502359686, 0.0292028792598666, 0.145614005592041, 0.310319457312625, 
0.281530335837067, -0.683745500342817, -0.614748186871044, -0.363229185134094, 
-0.76543816046466, -0.414112324541563, -0.522645476082849, -0.634476872832553, 
-0.874061629590403, -0.828146434484446, -0.358568606129199, -0.80995066840702, 
-0.799767716391205, -0.92509797239347, -0.75621605394088, -0.751256174002143, 
0.130977070292961, -0.695928593179445, -0.579406529881671, -0.590846842320197, 
-0.778499899484632, -0.877540456030457, -0.491113603036798, -0.52027095787109, 
-0.477355095282596, -0.417779638215833, -0.324296236611311, -0.354607377176734, 
-0.536563367966783, -0.27085600787283, -0.484819714602519, -0.409861736715447, 
-0.943405921558235, -0.753859298510009, -0.83529096465676, -0.581288193508299, 
-0.707948319399527, -0.922027111260626, -0.800697540090752, -0.0391741320399628, 
-0.568633608622456, -0.37375600318701, -0.491910350488691, -0.257600522613997, 
-0.263480692878242, -0.0684231779854069, -0.964111565119533, 
-0.451297364590818, -0.695729850915, -0.606197127775925, -0.695717954562511, 
-0.230240260928058, -0.584225675248491, -0.734262088907669, -0.518144708756575, 
-0.384428616169698, -0.614603622780277, -0.76257441413892, -0.521392785181917, 
-0.754309734474205, -0.167564185391987, 0.183341843707287, -0.00522160541864237, 
-0.0893936583486985, -0.735352880415542, -0.406417734779264, 
-0.534748314670963, -0.886437766037954, -0.847330682115994, -0.650446686728939, 
-0.466452709955393, -0.318155721175228, -0.46227336380572, -0.530711310348617, 
-0.936343844130776, -0.446181326580925, -0.713618447715856, -0.554947580585774, 
-0.238238113998817, -0.580630337711005, -0.334935909571885, -0.571543061774079, 
-0.589689085089626, -0.476534828555507, -0.504494323643813, -0.605797202778729, 
-0.572097575530867, -0.38738727045205, -0.605692261997452, -0.586306472754875, 
-0.470201743883168, -0.203651158630859, -0.795187562192772, -0.764451693637451, 
-0.107980233065328, -0.641292800690578, -0.813747302304998, -0.53307431294512, 
-0.413492988075495, -0.3570540140466, -0.558443884708029, -0.786194513953484, 
-0.681580797957865, -0.443210683693652, -0.243023574197597, -0.540359616426487, 
-0.00526845254701813, 0.361038959715257, -0.132553012359911, 
-0.668305198632077, -0.379649736925689, -0.520817041986551, -0.476580119841613, 
-0.57898226671669, -0.621313654553564, -0.529371457770286, -0.600165455945589, 
-0.391305035590115, -0.650450632185578, -0.494943639455589, -0.333929119909184, 
-0.132527168291071, -0.278430965660632, -0.700467243351372, -0.504772185434726, 
-0.292836992905575, -0.651738983601924, -0.280023320444211, -0.428979688978218, 
-0.637400408615363, -0.258592232905232, -0.215658093613028, -0.28191096041108, 
-0.379272673886195, -0.633352235312482, -0.692665587023565, -0.404887415178653, 
-0.630098290846737, -0.654029177497206, 0.307158579694681, 0.087404097020726, 
-0.843039135859737, -0.747802901127177, -0.664117267646563, -0.0584700388290408, 
-0.595564513907378, -0.283574942035307, -0.111311747943295, -0.759225362169597, 
-0.86036663221036, -0.437164494019734, -0.543900918014176, -0.332102783391904, 
-0.370264280687655, -0.39932639449078, 0.169847107251925, -0.123056710710765, 
0.0380005251378891, -0.61135949534024, -0.578590636463322, -0.694416316608172, 
-0.618972381722196, -0.348055693077959, 0.315420640211072, 0.240552688372899, 
-0.782024697574041, -0.124615446830121, -0.359954357234745, -0.471379014068632, 
-0.574713395867724, -0.829032124888373, -0.334302878893202, -0.854076258134317, 
-0.440716800645756, -0.805546975378487, -0.965126194375115, -0.156638368184056, 
-0.390135686381233, -0.808372465362345, -0.760789942713137, -0.63588518499372, 
-0.633615416810607, -0.445431245892372, -0.316558635188886, -0.650464527630932, 
-0.332515077597826, -0.612446116729824, -0.776023428515021, -0.249039798476644, 
-0.564191576729770, -0.489169332879706, -0.437388296786267, -0.672872005277905, 
-0.584794742011434, -0.658096314961174, -0.361088726404179, -0.674721868781784, 
-0.228993876003389, -0.709069641515645, -0.388870134118716, -0.733025223478234, 
-0.478371292222964, -0.294666850687723, -0.24989786026502, -0.71053723697937, 
-0.0779699585574284, -0.65696155960152, -0.456815457721273, -0.364488841695002, 
-0.613575632721514, -0.559781782674212, -0.839158464654635, -0.876185216589593, 
-0.0585591635605362, -0.499850879421331, -0.389113228041315, 
-0.263936993321611, -0.667756011983453, -0.580701973496552, -0.746436048625995, 
-0.169159894348904, -0.590284811933356, -0.540484468287779, 0.0305579969642755, 
-0.214041771050684, -0.591495226827929, -0.722292854488671, -0.303923783814281, 
-0.178577910053056, -0.781374603261101, -0.675915872270771, -0.391405033323166, 
-0.664336480179056, -0.97872878804897, -0.664592450014046, -0.473914914192176, 
-0.40190350387358, -0.513843961162574, -0.380476832385821, -0.371272950559233, 
-0.461761350412265, -0.687693092545627, -0.663802322683189, -0.737250942889055, 
-0.474536074296431, -0.226418554999391, -0.838098651185483, -0.854825470962757, 
-0.470521385228489, -0.458652285207245, 0.385133749959544, -0.498506684913921, 
-0.441100506687872, -0.930526444028632, -0.659782150951573, -0.587366634236991, 
-0.309792833564413, 0.177134286588019, -0.229357042348561, 0.161294454257931, 
0.263183034501882, -0.786098966701016, -0.426389226309467, -0.459199948847295, 
-0.00591413761892393, -0.504328023985955, -0.639793856146879, 
-0.680407046723074, -0.487982008990424, -0.343917715913538, -0.567469072310237, 
-0.600644757763024, -0.617787996967028, -0.706087896669705, 0.405383989492158, 
-0.0397868564974018, -0.675697480127814, -0.703755972798734, 
-0.257247817188676, -0.333922330248359, -0.53404457716083, -0.499478185858831, 
-0.773541476896629, -0.575858745669019, -0.352318196570551, -0.577888894668729, 
-0.506256532549015, -0.348250546321706, -0.455963613007383, -0.630153810632923, 
-0.688704664770845, 0.577825261725891, -0.648246144129488, -0.584139199560559, 
-0.594914278090673, -0.562317847420234, -0.254518354535105, -0.813503154846197, 
-0.354937402629599, -0.135749306883871, -0.622196158057103, -0.493988860218023, 
-0.412278708638347, -0.385657063221676, -0.555945100019361, -0.301153384512881, 
-0.671040106441436, -0.604725734612247, -0.364530551749134, -0.706466479886206, 
-0.377458315098977, -0.871631261538174, -0.252699659648101, -0.483362597811353, 
-0.390657213701058, -0.673253184374722, -0.86108377556111, -0.328850876363253, 
-0.438316115469949, -0.762710241921885, -0.588802304036937, -0.876060200635583, 
-0.518109189430062, -0.674773742973295, -0.00515143426465574, 
-0.564245531913854, -0.522677996439572, -0.317460643655415, -0.455630749036485, 
-0.359024525145626, -0.909185440777443, -0.431863295686781, -0.88800651826242, 
-0.702699651321783, -0.0603318576811564, -0.616649026065483, 
0.125273787362929, -0.324115437632226, -0.829590823096193, -0.751878353749082, 
-0.535658434763314, -0.0253154698891639, -0.688196033882858, 
-0.192612436698837, 0.323144607231988, -0.438130469313799, -0.574146730208519, 
-0.357013921477496, -0.289152608894936, -0.69772803393545, -0.525779830010611, 
-0.0584540797002542, -0.186342780807286, -0.636371654768713, 
-0.763854168866348, -0.457370161401989, -0.87756748091752, -0.304736056095387, 
-0.60315962243878, -0.72585857812505, -0.148124882085635, -0.961104083004144, 
-0.754412025480935, -0.534304975892994, -0.464058765402376, -0.389451102606347, 
-0.68941820843312, -0.594161424096492, -0.741132755724862, -0.603575548823204, 
-0.0631637350330066, -0.807839970197655, -0.751488296531186, 
-0.569236794750881, -0.728193312920504, -0.535027601800021, -0.408985234048495, 
-0.652870874929196, -0.887478193091849, -0.344687990437325, -0.202240761871274, 
-0.195865033747611, -0.331085893850292, -0.122760424119913, -0.570055230239705, 
-0.16361119728899, -0.753757499376746, -0.78190527085731, -0.389218836283692, 
-0.690823079158276, 0.86934171836176, -0.473814217547471, -0.557127730826198, 
-0.392871676772005, -0.527453472094502, -0.78251545821235, -0.483239285805596, 
-0.305751542138919, 0.186558730648059, -0.125021963159209, -0.532945055958411, 
-0.403432321602879, -0.35940806058816, -0.606656991045004, 0.00299046587462989, 
-0.498465987211318, -0.444521916219024, -0.600838974711868, -0.576409860793278, 
-0.335487783616962, -0.563621533982845, -0.484472687310419, -0.408269706734499, 
-0.869495078960825, -0.516925523901059, -0.576580349807941, -0.584024463626366, 
-0.359606636295972, -0.259640968070458, -0.725879461549116, -0.447681587764413, 
-0.354097399387091, -0.713871463741614, -0.81856485444619, -0.698388753788397, 
-0.921435604302786, -0.628124617203126, 0.230983821217622, -0.54871857827132, 
-0.849702965431883, -0.373822030244064, -0.331992922042666, -0.565158690471656, 
-0.24444674346189, -0.724476354464324, -0.749859228149157, -0.46309492805266, 
-0.602956901771275, -0.332864488636425, -0.149643735309961, -0.81348280188076, 
-0.47645555661474, -0.113501412592679, -0.694262967802889, -0.708513948093907, 
-0.661829001893084, -0.532367097923108, -0.494225695300835, -0.720530762742909, 
-0.756718750834655, -0.634564219955211, -0.52549147219604, 0.0605476324080435, 
-0.349806037700299, -0.673140871174074, -0.694135594258412, -0.745222348126129, 
-0.580980160316464, -0.815673785699756, -0.343184632429493, -0.342751160910543, 
-0.427772342344139, -0.385765878341024, -0.338910412169764, -0.238948989642124, 
-0.362444020508201, -0.619387916083677, -0.428722074399346, -0.62077135189395, 
-0.227668167932491, -0.437946720976865, -0.75168258537271, -0.408518509147104, 
-0.174723039798306, 0.0690405274961772, -0.562168729964499, -0.515754997841723, 
-0.557637776816411, -0.254219506233840, 0.182085779323017, 0.152076030898513, 
-0.589357243182093, -0.468382262070722, -0.718104382785314, -0.479894535805283, 
-0.49270028266541, -0.664633845213169, -0.387940559185424, -0.627402739210927, 
-0.47059589537416, -0.410885276448962, -0.430732288019846, -0.325012501160363, 
-0.0652940340659273, -0.817512383646511, -0.737184631150223, 
0.686511235318572, -0.53805473918478, -0.300822362446027, -0.413391045515807, 
-0.615111652166884, -0.0306378427935795, -0.457453919305595, 
-0.727325656758077, -0.515939720111084, -0.764655085885056, -0.455863554911476, 
-0.255405832680248, -0.387259283808271, -0.0123576023668457, 
-0.735834049789538, -0.0404043957183003, -0.562791172391179, 
-0.416213928179136, -0.694450821943994, -0.546942405918624, -0.441450797243891, 
-0.173179069645598, -0.662652151476535, -0.0723314783219643, 
-0.489565871584091, -0.176195813920042, -0.785789070499169, -0.701699787781456, 
-0.179882229400947, -0.590766454580027, -0.511625319249706, -0.145330790197822, 
-0.415831308894016, -0.418652443886614, -0.459897856981659, -0.880769213160334, 
-0.87593813259495, -0.199721727533048, -0.0211695184272863, -0.83070467295938, 
-0.704897795906869, -0.148273448389558, -0.637458012318377, -0.632117076811544, 
-0.69945233374474, -0.428697194456506, 0.0573120407455193, -0.317217447647222, 
-0.83835682132691, -0.762679047035747, -0.760923023242045, -0.327996033341505, 
-0.345060764390611, -0.384810875053649, -0.870241601449544, -0.472034670929458, 
-0.669503158818053, -0.614390523658934, -0.231587143575488, -0.562368590596178, 
-0.505852703771951, 0.442381242355799, -0.548457707864067, -0.505160151714037, 
-0.0673449248287395, -0.32160179177212, -0.732238087527069, -0.700075461980582, 
-0.451533590051927, -0.779620493326102, -0.508952976450622, -0.462086180032941, 
-0.732361879063739, -0.354270850286036, -0.657068048635082, -0.586780389227711, 
-0.664705517876522, -0.0754117321654952, -0.031564656359101, 
-0.266674148209112, -0.175341863037027, -0.85632824991264, -0.837014734199605, 
-0.0709510457048687, -0.850897645898726, 0.442675312837006, -0.49951975882903, 
-0.304858879137962, -0.786978452794021, -0.471658056509464, -0.560593687958589, 
-0.572009832661376, 0.40513696636596, -0.383665112666678, -0.42122924439785, 
0.45274888284249, -0.332216456822397, -0.233365836119789, -0.145064540657046, 
-0.491232662332374, -0.548524494903746, -0.239352973430711, -0.373495410771429, 
-0.65483480146332, -0.336303050697953, -0.802548740078717, -0.18629104025398, 
-0.834291629320747, -0.67188573310525, -0.65044716102442, -0.861449000753264, 
0.216756556214857, -0.361595978864792, -0.781061822890435, -0.222448144735475, 
-0.718698083345315, -0.532492779082627, -0.460587445003142, -0.688831402173576, 
-0.401870383377342, -0.388470231972017, -0.95929238316533, -0.497203044934570, 
-0.495008567581430, -0.541023684531008, -0.668383158085095, -0.483126328465415, 
-0.805413045273736, -0.899063258002861, -0.463803593224497, -0.776136079824393, 
-0.73019124566371, -0.229741804295351, -0.743490720122266, -0.386232323994748, 
-0.741589992163093, -0.725052382216774, -0.916543054483706, -0.174237545829493, 
-0.514624345933989, -0.0695581746623355, -0.745696851626788, 
0.144200515716751, -0.472935395162798, -0.396746865414270, -0.58413473545467, 
0.160186146481824, -0.736118781239381, -0.776708223084386, 0.0978553907360477, 
-0.916693914852624, -0.689231544037623, -0.776541334590703, -0.46679418240368, 
-0.522363427848091, -0.513719089017392, -0.531280463303174, -0.213185925860760, 
-0.437453695430114, -0.915848068154874, -0.270277664408798, -0.300224377366379, 
-0.857810217543178, -0.616207749205244, -0.517945439156145, -0.058452853014604, 
-0.57043727388586, -0.713584982166817, -0.193187994698621, -0.614791824024898, 
-0.52827635104098, -0.233638389959169, -0.512817649553686, -0.819854138634871, 
-0.540353219964146, -0.460248285533132, -0.569289501068592, -0.33500277549002, 
-0.602749687586524, -0.294299621250212, -0.079933826176054, -0.838094396818543, 
0.0291830905984123, -0.260917957847825, -0.544958176762167, 0.380615269517473, 
-0.6792047960285, -0.645093725321626, -0.711256927047039, -0.602048070753544, 
-0.55525074738664, -0.303265586080881, -0.514424890349644, -0.554682432467836, 
-0.347348833558184, -0.212494365576205, -0.355351722518568, 0.102902955372278, 
-0.0148483409530295, -0.282689121291617, -0.327942523052167, 
-0.313976449092527, -0.00899934646514069, -0.635300271477586, 
-0.466227124680028, -0.0120205737779345, -0.618433682199002, 
-0.472710442725105, -0.602041942827868, -0.764662397880698, -0.414542273812099, 
-0.586843660412227, -0.65692404751836, -0.510776703577105, -0.589147564700028, 
-0.254602815231790, -0.680393077608321, -0.301144037744377, -0.366488624438114, 
-0.922298566399108, -0.321838769287711, -0.901085125918411, -0.568691212295968, 
-0.513275940340014, -0.51030587434243, -0.555336887358472, -0.901865127468045, 
-0.140151076018995, -0.23593480847905, -0.797630999879077, 0.259908429127728, 
-0.197770061435042, -0.495103660477134, -0.433150060131322, -0.615439743892275, 
-0.152589529583441, -0.301158748851928, -0.376201801486132, -0.534707846915265, 
-0.629080818584523, -0.662016257294938, -0.472375494172659, -0.560472544613694, 
-0.878947286118854, -0.663822204896296, -0.373566118006428, 0.0529547954588500, 
-0.214442056888067, -0.513493091336728, -0.546638718898905, -0.256642043200931, 
-0.653981607622379, -0.826911168897827, -0.329174229919367, -0.524436318593733, 
-0.753998063903623, -0.0445216661623233, -0.452372599135486, 
-0.874582588183099, -0.230789168117306, -0.451101658080429, -0.332491355371605, 
-0.838104519587494, -0.734263283792804, -0.384467973547177, -0.73071417459237, 
-0.72419384763721, 0.0322713213962192, -0.499836580504757, -0.057669012265014, 
-0.393377104010655, -0.381939915705488, -0.176007119833842, -0.687925057840982, 
0.0643931985892807, -0.348292686311566, -0.895356544421352, -0.525561645579072, 
-0.98455526469351, -0.775738470974598, -0.375698694515579, -0.677643173227271, 
-0.233574169346596, -0.550299723074037, -0.736047449626389, -0.556916992925853, 
0.339228379056474, -0.331989236149477, 0.282726089730356, -0.437914103901314, 
-0.649237670856674, -0.677027378949812, -0.832694103453842, -0.594832717774309, 
-0.696581246319781, -0.69702662870143, -0.497194294288743, -0.108067574441694, 
-0.155427461062099, -0.516318213148686, -0.653226377119882, -0.695167473976606, 
-0.774452602592372, -0.720813841307548, -0.10661772889061, -0.459503885844921, 
-0.718076108675482, -0.367874846384672, -0.72080807979539, -0.442858277823342, 
-0.851328957242953, 0.00332227811662065, -0.207869889619577, 
-0.0211162525991934, -0.957516881842539, -0.922136715065413, 
-0.496846295749976, -0.641108886765, -0.342698646934226, 0.136133605790832, 
0.421392422134215, -0.0908985178282646, -0.495717965705849, -0.119829125024983, 
-0.645499587875705, -0.0526194100665393, -0.533545704391179, 
-0.401006007284397, -0.351044868848656, -0.44791222049945, -0.0307981568562927, 
0.0167937489282709, -0.416042057004142, -0.186692100021009, -0.0770122920543322, 
-0.191164283351008, 0.154661279953121, -0.372916805541779, -0.269625586293441, 
0.447651702013425, 0.0857715192762708, 0.573348052005167, -0.655735750767531, 
0.106071000606870, -0.372797286179964, -0.545648544072284, 0.20416896625332, 
-0.069112664145159, 0.147464902843653, 0.306352226897174, -0.0261153024198400, 
0.000600745369105447, -0.506622645310711, -0.305978104155972, 
-0.111788892445381, 0.290953442505215, 0.00155206136718437, -0.150290111118422, 
-0.532030236746326, -0.392212842398897, -0.47251081503261, 0.14147301629977, 
0.440913909896792, 0.0505874309996999, -0.339081856593504, -0.1436553083128, 
-0.660838523275547, -0.459228105901396, -0.116891712660625, -0.345151550325992, 
-0.0953659267497562, 0.119721176161502, -0.527379929134688, -0.294560051926476, 
-0.513273764079927, -0.292578022237130, 0.0903018987214691, -0.0381256048879022, 
0.168072867731070, -0.615502827780091, -0.350567937466747, 0.622766478758488, 
-0.524863163054723, -0.0739624200697389, -0.209533395777027, 
-0.301553618970576, 0.339494483869511, -0.320917888138396, -0.777883053509775, 
0.908724818595507, -0.296372541288335, -0.447413437882192, -0.160031980382142, 
-0.501796742719995, -0.420930822946162, -0.0733679079352256, 
-0.609397258833049, -0.118478730495006, -0.181765347572193, -0.173316255532039, 
-0.507342361450088, -0.404031479582831, -0.279048787591812, -0.0452229975044192, 
-0.760940095165448, -0.550658782046586, -0.318635991271609, -0.664288378347369, 
0.381158472195296, -0.255173799778066, -0.228934617075068, -0.190186810666686, 
0.6526428111546, -0.208015844108673, -0.304998845546706, -0.0837680327494754, 
-0.493423727955886, -0.614038109239999, 0.237401446447377, -0.535734294907579, 
-0.777457449207737, -0.312757264837315, -0.127487870637311, -0.747043268158216, 
-0.105021174256446, -0.232527510680194, 0.147449124686365, -0.543248524651474, 
-0.237073605999055, -0.00784699591101993, -0.513776711445618, 
-0.302408624206836, -0.406356013956595, -0.331358493971032, 0.176818242306544, 
-0.0821703306323098, 0.865397453235738, 0.81414902861135, -0.131069214357483, 
0.393624916666127, -0.0983004944776118, -0.267688336954118, -0.300253094262691, 
-0.304211290625153, -0.582356933712625, -0.273786117463193, -0.395982921820073, 
0.407555218526467, 0.387432865636141, -0.269236529777391, 0.0702949432643029, 
-0.0200583114370068, -0.555564795120804, -0.329325473314645, 
-0.301306128652214, -0.517736187858933, -0.452556530368964, -0.335954100432839, 
-0.404260482696888, -0.243500340253102, 0.315139318070166, -0.0922421286809588, 
-0.0681310118203943, 0.0757523395100468, 0.820828416509362, 0.154330765516285, 
-0.356011833222005, -0.582674900031211, -0.88239144309681, -0.142494761711788, 
0.179702683469668, -0.550177417115159, -0.333311729994425, -0.144538052587536, 
-0.0948123869484959, 0.169886998155587, -0.337283635906718, 0.249622776471633, 
-0.608876543510842, -0.417817966528239, -0.170883647625480, -0.498364703736111, 
0.124764572431290, -0.182772802517658, -0.0745202126665437, -0.141464553944157, 
-0.65473449895448, -0.409935668741595, 0.473358182108316, -0.141390802207677, 
-0.170035474807891, -0.479474226686235, -0.410409954776657, -0.309557113157904, 
-0.243597184376077, -0.146908090473277, -0.628515258529112, -0.679482214440509, 
-0.146154414417293, -0.680397083927614, -0.590326559937278, -0.462220073715194, 
0.397399767632834, -0.338430488358053, -0.471501168913019, -0.452646643333174, 
-0.541853836601267, -0.517102962191037, -0.309141938235157, -0.174365791896069, 
-0.0787376776114991, -0.413914553535609, -0.127337827201961, 
-0.232958810086070, -0.0403571064378188, -0.463539664828588, 
0.0378526868309652, -0.252414524422106, -0.613623727307134, -0.386808217007297, 
-0.135546938348331, -0.173863568353860, -0.132882363000351, 0.0397990412000623, 
-0.565120733792629, -0.247337607247884, -0.0534322867462656, 
-0.125869264721021, 0.231246620482839, -0.735544329241075, 0.470476079537705, 
-0.131945832722724, -0.219496604399707, 0.810509942321132, 0.0402517684569374, 
-0.0906175025344231, -0.145846275048308, -0.272781353490253, 
-0.272479436827627, 0.0566781821278735, -0.222723324818058, -0.438267134589057, 
0.057265870996284, -0.148285531408532, -0.514729584818345, -0.402942975826942, 
0.174338532732735, 0.662118665693963, 0.0283202199898008, 0.0741891644533308, 
-0.0277857749489081, 0.127568911594645, 0.0031069860720654, 0.345221318202012, 
0.0177251283557454, -0.134609033265183, -0.671899499651988, -0.118477963045408, 
-0.260417740478247, -0.0789787656991818, -0.879656453787083, 
-0.736605843053554, -0.187486520898938, -0.382388984345448, -0.628714022464467, 
-0.193072842660221, -0.225210282189465, -0.118198473014363, 0.479778380221116, 
0.148011578564262, 0.108547231407291, -0.287002708648747, -0.137778203475575, 
0.313749419564524, -0.368434425820162, 0.00411633515271838, 0.478565366200662, 
-0.440416814639375, -0.0648745453463792, -0.319974409818244, 
0.170884172295354, -0.618005598517002, -0.248431465336703, -0.265411683554972, 
-0.315123171868101, -0.303191295815135, -0.282666166979846, -0.308124048343983, 
-0.335661248620322, 0.846128012250192, -0.204746094616793, 0.239641809390485, 
-0.353509601266430, -0.233101199526704, 0.00880676048299521, 
-0.321449287773989, -0.649318332075055, -0.837344540969674, 0.499511861686627, 
0.122726473822777, 0.408405412065251, -0.387438798247123, -0.678470332343618, 
-0.0308658138004628, -0.113765277180572, -0.139408926692776, 
0.149122660063713, -0.835352493700825, -0.262771827064505, -0.0506965184795274, 
-0.0281657533598551, 0.026133368285027, -0.143468606955062, -0.512269091791451, 
-0.101041953510606, 0.122594133163616, -0.484196142941175, -0.0994002531533143, 
-0.766976962807244, -0.290386529615448, -0.0589227804930207, 
-0.381316944205194, -0.184598027382591, -0.180338904051644, -0.319536184495841, 
-0.392684664807472, -0.116113046046321, 0.136588993433424, -0.0712727287429774, 
-0.288352367523409, 0.287540924739269, 0.202638499869261, -0.657567789648179, 
0.0121063245914062, -0.501997921758648, -0.609053225138833, 0.171478328623385, 
0.820214494096668, -0.250885992728059, -0.155208333797310, -0.0228275526995513, 
-0.3973507598939, 0.156566500474552, -0.433618166837396, 0.18195631391382, 
-0.313578573571342, -0.366463602665204, -0.552126554804075, -0.153919970429982, 
0.256946671254781, -0.69820396969471, -0.206601575844314, -0.102528566911148, 
-0.154945014216569, -0.694018218855046, -0.121599650644852, 0.288232426027427, 
-0.336685069210798, -0.132225916229682, 0.0864169318073278, -0.646642529337291, 
-0.176177403388856, -0.268946030778225, -0.193910684314254, -0.36075393484185, 
-0.00401328108697577, -0.278697987683250, 0.504486934827095, 
-0.424867579842887, -0.215431619934572, -0.732101862011244, -0.329875005033773, 
-0.71254013313015, 0.0732332715681641, -0.242840827084360, -0.0564871631425487, 
-0.236192453057169, 0.459753340001108, -0.196960170232629, 0.228681083403689, 
-0.373523218344938, -0.278374322697089, -0.582276461445513, 0.346660318101975, 
-0.205516477256262, -0.151097859160579, -0.397828080565959, -0.00708785468816654, 
-0.178144512824526, -0.369144227673625, -0.247693727300895, -0.566448257503974, 
-0.0929406493373754, 0.580352243494901, -0.688123377364521, -0.334863222788791, 
-0.230931969161062, -0.149318631217529, -0.489302553236446, 0.224705063082091, 
-0.297773924927577, -0.481934745361812, 0.140379275975893, -0.0192455991612779, 
-0.368707361122351, -0.331252188789579, -0.435271085439997, -0.389393430435067, 
-0.337814289952268, -0.171460372755514, -0.298412639439608, -0.130557547022407, 
0.386802783582448, -0.00585705147529068, -0.33185070822717, -0.796688913614133, 
0.663233751572064, -0.0985496709014788, -0.180304855109247, -0.289101237041831, 
0.298776876217183, -0.287512257437754, 0.178893690169532, 0.198636421415653, 
-0.0507577236781736, 0.225773420973137, -0.229248000742023, -0.0273407044869188, 
-0.6987607308739, -0.269102663989155, 0.0369892215244117, -0.332078867585004, 
0.260971215206842, -0.283022624446578, -0.498268848506385, -0.338149873033312, 
-0.386660713598236, -0.0391599408039448, -0.224892317723691, 
-0.51977379173542, -0.28759130374756, 0.369420968604135, -0.202049066016855, 
-0.221645654725267, 0.216932927272512, -0.0374337343298583, -0.115288531786044, 
-0.249223837905514, 0.0102919674640263, -0.40465038564891, 0.0179910687580553, 
-0.0680001300746296, -0.339716613924046, -0.366379357372102, 
-0.360361307179779, -0.352615310781218, 0.041271160906605, 0.523685237511187, 
-0.205508543533826, -0.411877227946953, -0.352823198614012, 0.206921201504607, 
-0.451727085622868, -0.8041002084472, -0.175594215951813, -0.462419777502951, 
-0.572439691543218, 0.542133930700511, -0.517619867902627, -0.487626803745272, 
0.0879166841377848, -0.420022737978373, 0.202142864260647, 0.0170840279343228, 
-0.34557666483803, -0.467462964231335, -0.328848851118042, -0.493495470103163, 
-0.600167088114537, -0.218112437169093, 0.00441885980210971, 
-0.359821633415669, -0.557038743220689, -0.494862542028817, -0.0022798153707166, 
-0.144016944574566, 0.0147357705356684, -0.668517850572689, -0.206788984955684, 
0.256013324287423, -0.251496497960547, -0.230036994684109, -0.0997854178970958, 
-0.772372161853269, 0.175731721236258, -0.150274414483390, -0.326864228779162, 
-0.0863490053765223, -0.257743704133436, -0.370442295780745, 
-0.0887550283829059, 0.391781011667578, -0.3514400279541, -0.607802217068603, 
-0.641695685453219, 0.0869269171021854, -0.449018391419367, 0.0374591841291172, 
-0.368299049376907, 0.101981183741345, 0.0531489583583015, 0.340149474490167, 
-0.626068187956862, -0.245131681321812, 0.257584062047122, -0.254559673181603, 
-0.491848229996498, 0.119427671926253, -0.388463733616111, 0.308644350739676, 
0.345584995802052, -0.80439730035419, -0.465691286820326, -0.502885948450736, 
-0.199102856263377, 0.200395988024373, 0.0197674463068111, -0.213626002996957, 
-0.403865911547457, 0.215707606394675, -0.454807045636026, -0.768906086092379, 
0.620496338344963, -0.340312872271904, 0.431886058208283, -0.309283714859260, 
-0.461527539947278, 0.077035180192478, 0.506414480522387, 0.353598934866032, 
-0.480022737851624, -0.320536234949374, -0.485630319878762, -0.0345351778306729, 
-0.801094678921606, -0.543206841194757, -0.484922166606301, -0.29155140605924, 
-0.123226175578525, -0.115233737841798, 0.266615446162424, 0.576464480539218, 
-0.28117739428562, -0.0411761657846499, 0.320326849938867, -0.166765502875488, 
0.160492435793175, -0.916379703248175, 0.112145866033195, -0.291645702183040, 
-0.530009505895449, 0.355304817229219, -0.44900875977329, -0.539560858754364, 
0.0475787802624403, -0.277469345734575, -0.331332593323151, -0.0927406199105937, 
-0.428352790868087, -0.397523314703912, -0.468747241771489, 0.194679594199192, 
-0.392893246537236, 0.199626965369725, -0.33788647839006, 0.0959911693948572, 
-0.0750543102978962, 0.0966889447357226, -0.377218664223971, 
-0.453815813026655, 0.160759319508869, -0.415843682828144, 0.64611363250455, 
-0.504972566132741, -0.158948266800641, -0.334508072469414, -0.297828464661831, 
-0.0822065959572406, 0.0252110838141038, 0.0237439654315961, 
-0.428578319761104, -0.202187862831468, -0.0488761423117148, 
-0.735804492868735, -0.178788531310121, -0.125320772051606, -0.0704091561491322, 
-0.288557332367853, -0.533910346704859, -0.412848387294456, 0.198575219072198, 
-0.601170220768327, -0.0915760719071109, 0.00609201995412697, 
-0.377614326013091, -0.169131161873434, -0.0181719725833004, 
-0.0831336069167962, -0.018753236869051, 0.214486848730693, -0.0268465963592803, 
-0.500095951947861, -0.465080665473312, 0.615321742398733, 0.322051490749341, 
-0.483243089581309, -0.388591746715391, -0.319399244988005, 0.107362663139748, 
-0.599122783695885, -0.362093523803451, 0.188328901105932, 0.0284264712608886, 
0.230873496020605, -0.0647313344815675, 0.119071666313667, -0.351237826892134, 
-0.0863238870861037, -0.191061089815265, -0.678440294918626, 
-0.411078334044366, -0.030333499462989, -0.475905111220326, -0.0379668199717095, 
-0.334639572956931, 0.105517107868093, -0.192425643011470, 0.00275118618726022, 
0.160783883298793, 0.0661007382658766, -0.342961906489398, 0.599582917088456, 
-0.258720616767420, 0.534374857244027, -0.441492557524495, 0.205931425159785, 
0.256795983408207, -0.0624644831060115, -0.362105643436616, -0.313073406041807, 
0.249510830094282, -0.411388994157242, -0.30752930371324, -0.249431253607636, 
-0.724264444595167, -0.154153152139578, 0.178278876946945, -0.179169140790754, 
-0.000931124410383326, 0.0832612063721472, 0.0611620065195105, 
0.339014105514682, -0.567774989359054, -0.184261185281034, -0.334949683951019, 
0.186154579213992, -0.379588077911745, -0.169398609925833, -0.453559201794473, 
0.330100520203438, 0.000664745701560206, -0.30023334064485, -0.207115119506198, 
0.382239003016811, -0.478882653451632, 0.0838645815318544, -0.226167532407796, 
-0.178857308842838, -0.222796207336744, -0.238813735129339, -0.727923510898253, 
-0.132347418251602, -0.580300658614877, 0.135683418766276, 0.245277457952674, 
-0.187758115360777, -0.0817176256957668, -0.667424650125628, 
-0.280227047128394, -0.0554921811064632, -0.549430176941455, 
-0.0415469334880888, -0.0704448706292332, -0.173127080411225, 
-0.0317363935871385, -0.568083243474699, -0.68694001169787, -0.110895952035702, 
-0.441376492491998, -0.606521920982835, 0.46370548632038, -0.429836410407929, 
0.0788847614572081, -0.479633295120256, -0.857018485530944, 0.0259102410685097, 
0.312478156645437, -0.595253245650558, -0.359596585004455, 0.200022562292824, 
0.423532022010082, -0.0357772522218655, -0.405595137953707, 0.317273074510402, 
-0.0874125757536495, 9.58952297646579e-05, -0.283278987598533, 
-0.292552570019017, -0.0197557121216375, 0.0830776013857474, 
0.0339760856331702, -0.63375842195238, 0.117836185845618, -0.195404434446074, 
0.3148221590063, -0.674538248519939, 0.262439046906349, -0.183759582889164, 
-0.322717963906599, -0.118780207447293, -0.307194747791509, -0.251445289573432, 
-0.506429152801933, -0.426665585319751, -0.515750799805994, -0.408020403016653, 
0.326368602201085, -0.00620427139507911, 0.444265050729095, -0.0299420889019065, 
-0.523692719043369, -0.497817723699009, 0.459056903790282, -0.416025837393038, 
-0.00261176375665040, -0.538516498215348, -0.0304323546543625, 
-0.108311886751542, 0.307282144371834, -0.167293980247819, -0.779007636511415, 
-0.158497518668375, -0.129704285988185, 0.000624034644838944, 
0.160171083875051, -0.186362471435545, -0.762734054155284, -0.383953692911214, 
0.121519885478277, -0.218425056170126, -0.322639928013051, 0.024721690366118, 
-0.0300719378630077, -0.123733399880080, -0.123103610674216, 
-0.384827994236157, -0.401526580777369, -0.221133512697379, 0.0150957359315390, 
-0.0739233134681022, 0.0741386663595445, -0.691331118656065, 
-0.00733499882667892, -0.415504108697323, -0.240160103505602, 
0.606343298812458, -0.253526158967115, -0.700898914155547, -0.188007424839450, 
-0.120818070648177, -0.482275802476606, -0.377253991446105, -0.415254235412343, 
-0.270194171651932, -0.235588492894463, -0.452281389263153, -0.0871472609027076, 
-0.378192031114751, -0.129954613478866, -0.383233959083077, -0.321928726768526, 
-0.488978626887534, -0.251329922505309, -0.0820470529657596, 
-0.259532600735775, -0.234852008801543, 0.765416410787372, -0.514609262629363, 
-0.548660595994812, -0.0265895219057247, 0.358495500311652, 0.526735170797899, 
0.0565160535119837, -0.360705735943099, -0.433034816260693, 0.341057406693518, 
-0.144619666549341, -0.144097302000150, 0.778816791404882, -0.195965837890263, 
-0.47844513153619, -0.366040787804120, -0.507839980748719, -0.296631953285222, 
-0.7605930900401, -0.265050150783582, -0.353872621650412, 0.0305294033331643, 
0.0261948045085861, -0.280027549903001, -0.364869289272692, 0.419900827923243, 
-0.139015856797027, -0.347308446337014, -0.66425638087581, -0.352516153726558, 
0.0913572131349747, -0.291861668462346, -0.82974994039908, -0.260749560512281, 
-0.678862741134031, 0.109452914135641, -0.0581322993892328, -0.199688511743625, 
-0.362154905394065, -0.132098840374503, 0.129584940272145, -0.0450728301540178, 
-0.746738217565365, -0.0628766692455414, -0.0923302848305693, 
-0.278423983946176, -0.194615067860561, -0.350778298753687, -0.0964809206234058, 
-0.70131491737492, -0.742558901677303, 0.047837459727128, -0.0585747222236091, 
0.208836319176544, -0.102804831019293, -0.393721042746463, -0.437357137953234, 
-0.426050015536142, -0.115579264878071, -0.262353000238934, -0.84030619371483, 
0.00232427711260170, 0.169531985246881, -0.124732015212599, 0.563932471239424, 
-0.550974895974244, -0.139221468668158, -0.524094513320706, -0.89583181434704, 
-0.321717741344331, -0.249800589258953, -0.260075638060076, -0.22770849235013, 
0.174476748344857, -0.389223402482239, -0.00173902455163550, 
0.276496064652364, -0.189906485660826, 0.349728447216602, 0.00141260385183897, 
-0.298470613585377, -0.72150805381632, -0.332787995085642, -0.507311441185785, 
-0.152240766470878, -0.173594889296344, 0.740536347731091, -0.6740266361952, 
-0.714249134093614, -0.290886600244699, -0.413532369004357, -0.064273851309151, 
0.0259790747496848, 0.122521198530233, -0.0360030873598881, -0.281839058377914, 
-0.0267925617595342, -0.411178549593061, -0.338341473592808, 
-0.189836718514303, -0.561085919410045, 0.23299611399063, -0.268683167617213, 
-0.394299900253877, 0.484516709231253, -0.303536052458326, -0.356018754585002, 
-0.319803617754807, 0.647431284869244, -0.400803518974427, -0.378440954233585, 
0.0583234302607132, -0.102468460192394, -0.0561201615710864, 
0.122700465539993, -0.265555990317107, 0.253856945140459, 0.144902143513389, 
-0.215050001874629, -0.260550265353817, -0.407556992112777, -0.257106860900886, 
-0.155559039754021, -0.19770772197999, -0.0278614816645877, -0.501554687504156, 
-0.170289033295344, -0.307592619836008, -0.161795922521183, -0.279932576554359, 
-0.129985949786725, 0.180147196742403, -0.661139097024535, -0.114645902293925, 
-0.0898663193687644, -0.744751311276005, 0.105052709473249, -0.161012156485027, 
-0.319763160668191, -0.527993903768363, -0.207143678524745, 0.359166045513656, 
0.779941173941638, -0.435987191654099, -0.132717159773374, -0.225426134879564, 
-0.879343186817557, 0.057675763874438, -0.0932016375578436, -0.799709492607921, 
-0.339422691557746, -0.462137407912603, -0.0915281062013232, 
-0.378140470970924, 0.0708232317611326, -0.327376342501021, 0.11801183327163, 
-0.298072973695731, -0.47559755279766, 0.110784298071812, -0.266483845824344, 
-0.370753741746744, -0.329510581259896, 0.0182277640546884, -0.206903569912488, 
0.192978205700043, -0.0156208101022488, -0.470121296543297, -0.525946615660505, 
-0.371273575887368, 0.0175550912554337, -0.0630014774638706, 
-0.407102610934351, -0.0639457588429684, -0.305908386177538, 
-0.0914748923182568, -0.162216412399897, -0.751435987454257, 
-0.0420137917376216, 0.150418131347912, -0.358985029983532, 0.0344269994609981, 
-0.578572505598712, -0.106850234275325, -0.306785938890240, 0.0108819805524122, 
-0.181206725002026, -0.582096085515194, 0.100501223055241, 0.306232670483835, 
-0.257528803792475, 0.0398881892246407, -0.238363433175663, -0.127674250447676, 
-0.421873860115631, -0.0281171819092982, -0.471694648500797, 
0.370589802193587, -0.243062557757108, 0.0129847226858738, -0.0813629029064991, 
-0.248177831552448, -0.597851691947416, -0.578871989594181, -0.0514937810294193, 
-0.480608598902867, -0.104173302241384, 0.115625305746152, -0.876781657543682, 
-0.36112408203697, -0.395879363972581, -0.208826399752313, -0.28206716876757, 
0.121450732090043, -0.29164632061807, -0.15193947418424, 0.137580352304462, 
0.116193348039424, -0.149766070705476, 0.365754228932909, -0.316127938902934, 
0.0209612841844548, -0.643931618759036, -0.0407449615943488, 
0.0271434254597787, -0.324866561709989, 0.173786637162033, 0.000394545243416503, 
0.501605972602039, 0.504727231009061, -0.0913942775888847, -0.456530754949113, 
0.198451089094272, -0.0583553146223908, -0.130430617267792, 0.606075492174689, 
-0.393438854542174, 0.0320453644252204, -0.224026779239354, 0.0656979533906309, 
-0.0301119344771327, -0.0858142308778242, -0.000246984221573591, 
0.254651231718652, 0.338998460651391, 0.345107921681061, 0.350080572061375, 
0.281006243592874, -0.300638172011378, -0.279196396551255, -0.00526893918477934, 
0.0457876773122433, 0.0553952040228952, -0.419475034358, 0.240245138155241, 
0.256789413457777, -0.0658156388803743, -0.109509408142865, -0.282376695031670, 
0.155632008163781, -0.313846900856641, 0.084955671548011, 0.531180541766201, 
0.241507442410303, -0.271330945004195, 0.121645917668582, 0.0108673628323065, 
0.188716639418221, 0.467190424461052, -0.190940260518731, 0.00600475103621705, 
-0.278057248795004, 0.167151666154648, -0.0993192383868656, 0.518055778343151, 
-0.339736652565936, -0.152363413210860, 0.210599939611818, -0.449590645117407, 
0.429621193329953, 0.0210387472095210, -0.0500305200352858, -0.181158790077736, 
-0.240713740045523, 0.0360821418185155, -0.227652738091882, 0.576807917426823, 
0.748429708838288, 0.759537045524853, -0.039946669416658, 0.0802635740924854, 
-0.305208461460090, -0.183635039472695, 0.169292225908258, -0.296342183959494, 
0.461399361352664, -0.674852626282525, -0.770192997974883, -0.114642167442849, 
0.575400714985343, 0.00125523841666977, -0.5176812956893, -0.197856263550044, 
0.378248766609076, 0.106827339674863, 0.260812210725788, 0.547099236415913, 
0.902412203729408, -0.0453714989522934, 0.524039279812289, -0.167105557939200, 
0.671093132767503, -0.0499072131025262, 0.143857507539109, -0.0847790121463287, 
-0.216379614749885, -0.0847668163954959, 0.512177114642839, 0.0332395401065377, 
0.522516959132877, 0.525862113757292, 0.233061538441849, -0.676450015769825, 
0.581160347747403, 0.0122237196766916, 0.21341382481596, -0.251072231696868, 
0.363624848408779, 0.0307689240875913, 0.131911105983475, -0.0824422543526623, 
-0.0625673724279993, -0.223771072349259, 0.433445713413062, -0.103950990962670, 
-0.101703586999408, 0.0496430594118107, 0.380388444882385, 0.276092964495206, 
0.304185356560736, -0.198284639033062, -0.0478444459505628, 0.0715536574103006, 
-0.0362031264521516, -0.0379184630456754, 0.567354903049042, 
0.059820680191604, -0.546904238161364, -0.209311440264513, -0.331438816274053, 
0.576821942500924, -0.212824329005126, -0.0505635808334173, -0.205811754498023, 
-0.0591485797253985, 0.183785376123830, 0.217298661317575, 0.686125385138308, 
0.13617542470907, 0.090512860478369, 0.0406567952009083, -0.047437651243897, 
0.552815125264652, -0.0751056667261155, 0.120912532045636, -0.187058301106085, 
0.0748908178180061, 0.0113452556588720, -0.14437688455174, -0.107847129333314, 
0.146418251832829, 0.124275309510596, 0.281548214613397, -0.111832393470150, 
0.241895054830505, 0.0620272859603105, 0.00428869485296418, -0.137830586301423, 
0.171467816075545, 0.342221349724463, -0.0822261066829346, 0.299322229447698, 
-0.0728654424898835, 0.264672635680602, -0.0251348841116187, 
0.535926759592052, 0.163518500882281, 0.101537715866139, 0.0813406264094775, 
-0.135497824340371, 0.0143224393257541, 0.241946168318175, 0.0334110310424645, 
0.297903314421579, 0.433279282469106, 0.0608673895431622, -0.535273089546177, 
0.213928522870460, 0.286022332163793, 0.210383175541957, -0.156743520201847, 
0.373378188328092, -0.231138989878426, -0.558711481721888, -0.0970558760223788, 
0.0307434429701456, 0.159321746934055, -0.0813777431168379, 0.200120647372062, 
0.0672034307242371, -0.0832033864440204, -0.418347241357288, 
0.259576419583354, 0.216682718554095, -0.775611158828096, -0.057079264109581, 
0.508823640810369, 0.147570296136716, 0.0784646020938366, 0.0456047049164017, 
-0.157039634070791, -0.376338048319955, 0.0419052053740877, -0.444853643732043, 
-0.0528386102299412, 0.592465674995568, 0.417494024747731, -0.243587365170889, 
0.64312627300747, 0.242903110506171, -0.543148562104266, 0.172223882315992, 
0.0114248412792793, -0.463551362229002, -0.230554762026839, 0.642515264422484, 
-0.0599335340270161, -0.106392322798584, 0.277620962050577, -0.279195267129045, 
0.312864984309432, -0.394596000790493, -0.655770302500614, 0.0758393087215795, 
-0.285561751017573, 0.0906539436401776, 0.369796489340597, -0.201191438475102, 
0.543156550639973, -0.360194145243705, 0.165234311150644, 0.289726748107205, 
0.0430425524764684, -0.0144253651934459, -0.0477756793674119, 
-0.230476425397743, 0.279084342590572, -0.0762275902730027, 0.266330146703899, 
0.0860724655135607, -0.241834845360498, 0.218256901746063, -0.106693513016322, 
0.345444080485888, 0.128559219068769, -0.117334943545027, 0.222637998183898, 
0.236585339537232, -0.0210733298001670, -0.0655847669819562, 
-0.403554349164879, 0.577963789802131, 0.246884107656177, -0.420072408065492, 
0.81608226120923, -0.373358564435714, 0.183543630918910, -0.091058387342126, 
-0.383071735427607, -0.0357450339212266, 0.557061013287998, -0.306973693127195, 
-0.363889949409787, -0.176662679021924, 0.0883403794614945, -0.63709135973295, 
-0.336803071951487, -0.0908019467918351, 0.103723781510575, 0.262759293290202, 
0.21251255869794, -0.0669408237458782, -0.242946098729975, 0.441964985886828, 
-0.487037830630398, -0.396162577459099, 0.434897954547396, -0.109955628146285, 
0.693612593965568, 0.307927534059499, 0.59963600047751, 0.108678383916724, 
0.00897059598649183, -0.0475007604942925, -0.165929104539009, 
-0.0673689674303034, -0.672106775331972, 0.52266343713358, -0.107753259287297, 
0.128728095139660, -0.394954190008117, 0.285832560334406, -0.141204452427228, 
0.163440119181549, 0.0234111503327019, 0.149819864615251, -0.473327049528526, 
0.548889366074319, 0.817904151859137, 0.287915953430328, -0.323948909915047, 
-0.378417446391488, -0.055921526289117, 0.0112069266797289, -0.134072797346931, 
0.265597324192076, 0.256999252895511, 0.29774646937056, 0.0358216970558099, 
-0.64640756517939, -0.437262537268563, 0.553972176417576, -0.0385011733273122, 
0.238565854569973, 0.417013675571366, 0.14677499366173, -0.267677706782227, 
-0.410754721884306, -0.173685053643335, 0.0547165929172667, 0.098701211558062, 
-0.0479129340470728, -0.0853124013019555, 0.0687505563859204, 
0.0728098914761715, 0.0791169609470133, 0.728490009918436, 0.26305194856745, 
0.103005698471946, 0.338162039068509, 0.370914628070412, 0.339926065234643, 
0.147962274061910, -0.374544350945511, -0.0929672695710203, 0.212404090483325, 
0.471372328571439, 0.113563062356689, -0.0328867767651109, -0.0864276386776951, 
-0.440427288367682, -0.441518636840482, 0.385485149981158, 0.371863176053988, 
0.346177761370682, 0.00880892925405294, -0.586730592100698, -0.146111454364554, 
-0.272221308576822, 0.194354871368736, 0.0938586601618325, -0.0176224703297616, 
0.286008913834755, 0.422328457528813, -0.0351564423328767, -0.427878894296101, 
-0.293370068174131, 0.249770530101212, 0.60658864214174, 0.420075499718193, 
-0.134888517916709, -0.364760904345258, -0.571952154370925, 0.221469925431951, 
-0.547811895129982, 0.14427041860211, 0.572755731439402, -0.111900013756337, 
0.193585356010835, -0.333681427060309, -0.195581985442532, -0.0923874649874524, 
-0.0644181684424295, 0.255579343952734, 0.241354393514867, 0.208742203291577, 
0.094448026354592, 0.276236436936515, -0.424065234700873, 0.0318675373366376, 
-0.395967743294076, -0.0369277926328934, 0.452317963702554, -0.292252269597131, 
-0.137846112635848, 0.0559324404759052, 0.0162200430419885, 0.0774897979950891, 
-0.281956260445767, 0.711803034428375, 0.400823815677093, -0.190743678534398, 
0.260688164364869, -0.476593188230315, 0.580256823121182, -0.078082065823602, 
0.0119348412558846, 0.0769537423439036, 0.174086652207177, -0.199997763663357, 
0.270796483347184, 0.0437528036171594, -0.0498906809951168, -0.252120488216745, 
-0.0163901810716839, 0.288529476442212, -0.150067052842401, 0.447618205361359, 
-0.546320258034513, -0.138949137428047, -0.133506477638830, 0.124951134597322, 
-0.306470771273400, -0.318125089943227, 0.236142337219197, 0.583518382986857, 
0.425974518431813, -0.631096327010131, -0.19596780031184, -0.244877768548561, 
0.161308679704514, -0.0496570922461427, -0.160397909138702, -0.186722989848931, 
0.388948063772593, 0.0698140851583997, 0.069901922463187, 0.188079589479183, 
0.0313066407080771, -0.206575143090013, -0.244437271151792, -0.166794682122337, 
0.0098888398028119, -0.130415351686674, 0.194265621103546, 0.129456648997179, 
-0.321481256536562, -0.0817312892730968, 0.658345672000542, 0.0611981275454874, 
0.421854069106775, 0.0354842402806687, -0.633841796244284, 0.478800975661995, 
-0.446371318043333, 0.412906308960823, -0.67790412343182, -0.0794987101680288, 
0.224042781697387, 0.587679653878317, 0.351067999261626, 0.0222500736942419, 
0.147912307675668, 0.414377028905521, -0.355059790915447, -0.462559247179936, 
0.056618868220042, -0.145591751996043, -0.141740674179129, 0.0598652251465151, 
0.126326433101244, 0.357500561418217, 0.317743405535891, 0.378777531981625, 
0.0365348540440812, 0.0263621786242772, 0.0885381620002235, 0.478541440536054, 
0.575230800475298, -0.0641930634819501, -0.0861433619479991, 
-0.263931379551757, -0.175100257619151, -0.239882674269438, -0.0485956646397918, 
-0.307635612803869, 0.0401283334605162, -0.128306304737596, 0.161406222853227, 
0.489271369153871, 0.591645307239184, -0.415960406014623, 0.150217291118508, 
0.493259734859001, 0.536155697748694, 0.489608923807308, -0.265984297582745, 
0.323718333979712, -0.196320540519245, -0.25167666366346, -0.0748978752061904, 
-0.238821213525642, 0.545743335426974, -0.514637985091573, -0.0157892327043409, 
-0.193175881115357, -0.551337166064855, -0.104014529748709, -0.085434288522112, 
0.155430035557991, -0.615186001273837, -0.333308704945, 0.129457970053323, 
0.135851127723955, -0.133174653254796, 0.108127552293164, -0.088768010417819, 
0.480694294198588, -0.304316784756608, 0.133871983745849, -0.123636656177632, 
-0.775567719106871, -0.0496171884548995, -0.119102560841864, 
-0.0114305456110665, 0.130866400211746, 0.088996123432916, 0.0547367423634058, 
0.217978921384709, -0.0927033961427805, -0.0870088536759037, 
0.107253500816162, -0.134523311960911, 0.0504379250087023, -0.834461487612302, 
0.0592878376786949, 0.301946316517844, 0.293757616607015, 0.0422321152837229, 
0.444906114323488, 0.114109066986358, 0.352495293493806, -0.296553703594407, 
0.108875243947772, 0.152440313695962, 0.0846544885754486, -0.398351556504118, 
-0.649449090785062, -0.168300689441542, -0.21934680919728, -0.138958308728144, 
0.473286625214315, 0.551797544454227, 0.252210280291147, 0.229016679677325, 
-0.211131664612664, 0.310862130095361, 0.560498869987312, 0.0354306270665090, 
-0.149205034569900, 0.150564309079190, 0.370437907182894, 0.00923186542059285, 
0.28319500486217, -0.253029843585978, -0.311585797511726, 0.396907665351889, 
0.0569145256736834, 0.481286382763435, 0.0555981464697116, -0.533524824211808, 
0.00312071611259228, 0.173348687347746, 0.0294524608016614, 0.00648811869446579, 
0.0722484540526324, -0.100078717584878, -0.304548488436944, -0.690226603071145, 
-0.078056061779362, 0.0740061276249222, -0.0505285484079397, 
-0.352870861920737, 0.0731024598704346, 0.232460320444152, 0.151548323883806, 
-0.0125582177251728, -0.193201141640233, -0.168904453022545, 
-0.153826279302232, -0.151392760919373, 0.246489115052146, 0.671363692938516, 
-0.101127164051252, -0.0446482164674066, 0.209507983146363, -0.226233807303480, 
-0.0471929569597451, 0.0273012782783487, 0.171402398875131, -0.293517587978892, 
-0.152395180941976, -0.217093662056866, 0.154580329969464, -0.194165934475418, 
0.479258831760525, 0.303879236722000, 0.516964399460418, -0.229710345855335, 
0.365486141264146, 0.567133602630214, -0.116197772728636, -0.506184767752106, 
-0.046490183548401, 0.295012484525749, -0.0813081427119586, -0.469748698786664, 
-0.111445576771912, -0.553896087115338, -0.101846996107081, 0.0773511221892449, 
-0.271356194737592, 0.244376420013888, -0.294706373426887, 0.60187515772279, 
0.302826349093476, -0.320602823568789, 0.191090232648083, -0.181247748686638, 
0.175842394103003, 0.419746967697389, 0.373560589039399, 0.624957993956342, 
-0.101801337491796, 0.308216854084842, 0.54711559159206, -0.163741310780385, 
0.607379621244182, 0.347787240958925, -0.115001064812969, 0.905390327975452, 
-0.442017124718113, 0.00118340172656675, 0.777439802378946, 0.116557487839653, 
0.342940507710196, -0.263441746964551, -0.106415889786905, 0.204573585946258, 
-0.110511147082810, -0.164062707308474, -0.142253501281267, 0.220138803898696, 
-0.315042909359915, 0.360906753497043, -0.044380827218817, 0.105540434988863, 
0.105636220201442, 0.271824285375687, 0.696423993094758, -0.0368887924450151, 
0.183533290056666, 0.651402341588219, 0.194671384514284, 0.159181229860582, 
0.589107359831552, -0.397243674654619, -0.198473233199451, 0.497596358570269, 
-0.155541937388606, 0.712905716054883, 0.0361325284356906, -0.102527028496355, 
0.161161446805882, -0.133374490965332, -0.563728443380409, 0.225068291754319, 
-0.105592646687467, -0.153914290690438, -0.331719639007222, -0.267491179368453, 
-0.0907088008197493, 0.282091440822380, 0.890771509258235, -0.0101962522233031, 
0.697743031832136, 0.647650129693431, -0.252692045259272, 0.34266433833595, 
0.286867752593383, -0.118932092170233, -0.0953897243647919, -0.115191837529382, 
0.0799118664947978, 0.481188436833272, 0.599872986153633, 0.230785424364543, 
0.114571194633098, 0.384715499891741, -0.139697511168350, -0.259297221664736, 
-0.573915119888229, -0.459681270643708, 0.0650741496680023, 0.285038749430189, 
0.515088125146681, 0.090621769441819, 0.204354833814150, 0.104849412835050, 
0.290835562941143, 0.0562625989477399, -0.813244380202405, 0.586078317288698, 
0.10505170467053, 0.0449624552618708, -0.495297232971728, -0.67973116739828, 
0.275071824550682, 0.277018600680873, 0.286531201831912, 0.055900357202042, 
0.442310216667841, 0.349722144178944, -0.185645087349624, 0.426662670626844, 
0.166264724071058, -0.605265895267208, 0.155000157820706, 0.343284892109622, 
0.0301238383504731, 0.232191901372435, -0.14233585424252, -0.00219104276327386, 
-0.283311390752799, -0.392801815049399, 0.0579890193118433, 0.242497480463314, 
0.674049652530132, 0.12859925331941, -0.0397956106542237, -0.149944953095268, 
-0.0733462273156328, 0.517326018247468, -0.418690190474857, -0.457454862115525, 
-0.100167380026050, 0.0832322977063136, 0.450031988815201, -0.220932342260782, 
0.344744286594599, -0.321117399073753, 0.345817163030405, -0.0280820065661472, 
0.320068765078776, 0.180488770598396, -0.148246304093431, -0.131484204949446, 
0.0706161030192888, 0.330605486263214, 0.0483544660951385, -0.040369618528653, 
0.366795119227304, 0.0639803793527122, 0.111155523094143, -0.43015262231583, 
0.174216787691674, 0.174365156830277, -0.379606046572651, -0.0835280246100626, 
0.0575094680128743, -0.256720300745726, 0.0873115290494883, -0.271488749179139, 
0.44995209952922, 0.838898313341981, 0.421189983835970, -0.176005450864019, 
0.091483300917902, 0.0548986689803751, 0.0685400577996826, 0.0203385038784074, 
0.291475072431279, 0.439743557562822, 0.382968060071550, 0.203867719331245, 
0.121728914013907, 0.208424053308814, 0.607056798682041, 0.0358493406191049, 
0.386196440502555, -0.187425895811827, 0.535385724265581, 0.110061742208478, 
-0.110570421154632, -0.178238995038144, -0.504391214564966, 0.236238594740726, 
0.415160121232132, -0.262478107972013, 0.048554514524721, -0.480877733602737, 
-0.121312009094689, 0.149268960854166, 0.144687400883207, -0.338079818257953, 
-0.126470145604548, -0.239195125106714, 0.281227278768798, -0.252139493303959, 
-0.000301451745974893, 0.26071504693, -0.105706217168477, 0.133237592498074, 
0.280686915383236, -0.093851196083989, -0.0931826459454988, 0.0554065309105416, 
0.485297686515967, -0.147163241462605, 0.353828114572496, 0.202446244592587, 
0.257101186362549, 0.0786134726761206, 0.279159879093971, 0.375880035008008, 
0.762425029156289, -0.268367647709666, 0.329135567833714, -0.375550851911045, 
0.00210733507005453, 0.586784972123747, 0.333323591921353, -0.202514395632927, 
0.0483904203685662, 0.269227357813648, 0.196505050917569, -0.0733526419065899, 
-0.59308119650742, 0.507608868337674, 0.472104049664798, -0.165309745871061, 
0.35713867706355, 0.658001614112543, 0.587865327968376, 0.738864418646641, 
-0.0566702981735515, -0.139581216623586, -0.213508209947329, 
0.118325766483136, 0.460308003309693, -0.515996335895742, 0.0943556587529895, 
0.463723180013081, 0.211006945130287, 0.269508341328829, -0.101493249128047, 
-0.095393744872550, 0.162594660709494, 0.196500613844275, 0.876350804413842, 
-0.0272925385918956, -0.0267593373219116, 0.508511889581013, 
0.383447659377117, 0.438307754110867, -0.092584017235478, 0.269372669838657, 
0.0211997091891203, -0.301164527594294, 0.439160137520478, 0.256603101420853, 
0.478679517968665, -0.122768925815672, 0.040944416660879, -0.0303189747115242, 
-0.0181272107371503, 0.100770532563839, -0.180442339933265, 0.032405675218263, 
0.903444493337596, 0.150336113899589, -0.238329804553509, 0.731163779823273, 
0.0836498827384272, -0.0169775058417628, -0.0401127334465455, 
0.154545636782631, 0.594892886468332, -0.0374303523789571, -0.0779314135259478, 
-0.572202982401864, 0.295155408552402, 0.582947587550462, -0.546461898948316, 
-0.195072698569067, 0.282876210497655, -0.00327885140248644, 
-0.306387533564653, -0.734843360470829, 0.118012522367077, -0.405727505750326, 
0.552777431374566, 0.526593096404759, -0.341151385015295, 0.0931535384103982, 
-0.118948632424008, -0.253112717842735, 0.2205447912292, 0.382250830199087, 
0.705966500575218, -0.0382095714253411, -0.0320478816183807, 
0.0409628337841471, -0.620823872431324, -0.276842746741483, 0.134967089689853, 
-0.639045095580614, -0.382639647266214, 0.0591857417229857, 0.483658991287274, 
-0.417787584093757, 0.144914324151132, -0.0885566330927166, 0.243249735164671, 
-0.359412404280639, 0.139533636366453, -0.217028529668779, -0.0400330962841346, 
0.00115505075745798, 0.894726633409158, 0.162027517623463, 0.546514281698009, 
0.203407079575578, 0.232872452289220, -0.353972346791034, 0.614542168812953, 
-0.534422329212867, -0.0402399558142429, -0.269914486756966, 
0.0279618288447873, -0.249371334712754, -0.161562108027525, -0.134826995078778, 
0.401642591585349, -0.190493232480508, 0.381485764318487, 0.052178751391699, 
0.0850304764637186, 0.313130034122659, 0.0394356888115494, 0.123527641928303, 
-0.134410295942126, 0.261224060804889, -0.253247880755443, -0.289657043001983, 
-0.196865856768185, -0.109816959637492, 0.649402752257639, 0.556933607321615, 
-0.159976373223973, 0.220907448037806, 0.148583718973801, 0.706603762904347, 
-0.404595654586610, 0.155225046755133, 0.0468682567240370, 0.766774862401328, 
0.238531368761912, -0.303376858522361, 0.102127743420816, 0.0924839401776802, 
0.133010568588498, -0.0753447797364574, 0.055255091223956, -0.377772586660639, 
-0.0285640215625983, -0.083521932214816, 0.230463782749255, 0.316129633636537, 
-0.0453882849980209, 0.456084753415761, 0.209620154808754, 0.148595593526421, 
-0.255980706364635, 0.129909975768599, 0.330081235525055, 0.150327960450890, 
0.264019794380254, -0.371080227473167, 0.469353649865109, -0.467068248512714, 
0.513746389499341, -0.00804926706814675, 0.76623586742369, 0.354618197658228, 
0.148096256246697, -0.112370179972380, 0.198304127685449, -0.0726392881725584, 
-0.216217225746676, -0.155420024514272, 0.582960986602708, -0.368078619900637, 
0.0334352894531041, 0.332240483510378, -0.478734770607297, 0.177224306804702, 
-0.365021347961363, -0.398536856098529, 0.0642210443681999, -0.223407905767513, 
-0.298974695545961, -0.0634945083110748, 0.252285770972016, 0.71745011676242, 
0.558659938569303, 0.409406701155659, 0.0231597924282131, 0.367286122951283, 
-0.37531760354241, 0.184632580423329, 0.567471529001084, 0.320374578038369, 
-0.0736413877949636, 0.615621211648559, 0.761758328433185, 0.256986173803194, 
0.354315400322735, 0.439972688901676, 0.152907410518116, 0.544012437581664, 
-0.544054655702502, 0.489527721044268, 0.616860078246562, 0.513460727410698, 
0.602980488779895, 0.229987780022275, 0.764793441020206, 0.058762157148286, 
0.765958995479122, 0.611237225787038, -0.00511822134583836, -0.112257139253171, 
0.914391428826905, 0.445136507654486, 0.517123646706993, 0.531150713211863, 
0.108663426245708, 0.482954460355276, 0.343080316449569, 0.480264061330556, 
-0.0983874283270878, 0.249660719123211, 0.389875287953634, -0.233725462991812, 
0.493562690004713, 0.08908599238587, -0.484536935296849, 0.179739346835775, 
0.584231083478513, 0.87163159185132, 0.724978356183901, 0.662816220614702, 
0.192316150561813, 0.630734879230252, 0.686188783428663, 0.517683750349174, 
0.579865604044412, 0.77266776415213, -0.843223875314059, 0.362886769889896, 
0.331998948711101, 0.716668225833852, 0.333101721103249, 0.175816931700609, 
0.640303819056324, 0.239270320467303, 0.400108537671322, 0.519848031177438, 
-0.218222237503000, 0.435653134155321, 0.947024787282519, 0.4057014402344, 
0.75994461597975, 0.791533786597162, 0.266507856478079, 0.728528312913004, 
0.275684018533595, 0.440742757459204, 0.104873689228383, 0.945626466655288, 
0.148576450694933, 0.505971009857443, 0.378670549848144, 0.286139877321981, 
0.370019611126266, 0.435655427555372, -0.287626684014905, 0.73456446520593, 
0.52289330363701, 0.62386932750733, 0.439416497290823, 0.312878893135558, 
0.220160856128957, 0.325336945436248, -0.122389077811994, 0.960989796209789, 
0.370912629811093, 0.458372420351046, 0.358962599901974, -0.102799227714784, 
0.192278650706211, 0.700296812603496, 0.30452932288752, -0.0301444736533567, 
0.0898277636525817, 0.555156986337012, 0.867325143337853, -0.35417138912871, 
-0.592686685024834, -0.0912877634970675, 0.855387471168293, 0.245808470868285, 
0.338616424357446, -0.103944110994400, 0.0398603497504228, 0.760466696057971, 
0.116413114886502, 0.211343835198711, -0.0537116404895659, 0.50258030405398, 
-0.141988494378831, 0.0957544017269117, 0.372799747520559, 0.563816547165125, 
0.57857142784065, 0.272457559058151, 0.273442363497252, 0.602142356755153, 
0.44811422435285, 0.503337494767386, 0.40922580913673, 0.712562501492855, 
0.580060599530375, 0.629418256916709, 0.618146185213685, 0.086854136231926, 
0.622646869430224, 0.416573653359290, 0.75850459297965, 0.616016455844903, 
0.482637883283812, 0.637989440907218, 0.553036685316578, -0.438374844457209, 
-0.430954327401492, 0.234580120265752, 0.195847128982373, 0.125918885139877, 
0.521543767354147, 0.535486449702719, 0.447301161865298, -0.123213531925820, 
0.400062439403516, 0.509334311482851, 0.445263038836252, 0.472694377467059, 
0.137007849930931, 0.443767609556563, 0.434596058018044, 0.631341682104041, 
0.353228662188783, 0.202322068426475, 0.480692167212661, 0.192273165347415, 
-0.0765865757291639, 0.755474744832328, 0.505019369646049, 0.313839341941046, 
0.112412082048057, -0.174835793737667, 0.438187702952094, 0.105972585612061, 
0.133330842571766, 0.450844820174549, 0.181218502172108, 0.673807776049202, 
0.267441298228960, 0.474856613617884, -0.158316070417416, -0.03418663845623, 
-0.235102893764183, 0.117875543353017, 0.491768962496415, -0.0331506082122966, 
0.625567034153071, -0.338528263918894, 0.146695714461313, 0.401941389156857, 
-0.0673932315577643, 0.0467763891915944, 0.284076479454982, 0.342767620021055, 
0.700994646478933, -0.0646260819138063, 0.283542139136724, 0.401281777398405, 
0.512845560833051, 0.737012339209367, 0.320374425572551, 0.195089264494542, 
-0.379981787882896, -0.139248972927449, -0.0631131171006254, 
0.345698696103530, 0.645037922748082, -0.260758315500792, 0.0477249551688106, 
0.327073967704036, 0.327942218360827, 0.131765476331265, 0.300163444003469, 
0.779592544411446, 0.336101800385712, 0.657943785582001, -0.36210209643875, 
0.57741089998115, 0.302806966225202, -0.186606452908585, 0.747170149412841, 
0.428326305642694, 0.599684797038351, 0.419776746956058, 0.738364438452216, 
-0.0355017594456249, 0.097756748633383, 0.255981870964717, 0.477761717451363, 
-0.328384552607691, 0.359676121317144, 0.601973227761289, -0.579641309456613, 
-0.0993872745146846, 0.224230370008377, 0.441467579832371, 0.286918483070592, 
0.0431741850905074, 0.603455970531236, 0.341165504112817, -0.00684169230864924, 
-0.0204805096449915, 0.938274901702865, 0.140556891733210, 0.46950747005573, 
0.307178518769728, 0.740207005682948, 0.0795369291418125, 0.134499089600660, 
0.335039051936767, 0.0954858764930193, 0.151083103679639, 0.7256339505154, 
-0.179393317476855, 0.488298522610713, 0.41440312775686, -0.203442051316819, 
-0.0773765246213312, 0.159172013343010, 0.261240172228557, 0.480004520343069, 
0.607386775492835, 0.305534845854078, 0.305355717284990, 0.571231247685797, 
0.363214988194002, -0.0209817719863237, 0.380440258527517, 0.720767127337637, 
0.888323239159556, 0.545390033220125, 0.00634704376211403, 0.746400232425726, 
0.200415500783914, -0.0615676816093231, 0.295086856274118, 0.634448156509562, 
0.768381883885329, 0.5697229840691, 0.103523182204731, 0.442316991773866, 
0.863233236264051, 0.293152137760195, 0.766786469438875, 0.171622168306730, 
-0.173811235725768, 0.639450590978711, 0.370014955628263, -0.312785193062859, 
0.365419679786177, 0.773413376303858, 0.0695366369705314, 0.638158247982518, 
0.342372461991983, -0.277745009615318, 0.52745388798009, 0.0471038691307437, 
0.0334387534526283, 0.457389339650415, 0.588033525541559, -0.16149234567518, 
0.918379459076009, 0.324588512297630, 0.418617018652149, 0.0420160886719809, 
0.732591893265542, 0.544779859106514, 0.574935170540011, 0.523538154181559, 
0.475782085376195, -0.213384736487706, 0.404297531746121, 0.549852549962888, 
0.53547552424064, -0.173287955823466, 0.169440239217790, 0.362989478400322, 
0.632412289589072, 0.307829402515706, -0.115703487291881, 0.720246559245592, 
-0.128030795196337, -0.0169957282078612, 0.903602042008869, 0.333160496452246, 
0.12885907974457, 0.210288029431621, 0.155480457455119, 0.117354620329364, 
0.396646818694283, 0.40455140699277, -0.117499885145107, 0.431510592295523, 
0.293280272871804, 0.138909688908916, 0.111032058003420, 0.672998956360253, 
0.345686275858012, -0.114494451852960, 0.438597285485993, 0.294340307504296, 
0.783226466451673, -0.0109954464451502, 0.606171548828386, 0.423539201812630, 
0.252897098143657, 0.330339822053935, -0.139223918376257, 0.769308943688521, 
-0.321224826785954, 0.504091086194520, -0.501763172073877, 0.563624326139591, 
0.420793789135956, 0.377816087406624, 0.279305417946786, 0.835362360987678, 
0.937045871965864, 0.252155040599997, 0.776745629937538, 0.237654390774756, 
-0.0741855338258721, 0.614981607171886, 0.00073157689534902, 
0.332895025852102, 0.362684837989363, -0.135660374037103, 0.708562495523934, 
0.373742756596326, 0.775835235784865, 0.374149932604722, 0.694653816987206, 
0.614699742325543, 0.69997653859297, 0.163257018133721, 0.391792478979313, 
0.181126756258950, 0.48718637580549, 0.0222137410866373, 0.422841450601993, 
-0.102584792162428, 0.382003055920248, 0.202863816459873, 0.27991933860198, 
0.666059203032735, 0.202458596375786, -0.346829896583847, 0.325073027850647, 
-0.611462695263739, -0.055839202226667, 0.0979783825997304, 0.165683885324324, 
-0.159226407367754, -0.0329620190864895, 0.514405195358607, 0.209878910148664, 
0.361369203245807, 0.794777925734702, 0.454025887923283, 0.350595076663113, 
0.625465591356015, 0.323030599372110, 0.0143139070337820, 0.624704253488449, 
0.478799804415948, 0.281788420758545, -0.0358424465988863, 0.987496374981844, 
0.0965859271530228, -0.00854583351687055, 0.238323356698492, 
0.374565016892029, 0.247842803224463, 0.169629536030543, 0.390543151463128, 
0.595724670673665, 0.421642900154028, 0.6527379642753, 0.424504379759701, 
0.227618120432747, 0.364472435408467, 0.490241030019906, 0.648641540735384, 
0.656337767365411, 0.0767247784220026, 0.694592981528159, 0.75581844545155, 
-0.143708845921276, 0.181413340039312, 0.141558545862483, 0.160731268616985, 
0.0170775437466179, 0.570816546320326, 0.541883283697306, 0.314952598240647, 
-0.384085250389732, 0.200818520199893, 0.908353507320853, 0.787942804526587, 
0.640100580765576, -0.0418915803422536, 0.195760805234937, 0.712951662646281, 
0.428420674141202, 0.491476124035611, 0.285827214517883, 0.612711871845429, 
-0.0469162821879942, 0.443964966778442, 0.398258540219472, 0.0396227413300193, 
0.656226055924415, 0.150496415017398, 0.844447437286299, -0.0355668876128689, 
0.709110990564732, 0.450537819116933, 0.490346043812483, 0.0680586665483499, 
0.317070391136945, 0.557808121828649, 0.784887547342109, 0.362278335099639, 
0.174741828686762, 0.529579231576077, 0.573361284014209, 0.424473757665658, 
0.6205677314821, 0.337756999580559, 0.306320193803384, -0.529970356219928, 
0.624140282020419, 0.619058610535152, 0.6996130868709, 0.178055954844833, 
0.260032264818426, 0.469827632106852, 0.507449411002367, 0.0153862005252663, 
0.441745744414805, -0.000528766898425018, 0.287810536954178, 
0.290055436222396, -0.0259168454114185, 0.832759911195974, 0.464320119169487, 
-0.274129968487212, 0.249930926683085, 0.608920101105723, 0.550983210340139, 
0.0887669559199219, 0.552535062354449, 0.572266916039866, 0.398044965158508, 
0.526058209755723, 0.377527260184801, 0.120573991328552, -0.353422560858856, 
0.0609046797542679, 0.722956282014088, 0.442747249960850, 0.447049586828432, 
0.82850785609319, 0.479724828044486, 0.126292363448086, 0.0852726045388879, 
0.322649402217901, 0.572759929943838, 0.537072135651088, -0.764399312700828, 
0.888731643377085, 0.501248872356467, 0.894179807161906, 0.390657998574221, 
-0.0117152405709, 0.254255316976810, -0.121845924259331, 0.633194823492434, 
0.0229248453763040, 0.363711955511986, 0.116567546211865, 0.463455593563564, 
0.157761696010443, 0.481795249503892, -0.0317649737688783, 0.206661889492629, 
0.736692971636316, 0.060689694523532, 0.313109730372225, -0.12259154427809, 
0.109193458978258, 0.382221150536163, 0.168533306751043, 0.644607176835455, 
0.503116634079172, 0.383770835381278, -0.234193975091705, 0.156952972080852, 
0.318991787534207, -0.442854806745902, 0.121158162515933, 0.895735987303141, 
0.0879470653615281, 0.241452088983950, 0.284851638387535, 0.0560020168917591, 
0.257128298760794, 0.481418672520043, 0.740732359022659, -0.0282007311574229, 
0.0278968802788341, 0.203182731009535, 0.255030078651981, 0.412560991457943, 
0.233047708874893, 0.490211063899677, 0.722052054385452, -0.300175730408363, 
-0.328049134549754, 0.434787381065162, 0.316604994275737, 0.23432153046969, 
0.704899331788213, 0.425437328740036, 0.602128658276102, 0.505518197067737, 
0.73258891826089, 0.00516680652548948, 0.42375008436236, 0.30391649912275, 
0.531884549618056, 0.334252478135692, 0.305177685399324, 0.311370710006117, 
0.401737965404041, 0.536570719234079, 0.264189965924379, -0.0246218732027712, 
-0.352557812403935, 0.741395087119557, -0.64001401001799, -0.250161585119379, 
0.210405856711129, -0.123547948627612, 0.092006286806057, 0.0694742512282645, 
0.49847633116044, 0.79096298508055, 0.480480687962277, 0.432324930610728, 
0.625687096547383, 0.798253596349208, 0.00218165043963382, 0.0976013444169255, 
0.228459785982517, 0.866671842160887, 0.0783411212993019, 0.346451896294466, 
0.213214517426678, -0.227049547225569, -0.225000287617912, 0.561225577641086, 
0.430230415610806, 0.405846136187371, 0.311990822684345, 0.506867186193315, 
0.876242151070133, -0.0952862836428865, 0.59059197289081, 0.281973034297943, 
0.168923609706781, 0.541827656264869, 0.943029587656529, 0.762251206501923, 
0.372766346032382, 0.0571363547219922, 0.417573419161912, -0.134786716169689, 
0.429134330234429, 0.394850652762887, 0.823325988450719, 0.224080144702254, 
0.235509949229173, 0.277718725879293, 0.47200490669255, 0.624452406657813, 
0.338654881431662, 0.650867254925817, 0.0892381584419805, 0.210637163743497, 
0.257845913084807, 0.887220136595054, -0.00390693841119436, 0.110063069334597, 
0.205730545624641, 0.472641505726588, -0.316397449486617, 0.46975662959616, 
0.595106743578418, 0.568524516440861, 0.329860177187723, 0.200653383790987, 
0.236187628433183, 0.44600659775365, 0.732587216628095, 0.0952203937815106, 
0.544845651007834, 0.323148926714934, 0.98514068621422, 0.399597899266965, 
-0.0769233771540776, 0.154521541325765, 0.407917261266025, 0.26532446521711, 
0.235010352420128, 0.687328441201197, 0.662711687621577, 0.158608632871046, 
0.127286729562922, 0.137808303974390, 0.471497759214954, 0.78381462639621, 
0.622683343013268, 0.422875505006486, 0.4704849055304, 0.467550790140057, 
0.59137369751275, -0.283602833300018, 0.220500421301677, 0.434347326422178, 
0.3625574788578, -0.171266908726511, 0.258743066913695, 0.311568638587869, 
0.233070020161652, 0.743721356829183, 0.355482552497001, 0.5546867966397, 
0.948038036056597, 0.492488233860211, 0.266186915033006, 0.627218600666239, 
-0.33359092532551, 0.60159919272525, -0.396083550405235, 0.503437621078971, 
0.492484808729271, -0.0543424855257066, 0.229914181622443, 0.831244056302029, 
-0.141450004195974, 0.195114967388822, 0.309026179615854, -0.0273976914439795, 
-0.0435195010017777, 0.381805036746155, 0.616431110456568, -0.349700475761876, 
0.241319657886799, 0.687651043089303, 0.319993855385574, 0.780953382512362, 
0.493060986142629, 0.437794797010939, 0.278992892986921, 0.421172640640002, 
0.527395428310413, -0.0883479003480212, 0.0221562060169991, 0.397427933843710, 
0.545777664060242, 0.379722427779153, -0.177534614568184, 0.257758820177934, 
0.723064607761388, 0.615324552634531, 0.706956469609828, 0.541067362389689, 
0.00260078237927451, 0.330747585451599, -0.0104055892720543, 
0.592174963232596, 0.0395573758927777, 0.365226260619923, 0.198088999361507, 
0.437126549142485, 0.29612625864735, 0.707881208233678, 0.113810827709069, 
0.678386785685829, 0.452958398383108, 0.945358254569269, 0.538393015975747, 
0.232389179112082, 0.0838678429043304, 0.651863657492206, 0.538153429363092, 
-0.124773611734949, -0.0387271313469559, -0.0749988952321844, 
0.381861657463256, 0.545020218508443, 0.111688495942038, 0.366283799713763, 
0.51642249608502, 0.207364160601776, 0.476645397607881, 0.237463463814281, 
0.19710881867386, 0.508254403810001, 0.465598854904798, 0.318713836567705, 
-0.343776201394376, 0.404813539438712, 0.457193224251705, 0.403361905200138, 
0.419658180028343, 0.261261850783181, 0.0983504529050947, 0.608769585459587, 
0.142833875626952, 0.369371912986386, 0.293231919318181, -0.145564008365035, 
-0.716692582874281, 0.380637787193239, 0.62472566801603, 0.856541409305623, 
0.241871037707720, 0.145868586822236, 0.523216537096812, -0.329591247707494, 
0.0662499685225258, 0.542440144183983, 0.688183731001515, -0.0686194135901006, 
0.149908166613091, 0.365234419647174, 0.533939692956315, -0.202059753373923, 
0.105590438918438, 0.142262339389157, 0.0623574423817676, 0.392427146523855, 
0.281985868568492, 0.857057790989002, -0.140969807241949, 0.161259915139812, 
0.342000532722307, 0.445566709870007, 0.150803376567551, 0.499635770158716, 
0.0190358812561264, 0.233091665989038, 0.271481996271824, -0.322755688818152, 
0.259267692420472, 0.376574283287078, 0.324985356785179, 0.0533925790197311, 
0.579373949756292, 0.0104908532765504, 0.48948419739049, 0.187874916123448, 
0.281506111515589, 0.605043176417856, 0.613332314349458, -0.0485786471436887, 
0.786517808629799, 0.371915906409532, 0.073882324688118, 0.0509000360133825, 
0.729091477684322, 0.424648774521064, 0.163957208686679, 0.211176644630688, 
0.750480582384652, 0.542263256393549, -0.0463240742987509, 0.0724495820295069, 
0.10996720298119, 0.185616324325903, 0.487248732505427, 0.499989751680792, 
0.724354475229292, 0.120963069741229, 0.702349224085543, -0.0587487265630375, 
0.191644917335429, 0.274324212528092, 0.420923630363507, -0.230237711555702, 
0.128609320593187, -0.0791275994698573, -0.0346099250272545, 
0.419014871718527, -0.206341083702154, 0.39281211158362, 0.169963498259043, 
0.0610246080363283, -0.132952374630100, 0.382117574498379, 0.232430185732026, 
0.217057752995560, 0.698665375022099, 0.269982887230380, 0.115866828500066, 
0.23003210281452, -0.254323302660108, 0.367132137743798, 0.196616171460073, 
-0.326413649308428, 0.249480373823076, 0.402202321248981, 0.289638831808035, 
0.527996209646666, 0.529272356474772, -0.094355899651737, 0.433253794414871, 
-0.674347191976657, 0.498351937223957, 0.592200216981551, 0.344216493696199, 
0.282779817469767, 0.698665824999611, -0.140554284050430, 0.364138640984831, 
0.417005070111092, -0.158832591209721, -0.418782321169728, 0.587962911556894, 
0.122250814178028, 0.125545536066555, 0.392619447569658, 0.368937510164539, 
0.662783461373383, 0.558070415812633, 0.369175079964246, 0.150261687020539, 
-0.70291245645252, 0.168517406599896, 0.830322777778217, 0.110699497479503, 
0.69887779813346, 0.310655003052447, 0.409635068669899, 0.149500294335944, 
-0.0804401521313507, 0.664914002832704, 0.300345400451761, 0.167264579521722, 
0.0304001534758093, 0.285970056126574, 0.53094661230591, 0.282265730881694, 
-0.387625315068366, 0.564717106576919, 0.691588049135241, 0.353858310595233, 
0.450171609057484, 0.0999953106815293, 0.454558781666706, 0.594956028956506, 
0.371238583917987, 0.338845346473994, 0.165933258673897, 0.182941691120520, 
0.112896669018276, 0.103765510455083, 0.204427515387377, 0.0327346802133873, 
-0.73311447308676, -0.192070929328378, 0.162198971531777, 0.273461555646001, 
0.366636135316715, 0.426043238386159, 0.626015234267483, 0.408082667414806, 
0.395238736647464, -0.0110803574425688, 0.376450371411547, 0.360237926358505, 
0.365115480405693, 0.293125773420458, 0.211940529481143, 0.171565522698855, 
-0.154647066507870, 0.702798056325944, 0.291215088386006, 0.321518187932507, 
0.658426418934808, 0.0524474561816364, 0.378228001658836, 0.463372583151290, 
0.314676948608613, 0.235246866951340, -0.235160598160935, -0.0137508605526431, 
0.456939602194392, 0.181257046668773, 0.307169046562563, -0.0186689444696656, 
0.180296908883015, 0.658063344823317, 0.418293769883885, 0.120681404356252, 
0.227030404991615, 0.305079327647784, 0.410726576716795, -0.0158589458344118, 
0.60986228923842, 0.115086252646545, 0.382867681805938, 0.590915478855247, 
0.585638304928534, 0.158034670134704, 0.224053734791009, -0.132069604817468, 
0.181778027160839, 0.208210078103874, 0.0373383992399189, 0.397872852646848, 
0.275916234181764, 0.626761809835227, 0.725859511807835, -0.222225504096294, 
0.271648843183735, 0.394039047904203, 0.791718321588004, 0.390615746628171, 
0.365609615803371, 0.176305981291761, 0.475802364315586, 0.273871572532993, 
0.595209378154821, 0.168735125197041, 0.64224206472851, 0.310910019545673, 
0.311037489613305, 0.0611823602783819, 0.405820362612193, 0.605215662684999, 
-0.321515512581949, 0.694253952941333, 0.0366836385081165, 0.826665367383762, 
0.214858399888574, 0.549326594093431, 0.703912194891313, -0.255275588676160, 
-0.00433738025928452, 0.342057606730557, 0.481888552639364, 0.189327127267651, 
0.675337403950824, 0.0435740889479789, 0.377172727444688, 0.134280279059473, 
0.579399988215203, -0.118668036111401, 0.531574192790592, 0.0259016896636460, 
-0.0139123779868349, 0.495661457890559, 0.225409325224002, 0.216429334119129, 
0.666075048593013, 0.27721928737838, 0.595045178865664, 0.918308149183362, 
0.776202827074884, 0.696769275550927, 0.0526137321657894, 0.116269690342329, 
0.700627579065237, 0.783434548626967, 0.581697529675378, 0.358191775456365, 
0.579039197123711, 0.508793227483152, 0.692655604651901, 0.324449117958906, 
0.724766960233143, 0.595130569304121, 0.5349682101371, 0.225997828327550, 
0.674116112685359, 0.415758071588542, 0.6378466714453, 0.602005506980161, 
0.633076391169638, 0.223614600945351, 0.482332079070439, 0.618183586885208, 
0.856315313615306, 0.524582730498129, 0.720344961739438, 0.917735387357794, 
0.356913800765774, 0.664508001150798, 0.555767597568606, 0.583715500293954, 
0.932441709626667, 0.176357089962122, 0.824207276440499, 0.906947999556009, 
0.341895379139782, 0.796715644467462, 0.361864235180204, 0.613583174222033, 
0.689950602437883, 0.30448977084862, 0.345510752555788, 0.657505324049768, 
-0.220613244474882, 0.352779039676372, 0.189060574248528, 0.334914903553403, 
0.835574910246342, 0.603552760736633, 0.191305749635593, 0.508820854530176, 
0.515937931566564, 0.196774281265997, 0.743981235358102, -0.125677203804597, 
0.52920564938166, 0.664889623448663, 0.447544887539276, 0.769325868016086, 
0.305557956536131, 0.802261916323298, 0.640250465495492, 0.335947732056782, 
0.53116376137474, 0.473462918021914, 0.724649823184423, 0.713621175601596, 
0.449080291245825, 0.385991551954163, 0.522396192408906, 0.237422863297447, 
0.304871673984742, 0.536027884974078, 0.910933531072766, 0.907935054138043, 
0.324045307811746, 0.714940365271174, 0.187108536398730, 0.551356467373599, 
0.67919145773491, 0.654133558510349, 0.346072383880415, 0.715633919664592, 
0.51125014251025, 0.393293702858735, 0.352814393191649, 0.170292951060459, 
0.280124094765296, 0.80425682016146, 0.548781493811858, 0.216223409321339, 
0.218801176216727, 0.841390976502383, 0.703740265049655, 0.557897159936486, 
0.93064420982256, 0.632542257536857, 0.743548562098519, 0.77616979957182, 
0.428519392529845, 0.572830182310278, 0.586711560925462, 0.470724711996, 
0.302605082559736, 0.820739587193833, 0.332779556754053, 0.658026037009851, 
0.613178455531689, 0.578479345149439, 0.557890123938589, 0.71737714311902, 
0.791291371683545, 0.391388660895944, 0.444525302831194, 0.88585631208746, 
0.142729741940038, 0.621202026004566, 0.826837770413992, 0.710126040347852, 
0.657026148392535, 0.489123948274512, 0.766057481756535, 0.784135927906138, 
0.87535137358992, -0.67760855140076, 0.479496411006891, 0.355326507001059, 
0.361985915989104, 0.737157968008799, 0.73655057710079, 0.988417698202686, 
0.68585188060609, 0.684041664234087, 0.314749249882586, 0.529803787345318, 
0.695923939817431, 0.670641604666284, 0.310324444399199, 0.431687604692737, 
0.403614793151966, 0.926806257210872, 0.749063152431411, 0.44927075080923, 
0.530195967577475, 0.653377996121074, 0.232464822082752, 0.73153514206792, 
0.481301242756391, 0.53241449815114, 0.500034674025636, 0.303384534433834, 
0.666643533277272, 0.213131916416776, 0.59575089126369, 0.515065459754221, 
0.507926740722109, 0.814449582876535, 0.412198094079378, 0.390245727641311, 
0.702028054433856, 0.134613645149386, 0.133292358489384, 0.509223246228763, 
0.460560504879218, 0.785424064660664, 0.484665486671283, 0.292260214619859, 
0.517391972404455, 0.688700914567029, 0.174632268558369, 0.885083788453457, 
0.71893147072139, 0.75640123565988, 0.66174175961257, 0.301479144965466, 
0.404229854588389, 0.95584365353252, 0.604371555392792, 0.282150738578806, 
0.333507663971382, 0.607501500423653, 0.95096685766198, 0.781574196017169, 
-0.0296402433856894, 0.654383348839001, 0.294532270890581, 0.628066933809035, 
0.305802573473174, 0.637073989721027, 0.371452236393264, 0.380626520801472, 
0.758079769350362, 0.140680656401521, 0.394375240569358, 0.243659883324845, 
0.593704088826872, 0.332596175644580, 0.863108568068161, 0.65463403060454, 
-0.125605533006299, 0.458640041778562, 0.509434472449102, 0.651649244381792, 
0.900258510708333, 0.503777124164701, 0.50614136691, 0.473790713352806, 
0.791024269049708, 0.702754795148816, 0.44472424879923, 0.627410875357982, 
0.757228594941518, 0.322667920473546, 0.543278041835155, 0.58816125431529, 
0.713077310515918, 0.181925619219767, 0.734903822000307, 0.923232105759121, 
0.0274906872081407, 0.224384917402887, 0.77323115615762, 0.41398973963486, 
0.667034665929906, 0.181817186043991, 0.317436563611988, 0.673238248300887, 
0.824219669896888, 0.274652109743282, 0.346976246128471, 0.768851150794554, 
0.741294027101074, 0.572945778320848, 0.429523723388484, 0.80076453312302, 
0.793724219178921, 0.242322657777668, 0.275135321686791, 0.360115768111991, 
0.66395133299802, 0.654270693033986, 0.678119095322124, 0.530063040032718, 
0.555722636989165, 0.851450287858821, 0.326519956021665, -0.806553437992633, 
0.553069134594332, 0.487676643381554, 0.421821179930065, 0.361577516126571, 
0.854794354026953, 0.559159342269444, 0.0119545174959656, 0.5017231540085, 
0.845360486235235, 0.803939709360694, 0.89418449021703, 0.707926234986687, 
0.379493486193447, 0.447114897739122, 0.0689194921812221, 0.3375717564403, 
0.217581121877345, 0.560273336790679, 0.985369605043836, 0.396873094099013, 
0.900188492544466, 0.192742699621547, 0.59508397698912, 0.507108148324387, 
0.74493754256611, 0.684084356731542, 0.430652923943997, 0.485296462140939, 
0.504441849904807, 0.0864467875398146, 0.356491778262201, 0.909041632765733, 
0.754454607438391, 0.544848831098071, 0.927401367280743, 0.930287319853132, 
0.69566868370559, 0.329907772464193, 0.696963919162834, 0.612047956186078, 
0.532974604092018, 0.872076640039157, 0.715907610489288, 0.433064904045616, 
0.529599348388377, 0.590725370531184, 0.082715709885926, 0.670556445997964, 
0.401252567552040, 0.707002157748592, 0.841016481806014, 0.526732805040159, 
0.749349969975407, 0.890357282464331, 0.526482363406697, 0.86041064656764, 
0.544948871845382, 0.819777012047321, 0.616142366086579, 0.534456867093138, 
0.608856481391292, 0.54399321144922, 0.709502481917504, 0.4685057391336, 
0.69283406050826, 0.527580354750021, 0.38485731756565, 0.558537216724763, 
0.601314215581213, 0.791570953154044, 0.512235438031402, 0.406448627964995, 
0.585566833252141, 0.636826046459517, 0.453055668319518, 0.60436132691002, 
0.826157398901908, 0.726789657483521, 0.582037149136396, 0.523955385502592, 
0.7693607510619, 0.822316621254896, 0.911905601195492, 0.362727290802688, 
-0.259176559867691, 0.789826682559767, 0.794249483369021, 0.59966529701527, 
0.731287803159422, 0.046089919339142, 0.646623363233316, 0.584960483912899, 
0.363773319205920, 0.493638224703282, 0.336445908070221, -0.568823084058854, 
0.428345024429859, 0.43192922050227, 0.616857195600714, 0.852182473519482, 
0.124113686100764, 0.715743311464655, 0.819841450197375, 0.404476192871758, 
0.65556642977121, 0.171662631891168, 0.496327197968388, 0.119920026350303, 
0.656614518200601, 0.89545286751109, 0.682032224000785, 0.5942881052567, 
0.62224664736275, 0.590444221499051, 0.479365246667615, 0.830156837132925, 
0.294959676627127, 0.123060782584284, 0.44269423542866, 0.548083745460052, 
0.526835189869215, 0.620182674488537, 0.646840946207711, 0.847289016942661, 
0.792209665129792, 0.958902689698868, 0.569357360465469, 0.512111371123979, 
0.279646037388069, 0.156957451488030, 0.592524238586452, 0.431096609668618, 
0.395868256753981, 0.413220759728939, 0.551013891064273, 0.390605648223806, 
0.327698372042013, 0.300744390617911, 0.343943251560102, 0.163698256131909, 
0.747770173753778, 0.550804775099114, 0.320789346398386, 0.457370220379205, 
0.704910358177624, 0.696736802107938, 0.587094978633647, 0.0819884461203811, 
0.882230778008703, 0.690569701861862, 0.669413966988348, 0.6819269029767, 
0.527985437061177, 0.53544594618018, 0.704104839186328, 0.606081688237807, 
0.813371579529897, 0.330228374880572, 0.709267653594569, 0.543335024421471, 
0.459669040682722, 0.651951018041254, 0.553530923247063, 0.7934485763862, 
0.733689567111041, 0.795293844854854, 0.672998627228314, 0.309783513188763, 
0.420334257343037, 0.87379677639177, 0.865894268648116, 0.115959224350444, 
0.469776921233466, 0.261630905687663, 0.841584213381081, 0.921513857072902, 
0.659925398685061, 0.328732778486199, 0.497769330466032, 0.849176619935711, 
0.358839022399941, 0.740582377923467, 0.220194985257961, 0.166427585379160, 
0.347113518419923, 0.693669757720038, 0.360962581235918, 0.666169971669714, 
0.0474058366340830, 0.185687512556760, 0.120051669573916, 0.372416121656256, 
0.315539660363851, -0.119314532753464, 0.844859643981291, 0.443165796269421, 
0.590185831861403, 0.784295290635972, 0.257538785871265, 0.579179458454058, 
0.900846077880175, 0.741971529805309, 0.671615459912908, 0.855997329331791, 
0.266718836169780, 0.355172384948217, 0.615361518165301, 0.548722539360231, 
0.655402151170385, 0.696426089254337, 0.129536657099691, 0.740500354153998, 
0.701246335733333, 0.474421052910113, 0.622306172634243, 0.755510131572373, 
0.698598330340168, 0.568841422490534, 0.448913451750094, 0.628284972806486, 
0.92101025415112, 0.365598832989634, 0.615094328910591, 0.628914747135875, 
0.488805138127705, 0.695009842123288, 0.481192536648226, 0.718343354003352, 
0.622789324373056, 0.688944480175716, 0.533709976732307, 0.419323024839144, 
0.420828100396858, 0.324210916566498, 0.731142349279016, 0.617873784118839, 
0.178934520960551, 0.775939940739445, 0.717935942593325, 0.959496859030753, 
0.650199793715146, 0.187804194593158, 0.80882084926373, 0.76516497144465, 
0.580878742340312, 0.647298289467574, 0.160449850351886, 0.70122658192208, 
0.473052974441757, 0.304163385610385, 0.64863941719979, 0.958750961442275, 
0.68363843513268, 0.738573764003234, 0.747218630861396, 0.563540904006222, 
0.635858279845475, 0.941536112202211, 0.920625968359437, 0.741781240369862, 
0.774280556568092, 0.727882728407367, 0.857121955451889, 0.659136438094199, 
0.255353471025873, 0.75028853002049, 0.916493011932577, 0.846359419102108, 
0.839328391317427, 0.983425159223257, 0.667903896381754, 0.466996756378379, 
0.919864567033315, 0.810144856537724, 0.749954693338057, 0.499127937957448, 
0.97972769360201, 0.308878511490833, 0.883573833487369, 0.637567434575394, 
0.76406683906986, 0.797205515915332, 0.524056867923738, 0.545602804940153, 
0.715446785996475, 0.688083313926872, 0.42925714029717, 0.453524521059894, 
0.259066557183238, 0.497368839436514, 0.951810290781768, 0.241258860687806, 
0.617457819111656, 0.153086374457612, 0.640077746240732, 0.532498093939778, 
0.53499773580875, 0.673243209665826, 0.300231054920552, 0.395437622119671, 
0.67965825743297, 0.670652717664149, 0.750306237092922, 0.895646698851743, 
0.474546892414786, 0.643343470530577, 0.883565257403334, -0.404300709312838, 
0.777671402084223, 0.299458927591812, 0.509219052090986, 0.884717882352145, 
0.747632675156612, 0.602694561203028, 0.666917518784752, 0.530697015317367, 
0.928388863462918, 0.743485906577082, 0.320517304026814, 0.697169313352958, 
-0.085113817169049, 0.684903127926627, 0.477603626437332, 0.318750511461442, 
0.811338182928275, 0.247258233722809, 0.244412727402121, 0.951907529536734, 
0.426176799357712, 0.391872316228376, 0.748607749695903, 0.704507715120874, 
0.765441013259522, -0.573600628245615, -0.0801350923839961, 0.670592445060131, 
0.693478845899689, 0.858012214187244, 0.442094151856471, 0.339247955883918, 
0.819450685739835, 0.862121360079343, 0.595394569833782, 0.971991390034072, 
0.746725152958934, 0.336459796592539, 0.432582082774445, 0.460995295620236, 
0.426191643763704, 0.62466317462823, 0.652026535345283, 0.966599377693282, 
0.394086372748244, 0.762394311445738, -0.239926045617800, 0.478309177391638, 
0.610808256485938, 0.411669831207495, 0.752012614278147, 0.791912441843675, 
0.702558071953734, 0.229969913213609, 0.899108145558308, -0.0550567521515442, 
0.755614126304701, 0.60560736665924, 0.957670728421666, 0.499134958005199, 
0.870535435249885, 0.80264767796444, 0.309126127499835, 0.627700102225735, 
0.445529218130816, 0.414950568008556, 0.411275257405753, -0.0168784776782644, 
0.770089116689565, 0.597096137285453, 0.758144807510996, 0.754792884828184, 
0.529616956168318, 0.631170745517698, 0.462312276155440, 0.826966558904461, 
0.924756191349272, 0.384959659431382, 0.408732879649855, 0.548429455546943, 
0.753077238092297, 0.580576132231894, 0.368553674337353, 0.792478109521904, 
0.458432252862285, 0.67820965058073, 0.522639040474293, 0.392623890644546, 
0.322318326913644, 0.704922389513657, 0.53682503573136, 0.449566398575579, 
0.736001114600211, 0.817198083060749, 0.733349048476453, 0.547726238395459, 
0.724146814249575, 0.880162440349202, 0.53011510522633, 0.325586396154531, 
0.53763975530991, 0.843085473354918, -0.0809801632038279, 0.501404247527864, 
0.882187885737066, 0.172956360093768, 0.233403444205355, 0.408984898900576, 
0.931820908353233, 0.6823144197536, 0.784262321369961, 0.135750693453240, 
0.515320332018411, 0.522787136179512, 0.547408922340842, 0.504886016129443, 
0.655746933928503, 0.201169416189582, 0.77328029706304, 0.532722197842403, 
0.542867394749411, 0.305926672618483, 0.813495384274846, 0.711436237733552, 
0.758095927179017, 0.607805444146371, 0.239037553879156, 0.630599731158174, 
0.206557095132708, 0.450820573176410, 0.738796199403867, 0.621085971288027, 
0.698663123127209, 0.43893599155995, 0.528092768075912, 0.154373815157515, 
0.557822295777037, 0.687530222789487, 0.706101614088418, 0.72924068925195, 
0.490622423619658, 0.522894468069767, -0.432865984146684, 0.943451310394999, 
0.577022593008394, 0.52106039432422, 0.590326760111631, 0.393676604072812, 
0.704050840312787, 0.968421039072523, 0.31308867648816, 0.618516635800994, 
0.0633114588655076, 0.524080762074355, 0.424748322884927, 0.740640331015393, 
0.491641080672187, 0.470961651987589, 0.365909284979317, 0.624120235310847, 
0.590552850579531, 0.770019061756773, 0.628338563365284, 0.826146350028886, 
0.655340923817207, 0.604583694264408, 0.158549558824917, 0.547319391265138, 
0.500146983827621, 0.491790624344711, 0.619691411056592, 0.793691156583826, 
0.35207627386394, 0.725520891883942, 0.345073519008173, 0.533913027357716, 
0.73553486951915, 0.529616284127349, 0.6083770885121, 0.368372977933071, 
0.365409837225467, 0.354646136843384, 0.746840641716437, 0.204365495567349, 
0.895483951274631, 0.718923080806053, 0.562993806619274, -0.0174534509690816, 
0.888270689422716, 0.976952713399705, 0.58194991717249, 0.939090775104906, 
0.711271505832787, 0.88333257635611, 0.421114393641461, 0.464124860943840, 
0.134961007770815, 0.690710140139371, 0.506017336069144, 0.191868493276758, 
0.49715258487212, 0.736016333340837, 0.365631666415186, -0.0175616900266638, 
0.415977891386577, 0.848134219192642, 0.533215699203215, 0.458530820023087, 
0.679950972649507, 0.824265501240077, 0.403977833991627, 0.217120621516015, 
0.372975131065093, 0.697344842345997, 0.191942538446679, 0.322888194441379, 
0.584124808572263, 0.540971887061043, 0.163756279050058, 0.555339924677113, 
0.532732911556224, 0.403145605227086, 0.617740562299019, 0.534445369434815, 
0.279025033477072, 0.806205778770057, 0.708598634398206, 0.554191451360739, 
0.755389630985859, 0.488964780420454, 0.533679222398052, 0.769058077727352, 
0.720175125315082, 0.73933857491188, 0.480823311476002, 0.364912826356577, 
0.681880078334124, 0.40006013714477, 0.214255429129209, 0.73339032085091, 
0.53614976469807, 0.302755200081210, 0.77638761411952, 0.396940324078446, 
0.386475781779939, 0.602061038586138, 0.221183850566712, 0.748257707038032, 
0.566414528483681, 0.37311182659618, 0.462157106229018, 0.58244154393595, 
0.407066755540867, 0.548412548320931, 0.759213774246816, -0.190097431371638, 
0.510782712280776, 0.94331190578242, 0.342869095984558, 0.345504423569856, 
0.938423208027258, 0.495783804229807, 0.210833941429035, 0.549537732742892, 
0.216321347435144, 0.169956011860973, 0.444564837177185, 0.45740325482157, 
0.485356335423462, 0.804119446652129, 0.357444915155159, 0.290248399816345, 
0.0274989613416176, 0.293615956520775, 0.661727744190816, 0.4660075453968, 
0.431389014920338, 0.603660039068292, 0.695387014162996, 0.578870087979934, 
0.383330164091631, 0.312201403914637, 0.247267370613580, 0.398090491465702, 
0.251372037538345, 0.674832178814461, 0.554833937903595, -0.355379288844866, 
0.639169927232068, 0.265218089325910, 0.684231522688336, 0.540739302951118, 
0.196873915736429, 0.927235073065356, 0.395782754371518, 0.516942129051978, 
0.171931483107478, 0.643015907110479, 0.187919247855452, 0.509541447363609, 
0.110629561299710, 0.630938044266896, 0.70322900227074, 0.538580932041531, 
0.953114423730922, 0.888910317856472, 0.595318690687777, 0.192295055079649, 
0.652191746547701, 0.745076602745945, 0.62969180353596, 0.554658453230781, 
0.880727630376534, 0.66873719975364, 0.655311130310835, 0.783806446166673, 
0.796674271924073, -0.125607537957943, 0.756278832282976, 0.678406450369533, 
0.616878918538781, 0.81050048824018, 0.495629910262559, 0.782617443308762, 
0.547286281481576, 0.431628475765176, 0.285771039757516, 0.556219586206618, 
0.563443251260793, 0.847901537232427, 0.95012303457656, 0.573772989532660, 
0.410873969820401, 0.539207427934477, 0.148916228745202, 0.556331745854255, 
0.694773462547481, 0.407101605002699, -0.0838395540477585, 0.762079038435287, 
0.219057506837335, 0.490113379142763, 0.757671339846617, 0.477105964500183, 
0.458222562757372, 0.30947933878687, 0.839672381905967, 0.69550828645774, 
0.605819998900742, 0.779001780186016, 0.268826073712729, 0.109810075952868, 
0.0421155853709587, 0.748714791565591, -0.165360019344456, 0.321321187822364, 
0.570196885498601, 0.287998428485848, 0.453528225574751, 0.281477445429809, 
0.748380930278424, 0.620917168940442, 0.656685798773718, 0.55616890042325, 
0.70208112876163, 0.630322770696796, 0.321299378025891, 0.645491443868008, 
0.395467682661506, 0.699622496971795, 0.491691161642334, 0.432788572240068, 
0.370537009832498, 0.205629909318228, 0.717758994861865, 0.95742893433227, 
0.734836436624955, -0.157137447663648, 0.86390506921963, 0.692880393637748, 
0.514706618355803, 0.722652746026606, 0.269345474751802, 0.62341263891478, 
0.465725363738264, 0.48170695837647, 0.659778857668498, 0.257956288801844, 
0.706063640325428, 0.784570736143737, 0.930466056934466, 0.568420154201999, 
0.718116819520336, 0.703501440989867, 0.394561874730632, 0.288650372777174, 
0.527855819520291, 0.686607770838227, 0.243290235542177, 0.207923640448201, 
0.322551279133608, 0.0930686928003163, 0.736620995946937, 0.954385927591465, 
0.291640086156467, 0.76147729215499, 0.842686329916565, 0.800257632181166, 
0.197230005759330, 0.581529741439977, 0.858428208617631, 0.440109514195408, 
0.434327051782685, 0.159499449661268, 0.322482413273922, 0.452402594112694, 
0.554702993340959, 0.140376334560791, 0.53826216803205, 0.890358581542899, 
0.865621322922896, 0.079971553310541, 0.447196523438212, 0.0718965257304179, 
0.685696776629057, 0.60913988078969, 0.758427621409684, 0.801333085162467, 
0.467592924416177, 0.243572827027680, 0.229286786948282, 0.395795651877856, 
0.527518653756647, 0.551126644774999, 0.642969237404767, 0.743418209456413, 
0.596191838521465, 0.813887879146852, 0.570844150006767, 0.630929051273034, 
0.938212893795613, 0.794898434496645, 0.967357420357076, 0.89793532610436, 
0.677807995900029, 0.766716235003503, 0.805786754701688, 0.969506883056425, 
0.695947815122043, 0.636075063797032, 0.73934108754938, 0.926498829735044, 
0.688379345390788, 0.847300065592016, 0.92798015716357, 0.887345903065443, 
0.95764199940106, 0.597217181613414, 0.79212218317222, 0.89084152882238, 
0.919024458268285, 0.527540758578974, 0.787146249392138, 0.765388377699141, 
0.741011956081008, 0.955821061698725, 0.75136271985068, 0.773138187463587, 
0.868454398840548, 0.728572383182388, 0.706252344800245, 0.809068575778645, 
0.836301878155668, 0.518696651473396, 0.866510748810128, 0.807363784914507, 
0.95376716925838, 0.920617370891216, 0.973087043108845, 0.777859815908406, 
0.621049767607028, 0.824297575420701, 0.934649834837751, 0.692858758922452, 
0.80515508992299, 0.835455070573419, 0.881621563963247, 0.559908709642738, 
0.715659372196673, 0.755790061654723, 0.883600762734745, 0.857853142845798, 
0.837590386025892, 0.362687634862214, 0.700021756718257, 0.615489799251326, 
0.588757138483878, 0.901164412601787, 0.645296106899154, 0.878804980193556, 
0.633534052060588, 0.822528643142027, 0.885887446794388, 0.76416507531778, 
0.76413854687639, 0.801452229080664, 0.850807542202121, 0.928582968320682, 
0.973886832330166, 0.202074546388270, 0.790769085770505, 0.773551880646577, 
0.698355326562888, 0.654093871784298, 0.767811437928598, 0.550986955010997, 
0.585866268911059, 0.913688841910662, 0.537142633818835, 0.93891251909058, 
0.664681674586068, 0.869625725246952, 0.82091009419779, 0.662943488059409, 
0.620551667073836, 0.890483499137634, 0.843609834073236, 0.810428045008694, 
0.835285888288211, 0.901592467744859, 0.706890501896505, 0.750596479055359, 
0.7442504934638, 0.706988253267844, 0.573323649945045, 0.788076113976059, 
0.722612197570587, 0.681403292981082, 0.631276570842655, 0.549776958589036, 
0.810076512788427, 0.864170970740433, 0.6844365530703, 0.91252589687015, 
0.90807956994888, 0.74556722713919, 0.930289296224525, 0.925313349609716, 
0.773168069045023, 0.296170824849195, 0.611749800060487, 0.00481466130106806, 
0.87040150020876, 0.739772461828837, 0.92113725633966, 0.769700736862387, 
0.679202567503337, 0.946579774624063, 0.545253310452833, 0.753889757752469, 
0.93719726639661, 0.846083879517924, 0.627736257354665, 0.952644206990101, 
0.260508085085296, 0.68261519434434, 0.967538268389254, 0.969066186565422, 
0.521627805873674, 0.853543848785264, 0.890656133051622, 0.436985046113873, 
0.720228483844712, 0.88605571882503, 0.319192174418521, 0.830341169920654, 
0.487313577564136, 0.74599588693267, 0.726400834804691, 0.818376739291652, 
0.91821389023898, 0.520769017471481, 0.804976834788126, 0.823468738280476, 
0.479844192267525, 0.986144799896317, 0.684539763399913, 0.630867945674799, 
0.847824360374647, 0.634646042240687, 0.942985140232548, 0.696448714486409, 
0.960843391791016, 0.743894239722339, 0.801886376244876, 0.77946843999703, 
0.667485766155176, 0.759315001382784, 0.88288474043956, 0.61896682580639, 
0.55206223681259, 0.801521490719198, 0.988770260991991, 0.742404543214051, 
0.881823326960972, 0.858801771780565, 0.89944117166124, 0.895047572035124, 
0.687701942755298, 0.540742323716679, 0.511911796542061, -0.0742974216177033, 
0.789135218507738, 0.433159549153322, 0.915365183782364, 0.884098414642865, 
0.885845670294498, 0.946365757804174, 0.875340241855292, 0.792103897902393, 
0.781455667941581, 0.497433664880608, 0.739893299037285, 0.695477545227878, 
0.938417308690677, 0.721746702033888, 0.947316638233272, 0.707995001577209, 
0.601534758395913, 0.754294104568177, 0.960301345112113, 0.959374560453736, 
0.909359352200286, -0.229382308817676, 0.636644525618894, 0.827294546074213, 
0.945576045316185, 0.93237200003158, 0.986787052204688, 0.913831522124777, 
0.685918921953034, 0.740616783333576, 0.545430444152296, 0.927127638984739, 
0.758767664489517, 0.906192613685883, 0.619305251621491, 0.886010149826682, 
0.747058998885258, 0.666276976512152, 0.524178247944435, 0.349823290371048, 
0.589607946768814, 0.81960657501421, 0.90698441220126, 0.857749812202448, 
0.714450512569663, 0.481492454290465, 0.82692554419816, 0.780321963159167, 
0.561338220140204, 0.651255476707051, 0.690087888427783, 0.623148574012242, 
0.783158194981633, 0.263260170357197, 0.961286907312587, 0.902067514663256, 
0.657519371379074, 0.744438903639151, 0.692828675994052, 0.824633986018584, 
0.749395215538909, 0.874726791508997, 0.745239527539283, 0.32001148025029, 
0.836497288501278, 0.956142747828423, 0.855187240034748, 0.655868368890983, 
0.929833814688395, 0.501153548279635, 0.419635576961647, 0.727362272492706, 
0.650242697919584, 0.931601057698596, 0.547761631093306, 0.757856872851851, 
0.959816215455925, 0.882556304472, 0.86575887955952, 0.890206689427908, 
0.682206935954807, 0.851136648808917, 0.75356599819913, 0.823603594525115, 
0.887238225032713, 0.791499635110259, 0.763077545102482, 0.864666373969484, 
0.947199073953881, 0.539236781637986, 0.814029078819854, 0.886096925048787, 
0.829649442527353, 0.916299988790023, 0.788853960941776, 0.443128146933914, 
0.282540277606052, 0.963127410810657, 0.625596905950879, 0.926576048581128, 
0.476157595758301, 0.73616526074687, 0.910743675949649, 0.915561066749177, 
0.9069653529367, 0.723600458983412, 0.716365688792127, 0.77654425361652, 
0.840058992507102, 0.969443803369956, 0.852634719411183, 0.78835660782515, 
0.942369527226282, 0.74880219583114, 0.406196930073982, 0.767990704560744, 
0.526392971170933, 0.897257010535416, 0.879560483442504, 0.796354499336987, 
0.619669469105686, 0.89831051422616, 0.463814006691593, 0.479024810057752, 
0.831028129803036, 0.773498599572789, 0.863464420323291, 0.916800340270225, 
0.891243600602733, 0.93763633689862, 0.661568304574492, 0.734149056979286, 
0.768644717063926, 0.440178870257425, 0.842782897709601, 0.33299497604849, 
0.66403821543139, 0.753320285548459, 0.749793288821354, 0.988320186846236, 
0.738075675289055, 0.611055312463346, 0.853353559854962, 0.579917082102847, 
0.97501846786771, 0.766863938984257, 0.741131191485528, 0.891138525874728, 
0.915372919640219, 0.965686140012584, 0.61511451865833, 0.632611817817624, 
0.705854526167699, 0.711227071060064, 0.622385477536458, 0.885888056307448, 
0.922759444310004, 0.336398303149370, 0.82584256467269, 0.908845894335881, 
0.849008280657205, 0.753470806243556, 0.788264576891292, 0.737462567425603, 
0.929184804050769, 0.867838788912761, 0.808737800811316, 0.800830414304211, 
0.891354609866088, 0.731244554600558, 0.762017115068672, 0.829805101901108, 
0.461778832224914, 0.816017948805021, 0.946464403202348, 0.86377681437112, 
0.742730064758582, 0.879589914247941, 0.88476226933911, 0.929113800814326, 
0.986718265837079, 0.792473050153833, 0.567332777549774, 0.452193063247421, 
0.460418874415054, 0.396972049031012, 0.860588119966653, 0.854520052025021, 
0.69177757227044, 0.798366401861268, 0.548644577776125, 0.703509438424956, 
0.922211995452616, 0.815414498085828, 0.364359570439143, 0.81597888674873, 
0.96997557954794, 0.807726336046011, 0.613019254997655, 0.951699161213899, 
0.752557843677326, 0.771516102733175, 0.651561044727911, 0.567057595340289, 
0.536196323101294, 0.795165063033836, 0.865132147533314, 0.902248250921191, 
0.868676939345066, 0.625833595723836, 0.799775225695569, 0.53521128018063, 
0.748674386094288, 0.889388647239322, 0.77859598146259, 0.864546503224292, 
0.901546425761905, 0.722526283346692, 0.67497995768842, 0.843277043130347, 
0.925270118054185, 0.589282819626937, 0.743967342227528, 0.082770026106506, 
0.860893000645518, 0.71182906564967, 0.833022717595477, 0.923430498962043, 
0.854727222518936, 0.944276425074507, 0.817750549689272, 0.657356870483322, 
0.8019162311168, 0.856091381748417, 0.845407523626857, 0.573255288090598, 
0.898395958396565, 0.857595021192256, 0.71759109989782, 0.495279262093145, 
0.735653025053887, 0.72165951873409, 0.901952169079535, 0.793142593157134, 
0.541637303217362, 0.917070097623367, 0.689003766274463, 0.809049264673805, 
0.64145470303414, 0.837234744333159, 0.657040490000329, 0.939888969831346, 
0.984368906241805, 0.690787582892216, 0.833194069659157, 0.825057029865768, 
0.853985834440625, 0.711563121212202, 0.858789543031847, 0.790963267961514, 
0.837649819840425, 0.714373599012762, 0.496617463507803, 0.69838415447354, 
0.503023944147117, 0.549679326375096, 0.826955904154382, 0.839238639490836, 
0.601998971743645, 0.830322485919155, 0.59207857804518, 0.971579672762128, 
0.735905572239144, 0.820735306329067, 0.90022046785042, 0.802129087606766, 
0.505305825275575, 0.655370678489757, 0.843742410295641, 0.60546095220173, 
0.763447229003933, 0.833787593548992, 0.7509461852757, 0.98592839468069, 
0.852291120848936, 0.829383886712744, 0.298332777413573, 0.545423461115673, 
0.777646101643294, 0.80658982147205, 0.866466870790235, 0.667187560402266, 
0.585296309203945, 0.879973732429289, 0.680569743123161, 0.611695248131256, 
0.704899049882893, 0.912082192765292, 0.738186575974153, 0.774228692766562, 
0.731336626399809, 0.900246672459293, 0.817681023038038, 0.90393172351221, 
0.713218638515805, 0.79874189255421, 0.246723831535658, 0.354916517971522, 
0.815560322958929, 0.50561919714717, 0.709402572493447, 0.760540630266132, 
0.691762121008541, 0.739545894258436, 0.362743336871323, 0.797667952319966, 
0.906888809191407, 0.53397882852266, 0.949328418384355, 0.921510767692176, 
0.427379349885321, 0.185481366965565, 0.808858376868651, 0.599774109405417, 
0.468863985487241, 0.865443303156334, 0.988865911763389, 0.644213966661666, 
0.917514982993274, 0.92986716613143, 0.986509123714655, 0.846353559088519, 
0.681681637226315, 0.386300890225260, 0.593050338143384, 0.71217734422546, 
0.53629621325822, 0.459081582601907, 0.735003175260985, 0.809771436066537, 
0.756190920733124, 0.748965113852904, 0.885213705689944, 0.231388272834147, 
0.831405774844856, 0.654213148150168, 0.581349506290688, 0.941213161479519, 
0.877491678918783, 0.9376350903469, 0.827290506577628, 0.342356161875800, 
0.311785396162508, 0.723692264680627, 0.707332467293648, 0.626768103876925, 
0.748837777370043, 0.726186051267276, 0.835234179363824, 0.60222185434772, 
0.582576532939875, 0.805066227654599, 0.660245452093944, 0.691202247936583, 
0.503356559424491, 0.717169436800582, 0.832041197675536, 0.830763213975545, 
0.715615254589754, 0.972719062651296, 0.771280517272007, 0.762427577718023, 
0.932540314920663, 0.459356106189139, 0.621255676152753, 0.90466614376409, 
0.732712996648587, 0.725477296941012, 0.623513038556528, 0.955924868601252, 
0.766890017767333, 0.868914352009786, 0.949549566974216, 0.971948802265146, 
0.813799372267278, 0.118329989473484, 0.871925293047142, 0.694642060929628, 
0.755487124903288, 0.602995929422226, 0.812677085198961, 0.716756578869492, 
0.922712858370287, 0.829728364885256, 0.92172586315711, 0.766837865418966, 
0.864385348724585, 0.5765458857493, 0.906229670522084, 0.562777557449695, 
0.88095362628735, 0.61021135789151, 0.694398235348305, 0.687547511083478, 
0.977926893569258, 0.897204781240056, 0.762815798573886, 0.615597047809324, 
0.74757709376539, 0.690953346980773, 0.894492608030063, 0.899876305755145, 
0.724377114063401, 0.80658250406953, 0.759658255334599, 0.869792698563322, 
0.837458518145608, 0.691393891448034, 0.933731218236379, 0.742064946463364, 
0.575992831170815, 0.878804811746203, 0.538390633886606, 0.934749021184116, 
0.934680314000205, 0.556382230338132, 0.879278482212213, 0.686059744922995, 
0.537254288265166, 0.640480646169899, 0.965968580701683, 0.787473292366338, 
0.753413545816334, 0.91772120963499, 0.878325528675538, 0.699774840514494, 
0.728130204772336, 0.776426472492922, 0.98212217792148, 0.575232196329242, 
0.772330590145429, 0.807698093459271, 0.881172523702136, 0.520378177057604, 
0.71467068774343, 0.873570291623905, 0.42745908740123, 0.660406351444486, 
0.638450509922058, 0.851088523853651, 0.912586613756086, 0.876150707810255, 
0.777379589154491, 0.832671860763281, 0.674024738579478, -0.117413426713064, 
0.938195100341987, 0.65514650609098, 0.768623523926211, 0.830075540439536, 
0.880846363195405, 0.760062530539243, 0.785687338802819, 0.684776126198025, 
0.921680974570327, 0.786028949065043, 0.593442281528224, 0.689517474649948, 
0.850533496085984, 0.927265484558106, 0.863481166848486, 0.736941930780283, 
0.282822353844092, 0.80636422910899, 0.812715391726973, 0.918054385406592, 
0.7816181527527, 0.891212690108344, 0.776554139078585, 0.75062359856194, 
0.56637816582947, 0.760334926643587, 0.839424054962315, 0.67706882115093, 
0.824396986611081, 0.879877632660731, 0.762487862120438, 0.936249491482995, 
0.739920273803598, 0.76323113742847, 0.942647897188496, 0.958788523410408, 
0.941745987636605, 0.887138157527526, 0.933008307124659, 0.878021870972462, 
0.80484876151264, 0.814180704224497, 0.288408000967026, 0.856864343131383, 
0.586413006725292, 0.918884497796002, 0.88525513505506, 0.870393470851744, 
0.848158544134788, 0.66693644710885, 0.910473399592719, 0.891506832645763, 
0.518471825082522, 0.86584160003014, 0.681205060121562, 0.539973156455001, 
0.628360924426122, 0.926181316195483, 0.805155590603656, 0.806546767309092, 
0.508936342340274, 0.92390234774982, 0.92298156372819, 0.84085264773855, 
0.698467452000278, 0.173187309950183, 0.626241794254373, 0.76167980222302, 
0.575095256730558, 0.274003751330082, 0.698454388321856, 0.817092288371589, 
0.787475024043129, 0.787380235965076, 0.647501409475548, -0.124514515245320, 
0.359210212981653, 0.852301508681963, 0.866767697044885, 0.722584539591199, 
0.981850452013733, 0.88431339897863, 0.594916936859978, 0.40256862579051, 
0.947032393990903, 0.83066154369902, 0.91595310834644, 0.866502847384903, 
0.898375288773534, 0.918856311624145, 0.951153467507472, 0.799650808729738, 
0.587492152458967, 0.939400016562452, 0.906464334476402, 0.758017827353464, 
0.611284837111148, 0.90987036109518, 0.826130199950567, 0.723748919916713, 
0.861702328255625, 0.8714903705564, 0.643884946311718, 0.665091142856122, 
0.921421680906497, 0.989490302603644, 0.880511698977612, 0.508694467844356, 
0.763767882935472, 0.787365803623878, 0.689106364672485, 0.465667964905201, 
0.846600545907568, 0.654963488078465, 0.839476391355797, 0.870110985897299, 
0.523561981812081, 0.910460603415043, 0.94699827255595, 0.379995804938475, 
0.200719298325950, 0.29548654281153, 0.853943021449403, 0.63792042771537, 
0.587592727006909, 0.441794833077981, 0.939793319543186, 0.940009969993008, 
0.862961019046717, 0.648640347407561, 0.615734214594864, 0.529914331801616, 
0.894768624570876, 0.875619071989234, 0.48839268231283, 0.866338584550258, 
0.632006396669221, 0.921638724410448, 0.816836570184146, 0.80718928847038, 
0.957991914346433, 0.91064192945919, 0.847575995450876, 0.870284241496826, 
0.967256266181719, 0.505970776783693, 0.835003800655304, 0.688570737063365, 
0.706250844137067, 0.674694872149556, 0.686651139928315, 0.835709916733437, 
0.801870106008819, 0.878198527147303, 0.659538225014688, 0.787662176932102, 
0.654271770385659, 0.833500104692342, 0.739673538189487, 0.888255290073777, 
0.897103568485793, 0.355425563023619, 0.78082309248286, 0.768400427653038, 
0.870145064501976, 0.518411414931389, 0.945598928208206, 0.781426961881596, 
0.858011658418492, 0.779495410502206, 0.287915957231528, 0.70736639726831, 
0.893667686843796, 0.994886717048073, 0.638265506617179, 0.769664309445139, 
0.77937958072392, 0.779850313698311, 0.790360200668291, 0.84791803061431, 
0.730579981098059, 0.76606268118884, 0.91260442681719, 0.939643840320164, 
0.728938675942987, 0.764021583845135, 0.837876438376612, 0.87708996475606, 
0.808521599467969, 0.791228693199663, 0.346702735013498, 0.891550620084744, 
0.449101438269029, 0.368279950364537, 0.46836741602002, 0.734498407804503, 
0.95838019775785, 0.716320517234456, 0.490791959382454, 0.847060866076151, 
0.894213511613318, 0.457177173479104, 0.866622303673883, 0.706114043076909, 
0.812744399702105, 0.644175786748407, 0.8875504264523, 0.852543490433959, 
0.84124306541788, 0.86549511738565, 0.595175869748431, 0.336803126221679, 
0.856904653339924, 0.604228999186083, 0.758531142745752, 0.875151004333995, 
0.703730325259837, 0.653060602426438, 0.644996901126455, 0.406206023376528, 
0.745512259735053, 0.868023120949676, 0.896523538541008, 0.895167366788175, 
0.699471813629015, 0.891725431803186, 0.830699688706027, 0.941208841583644, 
0.701393319925008, 0.823407238034923, 0.671569546427089, 0.93061068431283, 
0.669019435685654, 0.834823896770135, 0.786642569292439, 0.836959097959776, 
0.87701609689384, 0.941075604819556, 0.619472216420026, 0.916791914523438, 
0.919305161047398, 0.638718368642783, 0.742428120049712, 0.756235101105241, 
0.855109455614916, 0.77579444314501, 0.923124398674122, 0.901443878945597, 
0.811755800883959, 0.916125776686687, 0.890131170224543, 0.913123179833482, 
0.855472210415466, 0.828691685918131, 0.526004016752339, 0.429229726749248, 
0.343989891758938, 0.779650620909754, 0.902342717087774, 0.824749627287854, 
0.911632882225868, 0.905682405101508, 0.68683057112795, 0.553652483880322, 
0.882226413724622, 0.681050556999041, 0.752051210810126, 0.79820070937441, 
0.605191628847636, 0.812721396268447, 0.854578617877266, 0.420497155607035, 
0.819234357996972, 0.77909588618233, 0.866521544656749, 0.706122621837999, 
0.8940742920315, 0.896741911888539, 0.779759073676759, 0.208002014051286, 
0.591691464990839, 0.787997370475912, 0.944665304933442, 0.822196896577737, 
0.641146018123414, 0.655645798338151, 0.914221889355547, 0.639053709031357, 
0.888698456167217, 0.843983598321814, 0.843772279715027, 0.81844409112444, 
0.725499005244627, 0.623095396155513, 0.742205788543228, 0.715282649421778, 
0.936588899386448, 0.890360071270281, 0.797269812627061, 0.889964033194756, 
0.831413536358989, 0.772210027710446, 0.754961040242581, 0.904674337134487, 
0.93974284357068, 0.82869853461229, 0.895773297327014, 0.661910659132152, 
0.700369569742229, 0.717370768594469, 0.816488620110356, 0.872726755718345, 
0.862673057049828, 0.572200960282247, 0.885118855455616, 0.431563782309202, 
0.73353884255854, 0.925530508868183, 0.738251011330692, 0.864958604526666, 
0.627274966678165, 0.9582495152751, 0.847499531575852, 0.860447544387739, 
0.716201010112707, 0.683202664163875, 0.817033226600479, 0.859827762707872, 
0.928085824910715, 0.174790484513920, 0.605683824736604, 0.980789678549946, 
0.668022734716195, 0.805221336463166, 0.733857758387947, 0.455118476400533, 
0.756510605911231, 0.815906457926928, 0.928129143471475, 0.937686101627273, 
0.8617471593215, 0.781582961507094, 0.856032880477957, 0.596097509418008, 
0.664979673977817, 0.904810059441663, 0.94533270259908, 0.824251281984274, 
0.835850777844739, 0.85227042808791, 0.858531782950233, 0.669084418151326, 
0.171534474639893, 0.794370185129078, 0.851538837837474, 0.96734436272631, 
0.895030072027892, 0.730301319759253, 0.466349291787986, 0.801936929909592, 
0.778679743785185, 0.877202486230434, 0.775942156628593, 0.780409828144922, 
0.90707431614504, 0.684985875286886, 0.845597471193045, 0.583551959702146, 
0.829278206448972, 0.859457852819635, 0.792582125386412, 0.894846803735371, 
-0.253945132972989, 0.658534343309057, 0.981288219831292, 0.902240589757392, 
0.59731951459332, 0.800094525485407, 0.735580712100768, 0.690245759728138, 
0.866698295306147, 0.845080366681803, 0.547225670352287, 0.871621259125167, 
0.810087244872131, 0.836253329480231, 0.908172733511627, 0.726596024473619, 
0.755786428913185, 0.84510267377862, 0.721518114228165, 0.923091278860278, 
0.904264943712132, 0.916636235763364, 0.405385269191814, 0.739500807857931, 
0.927200691908288, 0.941325215873374, 0.632823838756013, 0.741138815939045, 
0.876693350649385, 0.702458080219023, 0.824404877164417, 0.563134331961117, 
0.819470077693627, 0.959965882020001, 0.87828823952061, 0.30596951305499, 
0.574228736879184, 0.967282580595974, 0.971749063459694, 0.864328225571075, 
0.745492167421495, 0.862441409683606, 0.57103022899524, 0.59142647213139, 
0.842170343567418, 0.584937084490761, 0.700375968369337, 0.89861167895567, 
0.531986610734355, 0.801446212818311, 0.687429217049357, 0.780692134117102, 
0.481396300269485, 0.875872116184581, 0.945776638583249, 0.848090483917895, 
0.697851515009828, 0.908084317043207, 0.30626489130717, 0.707764225813036, 
0.737933708004474, 0.661013678358957, 0.957059292374143, 0.754319108154325, 
0.796080743107573, 0.926827683812082, 0.798006730413096, 0.613087358956519, 
0.800317659645869, 0.778230280292245, 0.77486863194148, 0.76911479753626, 
0.921521489873073, 0.892246009998947, 0.809166667151454, 0.867157016323434, 
0.88649376166203, 0.776663315454903, 0.690871677160051, 0.758906139386745, 
0.78549146595599, 0.91845223455952, 0.533278288774544, 0.816367874489673, 
0.87725890112571, 0.612023498400285, 0.888001605288109, 0.701688560242583, 
0.92366666856175, 0.728001977065606, 0.807248177383206, 0.981002807011034, 
0.851299780218617, 0.832089181937392, 0.48544309765936, 0.938597488391307, 
0.693129322977853, 0.800327655615258, 0.516477358754446, 0.888637279607782, 
0.582960243287587, 0.76360302951257, 0.90104423952612, 0.961944673842998, 
0.841858195886912, 0.755917285198696, 0.748266915140894, 0.442399601341543, 
0.857546201143658, 0.961970514756447, 0.846842177231646, 0.840139830856091, 
0.847989996020426, 0.721989444310242, 0.828473767260826, 0.526480508793425, 
0.928115123977016, 0.770215056531221, 0.739787974436626, 0.859363986238401, 
0.771428533401985, 0.897347158936195, 0.904115058035377, 0.886196582345925, 
0.893257109899717, 0.880403052308468, 0.887959340046414, 0.399182878244096, 
0.955473538746608, 0.879357172179897, 0.815022530423582, 0.876038598045555, 
0.874724745962142, 0.606274746339978, 0.853276631342871, 0.965526000485595, 
0.952572436813149, 0.808577325024162, 0.79518802114972, 0.612528642364894, 
0.849098701483146, 0.88303349313596, 0.914735023657573, 0.650570193781288, 
0.797308484729343, 0.980131370574459, 0.828176976357434, 0.909399229743798, 
0.960623448625601, 0.87281537765583, 0.687826661041356, 0.834335829916855, 
0.850574104581116, 0.737060879671855, 0.919144481924753, 0.813554215911434, 
0.79538014381973, -0.171369508693353, 0.583480975902407, 0.775695883762644, 
0.761653629859702, 0.981328224349676, 0.894257040663906, 0.975460020383981, 
0.556404550478805, 0.846533257646517, 0.713080177155814, 0.981609377326617, 
0.820783059742959, 0.926314253709694, 0.837654098890541, 0.911916942445047, 
0.932605533560048, 0.807566469093964, 0.902967934811762, 0.810489385035624, 
0.794192596518274, 0.685524855275684, 0.897933340046744, 0.261578103750601, 
0.924737711868881, 0.826150570640296, 0.945361719241541, 0.959116289551928, 
0.45485584550926, 0.94423908407313, 0.747354685952606, 0.939593080945785, 
0.824373105263437, 0.833167776170104, 0.771858706643637, 0.914624489533479, 
0.619710762251533, 0.948782092915649, 0.88178981400387, 0.7059535055899, 
0.877686172282822, 0.891807917990137, 0.413876360995634, 0.671489589695094, 
0.734531727758019, 0.84264392290602, 0.734310324212386, 0.935570527599021, 
0.70316353872849, 0.84667092333514, 0.851110888979286, 0.909778860109455, 
0.83947075791877, 0.838194010226624, 0.809669474738136, 0.462370415766428, 
0.846377372993611, 0.403762812981142, 0.672749936435603, 0.781378014821881, 
0.82494906430158, 0.880488091635354, 0.868389045674564, 0.92455681124362, 
0.786605794423467, 0.680239107848509, 0.881766985423185, 0.95638828873369, 
0.914084543757262, 0.854968456711754, 0.851613694932158, 0.991127267981789, 
0.96903573887329, 0.546336936044794, 0.910943391563612, 0.864727911494529, 
0.655305486415672, 0.868578956732252, 0.797158534959428, 0.820335243292718, 
0.70380667700433, 0.724903004738204, 0.701920686937608, 0.975172882913663, 
0.913361257589064, 0.76910494551723, 0.889761795804284, 0.926930909691923, 
0.513957723255725, 0.97551600154417, 0.885760312831887, 0.671387133188139, 
0.584077876509244, 0.828633101639834, 0.506044332504564, 0.98461436468538, 
0.932876372676039, 0.800494251012297, 0.850366328355677, 0.797050555605123, 
0.592802787539902, 0.749861734851672, 0.935484194724374, 0.982403197444512, 
0.654503211558307, 0.758008509199099, 0.830860297864499, 0.598005394000936, 
0.977563760594428, 0.902341086794443, 0.859867096281878, 0.873009091451006, 
0.841425758244918, 0.930129245123516, 0.650875207940592, 0.693314682042257, 
0.971152773973707, 0.959787112092786, 0.909257414231437, 0.662727989962066, 
0.922720359202643, 0.866579317418658, 0.510210773249335, 0.802775090349187, 
0.959453183568113, 0.91715990694301, 0.925141423805644, 0.836001158808866, 
0.807886650015771, 0.892989109341208, 0.79191532483471, 0.79758914575334, 
0.76099936581369, 0.941797559356723, 0.256400717264818, 0.710296417040528, 
0.495728598599242, 0.779850537946703, 0.767100714319539, 0.764806566325198, 
0.794804475933563, 0.53825842180268, 0.97676453135227, 0.875218819449687, 
0.859079095821164, 0.919499028729037, 0.749544694125483, 0.919857701436786, 
0.970483152437184, 0.556944810471042, 0.917112413528399, 0.789889618253607, 
0.845625733998511, 0.894554375657298, 0.806503184677269, 0.971366562982295, 
0.688917544173773, 0.690813524939486, 0.848406862967351, 0.795321049639657, 
0.860058283810187, 0.90291775494872, 0.921436827680291, 0.492657152183308, 
0.304742724103891, 0.755220899862729, 0.573364525206509, 0.565367718352472, 
0.90319943124927, 0.776547615692625, 0.622691984111235, 0.945910917664892, 
0.969140368303319, 0.87164691583547, 0.912064258722342, 0.95855837559181, 
0.830389879768086, 0.808513798512206, 0.895552451687826, 0.804505137908831, 
0.797463841717242, 0.545451251108626, 0.916319912872591, 0.552348247072078, 
0.90800066287201, 0.876744591425539, 0.953613401128566, 0.581732568665588, 
0.630562283297854, 0.845451323363391, 0.883755619235227, 0.83335202949332, 
0.933281686590254, 0.735815297902637, 0.836376494094405, 0.902131059159602, 
0.450254932285509, 0.257997778989117, 0.579002682575798, 0.692235676826195, 
0.831021795521527, 0.752743351530107, 0.808299441519177, 0.67701308701132, 
0.898225421244643, 0.779600571209695, 0.957341824537399, 0.643594455166847, 
0.345128796006624, 0.842721312633773, 0.833400567313956, 0.790196319229062, 
0.876552594112363, 0.620769588998991, 0.689685897791801, 0.66251307438328, 
0.807469962135056, 0.637799244652316, 0.737917469600762, 0.529848665009349, 
0.819987480487265, 0.84474581669675, 0.962408790383998, 0.831460313234112, 
0.868695211397131, 0.926731357377082, 0.562905612524361, 0.706801389922139, 
0.986524643562739, 0.750295814897312, 0.95183203879927, 0.755090874372747, 
0.987382505548802, 0.805547339432724, 0.906637206011828, 0.730665860705851, 
0.630825958323145, 0.927624639783837, 0.802154790129909, 0.94307659186688, 
0.919454496228641, 0.902468208088714, 0.581400511555289, 0.657171015145065, 
0.867940270082974, 0.81173942022165, 0.832474347297971, 0.751734287902531, 
0.934397646419404, 0.912667455226577, 0.119275137075411, 0.907887878075529, 
0.81303655562376, 0.960621509739706, 0.833254024722559, 0.766220113920968, 
0.807918555760617, 0.820813748599952, 0.87307212532717, 0.757781042016725, 
0.847911485188798, 0.95701315706185, 0.976850707189655, 0.959915969721193, 
0.919129716909817, 0.810217949195501, 0.945154324853159, 0.675992037948295, 
0.497137958885015, 0.904951875276646, 0.877242555123277, 0.634362380752894, 
0.819465816917479, 0.747073387222649, 0.94610277216757, 0.89960137465033, 
0.953967840632673, 0.992134020441963, 0.945082518826407, 0.831248550641646, 
0.663683731097787, 0.980677804680423, 0.768851329974207, 0.616678113582492, 
0.862416007641364, 0.721340625726568, 0.80902914978561, 0.77463842678793, 
0.604361612769544, 0.619395900083435, 0.684371396429536, 0.701945616090137, 
0.975978274521528, 0.376454430701208, 0.518530388275423, 0.78930862615577, 
0.787856772444048, 0.725168398480365, 0.964635354938989, 0.86549931748351, 
0.95240084168889, 0.895403625319615, 0.80673908946747, 0.860410675579981, 
0.941460461293987, 0.811964385507306, 0.985712138434957, 0.693073477896969, 
0.93584474278125, 0.87372461365447, 0.84741065969238, 0.811097253012916, 
0.740203065896047, 0.920011107098016, 0.977004927726552, 0.913088138706371, 
0.941941868394855, 0.773246212991952, 0.906285864826361, 0.679585396722608, 
0.713214412318311, 0.85191619565752, 0.892409514949816, 0.842096604270391, 
0.610912080196996, 0.911006840327431, 0.757656562969337, 0.665680117002567, 
0.98927578157385, 0.684141147105657, 0.9073797777264, 0.857522618967608, 
0.840602936844809, 0.695245409813004, 0.394570311971917, 0.824857323475016, 
0.549142260274711, 0.838185222779326, 0.897470918600518, 0.848154515963509, 
0.722579950446348, 0.784097736802561, 0.812978860705296, 0.342007109508881, 
0.832764524045985, 0.838350062016521, 0.69536241994359, 0.931071088235978, 
0.917633631916025, 0.822936158137683, 0.977099443900225, 0.567441062811101, 
0.74194509290161, 0.820469264253706, 0.861365131290103, 0.804797912976818, 
0.779626235883513, 0.712888418649202, 0.67060936750875, 0.647709437767421, 
0.91013939536023, 0.745554120022973, 0.816498933900684, 0.782432947823547, 
0.868704162275103, 0.961841438001265, 0.879029729540226, 0.883168120584125, 
0.93623519131865, 0.82669974430744, 0.850592453196454, 0.698293192626775, 
0.966324043192164, 0.905453216438768, 0.82176219752416, 0.751674824090079, 
0.92459040002689, 0.887128971173057, 0.927856511601081, 0.537747167098456, 
0.701127485384597, 0.947240891134508, 0.744896867275572, 0.808086714859682, 
0.385453743547523, 0.906431963491777, 0.741779513753631, 0.134204361015131, 
0.822350824156787, 0.732378992441536, 0.959388681581607, 0.634105181424363, 
0.959249530246532, 0.707522834856252, 0.967047133723233, 0.74567046653411, 
0.968400214278379, 0.882268669272671, 0.794803832856714, 0.507582809739833, 
0.875749299677666, 0.939077473140266, 0.685839314094046, 0.834419841542748, 
0.88916319966244, 0.112705368987576, 0.811397050486936, 0.77609209114672, 
0.663569299867556, 0.958673934479212, 0.815580035906742, 0.414212326482094, 
0.72871556140538, 0.85570447235799, 0.472858605688952, 0.666229506121045, 
0.96304624945259, 0.87300723152623, 0.749291532559914, 0.736735327594853, 
0.785261294973285, 0.678523818557765, 0.951018842616565, 0.676960198115724, 
0.859766816345307, 0.824011929212383, 0.775434603695583, 0.47874116658005, 
0.80254538463312, 0.96418617680387, 0.812284333681378, 0.837684624376962, 
0.675108800224413, 0.775496665075936, 0.73834163675877, 0.980568451289993, 
0.870238292132853, 0.765999843760197, 0.720535904980525, -0.0903126526297236, 
0.744182451818944, 0.738123906063424, 0.789542521425383, 0.784822185720589, 
0.68841750990615, 0.651336628844792, 0.585398756128749, 0.732385804233874, 
0.84513657938469, 0.893609005239587, 0.792841021915437, 0.93748495027677, 
0.823355897987956, 0.895782307023104, 0.715946512586187, 0.872312201210232, 
0.895611106831042, 0.747259685875695, 0.938320187847998, 0.889194112205086, 
0.764113728718516, 0.887410900788027, 0.299952127861338, 0.672106543112024, 
0.608401049525767, 0.862783083414614, 0.831952381216676, 0.959984783385635, 
0.850584897588603, 0.585484425140315, 0.72793517018267, 0.880283560394901, 
0.685807799936169, 0.800658946764672, 0.8983973226315, 0.896880397630202, 
0.848077246776325, 0.258873462591484, 0.944687920105893, 0.835072889953068, 
0.872009418896285, 0.966339154330073, 0.728025695980072, 0.773437497907934, 
0.627897873000694, 0.635157563116174, 0.674254056001916, 0.713494019839955, 
0.929440150520503, 0.890228116169532, 0.951671783319414, 0.69947482917401, 
0.853788894478987, 0.731555880734535, 0.93967686550591, 0.88406108096134, 
0.905930758231924, 0.791876125916312, 0.794855764255719, 0.741610020415561, 
0.410442772739866, 0.64244245197873, 0.823556767634022, 0.628627315175066, 
0.867098982446802, 0.878602811885578, 0.778663212010011, 0.897839247624391, 
0.942348726868187, 0.551854826241804, 0.856856879782577, 0.727442603790368, 
0.533722959503464, 0.860902756671239, 0.800894848948745, 0.759600709399991, 
0.60337977695338, 0.916015428303535, 0.949722281145323, 0.966967094571755, 
0.675202592327005, 0.785619064823783, 0.98696983949369, 0.720948892659051, 
0.904150420284078, 0.811540466280527, 0.94117036346698, 0.672429775017128, 
0.835034248582743, 0.67756679352994, 0.698944626194157, 0.921557853554803, 
0.698712145929278, 0.901700077521959, 0.911094775033957, 0.6510914313655, 
0.632738691763274, 0.917821568459951, 0.757964481520828, 0.810845614164645, 
0.85310402878438, 0.826285832437774, 0.503830365101483, 0.810278918032673, 
0.63611301953605, 0.958884850491727, 0.924613589407655, 0.538095868467288, 
0.924255797272805, 0.953561284673262, 0.697550817964698, 0.73322369855025, 
0.697490118782726, 0.688760454226694, 0.879281278290639, 0.739051126682976, 
0.931278859429253, 0.493963877723714, 0.865362675012613, 0.893678490663381, 
0.614395806937934, 0.81675798066077, 0.939416398111175, 0.914991759973632, 
0.888475586589303, 0.0645422252609624, 0.980806831314808, 0.85237060584851, 
0.721271735279669, 0.806428064313965, 0.960126308187825, 0.8779029299413, 
0.956180685609197, 0.967174805125153, 0.84648408703259, 0.917346840981179, 
0.841516819266637, 0.7111959981332, 0.464006565110011, 0.778810923352892, 
0.655823887524911, 0.881760957784042, 0.926608306853461, 0.709853112661126, 
0.898994694945482, 0.825589168862722, 0.933066633821807, 0.480771287961939, 
0.966022662900206, 0.885567354863739, 0.818015998768617, 0.717041022355559, 
0.825374733334925, 0.622318125039766, 0.935080569078752, 0.774662800269578, 
0.842599993576198, 0.935332803074878, 0.962740344494755, 0.456953318070825, 
0.901604500211747, 0.790411874213946, 0.399613618597848, 0.938825738924602, 
0.731010862112564, 0.92063315767361, 0.652055417189836, 0.721827486808152, 
0.91755464103793, 0.722261202609664, 0.764453135951604, 0.823585154661226, 
0.665665054112892, 0.949801382892703, 0.899026017109723, 0.89776918992008, 
0.934449016906887, 0.728733047582669, 0.726156582277918, 0.853297566334764, 
0.90740041304591, 0.926305937202071, 0.95277570927868, 0.783714396882413, 
0.631769700899267, 0.82620563547793, 0.61162057741462, 0.757494222349909, 
0.896205007762977, 0.757146737767296, 0.903383733245655, 0.929950381578897, 
0.570957348992918, 0.981692836443812, 0.478789817972445, 0.860193930511547, 
0.942177174908583, 0.85093034471024, 0.875058446823323, 0.858553663896536, 
0.483289785845907, 0.846699581415663, 0.666931165195603, 0.429280983180452, 
0.939208269805538, 0.993843808502179, 0.757480717567717, 0.78295343848839, 
0.973080368605317, 0.812805042724898, 0.693954401447335, 0.9860862220603, 
0.707721166156026, 0.766839536348867, 0.785230437472054, 0.61351052383725, 
0.905926426631243, 0.87658080266972, 0.908388850170133, 0.848295756840388, 
0.874672665318072, 0.896487854272817, 0.90528946903912, 0.756572420142668, 
0.93061390837626, 0.450425698675439, 0.683833333298328, 0.729084847486452, 
0.747924821694593, 0.731059085339126, 0.955194075637284, 0.959675374560183, 
0.752316650347201, 0.56191583763798, 0.627961216915975, 0.472792227795004, 
0.875174744339286, 0.651103398367245, 0.590005832920648, 0.973555357276988, 
0.822689003436694, 0.853260587229833, 0.832696538689635, 0.823573416694222, 
0.68762269180197, 0.910238492487735, 0.983868617981123, 0.963537272320445, 
0.938747316019153, 0.843085724486515, 0.985179330641892, 0.803919651195968, 
0.791752856717377, 0.865963367653954, 0.869854113834495, 0.894493557412758, 
0.498623656812141, 0.794406177357427, 0.94981848023433, 0.878712514415646, 
0.853598940613533, 0.880812084758554, 0.979154579677531, 0.98393521933423, 
0.943380563761114, 0.839059184726464, 0.944888453209083, 0.889149596147564, 
0.814012982013428, 0.880720000405941, 0.903827429240595, 0.898056917285483, 
0.658429599620301, 0.761346268169623, 0.818621847866622, 0.950180233781456, 
0.551181410773398, 0.793464796835712, 0.601114729413658, 0.941233383442034, 
0.76636471034343, 0.446493105079291, 0.922394067501206, 0.932614211649082, 
0.777997725072762, 0.908343203541978, 0.916060124417184, 0.613767121148878, 
0.962116081722242, 0.707776578438177, 0.956143564199546, 0.911055802829521, 
0.834288803805556, 0.530404562310963, 0.719155211210602, 0.550063377431548, 
0.882290916404464, 0.818963963377447, 0.67093895081309, 0.219762909342684, 
0.763545482119756, 0.899805835965201, 0.639516974043327, 0.7280187266844, 
0.589941088036327, 0.759809534076323, 0.735603164721408, 0.785276131182343, 
0.832979802610833, 0.851826605661907, 0.845581948347284, 0.92261827485969, 
0.82241879013123, 0.478497910141474, 0.95578675183916, 0.76245608147395, 
0.83060698714902, 0.709744738129208, 0.793922207044381, 0.813793227285503, 
0.810734231450039, 0.829885206006129, 0.554316803654904, 0.693040088988447, 
0.784076059451152, 0.886841807524371, 0.778167568309852, 0.834241775086201, 
0.931261223217076, 0.904386377140146, 0.520191225864243, 0.921508851907281, 
0.65772241016443, 0.924139250946911, 0.867879755945295, 0.841035440968895, 
0.8917846499553, 0.873187534960708, 0.869195827599597, 0.745680712355025, 
0.818341426282112, 0.777971959154629, 0.90080346514018, 0.741910357892674, 
0.979625764629577, 0.921852967143477, 0.760618033696976, 0.750946537120044, 
0.85079313096579, 0.61295841911327, 0.885462099387, 0.947772151337788, 
0.893341629282928, 0.888665990576858, 0.827519340530722, 0.79544584758043, 
0.964592894320804, 0.88024645832983, 0.89517045964468, 0.715309839284767, 
0.463938871538797, 0.781606578303443, 0.889164421260676, 0.848926420687613, 
0.855995808548726, 0.876655030842692, 0.868166041223565, 0.899109829735128, 
0.956892168274745, -0.135280723761238, 0.674043767426374, 0.865853927815926, 
0.911320938776202, 0.79843263036555, 0.358235434104976, 0.490990988530064, 
0.723988900604884, 0.674504559872804, 0.794677993920305, 0.820687644677267, 
0.742981379397442, 0.581611036713452, 0.725628267016609, 0.618845683839746, 
0.624743372506213, 0.589128503451134, 0.837915704134728, 0.471523803867622, 
0.813793380467206, 0.782966739917946, 0.686928451252176, 0.953048756636195, 
0.505288796140779, 0.778350081361476, 0.695223839213788, 0.930550735538362, 
0.912596628119842, 0.950364691280533, 0.91935602513094, 0.842191601125011, 
0.746877569757057, -0.971833510906561, -0.925793292163134, -0.856535817118806, 
-0.890715773138996, -0.969083091791605, -0.95271878563922, -0.871488010439565, 
-0.917079764810426, -0.963582588224982, -0.909185910355274, -0.941264743084465, 
-0.948452288577604, -0.942055656881829, -0.942915083717602, -0.930587472508597, 
-0.931701670457258, -0.889472105933133, -0.899279515342372, -0.981257441892532, 
-0.910665429156498, -0.925208953238681, -0.91345657254966, -0.905314332969553, 
-0.86609142248574, -0.877120148130374, -0.965815246294819, -0.95372376861819, 
-0.945550239927687, -0.894425792996672, -0.977759416352711, -0.877290897669978, 
-0.975101952489973, -0.92002574783329, -0.943577770345614, -0.860349384867953, 
-0.93265521495848, -0.975547379967118, -0.970728569574208, -0.96205774047822, 
-0.966813335621196, -0.950205987205857, -0.917823703155066, -0.936793083283984, 
-0.950327780470869, -0.899141232136944, -0.853178433409419, -0.916119139186451, 
-0.911724301629013, -0.878669139564998, -0.959836753275686, -0.957742393052889, 
-0.938513428870373, -0.940814096745996, -0.8539794483204, -0.92380026024732, 
-0.96494445461471, -0.95950355526419, -0.96064845891003, -0.960946166579712, 
-0.896445359200211, -0.892686863335285, -0.966339075066044, -0.960284941504107, 
-0.89317002580124, -0.907799210515052, -0.925889574302783, -0.904919852794544, 
-0.814567103926017, -0.95114370704596, -0.946069975359617, -0.954999364296572, 
-0.965919632758855, -0.922881885394026, -0.9505316907939, -0.909995908092586, 
-0.924075455993255, -0.910826812785823, -0.922203812931871, -0.817415762475432, 
-0.959766330579823, -0.976112700651937, -0.966987433860917, -0.973451030871703, 
-0.843656418352558, -0.876875950872926, -0.95732589871589, -0.95220814513787, 
-0.89178298959422, -0.858365203250032, -0.925133458283082, -0.90851300887905, 
-0.868201542241932, -0.883896268790514, -0.898507846696523, -0.932478602945258, 
-0.949973718603308, -0.927724392571541, -0.93234143555479, -0.81264475221178, 
-0.895932754170624, -0.946241068957343, -0.972465081809256, -0.968392842518875, 
-0.937747832241007, -0.951858949316238, -0.917899974556256, -0.96230981245731, 
-0.953131802411081, -0.834818165043016, -0.970385928963675, -0.922150574333949, 
-0.874589337710626, -0.884956787628138, -0.854133010820398, -0.963898208919007, 
-0.947814313656213, -0.95356024795348, -0.882343786924943, -0.876167946932006, 
-0.933739345172032, -0.901273462926242, -0.985669768391695, -0.903111931819682, 
-0.9543470843776, -0.974323627493745, -0.967759687583044, -0.915978967037103, 
-0.920927859876134, -0.958780059116017, -0.900943522637316, -0.929515699855939, 
-0.869719093746582, -0.921835586221839, -0.929394325638547, -0.969821999477455, 
-0.875252383127504, -0.975015067904277, -0.920152103670614, -0.891570127562257, 
-0.968859712363782, -0.864849132475052, -0.949183734050274, -0.947192559541688, 
-0.945715957286187, -0.96496685188289, -0.923221860762322, -0.921700682568917, 
-0.93540989768535, -0.92611413592949, -0.909168448723774, -0.912278735458656, 
-0.975469522843507, -0.879737040751535, -0.91212415048909, -0.950643405139013, 
-0.948139434799982, -0.900666452096707, -0.928154338356534, -0.961066197015291, 
-0.78849064294453, -0.942017510986467, -0.880064773292212, -0.966665036731328, 
-0.969889589481384, -0.922323421757954, -0.8640180034294, -0.873571133022176, 
-0.960963667198444, -0.852511364821296, -0.974372876362235, -0.806371862201917, 
-0.952956509014438, -0.8686117487856, -0.865305618549173, -0.881192504702552, 
-0.97933078852184, -0.928763560282424, -0.922292803824566, -0.968271261542348, 
-0.933331235945306, -0.903932276410418, -0.93662993613611, -0.883993111920175, 
-0.930244482588662, -0.952788093248982, -0.816984590078721, -0.919019050286471, 
-0.94976520220794, -0.919447820369586, -0.948463074471213, -0.93720125128585, 
-0.949038802755961, -0.943964531176504, -0.904732255586316, -0.968998924923758, 
-0.922487664859578, -0.954677730006425, -0.92605704034562, -0.823204824151277, 
-0.87056108346469, -0.946622300596612, -0.942876560296395, -0.90884209800866, 
-0.977249297981605, -0.930165516082761, -0.916928928254367, -0.817130262395463, 
-0.959475117771411, -0.944030424246438, -0.953665581368292, -0.960856798587032, 
-0.976413209571755, -0.928171601513736, -0.907054429998046, -0.934934345433432, 
-0.827437545650786, -0.948295787587912, -0.936777367563573, -0.978553591969716, 
-0.956625431896022, -0.928345402262303, -0.916558924038784, -0.912759032232621, 
-0.883205191216566, -0.96531509863879, -0.842320070443281, -0.935614427901178, 
-0.957056040562244, -0.973815374823272, -0.849515443626766, -0.908239132668826, 
-0.943074387009927, -0.884076227729331, -0.931451215732263, -0.972048471210233, 
-0.916557818661511, -0.97205245325533, -0.951684503709229, -0.924837516230278, 
-0.898875682107628, -0.924319009911903, -0.910002073486204, -0.918821493396163, 
-0.975100798823165, -0.907595262464343, -0.954292656490044, -0.980586961103867, 
-0.957644617701852, -0.933858277129782, -0.92963532810369, -0.885525951913827, 
-0.924009053936835, -0.912550951369963, -0.86291309781145, -0.921073141838576, 
-0.94907679928577, -0.924976292883828, -0.953225065588225, -0.94118674927887, 
-0.923742799865572, -0.938697080798215, -0.96129045105805, -0.889918690185038, 
-0.93631839461848, -0.936518802501445, -0.927054017913958, -0.902461943318932, 
-0.905502370121237, -0.95665621834954, -0.957450927211754, -0.920316907888785, 
-0.971809299988857, -0.938215550981902, -0.882522861161492, -0.922473104555927, 
-0.900914764244908, -0.945151361286492, -0.949546163761813, -0.928854602658957, 
-0.94076665550618, -0.920061578297069, -0.891884567854845, -0.838567080486107, 
-0.888602883739701, -0.842930688631515, -0.975179230000491, -0.950535225847946, 
-0.906144830950775, -0.910721932463081, -0.881302249007128, -0.95078705502547, 
-0.976598642366721, -0.981095755091512, -0.898392396157556, -0.926791021997917, 
-0.904839925287069, -0.8884995367577, -0.88502475348379, -0.93860300929371, 
-0.930446133574472, -0.97327316979891, -0.96811493208134, -0.957211122327236, 
-0.83160552899419, -0.90507601240843, -0.86770947434869, -0.946912586257764, 
-0.94955158482849, -0.919398075649314, -0.915644826251832, -0.824209023549516, 
-0.921341169261821, -0.933706569970307, -0.862815609846862, -0.904071353779984, 
-0.889391730407313, -0.928490916831213, -0.964526847880873, -0.917338537042075, 
-0.797842121304523, -0.883156068312616, -0.926745154415033, -0.959981252917427, 
-0.9097470235577, -0.86090981616148, -0.95086447815322, -0.937500305798633, 
-0.933196322771882, -0.924816568316427, -0.95446199595884, -0.957559708667677, 
-0.848900096529049, -0.946506904619933, -0.981121476378872, -0.948327159727442, 
-0.860834886451716, -0.971577099796898, -0.968101014119117, -0.911937612563466, 
-0.964218975320102, -0.940579022716302, -0.932255040188701, -0.91416487963196, 
-0.912160591138109, -0.894008031200262, -0.961719658866259, -0.901761881673304, 
-0.905027227383873, -0.826680974622537, -0.898600737437456, -0.926826138762095, 
-0.91901360728486, -0.971151072869174, -0.929378914176235, -0.87125147826568, 
-0.825804165281824, -0.907722741057126, -0.96733106797717, -0.935178361785507, 
-0.896818131949428, -0.93551941679023, -0.932913437943825, -0.921371865238648, 
-0.849052613862488, -0.95624246529934, -0.92006267579443, -0.942967800912687, 
-0.972965410080087, -0.928308608429126, -0.923822267983798, -0.954279737258462, 
-0.92788758697541, -0.923679647872767, -0.981039936601581, -0.85922579669797, 
-0.953154361606278, -0.976426189380872, -0.959746932976623, -0.919627433700203, 
-0.837787374575748, -0.942695240307834, -0.945741186686787, -0.90868634021181, 
-0.962792019214944, -0.931412338188426, -0.905237424878164, -0.833175895254076, 
-0.96590914957976, -0.90942200717108, -0.895938875984374, -0.882722878699873, 
-0.962034230518795, -0.973415733296265, -0.936766408039963, -0.85066556933611, 
-0.901012260535317, -0.89719912430988, -0.919201970158833, -0.930442754336737, 
-0.922938663248883, -0.897127888959449, -0.852145273724891, -0.887717599402958, 
-0.914197038277933, -0.976511530640426, -0.953458977941938, -0.944556165015033, 
-0.929881081567668, -0.948404319145242, -0.82392648246756, -0.9332335415697, 
-0.955828875939795, -0.869640588260323, -0.984132654358225, -0.910207423727181, 
-0.968533287494036, -0.934251451074307, -0.922114217620022, -0.841965401800717, 
-0.91388819028128, -0.900500541316642, -0.978536021060017, -0.944180699866123, 
-0.93459959310507, -0.925796777889142, -0.889062327755965, -0.823808286434559, 
-0.97246802764078, -0.95735896159806, -0.923897542799114, -0.967442481531112, 
-0.852269491395795, -0.953065899058471, -0.915167147660939, -0.894653918589323, 
-0.934370572801057, -0.859191360816221, -0.882504738866376, -0.842944202586322, 
-0.920680667095067, -0.949910387162665, -0.924010579721804, -0.917690692963143, 
-0.8689976125454, -0.855214021106476, -0.90388996075503, -0.960544895105372, 
-0.901931187922643, -0.913816323093509, -0.955385097667304, -0.972473798434529, 
-0.93484474954383, -0.984653120308417, -0.944062297060313, -0.904865181406622, 
-0.977766740958642, -0.943332218413643, -0.924690353267028, -0.953752277987126, 
-0.944055407561643, -0.892336183424015, -0.88087808754289, -0.922312947359487, 
-0.860155089142602, -0.873890184971633, -0.91695200287036, -0.967908012716897, 
-0.965079883476163, -0.956205208833211, -0.93904415662482, -0.980268474826747, 
-0.892684301464025, -0.949991708955012, -0.874126915061558, -0.959429829968235, 
-0.96659087716939, -0.914397518668701, -0.890891206461723, -0.878326398202661, 
-0.816590769915728, -0.961484062099407, -0.945783027810317, -0.934705825727187, 
-0.980408227312388, -0.927866335736548, -0.914422044541896, -0.962148588331805, 
-0.896970672937426, -0.877585987935144, -0.887734243176361, -0.868798240482791, 
-0.92197637025081, -0.953114954085631, -0.947228192487872, -0.95390632932918, 
-0.898890484333783, -0.923656708499548, -0.944660176666258, -0.960568525662401, 
-0.936424936439322, -0.946287108462843, -0.92458202780563, -0.980098471154093, 
-0.828136373858334, -0.929102823491907, -0.93087161725671, -0.966445245071724, 
-0.947593185850802, -0.96502412012459, -0.884419695186816, -0.941355053129483, 
-0.979522292070702, -0.949917944745295, -0.921722774548359, -0.825126886768575, 
-0.957254996176708, -0.915758366924681, -0.913897504482248, -0.973318492450308, 
-0.950032664645943, -0.878741431941976, -0.83364818802102, -0.97148690608089, 
-0.932676706871955, -0.895039117508008, -0.903051112754688, -0.990352776589821, 
-0.773246131304939, -0.96958414223451, -0.902153685891488, -0.920953671582058, 
-0.853292974491515, -0.945166705615862, -0.981736862948503, -0.860715714096048, 
-0.954693212006722, -0.921295430175718, -0.890855888203091, -0.892428861727499, 
-0.945102319935692, -0.956466479654993, -0.957060234984721, -0.970943483446481, 
-0.917804547816762, -0.928218346219316, -0.959128785064595, -0.969927515546465, 
-0.873224490009413, -0.924871431450981, -0.815004181799527, -0.944105519865483, 
-0.96266284222268, -0.940497301967446, -0.910177489260983, -0.883821965997239, 
-0.911467905174719, -0.951287419782353, -0.955749853173503, -0.88673464378735, 
-0.96169860763795, -0.9579095091408, -0.943034824753502, -0.920284952793384, 
-0.966486501109803, -0.924063604827551, -0.880484256274827, -0.888817601564357, 
-0.90965479732678, -0.933199613170555, -0.962305958087304, -0.94525821818632, 
-0.863414616123038, -0.931665151349572, -0.844084531441957, -0.947430126136467, 
-0.924865538144747, -0.877948162315006, -0.883768196583698, -0.937198898754469, 
-0.926982197261323, -0.872596036317813, -0.96465190150071, -0.940389352971723, 
-0.866553598090397, -0.907200877561141, -0.926301305084133, -0.880861931417552, 
-0.868360619557379, -0.90839051609701, -0.943138976955102, -0.89281874152743, 
-0.868525417926719, -0.936471855778712, -0.911395145663467, -0.923424983326271, 
-0.942100732401414, -0.937007299951726, -0.908137813913895, -0.974251994290132, 
-0.873299758182667, -0.956491924892107, -0.750865826297804, -0.936000578962349, 
-0.893760730892, -0.874315181822037, -0.93133327832155, -0.964014208661845, 
-0.961760348114616, -0.94270961511324, -0.967977795399708, -0.913830068379308, 
-0.923778810267684, -0.925349543261242, -0.913084424661054, -0.97414768000501, 
-0.947676878672867, -0.899488334586788, -0.942953389192681, -0.9563258866229, 
-0.95059469425079, -0.93790697192182, -0.944494199452061, -0.798618142928563, 
-0.936169264015119, -0.947439441417117, -0.96602800718648, -0.928037829853032, 
-0.927806770438505, -0.837016522871055, -0.939874383693, -0.94882977595148, 
-0.979965408197048, -0.924346101794527, -0.964557085313578, -0.924243232416832, 
-0.945186746632586, -0.93400484372989, -0.920677199566104, -0.978377396088898, 
-0.914669217003955, -0.853040722680886, -0.982835305051932, -0.970574120328028, 
-0.914407561294743, -0.92167500461569, -0.875221745044142, -0.958733462533869, 
-0.882553257184477, -0.949726933228367, -0.964259860660867, -0.907683057533545, 
-0.949606932242366, -0.915340827530402, -0.939054919733492, -0.843175118040106, 
-0.96109701102153, -0.849785234765005, -0.94634399552285, -0.932260206514442, 
-0.94811611085441, -0.88605607880089, -0.946686810846738, -0.959733234667052, 
-0.894619126953564, -0.95104735845195, -0.931262503241174, -0.946960275362376, 
-0.800137569586991, -0.903105635577755, -0.958616247625103, -0.964160516370099, 
-0.90039823967174, -0.925845490621624, -0.935701075178048, -0.90868490584873, 
-0.94725516080363, -0.94780243955658, -0.87479675499022, -0.875829621079603, 
-0.928507550150307, -0.958902308656671, -0.905483577745227, -0.91988009688131, 
-0.952473076674057, -0.970475014553413, -0.82603259217684, -0.942464006202612, 
-0.949660001944487, -0.897961596134438, -0.812108680349654, -0.922319189798467, 
-0.96783056197802, -0.879942853048423, -0.950833150796714, -0.905359746955623, 
-0.927485406181058, -0.863289537361555, -0.963514210853955, -0.952169152390527, 
-0.939201888834256, -0.931863390203613, -0.957043432921002, -0.929833572278509, 
-0.919349972811189, -0.94217940604752, -0.86035498206218, -0.91856948869369, 
-0.940563821885463, -0.907371607247813, -0.958441557986446, -0.98686729526129, 
-0.954536510756926, -0.932434833839696, -0.950289121885277, -0.908929446732938, 
-0.945294539684994, -0.938999702064354, -0.960087933659892, -0.935676894888153, 
-0.939499767648397, -0.976382027504085, -0.888444320785036, -0.934790934008934, 
-0.950926209493835, -0.921944228197516, -0.935281814036494, -0.973210185104634, 
-0.890724051889927, -0.934115367830086, -0.957301357364635, -0.957375031087527, 
-0.956619224131266, -0.916848391596272, -0.876657835183987, -0.95332172469333, 
-0.93052405238048, -0.918418699887077, -0.989158841047824, -0.891131377422296, 
-0.955137934373844, -0.978037758457995, -0.924136663700076, -0.945719956105698, 
-0.917430076504251, -0.932588575305978, -0.846538372183205, -0.90417668390556, 
-0.869442416122317, -0.940596402921347, -0.884595750709675, -0.942781716451391, 
-0.863801285823668, -0.946562823846077, -0.830252485567924, -0.725294376957014, 
-0.90504285160617, -0.845252714449395, -0.88487688326102, -0.95244220723474, 
-0.918658307269343, -0.958811103073175, -0.81906885865544, -0.905106972566501, 
-0.925938740120346, -0.80097663631483, -0.939385458632887, -0.943680700066816, 
-0.980467788894352, -0.831108257853925, -0.984983392107155, -0.927379018650165, 
-0.906032899864802, -0.93201441302284, -0.909300663261856, -0.842340347836516, 
-0.941712479362722, -0.90734472603865, -0.930482974863093, -0.92467417124791, 
-0.938350046310343, -0.848056479378959, -0.840985348727626, -0.974141811152053, 
-0.921774641298685, -0.843780542633657, -0.93838982055656, -0.866346632346753, 
-0.965740895276725, -0.925846822315945, -0.95889697742896, -0.95428673852799, 
-0.901881840637627, -0.973583956040632, -0.973615551897885, -0.935155364774845, 
-0.850577378316152, -0.965101594926052, -0.918508981193373, -0.919808055092325, 
-0.839202111560554, -0.861769099523647, -0.9563284203662, -0.90197744357942, 
-0.957311521040221, -0.9527056827395, -0.973347378319917, -0.829606692254945, 
-0.923888805114067, -0.943366843705467, -0.885131552183646, -0.970382936388116, 
-0.90410324205956, -0.899073559625732, -0.91567337684054, -0.848339992014173, 
-0.944440997575704, -0.918663882907837, -0.900130682994446, -0.960098945691538, 
-0.965973121116268, -0.968847445235487, -0.920541440411166, -0.94737336316770, 
-0.907986378433583, -0.91282127887582, -0.911015019748892, -0.897408771788237, 
-0.909538975793068, -0.877370908102135, -0.974319565436727, -0.953959654070336, 
-0.833353754745304, -0.907248100534613, -0.958860532125691, -0.935589661397886, 
-0.97336091518064, -0.816629538307392, -0.922004607079116, -0.925361542264259, 
-0.968458894246189, -0.969457532097264, -0.947879036439074, -0.915150589162226, 
-0.832087512553727, -0.935977886072045, -0.951420090942576, -0.95391735784886, 
-0.959760415665059, -0.864042554185404, -0.896546824909145, -0.918770554031801, 
-0.931712465755567, -0.9472133804565, -0.941967865288279, -0.879070992167592, 
-0.912191288623522, -0.819298170393167, -0.82120884379705, -0.886719297187466, 
-0.954316722022583, -0.820530726886858, -0.952913264173846, -0.924446021271621, 
-0.923108929396388, -0.888887144463356, -0.961197366918308, -0.914231857845969, 
-0.973419282610675, -0.874541817943736, -0.89170161548419, -0.966445809237834, 
-0.888315219256832, -0.867424889218186, -0.888273278941553, -0.93976654944536, 
-0.883518007706239, -0.921673237949473, -0.857417696301866, -0.918337045692952, 
-0.94328945812186, -0.95992051650383, -0.9631028319574, -0.964925312281418, 
-0.899140589797634, -0.944540660769594, -0.95222415462048, -0.905578252512444, 
-0.916377306946098, -0.893408425706345, -0.875546880842019, -0.852300676066964, 
-0.928146720289537, -0.918953241093249, -0.945279758420554, -0.912779704202473, 
-0.838910884323206, -0.897684830021167, -0.910268081007058, -0.941924016225837, 
-0.942954319669738, -0.881854467361617, -0.94795478055899, -0.955649997660776, 
-0.940911786519327, -0.965519292276487, -0.946793822822044, -0.97379709023631, 
-0.976307800631242, -0.843581360922323, -0.911227501547914, -0.940887898635125, 
-0.778541721437353, -0.928264308929513, -0.96241455011144, -0.927607488724993, 
-0.962992007012832, -0.978818331742758, -0.967919828418833, -0.981427704137188, 
-0.96774540016665, -0.91678958329436, -0.915256987781428, -0.915532012651814, 
-0.953535229119367, -0.959838858047113, -0.95310246750827, -0.969644644286263, 
-0.908735988797804, -0.96864472715075, -0.955708892047223, -0.918378914084917, 
-0.957111112438771, -0.947290740075946, -0.949904398668466, -0.912373959332919, 
-0.940077326687276, -0.955711477377826, -0.937588975672346, -0.883945797674501, 
-0.884668637783828, -0.959588114638466, -0.920091970598638, -0.89065162031291, 
-0.936465103590185, -0.920489714206104, -0.971366806079545, -0.916068970055129, 
-0.96495386328069, -0.921926621939482, -0.988667824632916, -0.9258595600801, 
-0.819546433046005, -0.89122035202994, -0.922379013456468, -0.925563461053479, 
-0.96849098111464, -0.836629936630587, -0.968794356579587, -0.866709081043626, 
-0.91631656004154, -0.95436866390081, -0.925622767419603, -0.880569908882553, 
-0.979163670863207, -0.936293556183124, -0.91989754166237, -0.81049357602453, 
-0.924737405229952, -0.835428975697257, -0.877569486556206, -0.880890088462153, 
-0.887517124398922, -0.941030336941037, -0.930493767465207, -0.909138216442866, 
-0.897637841191594, -0.932460259185126, -0.808715298014231, -0.957813556800382, 
-0.90489320124586, -0.92897067939925, -0.915820727547424, -0.888724818075057, 
-0.940712763587137, -0.94573175555756, -0.94008991223003, -0.945338614594466, 
-0.96897429884122, -0.896112997619747, -0.948090643838857, -0.916278976832503, 
-0.868373994827657, -0.927656080727702, -0.919098434852885, -0.942128606280332, 
-0.951522781282375, -0.925504419036006, -0.913918903502978, -0.94502455657281, 
-0.895437343272465, -0.91027176186001, -0.951088573005889, -0.899406100687994, 
-0.939186938394283, -0.902432989377445, -0.815663458849276, -0.910688988421274, 
-0.843723655121133, -0.869991193728619, -0.900273130758489, -0.923422347675756, 
-0.792323261543618, -0.702542882826307, -0.882159169354863, -0.840985272573046, 
-0.865403467311678, -0.920871556530545, -0.807354170929046, -0.803844776303711, 
-0.827993750251676, -0.806234876974753, -0.786915370595558, -0.746810773999143, 
-0.889421116563165, -0.931971443981027, -0.890860788297186, -0.897159173375855, 
-0.839562091403459, -0.81514591073668, -0.895141333733, -0.812561170165679, 
-0.939365450369378, -0.851749408990767, -0.924397894774086, -0.913539819136824, 
-0.744506538845342, -0.927816159472167, -0.888504941834189, -0.89705371727859, 
-0.872184988267726, -0.797458474668234, -0.85952010635553, -0.918537225407231, 
-0.854046707721094, -0.876754435180067, -0.80199669047232, -0.901363251469084, 
-0.862381760817005, -0.918371817559607, -0.941386759265096, -0.908446590928222, 
-0.842074982898927, -0.958594234200913, -0.923528457030596, -0.797143781661162, 
-0.78629870244685, -0.942849724529361, -0.909359617988998, -0.853381322912333, 
-0.901290921922553, -0.896090086852655, -0.8317318263651, -0.902150102732523, 
-0.965606664027598, -0.84053216080783, -0.861183735498646, -0.8065404029643, 
-0.802582183815303, -0.93010398273475, -0.857621864187717, -0.738540380102631, 
-0.834261672109038, -0.927415133834446, -0.81119492825374, -0.8144285617975, 
-0.987845136263147, -0.787732832944455, -0.771461829600055, -0.890888505484809, 
-0.882005117667375, -0.87942898137949, -0.772243594965277, -0.837981324618818, 
-0.97476741203513, -0.837385881665221, -0.826315093820666, -0.731966569169254, 
-0.754160211848263, -0.868826621790984, -0.89109116400127, -0.955144792392516, 
-0.855830478356317, -0.935398103656575, -0.77617597712475, -0.87923928091604, 
-0.883330344997882, -0.913172189576705, -0.844167440701713, -0.925009445528344, 
-0.843248167370203, -0.880920430470794, -0.829741802700128, -0.828342792154399, 
-0.887241698376491, -0.852397420289958, -0.858465835705658, -0.86788583877751, 
-0.850426688961771, -0.8539360924834, -0.8620835004416, -0.791990386265235, 
-0.765116271890448, -0.92266345315197, -0.943985100731853, -0.84956188732909, 
-0.765838951406351, -0.904310716557854, -0.661130935164144, -0.885114723376716, 
-0.597689380141336, -0.829052434989378, -0.930534929142158, -0.931607466551234, 
-0.91238901316269, -0.877022851844664, -0.747305060273928, -0.85641286624639, 
-0.888764167529904, -0.836816003600168, -0.743045084355377, -0.850773409894098, 
-0.917201757182144, -0.837986281525913, -0.807912377316818, -0.942067746499509, 
-0.86005054797354, -0.872171397630748, -0.81944171961881, -0.907503108930574, 
-0.893241358528562, -0.936790557895091, -0.856368519505441, -0.754673189748489, 
-0.921217620643903, -0.895550817258282, -0.90926253702003, -0.95843905124102, 
-0.815789296560218, -0.887605437252446, -0.860982679391838, -0.791790300322259, 
-0.77707339668715, -0.871069424865901, -0.905390804277702, -0.87234679372798, 
-0.81193688418304, -0.896136105391872, -0.814655619539114, -0.937930621505333, 
-0.856316175065852, -0.872092745958287, -0.909223438258818, -0.854242574059494, 
-0.854013171771342, -0.857077145584934, -0.794090159858688, -0.544020612021487, 
-0.94488993233341, -0.967075714830187, -0.875035204972882, -0.844538806099143, 
-0.82067676134514, -0.889865506129971, -0.86790318543578, -0.763087244846745, 
-0.805834527011099, -0.815313074039337, -0.837094034377167, -0.935048154081137, 
-0.815354206801786, -0.792249146043603, -0.953473701992839, -0.922182309954071, 
-0.891660148809245, -0.858009815686421, -0.928698230521582, -0.909874770629427, 
-0.923977051307118, -0.849749443550585, -0.910827556261399, -0.826947032579275, 
-0.74707093389016, -0.8983930347923, -0.80274058759284, -0.861364936798595, 
-0.90558901330687, -0.913853884931265, -0.749745979596918, -0.94270824469780, 
-0.898024839795858, -0.847932193893023, -0.770393511219412, -0.81923790288434, 
-0.76036102605007, -0.718948730449795, -0.89428126316344, -0.783025728341778, 
-0.909391777947231, -0.677144935575634, -0.836182653419305, -0.839629158313167, 
-0.816359407292527, -0.924676297380646, -0.804057338149171, -0.890995839224934, 
-0.854678223420578, -0.92502839385352, -0.85195041596505, -0.787203109496802, 
-0.922345207447194, -0.795922012175873, -0.929112648567501, -0.86105246840298, 
-0.964361162880139, -0.935024916112038, -0.900378964334838, -0.894333859992579, 
-0.951131194576836, -0.852783231578363, -0.869143172084916, -0.906168889991636, 
-0.713926244879821, -0.89970827947356, -0.892030566949974, -0.858496189861578, 
-0.851675442194035, -0.810711311625337, -0.95095161091233, -0.94924965529154, 
-0.86506729675453, -0.786517978450094, -0.824308520952065, -0.931077363434386, 
-0.893034051375442, -0.913816962323138, -0.929436474333872, -0.954316447254906, 
-0.846456737096687, -0.886185014301233, -0.843317703966589, -0.802765478240283, 
-0.845738673253728, -0.78324080916764, -0.915174680489023, -0.836362693870458, 
-0.877044655791416, -0.8586473406479, -0.761181173496325, -0.922134245299858, 
-0.869635602165313, -0.901085748335026, -0.84104764003908, -0.845244774086148, 
-0.914475826906166, -0.773585032002882, -0.891024878987029, -0.919819843365684, 
-0.875238982531713, -0.95004161918638, -0.859731317542908, -0.841153399736026, 
-0.828034929020217, -0.825738484450752, -0.89765521662259, -0.896847467971984, 
-0.96879749176973, -0.837579462423845, -0.818861187937163, -0.827359205121498, 
-0.871215439721395, -0.880742351086995, -0.890491132366424, -0.883817474069218, 
-0.898443021841668, -0.673412526842357, -0.867684793983215, -0.86708598854394, 
-0.843475545153874, -0.940117405326073, -0.948035097690203, -0.864541706546332, 
-0.89224960747713, -0.918292013888879, -0.86163135728756, -0.936450769769508, 
-0.88535239306695, -0.852435122695395, -0.842558200878368, -0.896154030446713, 
-0.88913686375604, -0.870436557817255, -0.876586079887466, -0.852445144046111, 
-0.880778448708582, -0.786978174838356, -0.81419326155768, -0.82087466907161, 
-0.801917199487735, -0.922231148268346, -0.948256444191381, -0.893573136773918, 
-0.840863306554411, -0.822296791986047, -0.852495987170645, -0.903709956710516, 
-0.888850785966701, -0.897865062859885, -0.901398501254962, -0.783264517107247, 
-0.85326260757075, -0.753482559523869, -0.91552834975871, -0.89746959143527, 
-0.909755330811062, -0.822573704208066, -0.786972395105185, -0.896260369509333, 
-0.877562825807666, -0.83900655149462, -0.880303859938203, -0.893966005652095, 
-0.776899419844141, -0.930646357171798, -0.925398525986826, -0.910801117229879, 
-0.974151819701482, -0.93465455097491, -0.828286731733898, -0.907334763567687, 
-0.840776975611015, -0.957505183638357, -0.87876586499407, -0.82735691922362, 
-0.884640745824873, -0.855694156700225, -0.858043513545318, -0.843852568441302, 
-0.86295515367421, -0.86510426419216, -0.872379535255627, -0.827489308691241, 
-0.919864638960582, -0.813534295234827, -0.967296708403378, -0.894736074005732, 
-0.890773518085585, -0.885054649710295, -0.81299102582377, -0.933271218832421, 
-0.845508767499805, -0.732792328786382, -0.730524778141466, -0.794730087326161, 
-0.85032851602307, -0.86308171336905, -0.910154938750358, -0.911257795419631, 
-0.92604121338201, -0.882446939103515, -0.83237776623373, -0.802163070643253, 
-0.839798362015243, -0.837974684546714, -0.839293901785979, -0.906964403009813, 
-0.965095344661755, -0.79809177825563, -0.880844200899793, -0.885435346352937, 
-0.7835851631122, -0.841192481113955, -0.794537674070534, -0.866366117487041, 
-0.930238870184976, -0.876722586229896, -0.910024361529877, -0.883750583153391, 
-0.89351714093951, -0.783103643616004, -0.809528555832021, -0.936074217077497, 
-0.941785186165344, -0.921959826523446, -0.708389449668711, -0.865789943266817, 
-0.887543669767994, -0.868991492033954, -0.73128678504344, -0.735129385842109, 
-0.797157402328903, -0.685440822768935, -0.780978121108918, -0.82231968227452, 
-0.856453678399052, -0.898764732698651, -0.828747079487568, -0.76208476249346, 
-0.867106878242056, -0.881483775092972, -0.753869734461412, -0.816822305968946, 
-0.884840411781049, -0.864765506927934, -0.886488322788896, -0.818193136173057, 
-0.82500934243076, -0.890536884711278, -0.868052721862406, -0.878862946381104, 
-0.894542382888076, -0.887137535478301, -0.887559798467637, -0.620578834705594, 
-0.871257163001215, -0.865369532478343, -0.862941837609962, -0.839224532907042, 
-0.938619923548683, -0.801669403328217, -0.825496900075493, -0.928162414524, 
-0.78762736682524, -0.85571341287473, -0.852853631117037, -0.920095743700159, 
-0.827529422331456, -0.914290680338403, -0.75889549074218, -0.747641010813094, 
-0.743449913192255, -0.803752874074256, -0.737033502943135, -0.883048025164117, 
-0.903274648956688, -0.922930875418004, -0.737208870229282, -0.817075282341728, 
-0.943132016362724, -0.814615726189135, -0.894180141536796, -0.847496914115508, 
-0.886305938297469, -0.887660525095838, -0.825251117791227, -0.964890588986478, 
-0.900309069311438, -0.878596997048782, -0.784528971987424, -0.898240390564597, 
-0.881474085653904, -0.694073504208742, -0.807046933421925, -0.705933379237644, 
-0.979424123935214, -0.858206854641184, -0.912900050190192, -0.921861651415088, 
-0.839917479189801, -0.854863222882113, -0.859606310090366, -0.94539047156292, 
-0.874785855838342, -0.90493018123835, -0.864026383044348, -0.835584361179297, 
-0.815542435023649, -0.698780494046113, -0.973494118313092, -0.906317466442479, 
-0.868446785619876, -0.959469348549997, -0.884551110749314, -0.925849036695483, 
-0.841188939425382, -0.913581943254166, -0.845521094454803, -0.883281269384455, 
-0.877503132007388, -0.90246085441177, -0.925882759195773, -0.81393623354214, 
-0.86158987430925, -0.80610697904409, -0.851980551920659, -0.834995400464688, 
-0.93528960904799, -0.633062334817631, -0.898580203515476, -0.939121073396328, 
-0.864753431136323, -0.848586269126734, -0.932071420085889, -0.898333456581703, 
-0.829849207312408, -0.834573591072932, -0.913133972506072, -0.914377632825257, 
-0.881584867366574, -0.951517329306203, -0.825075765646575, -0.875640333012481, 
-0.858394910132838, -0.95858874078383, -0.885312690806435, -0.929007514458402, 
-0.836793121214279, -0.857173487746872, -0.90528899657689, -0.94128802434483, 
-0.903619150397528, -0.83016980942886, -0.843435592967005, -0.88256360360162, 
-0.876040850193085, -0.849248510998334, -0.857751265630381, -0.87613697912948, 
-0.851749458741636, -0.82655713772042, -0.945256308096627, -0.919997752722344, 
-0.798670070009657, -0.884054126968786, -0.911940108375853, -0.758318448283448, 
-0.89154205125383, -0.901863642526494, -0.918844240222137, -0.896251086666409, 
-0.8053106681484, -0.950650735652357, -0.919315540356163, -0.877385714911208, 
-0.858395339019444, -0.91212727180333, -0.917214791892662, -0.719215813215398, 
-0.766724801652683, -0.84006095137664, -0.86059572710306, -0.887046396155721, 
-0.94177376965220, -0.795582837692674, -0.843490128587544, -0.892091031041796, 
-0.897240460761839, -0.766977910965996, -0.923571396293278, -0.760504762788808, 
-0.921892639627959, -0.680827129580553, -0.806131621765424, -0.801263093040536, 
-0.919283500866587, -0.929211275312946, -0.874688422705953, -0.868681247891967, 
-0.892852853270038, -0.914385616436962, -0.86551365513138, -0.925265146324077, 
-0.864361944096877, -0.922063880085017, -0.927297508158917, -0.870755002887587, 
-0.680587954931424, -0.896647895100588, -0.950757621367661, -0.904929908846882, 
-0.738212001638234, -0.746770915144076, -0.76033597589388, -0.906447470265265, 
-0.929498049602958, -0.920094037401682, -0.87059450765748, -0.909661407162515, 
-0.823966113328599, -0.878727836076702, -0.879844000352183, -0.948652149140115, 
-0.9215715475058, -0.908913594081408, -0.692093157798859, -0.842086692222129, 
-0.921016246157496, -0.884578335035626, -0.81832770126381, -0.826082416230535, 
-0.827714259825993, -0.91875521486531, -0.817739392564101, -0.67171828681703, 
-0.813990685032325, -0.798856899507473, -0.946076168687434, -0.730111445822887, 
-0.840218647238096, -0.848097447589664, -0.865190128981785, -0.858987991965076, 
-0.84567395893794, -0.799897366346235, -0.916213778152614, -0.843068583101137, 
-0.897991415151136, -0.899780244299592, -0.893570204525553, -0.897136409052793, 
-0.79145830382569, -0.85580730165194, -0.945841749238705, -0.868429501673309, 
-0.917156116711548, -0.874056761642943, -0.9509573067657, -0.677656156771443, 
-0.661640485900114, -0.842117806761708, -0.921172748842807, -0.883276255629985, 
-0.833048423958817, -0.738246190426561, -0.756034357404646, -0.845268207271418, 
-0.904155502673949, -0.835914064656629, -0.734610048758033, -0.81403555808709, 
-0.894713719848079, -0.894982147894224, -0.849710852347108, -0.933849214765761, 
-0.950120892968051, -0.955686406608596, -0.93607509407509, -0.90662180886725, 
-0.79041517038538, -0.802324024448962, -0.96236747053133, -0.924972600174352, 
-0.871812361419585, -0.938099141319911, -0.83914307543497, -0.883594427202267, 
-0.879302634538027, -0.848654331708641, -0.898952942482729, -0.813504295139536, 
-0.978044792543501, -0.899892660954044, -0.918294581925578, -0.844817993414196, 
-0.88668286503123, -0.8889933025304, -0.915025637759934, -0.873068887473285, 
-0.73881685504524, -0.957312200779218, -0.88162397311847, -0.72322220229313, 
-0.889349718469708, -0.697076708624022, -0.72936036412598, -0.970068793334464, 
-0.935593451022697, -0.836151955678927, -0.878599388257377, -0.918953704985583, 
-0.758955078649777, -0.921039600591126, -0.752735805159752, -0.691106539068316, 
-0.866366153341393, -0.79714485520853, -0.814448812569865, -0.846091006415162, 
-0.860376649005454, -0.855745839783636, -0.863229301090881, -0.839577345728237, 
-0.637559534227973, -0.915049168000495, -0.886766038380507, -0.85427876142935, 
-0.89440052426182, -0.882136005380534, -0.923930752886207, -0.877402338585207, 
-0.863334821066583, -0.865167867258401, -0.885173028726873, -0.815775185417453, 
-0.79979186438332, -0.871135801661264, -0.772073994239638, -0.707812929101628, 
-0.894936627947426, -0.833648851917634, -0.84428292180155, -0.891872024821432, 
-0.75557912178606, -0.905263074833298, -0.898926964531853, -0.943712605799624, 
-0.786221683355043, -0.837557497676269, -0.919722348110441, -0.825833641841458, 
-0.869750486277567, -0.841415303122877, -0.880534386268355, -0.871848217015507, 
-0.888375190115367, -0.823775382760961, -0.835280342281303, -0.946606968603403, 
-0.90997536258747, -0.8832649413262, -0.886685501535154, -0.815512188551497, 
-0.841517643663803, -0.869003144894542, -0.838924259442377, -0.912816545059438, 
-0.831759899120623, -0.793105608333846, -0.869262103433335, -0.93581090235266, 
-0.86359698367908, -0.972689582258994, -0.862997887122987, -0.791000141548016, 
-0.84096144396231, -0.816280409982102, -0.845456936975633, -0.91164413062996, 
-0.922401865807889, -0.88723817009451, -0.867804945663449, -0.838085803290782, 
-0.860916580727039, -0.711164213147659, -0.86488906869639, -0.842954393604838, 
-0.84644655181353, -0.847081703049086, -0.897054414855857, -0.818497964830397, 
-0.950918656760448, -0.880664681512082, -0.877489585189842, -0.867334809842488, 
-0.950102547691207, -0.809537515194524, -0.885295859034542, -0.88288783395968, 
-0.89196663837807, -0.878022048031624, -0.772802326147342, -0.90384458557316, 
-0.918985537173656, -0.92169596562653, -0.902974833407611, -0.816867221179196, 
-0.81028232521001, -0.667145243064915, -0.88514765802488, -0.82195893425363, 
-0.94653090590587, -0.803255970077281, -0.950426552060374, -0.881747681980104, 
-0.946031213656487, -0.836575808654049, -0.775369268957625, -0.863372860258931, 
-0.81179614027597, -0.521953511311493, -0.908802428491934, -0.977952622724006, 
-0.777434667642969, -0.93076224047006, -0.775192359364524, -0.879253033218594, 
-0.942650584701146, -0.884153707968678, -0.844355121063709, -0.780071606299377, 
-0.756516367231137, -0.808337364139869, -0.90279422853362, -0.846819951279752, 
-0.703430601682576, -0.943047140772204, -0.92771762041422, -0.976165318980557, 
-0.814197104235299, -0.818227029909212, -0.820184341206812, -0.844755700669017, 
-0.875975716072039, -0.854533121914154, -0.957674307880757, -0.944950462467876, 
-0.889068466642628, -0.852940082248052, -0.81135739464597, -0.824909645107581, 
-0.86985097915679, -0.987731904758049, -0.829283027050368, -0.701443646407787, 
-0.781070622383814, -0.78941011860236, -0.876066980368705, -0.837235077385, 
-0.943098626638807, -0.795740262808707, -0.799046003672906, -0.796200693615536, 
-0.891697760642318, -0.822558719764611, -0.897128219101349, -0.816133579675523, 
-0.783385323841536, -0.922833740105208, -0.814713493346646, -0.717149096382242, 
-0.815482181693204, -0.946159988861112, -0.895918096115235, -0.796473107998046, 
-0.96913519977195, -0.78290505221248, -0.853259000042524, -0.772526789283841, 
-0.83148942668914, -0.95277350617928, -0.960283008077825, -0.921041938043294, 
-0.92427187648777, -0.866140454551643, -0.832683579787418, -0.967535587161378, 
-0.841737978350723, -0.900638504165792, -0.866325603396494, -0.87654873391307, 
-0.909935248356716, -0.916631262620417, -0.932679416969508, -0.90739081830566, 
-0.743738637284522, -0.953814760167505, -0.810619481871267, -0.675329066238197, 
-0.925254605821791, -0.910741442341737, -0.784924572747716, -0.83770775870756, 
-0.901505507089454, -0.895473478633981, -0.772109305713123, -0.957455883670276, 
-0.779560239822394, -0.763942609470177, -0.799385830020882, -0.863967958753932, 
-0.901517235308091, -0.879092596961354, -0.798603112943607, -0.83875759623366, 
-0.857861399688452, -0.939265970910568, -0.880964531949989, -0.847989425475382, 
-0.956735606028197, -0.917141365773382, -0.938749347845988, -0.870549369401644, 
-0.92570416039389, -0.832283538865416, -0.929570764393736, -0.875658081080715, 
-0.833933754428892, -0.833136306056766, -0.851951623973423, -0.874501019379728, 
-0.89408339559012, -0.891396629474354, -0.823013413558605, -0.909509706226458, 
-0.849317900001953, -0.811491898334176, -0.852116516827675, -0.796765318251049, 
-0.915474530963598, -0.85431176687524, -0.750122159741389, -0.917019714754243, 
-0.903300754706092, -0.898373920602759, -0.839404928601986, -0.748243679671323, 
-0.821308243764225, -0.863616555337969, -0.867961693835577, -0.858530122351493, 
-0.771980174564918, -0.965497087008722, -0.881171322769694, -0.865629390480524, 
-0.879886126021127, -0.867336839010378, -0.828625091500482, -0.962932572312836, 
-0.927453389489658, -0.926719177996699, -0.803842637692172, -0.829244123686198, 
-0.840007882041237, -0.846883102673227, -0.905020816688823, -0.851034597447476, 
-0.91874732393766, -0.769177601897418, -0.869940347266274, -0.89988094251153, 
-0.710997562796124, -0.895911103597555, -0.918510799204756, -0.95924550888801, 
-0.837045674974198, -0.851350994002259, -0.751453731173656, -0.821902197124694, 
-0.822276733307332, -0.865427640608947, -0.908573554854575, -0.943549974200149, 
-0.868964537883552, -0.91581464619942, -0.920709100531013, -0.849858907267504, 
-0.765215251690161, -0.889383581779051, -0.83342415148077, -0.901566072469447, 
-0.841597370700032, -0.871834146613661, -0.956626848281235, -0.82176173969798, 
-0.914503084672191, -0.827371271721203, -0.836430948030943, -0.85350737515846, 
-0.837594208994796, -0.914500202004525, -0.832443987808236, -0.919950860427514, 
-0.78532304717343, -0.769559340532654, -0.927409101883816, -0.857237196116756, 
-0.80253261649155, -0.892732483694165, -0.951028809875925, -0.871348495186084, 
-0.83114521012493, -0.873602892172417, -0.90037385385688, -0.873616875186206, 
-0.964187755438113, -0.698723952189649, -0.832845296636554, -0.790889875472797, 
-0.748219261327934, -0.906154716187298, -0.841129565458436, -0.879462687546322, 
-0.955254363862538, -0.860143911529466, -0.892587723783164, -0.933085631006263, 
-0.795947579694809, -0.817172597518207, -0.875971082454018, -0.93807445788416, 
-0.946676717955601, -0.561667052658791, -0.461664820059640, -0.560539402281032, 
-0.714357934200464, -0.541000048001114, -0.461879785435074, -0.504915973517357, 
-0.464441395027932, -0.509705367221606, -0.407464394247162, -0.452135929692195, 
-0.555475947306924, -0.802673894835525, -0.590918576043548, -0.49415784864625, 
-0.49963757880004, -0.474070739941281, -0.621243413618465, -0.651853086811367, 
-0.592307067700924, -0.429368333764668, -0.483848131726199, -0.672818522709485, 
-0.64725681680589, -0.702846018433165, -0.513284106163011, -0.59300569848525, 
-0.667735654469789, -0.422478902352876, -0.627831812986343, -0.52043633627581, 
-0.770162622240034, -0.627119039810606, -0.592844201958183, -0.540662033926175, 
-0.424959090496569, -0.465661196464247, -0.534576314917956, -0.384319529480771, 
-0.522871415018985, -0.495773973572222, -0.517490788910008, -0.569304741059299, 
-0.479317391013227, -0.607407787074776, -0.589017157177879, -0.682641937466853, 
-0.635387127358766, -0.586772993012602, -0.702914417724452, -0.348352585079899, 
-0.37814420541392, -0.54738824045297, -0.551246881847277, -0.375582404959123, 
-0.493789218371278, -0.467350480323208, -0.559498561094772, -0.522800463032277, 
-0.514475179385999, -0.5997389213427, -0.509185483148766, -0.613918916174498, 
-0.56204418060426, -0.592559296735595, -0.596174667891558, -0.472447413605103, 
-0.41019757681587, -0.702091449552089, -0.525452211752179, -0.543807285295032, 
-0.668651439104137, -0.322861340373228, -0.611976949639057, -0.425236497701985, 
-0.449540195136121, -0.467081378845839, -0.74269096827546, -0.39738834435964, 
-0.374318638083862, -0.536759215865627, -0.702145942594878, -0.666073852561737, 
-0.624290877487032, -0.659669041400882, -0.690710062149247, -0.274847687255526, 
-0.648839618442072, -0.418685675414495, -0.465417308922005, -0.555979595210507, 
-0.653601101571116, -0.597231727163495, -0.595803965911635, -0.678198813090981, 
-0.486610749437338, -0.652220962278006, -0.763747855345762, -0.578668387981555, 
-0.437218973106046, -0.582791529231271, -0.67399257583538, -0.406058185624779, 
-0.612070001157294, -0.365031223046938, -0.631363672424388, -0.568016777488017, 
-0.365595369360142, -0.693428945781576, -0.665795359540925, 0.396321284123441, 
-0.661049904013482, -0.532800614575576, -0.534218557606074, -0.568651892272286, 
-0.588829217634929, -0.590264614535102, -0.481290528738934, -0.622850524428714, 
-0.631747491363092, -0.504121470151207, -0.539969852041277, -0.434784436994686, 
-0.414520802581387, -0.646717506659652, -0.328962712311149, -0.492721946567138, 
-0.389689575610751, -0.663830597441459, -0.789814723701724, -0.591844697329725, 
-0.670430607884333, -0.634083702341815, -0.495315878685844, -0.526520432727417, 
-0.330346634103814, -0.642011265366288, -0.550239571848306, -0.508999865722831, 
-0.68212507251179, -0.697999457164776, -0.246793173324248, -0.421314144213186, 
-0.526194271870383, -0.52924335103283, -0.75584641031485, -0.557256733989166, 
-0.62772059038206, -0.55322715811453, -0.570784439492333, -0.553731734496906, 
-0.53673262516304, -0.749321896515638, -0.598487671269154, -0.657806923585634, 
-0.588391776783152, -0.423142298007861, -0.400014472608572, -0.652596321649845, 
-0.611843514487633, -0.702871019429778, -0.549418701304876, -0.496660038850201, 
-0.441741418639648, -0.453280576626135, -0.596685897975535, -0.550149171818608, 
-0.459365151395125, -0.580538716327211, -0.687649467046269, -0.597560396390382, 
-0.595268287279059, -0.603564081800888, -0.527728130321207, -0.550903947437795, 
-0.601593352415339, -0.479973425026256, -0.509442119293641, -0.636330543654257, 
-0.572080219224388, -0.500386946714079, -0.564018504504019, -0.82002915774641, 
-0.593477193800516, -0.346906857347605, -0.842937452555631, -0.533344509906258, 
-0.642062528033859, -0.492748191992962, -0.373093001380866, -0.434118954166942, 
-0.439060614665791, -0.478509409492132, -0.615807851188686, -0.493304557926802, 
-0.728831751613992, -0.583523338795055, -0.63833945555631, -0.464487156428054, 
-0.639661465028429, -0.609801287174213, -0.391571630081762, -0.445211969440946, 
-0.679211128231677, -0.46586810817762, -0.54445483494351, -0.61244828317067, 
-0.580203719456731, -0.599340990561419, -0.610315783011137, -0.529741741612428, 
-0.672984779242353, -0.46808684318624, -0.707014674369217, -0.657932105133584, 
-0.619603647874343, -0.465473201502893, -0.574095380194763, -0.553832728761008, 
-0.505174033464314, -0.622346316956587, -0.631786786107468, -0.497005387799439, 
-0.53509235517529, -0.752524785266862, -0.749646628866846, -0.515943095124196, 
-0.428269065732798, -0.384537496514671, -0.438608559778425, -0.507461285615433, 
-0.54642839565659, -0.634556494195032, -0.6786503512045, -0.794997373408074, 
-0.53937550205379, -0.6260253884263, -0.628071824259682, -0.594371484195231, 
-0.701285247999587, -0.672812562126277, -0.542016548408763, -0.357371552918576, 
-0.579569794952966, -0.35925309613011, -0.366878120366655, -0.623453068056545, 
-0.670740597926119, -0.53208420168707, -0.711084383746216, -0.297955539915406, 
-0.540455699623542, -0.458384962706062, -0.339025609374885, -0.520122038081046, 
-0.457150283024151, -0.656259058440675, -0.519571760432537, -0.331082551020467, 
-0.652289625672747, -0.637316041716443, -0.746102520214111, -0.597848360779202, 
-0.818953976757458, -0.507687061649016, -0.559612720329035, -0.380025914783379, 
-0.403250976639533, -0.610248107278321, -0.670624252003956, -0.475105822741201, 
-0.493623257298812, -0.553415493141642, -0.492431372553586, -0.42052666637162, 
-0.528411226058743, -0.776162905916044, -0.561629899473249, -0.688047138653394, 
-0.59692344016617, -0.553129468584121, -0.459106677093466, -0.53524381888881, 
-0.550206348535378, -0.325056547652757, -0.284173441196318, -0.594271099945212, 
-0.623173554116202, -0.561362442996529, -0.713883006993483, -0.520063554768346, 
-0.563525875609464, -0.184183305916164, -0.394671930829398, -0.560592544467161, 
-0.589423578299925, -0.594851741070446, -0.517363300046065, -0.481536798906611, 
-0.566936253650195, -0.383472439604428, -0.693309049836252, -0.647295891784796, 
-0.548728110646807, -0.57127324474268, -0.851111930835159, -0.723472034893197, 
-0.680995279157175, -0.533072584116, -0.467381668965785, -0.518024661403873, 
-0.244036243178600, -0.688969220209073, -0.565563807065075, -0.692666822169737, 
-0.342389736498090, -0.282193813886897, -0.237675744958854, -0.592302189798661, 
-0.65326466825451, -0.368575913761667, -0.644095438868555, -0.469718636130486, 
-0.580241971656345, -0.456429142497645, -0.446181237343928, -0.524019071394295, 
-0.437418355382894, -0.329539547583540, -0.77605997820412, -0.745700662685352, 
-0.509431988260142, -0.588545882041266, -0.561015682793914, -0.711596123534611, 
-0.542859663347595, -0.499176919899668, -0.421064601680369, -0.392929261486018, 
-0.619493770402183, -0.464272238713943, -0.449393590533339, -0.373769585211191, 
-0.709905594421082, -0.565253084680655, -0.314114714016253, -0.545661428529222, 
-0.64325601892109, -0.57967518326701, -0.371602432268267, -0.290151592965983, 
-0.482849920572451, -0.726535164354434, -0.846714306380466, -0.426934809302821, 
-0.558526297311516, -0.602687352253236, -0.475196930677974, -0.545434148831775, 
-0.623539336513423, -0.659705135372112, -0.762472512067898, -0.308966216655914, 
-0.275624602668026, -0.528008608534699, -0.421878135733302, -0.642406052540601, 
-0.660424280087266, -0.462489882466958, -0.370142998694007, -0.68997589018189, 
-0.655394662389908, -0.158297228220863, -0.626011101163521, -0.223957666646235, 
-0.629787764240628, -0.698005371176732, -0.566824436136893, -0.351772290780218, 
-0.576030387469310, -0.533293755385284, -0.53688318183528, -0.504124595958097, 
-0.61319041080911, -0.610114677057624, -0.563470328707714, -0.494551456996552, 
-0.607532643773091, -0.592656033662125, -0.268273494558735, -0.513052284937475, 
-0.549824377163869, -0.569225249980245, -0.78008288778183, -0.70758365545281, 
-0.441389979463772, -0.964791444279687, -0.755012082442501, -0.749275400024301, 
-0.42685398233565, -0.677268478333507, -0.506913511197266, -0.583144925355878, 
-0.494220757384693, -0.624510841789445, -0.7498539621552, -0.573728451103918, 
-0.645670605315545, -0.583291590750794, -0.713470948900894, -0.473052968187305, 
-0.477957009530129, -0.456516557361961, -0.417445236445253, -0.636088102292026, 
-0.442470349894362, -0.50704186134189, -0.534713719971891, -0.410488209212437, 
-0.622522199167205, -0.538846136748616, -0.332064593124510, -0.782438661069846, 
-0.551303756528986, -0.431669773679976, -0.513540868261094, -0.773953966669852, 
-0.622382160952156, -0.532257578281326, -0.502160523799878, -0.80397460018466, 
-0.550869612546104, -0.373172037394232, -0.472028653690753, -0.482848044784328, 
-0.738126686313071, -0.563662349685314, -0.359671506759799, -0.351401108306963, 
-0.528654522010531, -0.45761127858704, -0.833998177487838, -0.728337023794177, 
-0.439306524579275, -0.612273175811884, -0.667117228653906, -0.547214921979048, 
-0.64347176353762, -0.518624455400512, -0.508602731853541, -0.502568986419925, 
-0.219008992758252, -0.433698776902075, -0.639136076299637, -0.716231094889956, 
-0.426276698649406, -0.632805681596589, -0.617060741472943, -0.754722027567514, 
-0.496324734558201, -0.441642775592713, -0.377894441799816, -0.737644463173138, 
-0.508161868852301, -0.450888073709285, -0.576527249968956, -0.331963262449292, 
-0.582972152160547, -0.139228217263893, -0.593068585150643, -0.507893011193259, 
-0.924143058283984, -0.554341703108757, -0.64952518442976, -0.301838853214577, 
-0.633055327676171, -0.457257101713973, -0.539438271940757, -0.554316533789229, 
-0.658689636829311, -0.752979886347767, -0.698553814502676, -0.819090788726784, 
-0.513892302127003, -0.551310426036438, -0.485087838946165, -0.61505165716258, 
-0.395756946980464, -0.600037012212826, -0.724949517089016, -0.588325982775121, 
-0.581507223840757, -0.678875551103723, -0.795750338961757, -0.570088767284336, 
-0.63889912123741, -0.444151319916350, -0.627447172956895, -0.572201171203462, 
-0.603516085175614, -0.390049563726090, -0.66582167742545, -0.605033970826426, 
-0.588793244267012, -0.362365021653562, -0.63231100955598, -0.47390032938087, 
-0.532963842310152, -0.475943688412076, -0.686709001739137, -0.252186248688571, 
-0.612765793158236, -0.523494546251356, -0.547532128951462, -0.346663020742652, 
-0.422578114253182, -0.551390830223606, -0.501559832124268, -0.490560685485557, 
-0.516916489379618, -0.501471691338168, -0.289626574535814, -0.658814439463551, 
-0.474620679114943, -0.568093978190058, -0.592602097203599, -0.606560261026704, 
-0.636500324722054, -0.572363860965358, -0.355924119691818, -0.573150743717601, 
-0.548928576808361, -0.362714629843449, -0.406037369424026, -0.517746530012131, 
-0.649548106578622, -0.620128585931062, -0.701338791941126, -0.659669499975423, 
-0.572517911381543, -0.520495257012631, -0.644375685979957, -0.629166827340655, 
-0.555551272718836, -0.659958252804493, -0.487273281101433, -0.546263870455019, 
-0.615859246732819, -0.557294884651019, -0.511445316661534, -0.6060371049533, 
-0.527127595303884, -0.365151133495277, -0.574212301684642, -0.739382473981423, 
-0.827402918160608, -0.672386302090372, -0.48445945907739, -0.725734211145489, 
-0.716048870500261, -0.736172525359789, -0.443018947806966, -0.836153729731858, 
-0.428435381526277, -0.534616145864087, -0.708191590203929, -0.809089702583446, 
-0.549496014413582, -0.535711943658351, -0.348566345381508, -0.631529437362827, 
-0.440512705535212, -0.591322484055796, -0.66471867934525, -0.539016819108535, 
-0.407438448531417, -0.693023494612362, -0.429050497956282, -0.709337905362515, 
-0.517610968039603, -0.414063208969635, -0.442774055688340, -0.68795450661398, 
-0.493153950091808, -0.624302502890437, -0.486798279954774, -0.538864769612741, 
-0.344692909173684, -0.67006160443495, -0.551342575210624, -0.588210327766434, 
-0.502612317281723, -0.58512358474711, -0.547880159332165, -0.498801982557537, 
-0.445941958393136, -0.731790180371992, -0.429185383869018, -0.706200082871352, 
-0.572275634899041, -0.484301163982744, -0.441250003357001, -0.493727092093938, 
-0.471019267858025, -0.64697813598296, -0.701187186666178, -0.549850245664879, 
-0.49072236171452, -0.551408166604707, -0.463964485905716, -0.599947895228754, 
-0.750317979016838, -0.62995542879409, -0.385262478313163, -0.620722194027544, 
-0.572254235881825, -0.714182922906111, -0.608082980143603, -0.750227721910642, 
-0.691291797796242, -0.354301282088839, -0.612008516802464, -0.552974577058652, 
-0.614035428274209, -0.281433649566308, -0.745750250674879, -0.595930846384901, 
-0.38394152739172, -0.492751538496507, -0.558361900375274, -0.412096788492491, 
-0.479974314731838, -0.715618489406957, -0.566090107080051, -0.320569159939146, 
-0.440892727085309, -0.470110563635041, -0.67382205241903, -0.564289586770853, 
-0.697776272944887, -0.708506268616109, -0.687925697570308, -0.567678087991558, 
-0.338490870561825, -0.444084987083784, -0.751975788960534, -0.347471661651201, 
-0.389499606454328, -0.476923064252508, -0.511881298640544, -0.272268755094855, 
-0.629765380413513, -0.425049348065023, -0.389156976321355, -0.454581374489028, 
-0.541858197241574, -0.513812925237289, -0.482921602956477, -0.692819099600307, 
-0.470945968193212, -0.653579279668703, -0.462884612701026, -0.641218339280141, 
-0.533172770609748, -0.715495663571263, -0.696049146294266, -0.776155874223358, 
-0.493324510409671, -0.609284317514178, -0.382850736352655, -0.659526199620521, 
-0.596192266076938, -0.534656599257071, -0.735993340940652, -0.430673384901118, 
-0.630304982745558, -0.544242971104850, -0.579541111925787, -0.482612530706763, 
-0.675372341387466, -0.852549559372734, -0.526307979327961, -0.157390910075219, 
-0.577119289257222, -0.437839101284431, -0.359141944449056, -0.53790824646227, 
-0.691366367904792, -0.554983458683403, -0.681535105402475, -0.516696015822435, 
-0.490399130335199, -0.326885373585088, -0.555311294063693, -0.683285732049515, 
-0.627796232349508, -0.641811230594596, -0.560808499371777, -0.443177897390435, 
-0.621966493160848, -0.573279006437244, -0.640879596091156, -0.552731449477851, 
-0.648491875088849, -0.527523268898834, -0.439034215001607, -0.574112555440165, 
-0.42699376692766, -0.503714991770474, -0.624563261625792, -0.33317724138199, 
-0.741824975310923, -0.723101324745059, -0.60837358002226, -0.345091286006983, 
-0.773412352967233, -0.648117890575228, -0.770224414659059, -0.373838138470087, 
-0.67706475917438, -0.381113877481856, -0.613016491159896, -0.567878391508423, 
-0.477742319923062, -0.307222422569631, -0.81107472830581, -0.587751431487892, 
-0.403237195403266, -0.410939658878072, -0.59939590988892, -0.497544792197285, 
-0.681465060692661, -0.599658380867359, -0.500531468794558, -0.591780348711543, 
-0.500554291471717, -0.557833001769922, -0.557311619549123, -0.582496758400244, 
-0.460885303125318, -0.404962784467808, -0.410281800145466, -0.652920926794012, 
-0.734009783879178, -0.286933786009751, -0.508049312905849, -0.431132343951561, 
-0.62707403343454, -0.545973439246566, -0.369286497948813, -0.762902215047712, 
-0.69151471135046, -0.749492669673561, -0.648139818264019, -0.620964789612587, 
-0.72114970265274, -0.419206376162526, -0.698369858672559, -0.181277490114578, 
-0.581732276116178, -0.555239441674115, -0.549005134264085, -0.600361600038416, 
-0.685145844571677, -0.497982711538505, -0.536035012567907, -0.399784978543341, 
-0.5846863418016, -0.440395292945609, -0.411277420717100, -0.562886787162431, 
-0.649214942929592, -0.649338531159785, -0.469092162129979, -0.382046089923626, 
-0.608743428721761, -0.467275121889106, -0.481607728487895, -0.54255434691431, 
-0.7313655713728, -0.576540983507427, 0.0515300178476047, -0.514852574832896, 
-0.626594055635402, -0.522262548288729, -0.669211838415139, -0.705566015288357, 
-0.729143599702059, -0.66569241410535, -0.610715290724707, -0.7284696266789, 
-0.448076195578799, -0.449420905366946, -0.186414386959407, -0.49980084024218, 
-0.530428849934796, -0.428745103838829, -0.663718566918988, -0.493324197380986, 
-0.491518466775886, -0.469975702353763, -0.67454009409871, -0.425430286373314, 
-0.591305873470959, -0.711249434242876, -0.486953755080095, -0.310401079088384, 
-0.699268184271902, -0.730363704404695, -0.812312860946087, -0.453905045045646, 
-0.589846104436021, -0.618635525006452, -0.499880593801563, -0.531550189744718, 
-0.471756092727853, -0.717933513315495, -0.536372871957204, -0.691778028219655, 
-0.363766974081264, -0.468388965286492, -0.517101718356372, -0.51266716775401, 
-0.520402777538506, -0.575720807806134, -0.674861408825656, -0.667294003197556, 
-0.627559521676665, -0.6396066501453, -0.63436285427504, -0.646853512203142, 
-0.435363680208901, -0.565005951719498, -0.659243261110256, -0.433205626930945, 
-0.63795556156634, -0.581765112046916, -0.391189270836683, -0.554713848461067, 
-0.568716352812348, -0.626318605883579, -0.522674473165794, -0.547579246784233, 
-0.697643960210938, -0.647736677569302, -0.602078181896294, -0.588882042762979, 
-0.459663350647339, -0.422557507951277, -0.77676575144499, -0.704641141184477, 
-0.563403233905461, -0.491133609452498, -0.614141566154725, -0.57035504987701, 
-0.528803361803431, -0.51038542510535, -0.69026085354497, -0.60430146819739, 
-0.487147033043016, -0.313069404038256, -0.612114121842157, -0.648685022991297, 
-0.428434917367184, -0.494078324145531, -0.843446397460636, -0.614820269732436, 
-0.568333319978313, -0.394923705508000, -0.68485205813526, -0.608546429623666, 
-0.541360432684649, -0.62526527934282, -0.476244696115919, -0.488132879176627, 
-0.63686844132454, -0.384762084083204, -0.637283123451855, -0.706055791804796, 
-0.69505924613242, -0.521762641618129, -0.430948199814962, -0.287748948699028, 
-0.594638088569275, -0.543543674788065, -0.615598710578148, -0.550644529617644, 
-0.400183705537092, -0.516140962807774, -0.685070960350822, -0.478610271062454, 
-0.529491505921074, -0.554701307653622, -0.549178225235884, -0.645488310957262, 
-0.536037099251451, -0.390599976461969, -0.753477550810308, -0.645041162188167, 
-0.536216666834387, -0.437231321827923, -0.50106275261944, -0.45623463645954, 
-0.564120966234857, -0.392202504294228, -0.672435094353981, -0.435520179847919, 
-0.502668772650959, -0.727374602409943, -0.500507740998925, -0.410260360948329, 
-0.490628783153358, -0.448264080488135, -0.5091451720032, -0.431986289045741, 
-0.50207046155446, -0.432915713954963, -0.57164477938472, -0.566608280789705, 
-0.762845148128494, -0.584976290022298, -0.520219701368294, -0.57383211808379, 
0.0455328964353751, -0.548391556058317, -0.525994294388372, -0.697343527529714, 
-0.545499113432944, -0.748269412900881, -0.401438674221265, -0.665503682605812, 
-0.48349748001966, -0.52025061271389, -0.556173955774806, -0.63406429924506, 
-0.497654928984162, -0.55480647442119, -0.375255848151064, -0.489828963900271, 
-0.651280989310247, -0.448180209231292, -0.84365121170237, -0.63500090352309, 
-0.602112619711339, -0.565970468610696, -0.60025848583139, -0.537401972478493, 
-0.525983993868089, -0.51537847307121, -0.719293942674995, -0.651658606385929, 
-0.679456399410479, -0.711137266343928, -0.619121683891536, -0.185932569425946, 
-0.590218903346737, -0.300599570075816, -0.765482206480147, -0.529176889475122, 
-0.736265776547963, -0.580149657218059, -0.608533874241433, -0.182726350349590, 
-0.75609567216581, -0.650130196958705, -0.714251806570612, -0.602888349995584, 
-0.568050165901802, -0.545614428914405, -0.553867973052127, -0.344938363784533, 
-0.592744538178731, -0.459355038694009, -0.472450714038397, -0.400777873585682, 
-0.430113758106402, -0.60495254802731, -0.530706639248464, -0.718554083232649, 
-0.585340105148937, -0.20791287140495, -0.436212854647829, -0.465912929974463, 
-0.576239545236719, -0.527351654225036, -0.55469573484463, -0.540630572315549, 
-0.696656058746254, -0.484254781297734, -0.60180117599271, -0.523346160467752, 
-0.527628149299796, -0.438975024985691, -0.762884495884517, -0.485360558449091, 
-0.44166283135624, -0.6092949440061, -0.601467262862067, -0.54728569048688, 
-0.58496644932982, -0.470178544302218, -0.289160196509887, -0.405971606153791, 
-0.73092412706089, -0.546161704023621, -0.178916465276085, -0.168402490639396, 
-0.228097463006266, -0.220346895122717, -0.335643415571689, -0.331365684074968, 
-0.236945557190289, -0.0296646054023525, -0.101259812876592, 
-0.33806300607135, -0.292888997843279, -0.184626444065677, -0.186542471389987, 
-0.197884247508766, -0.354061585608549, -0.227029716967328, -0.237332818889098, 
-0.0963866131546276, -0.0657019152270015, 0.159170246473307, 
-0.0353502259982170, -0.303859770375356, -0.373742971778668, 
-0.285952326374885, -0.230514446117405, -0.154924020279341, -0.655537736227155, 
-0.469639420762727, -0.231576182812332, 0.0895930605178346, -0.317978489312865, 
-0.402044437410296, -0.0604031087987543, -0.300263228669114, 
-0.448090682094598, -0.311758968991047, -0.186200601775443, -0.276134898680499, 
-0.229652325552257, -0.391611845533241, -0.371290107416045, -0.301004059908131, 
-0.294235358442999, -0.385350634413882, -0.419462908531085, -0.124663992441832, 
-0.340904850060594, -0.131389839127991, -0.282868375594157, -0.331296220027867, 
-0.112554638524446, -0.486796710967493, -0.198651805488643, 0.0126621644695605, 
-0.165035173530684, -0.370388452535754, -0.312196771492396, -0.505473123029996, 
-0.312435021537668, -0.329069893614636, -0.375203313733328, -0.285319573024586, 
-0.353658863205517, -0.261728698526828, -0.510615823645438, -0.378894125154551, 
-0.33067057267684, -0.401878639479959, -0.448960106256228, -0.0828258060082468, 
-0.175305915013619, -0.355647188983042, -0.296619381497974, -0.215750353870372, 
-0.294295111534830, -0.340299890085385, 0.0489167211378197, -0.210944248063137, 
-0.178136050406185, -0.179950953621853, -0.290700458965440, -0.0623968676361784, 
-0.380245909388505, 0.0621219635366947, -0.282566333581622, -0.114677445628851, 
-0.307886625131035, -0.356004726105125, -0.0919333512796322, 
-0.322546943558316, -0.314005001412192, -0.155709073004803, -0.269428175018781, 
-0.352590711438157, -0.0187593804836134, -0.633326100112384, 
-0.287371388696296, -0.273898972524247, -0.406231691322276, -0.324465164343162, 
-0.0463027500521177, -0.245741301988359, -0.397630020553794, 
-0.0576034677280312, -0.20474070037211, -0.448048401974186, -0.25793817035976, 
-0.296982637541892, -0.171098396843415, -0.265208548122671, -0.0481209006778969, 
-0.116023814766981, 0.156511582015465, -0.401730931786729, -0.237529846340667, 
-0.372397162072828, -0.270099632789205, -0.340855778607435, -0.250220285038056, 
-0.107335949218492, -0.0714341942184687, -0.225482327737313, 
-0.282373331435379, -0.357276548642739, -0.255932343814539, -0.386207559032014, 
-0.220634741872379, -0.219901278543347, 0.289347359781153, -0.186647161398776, 
-0.296297365610068, -0.158100897089339, -0.297222427689762, -0.475485238662839, 
-0.373331981829456, -0.311138800584875, -0.244389587744256, -0.297702937479390, 
-0.449761249812122, 0.180386412787974, -0.395910059600848, -0.377044288000128, 
-0.271361388610551, -0.302669842089755, -0.0962708572966187, 
-0.263061982967072, -0.498714680648555, -0.177846176479561, -0.454572625502159, 
-0.395058327190277, -0.199792030527026, -0.539980209065046, -0.44380608404253, 
-0.306828483969012, -0.454926794922149, -0.115393999773164, -0.289396005771584, 
-0.305310183152401, -0.0389753959739821, -0.467306554835639, 
-0.103279413825429, -0.00310443726754364, 0.209332088286069, 
-0.0801423798263366, -0.539472508203217, -0.256358299975233, 
-0.261972837689834, -0.128834905266972, -0.302326118310386, -0.29563572819928, 
-0.0762811165950842, -0.441555141701913, -0.195225077097953, 
-0.337355718066480, -0.171350838887736, -0.250008020423156, 0.0960305665230287, 
-0.465047627622005, -0.280484988210416, -0.305085140741363, -0.707645867648409, 
-0.442736559854279, -0.0179284246658530, -0.28533647862528, -0.119493119942950, 
-0.381127729677838, -0.267081921370928, -0.151533282925701, -0.421698350429092, 
-0.280990462310704, -0.541153765865418, -0.187409290579589, -0.322771342224526, 
-0.17423852498365, -0.222467586242015, -0.262496479144213, -0.340679419824946, 
-0.183354228568086, -0.349667178799145, -0.174128351244974, -0.235396318892855, 
-0.259584707576659, -0.427368017001617, -0.489260858951127, -0.20279412148173, 
-0.179552192258711, -0.365970228809742, -0.209360724266722, 0.00565515271651326, 
-0.416153490091267, -0.483419463725071, -0.114356721282282, -0.430201641790999, 
-0.289354029755824, -0.263208081914213, -0.035836317164094, -0.161388321239131, 
-0.283753369004428, -0.312783512784636, -0.343859230092806, -0.524095897580431, 
-0.46345562668423, -0.0895136231033357, -0.150530287550325, -0.495935230753952, 
-0.232575935374586, -0.398609339309493, -0.0784684374101854, 
-0.337674370412497, -0.261078544922811, -0.0981534353104494, 
-0.36317085343704, -0.414314274327236, -0.0194272751539103, -0.24671085222658, 
-0.257368146133184, -0.392128045546698, -0.117452608817964, -0.347252361904472, 
-0.188047390824695, -0.246322058656353, -0.147564683585441, -0.361847519356403, 
-0.414290827006917, -0.542394385347272, -0.323780679079526, -0.44542025457209, 
0.0219001204820371, -0.366580426788349, -0.201699717767390, -0.165502936663177, 
-0.0493752449032377, -0.276135557802571, 0.0115033744202208, 
-0.152389734676707, -0.242207864991783, -0.321540971773775, -0.503177066139942, 
-0.086614149583699, -0.495514946765096, -0.480339192217221, -0.238093143909598, 
-0.206532827971344, -0.166440373180083, -0.486877631898379, -0.474522093933582, 
-0.311293958316598, -0.439854186213077, -0.323063352757576, -0.177728312411652, 
-0.154461994323926, -0.445416810673235, -0.399663589678842, -0.349431928544934, 
-0.575596435315373, -0.431430049801052, -0.352709779324783, -0.202688079768158, 
-0.795894017071758, -0.285286234002050, -0.156565910873886, -0.410137095416419, 
-0.390966956654753, -0.200153268144493, -0.365452467943909, -0.243400900919981, 
-0.298026438247374, -0.186417967080754, 0.206770486181416, -0.101778202323541, 
-0.177687250393441, -0.0825859984615178, -0.0903301124349267, 
-0.163543952846110, -0.204728304809600, -0.359495466159876, -0.122075643760878, 
-0.39572635022144, 0.00628004729456551, -0.130387851970161, -0.306907031475013, 
-0.303944604748373, -0.164101668352160, -0.254969010960664, -0.220171589833888, 
-0.283885871632785, -0.596950709711551, -0.0381621656548464, 
-0.345886930950920, -0.319352013043194, -0.156074421384019, -0.512397646032651, 
-0.327730674072525, -0.300329237473373, -0.032325238412436, -0.412457057720438, 
-0.266599460073318, -0.363386540978026, -0.318176961508613, -0.213553847551259, 
-0.272353601237096, -0.170638807377891, -0.459937339035194, -0.369043739168056, 
-0.342759462432996, -0.517444982400908, -0.561354637657968, -0.236612029174107, 
-0.466101632374304, -0.334024128862424, -0.334286116007186, -0.106262790760143, 
-0.525812001638562, -0.416271911185546, -0.250294831242057, -0.41764802792264, 
-0.238374433778319, -0.584365139097301, -0.450357905004444, -0.30127684535994, 
0.0803760647191362, -0.268345255743208, -0.47466783108687, -0.175390189659651, 
-0.165841401914250, -0.239024161773605, -0.217234655814803, -0.430781759832846, 
-0.409099260592484, -0.199526805920101, -0.0402702725126724, 
-0.510070902073929, -0.217357695120756, -0.394243312245375, -0.244165719498883, 
-0.288005293676397, -0.156568631237748, -0.238779737337815, -0.338282397558388, 
-0.358846125703649, -0.287343801804261, -0.169287102859988, -0.430100000602626, 
-0.373576648468517, -0.437018344998112, -0.345919592020656, -0.648975355786897, 
-0.289038215206045, -0.198789443690868, -0.386486069006876, -0.429366148359548, 
-0.388889160993247, -0.41494736043825, -0.303112696934301, -0.559700724856641, 
-0.587180663116262, -0.133841396872010, 0.195868441741776, -0.387196709499962, 
-0.41180246029454, -0.395831351158203, -0.462147043665872, -0.369607626832737, 
-0.580150485961123, -0.256582088837325, -0.0420715005405622, 
-0.0193503933136065, -0.306248565865586, -0.209909358115991, 
-0.380192093974803, -0.142103332060865, 0.319989650653065, -0.344271899405513, 
-0.320633454949809, -0.176509883546983, -0.227603749529086, -0.396014504965206, 
-0.384317637427118, -0.421166890294317, -0.35177838949606, -0.360115753754992, 
-0.42477578689816, -0.377153336220712, -0.43725001797998, -0.316274256796532, 
-0.359709914137614, -0.271476455817175, -0.264690066980141, -0.407149877653537, 
-0.0582710480985467, -0.283337524814367, -0.332066644426924, 
-0.132250256146945, -0.304920172975131, -0.344808077943929, -0.202746450768917, 
-0.125561824897764, -0.335650419302736, -0.067138103845641, -0.369579394539658, 
-0.466351845304233, -0.0804854619540352, -0.316155351846476, 
-0.565086326255877, -0.32018258031848, -0.440848044368844, -0.319143448071066, 
-0.181252682353026, -0.374619339062354, -0.111758864628804, -0.596169803840113, 
-0.330254208640042, 0.000818261552781478, -0.453595485914629, 
-0.286195254448309, -0.351796360066228, -0.133196772553478, -0.341951409889637, 
-0.35144976521879, -0.235780859153609, -0.392562204093851, -0.300482237089746, 
-0.422300050746926, -0.121465026814670, -0.401118554152232, -0.0225800114022512, 
-0.381078642131954, 0.0220511215616085, -0.302796168623667, -0.189314656732639, 
-0.0410339980498387, -0.551404394444595, -0.477861887128036, 
-0.242171414064232, -0.21845797148023, -0.438968360190424, -0.123081715252771, 
-0.41915762544291, -0.289606632841101, -0.291165442546385, -0.223746772853756, 
-0.341685628463944, -0.381265099149072, -0.217826702709666, -0.403577887606898, 
-0.0870733499684365, -0.234105417727488, -0.331165236482591, 
-0.233795911597161, -0.324342846821573, -0.303004533686388, -0.420226240782622, 
-0.303841638656106, -0.421514878630187, -0.688738396647942, -0.308270484150293, 
-0.34680191726024, -0.346914705630001, -0.265603539389198, -0.274793388920499, 
-0.356961237668089, -0.0162974459478375, 0.125054491072054, -0.213757928833970, 
-0.305414483739096, -0.19312922890934, -0.0522724273467152, -0.0186871679759017, 
-0.227172031534820, -0.384567263520280, -0.231843683763740, 0.0870831703800607, 
-0.42714543357879, 0.173528936600284, -0.491145791194398, -0.154616499472853, 
-0.494904481528809, -0.137920156223391, -0.322696987009232, -0.283628135168889, 
-0.238669244886363, -0.221508787892077, -0.391234904423694, -0.410830588162796, 
-0.214078792121183, -0.412924572253319, -0.213969145209392, -0.273291878009408, 
-0.147765609850759, -0.350127032366388, -0.240661903291881, -0.276058114240609, 
-0.37831166879614, -0.433826984212709, -0.267984364628578, -0.258090692794303, 
-0.128004444322224, 0.0331553585531291, -0.423698554922789, -0.348308524156728, 
-0.178474361459147, -0.227725173823050, -0.456045405038292, -0.332378930441661, 
-0.387772796208678, -0.435302987322926, -0.0497646313119604, 
-0.21421100886916, -0.222402846218426, -0.375891543444787, -0.230722788969479, 
-0.349240360783356, -0.360445051574573, -0.186436800374424, -0.579894250350535, 
-0.37615709651817, -0.379490126609334, -0.164438565246507, 0.160504476798351, 
-0.462261663151795, -0.351227332933606, 0.0200766712001482, -0.464102498135082, 
-0.450944726610813, -0.322924529862199, -0.447927452893141, -0.331926218408776, 
-0.186791720054617, -0.214538700533461, -0.295412921440406, -0.442714518949311, 
-0.409058811028767, -0.0862897931164246, -0.323913645117154, 
-0.267632558551583, -0.378078938949592, -0.775438483568465, -0.262790476445962, 
-0.266301367816791, -0.210963872823763, -0.301516565132342, -0.313583302281543, 
0.0267999521483458, -0.240279006028391, -0.394220379807917, -0.115221443114830, 
-0.193506960162906, -0.46532826264797, -0.312973038829572, -0.361481667891259, 
-0.441495247883239, -0.383487272541213, -0.501593420151292, -0.224032367969762, 
-0.503809088398326, -0.161574364179618, -0.0717367311759247, 
-0.244149044830563, -0.422176679307528, -0.34904144468276, -0.459465010274014, 
-0.153349582141916, -0.430798826063707, -0.136191105708483, -0.192587293995823, 
0.186568010325251, -0.386499037846324, -0.373692778460091, -0.299645783763242, 
-0.049417312280605, -0.5290104298778, -0.267907807127910, -0.317292988316166, 
-0.198008190681726, -0.265926693256671, -0.193689546732993, -0.202538375190486, 
-0.109147067648998, -0.44762320360856, -0.376464154301859, -0.398475049937116, 
-0.242339010471197, -0.203169025600669, -0.481249217113052, -0.218464984285509, 
-0.238074589645914, -0.134213835767713, -0.229720121706657, -0.0187536683158595, 
-0.61465303139652, -0.398154113352973, -0.0953332156794165, -0.297185668813610, 
-0.175875116684745, -0.175241229700083, -0.197473028530843, -0.262718275829867, 
-0.324789176554198, -0.431471292234299, -0.435240011255864, -0.167407196344863, 
-0.335041962075274, -0.215028379121969, -0.451790786689851, -0.226312318072569, 
-0.42618533448614, -0.356869940223536, -0.132004902778064, -0.163535376488449, 
0.117427795171753, -0.25445889844059, -0.179408715978091, -0.42019784781971, 
-0.141217112924201, -0.226331251592405, -0.358837327646147, -0.240647056681423, 
-0.174318771587225, -0.269626394961458, -0.185170940528888, -0.00900242610273508, 
0.0564008630355297, -0.416866344771671, 0.156799262533601, -0.409040519334965, 
0.0635054703467568, -0.54538552108046, -0.232360013949671, -0.410767982498701, 
-0.137172315402428, -0.354593098143337, -0.276753210066044, -0.462823786124298, 
-0.440893974407168, -0.234778752334142, -0.325297910033435, 0.0342136441453212, 
-0.430215612642081, -0.141130458904478, -0.00911799108535364, 
-0.39177254180602, -0.554713563407839, -0.547514422040762, -0.230002375444632, 
-0.302242025485844, -0.267749295600272, -0.197139060146158, -0.0803434446011221, 
-0.254061881133242, -0.604941640849444, -0.439627739441455, -0.485431629161678, 
-0.0983801084491, 0.244462330578411, -0.506594049903856, -0.165646592004187, 
-0.332931147730216, -0.199539337528214, -0.548565791215969, -0.203011794753164, 
-0.161222909036884, -0.128039629836840, -0.325815628444892, -0.138988095561481, 
-0.251166141729877, -0.347671953173106, -0.332331925833965, -0.186671049344291, 
-0.258412096743107, -0.430193195027392, 0.0124398231309022, -0.130721110408086, 
-0.316690797921798, -0.143394455034135, -0.303001808073365, -0.48998451226845, 
-0.407230102119114, -0.14536196119368, -0.311668499483559, -0.204523051021919, 
-0.108879196316260, -0.280490293390301, -0.402773048948135, -0.100793959233428, 
-0.158580312899827, -0.154075921207807, -0.182164118446686, -0.241932635167381, 
-0.392683774623514, -0.421256709118875, -0.388336016352746, -0.128865040316613, 
-0.264577019100771, -0.31522140876903, -0.205456400882834, -0.479465574522162, 
-0.281031268845108, -0.206521112189384, -0.350038464803807, -0.136078083702362, 
-0.0444592373267525, -0.449620320512297, -0.160686789856840, 
-0.488870464239675, -0.424469988084223, -0.478896640768141, -0.38740467944761, 
-0.305275156055518, -0.0881270652372178, -0.171621286117593, 
-0.298071307281563, -0.341734534243497, -0.311669226811959, -0.0833388754460922, 
-0.257681999215164, -0.217441149774506, -0.364650567692363, 0.0843634079951671, 
-0.277397437004084, -0.541178364683491, -0.451768904688741, -0.236140056771678, 
-0.177148707104276, -0.132105215440045, 0.0785691518446536, -0.480750270848473, 
-0.0352427837408841, -0.303827586457332, -0.324664379732305, 
0.0422429883053511, -0.274341994363850, -0.204078228046654, -0.408625446237442, 
-0.313688858999553, -0.046292510742183, -0.398494970560916, -0.354941935965821, 
-0.363095417875887, -0.469393726810767, -0.223957590641625, -0.180130471783209, 
-0.201665477468531, -0.0671504241049113, -0.496946179191955, 
-0.348832945634914, -0.488685848667182, -0.341776511955332, -0.101491902637759, 
-0.260517941890639, -0.504089262032207, -0.145614666164915, 0.0594227477011909, 
-0.212209996933125, -0.255956553089068, -0.397805681780025, -0.379709465073432, 
-0.0998976426515063, -0.258107101474940, -0.213337220573009, 
-0.276927370400102, -0.179896490670323, -0.340959707345706, -0.633880662122289, 
-0.204773652263364, -0.418295318073644, -0.690132840949231, -0.398012516123766, 
-0.112554670492534, -0.344131210153936, 0.0126482454160023, -0.154200130587352, 
-0.397747827907889, -0.328292392004978, -0.166705271521433, -0.315934927660349, 
-0.271677960096638, -0.299023580998594, -0.28628631171357, -0.155323402204071, 
-0.355198899703495, -0.107216792758265, -0.167980504250838, -0.310447891030274, 
-0.404169603765321, -0.387986785855505, -0.465318957398302, -0.184101461108035, 
-0.380966090527136, -0.282289495495766, -0.265483653615655, -0.171860344613598, 
-0.139344425821935, -0.169443211245590, -0.230555899841688, -0.535619189163579, 
-0.225492789293798, -0.171663921893342, -0.363129099027277, -0.4265617947024, 
-0.255359587347850, -0.424591206868023, -0.365527145332025, -0.290581097726078, 
-0.252527052230327, -0.111535080842085, -0.079195970968085, -0.281169863755129, 
-0.247057731987191, 0.0536615359455468, -0.334626565449185, -0.35289747801148, 
-0.00230972869186031, -0.247181468105589, -0.235119236240951, 
-0.135936994368239, -0.198590035280023, -0.302713238304227, -0.207420399581959, 
-0.222989693056516, -0.246284506339154, -0.328141236065326, -0.434667099741665, 
-0.224925867465089, -0.346194900210652, -0.283192483380189, -0.275079603263309, 
-0.378790161143134, -0.371427865612956, -0.236381232590774, -0.571838411641047, 
0.184842028572217, -0.311684426596662, -0.318888125356715, -0.127359057674061, 
-0.446797865176419, -0.121311616838171, -0.166378272853907, -0.338665576868991, 
-0.276562719606077, -0.0291821547791691, -0.3747499893972, -0.377474899785532, 
-0.00616365871992149, -0.0506919270957119, -0.341172835034666, 
-0.494911237332076, -0.297163488649987, -0.245362808054426, -0.637620871118454, 
0.0190069422739628, -0.191312762009369, -0.0695094951938149, 
-0.245646149258658, -0.432091994983887, -0.327926129059225, -0.263994998102065, 
-0.210488353630947, -0.309946326214943, -0.104261363540132, -0.0992904321007825, 
-0.36471543961862, -0.0940222825330452, -0.390555013108592, -0.102963079860100, 
-0.256469892508106, -0.504034045314047, -0.271850196723376, -0.430637452268181, 
-0.197598458436389, -0.293147258034687, -0.0523049718860735, 
-0.569135153651047, -0.518746320843074, -0.269515294041755, -0.169035268751675, 
-0.0165272657230567, -0.136130905191968, -0.191010676481456, 
-0.532684618307651, -0.300828680498159, -0.414563616240879, -0.067149431419523, 
-0.202021363368667, -0.403525725404843, -0.210632449315633, -0.428110818692805, 
-0.180537457929821, -0.237013118186161, -0.184028489101459, -0.320788193174933, 
-0.270248686680476, -0.0353646419109701, -0.335342933225003, 
-0.394099053714408, -0.0316859821651514, -0.376230595224495, 
-0.349677022104173, -0.0578965161127524, -0.357247467714905, 
-0.351698599974314, -0.421735743193295, -0.406375471118573, -0.413850502196136, 
-0.336700934325204, -0.316998388804217, -0.314431132310029, -0.215162324714683, 
-0.000819456555919248, -0.0456428607983722, -0.495784632360109, 
-0.317393038503055, 0.00798245683584356, -0.337714255095559, 
-0.340682694010652, -0.375366798699691, -0.0124119174350516, 
-0.509367952186267, -0.369256388595982, -0.248435555370638, -0.104238116688975, 
-0.427445679754883, -0.190511713212796, -0.145834345255997, -0.237969041622421, 
-0.223073222356277, -0.298827658632133, -0.204718056243283, -0.153677620610606, 
-0.306905563899758, -0.269267826250873, 0.153849088125656, -0.250045548876477, 
-0.52305726840855, -0.482366864611445, -0.392024657500891, -0.0527733309070311, 
-0.0609439098860501, -0.250843071866979, -0.238937154475922, 
-0.057607242121684, -0.424809515474751, -0.130914289311501, -0.0266436215130681, 
-0.391448327541748, 0.00679161877681543, -0.359562796520148, 
0.026014325580301, -0.0276039771626832, -0.388330110326376, -0.0328104513031919, 
-0.492238945764364, -0.114534244615129, -0.291081279910926, -0.212358668977655, 
-0.498552929851428, -0.412926172563765, -0.220732843202815, -0.312825603932063, 
-0.448383681071725, -0.58637347271703, -0.233156260588345, -0.23012282764106, 
-0.261772691972467, -0.310674398722383, -0.254255609957646, -0.293210777900158, 
-0.0780737182917845, -0.225342661630834, -0.243138282934726, 
-0.169269635570802, -0.331266823518629, -0.322984892847023, -0.419662084792129, 
-0.141366236693988, -0.0465978630065901, -0.131149050728822, 
0.149357840180691, 0.0623074068795511, 0.158866995578409, 0.0686062710171227, 
0.284473522133367, 0.169464358929494, -0.103068905772019, 0.123889459346647, 
0.0266922318871987, 0.158690312876628, -0.130067311622041, 0.180874389483135, 
0.137293534488465, -0.191214452593404, -0.0763735139208896, -0.0289147731035054, 
0.128963967944768, 0.0475788391393742, 0.0329677840344873, -0.0265914513562836, 
-0.0047571284312778, 0.0218681697207236, -0.211477551784038, 
-0.00940962427029915, 0.0124170173513716, 0.000559131879178694, 
0.00549427670211997, 0.170666394265990, 0.0304992034358451, 0.277068638751037, 
-0.0668281632412092, 0.427267821100618, 0.177797876657780, -0.108722153714213, 
-0.284812686081105, 0.00659653322801976, -0.00858965585927551, 
-0.0876571605608536, -0.106977982841948, 0.0404593591705874, 
-0.0451401115228469, 0.14078266614099, -0.140873804682743, -0.159356233639093, 
-0.107308274983473, 0.363824812126252, 0.00814850032395148, 0.0448063517956675, 
-0.262057011068437, 0.208975396211713, 0.018419859908014, 0.491603207569037, 
0.197755953248311, 0.00275053579599186, -0.138273015703856, -0.0490406087488828, 
0.0585138877787805, -0.132014644655485, 0.0330677816807215, 0.0137251399668372, 
-0.151016869008888, -0.0869566108166704, 0.0360588961305986, 
-0.134816446673762, -0.146801322340189, 0.250777517870518, 0.146311576197322, 
-0.140426917658190, -0.150452301814621, -0.126294838643310, -0.123858124673312, 
-0.329665357770874, -0.0110247344080719, -0.259926371622306, 
0.148066462321084, 0.125116043716759, 0.0218128260563914, 0.0556311582273972, 
0.283491213737553, 0.139206431312591, -0.118462205256660, 0.0707627451929059, 
0.0145039783318662, -0.203286234518342, 0.231627737749283, -0.306295319915251, 
0.0262152896072818, -0.150836366269252, 0.0347754141971211, 0.0722430399653114, 
0.183562471803536, 0.0202848264995054, -0.112037785763662, 0.209171717168914, 
0.270400101988192, -0.208134164017563, 0.0103006112681256, 0.067788542901294, 
-0.228385139581565, 0.158319655303144, 0.216995276726753, 0.0704485916715679, 
0.0264442971780852, -0.00479254273100143, -0.0504467911097625, 
-0.0805801057199282, -0.081875957217529, 0.0385950605364776, 
-0.289585433628406, 0.232299654136142, 0.064030578195853, 0.0513044587036867, 
-0.0290264457999167, -0.043849955471589, 0.0348782292110724, 
0.125630270824452, -0.151744962162351, 0.344047760276331, -0.0642187127043649, 
-0.122819257314729, 0.168236239658309, -0.061145948029627, 0.0342588872213172, 
-0.0835707446450923, 0.137163281894353, 0.0616445754728126, -0.178629530531098, 
-0.356451579841927, -0.218475333942844, 0.239396221863446, 0.0455476112308314, 
0.47807329512991, -0.275125528849159, -0.0982983304269449, -0.0512672402918093, 
-0.0958623390399983, -0.208617662418459, -0.221228107595905, 
-0.0695741939148181, 0.207100827737932, -0.147534388224959, 0.141250873889460, 
0.112168608427409, 0.0154265818771095, 0.110127663906370, 0.293876559731595, 
0.0587452600992329, -0.101695630436183, 0.061634012212646, -0.0554138133045551, 
0.175987934392195, 0.0179693709553782, -0.128123555893272, -0.00631875835853927, 
-0.307851656351223, -0.232777651521182, 0.219928503993341, -0.00767764395704948, 
0.295283273353598, -0.190178348140415, 0.0200836371784083, -0.172303164006078, 
-0.019916883328905, 0.185905217260664, 0.134239508484116, 0.35378328167195, 
-0.120377085855969, -0.0862122066441455, -0.115153670786462, 
0.64191696269866, 0.186089917933237, 0.221197815241149, 0.0274126548326194, 
-0.173663760551166, -0.190868911712590, 0.253832009944226, -0.0796499988701783, 
-0.152912625521506, 0.158564256082749, -0.164416936905745, -0.338085716526111, 
-0.0419798197591057, 0.079653962395111, -0.174814057178494, 0.0916866319152622, 
0.040802776146503, 0.0780844623993157, -0.000904643131164318, 
0.0220348866870459, 0.110794504654896, 0.209341578303365, 0.263792266233071, 
0.0349152920415423, -0.0259210044187623, 0.0716567043867298, 
0.00436822541915827, -0.112669640207194, 0.502417412722156, 0.0129987867375443, 
0.136144725862932, 0.0402566897422296, 0.236646348589184, 0.0360036088554677, 
0.175134481933516, 0.0214067363047615, -0.0160271535035251, 0.0842442863974707, 
0.134490335326621, 0.0192777790314903, -0.167632870106259, -0.0787782446797642, 
-0.272406090920731, -0.00481009017627317, -0.0176926013023319, 
0.0219024823665246, -0.0289644326366252, -0.00131774514089133, 
0.120991388513086, -0.080641566919031, -0.122193818607029, -0.112189507988353, 
-0.0893526409663143, -0.0127589474894754, 0.220277540647913, 
0.096590488326182, 0.0628002126627614, 0.163915155738735, -0.0686287116078283, 
-0.00827481383585986, 0.132248955781262, -0.0315505891445566, 
-0.0610076487506164, -0.0687971739473397, 0.0349983091728584, 
0.0209434082371812, 0.307463377930311, 0.185644173325833, 0.0246959532823227, 
0.0129000376826190, 0.039388468412787, 0.172035739795313, -0.0693632904612561, 
0.247287581939315, -0.138801571820683, -0.104744392114111, -0.0958372583943055, 
0.00535042384320092, 0.298428650240131, -0.0440598684464423, 
-0.172776968384802, -0.144719440730843, 0.205573936347847, 0.0522527520481815, 
-0.100045772412593, -0.0662344276240967, 0.127232729125894, 0.238649901463243, 
0.181210973169391, -0.274731997294456, 0.408512972515519, -0.257467006383946, 
-0.072456452859408, -0.00114472864549421, 0.108129916904767, 
-0.167606725726805, 0.0400463696465631, 0.108813399332858, -0.0082034925009622, 
-0.0630488477471723, -0.108828494965700, 0.0402685418264967, 
-0.324209030233033, 0.582057849759694, -0.239996229334759, 0.151396199185997, 
0.223536672905255, 0.0999830542940482, -0.140159610687794, -0.206207573769134, 
-0.040423209148141, 0.00749660557933206, 0.166793924139145, -0.0237479994335657, 
-0.110727179487651, 0.0299166744201847, 0.0288519086607954, -0.00219372828252397, 
0.000787077975280466, 0.315493403532623, -0.0084112119602079, 
0.341142159138229, 0.0251961208512577, 0.147246838099204, 0.0855155277850524, 
0.00652654352671238, 0.189047810949238, -0.0954268368158985, 
0.0228223436612516, -0.160740281751563, 0.0217029021703828, 0.0142829859064857, 
0.00193979043758383, -0.192314112068356, -0.111776893004686, 
0.126486830763887, 0.0411973592936229, 0.169389253032923, -0.198551518260124, 
-0.0554349790815875, 0.138696799722905, 0.40564590683243, -0.0152039637897623, 
0.201739118992291, -0.137910292378123, -0.0419415880864479, -0.227736130639803, 
-0.0320404706434257, 0.142791062533779, 0.107465063198838, -0.0213753187564688, 
-0.150816149657752, -0.0395846546917565, 0.0118076022882854, 
0.163430386424808, -0.0753785740120953, -0.150237614352578, -0.229647878057078, 
-0.265442297265016, 0.392109739674394, 0.179791342045411, -0.0554313744723233, 
-0.126328474815865, 0.0515865037336249, 0.158891728960802, -0.193346450697151, 
0.111469209247547, 0.0603176487905906, -0.397250332586976, 0.175793484703855, 
0.155352671417198, -0.00340338438597108, 0.0905852459885443, 
0.11845424017374, 0.384864067955867, -0.158200009304493, 0.156981991284146, 
-0.047741178970831, -0.0234867923615546, -0.420809251837542, 
-0.0460350693120684, -0.0718583649363637, 0.0428173200048126, 
0.291793628712585, -0.100860702931191, 0.0871657909288788, 0.291237887276686, 
0.0965648048894861, 0.0723356415852724, -0.0325194174729241, 
0.165071795097047, -0.187827566559979, 0.0904130977761698, -0.0103796428911311, 
0.308561098970509, 0.0973600996253036, 0.377251510515392, 0.0426681713848816, 
0.108701912884321, 0.22869628446329, 0.21445196557031, -0.114205460615471, 
-0.0574025643547678, 0.088340708760352, 0.121344404609270, 0.087299689886299, 
-0.0564931319967136, -0.00965842764695762, -0.0129698555519166, 
0.191198174261883, -0.212743959715698, 0.0148895783433158, 0.0453369102338831, 
-0.0320411701021048, -0.0449910471164692, -0.0377268494573188, 
0.0252483573289535, 0.401939893040271, -0.261102315607773, -0.116412684669900, 
-0.0180159668487182, -0.20401304133783, -0.0109200313660398, 
0.0368621465596313, -0.0569727820117497, -0.0745049082106642, 
0.335238621097881, 0.119282386148597, 0.171764102643274, -0.187232376966927, 
-0.0936465735978179, 0.295678747259379, 0.198206083386147, 0.0640845882405911, 
0.370492122197502, 0.0843072629244112, 0.0272777070377308, 0.442331450412568, 
-0.148094460173928, 0.176077708011280, 0.089336537482693, -0.0686696280827226, 
-0.119898901963065, 0.226619696099192, -0.0663321013975068, 0.144700142090920, 
-0.142768233747872, -0.111197438789077, 0.339857124320190, -0.312711920440704, 
0.0218846285565577, 0.142142093213215, 0.129109195774886, -0.0943990439498864, 
-0.0222413467316353, -0.382273729527762, 0.0363245905628911, 
-0.0192875323645167, 0.0722009534086289, -0.132751467469042, 
0.132501966512929, -0.0656405000086164, -0.175834590100979, -0.0834450852984272, 
0.150530659133085, -0.0145070406539697, 0.105578798582834, -0.077175306562125, 
0.0155921442752762, 0.0295941585362585, -0.176322516710758, -0.170973926296642, 
-0.0158246329940161, -0.0792020715522436, 0.101321576281270, 
-0.118714438343539, 0.225884809133176, -0.0375013788421757, -0.0141416277672929, 
0.111658218222337, -0.110988516588416, -0.119337706754644, 0.0387038074415543, 
0.073553527702456, -0.188243118207757, 0.045896469916104, -0.172453230768465, 
-0.0377345865519911, -0.39000260144994, -0.148834285196318, -0.0209224471616284, 
0.158700716653485, -0.0958940222993539, -0.149858157968016, 0.0297472965570650, 
0.512408070843607, 0.0809575928613323, 0.0758365844497662, 0.197899625142790, 
0.0041449764166297, 0.171584292009690, 0.76502276271263, 0.0580066664660141, 
-0.136990975822829, -0.361478694035411, 0.0900893347731296, -0.0958728561852313, 
-0.0564580195140932, -0.183350208771435, 0.249819181962556, 0.167747601478043, 
-0.0337519359631371, 0.158472974731347, -0.00135123856768266, 
-0.00611121394314759, 0.202441201133881, -0.252456425874357, 
0.201105571270376, 0.269743803009587, 0.0691741487545524, -0.0277488590972831, 
0.0212898890616695, 0.0403482111791831, 0.185619101995046, 0.130791702008987, 
-0.0196909171127555, 0.268246867523342, -0.238652430080850, -0.207242665728678, 
0.187938529370306, 0.0854432562912267, 0.0290069834403119, 0.0404145291800991, 
0.27778425350563, 0.0890496214486735, 0.0521670289689694, 0.233717832450089, 
-0.127586535875862, 0.0474676252754197, 0.102545879208967, -0.105387768153394, 
-0.0736572743565822, -0.095357415229191, 0.246092700486163, 0.155684781092642, 
-0.093840883666353, -0.0743797396155214, -0.145066425418943, 
0.253342676447539, 0.0603147189278727, 0.0829891552726057, 0.0607033242934023, 
0.193894201011919, -0.00259441521834535, -0.0193639379156916, 
-0.175101965150794, 0.404517752831202, 0.216049641078971, -0.0818296387762714, 
0.0741955655482327, -0.0757476029732763, 0.126853634888120, -0.00933660710980174, 
-0.273405024367354, -0.0732706888884128, -0.157547730778602, 
-0.163671301646675, 0.0680369350718307, -0.121786069956059, -0.243797317112124, 
0.0634278471207363, 0.228866750566153, 0.261542434054951, 0.0639561981729855, 
-0.218331197628632, 0.0444349834007622, -0.0912507606318592, 
-0.149824518484686, 0.0858652673445306, 0.122478087926291, -0.0757794613315986, 
0.125437832864490, 0.245274328665835, -0.0757162456844362, -0.232272521011528, 
-0.366364874265843, -0.183644839253474, -0.0207865884586298, 
-0.284651087315193, -0.091884718721714, 0.128081965919701, -0.0404608393025127, 
-0.416850664860276, -0.13229780738205, 0.117747706032114, 0.0469682405955356, 
0.0531053480707639, 0.171389806924259, 0.168410073184829, 0.00129285857293122, 
0.0221913150751395, 0.147059534842749, -0.0464565668502483, -0.0667074664473824, 
0.0153820679762696, -0.0064391457341483, -0.060985060379305, 
0.427151409297452, 0.214871726724187, -0.453783649053011, -0.0212974538064189, 
0.079609832577976, -0.253570376868372, 0.135174613652071, -0.0384623075338492, 
0.377654613223926, -0.150109600244186, -0.196739869201841, 0.164605707893287, 
-0.0882779379346126, 0.069278177543106, -0.0427201933135395, 
0.255738877570176, 0.0527252045115023, -0.108767968852264, -0.0303831229022529, 
0.0510554113727358, -0.131002240503120, 0.00212521334909402, 
0.0417744603863547, -0.00991482338621987, -0.0223892262651591, 
0.0835969688499325, 0.407559544578506, -0.249849447127265, -0.257723369911382, 
-0.301075427818911, -0.0642383540483868, 0.0921038917811179, 
-0.275765461973773, 0.0260100779001989, 0.152776749420067, 0.0434490577561237, 
-0.054482350154786, 0.395125069564765, -0.181723425100523, 0.105831892076228, 
-0.201059533885722, 0.505761760684674, 0.0542663962308559, -0.195271054422865, 
-0.0416318066605903, -0.0457098017225087, 0.0387637892157404, 
-0.122367604055545, 0.1122842171693, 0.0451717432806381, -0.0280893969357085, 
-0.0135063065352813, 0.155576534313137, -0.0595691626528876, 
-0.0505185144578398, -0.0282113339860405, -0.0301301399927702, 
0.00133505746040071, -0.281145176535248, -0.148426073223880, 
-0.247873880781445, 0.127940272772580, 0.00369104703543057, 0.0915983320214043, 
0.0498080089446902, -0.123944372150603, 0.0104310174107486, 0.107609883845114, 
-0.0492279794534002, -0.0122770233531035, -0.133428339297979, 
0.240979188534152, -0.134568412652677, -0.0106261910097059, -0.102115759916211, 
0.21360603032208, 0.137205730305229, -0.189622499585074, -0.423786324038789, 
0.0571898558188433, -0.0432171335817111, -0.0835157801054245, 
0.223803531451026, 0.0145570522770546, -0.0072996721294905, -0.255129351081331, 
-0.0999490741162584, -0.216688807961841, 0.0615978104596345, 
-0.143331711185844, 0.0084620662819872, 0.0346180737495276, -0.0715082747900369, 
0.141113772603391, 0.20718742819524, -0.0676540142441103, 0.125017168672244, 
0.153110500000404, 0.0292295522692825, -0.0467354816097025, -0.256033548831593, 
-0.211323135637996, -0.179422552030552, 0.136935788803931, -0.102875640424657, 
-0.219752094502192, 0.202123117631695, -0.254217449680233, -0.181034341897444, 
0.0111158059690381, -0.399170045408508, 0.0273243367806969, 0.194332503116179, 
0.147022068187721, -0.0905183676635412, 0.0889111237616636, -0.241268468768422, 
-0.0548969481225207, -0.0761020244798325, -0.0749327252421499, 
-0.0696219490063506, 0.176120776495637, 0.261039637622404, -0.0322608613235441, 
0.0806238033769013, -0.152064279267066, 0.0885535714401325, 0.22815654886931, 
0.312198324959159, 0.381709318981987, 0.00444900393454631, 0.0871833523263172, 
-0.0645259907603272, -0.0365810848025853, -0.0267428991082448, 
0.0887411515379397, -0.0757538470192789, 0.016717430753456, -0.0417090568101361, 
0.0656643322681658, -0.106888683699938, -0.108833664853002, 0.025430957508454, 
0.185237160528056, 0.0467260483180853, -0.0528881353173254, 0.469846914846138, 
0.313964834189217, -0.0199998302506812, -0.226408551311456, 0.457614065950073, 
-0.225951793388287, -0.142818033258238, 0.0586864508254477, 0.0481207714981756, 
-0.0551153027807167, -0.0885846897540128, -0.392286429665607, 
0.0454694561842481, -0.115972486597537, -0.110796044120611, -0.160249775242673, 
-0.0117549516075684, -0.184068705738920, -0.00494893773136893, 
0.152224090662698, 0.155617203894181, 0.0277035585357183, 0.200535967839334, 
0.281030241548402, -0.208967133612356, -0.171475590454976, 0.221839520350640, 
-0.0678402414261544, 0.0940918308822581, 0.117336547279709, 0.0745274021384861, 
0.0806912969509796, -0.101543996372089, -0.040687378311702, 0.0694380092836322, 
0.295615397735437, 0.109753112838114, 0.00634579234181571, -0.0547960247615668, 
-0.0408437146515949, 0.0722429964057937, -0.112698789045369, 
-0.164365146687529, 0.104633223657791, 0.297321845901796, 0.0193031765556611, 
-0.209770867541779, 0.171269238680683, -0.016821859861359, 0.223493685062974, 
-0.0419811675628382, 0.0779107702691672, 0.0388241817492838, 
-0.0219446945355555, 0.228288685561773, 0.160836595284454, 0.0103189540289803, 
0.0131387722371704, -0.0392795721197695, -0.0802317165580279, 
0.135774867735787, -0.247355322524366, -0.0423450576672384, 0.0488152556681602, 
0.0921502945996839, -0.0608702883559726, -0.0321684132555502, 
-0.176410207842732, 0.314169402908187, 0.25362418936356, -0.0139892256080735, 
0.0322428650692691, -0.250660990900872, 0.149345722764835, 0.0539511611482532, 
-0.0857943485507524, 0.116887246762714, -0.222142557579317, 0.26329105507377, 
0.0302169932081246, -0.303579672707037, -0.114209456718995, 0.0201584529841612, 
0.0740030029389643, 0.0950521695854472, -0.078777440091102, 0.00253488999101064, 
0.0489590163613249, 0.0636846077654244, -0.0200612363477268, 
0.243305522702594, -0.0721374668110208, 0.0235669803888344, -0.118678472963021, 
-0.0402451570010386, 0.152426747213521, 0.0669692086094253, -0.0212617166306065, 
0.120917769239359, 0.0660298826007044, 0.0824607565105504, -0.141022239328172, 
-0.229291412148008, 0.070103802750434, -0.0115472742594695, -0.147346795693634, 
0.0543998453713504, -0.252229268473922, -0.116999526124372, -0.0673018834139628, 
-0.0900675638709076, 0.168151210044642, 0.0266647794409082, 0.00944589127305667, 
-0.212062750377647, 0.234179184562598, 0.255827873104313, -0.0459131856701597, 
0.153647378314740, 0.0355872148848541, -0.00391678138227936, 
-0.094662512041345, 0.0758833027850541, -0.110075693894287, 0.0532855694246638, 
0.243122002768204, -0.0271441724387974, -0.0191751706315662, 
0.193265910392442, -0.115421948430594, -0.182098178222946, -0.0402953648558688, 
0.263565466032418, -0.237948569223846, -0.0835703139361084, 0.143222692148391, 
0.0428908545844446, 0.00383458651912522, 0.222103665312594, 0.0642091905357334, 
-0.0422530475921324, -0.320677321644138, 0.073656201281906, -0.147768973699805, 
-0.143928686936157, 0.203004387712968, 0.0350829328319587, 0.0536927595343728, 
-0.115338791887856, -0.0372707186161051, 0.226229583020757, 0.168236154241713, 
-0.0616395939753314, 0.273974136331630, -0.0663693071090341, 
0.0590796545544993, -0.206617063967494, 0.0790551525064936, 0.235339910244778, 
0.409857735807914, -0.284379686478846, 0.258197129615038, -0.015033287019984, 
0.0530091814503799, -0.0813281234798334, -0.0385794892956136, 
-0.0305322166634124, 0.308799134472912, -0.0405555291125218, 
-0.152212518465653, -0.156465473897146, -0.367521772602323, 0.0226383743992883, 
-0.331895853998770, 0.0723410519122317, -0.212859599584826, 0.116472479239863, 
-0.0836190847765618, 0.0615604087972277, 0.0313028826597427, 
0.112797280947838, -0.0253987291133716, 0.103122132453224, 0.345175961755889, 
-0.0610306619747209, 0.00519654178843067, -0.0729704011225227, 
0.0557274516367648, -0.0531765137283549, 0.294323682752847, -0.0324346636218021, 
-0.0131139456932930, 0.114345855171226, -0.120031720050999, 0.272602841351367, 
0.249961874146925, 0.302987808290482, -0.138371411191170, 0.0024088823789876, 
-0.0215579897098087, 0.228273371866818, 0.192704153309565, -0.330803138229401, 
0.171369392087315, 0.192883450202311, -0.0557260069166683, -0.0585004079126892, 
-0.137198614134869, 0.0569114193151784, 0.155130368778835, -0.0655540219459377, 
0.253630749954216, -0.127219741686234, 0.239345124834766, -0.15617822943851, 
0.263311094685203, 0.131777706821501, -0.0103461883179246, -0.000872022632111548, 
0.253310196612985, 0.17305869256243, 0.0640320734029095, 0.0845425582192637, 
0.0110629730525578, 0.0131621181933962, -0.0657006430723236, 
0.160844288112198, -0.0079209856741422, -0.078257913055463, 0.0353013094562501, 
-0.0621723179815618, -0.119116849047575, 0.190971893594903, -0.0198740517336916, 
0.060691498753814, 0.120913419059316, -0.172044286741430, 0.0127930137879516, 
-0.180842808385352, -0.0737577816367944, -0.094076183549868, 
0.193207427732636, 0.0315775484315884, -0.282925564564906, 0.0278977091540137, 
0.142721781828526, 0.234068026210553, 0.0913669442553505, -0.160822827349624, 
-0.149323640968888, -0.195987966401647, 0.00108381561005925, 
0.176461400565128, -0.112846003965382, 0.0123183755290966, -0.053799959800984, 
0.0270765323195429, -0.398883394198887, 0.279446222181906, 0.114469327024589, 
-0.247880551281094, 0.270213194729290, 0.126873487307246, 0.090036496383764, 
-0.00772677566192394, -0.0209249806216367, -0.268225444724435, 
-0.183276498327583, 0.198304013705187, -0.112331934910048, 0.0469823922564294, 
-0.277522985289959, 0.08919354317931, 0.137436745235483, -0.0262992727311273, 
-0.136507671491352, 0.198658854366115, 0.298012142674031, 0.295539442998596, 
0.0694223684655559, 0.299804250185484, 0.297471102110108, 0.349029006482534, 
-0.0638220628954475, 0.290547465541666, 0.265038575283365, 0.381811709805551, 
0.353159614118895, 0.125874662479870, 0.0749112488957054, 0.450403730868457, 
0.385635438514863, 0.225296410164884, 0.313348549355384, 0.381410039790073, 
0.181189413565491, 0.609108689821623, 0.257423669747583, 0.236740835248226, 
0.517787172563686, 0.356293969729651, 0.557480885533275, 0.462787043679648, 
0.0444912290124814, 0.475694081654073, 0.338711561649423, 0.1795401859857, 
0.272998722989625, 0.194153660551151, 0.497055138188757, 0.306695095058634, 
-0.00121160330178383, 0.615898882527064, 0.726034891004247, 0.135003567315130, 
0.527473455880344, 0.563303161727047, 0.343560232484398, 0.329977345635645, 
0.625729679301813, 0.0965273897859931, 0.375139966633038, 0.225808901836267, 
0.458401234690181, 0.225679289132966, 0.00749007158651963, 0.305565797382886, 
0.365911066801778, 0.0620260034114483, 0.0503225663539792, 0.362757116602642, 
0.369967430733269, 0.468106017508637, 0.284360664568296, 0.440325096604349, 
0.237217704926834, 0.285160986854464, 0.475804890237597, 0.347320817643065, 
0.275109848769902, 0.347907980091266, 0.42425948877963, 0.321418312446614, 
0.481652228108147, 0.445677235342478, -0.164594973210283, 0.346429633537294, 
0.729862770272736, 0.345152439895919, 0.445412665651898, 0.236360466176622, 
0.402768260652195, 0.351229683464478, -0.148858164367137, 0.463968850833967, 
0.244679903306579, 0.143360366303583, 0.523975775782521, 0.45628368537863, 
0.401995560403282, 0.138895364471005, 0.228350416009714, 0.571838377338963, 
0.184136186365223, 0.39335299866692, 0.418577856331693, 0.391729561123405, 
0.205789619456073, 0.161319194436316, 0.331876085799, 0.443410230293082, 
0.42644938085955, 0.0588998308207831, 0.696920749773451, 0.151640029325741, 
0.413857053629817, 0.264653625535000, 0.240369479955198, 0.471327385092261, 
0.590822907975423, 0.234759407508986, 0.382453634336199, 0.34717858612323, 
0.331180693927161, 0.128739421378217, 0.198793156825187, 0.693481000331426, 
0.265299459029282, 0.418657838691121, 0.202348783035926, 0.650996516605928, 
0.197684884232881, 0.553606341211695, 0.162121343675697, 0.336156776967069, 
0.229350432532308, 0.385307829561825, 0.320802332014531, 0.421612702180468, 
0.309735967442337, 0.108389914065168, 0.318842324226095, 0.353407035664123, 
0.414171304101475, 0.117302129702834, 0.402184884818336, 0.479146472719804, 
0.0245113306424451, 0.247490079566476, 0.313874994796039, 0.250090646891571, 
0.562939404645724, 0.359035056067319, 0.56508446433619, 0.381029031913927, 
0.335214936408369, 0.432698430202885, 0.168393084377191, 0.187449799306091, 
0.490425177737058, -0.0743174409542958, 0.516495985282616, 0.455016599248415, 
0.275121044343068, 0.392003218283862, 0.484758356877367, 0.268854437835674, 
0.240782136722364, 0.464851302335772, 0.648729736725727, 0.375118148940030, 
0.374199709157166, 0.234980937563758, 0.274732123451925, 0.188443564095078, 
0.390210318862982, 0.315519622002227, 0.405804310681601, 0.324883256321773, 
0.420590233429985, 0.43896781315067, 0.38852175424074, 0.715523058706039, 
0.168103237847730, 0.389755840539010, 0.20772264863534, 0.354751535411307, 
0.282094071267177, 0.30381415755186, 0.263288996710604, 0.156737879632572, 
0.319237750892188, 0.470564654183198, 0.177136017836509, 0.320280352295664, 
0.173162052402854, 0.183740760797505, 0.508170354441685, 0.230509396020276, 
0.218563119235707, 0.706113959635874, 0.291932224538581, 0.180402923404190, 
0.138034126777464, 0.0692886765851901, 0.15121803948136, 0.304384029604613, 
0.197736101188703, -0.143320610718937, 0.207405164838191, 0.271066623016082, 
0.272507387906476, 0.43064203012994, 0.39479469526115, 0.358290677111708, 
0.631082618383906, 0.0885020119831563, 0.349354384303312, 0.179773897920451, 
0.287698262562326, 0.388030243058833, 0.219290594564718, 0.472376975579939, 
0.204559857156133, 0.251725993878614, 0.259331211844447, 0.431955303830854, 
0.216641663134368, 0.248081940689394, 0.27697996279514, -0.237225133372699, 
0.0379230866438483, 0.140517412933129, 0.314445825716421, 0.347865571028288, 
0.300755894395054, 0.349260303872237, 0.202412443008864, 0.297432665543796, 
-0.0221896578261038, 0.321758550083224, 0.379394890868738, 0.350326872133947, 
0.134293325688747, 0.211821556899389, 0.376728938727334, 0.269178018949194, 
0.321772126793509, 0.286526569077558, 0.214116950503449, 0.632778771884703, 
0.305812009225849, 0.402258796641891, 0.0958658274294962, 0.41671539561598, 
0.441894231169441, 0.271055400793845, 0.101824680252309, 0.388620700239996, 
0.211505399883814, 0.204724010044837, 0.455756973512651, 0.282350752762067, 
0.353139788723083, 0.720678064820417, 0.380821488852297, 0.154197007104473, 
0.396438345414355, 0.545289304414973, 0.469476012986048, 0.723263603795516, 
0.467850057225145, 0.196765084005716, 0.58793256220008, 0.221082154664103, 
0.294780157028022, 0.25847172669615, 0.00462524546262731, 0.143988563101849, 
0.457843924399712, 0.261154144273173, 0.308370511424555, 0.347225893046592, 
0.283119557652933, 0.849672450260776, 0.217632255201512, 0.479849434392888, 
0.0860327067198646, 0.112406169363195, 0.179540495754755, 0.150947453291584, 
0.339281308832165, 0.158110377382019, 0.201895794726065, 0.317680643485881, 
0.355693800774727, 0.282313802562633, -0.000843323714833288, 
0.473587739236218, 0.414166976431479, 0.566094407564543, 0.362406756778106, 
0.430150352716469, 0.457699560406547, 0.286643713494769, 0.536215562959808, 
0.341711049163698, 0.373258214200366, 0.0263701309822965, 0.158779962597386, 
0.08670757460304, 0.19249605760365, -0.0276429593496363, 0.57707878490399, 
0.457216053977578, 0.273042120524371, 0.43238702664335, 0.245652471182152, 
0.471486607165118, 0.121458010689735, 0.404911408061493, 0.344562867375588, 
0.375608549610144, 0.286312684147385, 0.444836543503497, 0.266450831717109, 
0.204692108244961, 0.498197241733631, 0.181290822483580, 0.472669876077852, 
0.0695356924999329, -0.0150378471779597, 0.477396703095072, 0.170128136344301, 
0.416164954915809, 0.239151288489185, 0.343990415089301, 0.170871609168741, 
0.468517963423675, 0.414657216701929, 0.388697408754769, 0.295391984539077, 
0.177826829784702, 0.36874629447309, 0.462058268771318, 0.0737821212909572, 
-0.0566388116856767, 0.398296481458969, 0.128439787039177, 0.270107928460796, 
0.125837056084596, 0.00919775095601236, 0.261591548899165, 0.380646396847152, 
0.280491762093414, 0.365224910704933, 0.611260104507989, 0.343919170813422, 
0.287945639377301, -0.0382946405564513, 0.418350838662908, 0.237205067258709, 
0.250483942954637, 0.593184594636276, 0.492749101921649, 0.511675520220784, 
0.591639281621358, 0.361890629501724, 0.245084015198214, 0.422714122798231, 
0.198578458117629, 0.420157198731828, 0.345945545547113, 0.229746917201202, 
0.436926745333494, 0.407252442335291, 0.380515769087253, 0.0658543277439312, 
0.2370102257871, 0.75772796443932, 0.295959535603009, 0.352216399861848, 
0.410572656271254, 0.0781965008869619, 0.285925273848387, 0.171984742042055, 
0.564132787859261, 0.33971833681608, 0.418127345715201, 0.127001362069509, 
0.144548631720157, 0.319341647708110, 0.49264601680458, 0.439762509166778, 
0.214503192092976, 0.446736861126773, 0.386114798549793, 0.361138784157893, 
0.261911022234102, 0.368195258904184, 0.494635360122577, 0.106174215277420, 
0.321436927251763, 0.365377775890344, 0.287412386987033, 0.403372390472495, 
0.459443467322077, 0.320098800404119, 0.172687858347099, 0.365230443204827, 
0.401966673695724, 0.192717766155664, 0.427617950066357, 0.220357568320513, 
0.367819969451407, 0.407208579948732, 0.396097112523241, 0.201627182025556, 
0.286117707000733, 0.500919969162555, 0.256608381333185, 0.178187565738756, 
0.161719158870153, 0.476157274968451, 0.319198565612060, 0.440107092058427, 
0.204356894163448, 0.3192189256198, 0.549208886375275, 0.124415252383337, 
0.434173299083622, 0.469633429662348, 0.131194055430531, 0.395066726561124, 
0.388953242780583, 0.404151504273999, 0.413580502354533, 0.219397903094629, 
0.234525559326947, -0.0966623233965032, 0.488158258888592, 0.355493354997689, 
0.228040319179339, 0.511233926550239, 0.319333802918075, 0.402148432269047, 
0.0916486705062305, 0.445079349652001, 0.397982242438230, 0.600234965839515, 
0.381516495580693, 0.106851732245650, 0.475315200661345, 0.221050989119881, 
0.434050175156413, 0.500307479123262, 0.511403605562879, 0.381653056214444, 
0.316155763705041, 0.113535018573831, 0.204448109850629, 0.411342402707076, 
0.0480260911040145, 0.442352511510424, 0.30622269845616, 0.429093497516507, 
0.317420504575149, 0.384198519936213, 0.237272983866734, 0.377652193495061, 
0.235891051735385, 0.414750050625489, 0.163378210503821, 0.100488601834275, 
0.354988945592742, 0.241256643827504, 0.170579256818755, 0.421269187264264, 
0.539769795502187, 0.397363000144515, 0.500217232420226, 0.128157597850253, 
0.48665025314265, 0.279517313898077, 0.218886065786655, 0.421484684754418, 
0.269176221874498, 0.301717967152764, 0.516858045434091, 0.383855895028831, 
0.384490694213184, 0.413712992463054, 0.386008980833017, 0.269410107471583, 
0.408416674695223, 0.376628926026382, 0.177028706343897, 0.0512186109666889, 
0.142490231824352, 0.304455216388245, 0.697640659174172, 0.293165623440630, 
0.132694470042413, 0.413191914991373, 0.338202827831304, 0.317010116669835, 
0.187161286713001, 0.365035956418291, 0.341031836596953, 0.119566652009989, 
0.0604717290346679, 0.307566800920560, 0.407025221127298, 0.267953650961976, 
0.382428666022007, 0.317736953739116, 0.301437661691257, 0.232119996683364, 
0.475037735415969, 0.168567953927050, 0.390539498995374, 0.288790192155542, 
0.523045649323439, 0.066311620934195, 0.205683821877579, 0.331931121412781, 
0.444244478766489, -0.176746678136050, 0.267341721242022, 0.254260863665563, 
0.106670537034697, 0.271353703786526, 0.517888969197565, 0.56777774566883, 
0.0224486059041618, 0.412593558516421, 0.489370987114102, 0.0742788174971234, 
0.537480722973334, 0.560030627253654, 0.292569268809868, 0.296529858381048, 
0.226472992723978, -0.00354283034291647, 0.264686133968438, 0.163552094134256, 
0.279009548898926, 0.343423915711675, 0.568739636491342, 0.346537691391448, 
0.504940029667605, 0.532018798727207, 0.638584728851606, 0.241801548928255, 
0.444523881584871, 0.116354829110795, 0.493785812161957, 0.440318588839251, 
0.314660853705776, 0.440614834435567, -0.0133263079369501, 0.33192716575914, 
0.360982402476501, 0.154896826242925, 0.446140163982946, 0.224312981183422, 
0.313641352195659, 0.290874766144453, 0.427729692518734, 0.255817260893364, 
0.472842421215518, 0.303229791997827, -0.100404724043160, 0.299635804931711, 
0.664909180248132, 0.518524179856801, 0.0655881624069144, 0.308809126194278, 
0.54615134372677, 0.154146086359482, 0.283007600306651, 0.419911918368371, 
0.247454624228138, 0.314554072393893, 0.123332768322886, 0.103921443658176, 
0.395809192933950, 0.094079368907836, 0.276647788192475, 0.437312140653315, 
0.200647702656550, 0.280802350992585, 0.197213801938346, 0.10155383572045, 
0.575390978329606, 0.135738870427668, 0.271603355879791, 0.343627615062098, 
0.169243309329047, 0.232208931272065, 0.284014651515687, 0.389022960556717, 
0.270772627396037, 0.203002406119733, 0.195202280732566, 0.429127883662607, 
0.224856456715142, 0.381941263733956, 0.545871876647876, 0.340432404984952, 
0.305786797411436, 0.549493182172915, 0.594453310077122, 0.482800883281824, 
0.118323122892805, 0.224758658091329, 0.402855044472304, 0.159625084485941, 
0.407299115081227, 0.441438963419384, 0.429679291863154, 0.519349071517046, 
0.383681363913987, 0.428290640528066, 0.304302117809618, 0.167581287995794, 
0.536658357767838, 0.236109389358318, 0.173773507248357, 0.281770841376477, 
0.180644522196549, 0.336187518861552, 0.512205053815922, 0.404848198511762, 
0.51564145464327, 0.248828572925097, 0.187818677267011, 0.680332140663563, 
0.308965635769815, 0.208066080280114, 0.0339781768144294, 0.068145061331442, 
0.206933465664176, 0.366351535546468, -0.0559293012231669, 0.538106516348831, 
0.23715043069865, 0.33584274620338, 0.374376820727685, 0.603225761348544, 
0.354310715379709, 0.645680622721162, 0.450687656743753, 0.172681606438352, 
0.132947387158093, 0.329285144752995, 0.265256591995213, 0.439146619536749, 
0.251195055156577, 0.185435101370936, 0.0911306456991821, -0.0060681941253757, 
0.501336616386782, 0.114929808741213, 0.343124975662152, 0.595335844968769, 
0.550473081603261, 0.352150837236461, 0.322220029566896, 0.374431050305758, 
0.42840465143031, 0.313740783469234, 0.496765078667785, 0.3933097544416, 
0.204146523148258, 0.309811705879458, 0.107655834669604, 0.457553705062025, 
0.250797096137412, 0.442874253183017, 0.198618825389305, -0.0633696318100252, 
0.274205020452388, 0.319467627446981, 0.252836670006670, 0.535213418754831, 
0.510922431501133, 0.204477921643075, 0.294460616330242, 0.243886665392477, 
0.313851870935193, 0.271411724108362, 0.308970192500480, 0.365974322382247, 
0.271387238620990, 0.093762380696181, 0.443987567586495, 0.181553971310551, 
0.0972068314823356, 0.194457394169355, 0.376320047282603, 0.39714370440278, 
0.227293703131648, 0.343398925771693, 0.307603429520147, 0.416193050812734, 
0.298919373533727, 0.319987679551956, 0.44323361037978, 0.517193543471399, 
0.287235176412589, 0.277581297525822, 0.329641552724496, 0.397713293620292, 
0.471110644426256, 0.372101529541921, 0.253140740191708, 0.147862913957276, 
0.113596157657369, 0.3678660145004, 0.374408113474246, 0.326950060698863, 
-0.0685214653653169, 0.120022943332076, 0.377506473740257, 0.230296748894244, 
0.436673049711936, 0.42514626521011, 0.40066480924673, 0.349371620847022, 
0.558158596150924, 0.388480820603781, 0.215673274928933, 0.317510305181019, 
0.398598143091949, 0.402199554135402, 0.199647739285834, 0.130733608759450, 
0.19679380055018, 0.173561093825333, 0.114942688203776, 0.181311157773641, 
-0.125965188216132, 0.219116354307721, 0.30960321236518, 0.341859327420623, 
0.630636101793994, 0.334023052618366, 0.159071165927887, 0.32944488853262, 
0.312641865062362, 0.373337368485345, 0.408522946063264, 0.280183861568438, 
0.443774428792113, 0.452147501009054, 0.316388445202158, 0.291240197559797, 
0.255232528029162, 0.547771249018854, 0.729074815935722, 0.343205707883136, 
0.393988460835854, 0.44209230298241, 0.403130111976754, 0.0964346164197638, 
0.405063337494244, 0.282735404172421, 0.389496030200338, 0.258535309196189, 
0.384553786389848, 0.391607458494834, 0.0313340402367538, 0.175297545398226, 
0.224814576953525, 0.205725362517618, 0.321124225703019, 0.381803433426026, 
0.356871268978377, 0.230559273386968, 0.433159477607387, -0.0407891358513539, 
0.387545294347076, 0.349726006067571, 0.522626063312428, 0.488883237411096, 
0.119794344764701, 0.0599844846314844, 0.229849619070044, 0.287895329975520, 
0.261936972866735, 0.331852704500265, 0.246027699603273, 0.306781397335942, 
0.260606391268427, 0.416500352575909, 0.626200829482575, 0.363376053797263, 
0.411665585452986, 0.1709008906477, 0.394851324896577, 0.427877802294108, 
0.521615202496062, 0.468149641191644, 0.173459259586133, 0.215111356895658, 
0.256074064973498, 0.433563695491698, 0.267524918186382, 0.351737886003795, 
0.139802586405692, 0.463020427201632, 0.217190323513054, 0.351800179486873, 
0.29948704587758, 0.297947594854008, 0.786493674401965, 0.498008262554261, 
0.275134457222963, 0.346714153142283, 0.313080198537602, 0.241881313103322, 
0.0693047665652073, 0.196233183383379, 0.232651883597942, 0.236456468180617, 
0.252995407143643, 0.190905946677212, 0.422519607193729, 0.261450455420427, 
0.318040650342393, 0.465155498057873, 0.210979616884546, 0.224996298225553, 
0.410805041319179, 0.460316847238555, 0.296708288075006, 0.354492815497715, 
0.371122470531359, 0.363033663627255, 0.646306425946395, 0.396337617185067, 
0.265921977709483, 0.284506765239824, 0.266378894226771, 0.334439273238982, 
0.180020137201384, 0.178422667503226, 0.0311422529371402, 0.379602205983953, 
0.175408622142099, 0.583487712049462, 0.305065707224501, 0.337073114941078, 
0.242139133106867, 0.350778514725123, 0.494738245195007, 0.739885549127556, 
0.356374577455867, 0.221126813308416, 0.115127211204158, 0.362004023302193, 
0.34718717826209, 0.208724968772544, 0.321176014859684, 0.360831461250363, 
0.303894699132482, 0.323706551229272, 0.434210940725697, 0.449070153337069, 
0.507794001822638, 0.373678909326080, 0.204721362238386, 0.463167753633286, 
0.51679656880183, 0.314740729640001, 0.47689242122158, -0.0583755689628783, 
0.251264949837556, 0.306684143391099, 0.607439218988422, 0.391677284702931, 
0.223376191667061, 0.274996909784093, 0.32014006366884, 0.345161575423373, 
0.302746497734061, 0.394767641468814, 0.367448175461616, 0.472331920456057, 
0.508512783069033, 0.48101569042575, 0.125760552113968, 0.174637731756477, 
0.326314386590524, 0.357921540897097, 0.382297930661714, 0.342310584768509, 
0.336279653767599, 0.392943610251708, -0.0388690492280416, 0.157212190474633, 
0.314201517022742, -0.0926727848692965, 0.288551068736656, 0.444716223627245, 
0.366896463913651, 0.317927835696799, 0.232553069965224, 0.221431295267289, 
0.247160996108112, 0.217943505923897, 0.115915757580769, 0.229564857034421, 
0.287346672706333, 0.267411410347244, 0.364402606050864, 0.340581470039353, 
0.418503119106161, 0.099617392679111, 0.228660518710394, 0.472053140616952, 
0.381087258538323, 0.476096964121581, 0.118785452098994, 0.496599564294799, 
0.163167545515388, 0.325088590315653, 0.0808031021009896, 0.259678755131064, 
0.64272305851925, 0.0388829840921738, 0.180294040148761, 0.434385462411534, 
0.324461465775067, 0.250393989347769, 0.107309298961400, 0.360103154094793, 
0.262436556640892, -0.0368287712056054, 0.399459441602097, 0.263440636963565, 
0.324774753883276, 0.29941874424743, 0.371377963567427, 0.188604119523224, 
0.318343217587475, 0.270370332582204, 0.227969586098938, 0.424384327242342, 
0.221303502092340, 0.286367053622412, 0.533624372817693, 0.155141408955381, 
0.42103228173513, 0.308448401019001, 0.117174027842580, 0.331883778757692, 
-0.0167175708461817, 0.388971118762272, 0.0713901594460537, 0.50459013343717, 
0.261564673773744, 0.50318667235841, 0.446265702686363, 0.464070615903898, 
0.183877522401972, 0.188254158456786, 0.292417749475905, 0.454386556504875, 
0.206271505533962, 0.409819179433278, 0.222664658221546, 0.198088434387282, 
0.164473873691889, 0.310776736658631, -0.0220484515138234, 0.292922721869990, 
0.25942919924749, 0.31383239775694, 0.481677711583511, 0.357947819278155, 
0.433520308881553, 0.421090486047741, 0.168080662381194, 0.527368558735785, 
0.00368202602814023, 0.457841261873145, 0.0477498369566717, 0.325268672515522, 
0.166339328753949, 0.200434488480364, 0.561248705819696, 0.372878498474791, 
0.572602010950452, 0.303396025567244, 0.39236535370041, 0.219859059339353, 
0.462284379639902, 0.496818876216714, 0.254058188310969, 0.41115670077247, 
0.294098754252520, 0.120528445845849, 0.310831808315927, 0.489167835670052, 
0.328949719230754, 0.296077969024505, 0.27744142082989, 0.259633489130923, 
0.182865598761032, 0.0208272665430166, 0.316711335816998, 0.423080117639382, 
0.472651533724086, 0.108234077944161, 0.338441411626907, 0.519370118300755, 
0.671286847408451, 0.63001814007139, 0.596316679585781, 0.752655964123252, 
0.642801845166873, 0.627091692341751, 0.687424353135812, 0.628011614302281, 
0.380976575783664, 0.529716487702685, 0.630405234381131, 0.541776716490197, 
0.748506284315755, 0.600776257833145, 0.545768230196053, 0.557036986946544, 
0.63531708920687, 0.633011683423797, 0.631696695608397, 0.592926325829417, 
0.870188746274855, 0.713271806638374, 0.764000723496042, 0.621948285108621, 
0.507372869273189, 0.596969145724243, 0.713413715936003, 0.613800386242287, 
0.594692375617752, 0.211171069671602, 0.72888202440434, 0.582056304290605, 
0.61019739992945, 0.404522318384433, 0.345008329640843, 0.57512292651739, 
0.68164464262018, 0.595199972529224, 0.624239769507493, 0.632841664372664, 
0.760733273305655, 0.455544345121535, 0.63945059099134, 0.260864404123975, 
0.654444488283183, 0.623308124540621, 0.588346470134466, 0.75814365797627, 
0.533734202982425, 0.747072017005214, 0.750438267449255, 0.653822065186412, 
0.581523113597453, 0.569983596308385, 0.517209344548737, 0.602961673581928, 
0.584083630487316, 0.466293520041533, 0.691709247286307, 0.592711825792286, 
0.704175324190875, 0.542257581415571, 0.600096208496977, 0.588651097238197, 
0.508709586415333, 0.421227038164659, 0.47882402282419, 0.666002974931647, 
0.74167253926391, 0.719838052305407, 0.461207251966373, 0.496171373689048, 
0.613016384489136, 0.643817850879853, 0.53482613286031, 0.564030848281714, 
0.61063961362447, 0.808654085241577, 0.42165857190645, 0.365665316305505, 
0.617566315952731, 0.168445313024439, 0.77286830811611, 0.62082417559307, 
0.57368047983573, 0.828748525801485, 0.378860671124167, 0.589805507497605, 
0.422518135102451, 0.646288605079658, 0.612072916914857, 0.405277497974806, 
0.60358871217178, 0.576649039701318, 0.352779853833102, 0.601830990465612, 
0.514862124726406, 0.635581348438682, 0.645442226946046, 0.56637276654573, 
0.486620920069695, 0.753794915675377, 0.641678284858292, 0.807079338843054, 
0.609778824751909, 0.689558646377258, 0.761060916482562, 0.500159355629783, 
0.520629955810154, 0.798827849004698, 0.501148068934352, 0.514590424408958, 
0.614748851422156, 0.632952576455052, 0.337981440211579, 0.462177892864111, 
0.726300407937345, 0.664465908707578, 0.538753333269651, 0.650058685547142, 
0.542474544802676, 0.643064047371755, 0.608025336910077, 0.651430276013309, 
0.609629359489572, 0.76699600049479, 0.561888213266263, 0.63505341858361, 
0.643733817428083, 0.48990319188083, 0.505067799061969, 0.516603806516233, 
0.400396994688073, 0.527486667254053, 0.35794964838929, 0.55745450208556, 
0.514621836805799, 0.736419774070906, 0.643570353347152, 0.513249718186961, 
0.662024987139621, 0.813131065438053, 0.5526585551929, 0.625694935262234, 
0.417720252723775, 0.757291266357916, 0.595284236701697, 0.418464769771702, 
0.487004507896992, 0.664051759276955, 0.662744750616335, 0.594323287824968, 
0.655164530659622, 0.532483894459562, 0.586709086434585, 0.643011206401602, 
0.54318972255514, 0.557076315148509, 0.621359248421063, 0.598866648226402, 
0.784436067826459, 0.523175457241095, 0.516603991535763, 0.825378659508853, 
0.574694481893654, 0.560127823411026, 0.58499788693839, 0.478031343701876, 
0.709893536527132, 0.706719529293488, 0.598986351628214, 0.50494621450562, 
0.53627430403976, 0.642751402708634, 0.500953266629589, 0.752422866029841, 
0.451255184821858, 0.507584716068881, 0.612103934722117, 0.585912375310024, 
0.816841832740975, 0.722484781529811, 0.740779557382813, 0.685747572551643, 
0.541925794484098, 0.642571651009794, 0.597597311990316, 0.618469896390571, 
0.296357972073075, 0.638163440645619, 0.457901665319387, 0.597884679084778, 
0.700167455307532, 0.541024792115069, 0.604321854346871, 0.610471536472283, 
0.363252862547969, 0.715424513429629, 0.464163173077143, 0.496782115460907, 
0.610373894932227, 0.606093222952432, 0.679125832122576, 0.572482314392028, 
0.645894568300805, 0.612396547574435, 0.699807442207711, 0.665922388691031, 
0.716689521031131, 0.631632387442687, 0.484812040303657, 0.432936802579391, 
0.637444674358257, 0.533001249810818, 0.389263610964232, 0.612079879450859, 
0.625424243495378, 0.578128710240348, 0.449969311432301, 0.753569153091191, 
0.617266494516328, 0.253772292399728, 0.474858852718772, 0.805046980351202, 
0.434309986175486, 0.601230488591231, 0.549462192977778, 0.285409695483274, 
0.667425973057767, 0.546013107497052, 0.669497808689972, 0.890003114683446, 
0.530418821293043, 0.68698139314302, 0.68302117681193, 0.71613038284098, 
0.542981823144073, 0.500454267918073, 0.580589653980952, 0.651748934347427, 
0.561235587980813, 0.656916991936766, 0.585179751069118, 0.550907787487465, 
0.779031245679453, 0.438269561569865, 0.503292309919134, 0.475172998663437, 
0.583809963489046, 0.611728034465039, 0.578614548099509, 0.608783064096779, 
0.347772380981475, 0.68962173775417, 0.390194294850648, 0.492373228208151, 
0.615176497263007, 0.70512582267341, 0.514386529917625, 0.700347277087487, 
0.469794219613379, 0.574295713723762, 0.704956720979827, 0.864075979012463, 
0.648918502565172, 0.681047492805537, 0.58932901802076, 0.653894501626926, 
0.636748459294507, 0.728043743639359, 0.556484550895955, 0.621329183236732, 
0.63371745850556, 0.493732151018663, 0.729181918634546, 0.461720369340688, 
0.669209461011409, 0.744182632916385, 0.611999169297103, 0.733797671090831, 
0.863153888674952, 0.569853771126838, 0.451353879224909, 0.504450505613734, 
0.443529915138963, 0.750254224886681, 0.727701197330018, 0.659594438974366, 
0.401852086373462, 0.661595492683299, 0.601916735522401, 0.519823615919561, 
0.714158299014485, 0.402799071907316, 0.51673343850319, 0.610113711414212, 
0.548349683277364, 0.623698693306343, 0.542953981688944, 0.565230351222832, 
0.669938766847408, 0.699636619539942, 0.660353793964101, 0.713643140419886, 
0.664484864905138, 0.744582794274644, 0.849794824475098, 0.692228292292913, 
0.59462680046072, 0.593536885673977, 0.71291625363357, 0.437860964347491, 
0.494514770583837, 0.602512019177072, 0.617449018228252, 0.601549136892563, 
0.475348921984636, 0.641757539453459, 0.377345202793912, 0.472864051410128, 
0.711024035325673, 0.477899252134841, 0.488625529993022, 0.643712349236762, 
0.641873668157024, 0.612251755538928, 0.446690633630623, 0.554799286567349, 
0.658098151550182, 0.422470842890808, 0.590609083472415, 0.688675276851831, 
0.397051268447102, 0.671369253682248, 0.626547145345614, 0.4676807788085, 
0.607309082812794, 0.495992659546862, 0.69566037178882, 0.662918547774531, 
0.56814947707464, 0.444278960025616, 0.526211159814062, 0.624306793003689, 
0.596854045920013, 0.627667404883422, 0.589787664360698, 0.430552640561519, 
0.768594010051113, 0.399548828560404, 0.669188923165177, 0.826696831961893, 
0.662784656701922, 0.5742168511109, 0.649668097635702, 0.326808015877077, 
0.440021903899713, 0.539014640377341, 0.548254136330605, 0.713241490960097, 
0.503356735497276, 0.527263306107066, 0.628947009519544, 0.551044512466861, 
0.421300497729309, 0.562468581922607, 0.654523080403406, 0.494581303714545, 
0.617067898639088, 0.318374161783251, 0.742102346332448, 0.5057618462594, 
0.514974182659459, 0.542600808588094, 0.677361084951845, 0.665962764348613, 
0.62308290606698, 0.466212085769795, 0.690375976022796, 0.64515206639535, 
0.595157486253497, 0.452794029022613, 0.587557504843814, 0.685549503738478, 
0.508918630760378, 0.544061428699879, 0.669511551033544, 0.487365878905625, 
0.762417306276875, 0.412782085224663, 0.560427876875168, 0.6134233827566, 
0.513792607172033, 0.693889507427442, 0.603406343522912, 0.74220907522658, 
0.516418060541408, 0.573475766236898, 0.637009088677726, 0.560490381900772, 
0.778881116735739, 0.735215151852527, 0.378373024168815, 0.696953408687506, 
0.786464062021598, 0.575330791726223, 0.747580745641857, 0.791246197712924, 
0.59056110289598, 0.559441629573181, 0.733761562716807, 0.382431228294112, 
0.657951199912787, 0.791591891734794, 0.620874956263610, 0.687299964963555, 
0.560253544736593, 0.634927104178383, 0.433987748243964, 0.805672334284888, 
0.781702624293362, 0.667146362216818, 0.764769089851916, 0.7127629321781, 
0.760021415884728, 0.755114746306605, 0.777401431661015, 0.618567026265895, 
0.420241066807562, 0.493186039032174, 0.512404739932925, 0.650900041846387, 
0.181482713904094, 0.425835208748842, 0.445162229920189, 0.648473050436914, 
0.685990695840019, 0.525125519167464, 0.568122799560562, 0.546356873888507, 
0.56919269063699, 0.444807742498328, 0.749097829640677, 0.527490848988144, 
0.523100060464953, 0.497576235922396, 0.795341631453463, 0.682708357178031, 
0.546744347722306, 0.625356362475982, 0.530711673079291, 0.61036425042448, 
0.640802349055971, 0.544941013457941, 0.607084738522154, 0.855548748285537, 
0.426791785108128, 0.544945958989139, 0.747554872907084, 0.635018378933728, 
0.530060442236188, 0.6362649721868, 0.59906273965603, 0.709934394208218, 
0.574694219893129, 0.779176217480181, 0.544841757068692, 0.429766772631377, 
0.499282560806045, 0.783908241416687, 0.490506565932796, 0.384467922290384, 
0.625327079700246, 0.559272638058183, 0.725435050407261, 0.671355435012088, 
0.510094045000624, 0.526044758142865, 0.700533522236304, 0.690363897161687, 
0.549328914939014, 0.640838266430233, 0.534210313180442, 0.717970683039836, 
0.459261640001815, 0.39854259495223, 0.598875571018131, 0.882067703182288, 
0.448099919576334, 0.525678616395356, 0.609899085813519, 0.474422075664442, 
0.506714119487273, 0.381784790308962, 0.70290689805636, 0.734451354240357, 
0.586687602580099, 0.674371766116223, 0.3352004516631, 0.814069621957919, 
0.635515822599598, 0.726930532955375, 0.670502215353107, 0.43072930803778, 
0.56040978927617, 0.584407838592829, 0.637531040151282, 0.742986891203921, 
0.464308386439678, 0.637393945466187, 0.67485453128811, 0.540936150348772, 
0.782186172576872, 0.84951417329691, 0.760489655482419, 0.578314737581526, 
0.53948379904591, 0.599032520753099, 0.524913004398132, 0.562093827332396, 
0.56082492882749, 0.563508397266091, 0.711970628522298, 0.698328881351418, 
0.546113990171722, 0.58335182775777, 0.630458359699684, 0.806308558943148, 
0.655531267482093, 0.755817740121282, 0.751368347367928, 0.651588496361881, 
0.513814228408818, 0.605952434967728, 0.688731234025047, 0.478561316397608, 
0.52689752180298, 0.712281394673324, 0.597392429814567, 0.405046317356689, 
0.533352814389882, 0.742037279368204, 0.62165174002993, 0.724863960984546, 
0.695247271122206, 0.583914115180571, 0.57113426901314, 0.551468122450025, 
0.523045680123766, 0.481981836823196, 0.666759235574188, 0.397676319270764, 
0.748874437583414, 0.470658917761126, 0.710439053179436, 0.730658495908016, 
0.343320392690253, 0.607235898151914, 0.626645717429429, 0.455503160806321, 
0.626086937144464, 0.559574035823297, 0.76473137695809, 0.705315812196472, 
0.576850601145998, 0.487566095711988, 0.551774223003994, 0.450244245868873, 
0.807760769612667, 0.416603092061277, 0.710229337425496, 0.418718632843299, 
0.633676158463602, 0.627030906763139, 0.636430644710851, 0.512381882400249, 
0.798182187401603, 0.868139621393651, 0.433314916957976, 0.628285681903285, 
0.58347586646936, 0.556407810551144, 0.447966346524436, 0.791821033421289, 
0.556636962920726, 0.900853572047598, 0.612589671818177, 0.560058596803257, 
0.452240147059807, 0.593605631174887, 0.239942705367835, 0.313983005171785, 
0.55848487165578, 0.748853499298472, 0.440643396151067, 0.486669088647742, 
0.438076506481345, 0.639775473551532, 0.70532658648035, 0.670472827263474, 
0.806932292533423, 0.534742918111599, 0.782233648445492, 0.543582699138578, 
0.85589503088699, 0.705380273797135, 0.769955738382037, 0.70657980942545, 
0.671603461541456, 0.691267004455244, 0.65401506275384, 0.723012383006251, 
0.67076128133329, 0.640825203872571, 0.452971657448868, 0.427543842564259, 
0.458299940061287, 0.612991834551536, 0.709400397697568, 0.484390936167175, 
0.421297586386789, 0.508479279379907, 0.73634729452231, 0.804934666454786, 
0.660615328790592, 0.739082283367146, 0.596505337985241, 0.753675256688457, 
0.373818790744495, 0.697808033495665, 0.508988960650621, 0.54081935960014, 
0.395691746227843, 0.495758850445354, 0.738348828459717, 0.78743904963074, 
0.5565963585498, 0.440966281562161, 0.691352784114204, 0.586538259700786, 
0.639422250676064, 0.67183063708168, 0.522393033456839, 0.721985030096943, 
0.767021819614857, 0.565324101573554, 0.421710148373704, 0.633848361153562, 
0.753072510671123, 0.800127359468691, 0.602061379994031, 0.658220698548548, 
0.536166686537547, 0.484021800926654, 0.760389991768647, 0.510970953257085, 
0.491097754747383, 0.539631901532166, 0.89862602631161, 0.60053401736999, 
0.830446163003308, 0.644725256766853, 0.72686152940912, 0.577755610330869, 
0.651398942387034, 0.708438556817042, 0.532053733670147, 0.621125955051333, 
0.672781564553335, 0.560621681653798, 0.568711497687806, 0.462138951059857, 
0.640297531613933, 0.687461620135701, 0.310020061735512, 0.63760072285426, 
0.412621451154602, 0.551215727371923, 0.763436755091468, 0.619468149045487, 
0.693095367300574, 0.635771007066989, 0.553229901805659, 0.516356115144397, 
0.574640947526543, 0.431958011383603, 0.489826758304792, 0.558944255146057, 
0.760576355151945, 0.388312376495133, 0.346065178356338, 0.235023934941328, 
0.71280040760781, 0.570199600900665, 0.538320597213346, 0.708357948213969, 
0.728681093761352, 0.566991737906236, 0.622688132115936, 0.755695839375944, 
0.67006347801659, 0.549306275180973, 0.657366907688318, 0.529318482413878, 
0.528588406316392, 0.62096788468267, 0.837268983919155, 0.605774898377071, 
0.705921078278805, 0.55260374637496, 0.585192840868886, 0.597767197891019, 
0.637112819378745, 0.717861010374943, 0.4853547700295, 0.603217204912621, 
0.529293836758643, 0.335305046873515, 0.677598425525253, 0.665721815945107, 
0.734961785930994, 0.784776971043908, 0.539010864471101, 0.667166932414512, 
0.599999611469816, 0.628082980903154, 0.408696590911293, 0.158453404241292, 
0.58378940966676, 0.637469948042137, 0.56353744206039, 0.639861909418952, 
0.590021740462197, 0.644727227399005, 0.541358113472061, 0.578213517440986, 
0.581153032070526, 0.832091273330008, 0.570999244954445, 0.599555634421069, 
0.518188588560735, 0.760297129677194, 0.61076375966836, 0.541343201977632, 
0.656214778619783, 0.534060118053306, 0.684092609770846, 0.503633625716905, 
0.730560181970839, 0.595886234999275, 0.549161053534696, 0.647605398690051, 
0.554057103213348, 0.471008512494498, 0.668995150567716, 0.646053387809814, 
0.528568369387017, 0.73550732351739, 0.648815109879549, 0.676273839797716, 
0.480086045361533, 0.515136349612902, 0.319137030763848, 0.714396391165248, 
0.764672543752589, 0.723388585123573, 0.71248010575882, 0.431182636160098, 
0.68767891513653, 0.709819205547546, 0.531912614599835, 0.712068871836444, 
0.648176342788802, 0.470414921005635, 0.593540287845706, 0.603253908801486, 
0.576472923346396, 0.476175378414979, 0.530915861313839, 0.442803984316135, 
0.654452370512957, 0.589534748815658, 0.47564008107245, 0.482442339981105, 
0.653296913360147, 0.621728817504303, 0.684799387965779, 0.643274897869024, 
0.624027514719118, 0.549391009531577, 0.554477272939574, 0.733374046873577, 
0.678788266457204, 0.705498917932015, 0.453180118036206, 0.483118104313175, 
0.650120475607273, 0.807545739179862, 0.787227750640533, 0.675829389787829, 
0.382516075995705, 0.46309694817918, 0.603833106400763, 0.586011713216094, 
0.80906586123451, 0.611038063281264, 0.869160378275136, 0.75523285281974, 
0.678144258917694, 0.630639296752286, 0.785382684848544, 0.752928910726875, 
0.68231161042866, 0.651234577421426, 0.604543080425801, 0.442814448581852, 
0.665311916579175, 0.682605081799296, 0.620389430413024, 0.536118271103270, 
0.576474654072091, 0.578009117292882, 0.479272806869804, 0.605961372597318, 
0.590316869922692, 0.534450574790535, 0.381323637780758, 0.606618453831846, 
0.625957880437356, 0.709778844796836, 0.323267408447685, 0.571983334710445, 
0.71211171647457, 0.438527720009391, 0.676499902940487, 0.744684216112916, 
0.669279161586632, 0.583228196623028, 0.562375768679780, 0.381340631347167, 
0.60582587886338, 0.639484383427787, 0.712412806999023, 0.672880773633334, 
0.478003804164758, 0.716395961048196, 0.701770103705706, 0.509849484357673, 
0.696391721666431, 0.789158712177932, 0.402819601313981, 0.516839496196403, 
0.584423387386823, 0.65961598841491, 0.683606967584363, 0.578164963469191, 
0.71265308275221, 0.577434424038524, 0.726267868581813, 0.58186137596618, 
0.512610656358399, 0.453261695586212, 0.680555730543385, 0.735853513875568, 
0.628379867875565, 0.242348247091403, 0.621603844251126, 0.687226694327605, 
0.631634632012588, 0.745404165068888, 0.613728123007724, 0.476990919715687, 
0.407104612504026, 0.660166310580545, 0.636306886692246, 0.598392332823755, 
0.535449532693158, 0.352630842031853, 0.656710305569278, 0.689870985968251, 
0.6229542828405, 0.489828878900704, 0.606209822239535, 0.498720761367745, 
0.385324620624067, 0.759763058812932, 0.670207695475127, 0.682436941160119, 
0.549809258311802, 0.78530479252711, 0.335931596026877, 0.604758051429086, 
0.612626820121917, 0.634179622641684, 0.537266703671352, 0.583332611802564, 
0.615658033545553, 0.752764851270139, 0.721213779151129, 0.775795568112737, 
0.549482186739608, 0.578391110180021, 0.479602538299353, 0.642523933165035, 
0.655813344861591, 0.666796514769602, 0.640419760156315, 0.589262993032306, 
0.773532359845287, 0.580085010459407, 0.578870788900731, 0.716780753026129, 
0.660040216205049, 0.60851138335268, 0.698713060484675, 0.5336967361661, 
0.508399343132718, 0.565298350317359, 0.712753119093075, 0.658094875331069, 
0.698468996418883, 0.5145827425949, 0.88817321861269, 0.615917851066582, 
0.622105928019143, 0.580798007635632, 0.403113674253043, 0.764694275636884, 
0.56563896831169, 0.442167941206258, 0.690530592756196, 0.86568778943557, 
0.582648547975802, 0.562091514391051, 0.542909654951245, 0.73346898742226, 
0.730267945293905, 0.604465286803387, 0.484916742109755, 0.282603763630951, 
0.386334576799481, 0.564780937085696, 0.631365291039445, 0.633303757094925, 
0.649997202888155, 0.52347811349876, 0.434715774440174, 0.733591398725544, 
0.652338528346956, 0.884984094284007, 0.647820589233411, 0.488571336250494, 
0.497605931508463, 0.764828848613908, 0.548641007099586, 0.795417811599926, 
0.571702758171044, 0.499618961039201, 0.632991287923964, 0.495984484183286, 
0.7016503875466, 0.786207942657321, 0.802403196068212, 0.543307779206161, 
0.511554475228981, 0.519070686949771, 0.422561926547437, 0.380166207644776, 
0.645023816803786, 0.589121296204284, 0.364689231045029, 0.631597880713721, 
-0.00198623645673729, 0.531763351195339, 0.453946681308142, 0.839388146228564, 
0.58892731063189, 0.314543272979676, 0.620487945377426, 0.70779607341899, 
0.460136229474067, 0.66427383514274, 0.639274403866067, 0.357861938569595, 
0.460288241317826, 0.52820504335514, 0.459360274946407, 0.543203333263186, 
0.182406015443938, 0.560289063103742, 0.75458303420255, 0.572674976281404, 
0.839983123298882, 0.647251872801993, 0.505389317818247, 0.616197054037957, 
0.417188680695985, 0.526823743078899, 0.444080335784915, 0.89511933506322, 
0.846773152676287, 0.808167620625463, 0.936584415146692, 0.74545187235163, 
0.834593269687304, 0.907185645608956, 0.796923305883644, 0.923496370009061, 
0.916427598235624, 0.858547797599268, 0.88710086751415, 0.841605206687847, 
0.860780070228195, 0.873840462622983, 0.776956234609861, 0.952565231213837, 
0.79662125359404, 0.833518920033635, 0.74242606590522, 0.913744680431579, 
0.776879439825677, 0.814880238418544, 0.744407623122625, 0.89119913308051, 
0.973807911778658, 0.896634065233205, 0.928570228466766, 0.830635407410678, 
0.857058313005436, 0.906153840824862, 0.903259638467334, 0.879416217669369, 
0.89237224209525, 0.697999353371886, 0.85484681250482, 0.850464192447829, 
0.823724738615293, 0.832340714808635, 0.810412716085979, 0.777780743444876, 
0.902851308130358, 0.964986838233138, 0.86767987822129, 0.741002464509707, 
0.912457982323639, 0.818862782521288, 0.897579760165307, 0.785719666394083, 
0.814579192385028, 0.900698526835567, 0.748606136326465, 0.834174973949896, 
0.845963035607355, 0.927560706799999, 0.838692149002788, 0.897558588423893, 
0.859513739001083, 0.885462146485842, 0.89129962759457, 0.651136433089245, 
0.836604962620825, 0.748696622580657, 0.903204213173609, 0.841373474277254, 
0.817660821452478, 0.88295341396688, 0.814721059628804, 0.811271495627832, 
0.767372754199352, 0.862452455133146, 0.872548736954865, 0.79088300736737, 
0.716701720229641, 0.892861137729957, 0.816930731878418, 0.90037744738597, 
0.903906902535208, 0.834856172254159, 0.890074380172023, 0.897998625198904, 
0.838703027293095, 0.845741136158486, 0.934405305794414, 0.85683295260507, 
0.916443438627439, 0.938102032073583, 0.795874466389385, 0.889059643721695, 
0.823372386147516, 0.875441224710346, 0.732781520768905, 0.893009882070306, 
0.920226709333772, 0.893720069636247, 0.825376897997394, 0.972717942439423, 
0.910450447443762, 0.839647189772656, 0.874166635975704, 0.852224158852172, 
0.776994028741757, 0.807886398469922, 0.789310119409975, 0.913260484816486, 
0.843621227810083, 0.864287677988547, 0.917349329895692, 0.844229805991516, 
0.833111037060752, 0.842598184841284, 0.788119515060113, 0.818256219411964, 
0.897975880064794, 0.94803739946361, 0.915079752368508, 0.840676572705891, 
0.930585100461151, 0.922320128709729, 0.880228832779998, 0.825626155257821, 
0.718446374611689, 0.83467270417452, 0.787262954240022, 0.806102583557268, 
0.768290621023256, 0.823014865208531, 0.858100186612746, 0.830739536129368, 
0.761537591428576, 0.756373353820261, 0.670978892032234, 0.862787720508426, 
0.821605282534483, 0.78719150274375, 0.90381995108075, 0.7860192769453, 
0.848882921787973, 0.882259373329705, 0.797757594700278, 0.808808248965134, 
0.854692306655341, 0.72887465817604, 0.797413513780887, 0.862390268265713, 
0.898939742232918, 0.878371967105438, 0.808078286051287, 0.838072376094284, 
0.888093903294932, 0.887310999611841, 0.87745617084585, 0.918604768585857, 
0.905101474814251, 0.891635037022148, 0.827207931917288, 0.96618802043164, 
0.816336172829385, 0.858159317281512, 0.828981576217777, 0.938133949508748, 
0.875606000535105, 0.894754140546271, 0.928125138584833, 0.849130169830703, 
0.959780874089491, 0.869495587014115, 0.76180976407932, 0.846528391823838, 
0.851861162440072, 0.866952345894618, 0.805012305059839, 0.883231669153844, 
0.776466917960442, 0.916069787941312, 0.916723437776695, 0.858019502362058, 
0.956656133075782, 0.85615615423267, 0.779833301335338, 0.890071131998263, 
0.799005615848193, 0.930685616820677, 0.805302956818008, 0.893789380368478, 
0.86232900522898, 0.870718001507242, 0.915436973995857, 0.802440337641032, 
0.888502079374429, 0.847356147673849, 0.966190260762212, 0.879412669336532, 
0.874032283432947, 0.892141399977644, 0.890860727217287, 0.834144118813253, 
0.863823315615938, 0.892902947448525, 0.820695967844833, 0.828089897731566, 
0.945011475604171, 0.820225150639848, 0.807732102694357, 0.953199496868696, 
0.869504958643287, 0.81731489899633, 0.872091932386204, 0.856266142688928, 
0.884715380500997, 0.94368437367414, 0.865422659068492, 0.915923043268416, 
0.903521732725429, 0.885283879843794, 0.794290017357103, 0.843709394358523, 
0.789532017904221, 0.855756116790388, 0.919427969666209, 0.890416057694715, 
0.907361271797073, 0.843142661280092, 0.896428390156979, 0.871254046061008, 
0.803774242140793, 0.88987596850101, 0.85118629333602, 0.795033486488854, 
0.855907570807574, 0.817806169564645, 0.891498487744302, 0.920372223177087, 
0.94405685694911, 0.850686343842138, 0.916546042107843, 0.886548008895945, 
0.940794897633463, 0.941545061508754, 0.90268326466021, 0.899967361714513, 
0.81154838563486, 0.839701565449578, 0.855309300308402, 0.880300682796342, 
0.944818001425756, 0.887654821232215, 0.867688479055971, 0.900687590740996, 
0.828829690725148, 0.839093140563393, 0.956646377813848, 0.894545104612131, 
0.849692154718585, 0.886713773819203, 0.86239883703733, 0.879909835375233, 
0.83690936533696, 0.938591800179272, 0.923655039313136, 0.913708933386683, 
0.812117797352472, 0.921345833028585, 0.921131587326526, 0.858113441352878, 
0.835352797191235, 0.91393179636987, 0.90725101865815, 0.840709604224758, 
0.75745292795075, 0.920493161389518, 0.888278562815606, 0.726906014155511, 
0.821581732402626, 0.680959332519848, 0.844625960302634, 0.724374622600212, 
0.786655991745654, 0.81780930883206, 0.871070604906335, 0.736683944316894, 
0.901582455133635, 0.820760924118281, 0.805097830105633, 0.737309456739963, 
0.860230588712276, 0.891054221380914, 0.877200609702284, 0.84108624404229, 
0.808984524495217, 0.946715276276166, 0.813468042171823, 0.862823639493257, 
0.911143940621215, 0.896509666758626, 0.769100766886003, 0.802490399869526, 
0.944665384899103, 0.720205645365424, 0.875120986728974, 0.663710927785285, 
0.814648514445037, 0.892029314891595, 0.867459421987463, 0.9002290106465, 
0.950469813843825, 0.774441433044666, 0.924995943075146, 0.761239580405999, 
0.854587627474382, 0.815974132959372, 0.885487432384074, 0.773948572811345, 
0.949250439893178, 0.944589971419433, 0.901585493229866, 0.949113131329845, 
0.878895250124055, 0.947314311975761, 0.714315744082948, 0.864483045021689, 
0.879991411658365, 0.866560309004868, 0.786013198969023, 0.85301918433656, 
0.898549864622248, 0.854053217024499, 0.794327422249564, 0.946057439095228, 
0.857885649760683, 0.8157800826659, 0.856903414456677, 0.830246134005755, 
0.877907331649261, 0.889911875156847, 0.953554537610576, 0.939138411051664, 
0.912543200084765, 0.742331541643006, 0.74814997103899, 0.826846164809685, 
0.850489056128957, 0.85392212095898, 0.846443151362417, 0.870244068192337, 
0.870082027104158, 0.79299815968733, 0.956488918157505, 0.963081638745714, 
0.736991214116752, 0.811824374477817, 0.881005922069523, 0.884036626251706, 
0.794534529909453, 0.83659235276628, 0.940786557411955, 0.865597699860856, 
0.8289300615097, 0.861690144988028, 0.844835536475514, 0.841246790304327, 
0.787249297721015, 0.842071753583462, 0.856253990128014, 0.901958728533466, 
0.852839072196448, 0.839516417320023, 0.811262630832515, 0.877831724323875, 
0.809362219722707, 0.91128413236419, 0.932865022208372, 0.810229124678079, 
0.818503892200696, 0.937508286528476, 0.920408546561734, 0.886606898348683, 
0.86117916675296, 0.90131043098109, 0.914613438061998, 0.777086154630053, 
0.875352655165674, 0.882765080922611, 0.864049151199482, 0.733105829899975, 
0.921283865101954, 0.865697703963466, 0.897176151887694, 0.82496432745623, 
0.899399023598333, 0.87230263974388, 0.889976150218206, 0.833708264730446, 
0.849137736448593, 0.826198553755735, 0.88681296336146, 0.72022901198329, 
0.898576701628379, 0.80704774418698, 0.928844829309576, 0.904677849065199, 
0.951498889610369, 0.892839362576983, 0.788464272827673, 0.912869286823393, 
0.796480401635667, 0.90682641542781, 0.755743798735199, 0.761915720011144, 
0.879224061299966, 0.921794818024164, 0.847669297797262, 0.860353220872712, 
0.900796279893565, 0.809212683118458, 0.946006386879033, 0.685437690939045, 
0.80750261152428, 0.798022500453963, 0.936963388985453, 0.946878399918214, 
0.821826922369785, 0.921462180981923, 0.90244133960365, 0.888299351137503, 
0.855519896070093, 0.945281735189665, 0.855898273574889, 0.886971683695827, 
0.787256817214925, 0.861812546126199, 0.897774596858976, 0.862081291411278, 
0.95167717961157, 0.823272766233322, 0.839261792422371, 0.932480640285008, 
0.969402077767936, 0.947160437113485, 0.947293380977377, 0.825111689378784, 
0.912165311267717, 0.850702770457205, 0.922585952704788, 0.930670658304422, 
0.854937092268692, 0.827300472828336, 0.942404463389619, 0.870355634031816, 
0.781702409489897, 0.951220528763034, 0.902958421564331, 0.86526896631447, 
0.800053514307508, 0.822142809003412, 0.969392360225037, 0.893767942454795, 
0.91272830979136, 0.88913142395519, 0.915767317289324, 0.915282693861918, 
0.87474077848825, 0.839223198672687, 0.881719609654138, 0.867610875181322, 
0.87201858892015, 0.872796702404706, 0.861034075701507, 0.816233379744837, 
0.879688948976747, 0.930699404509661, 0.856025666254911, 0.815748977875817, 
0.796953275931618, 0.860804229538224, 0.856357299138516, 0.801581570987316, 
0.885210028573361, 0.872587678260717, 0.89555297003448, 0.812201773775792, 
0.810060847475674, 0.909308725323706, 0.884542788003327, 0.963877040181122, 
0.838997027804084, 0.886898288642116, 0.791727419349736, 0.854495371129013, 
0.90363288586154, 0.869464556829727, 0.713033840400635, 0.94808512326869, 
0.792292670195, 0.945958216629094, 0.914190100042157, 0.816140346576512, 
0.848072599740491, 0.962143165081185, 0.718395245503638, 0.87528191876418, 
0.854974922692371, 0.904862476827474, 0.749985027892898, 0.889111925110186, 
0.90294353313214, 0.823377151038245, 0.980016388845376, 0.936030059365294, 
0.72888141118495, 0.802419521430416, 0.873722767211501, 0.799107713684004, 
0.924082695158555, 0.914949925876103, 0.741943579773322, 0.80554111997139, 
0.884171203684347, 0.767109869152335, 0.915533988245606, 0.869298827579417, 
0.913762907038613, 0.878759790628254, 0.861631946592151, 0.845917598523548, 
0.85065508953333, 0.834776222333552, 0.754997307946686, 0.923983582403441, 
0.848288805243425, 0.891232842954851, 0.896872621761138, 0.81668531151462, 
0.955506614291708, 0.884866699876477, 0.71533499335016, 0.902717252709563, 
0.83274157256082, 0.94396768538212, 0.843460055490608, 0.891688714584307, 
0.927302641083506, 0.91250971571575, 0.851005974917283, 0.915098029310927, 
0.859482612104369, 0.887992944402536, 0.932721187632467, 0.859546413193978, 
0.782441603900182, 0.795261622136575, 0.881504894274288, 0.946257447189045, 
0.770544467633111, 0.789994308418018, 0.689902651745325, 0.730325598635709, 
0.95500505553571, 0.792281341330125, 0.762634925796768, 0.855887480292786, 
0.75899992889442, 0.847041573845727, 0.899044704541384, 0.81201180792667, 
0.848624962272946, 0.877883757434134, 0.861226930246146, 0.871814824360868, 
0.8727239507784, 0.829704862534271, 0.82158037602976, 0.870601307116719, 
0.916399684948205, 0.847823579952836, 0.8721206048967, 0.80454764578325, 
0.908408011439573, 0.90122750587574, 0.866096151883479, 0.927907041502703, 
0.902714507901998, 0.87325732240028, 0.901513287665114, 0.893825589700818, 
0.742403557895883, 0.89245025859267, 0.756559180989027, 0.880712998535098, 
0.86016451244274, 0.893832494120672, 0.884325673941444, 0.865854400599384, 
0.815386554109285, 0.806605756391035, 0.86379842855752, 0.852577353392133, 
0.84644697614099, 0.887309990837723, 0.88923976555771, 0.88433333284634, 
0.6707181212757, 0.94596513719339, 0.829765370921154, 0.9244072336846, 
0.834908554824638, 0.65169989435707, 0.862857573117546, 0.939918606380738, 
0.90190628004894, 0.913358246918873, 0.857008743553703, 0.870419736703927, 
0.911644850833046, 0.83642273974402, 0.931811932236871, 0.761379237962747, 
0.731437435841165, 0.777255288736235, 0.939153935522232, 0.905053650751614, 
0.915032524334129, 0.872633094629633, 0.836939653930789, 0.80491808481249, 
0.720626093584125, 0.874517010453445, 0.966470445737282, 0.81389656848579, 
0.862042788434862, 0.839907653109456, 0.858236521330345, 0.897135060279092, 
0.763398141595314, 0.822677423560693, 0.765720957132324, 0.754702428480408, 
0.854490942008456, 0.823581381243042, 0.874790677869093, 0.857284341718557, 
0.846941241207532, 0.831323227706466, 0.880003652794595, 0.83550135661849, 
0.857484164362853, 0.923378540966414, 0.707952981016891, 0.711413455904878, 
0.748010070019836, 0.86301931055757, 0.93951157241897, 0.842235004722146, 
0.893772601664778, 0.953765592229405, 0.941812932688129, 0.792337112287905, 
0.920389127687038, 0.901229523899478, 0.749306390393386, 0.82445674374925, 
0.770904431745878, 0.863127377933536, 0.723605461154815, 0.905352511371184, 
0.862738325246529, 0.83161551236538, 0.85086658878906, 0.826896928615655, 
0.935869861942033, 0.901855128326841, 0.88103216667297, 0.808157514101551, 
0.834726202963938, 0.879600315194743, 0.836685592857261, 0.836763679541956, 
0.945029407868385, 0.782950538937411, 0.960344567256535, 0.906383079736023, 
0.902873019681028, 0.854606012773883, 0.864153828735001, 0.811671855901985, 
0.891168133234518, 0.82624079448938, 0.892998194155746, 0.891687179205425, 
0.93203341006979, 0.835556104050553, 0.867115544615026, 0.943561491321392, 
0.880605875162565, 0.889195923301342, 0.958234173126904, 0.879489620300142, 
0.93422945550621, 0.837820867603505, 0.829786028228738, 0.881141772044422, 
0.86495326563823, 0.866981452113473, 0.903296126233969, 0.871559866535466, 
0.879608727395086, 0.7359945957435, 0.830156866811837, 0.851432643853356, 
0.795970007511483, 0.733557610086075, 0.87794083167475, 0.792201263006478, 
0.846517186900708, 0.772498995969804, 0.815958842869375, 0.777847523617687, 
0.92285198559301, 0.831905418661625, 0.942201577552625, 0.892421154134394, 
0.886666926178208, 0.868488563651916, 0.907556254972364, 0.88391575245475, 
0.868028948871889, 0.870788980375857, 0.694790620238307, 0.905282294514889, 
0.869882758148344, 0.858926183615132, 0.818176965927801, 0.793394303514978, 
0.856214600929912, 0.670668626407561, 0.793878111141908, 0.808082915207394, 
0.888494855388602, 0.76631566931936, 0.897130299669151, 0.935079781197615, 
0.79346606301777, 0.935042294390778, 0.836752549946779, 0.85820344782981, 
0.872915101210991, 0.872903482381953, 0.765564983240432, 0.88359499914759, 
0.894607047367826, 0.886155203195936, 0.955156823416942, 0.917800503224507, 
0.886526973136927, 0.812249420256529, 0.961331522461886, 0.89597461603449, 
0.89043469987405, 0.83152689533378, 0.846024490230395, 0.830220895917025, 
0.78272889998545, 0.953760175457841, 0.879869319081179, 0.832983138542934, 
0.908818630587399, 0.823568068043472, 0.846898301347959, 0.833477122960413, 
0.960876253602755, 0.908292704859488, 0.776858775930481, 0.91283806439945, 
0.843413627686852, 0.745431513388804, 0.834812289426728, 0.808402315030197, 
0.934753604833762, 0.963212773714895, 0.863997599946322, 0.894631932536227, 
0.854066619634112, 0.927733105590167, 0.765506481778898, 0.818933878923886, 
0.847219691913851, 0.9216200307557, 0.898142335577535, 0.714014338524961, 
0.896046989331527, 0.82252255084413, 0.905917542977486, 0.904992634368818, 
0.83786867026426, 0.871194710536202, 0.906519092176488, 0.762366883219011, 
0.900263005311449, 0.86166783341198, 0.834828547504773, 0.812489020920882, 
0.851216155571592, 0.895175382376323, 0.79933490105425, 0.843632184701106, 
0.881130294192034, 0.912191386181003, 0.888539807444735, 0.80891988744843, 
0.816396752285273, 0.947358784339455, 0.86680088106044, 0.855739535393073, 
0.784263660785418, 0.898963008266782, 0.908331625197397, 0.943545804812276, 
0.878773900829378, 0.844242003925527, 0.889257869501601, 0.774470645178151, 
0.893484351546117, 0.811682028485106, 0.852142170553278, 0.830504028208866, 
0.958351048893225, 0.85437719909502, 0.923614674862581, 0.852655668702629, 
0.855297542257706, 0.852464958130102, 0.846757609410734, 0.859788280053317, 
0.829347551233163, 0.931457641646248, 0.840932197662346, 0.95113250334033, 
0.774086175557819, 0.948815103662855, 0.921611661520602, 0.934074090507037, 
0.789814804905704, 0.77292436083235, 0.732520332619751, 0.848579916610279, 
0.893606229737317, 0.813190040711896, 0.916895185929992, 0.813821738548404, 
0.931466840907052, 0.873798862378268, 0.886586121760007, 0.83781885489255, 
0.806409560292193, 0.960709969826028, 0.74487622854129, 0.814514224783014, 
0.952956708816146, 0.847194406499801, 0.885900773946529, 0.750202533167963, 
0.887246866354244, 0.889632656476669, 0.900631717756596, 0.889538755155704, 
0.921994858975353, 0.822843999695573, 0.842520573013975, 0.844114350469783, 
0.943188333826386, 0.831879644164746, 0.928823390365773, 0.95558807538615, 
0.798627290256535, 0.888722493286172, 0.804507546101471, 0.822016503676454, 
0.899953107161754, 0.677494060058411, 0.85110072460206, 0.948279204966722, 
0.909478860164686, 0.927784571010451, 0.790198073695405, 0.812442858928211, 
0.762400972539042, 0.870917105573166, 0.87599624678614, 0.889722068851088, 
0.759217176036702, 0.82272966288563, 0.860760886981668, 0.877684620206526, 
0.756596183155554, 0.771118961045276, 0.880797491751137, 0.757287724407572, 
0.892458332260512, 0.843461363951019, 0.88002414272246, 0.759866033282763, 
0.832171004231447, 0.909333221802144, 0.88744838821926, 0.702151338440064, 
0.820002860170448, 0.876091853297579, 0.78670007583572, 0.894115602482887, 
0.865282083043793, 0.797014221038022, 0.881755499725638, 0.838953721185792, 
0.82757876077928, 0.949004170735147, 0.952301147229659, 0.794681235465755, 
0.828266662577738, 0.733870019073218, 0.847863109231078, 0.950690300535202, 
0.90385757979526, 0.788582514542978, 0.82697495151508, 0.830703073072283, 
0.797131507173857, 0.80863179468461, 0.860755562372722, 0.919548020260011, 
0.768159614160802, 0.86066965191546, 0.805566092924397, 0.737577040025976, 
0.923843892936636, 0.862421189714699, 0.796782792365174, 0.862464544237835, 
0.850725712777244, 0.882660122214346, 0.879977380512612, 0.759387438444206, 
0.845781476445772, 0.908314144042198, 0.842809209778385, 0.906088515507313, 
0.840713834174183, 0.851626961640645, 0.693849986027709, 0.869968161877896, 
0.875266246140047, 0.800866307536425, 0.806177525523104, 0.775676760909325, 
0.882035639677797, 0.962517043957045, 0.88064692597549, 0.805473426728478, 
0.854082056871067, 0.92648826279934, 0.954368019297604, 0.893286188069856, 
0.77929051924431, 0.8314363293214, 0.902661827142256, 0.848456883555786, 
0.930131892655228, 0.857921831035411, 0.840428229148652, 0.836219814667733, 
0.72266521174073, 0.820706645313073, 0.846654510988715, 0.774576726620954, 
0.831723656552967, 0.946456843583205, 0.787452151345938, 0.890549194296367, 
0.823134377461176, 0.824499450677357, 0.798753832928756, 0.863481642184191, 
0.923699676332559, 0.861985698947267, 0.803626453550737, 0.892558759094718, 
0.861437626030488, 0.900937327348619, 0.848031629565071, 0.83445595681324, 
0.930189510980062, 0.840217686296572, 0.742501524564534, 0.785624314846528, 
0.913468142241969, 0.901686175149487, 0.81942921137784, 0.823427393997546, 
0.747566986484585, 0.874591895467256, 0.503630620722526, 0.897737090084296, 
0.939334986068696, 0.909553501875269, 0.885546773072014, 0.943308475958365, 
0.9463491903139, 0.893904571818567, 0.966973379383205, 0.937939158130375, 
0.923466997129217, 0.862995373097065, 0.95375153240708, 0.861428360652672, 
0.894141167982962, 0.936335054862674, 0.936382141475159, 0.82864494560736, 
0.907619492914828, 0.839699141593125, 0.762343995654522, 0.912301399905468, 
0.866793243924124, 0.916640837858886, 0.862787875970602, 0.920340676024423, 
0.929231944260859, 0.81708199486107, 0.950982203335467, 0.95208387300787, 
0.876605482856055, 0.901811065421562, 0.866406556770225, 0.918307514622272, 
0.80968032369139, 0.904232310806248, 0.80892572344478, 0.937675151108616, 
0.910669981359513, 0.883582101910062, 0.894001235062148, 0.928539546510358, 
0.972477664561466, 0.717336481419793, 0.919706426769547, 0.84143849375275, 
0.884604222471943, 0.916185086294041, 0.83591705614904, 0.929473079039986, 
0.870545156034803, 0.902054174855935, 0.872241237209828, 0.908968037692487, 
0.899209571586283, 0.910460663238584, 0.96279799804237, 0.888609695622756, 
0.841467548448277, 0.932797032366713, 0.862334982848712, 0.94365284721674, 
0.785434034120987, 0.933966328225374, 0.96090550186062, 0.859399193025407, 
0.898849483167823, 0.840782232957796, 0.857119944478312, 0.941140735863505, 
0.859860029195327, 0.933866196767468, 0.915242416988407, 0.914113248600191, 
0.935566830778607, 0.937382081204835, 0.885969779293311, 0.924093070184887, 
0.979119358829829, 0.856169222628274, 0.907267016047837, 0.858330600474018, 
0.9509742835303, 0.911635543548735, 0.87256947202353, 0.940771103408163, 
0.842206495707538, 0.888791573185252, 0.859946049420237, 0.912834527330634, 
0.839342622979817, 0.83408842110536, 0.909397676011696, 0.87710191282038, 
0.908990118434834, 0.937193058916135, 0.900456858328031, 0.79306768317451, 
0.879382806449332, 0.95149708128354, 0.95447836755229, 0.869642119507547, 
0.904438901542038, 0.956470419426836, 0.86925401626176, 0.896884332930676, 
0.884622215433583, 0.942964612831374, 0.911495234426266, 0.9364632314253, 
0.823445439420401, 0.880400530280873, 0.906270057863428, 0.910695033009612, 
0.85005075514154, 0.92627705398622, 0.784217982050224, 0.907230760392885, 
0.925279718798232, 0.810172767079759, 0.82254544626223, 0.940795284222248, 
0.890298426430956, 0.87773189982519, 0.844594637288726, 0.921972201746606, 
0.873469145411705, 0.8927550036183, 0.897153714136413, 0.901502702792066, 
0.868617464206908, 0.90017798288302, 0.934197063696983, 0.918653699026807, 
0.949259927551093, 0.967693110948978, 0.867363529999003, 0.965564629608323, 
0.854521184286062, 0.850129461436178, 0.923502170958029, 0.898248946210763, 
0.912078636081787, 0.958932387303783, 0.915360015256457, 0.888503891677954, 
0.869017050119111, 0.981744074386164, 0.942824388006027, 0.957393611088413, 
0.89791079716511, 0.801816473442645, 0.979409336093236, 0.90516089171803, 
0.897333373778393, 0.853013400973933, 0.913051836987897, 0.86377995035301, 
0.931099045259428, 0.896836884501512, 0.84751540022092, 0.902024215894664, 
0.899628069288881, 0.906173767237539, 0.894783001374602, 0.910936351533564, 
0.906032432214782, 0.898547431438025, 0.884818227761246, 0.869687512056691, 
0.860044547725107, 0.913800893529598, 0.892420164469272, 0.970431927603918, 
0.908919613416448, 0.795074972938448, 0.903810566076303, 0.842394992454042, 
0.96551495787751, 0.88930477909635, 0.933025856237629, 0.90630852597366, 
0.892280916147092, 0.83563432416446, 0.962350744704233, 0.91062131024007, 
0.934715688619887, 0.91690599933728, 0.900051256872761, 0.903306117305999, 
0.935906326397198, 0.829864489413694, 0.876279130479234, 0.847050702137304, 
0.79027068233186, 0.906366646506316, 0.902756284833242, 0.926989114973008, 
0.837757134248337, 0.805179834522426, 0.900577401069773, 0.803816172174654, 
0.827782024582407, 0.83308694022842, 0.840072974169397, 0.91665228597595, 
0.959020799071955, 0.955122225554765, 0.932593333940179, 0.909800689168969, 
0.872617782037801, 0.8474835685811, 0.79615510100302, 0.856526620786476, 
0.876139716713073, 0.820463263645575, 0.95943362232449, 0.906308734045695, 
0.96111537255819, 0.922789810986156, 0.950919561162159, 0.927800631714134, 
0.876640658561735, 0.832840683877071, 0.862903922910845, 0.858299774811977, 
0.913980809295745, 0.8624732267258, 0.947640746369687, 0.981088709222557, 
0.948331839138861, 0.937081630615139, 0.969978523734061, 0.891165510327006, 
0.879794353721675, 0.895622805359376, 0.89523543228852, 0.906404850563806, 
0.958235060839155, 0.915617077356916, 0.850506465987786, 0.92782983945353, 
0.891021550511948, 0.919637210927299, 0.860752399285677, 0.921385314285272, 
0.855989829301773, 0.92368380318326, 0.860326681009355, 0.901377359006769, 
0.912994758267311, 0.929556633622032, 0.910542489676827, 0.860142950952175, 
0.909844604790637, 0.953795332749782, 0.923215702325876, 0.971447708334807, 
0.916131461673253, 0.852113817064118, 0.95031815994918, 0.875428217029598, 
0.908583133798858, 0.941634582401706, 0.921996748887776, 0.889206999495223, 
0.959800820986475, 0.940997115976431, 0.847929027723361, 0.89027348893312, 
0.937073035195309, 0.907082912417226, 0.874100806073726, 0.916928280005377, 
0.893531070239339, 0.878215016491266, 0.949808643359985, 0.861951881740247, 
0.901688460569054, 0.828272531112391, 0.862205170979292, 0.915813917664012, 
0.824126395993393, 0.94039794226576, 0.93147055041584, 0.924450310443699, 
0.827021729452748, 0.940113385109759, 0.901011860395562, 0.896063202185371, 
0.89979603924513, 0.928483757710443, 0.940183051431072, 0.910138002092669, 
0.928705005497846, 0.883520571991005, 0.818017056207297, 0.97692565500403, 
0.896923441663745, 0.811115162043936, 0.907889179412644, 0.773446184285438, 
0.935294849549611, 0.903286326762818, 0.918905418788516, 0.892956796829249, 
0.868447431443346, 0.92692769358948, 0.658284157614559, 0.852941741604238, 
0.876408136070148, 0.872885353934263, 0.952158907546957, 0.739739111096173, 
0.932945403075323, 0.88246020136004, 0.927342685832884, 0.859136292394552, 
0.855645224879453, 0.888194786344207, 0.950859367804947, 0.928737320766729, 
0.90526953345514, 0.952548836091079, 0.903787429313811, 0.893901843769406, 
0.94450896252755, 0.971809230054725, 0.835038032419394, 0.855807958245011, 
0.871837609488765, 0.920623434663935, 0.955778011971882, 0.87915840882665, 
0.868229038302544, 0.936614077290492, 0.984638608564228, 0.946544459653725, 
0.969367098450276, 0.884034208748491, 0.84604002604026, 0.96018497996484, 
0.871060615447083, 0.91865430093167, 0.89845292906713, 0.955951447403795, 
0.902411632157726, 0.954512401788295, 0.910807964319959, 0.922796420942499, 
0.923366482491023, 0.909953277988501, 0.887344799605153, 0.941064904150256, 
0.943524010534235, 0.916045516818616, 0.84955451815432, 0.931100594021748, 
0.940681628515885, 0.833483424174831, 0.848277486329904, 0.967399184315369, 
0.847871362947854, 0.861789213660381, 0.945715592308313, 0.910319009650346, 
0.847838284087547, 0.9316271218124, 0.81350599621816, 0.921784867331949, 
0.90687865448127, 0.927771043042607, 0.925753206754718, 0.95212229590139, 
0.881108850036387, 0.966868957036698, 0.935257151021898, 0.929776471194493, 
0.927629963679256, 0.888104970420552, 0.949901823514977, 0.963608018656892, 
0.917633124079828, 0.934918220721432, 0.921764663021884, 0.965277451150864, 
0.857419851359832, 0.851487614560216, 0.931144301488675, 0.915902518480973, 
0.981393284867943, 0.973719752112837, 0.864312409033478, 0.88262688375887, 
0.842096717868828, 0.973550545367903, 0.933155927237757, 0.877137126971436, 
0.951087990597576, 0.964722002536436, 0.944634407082961, 0.928317250837681, 
0.944751501073757, 0.94593846747075, 0.875093685727895, 0.863839790506117, 
0.838499639756172, 0.922145102641175, 0.936669710237334, 0.897215987257253, 
0.97318237109926, 0.951457726437577, 0.961632751437672, 0.95208132474411, 
0.960443822378036, 0.793310950018928, 0.8909079642961, 0.922827699669561, 
0.814680344240579, 0.97409075003766, 0.865099975265828, 0.914609572836252, 
0.949590221845773, 0.898969645280367, 0.818044243667851, 0.938450838011748, 
0.94422081043036, 0.915980178588904, 0.923636505769446, 0.758239484542595, 
0.959021456266094, 0.840254303581773, 0.760590105186307, 0.815019774699037, 
0.947367826461873, 0.947040981537384, 0.984896786153539, 0.924220358586569, 
0.844625043555152, 0.826805873680017, 0.97774777782586, 0.615738902617645, 
0.907322728100328, 0.8608250219554, 0.906135087812729, 0.940929756449317, 
0.867490801827121, 0.89798734088929, 0.877533733700621, 0.942584730268405, 
0.937250449227371, 0.937909261837896, 0.91743379026979, 0.888325438346168, 
0.94140989255662, 0.703140194901197, 0.986978445765787, 0.89178516033839, 
0.94914197147625, 0.906188508726134, 0.831261188881756, 0.851764517054923, 
0.937505801093534, 0.92578233904408, 0.92588324716412, 0.899325887465106, 
0.764872061994927, 0.806149136677157, 0.901268124474647, 0.89676179066657, 
0.91598944391196, 0.948172619065671, 0.95837944708513, 0.957341989851836, 
0.912657594856735, 0.908671654786876, 0.785016097733042, 0.883120521736665, 
0.826971677295834, 0.833001510179445, 0.839553283020997, 0.964273491016134, 
0.959451290837825, 0.822974527601545, 0.829042510855436, 0.948810138226285, 
0.925175702751489, 0.861772661749484, 0.891052132410115, 0.93576884491319, 
0.973346122793205, 0.923802903316008, 0.910951059252537, 0.914669162243015, 
0.92627108177472, 0.840192903988067, 0.853073764282226, 0.94448154228843, 
0.85607367108526, 0.91813422228935, 0.929185983397513, 0.891106125756983, 
0.906113793060949, 0.92013646332165, 0.63990498284845, 0.725611987067865, 
0.944740993564285, 0.945150135332293, 0.946273042755016, 0.93743270934201, 
0.814831152894591, 0.926161770450644, 0.829761533694776, 0.861706678467318, 
0.848615234410801, 0.915657370446226, 0.947658626023985, 0.910462667093263, 
0.935293922206423, 0.912397511230113, 0.939037252112612, 0.906261385492143, 
0.828470908980773, 0.82386108246318, 0.98067561422171, 0.835768331123886, 
0.947530974972453, 0.97908607289945, 0.904412914464326, 0.966051561903852, 
0.853639442575275, 0.957962100408494, 0.855554593407725, 0.857589098185313, 
0.929082945795915, 0.871127641981928, 0.937287521270318, 0.90578023258132, 
0.897905042818188, 0.895414597381044, 0.887440399358786, 0.885767871718589, 
0.924207561070323, 0.802950802047436, 0.872889720927926, 0.842109208802376, 
0.841831924988845, 0.859569038246189, 0.828423513702255, 0.927259535791793, 
0.951483989476567, 0.889197156157038, 0.890152872678484, 0.960742140689837, 
0.912285366372581, 0.845313020902154, 0.812433181109156, 0.943374839590553, 
0.84901409867614, 0.879103739314803, 0.927976572895895, 0.89684028117121, 
0.868303365812833, 0.935019590975228, 0.947579871996157, 0.948660347078559, 
0.87815740227965, 0.888011542497528, 0.962230407662373, 0.876868321184154, 
0.94293846713777, 0.886866050840799, 0.931053873452428, 0.894011581617358, 
0.945301699119344, 0.925416216871363, 0.849706255617884, 0.94472564689516, 
0.95944834888688, 0.878024643284286, 0.920041738737091, 0.863602287424807, 
0.966754974879737, 0.918077579752039, 0.951961398084426, 0.812241957800797, 
0.969064501963585, 0.905372501244575, 0.838930142347991, 0.934929478441264, 
0.832937477932614, 0.945920557424797, 0.89174320197604, 0.966587530938756, 
0.84902447821792, 0.796444108312119, 0.874449971019477, 0.960356626691876, 
0.902634922237172, 0.932290805079888, 0.83758701647273, 0.883356721480078, 
0.837715760736586, 0.855568312377381, 0.881661467794932, 0.933465334284556, 
0.886082808089142, 0.983245376780086, 0.868075203926649, 0.94860475267986, 
0.935107809183317, 0.918520669168665, 0.94610379891674, 0.884203223383842, 
0.901241106316468, 0.914728415245897, 0.945120353199958, 0.94077904740948, 
0.842875759246597, 0.907313829145593, 0.87011721190241, 0.878843364171143, 
0.955670016121966, 0.966031874886202, 0.89389726875777, 0.921291544349364, 
0.875150062758915, 0.923419943951102, 0.840201997148102, 0.886351817995478, 
0.851975604239104, 0.906170963871115, 0.787505119181749, 0.88750309349781, 
0.94420096504255, 0.942514288221021, 0.955829912867625, 0.91704835273448, 
0.920654836959727, 0.963721694394757, 0.877506846610337, 0.895935370776583, 
0.86794191081979, 0.840554908962685, 0.9084169513807, 0.893901380754573, 
0.903919206292877, 0.974484001222343, 0.809941761225615, 0.885543205864222, 
0.931709631604551, 0.861458693311944, 0.980841515116753, 0.869709206523345, 
0.942882643328872, 0.955989768124221, 0.927943826730049, 0.934398722353725, 
0.906743857764635, 0.911285802320767, 0.889437934570784, 0.879908496527462, 
0.888549391428516, 0.927647720112273, 0.870618754755483, 0.783506541224584, 
0.870098568486596, 0.794529959065355, 0.916621345413201, 0.883464464969717, 
0.871688137467223, 0.919766309631386, 0.848873761284641, 0.929556395558721, 
0.916750925442585, 0.924873878037438, 0.900497266346523, 0.964197306058906, 
0.908881773367348, 0.969625578645695, 0.931842402917229, 0.904362477534495, 
0.925595787334853, 0.955211139174396, 0.859307724973082, 0.940372803735052, 
0.848993396541593, 0.873835348296811, 0.934871352698744, 0.857049453451807, 
0.89823238558156, 0.94895874152038, 0.866214635963468, 0.907631376271523, 
0.898704882204809, 0.929912158481326, 0.892425830655086, 0.789925019731793, 
0.858915754799256, 0.851509546676527, 0.887012351029017, 0.9446138925903, 
0.907098868292759, 0.882141741419182, 0.924425308292946, 0.879964177077306, 
0.963846996422253, 0.872799820081346, 0.939965818025214, 0.88984502487809, 
0.927570103063459, 0.820791547987827, 0.831986266077194, 0.870273090220666, 
0.90547655995548, 0.953410406148858, 0.911662665315259, 0.867062625799806, 
0.775203767224817, 0.898284358692132, 0.91696843133408, 0.94785662291355, 
0.873652394006281, 0.964525514556708, 0.818644716681932, 0.935076378601022, 
0.887873283925595, 0.835732741548333, 0.909389870918517, 0.93710451402426, 
0.904757767393743, 0.877858403863311, 0.896021061817698, 0.934717735061113, 
0.897788544194428, 0.805528624619302, 0.929936524929979, 0.901157234031792, 
0.9294506207831, 0.923928290950801, 0.92896573182777, 0.938023226397615, 
0.936235351944762, 0.894683050372978, 0.923775396420717, 0.87504264006536, 
0.921192607470184, 0.83464869133249, 0.894855780403003, 0.86025140233223, 
0.85945146719279, 0.881216656185432, 0.89650040254379, 0.858695553244652, 
0.956545943596986, 0.923208258055605, 0.858142886816358, 0.91926476394845, 
0.927169363995719, 0.898642762735816, 0.924392128438688, 0.940602180025735, 
0.907996122745111, 0.929646923971548, 0.95921357632386, 0.872761096166197, 
0.942362515776917, 0.806714505040524, 0.905824894894752, 0.886092327540317, 
0.864759956638802, 0.888094173798082, 0.931581614226328, 0.929320977651595, 
0.950349927797928, 0.894359162478458, 0.833239499449013, 0.927846308861906, 
0.94766384849833, 0.94706198808057, 0.902254049160337, 0.943671277967745, 
0.79730738361068, 0.841180202770624, 0.88855820702081, 0.88405762366929, 
0.915726231922894, 0.932649583540026, 0.85930677218539, 0.84974082395674, 
0.922387084741166, 0.805243322486746, 0.893587808314386, 0.888956078942251, 
0.907236565483343, 0.923552976048607, 0.881309859474546, 0.878416660059103, 
0.96525255341046, 0.93461180875851, 0.960183663706231, 0.815397665389561, 
0.855018076331934, 0.880833574850432, 0.918608789639867, 0.925302342250816, 
0.83406499787464, 0.818334880434825, 0.9697481713881, 0.912165644190273, 
0.866084918030136, 0.94447285506478, 0.830461037195607, 0.882586801994962, 
0.926936078029963, 0.848066860039113, 0.888414990580276, 0.917687507604004, 
0.890640598189901, 0.936910892505612, 0.939841041130282, 0.944638715569826, 
0.856199385327715, 0.912167558117026, 0.772327603630583, 0.893303298376662, 
0.953076115747257, 0.866118703377693, 0.889904745987648, 0.895610292386082, 
0.9026732832878, 0.932658603101791, 0.890673962922774, 0.889891330707973, 
0.945258025214347, 0.849664970114017, 0.950032246753453, 0.954356708298775, 
0.85588635757431, 0.911825093332529, 0.898324923928207, 0.903974524129919, 
0.649452398813891, 0.890378599014325, 0.825109523109802, 0.957404907577547, 
0.877053886715364, 0.93532462234698, 0.954362100235162, 0.786625691511245, 
0.930669872417155, 0.856013068553372, 0.90322939924636, 0.892399851593418, 
0.882812597150925, 0.960632631316763, 0.891790704460934, 0.877948471821414, 
0.891980268070217, 0.896565234769595, 0.955965708120194, 0.856710873151368, 
0.95451835454381, 0.924204725234803, 0.809117127845296, 0.841008971183335, 
0.94245167313572, 0.91947577016403, 0.828031431155517, 0.863669908846241, 
0.887685591801259, 0.941892393813849, 0.949686237247356, 0.883899924041661, 
0.837483268270489, 0.939376005473207, 0.858751095829775, 0.895786324249169, 
0.899131239976143, 0.772513573720484, 0.825462719227377, 0.889538184326336, 
0.883198586488925, 0.895411019661548, 0.87626190542058, 0.854431197093808, 
0.921598065326861, 0.761782416439097, 0.924164826468329, 0.908326484489709, 
0.941845481533356, 0.719304461851708, 0.94358609009777, 0.961339312092883, 
0.94779482284236, 0.901626134889784, 0.988310686051877, 0.916732044436196, 
0.813538082541175, 0.953746371258543, 0.967181185113193, 0.951709464456628, 
0.916984446262692, 0.873875865650394, 0.896481110927106, 0.905886091836202, 
0.984487163283743, 0.961791761940684, 0.950865856773955, 0.9041068656767, 
0.852934711778465, 0.909960696613665, 0.836303387672421, 0.815738895187113, 
0.856965975768503, 0.855223629198556, 0.930832572989238, 0.972298420975147, 
0.865612909957892, 0.961890010704576, 0.90642924817038, 0.878977171122579, 
0.877600571918289, 0.864039578149969, 0.97196688291473, 0.912888623510612, 
0.780175545719464, 0.953216976699764, 0.64223986283212, 0.949113956636256, 
0.854857463556756, 0.93292492267518, 0.898479996766493, 0.771999053642508, 
0.88420078427286, 0.955324549598417, 0.84708285871799, 0.852021350615383, 
0.944731447234896, 0.93740394780246, 0.911345958863305, 0.848792042449354, 
0.847405971392649, 0.895344461911517, 0.876947346666383, 0.898981745794068, 
0.968038632698037, 0.874478462870126, 0.870882460213244, 0.908345092988642, 
0.919309214928697, 0.950165601163704, 0.876696760488847, 0.862281392472567, 
0.931888962613916, 0.934917822806943, 0.937258958842236, 0.959210005912752, 
0.921488552696559, 0.89559230087405, 0.861109135958496, 0.94129382704995, 
0.965227540112629, 0.925329969341104, 0.881287235259226, 0.907980191617989, 
0.904058115141855, 0.900086465905524, 0.842867627005246, 0.956329971611462, 
0.908945500006798, 0.924335924866595, 0.832990733746003, 0.961512992062023, 
0.929585196081736, 0.922150743041595, 0.91514879280539, 0.831197218809973, 
0.842748299634438, 0.861381072112399, 0.845283912817861, 0.92225365992803, 
0.83475707440907, 0.949342999304395, 0.823688309765103, 0.892139651089371, 
0.940463835180868, 0.897005075093298, 0.872158854128364, 0.864158353200861, 
0.903720249542754, 0.869246816630292, 0.953933384710574, 0.883689280834049, 
0.931667390937613, 0.96960632440045, 0.959878684733156, 0.914167487898393, 
0.863787462147896, 0.923991127321779, 0.892419615121229, -0.964748951618441, 
-0.954754167958125, -0.96259499779364, -0.927224607293905, -0.91029241492702, 
-0.941718476613897, -0.917790151694542, -0.927076592688086, -0.962273998924942, 
-0.947447190178766, -0.945684724898312, -0.919466322176157, -0.960810309887321, 
-0.960100175240686, -0.951609917414666, -0.901531724479972, -0.904255332656998, 
-0.94709762041531, -0.945155706231009, -0.942863771541816, -0.938546971688464, 
-0.940717712512062, -0.963841427035464, -0.967586486490868, -0.945203915001349, 
-0.953069894788934, -0.935868063286646, -0.943585168925661, -0.949599132768698, 
-0.91641998569776, -0.939459517124106, -0.915946320355112, -0.951749965396341, 
-0.947036817783727, -0.95890908321403, -0.934890021169002, -0.92231526457999, 
-0.94307686827492, -0.966401832739145, -0.944627697500826, -0.95091644342187, 
-0.933004326274563, -0.89789288096775, -0.954563173292992, -0.891906014240608, 
-0.946979906980033, -0.968351919164875, -0.911975210480234, -0.943463457643904, 
-0.945868145860197, -0.962669260340245, -0.940902403547278, -0.92569331079913, 
-0.947385827129556, -0.93398927907052, -0.908180043309932, -0.911820683363575, 
-0.94617114401132, -0.911147031922373, -0.890997469326208, -0.97786418993367, 
-0.969123805569032, -0.928009378587728, -0.929329997030523, -0.953716759522466, 
-0.93973308204071, -0.94422541585168, -0.960137514967682, -0.966364752031938, 
-0.94223531634413, -0.922416247547793, -0.934968043260583, -0.974729415299336, 
-0.928299663258612, -0.96361944146862, -0.937937126360584, -0.927525241454082, 
-0.938801412727379, -0.942699655069822, -0.977638858429475, -0.95867777076774, 
-0.89830726220962, -0.949533881095848, -0.948824579842932, -0.9357772348544, 
-0.924123467570005, -0.967032987976464, -0.93617658644679, -0.93182384423024, 
-0.958744363294098, -0.907098154680523, -0.942439532646475, -0.974012562880135, 
-0.970337497471519, -0.921010635955898, -0.94213844997771, -0.9044038401738, 
-0.938987378068558, -0.92634782932712, -0.898237803769317, -0.946086888994608, 
-0.956674849439516, -0.95515362688751, -0.924440309594426, -0.931777652825795, 
-0.918380628814987, -0.963657738721025, -0.94960615378927, -0.93282830086775, 
-0.904662490694871, -0.941695559736967, -0.952358685688255, -0.915790194668373, 
-0.97422433800828, -0.915974902525292, -0.929344042850676, -0.910648112688315, 
-0.940238861318273, -0.962499363269821, -0.957404021782533, -0.939085639769353, 
-0.934332045081556, -0.92143641072261, -0.97119817977741, -0.93543472681994, 
-0.94140207942602, -0.952095383917167, -0.96321293924611, -0.916214356672547, 
-0.962248605373667, -0.92128193905645, -0.946159683140802, -0.968612552435741, 
-0.943132519481525, -0.929711698801912, -0.955770842189445, -0.9676278323735, 
-0.968941646241671, -0.912456534043865, -0.963449175036533, -0.940480496628845, 
-0.96287729963996, -0.94682880219474, -0.942674858137374, -0.90948424535409, 
-0.939930691874043, -0.91783833617085, -0.918191862806117, -0.948704073072046, 
-0.920510008923067, -0.91890783110074, -0.943764635144196, -0.949561079012116, 
-0.933909482325243, -0.946139228663325, -0.964335396128618, -0.957698705847909, 
-0.963926499689396, -0.945067886385827, -0.950173667812089, -0.950147443423236, 
-0.970500911096015, -0.963359206287792, -0.915209192216547, -0.879339800371212, 
-0.915809846310143, -0.90048765191635, -0.93227596634892, -0.952478178154388, 
-0.919591503114995, -0.926740087953619, -0.90031916440325, -0.924080732850505, 
-0.951945381295873, -0.929883784535142, -0.976928269735315, -0.937717445833747, 
-0.957641720564068, -0.908111556114596, -0.918974048766133, -0.907422824639942, 
-0.938407804355061, -0.972255664976663, -0.949215327170387, -0.97869262481182, 
-0.930923868885501, -0.972168172675029, -0.93092138867854, -0.925765550919652, 
-0.917581413889444, -0.963384000600558, -0.922610889187888, -0.927406806369986, 
-0.925958182839818, -0.931998140520974, -0.968359700671295, -0.946979073539703, 
-0.95064141998102, -0.954938952810772, -0.95735128795258, -0.934751854402594, 
-0.940589129925523, -0.92040269866049, -0.956745910401926, -0.957653764603128, 
-0.9205960344841, -0.943048170905905, -0.97016144900005, -0.977721555888489, 
-0.933238130571638, -0.95578540970934, -0.964854066055959, -0.91492626611933, 
-0.927866504222896, -0.919163799972302, -0.948551601306046, -0.95129710320619, 
-0.968327979136743, -0.881573847445585, -0.958719137402983, -0.962854291722923, 
-0.881886386296526, -0.889608285460519, -0.882076982798876, -0.907082058438268, 
-0.938327202573627, -0.93743461674952, -0.934228366610642, -0.94517864001685, 
-0.925465944040215, -0.879524213177572, -0.958335253985713, -0.905778096416183, 
-0.91232410004841, -0.936810070319832, -0.950015909229805, -0.956903392938507, 
-0.87620378432225, -0.959204392724377, -0.962228279553718, -0.915535158768813, 
-0.941840436110625, -0.919200554681759, -0.936771341780819, -0.910225836642573, 
-0.93320343906948, -0.940128161030935, -0.943180197715105, -0.963823752447597, 
-0.933183670972265, -0.87976388650954, -0.935871699943443, -0.927281315780899, 
-0.936377892379541, -0.964016282503993, -0.926905001496, -0.930070705694351, 
-0.943192877589092, -0.963293131111899, -0.92754541991553, -0.950900232008156, 
-0.977706860386577, -0.957454693673748, -0.934762189756868, -0.940294838124614, 
-0.91003137948671, -0.949854497969145, -0.917122598618656, -0.916116919201456, 
-0.934804159319768, -0.954704666578936, -0.89479163383792, -0.922501077608114, 
-0.935453508185094, -0.949977814881224, -0.945695975527482, -0.93417441739367, 
-0.928441038274393, -0.960682975809288, -0.94524157681984, -0.942778009340178, 
-0.948881111891412, -0.923088562114708, -0.927095635536065, -0.954700512126016, 
-0.968558964030187, -0.945435627967075, -0.952627646212956, -0.961699865972548, 
-0.945247181851794, -0.968528580089818, -0.954244881282606, -0.928505493877847, 
-0.912766425656292, -0.977494094493449, -0.978238613359264, -0.952252696963801, 
-0.879739379956504, -0.905186001716405, -0.939083271579057, -0.84425007327495, 
-0.955532190692438, -0.922612418846935, -0.892733452614756, -0.966259748734679, 
-0.938904174896802, -0.912047558235627, -0.880371155408696, -0.964600353582165, 
-0.93616675656918, -0.952980919541228, -0.928668815187874, -0.92307961330345, 
-0.94466181258154, -0.900813459549248, -0.906898562955971, -0.960052936904508, 
-0.949204319086914, -0.963347466304932, -0.932831653928197, -0.911682172054902, 
-0.89891783728057, -0.970604214272915, -0.921394319646345, -0.94177646798304, 
-0.913820269288405, -0.911374261896281, -0.892414064954048, -0.9103551849794, 
-0.913059344962773, -0.963946126686552, -0.947486822041767, -0.944634465629028, 
-0.932131656667946, -0.96272926957137, -0.92524001386223, -0.925039429812886, 
-0.909093645902242, -0.93788333662649, -0.88018511576563, -0.939820426714452, 
-0.960483671431784, -0.94797210443008, -0.94279742753634, -0.944042944072986, 
-0.976162462618958, -0.93878965502396, -0.90505960128754, -0.947918614901726, 
-0.973060365397944, -0.905276256988621, -0.976400075004096, -0.955093646786642, 
-0.920825275863918, -0.961323517666297, -0.952377999444367, -0.937443444964048, 
-0.96410521968373, -0.969138552146483, -0.926516773143895, -0.901404328457296, 
-0.950719882812225, -0.941357814657442, -0.877073400420526, -0.938878340313143, 
-0.944970161253457, -0.954466199084475, -0.90992789078567, -0.92622924641689, 
-0.933496022151593, -0.968629031404666, -0.913855072250547, -0.952692385183765, 
-0.955526263691377, -0.954578597955223, -0.940967514117426, -0.89212110007752, 
-0.94866308945966, -0.940078741464725, -0.95470697299041, -0.969199907495784, 
-0.931704483651685, -0.969809417585279, -0.94709627746296, -0.91785025849416, 
-0.942792078460993, -0.961350001252174, -0.942228049063784, -0.91521349172347, 
-0.951927302989242, -0.95143995958227, -0.942523336798233, -0.958131755486863, 
-0.956916354772339, -0.93852207212764, -0.933498794765287, -0.956768489475809, 
-0.957579832569483, -0.85528860194766, -0.882114088592198, -0.911051043364961, 
-0.87754902494905, -0.943528776852019, -0.97111797074973, -0.89128369639198, 
-0.932957988621628, -0.9594734092018, -0.94556410773714, -0.917595043929486, 
-0.96584193196042, -0.96135470550016, -0.953554666458374, -0.936815043400087, 
-0.94289014571667, -0.919880939582417, -0.939845527325712, -0.897299542752835, 
-0.967207754674838, -0.976238433975247, -0.958149343951983, -0.937378569301078, 
-0.935816017043409, -0.95159442186202, -0.93106417688329, -0.95571704721757, 
-0.946924954569383, -0.951381258860158, -0.935494224940575, -0.948140873470392, 
-0.944724474243935, -0.951185155172172, -0.917645901463794, -0.964147992367987, 
-0.928029980919038, -0.919739431935323, -0.93601027622318, -0.980563528083097, 
-0.932757427525207, -0.927753499478543, -0.932052051304172, -0.925669972635627, 
-0.941683860375156, -0.930580332474935, -0.948621987941206, -0.950310281719165, 
-0.925371560702197, -0.963834964865569, -0.950797166586809, -0.923093181893468, 
-0.957784558567337, -0.975702727391421, -0.928652707921340, -0.92288749968715, 
-0.928900733399942, -0.968187056674948, -0.946790252623704, -0.92160585683525, 
-0.911354406895246, -0.92036246691288, -0.94851660877381, -0.9656645189755, 
-0.973229274639139, -0.945751164415484, -0.938403138104723, -0.940775853353452, 
-0.923860389515534, -0.965685119801032, -0.93374729222115, -0.95530489255958, 
-0.949392563180228, -0.958933074471894, -0.916797108547013, -0.938770789713495, 
-0.954249716616166, -0.918489542306282, -0.92329824941087, -0.933608225684385, 
-0.960705886813496, -0.95205341993885, -0.930340307086647, -0.951326827664695, 
-0.93906659804289, -0.932847471971852, -0.916512352530422, -0.883014068337244, 
-0.915272349105812, -0.962255762940662, -0.921316952490678, -0.958168660432107, 
-0.96622357436506, -0.932538160806845, -0.97275994686742, -0.903636575123327, 
-0.959756535498427, -0.937349398274315, -0.972927479568246, -0.948462069176096, 
-0.93563640536318, -0.899196223881276, -0.970183047706966, -0.975601050553254, 
-0.938879915109285, -0.944999638113357, -0.907570500013734, -0.937282823756216, 
-0.960218792517114, -0.947671150597778, -0.956638376325503, -0.963184803277452, 
-0.975104348043304, -0.941610065510996, -0.933586761973895, -0.926564927776363, 
-0.966996702789267, -0.918970757291478, -0.958355869235, -0.90846813458796, 
-0.938119025135853, -0.951693575355617, -0.917641971806408, -0.932648071940984, 
-0.961455241932017, -0.936252398465516, -0.966385214694854, -0.945709415449213, 
-0.97183189118064, -0.96388217437317, -0.967554621061398, -0.953878121747536, 
-0.924789183763268, -0.91991509465947, -0.924894717162892, -0.89761987950426, 
-0.96644123063948, -0.980946697100953, -0.921160959959128, -0.92183820660621, 
-0.975322530887495, -0.933907398198448, -0.964638536090368, -0.94080616990529, 
-0.907330611154042, -0.943983226419846, -0.937024086890714, -0.92616352600275, 
-0.948443662237703, -0.889839977687683, -0.961775846439566, -0.926924222092625, 
-0.969721085229289, -0.892538942015051, -0.950361982287786, -0.949597595515574, 
-0.887301415393376, -0.912181841464882, -0.949496076379637, -0.935216606815835, 
-0.919843235600213, -0.936947201930212, -0.870035182551175, -0.941491709446655, 
-0.932025800654009, -0.96070981930220, -0.941866012082667, -0.980063144087245, 
-0.95722494553668, -0.926752449320411, -0.94925875702347, -0.93822110825830, 
-0.931284439088495, -0.95784475862831, -0.963724911256496, -0.94008734938318, 
-0.87356930078953, -0.925015041509088, -0.944407101311351, -0.946551562383168, 
-0.939347742372543, -0.928912675764196, -0.969900785010252, -0.95199214559094, 
-0.95689845943559, -0.963367599553172, -0.964725497687915, -0.927087695226644, 
-0.940744014177466, -0.948516217041324, -0.942312591689022, -0.960476972993174, 
-0.943252858091115, -0.95355180980485, -0.955943716864576, -0.959475632108869, 
-0.921191149372615, -0.968135405047058, -0.960289582384331, -0.975249866345934, 
-0.952081633989013, -0.951926358695679, -0.97756428841602, -0.925804950887681, 
-0.962140829690393, -0.951745387187788, -0.93423851698494, -0.935550109251482, 
-0.95867891369496, -0.930888207863962, -0.960379184695602, -0.966205589142345, 
-0.918746124836498, -0.947761181712417, -0.952506834229104, -0.899447982961253, 
-0.94307580257033, -0.949045115207973, -0.915635785418929, -0.94072763614159, 
-0.929981794338677, -0.93830982688224, -0.965419222019002, -0.940466989914734, 
-0.950544015761458, -0.971042018770717, -0.911688351260886, -0.970562978049378, 
-0.936561710235545, -0.967525590671973, -0.947806475610456, -0.957997367602182, 
-0.949598489367823, -0.95950088931945, -0.942708519401182, -0.968220642301994, 
-0.919572052638186, -0.97389416207087, -0.915488349790641, -0.938568934256266, 
-0.953252140324548, -0.938401105472347, -0.939475171081142, -0.905731955324444, 
-0.967375808739374, -0.9574200360864, -0.916661678614455, -0.917394559668212, 
-0.973088588793195, -0.94724050686716, -0.954319183969362, -0.934892181013345, 
-0.959403579004545, -0.962734153221329, -0.918527984351817, -0.93141643189539, 
-0.874470109038701, -0.926137786336131, -0.934527546787373, -0.935689590573051, 
-0.92840777804574, -0.969850635743312, -0.96996140640236, -0.931486767955992, 
-0.903729614988394, -0.951440156592674, -0.95176240036581, -0.95032363368383, 
-0.957757603351757, -0.889934576142235, -0.880430033838078, -0.964633573693005, 
-0.958821593699584, -0.954216798554431, -0.960655025639855, -0.9553608829542, 
-0.94616524839751, -0.940960336443398, -0.930425878881182, -0.948876850162336, 
-0.952570408124843, -0.946156330762434, -0.937324247099309, -0.957023341669038, 
-0.963910340939736, -0.961021443823154, -0.960321666231856, -0.96944066779503, 
-0.929683826622219, -0.955940484513559, -0.942776017666383, -0.954960336883, 
-0.958562675261632, -0.96647112532669, -0.932456992450955, -0.923567321978894, 
-0.959711716848538, -0.915577589996402, -0.936765208539658, -0.932551080780691, 
-0.944745376463945, -0.959400315873677, -0.956671813035653, -0.938440498688224, 
-0.90464804342664, -0.950057974409262, -0.946415736348857, -0.970888899961523, 
-0.921260266903391, -0.938809099561142, -0.953096153527235, -0.957273088471691, 
-0.943136896792103, -0.934362163528266, -0.94075652167926, -0.971991783737493, 
-0.940511348755697, -0.946271670613824, -0.940752419444834, -0.954595833310935, 
-0.916927198649401, -0.950406785436414, -0.961374857547472, -0.886133162455991, 
-0.910150665210764, -0.919176127121694, -0.94805076115518, -0.815158700351411, 
-0.967297703379122, -0.916236134657354, -0.940229953816911, -0.956570999297726, 
-0.953888893475271, -0.927272455560931, -0.947952264277726, -0.94233969047322, 
-0.957632980295219, -0.952176264842492, -0.971976076493592, -0.882683532092331, 
-0.969463404281959, -0.94604062830329, -0.922240892378698, -0.951829737569282, 
-0.937277929492014, -0.89053638409198, -0.949569738912244, -0.95608638139524, 
-0.948899696104133, -0.950229050724421, -0.933130317494074, -0.952898121180783, 
-0.945178749443224, -0.943031640307313, -0.950547034923012, -0.975132803394277, 
-0.948936525078534, -0.94297760663045, -0.968801452148352, -0.941342610687083, 
-0.943004471552048, -0.951260568777888, -0.930695186238427, -0.945693459390412, 
-0.948898669105686, -0.97174952578051, -0.93927866537525, -0.958168663260522, 
-0.924062960781735, -0.96186059314283, -0.924621757785118, -0.956417628717505, 
-0.912605390574497, -0.87995187162829, -0.935139449076884, -0.96674390592188, 
-0.961827138137973, -0.91592484946264, -0.941335953745428, -0.937936355291677, 
-0.925616047648121, -0.936341693854043, -0.955931966871867, -0.938518216727626, 
-0.958306084713263, -0.949509573800944, -0.961520783966241, -0.940991239328305, 
-0.924513835537898, -0.9468739939683, -0.963732763237812, -0.955351615876245, 
-0.921250190776513, -0.973271294796106, -0.936198349178584, -0.938357212093522, 
-0.935959201497796, -0.947453513607496, -0.89706091854029, -0.967386637062386, 
-0.902778137872705, -0.94339954022320, -0.916528087086282, -0.957755143946704, 
-0.945054195352244, -0.904898297676138, -0.974705740621048, -0.913529671259859, 
-0.94500803661846, -0.972744131870715, -0.939636539685508, -0.897832166570355, 
-0.949979599903168, -0.872386974646019, -0.945791032082878, -0.951933405543913, 
-0.946140860795668, -0.950483412415442, -0.97334392791123, -0.932680789948561, 
-0.924553430552344, -0.963471922134273, -0.933030154306701, -0.93502318061765, 
-0.950935002925293, -0.937221608632085, -0.927758451779248, -0.95111972136774, 
-0.952002586030676, -0.945797435456956, -0.952007484166426, -0.980452942999026, 
-0.904136113734748, -0.926879836135525, -0.955369831629114, -0.904285882153157, 
-0.941611933221682, -0.904668366653585, -0.921858311996301, -0.935742773621869, 
-0.957462960947717, -0.963330060359225, -0.937272422452417, -0.934078290218109, 
-0.924917147978068, -0.914819553278274, -0.921111384608104, -0.94188901146921, 
-0.948456878630336, -0.941124024991543, -0.913913780633937, -0.939963762355453, 
-0.921831471366523, -0.968978642772855, -0.957388547122692, -0.944746041733147, 
-0.943840411839397, -0.924913003951864, -0.961738080578633, -0.920567344016934, 
-0.96244872519884, -0.969880272110672, -0.92035018162439, -0.945726724018077, 
-0.962898461951715, -0.922723689657432, -0.940630678704948, -0.959157646679117, 
-0.9494452224789, -0.928249489984324, -0.951411041937693, -0.863697690334163, 
-0.941374122588805, -0.911073768282238, -0.954300928257175, -0.94148356246295, 
-0.955638401640471, -0.94086079060116, -0.949669290791238, -0.96616226693023, 
-0.923870788887536, -0.938648101381172, -0.9275503418144, -0.941710683537805, 
-0.92612101005238, -0.94081200658441, -0.939534272683547, -0.974262071190313, 
-0.916670202645289, -0.95818379331167, -0.931432901256147, -0.949396336849907, 
-0.95132312599223, -0.913009331591035, -0.944562814289091, -0.926079807825916, 
-0.941466979496308, -0.943407255938892, -0.93408818902162, -0.928488555780597, 
-0.954951860499845, -0.96124117510743, -0.949872329598565, -0.945503070721283, 
-0.941107473576766, -0.948837379656238, -0.957658399004594, -0.922569425631688, 
-0.952639070230373, -0.951550069574597, -0.96553168519304, -0.917875566424442, 
-0.957498479249101, -0.962025234770785, -0.948555069408126, -0.97194066654741, 
-0.941294774714949, -0.957593539415361, -0.96504311976039, -0.926687103968095, 
-0.958370871392015, -0.969218502068813, -0.94507519453104, -0.953129093233996, 
-0.939149498574573, -0.94771297197656, -0.951695148217678, -0.960682516479094, 
-0.943291396292295, -0.919003758599508, -0.949158220551756, -0.908450507334337, 
-0.973753693627776, -0.915891113693565, -0.952317298929746, -0.94364655339386, 
-0.959347744411506, -0.97039422706863, -0.931453808255668, -0.928593899020156, 
-0.940908155735144, -0.931847991217853, -0.91562061267537, -0.969665494831776, 
-0.912915658525774, -0.957634258336903, -0.950016307635732, -0.956855356791213, 
-0.907557548883371, -0.923648477055169, -0.924744999551241, -0.975540282951887, 
-0.916794829549302, -0.927839494557148, -0.937275789845582, -0.94722911102094, 
-0.921377126190732, -0.961255323001664, -0.922826691036514, -0.946198156615084, 
-0.896037610466017, -0.925344000208207, -0.955554628637524, -0.965059363641053, 
-0.922205024812843, -0.912512960913729, -0.969523696475958, -0.944393908750848, 
-0.94924663916862, -0.874203916636688, -0.96554572115538, -0.939007505453872, 
-0.9288921125976, -0.89607527634994, -0.961611989910236, -0.913631208756373, 
-0.961079121414017, -0.924910824014926, -0.920578500445417, -0.97101656855727, 
-0.863389124946243, -0.929325651542401, -0.952657678960576, -0.959656946571295, 
-0.963192435933595, -0.963796262840559, -0.91862951911351, -0.944032342765649, 
-0.971259968895011, -0.951542574898506, -0.972436798716399, -0.954538396483338, 
-0.901113232996489, -0.955582079229533, -0.929176845770155, -0.951626492916928, 
-0.922882706295403, -0.964102452597103, -0.961075288081156, -0.935548147426598, 
-0.95899872169416, -0.886745014527736, -0.930187669011779, -0.913019475566367, 
-0.882778876967066, -0.93087276780078, -0.897377118478651, -0.904429999883723, 
-0.871591917643317, -0.875665470757024, -0.891317913809330, -0.835325594322404, 
-0.949828430005133, -0.89245404704126, -0.944386834261187, -0.941773408019864, 
-0.82482246798918, -0.871330175037888, -0.921750149463186, -0.92582900028484, 
-0.871792406015102, -0.922528544533841, -0.866366700001897, -0.826837144841736, 
-0.926396536690465, -0.894252864576102, -0.87158158466231, -0.840058454297895, 
-0.846028551548594, -0.837896307221513, -0.818674067786489, -0.934127721507692, 
-0.92483071988626, -0.874001052269876, -0.831912084821858, -0.88757818396841, 
-0.92754141489475, -0.86520890988881, -0.819172159633985, -0.854156892102943, 
-0.82865104196681, -0.840682143828496, -0.878606495041735, -0.895363729582365, 
-0.905933488193686, -0.824286369162169, -0.86659304190294, -0.86108317363882, 
-0.901262613842048, -0.872094168395308, -0.921364271523996, -0.877155219939936, 
-0.860581084156252, -0.905915797722193, -0.860343831395633, -0.857421346778338, 
-0.928620400045482, -0.81587081728541, -0.917629374435857, -0.912303679058493, 
-0.732791507868245, -0.916829999321156, -0.885964699548445, -0.903825668190955, 
-0.84852375757814, -0.901121412848219, -0.88120348528279, -0.912969262372439, 
-0.81786145836854, -0.826777778895757, -0.872241858984658, -0.915652020449328, 
-0.901520074679201, -0.888650008289314, -0.890532817102416, -0.90774099793617, 
-0.83825231460441, -0.844219195624974, -0.9076740273853, -0.847883016882962, 
-0.826549002459874, -0.895683067181121, -0.893817473619547, -0.897561252875473, 
-0.928275777656596, -0.929729112780442, -0.905025513683911, -0.843843020007668, 
-0.889873678173042, -0.900996076999118, -0.961955919143858, -0.875521996864066, 
-0.890190761400166, -0.87566335941989, -0.84270586417702, -0.88801936100562, 
-0.896178841870388, -0.891035193295892, -0.890562043016199, -0.87642133994529, 
-0.807992792630874, -0.900936082410818, -0.904258604922975, -0.869524151451094, 
-0.93688456503502, -0.83416593996125, -0.879878194402506, -0.829044262963896, 
-0.891951323729012, -0.91381502483499, -0.85194811407111, -0.836125510590351, 
-0.895489686406526, -0.875044083439864, -0.912422833612003, -0.850131237637506, 
-0.895839489585401, -0.887720859712536, -0.902957596304236, -0.85740887891309, 
-0.891693657061872, -0.91008807431955, -0.884981730727903, -0.881278655936271, 
-0.922030151591856, -0.878631142760351, -0.885768126674418, -0.915311573983493, 
-0.792977955502228, -0.914233202470152, -0.906514469503124, -0.883312834795992, 
-0.904875618732296, -0.912920073435045, -0.86612314959571, -0.889164553556478, 
-0.88203764788109, -0.885614094054983, -0.890303506795217, -0.849636152927631, 
-0.892090679536346, -0.78016415958471, -0.894722276969624, -0.874502288345995, 
-0.855031783462954, -0.813664198657919, -0.900715964012959, -0.916886806707938, 
-0.920058218297425, -0.845420129934496, -0.909518035184604, -0.925899297684958, 
-0.870133259151184, -0.828103151669773, -0.89281488835865, -0.921543277235201, 
-0.935530186432284, -0.913984644831517, -0.866376112776484, -0.86544514907044, 
-0.937327587020716, -0.859209660489364, -0.920044782377363, -0.878166574066112, 
-0.933821474031261, -0.879677105444021, -0.82620140931732, -0.904044025488336, 
-0.83961313291474, -0.82278896359592, -0.930736448623233, -0.885311582492471, 
-0.919142830994415, -0.9003622858379, -0.866115763493408, -0.923146577844713, 
-0.886668129435202, -0.800182122673342, -0.912729279694438, -0.908761756246109, 
-0.857718591756155, -0.839252468404122, -0.888240852947556, -0.903953425494307, 
-0.94313826408189, -0.853975830363416, -0.90301355745604, -0.874529671453932, 
-0.950127319278977, -0.898331902102858, -0.881632865013045, -0.897738684801882, 
-0.89610001049981, -0.856006488104319, -0.901749446360642, -0.876699861959085, 
-0.833320242437007, -0.918126524728937, -0.89956009627372, -0.918033408341793, 
-0.865232498834665, -0.859142168850842, -0.896470690925779, -0.864944107472386, 
-0.926765904276479, -0.886863054521802, -0.806018693660443, -0.86180420761514, 
-0.913036468994573, -0.871943610621692, -0.885249726266209, -0.855101270967686, 
-0.865132393180412, -0.786398763614612, -0.870295045598369, -0.903368051828102, 
-0.793507600644635, -0.880160996645936, -0.815354205795556, -0.935974440293444, 
-0.825344553726805, -0.865267200394334, -0.850450336254718, -0.930561098954662, 
-0.94404358701282, -0.911583673673845, -0.856688946086508, -0.866624751138355, 
-0.909763187387083, -0.930032420639622, -0.866103276736159, -0.89184503725145, 
-0.830803525232722, -0.898323047786379, -0.852087047638539, -0.865701318915799, 
-0.897246772512671, -0.901577949894848, -0.892154759879213, -0.91440720758082, 
-0.871338960833898, -0.889919609863155, -0.903507346116353, -0.832162010819384, 
-0.912870306774257, -0.890175964752459, -0.881672253698638, -0.875054694139223, 
-0.813685479432599, -0.886240773920305, -0.898428614675346, -0.934448499083047, 
-0.839246293516058, -0.83002495568378, -0.95913090376923, -0.891596198857493, 
-0.897178937582518, -0.865530918166665, -0.864181189071115, -0.915616013610094, 
-0.89913898974044, -0.925257687262033, -0.865749926813856, -0.844696607148038, 
-0.849903325475013, -0.885240835202895, -0.87012809899451, -0.912728723885039, 
-0.897586518415072, -0.929765526357166, -0.922072041431814, -0.926870279277253, 
-0.89826149999942, -0.87457537290501, -0.88015400621939, -0.877037424292847, 
-0.905058119707577, -0.863438600420625, -0.9272926790323, -0.874874406554329, 
-0.826552639447758, -0.838122929154727, -0.853944142013533, -0.863669195559635, 
-0.892447306917785, -0.87487967322524, -0.908051947029393, -0.913377304718224, 
-0.914730573503888, -0.827036763814078, -0.90003813436382, -0.910030017501486, 
-0.895341545367731, -0.890524193396496, -0.861667866010991, -0.865166170242642, 
-0.910125256693863, -0.916908040422033, -0.874195765319556, -0.918802138244667, 
-0.858483544290935, -0.867707149402963, -0.826327057172366, -0.886484858745601, 
-0.866155220099031, -0.892626294449677, -0.889356215338135, -0.882050031664312, 
-0.921879834430894, -0.960643478415757, -0.854429170795087, -0.841919301026697, 
-0.92554426915224, -0.900102039501564, -0.825622760576828, -0.908522985946049, 
-0.842013736377228, -0.838187185672472, -0.859462760450554, -0.879658184891585, 
-0.84996393052578, -0.854504731392134, -0.929546087718485, -0.908598317121736, 
-0.806824174287639, -0.929195224434972, -0.937954086293353, -0.872482868938567, 
-0.899239902712522, -0.895252761332684, -0.855336186157207, -0.869886698749073, 
-0.884552130492554, -0.884573648036775, -0.911050497067531, -0.826682267339484, 
-0.851069326106167, -0.88346785684248, -0.898346644011722, -0.84829582609548, 
-0.921762385866726, -0.923630427150272, -0.915751920321567, -0.859053346920681, 
-0.901716954381736, -0.9128040412953, -0.913735689772935, -0.92316881941717, 
-0.878422451559754, -0.907823501890863, -0.862946182247887, -0.85705304878078, 
-0.906973165298295, -0.924960686683138, -0.939748643408984, -0.853393289312017, 
-0.849813573645052, -0.884527181777312, -0.864698540806403, -0.837662845991193, 
-0.86916235633521, -0.91770904816251, -0.914105895824325, -0.846904377728643, 
-0.859915203064882, -0.9105485582498, -0.848787495221099, -0.834942769060347, 
-0.918460469439116, -0.885252124195311, -0.94626467066279, -0.862425737630572, 
-0.879814633424406, -0.885455526318982, -0.862279334782611, -0.917822560393847, 
-0.927111166922576, -0.813336477726669, -0.890405279684171, -0.906667422404755, 
-0.867273701373285, -0.924037118335764, -0.931173487201407, -0.902728526156942, 
-0.864779094339857, -0.887263657458157, -0.905796142660967, -0.84996046995198, 
-0.859195245366375, -0.832694205373721, -0.79454477343708, -0.90791268009816, 
-0.901752801455598, -0.865924996748049, -0.90851973596016, -0.873453279007608, 
-0.919102843693408, -0.937464862278747, -0.906825639131519, -0.90288078315786, 
-0.924662314921499, -0.860234777358061, -0.815879108596085, -0.901581066160499, 
-0.969583045711376, -0.90182955936778, -0.957721701974435, -0.86363048638202, 
-0.910308815710747, -0.849356598907134, -0.898283465898068, -0.748279204163218, 
-0.945070471893467, -0.907839334042428, -0.893385433316293, -0.838726253752114, 
-0.888843567741104, -0.87608819995492, -0.908987745431244, -0.862008474710668, 
-0.936610601245738, -0.828399907826162, -0.92388750995387, -0.862987254254484, 
-0.882438697777375, -0.847355300039588, -0.819802546774079, -0.871239203369137, 
-0.890818792649633, -0.883962074853096, -0.863192226294632, -0.9110490132288, 
-0.857749307700778, -0.905385818326174, -0.807421184251379, -0.89277715166759, 
-0.851195696728585, -0.862798531161304, -0.881395860108474, -0.854667250068466, 
-0.870077137189105, -0.930071745858235, -0.927470776395735, -0.883130518419251, 
-0.901631910443824, -0.873556171148978, -0.96758304377878, -0.851569061074902, 
-0.923544735017026, -0.855265817162686, -0.772820817163641, -0.807830403617222, 
-0.881975208595548, -0.896029460336181, -0.882824046541056, -0.934701220224156, 
-0.854323571188475, -0.919638924872276, -0.88226598656774, -0.903771336221463, 
-0.842261973817924, -0.9264233067145, -0.903589245266606, -0.869562849541453, 
-0.932606599267034, -0.879836673009203, -0.946861706138312, -0.893293454508797, 
-0.900705242344467, -0.838865362169619, -0.888162347003353, -0.910776069019224, 
-0.835298798511224, -0.835321276377649, -0.907578251768937, -0.902124611620877, 
-0.897248355384756, -0.821546673578193, -0.869916190331463, -0.867745428175976, 
-0.92313591624697, -0.886106833759722, -0.911362818767844, -0.899954412584077, 
-0.847594104298633, -0.87976519921023, -0.835984433977154, -0.917385141563911, 
-0.906135866047097, -0.893568282392684, -0.93939558775047, -0.914330600141497, 
-0.861754183028939, -0.844771400334535, -0.876319093231983, -0.929579562276424, 
-0.885340485330884, -0.897153088177161, -0.95892783811819, -0.896437125937536, 
-0.890207763718911, -0.91968028491853, -0.940309625104997, -0.925744880251061, 
-0.893226004332504, -0.930961983154571, -0.930308408009577, -0.921649106107967, 
-0.859534918351363, -0.860956665658499, -0.89461558036638, -0.920140299250347, 
-0.883526384238113, -0.901782688300267, -0.863542454949088, -0.84797444684733, 
-0.879335613239465, -0.888542098250938, -0.949323532382098, -0.848081180239904, 
-0.871121619054185, -0.888473424047874, -0.941321937286216, -0.89893862560248, 
-0.86280469227545, -0.913313859340729, -0.846416750281561, -0.950499094509453, 
-0.829201563928218, -0.917576721578353, -0.859014058040377, -0.910769978449687, 
-0.894606234591698, -0.884024048636455, -0.905870832292751, -0.901236210267469, 
-0.885076894763843, -0.923310562277016, -0.840469788995834, -0.861365709518713, 
-0.926879268418185, -0.898687432792886, -0.89975700342667, -0.873844137706892, 
-0.799792343741705, -0.850657700944994, -0.850639524083122, -0.808317149225791, 
-0.859823071921649, -0.883770492619706, -0.848247689037676, -0.896681637713708, 
-0.901639058251818, -0.891589140509776, -0.926373891026544, -0.85487855848234, 
-0.8263630404027, -0.914718349443745, -0.919434516756655, -0.88231912707301, 
-0.867478792165137, -0.914219351136792, -0.874281708847183, -0.872876841004898, 
-0.87417423381508, -0.881334971284069, -0.90401195587769, -0.928713398810422, 
-0.864075625108233, -0.865294262172486, -0.941568813452721, -0.935090685968269, 
-0.883617338451699, -0.921815189180799, -0.821090895123662, -0.880592454504286, 
-0.916645141608934, -0.833947029420412, -0.907505470322918, -0.82017482251378, 
-0.891646722439008, -0.884062004878724, -0.837745889092958, -0.880528747298029, 
-0.902297200002102, -0.912721994190948, -0.898203893896145, -0.911112950218132, 
-0.882475723342808, -0.849348827193163, -0.840642467614977, -0.890940970644368, 
-0.908682358490799, -0.87037784668539, -0.879270067793208, -0.856926561677016, 
-0.844553907947627, -0.829558194641148, -0.923339184410282, -0.910816325169992, 
-0.83820668145091, -0.906951718525285, -0.83274547890089, -0.872752514584078, 
-0.92139567654069, -0.830273189052622, -0.913788581603654, -0.902044043224305, 
-0.864242938349192, -0.923895295325384, -0.904970978419538, -0.918857425850381, 
-0.893738674831362, -0.873076057159963, -0.790339077424054, -0.933055552527008, 
-0.904061043409477, -0.848576173917482, -0.86590240114726, -0.865693055018799, 
-0.93474660239401, -0.888054804477369, -0.908219231448155, -0.91854725903175, 
-0.879799389426088, -0.81365746103095, -0.871425162591651, -0.857315825185193, 
-0.8602645389232, -0.851569723310972, -0.862580889777398, -0.921121686287822, 
-0.913758850338259, -0.946126733173202, -0.930874072059273, -0.908820930651221, 
-0.856638557014967, -0.771442673601198, -0.898326413990896, -0.898288254802723, 
-0.90790719466875, -0.917367770690082, -0.948094273983071, -0.829773543191369, 
-0.834384935472211, -0.848967860352952, -0.827274913414788, -0.821604220616283, 
-0.839121180445722, -0.884777399143536, -0.89017012522554, -0.867066442718008, 
-0.713887418294996, -0.917456063952303, -0.871650864861618, -0.930355688587242, 
-0.938559173809445, -0.883665899951144, -0.896897950600836, -0.845889812073969, 
-0.861223494119824, -0.819318037855895, -0.903284629243779, -0.802157904006188, 
-0.920314247395295, -0.881041169115395, -0.897278192393465, -0.861775615379847, 
-0.858863264802765, -0.888448268698525, -0.903196994472923, -0.865351568464095, 
-0.917824954189654, -0.902289243028571, -0.891631022306486, -0.870793216341138, 
-0.916861262904552, -0.839762661312444, -0.871135085630634, -0.879551088086629, 
-0.824400697370482, -0.916830194662062, -0.847513426710625, -0.883016423553458, 
-0.877866272992164, -0.884619958366016, -0.917864926402076, -0.906481991714086, 
-0.892897569321036, -0.92399497956348, -0.823440207945139, -0.922895077481075, 
-0.904827813605587, -0.929192405158391, -0.921126623883799, -0.814145654874394, 
-0.853758098647857, -0.87143952977811, -0.793641534199048, -0.873238006542264, 
-0.839567161340523, -0.905484178041859, -0.898896547637018, -0.893833589314764, 
-0.909517985078988, -0.89001811324861, -0.898668868470644, -0.867810656426398, 
-0.916094725080264, -0.854848250980133, -0.868743794455586, -0.884711893929041, 
-0.84962347960781, -0.904940111260623, -0.913490528420714, -0.857496773859059, 
-0.908124983111649, -0.892829772887192, -0.893552041081356, -0.88284474871842, 
-0.898073256029905, -0.790924758294351, -0.803875907533138, -0.874357281333464, 
-0.945908832484175, -0.854816781762552, -0.907676080027353, -0.936830709010842, 
-0.963546315178947, -0.882099218675355, -0.864219878744134, -0.90084030392939, 
-0.872494197484142, -0.778634814883444, -0.882489876121952, -0.814159281607787, 
-0.884156604334591, -0.909098662320827, -0.88799991793786, -0.879131280985495, 
-0.91025672002149, -0.837484516117627, -0.806346250876668, -0.946327534697252, 
-0.886428764517256, -0.86367388211019, -0.905519150672373, -0.883143689811326, 
-0.873950052226264, -0.845591887335709, -0.855755780180721, -0.8789257058878, 
-0.84189047067958, -0.929326306225334, -0.814814370770444, -0.846453415031324, 
-0.843842789522194, -0.85287483226546, -0.910025900076062, -0.823251340920157, 
-0.880526772105971, -0.858079970172413, -0.935201673473432, -0.843923212424288, 
-0.868485513509837, -0.885330910500204, -0.919644344755214, -0.903213015327146, 
-0.844408320486863, -0.827395920338026, -0.89248179251918, -0.884433820528232, 
-0.899482237654775, -0.898476396980494, -0.92209675915827, -0.884787766386945, 
-0.94162379062385, -0.921989776718369, -0.92071768762047, -0.87976760704984, 
-0.888629639364447, -0.900829255881529, -0.847828909064174, -0.901315237484128, 
-0.862206492472397, -0.88835799887453, -0.908226464166787, -0.887549252356842, 
-0.778342365983587, -0.922184886248445, -0.942477140339354, -0.904845403001942, 
-0.907764948065274, -0.864283124885267, -0.886870971889643, -0.918684569798757, 
-0.804421348036471, -0.903801527062213, -0.818178758073088, -0.844490429899906, 
-0.878367439234106, -0.90457044969068, -0.827675995675975, -0.883013715414703, 
-0.934423263525285, -0.817041121744317, -0.945986215846853, -0.906741383392403, 
-0.872704449789668, -0.919242933570154, -0.88335278713015, -0.878962066215175, 
-0.883575364910276, -0.938558736873487, -0.927425759881995, -0.799565811909348, 
-0.849952902220353, -0.849823643137953, -0.88943684117076, -0.891815654255447, 
-0.913002915523741, -0.905100900568762, -0.852177723972343, -0.919476964392908, 
-0.868444588536652, -0.867803764807547, -0.867916844225824, -0.877334257964625, 
-0.841194270827335, -0.923010192261451, -0.880587149210797, -0.864750798273315, 
-0.916238101871213, -0.866901555104227, -0.916443143721841, -0.874059371660543, 
-0.836118203542284, -0.80837748596491, -0.865224578159462, -0.913600015361399, 
-0.86416926462196, -0.930230055358795, -0.874889114083295, -0.933578615948666, 
-0.871238718282949, -0.88604609879006, -0.877820382466712, -0.832091908738163, 
-0.89577416152959, -0.863578557735814, -0.870011526803059, -0.839846746778895, 
-0.846075264334098, -0.874796321349219, -0.90644889150976, -0.930991790011164, 
-0.891518124742289, -0.819844280484447, -0.910859697553357, -0.886381695410681, 
-0.876629727987902, -0.905719452585119, -0.832220427844291, -0.901913934875948, 
-0.917523353170914, -0.885223194836368, -0.89149184035095, -0.879584495987044, 
-0.89848933505012, -0.828235546485057, -0.861072743872174, -0.832118748824312, 
-0.893403324947133, -0.896032784242555, -0.865775228341585, -0.900079325415308, 
-0.85668479792411, -0.927020297638338, -0.872190676961753, -0.862933858490542, 
-0.893124604538762, -0.913624128856982, -0.896333977627366, -0.862837035822221, 
-0.921583181980845, -0.894478236468906, -0.84630405204664, -0.90361820961653, 
-0.883819904465621, -0.86304218913834, -0.937722072613226, -0.88787307472137, 
-0.90276875295246, -0.893799069390575, -0.891200094843742, -0.876611042214342, 
-0.86617849392679, -0.892972421588183, -0.929807425326767, -0.878316500556915, 
-0.886034092335955, -0.866457441007954, -0.9074961791915, -0.91660838953758, 
-0.864283280564453, -0.921338691671796, -0.941574727449976, -0.859859652512485, 
-0.863773952061453, -0.790012282912286, -0.881835564284266, -0.84464763648395, 
-0.903407275240552, -0.831061778141058, -0.85065934395142, -0.877655626453575, 
-0.834453449220017, -0.830976255564591, -0.848811269573566, -0.861868482015393, 
-0.906466270036204, -0.890831366130659, -0.804382380569721, -0.876114238671623, 
-0.845064059572267, -0.88551376241242, -0.83497089178724, -0.8968512016906, 
-0.910550730474088, -0.933473098151083, -0.884469511236027, -0.926441632194972, 
-0.829937065234779, -0.897453239429133, -0.92003561027618, -0.85500172215999, 
-0.846898070504387, -0.927458325052078, -0.934071162863755, -0.86046175095044, 
-0.914097070257922, -0.89861315387765, -0.842871730141968, -0.95081239829434, 
-0.868124140004278, -0.910125805436313, -0.902664520834178, -0.837698098645193, 
-0.866167999252355, -0.868322520850756, -0.804543796534272, -0.850363231063218, 
-0.827066837896922, -0.888968074558252, -0.885608910345588, -0.886517492948155, 
-0.932511169213736, -0.850810885836299, -0.833458209119944, -0.874663105623096, 
-0.919932866988807, -0.841151374944106, -0.909355332027413, -0.781425268732704, 
-0.871778324353305, -0.906476038104549, -0.889041374052173, -0.909072669622792, 
-0.862302410931034, -0.878000945499101, -0.87888619671705, -0.9518973549144, 
-0.911303683565554, -0.814049077532302, -0.839186783488503, -0.857487063334855, 
-0.891723961331184, -0.909313522346331, -0.854925689596139, -0.820801741056568, 
-0.916895047396765, -0.874860655088207, -0.891739146919237, -0.891165592373518, 
-0.885360957968535, -0.921703377871947, -0.828297601240764, -0.895257927776778, 
-0.846510773589956, -0.841005763714524, -0.871958173788869, -0.899971001027722, 
-0.852811220767349, -0.85109118665276, -0.85475135808019, -0.889751325340043, 
-0.863304517087617, -0.796795491846831, -0.934661597409677, -0.91279805918275, 
-0.86235597012539, -0.862551673584917, -0.929277751006358, -0.719412672764224, 
-0.637869278352447, -0.650546956612998, -0.575554771964779, -0.614477685105174, 
-0.634407345427005, -0.640965034981284, -0.67104849104439, -0.520023209400265, 
-0.43163157829628, -0.484225912815252, -0.617235676256228, -0.554319052588818, 
-0.653002872404988, -0.506996288611344, -0.570153978675998, -0.56485169960126, 
-0.582342349441745, -0.651161781848716, -0.670732477736936, -0.544027860021035, 
-0.619087069692248, -0.482277181512321, -0.627519305088596, -0.683653727012046, 
-0.496806592229147, -0.529161828698153, -0.536546164068826, -0.629694586996983, 
-0.43758282772129, -0.520784774762898, -0.621861074973458, -0.648231030411465, 
-0.593070517517509, -0.594728099357322, -0.579345044724548, -0.675901285122566, 
-0.600056154619891, -0.580624827448951, -0.554968464389573, -0.590102322441912, 
-0.518237479060407, -0.75130868862329, -0.785756158472935, -0.623451251190322, 
-0.772551378457674, -0.606480890821127, -0.537356754401435, -0.641310627172, 
-0.609956542993992, -0.578874653798766, -0.654192885750067, -0.647101789104988, 
-0.611397115337401, -0.524163791850762, -0.571169767550024, -0.458952525908991, 
-0.575116633119836, -0.663186118200368, -0.585527554558608, -0.59427099823095, 
-0.55091670953169, -0.606201917170366, -0.505978322185821, -0.484550832054857, 
-0.653056027198438, -0.436394306149076, -0.459497522056019, -0.484926636084085, 
-0.60352146386059, -0.699101000672589, -0.614208028012437, -0.5048370236611, 
-0.570731600007897, -0.559555486115031, -0.551659981193312, -0.52186027701182, 
-0.606618499436821, -0.602181342033844, -0.578329671864886, -0.543466035249778, 
-0.518802661422877, -0.622185814241526, -0.573741966762246, -0.687658098626386, 
-0.477981847068074, -0.565974095590035, -0.635899507127638, -0.53374024283783, 
-0.626514247875395, -0.617651694555082, -0.606774978469385, -0.554040434626908, 
-0.52775543934802, -0.528814730011162, -0.551919162262886, -0.646026193068812, 
-0.660875227986622, -0.524508294290636, -0.676951222936709, -0.722213781179856, 
-0.690529658955458, -0.595463448997185, -0.421404746645368, -0.605291659142347, 
-0.502544490441999, -0.633037164898347, -0.400572240120127, -0.624255923951042, 
-0.70688663784791, -0.500714903338347, -0.528106281470123, -0.661630108133927, 
-0.537661327458494, -0.525845783626051, -0.51031784161311, -0.527213526565492, 
-0.57440962590857, -0.585305346925986, -0.57180308229488, -0.455486787170266, 
-0.384644380231169, -0.650712161008213, -0.563535909655918, -0.647302498966518, 
-0.605953453894577, -0.546911165790338, -0.560083486269512, -0.651077264776589, 
-0.640849226489754, -0.458641405958743, -0.502708571744285, -0.558212972025372, 
-0.61870185443901, -0.579720139487679, -0.623252277558856, -0.671282024505343, 
-0.663507117835547, -0.467370758114329, -0.630624594170406, -0.67332427577183, 
-0.608086659642172, -0.68000487664248, -0.488764183992031, -0.707001871121289, 
-0.646017312195117, -0.655148064949452, -0.638212540647509, -0.60734774407354, 
-0.480049718507613, -0.630557781078114, -0.531360549804732, -0.66793621471039, 
-0.434331994449431, -0.624661760333387, -0.520382954070024, -0.6970585954814, 
-0.476650641771583, -0.581023485431404, -0.599223504785001, -0.589778524255722, 
-0.424341882107016, -0.68545385423134, -0.598821512691503, -0.535790786413646, 
-0.612776538515478, -0.606552639042644, -0.559928735427728, -0.650696844647038, 
-0.550954277427876, -0.655854403858568, -0.517861077440157, -0.512371839901032, 
-0.608461330616358, -0.659239191779174, -0.562903394885571, -0.659488368779531, 
-0.454778283321598, -0.510631031043707, -0.481381015918015, -0.502002433243343, 
-0.458511284277721, -0.558564573849146, -0.595727694829106, -0.465618037735949, 
-0.566683891695093, -0.608501479520908, -0.653902573121704, -0.493870247246593, 
-0.597755848837129, -0.579387292795501, -0.674877828694216, -0.613619641761291, 
-0.600138446969015, -0.66786849195823, -0.654728076184009, -0.521139482208987, 
-0.57000055742143, -0.623248013966823, -0.469738184602766, -0.673965755822952, 
-0.569392942800239, -0.526631900086208, -0.683632057799176, -0.545358613948405, 
-0.586552015451576, -0.595984025623354, -0.524908638877007, -0.55751075452863, 
-0.651142083641397, -0.549355456345371, -0.594298448584249, -0.680109514351764, 
-0.469927407269727, -0.515317394947452, -0.554800175681993, -0.506902935748193, 
-0.6323731956028, -0.610302909649484, -0.573674543030936, -0.542849176793951, 
-0.612652470197806, -0.596770904486579, -0.584531499603206, -0.63287884620589, 
-0.683704115367048, -0.616815359918376, -0.568924442507491, -0.56441651076176, 
-0.615991087330861, -0.599612811862821, -0.57269448205249, -0.539828556090693, 
-0.650624498619757, -0.55100484287324, -0.556571232843326, -0.632034730285432, 
-0.558500183781537, -0.569887797069721, -0.561578943841574, -0.555471321147865, 
-0.612567826238942, -0.653498195868687, -0.610661619334719, -0.61641838366389, 
-0.537760163435205, -0.518386504719611, -0.296581226706984, -0.603094841502682, 
-0.553914643424764, -0.476401561710903, -0.622173010354638, -0.665622511131542, 
-0.601031934507364, -0.482377246905996, -0.542936081389194, -0.651303847998788, 
-0.623805406878995, -0.583127709265867, -0.630584360288549, -0.651537417328412, 
-0.590479359870799, -0.537159017526, -0.455973664466835, -0.512944867621733, 
-0.683731917464182, -0.499962856875733, -0.670384750175099, -0.553946946887043, 
-0.538521181436246, -0.425821336283749, -0.616674390239209, -0.65013933399456, 
-0.600397733829873, -0.604890448272358, -0.646089084793129, -0.550042204739937, 
-0.611930750713865, -0.446263232048661, -0.611041784130231, -0.624077448682649, 
-0.553429421992841, -0.560811861478766, -0.479253862831921, -0.512926770419157, 
-0.464849203982797, -0.59792966538711, -0.382761734443792, -0.592303618807569, 
-0.716719902461696, -0.638618767271704, -0.61414171997461, -0.600101323353621, 
-0.680974076490675, -0.579866369834615, -0.576735938085225, -0.55101872688994, 
-0.63113501415591, -0.469654773857055, -0.713810971966393, -0.581968173089258, 
-0.547705719999984, -0.587512877022873, -0.61803189895968, -0.654629850525925, 
-0.592977999804306, -0.43557053906945, -0.569705797274623, -0.500242590081418, 
-0.598146936883914, -0.547161089641305, -0.703454409305071, -0.58684812669825, 
-0.545778990301202, -0.617492271573431, -0.57680169923714, -0.477780739561264, 
-0.771397339136958, -0.639640905279718, -0.678846900853126, -0.562858876948916, 
-0.62741393922349, -0.582131266455211, -0.587513904903743, -0.433234418779259, 
-0.533292133922106, -0.546306731103589, -0.498205609163193, -0.656276790889173, 
-0.605765808248309, -0.644789348925205, -0.472915981674984, -0.560151305671555, 
-0.59406334761722, -0.39566097285634, -0.54234041388528, -0.496260007299178, 
-0.597897903984368, -0.486648657049722, -0.644222326951869, -0.689629808741047, 
-0.601250054750306, -0.65721890185635, -0.471009251450115, -0.527548702054580, 
-0.522992437821947, -0.589344095528385, -0.625511952254297, -0.542765749535504, 
-0.607104849327421, -0.620046814298837, -0.721407713362067, -0.635716988430637, 
-0.679912945845579, -0.573070735753817, -0.627580339539043, -0.590649299023135, 
-0.595066973177502, -0.57599157770853, -0.705881800348688, -0.531751806233613, 
-0.595390497862577, -0.65096908994172, -0.593281140429201, -0.617031187045569, 
-0.518376620923644, -0.560267481620096, -0.55619521558303, -0.371232385481311, 
-0.59850703025163, -0.699187956035677, -0.63742182931741, -0.585612412301493, 
-0.702069197166846, -0.547181023803876, -0.497647509423714, -0.462868998872815, 
-0.548836469064894, -0.620495571047503, -0.612234942214696, -0.688458857776985, 
-0.357724307228554, -0.611817840043039, -0.640906433754808, -0.725728373248722, 
-0.637871113484178, -0.632018187960465, -0.690248897984082, -0.617174564999303, 
-0.703297166883567, -0.592140739336886, -0.552670869427785, -0.599433043627249, 
-0.645793337628901, -0.5454332798619, -0.591854145218886, -0.588162310455889, 
-0.535264576882807, -0.569707094437342, -0.508690606634532, -0.566682288513078, 
-0.561927601269588, -0.498414285045764, -0.640146733679862, -0.581835111165451, 
-0.600366750996512, -0.648929244141561, -0.655769229049524, -0.631018646487522, 
-0.517370318113293, -0.52455011421513, -0.553232102839658, -0.578261441974128, 
-0.636235602156203, -0.568042165894688, -0.521233553677488, -0.666900410124343, 
-0.579336845474113, -0.60956422774954, -0.545059758446451, -0.573905438972821, 
-0.619754427497114, -0.567734161447253, -0.439316115368647, -0.647609329151909, 
-0.47912983882042, -0.597358781486901, -0.71521263285272, -0.498932030066431, 
-0.631336171591983, -0.628718657517209, -0.59682017843239, -0.62673722048474, 
-0.524779030527092, -0.584961242122162, -0.754417667521934, -0.610708529584986, 
-0.532798650185161, -0.643812132857477, -0.633042533483767, -0.621541311244187, 
-0.58399066848841, -0.561141485602849, -0.605675822880976, -0.610032359840878, 
-0.727663048156665, -0.547121707542942, -0.534062631223224, -0.624278487593328, 
-0.505940553842864, -0.579173581052798, -0.595516954615438, -0.57067641127792, 
-0.561874724617435, -0.568083431200823, -0.692753968992052, -0.462200096764508, 
-0.498170078903886, -0.469501115612978, -0.462008337762757, -0.623904102022375, 
-0.621618294772263, -0.578270199684241, -0.753620420670047, -0.550341515499661, 
-0.669076422359103, -0.612867284870968, -0.57680566770731, -0.580400461626793, 
-0.492691204807699, -0.556331142603751, -0.553302618181141, -0.67544139790857, 
-0.569710606843553, -0.66184346297891, -0.6376995024973, -0.498849751994738, 
-0.569749892200248, -0.557101798920474, -0.687254777538379, -0.554386068231672, 
-0.579132893247431, -0.647137488893024, -0.521420096132963, -0.617030075780564, 
-0.504690645074184, -0.609828616829581, -0.601260019088119, -0.674686671220166, 
-0.60473567867544, -0.624339935832987, -0.622787207459784, -0.565552725905954, 
-0.603364409772172, -0.543934351402466, -0.625175922954548, -0.514043482288791, 
-0.629459650547823, -0.700903591608843, -0.612146268917788, -0.56166311042517, 
-0.490501666042572, -0.716972831025859, -0.452639917521757, -0.604504394377012, 
-0.638413370696771, -0.523291168511021, -0.520898094376849, -0.662952238320446, 
-0.494884195173135, -0.485220085311502, -0.557016095436698, -0.459845355533631, 
-0.708372064867103, -0.706643156514222, -0.621697457823736, -0.550189903284037, 
-0.637025623105742, -0.580528044936456, -0.648557932462037, -0.615226175898563, 
-0.598253373981031, -0.671653377621059, -0.652920451889355, -0.657795314214958, 
-0.544071303084422, -0.624259925297459, -0.431681541231348, -0.552610235316578, 
-0.643741745389447, -0.423543681307440, -0.617384560686656, -0.488700705427299, 
-0.544944098048734, -0.629207343834461, -0.466132106848914, -0.591089498244758, 
-0.539160115124975, -0.458316220774998, -0.576022373754036, -0.583839791858885, 
-0.478463220708551, -0.602924680733281, -0.586150019345744, -0.575877769615038, 
-0.607191407884506, -0.502716781448159, -0.649557836869025, -0.581574368168856, 
-0.63633403646321, -0.441778976233619, -0.455163110004232, -0.551487859007723, 
-0.454649311341054, -0.654323472583728, -0.513097544368447, -0.517953727697089, 
-0.565585851504077, -0.435778918536332, -0.53507197895933, -0.762894334619649, 
-0.603266744482552, -0.390187749525766, -0.610351944993013, -0.657129715768404, 
-0.674670648310622, -0.53536113258648, -0.587562392637790, -0.577492440022376, 
-0.699287313794375, -0.620269423140264, -0.684367628020201, -0.444484139411895, 
-0.670457287737641, -0.574174359534523, -0.640307579448786, -0.602380609430636, 
-0.485759937006584, -0.685936055670646, -0.569378634220091, -0.689816809448034, 
-0.5657620498957, -0.546323560815272, -0.602333536398077, -0.600434969217537, 
-0.69593328117545, -0.631698843848999, -0.477194881457247, -0.618141559553088, 
-0.595745106170834, -0.595062752850355, -0.584630461442968, -0.678664710567246, 
-0.502143055901932, -0.595092335886173, -0.661871079548686, -0.625573654027795, 
-0.650797801284965, -0.707201398227266, -0.691042280098591, -0.612867156075261, 
-0.53905851294854, -0.669526586479762, -0.645605148046219, -0.597922544619409, 
-0.611669030564856, -0.621610708137007, -0.470704045062447, -0.6030282883104, 
-0.549603083113644, -0.502423303823558, -0.588405122861279, -0.630868890467873, 
-0.73715524356793, -0.480764649056821, -0.590461763053589, -0.606732615633151, 
-0.499334438200598, -0.565563492414469, -0.592482340486048, -0.529595544079622, 
-0.58798484366564, -0.566277384162453, -0.575691788070079, -0.565938251858535, 
-0.52145926652316, -0.602077765332726, -0.637654093254093, -0.541712857910302, 
-0.569507846264709, -0.553442432720848, -0.681596831155592, -0.535215738066022, 
-0.553889766224314, -0.595123705643895, -0.651583204560733, -0.650527824503533, 
-0.686987774857227, -0.551914324241975, -0.403283341831318, -0.564989053717036, 
-0.639296629330413, -0.551441698359355, -0.468585139688677, -0.442690681920126, 
-0.580809982094518, -0.572328577284106, -0.69415923052908, -0.572714790772062, 
-0.480282802039747, -0.553175755372323, -0.670169450704619, -0.609124441423541, 
-0.7541125755714, -0.74514229232772, -0.542956484929796, -0.745653791699757, 
-0.561263381312415, -0.500591542666834, -0.668540025110052, -0.576842193231374, 
-0.645074461288787, -0.61957053921713, -0.661738602994506, -0.65194753481202, 
-0.534492111060237, -0.595274775163910, -0.500688351378496, -0.663441406572878, 
-0.623852099479077, -0.718939971930586, -0.645158012944207, -0.553464241042912, 
-0.653914167909398, -0.545916851127281, -0.555139918003814, -0.603286892206102, 
-0.64591170102698, -0.645890245202761, -0.691561978441027, -0.623633028817061, 
-0.624031152026416, -0.441286220044711, -0.57515477372682, -0.524654699585674, 
-0.527282660605577, -0.666321499019315, -0.559538112567475, -0.547327353700948, 
-0.569392559832294, -0.571975688923177, -0.494174098681748, -0.606187787153533, 
-0.536400261098662, -0.45335563423043, -0.601519076861232, -0.667415438448107, 
-0.601876171315395, -0.535489579025453, -0.576510537745601, -0.684057848452974, 
-0.465739203156231, -0.516140193726232, -0.597281939939953, -0.591404371271407, 
-0.578096052528771, -0.659683048457624, -0.645704469509439, -0.610145475607612, 
-0.62516609019702, -0.598729029233432, -0.617801046210604, -0.612799234347255, 
-0.697223882506418, -0.554551574601424, -0.560798282075057, -0.526222337402982, 
-0.547915256572214, -0.605760673466803, -0.616110633268055, -0.594666158776738, 
-0.592427216238789, -0.69081683534073, -0.465513484972118, -0.619452561860565, 
-0.639084957358658, -0.461020982049013, -0.5046911239543, -0.604046307509793, 
-0.548720823558253, -0.533128635768027, -0.531189830037296, -0.61026565384307, 
-0.647418140273195, -0.45087934571733, -0.493263076326342, -0.570383334871269, 
-0.626033309400669, -0.607588198568982, -0.699973956371466, -0.645189459671897, 
-0.598958770103381, -0.586390705825672, -0.519241622542532, -0.609326501380918, 
-0.58098004939803, -0.508239641548639, -0.560555124379786, -0.574114652249104, 
-0.583452136122835, -0.58756857413622, -0.568825316551317, -0.556562540109765, 
-0.526326000285854, -0.589290526538868, -0.503878783248295, -0.550411338695412, 
-0.576066918163408, -0.590705026453776, -0.541565278518653, -0.438954627768072, 
-0.512676203801386, -0.55768950913669, -0.553277637228973, -0.653633465158472, 
-0.602174432450718, -0.544475027183657, -0.646120001212466, -0.587498874312758, 
-0.607059941823833, -0.452554420826111, -0.613429958662363, -0.617837366370091, 
-0.54682580488221, -0.525175082092065, -0.600743494976493, -0.550638151610377, 
-0.679640616892273, -0.61298741203257, -0.64763569554761, -0.645001605256195, 
-0.502435790735228, -0.51729677779345, -0.591733383135312, -0.466128208155537, 
-0.553353610432798, -0.525661711685563, -0.647715412941152, -0.605237894628606, 
-0.827510729994938, -0.577497331363725, -0.617398961151694, -0.550430752916603, 
-0.462838860597707, -0.585362579565905, -0.480578988366368, -0.607643000122022, 
-0.696401147388747, -0.52082734784597, -0.603993622865835, -0.585739004924887, 
-0.600153320464369, -0.653875161447352, -0.638865109182341, -0.417225145589666, 
-0.566959745631202, -0.567900330780065, -0.651877250542433, -0.51793883519007, 
-0.544339445471431, -0.560828195363239, -0.489911026833285, -0.612747511227798, 
-0.737315411591041, -0.678775475220548, -0.604999072165844, -0.580928256493981, 
-0.572516258197954, -0.625205328676779, -0.538412519081012, -0.560764511477485, 
-0.667945301251365, -0.523722731505834, -0.635774500185965, -0.374236082862180, 
-0.550538304934073, -0.622505149929154, -0.700081122327348, -0.590153887621494, 
-0.638525446968833, -0.608320821779929, -0.430580046610358, -0.623362664258122, 
-0.646116427247597, -0.531542202548363, -0.650966437837394, -0.51028223709937, 
-0.535247439313995, -0.659590851868326, -0.509331154256042, -0.473225576457315, 
-0.615858400806835, -0.573469792705236, -0.587122981892037, -0.648435055666079, 
-0.529950704488611, -0.575660198191245, -0.553947428171869, -0.510619738222637, 
-0.577893555230583, -0.595429998430732, -0.464202441873169, -0.556084667606896, 
-0.621959048447079, -0.632863358003857, -0.558423061530354, -0.587749831849575, 
-0.618184910728136, -0.671681227205245, -0.67150780608345, -0.541303050386558, 
-0.527989831937985, -0.662369333639887, -0.632870734027938, -0.601017473846341, 
-0.502955192233882, -0.528812190163206, -0.663488006252106, -0.533531069759815, 
-0.613930608653237, -0.47564548471573, -0.553750725298567, -0.494091353349247, 
-0.573737813730816, -0.590239095487216, -0.626009011986271, -0.579815581631242, 
-0.539310756939809, -0.691735035208974, -0.556897135573719, -0.58426300652307, 
-0.576568384859549, -0.583311056505626, -0.499823020290581, -0.601506721059811, 
-0.442006477081161, -0.551127531954032, -0.517585378181707, -0.522863218164917, 
-0.605900708139946, -0.486752301097047, -0.599702585887106, -0.687857675365029, 
-0.605274611380378, -0.610868390179594, -0.602743745180807, -0.701578557804678, 
-0.604097356474103, -0.726052536371904, -0.685488455597792, -0.53921465294192, 
-0.644588348816393, -0.550822690979587, -0.705502549556664, -0.51384786168878, 
-0.731614684562893, -0.581916459110104, -0.513922882584056, -0.530400227855025, 
-0.629073049494091, -0.551108004904552, -0.613760181791295, -0.64727086598398, 
-0.673838796506406, -0.537491444295357, -0.556894754188625, -0.710042723630561, 
-0.507857712356518, -0.432919438289791, -0.640214619639751, -0.773572551786678, 
-0.591232491330349, -0.602257147735447, -0.572597029382654, -0.528409100969873, 
-0.6278126811936, -0.646257196739532, -0.662483312215364, -0.626606272570594, 
-0.693825127213458, -0.618896447558605, -0.562493441320163, -0.677066068609053, 
-0.404640845511448, -0.620963146382916, -0.49546813131748, -0.591663932054267, 
-0.679550289652057, -0.671482977064715, -0.628706898793875, -0.510923640702235, 
-0.612302265307502, -0.542051582085008, -0.54982864467537, -0.506673851385385, 
-0.581763990343327, -0.664497000345744, -0.62084230744692, -0.718098915087919, 
-0.705779586445318, -0.503299244801371, -0.664256443445912, -0.596571591382913, 
-0.582935708875542, -0.825904802498042, -0.539008249991744, -0.549269959439852, 
-0.59028798325473, -0.525820675777823, -0.591034024100483, -0.569941604278775, 
-0.607509775506174, -0.514044709585065, -0.581002934911166, -0.574742423278887, 
-0.446434090220343, -0.711502644656386, -0.645293685128437, -0.476775702302523, 
-0.501994189057685, -0.659911622192145, -0.422679951398679, -0.517963466579154, 
-0.665542487278446, -0.530131788991949, -0.593866065991771, -0.618242443521514, 
-0.496231964435557, -0.60559971545852, -0.556055536144513, -0.512401689083176, 
-0.570404993191849, -0.520848946481114, -0.55568583116207, -0.609797502470779, 
-0.642571792917265, -0.52750369898653, -0.605861421012462, -0.66036872199014, 
-0.506884016865601, -0.660105110572747, -0.564296529526932, -0.603198983065460, 
-0.502422408889647, -0.725549951111145, -0.422739144926749, -0.692108769954532, 
-0.628387404990759, -0.700291353904485, -0.605754410239236, -0.307921370975258, 
-0.424988911825764, -0.38185783540692, -0.310426051743328, -0.383852583861083, 
-0.245362459891691, -0.439429323674614, -0.216070110470480, -0.298276115729305, 
-0.287464402321510, -0.351838748521105, -0.301808332343402, -0.312403454274384, 
-0.260198887133647, -0.378484218114250, -0.250440904298665, -0.351738470405831, 
-0.294837260220425, -0.382639941580933, -0.269781744783396, -0.192052122412732, 
-0.282886086828798, -0.321199757533616, -0.278434021531051, -0.540471182495675, 
-0.172862610703850, -0.387295835506866, -0.277104045631442, -0.237314845979596, 
-0.461623708657139, -0.302816593383794, -0.241016349674001, -0.368030859436214, 
-0.369326753905363, -0.197395290225286, -0.430702974530895, -0.303234501001407, 
-0.35613562392757, -0.400051707055326, -0.283991234410860, -0.335888025429494, 
-0.119764682391519, -0.169986101730760, -0.342538157144201, -0.124588888644220, 
-0.305307739896563, -0.0370362505680162, -0.214032243642079, 
-0.293749761578571, -0.404671442439841, -0.176153426967739, -0.438028314089847, 
-0.349983273783594, -0.221379140284034, -0.346218304419321, -0.301223321401280, 
-0.487329904420201, -0.360812208588722, -0.366520020826470, -0.318869784473659, 
-0.392466712656982, -0.270318869736936, -0.390751743747906, -0.511910097528929, 
-0.359223405673931, -0.327975059491564, -0.429111854115634, -0.290280804137149, 
-0.396242155661814, -0.255347343484937, -0.070769752393858, -0.380794513102492, 
-0.299684740708238, -0.252528108454297, -0.349218810500678, -0.428969708888488, 
-0.276851324429045, -0.333048817758106, -0.320724498614898, -0.284223882249758, 
-0.0535415741811, -0.21948390638763, -0.342703377197862, -0.406793367926398, 
-0.223995955389135, -0.394965290727414, -0.303801905347136, -0.243601841346017, 
-0.372610822361047, -0.234365929074889, -0.341525244047149, -0.319843567299271, 
-0.302768082267561, -0.383445142585386, -0.496386973942187, -0.279944634341601, 
-0.150792473087196, -0.410048407747172, -0.263849037780674, -0.184178108118323, 
-0.267744527772090, -0.403013803862156, -0.281979404516786, -0.314737272183781, 
-0.140603580891678, -0.231042316443832, -0.476716697491402, -0.407369375584294, 
-0.174264676295115, -0.301886389380881, -0.324784601630613, -0.293704033171536, 
-0.505471780093447, -0.257515566877209, -0.186483162749321, -0.322390044427887, 
-0.154288045789038, -0.151710913155439, -0.323958335060546, -0.282046003163104, 
-0.254946156975119, -0.41130805286624, -0.322650374805648, -0.477624701153212, 
-0.267031190948403, -0.235604844231995, -0.274653838618586, -0.193610491826503, 
-0.305414000321472, -0.199639406563729, -0.369234699984169, -0.174956795547472, 
-0.235739138082024, -0.46398744828806, -0.330096685653695, -0.322744998512471, 
-0.168454215980812, -0.182451282650939, -0.259917312180662, -0.0822075788980216, 
-0.308659254753835, -0.409180291595146, -0.236777733270826, -0.224417823180029, 
-0.367427715564747, -0.272553550632633, -0.336954943024173, -0.210026816102702, 
-0.213125757391231, -0.282467814476409, -0.170288355580208, -0.172363813314075, 
-0.269908849597355, -0.236897117686547, -0.329894720891705, -0.26508044921923, 
-0.303835090497625, -0.345478202356090, -0.41491389707598, -0.184463412899603, 
-0.279846155119674, -0.371731090207582, -0.412668219701913, -0.292353150479976, 
-0.242513109592930, -0.181302278237191, -0.315184524022014, -0.238762061571148, 
-0.308570740043484, -0.314496507430514, -0.388001588306723, -0.374162652952815, 
-0.36731577538297, -0.231402921761594, -0.232805353157099, -0.258228440483826, 
-0.271060969329814, -0.311052690137062, -0.277816173775121, -0.178675388561245, 
-0.34694414741402, -0.184820738793289, -0.247162354297008, -0.130997767506474, 
-0.240828649006677, -0.227569281725449, -0.195717153504717, -0.310273492519172, 
-0.298026550481641, -0.240468454960187, -0.413302902046157, -0.346774875022113, 
-0.28320865182777, -0.231678039483, -0.215238136454044, -0.314693996937329, 
-0.303491738840571, -0.158872346234198, -0.380480988024211, -0.329927158606675, 
-0.214968852547415, -0.254745083211784, -0.258291808026816, -0.391687745115177, 
-0.329778412394084, -0.07654562435262, -0.268112462875556, -0.328843965890652, 
-0.348250456581926, -0.363054072601114, -0.214790670185808, -0.226440663767949, 
-0.275629108488871, -0.381556176577793, -0.320769725961507, -0.326103284474974, 
-0.242823685239361, -0.319286477320297, -0.329612072284113, -0.195002444890054, 
-0.240317594283301, -0.198536018382755, -0.389808663551804, -0.158237309785109, 
-0.267146661736509, -0.194680371870615, -0.328438496519786, -0.199435725604755, 
-0.356286588545911, -0.445474763111915, -0.237171075062807, -0.261023455164705, 
-0.275521469127548, -0.291356832014504, -0.216939503817472, -0.148398805269328, 
-0.421718523238469, -0.305701218099813, -0.361501494156972, -0.245320443598809, 
-0.27532728336668, -0.332813763698889, -0.324612276912988, -0.313280775412056, 
-0.3721539767625, -0.44896020937355, -0.231137551687029, -0.432118651443857, 
-0.165519213218925, -0.314287352052224, -0.48823745717252, -0.305467804820971, 
-0.370467925781306, -0.316764244983256, -0.405538886419487, -0.38513909511249, 
-0.193344049329085, -0.321448432196806, -0.322218595211194, -0.254419652039599, 
-0.391738847201514, -0.403181910158592, -0.374484084724455, -0.229714397263539, 
-0.343701222148568, -0.141015282593643, -0.3632738180562, -0.245111287202664, 
-0.321203796250566, -0.241879136176644, -0.324663514673803, -0.309858008566982, 
-0.301116517363207, -0.381908821222858, -0.268320791179621, -0.261486399357214, 
-0.290363378957913, -0.113824562604335, -0.348923921123579, -0.241589395126069, 
-0.364723812328771, -0.229582038965981, -0.349476075495201, -0.391688004129767, 
-0.319055695781904, -0.151242753366818, -0.45374166430359, -0.316029175027107, 
-0.334041554565712, -0.296854711604098, -0.346173487340395, -0.414615508717861, 
-0.3357285762622, -0.314712929028417, -0.406223952587217, -0.261175724643735, 
-0.161346074593491, -0.291600170771608, -0.271068856846363, -0.0303898460818164, 
-0.323418815897397, -0.286751368801315, -0.327914944062898, -0.312061414026807, 
-0.373598588653759, -0.308858946773225, -0.312813958873489, -0.308500001868749, 
-0.221487260999118, -0.279884824041356, -0.462540321082993, -0.41430572866693, 
-0.30179441354878, -0.224314217680069, -0.276509339222627, -0.242797611435185, 
-0.306300350811476, -0.31076714517221, -0.303977674839502, -0.327842337355991, 
-0.321801091917292, -0.276339553172828, -0.223124336264098, -0.190908792509534, 
-0.466702969007483, -0.240691216231957, -0.319628182078355, -0.329359145166792, 
-0.309568969670853, -0.156956747705042, -0.0857496548573512, 
-0.274010623713562, -0.207062994064791, -0.372324416984723, -0.365730487009527, 
-0.423872237423011, -0.219193468561189, -0.229342301860371, -0.114578105139391, 
-0.448466021147195, -0.256581171145475, -0.214141340441194, -0.305505963156714, 
-0.195340580857953, -0.232258027077127, -0.213496091010641, -0.337777673827265, 
-0.298504381950878, -0.160096316794156, -0.317843933115053, -0.166101709024867, 
-0.434771020933773, -0.35642278939167, -0.252674913642753, -0.143798955894085, 
-0.175865883266929, -0.325734519364823, -0.0107169718620422, 
-0.232256868213724, -0.289767662427656, -0.313766032024117, -0.264220172896152, 
-0.414455396035393, -0.157890402443137, -0.237735961050882, -0.278718495435499, 
-0.363318997037983, -0.418140519475129, -0.193033326123836, -0.400112480751783, 
-0.286603606316974, -0.17282157631232, -0.243365926728801, -0.294623169481406, 
-0.337413672323408, -0.347366694261954, -0.293049091007304, -0.350388490187038, 
-0.449947432836463, -0.189606811489933, -0.162426378511747, -0.329736568260043, 
-0.382207455481325, -0.258163640335732, -0.321742828679795, -0.182020060368858, 
-0.369095264601723, -0.361343689867836, -0.35183758372932, -0.202700841285932, 
-0.330870578614293, -0.182674898683434, -0.287961647232420, -0.343806895351891, 
-0.411447903044073, -0.340351277072151, -0.36740970333771, -0.319648893208033, 
-0.257115965222410, -0.340536784543915, -0.173011791269754, -0.239144332012295, 
-0.248315335332070, -0.308826054073607, -0.423580539657858, -0.242122799821441, 
-0.309662404274415, -0.358256693044534, -0.288208134877094, -0.199983148253386, 
-0.326701452455432, -0.366537369490577, -0.296585263702351, -0.325361184846960, 
-0.320893512305969, -0.280143044914108, -0.396486437585053, -0.288289832799321, 
-0.176407041697376, -0.257555018280765, -0.423911041485462, -0.285342264369644, 
-0.408424418945537, -0.489819502776534, -0.303199160904719, -0.242468651322627, 
-0.366769086648908, -0.307882100576237, -0.202555625385369, -0.308879093603554, 
-0.285613116845815, -0.314056473955006, -0.386103734771115, -0.304426579756519, 
-0.373090998250016, -0.219689102786806, -0.181778951780415, -0.399969073878417, 
-0.212127064648532, -0.498940567686025, -0.265049264090510, -0.131213509216845, 
-0.319475833191529, -0.309420494769059, -0.295083935968702, -0.307115607104571, 
-0.249768223859182, -0.439852659178422, -0.294649939250255, -0.31452112176952, 
-0.285092019012834, -0.375132399312558, -0.310941094002023, -0.363077560448008, 
-0.226909136100588, -0.340962932300488, -0.174383474806854, -0.310112192090699, 
-0.198667835983589, -0.220248634982694, -0.235561828509951, -0.440642914252756, 
-0.276176634009842, -0.340728239666948, -0.145361099195294, -0.358586110632343, 
-0.333424150845068, -0.115760715333225, -0.337398668307838, -0.173609910962376, 
-0.248451409142865, -0.264511756593683, -0.193236042466763, -0.1854591931422, 
-0.386005195633993, -0.367682847903039, -0.259798840507729, -0.267027271328427, 
-0.407009090874733, -0.184243815133337, -0.306969836344345, -0.268493294013038, 
-0.377786781914033, -0.290853722384144, -0.303819454562729, -0.431168210898537, 
-0.360847485127765, -0.176513005674671, -0.234463230103880, -0.212621576156504, 
-0.310975724206371, -0.352457208157616, -0.176828199475964, -0.294905292334564, 
-0.221414087789165, -0.223812398342110, -0.391270483471506, -0.342941240604254, 
-0.337259831095278, -0.315711546986342, -0.244039369573319, -0.197902937958597, 
-0.352025045307554, -0.183197835708903, -0.375443297163824, -0.206811302711528, 
-0.256327798237229, -0.274220985648696, -0.234962525388364, -0.213156671057217, 
-0.420223346160982, -0.539081169525985, -0.284053109793427, -0.281659192878916, 
-0.284794837943266, -0.352135048054110, -0.377846085103407, -0.233502859129952, 
-0.343487368024786, -0.489415010640763, -0.362810509692643, -0.429536686694893, 
-0.239489083705226, -0.251467250388816, -0.326124912789531, -0.241957885695511, 
-0.163725854036002, -0.205128044614685, -0.3120735683925, -0.524584881202211, 
-0.219052408538128, -0.285967758677940, -0.281210534819159, -0.176123978774219, 
-0.180007521483422, -0.306396412215894, -0.371537913403217, -0.259303207078267, 
-0.279811954440384, -0.332140214550972, -0.176714520944998, -0.209326969539416, 
-0.230823483977371, -0.153916238428799, -0.163576713575407, -0.254606535930815, 
-0.348789305179051, -0.307808078089128, -0.3775896500974, -0.268608483749749, 
-0.291366617887224, -0.330242515424561, -0.306709999301944, -0.281641093825197, 
-0.393092135286091, -0.236535383850662, -0.329435232408556, -0.248101928717483, 
-0.316099281580262, -0.335853999541981, -0.250115740623332, -0.275488668515974, 
-0.459285831549266, -0.336218119103897, -0.265573913099263, -0.341156211696763, 
-0.279848468283157, -0.283244449168931, -0.263009023419148, -0.200533940447353, 
-0.359758368454747, -0.275748983892985, -0.251584565395527, -0.204754840895216, 
-0.300412800399432, -0.198706061999610, -0.209600376018353, -0.380279369489746, 
-0.384847157191836, -0.220036438336178, -0.193100530363037, -0.240205350356934, 
-0.259976943558912, -0.199639730052628, -0.274594255823951, -0.214684080817347, 
-0.379509027922489, -0.307704631788612, -0.267804486855930, -0.238505962789237, 
-0.302602090419757, -0.319144405248428, -0.314555361628797, -0.177681724748564, 
-0.197113551342479, -0.264175575741798, -0.180158101062836, -0.309737735859066, 
-0.0678225901088516, -0.221783875007500, -0.444641897665364, 
-0.275162193144052, -0.249805104091265, -0.483623560080963, -0.284378156908864, 
-0.200219798784704, -0.279402445048444, -0.254750592910633, -0.209523011834645, 
-0.221004394225608, -0.333357487590449, -0.297349326174608, -0.290372110675826, 
-0.308697027235348, -0.350532547309526, -0.382933483485437, -0.364119025910025, 
-0.369674600417374, -0.357296969209841, -0.269985106225905, -0.339353084749304, 
-0.38560532206108, -0.241755490718717, -0.351270828715328, -0.255971754816309, 
-0.271289913852227, -0.313615602666544, -0.300180323160861, -0.301225591516508, 
-0.159447433749703, -0.284492646009307, -0.276457496496770, -0.098240923631459, 
-0.237331029086796, -0.302912739946092, -0.18213521992873, -0.163078936187696, 
-0.335257160214901, -0.217182311383552, -0.367915498750241, -0.237128096883654, 
-0.291658770263677, -0.090613852705005, -0.279089238519773, -0.265789413258059, 
-0.317874667661958, -0.245880437838304, -0.269357590409976, -0.426672451922416, 
-0.621722168332915, -0.170268601115398, -0.263006531718549, -0.054905505764387, 
-0.232954710721931, -0.3066064688468, -0.383038693284171, -0.361537044396455, 
-0.150033316719882, -0.257582984636066, -0.28789558867865, -0.284016385949953, 
-0.348403758446071, -0.401813671862360, -0.326833823054588, -0.319428304269408, 
-0.240632934152304, -0.330494670818912, -0.403871594234140, -0.310337895106858, 
-0.410982426203366, -0.202779453993914, -0.299341887825673, -0.340762440590829, 
-0.321696170019157, -0.411939641957037, -0.159561022498195, -0.356146226891793, 
-0.139676235984482, -0.155897669090063, -0.193903497648082, -0.127411108862058, 
-0.327424524080409, -0.105423464345596, -0.342388943242017, -0.480756205747631, 
-0.333623987843658, -0.16358136405169, -0.143491986200830, -0.297768746157864, 
-0.249582406167429, -0.328748301568619, -0.347486186281393, -0.302780586072667, 
-0.316789879127780, -0.364821539102636, -0.278169451425808, -0.236756534149419, 
-0.450901548709281, -0.279134008303598, -0.390622716802314, -0.289604873249452, 
-0.171218959347090, -0.217574182132733, -0.195674853239179, -0.343151723620927, 
-0.239481554829736, -0.212909367005637, -0.200557480707716, -0.340037292615949, 
-0.261932645026223, -0.332582577227769, -0.368036691131931, -0.218690558979367, 
-0.412278058191532, -0.229550439072738, -0.273058063878438, -0.343707925365963, 
-0.413923964107834, -0.225272485959888, -0.154480067956112, -0.409530219997448, 
-0.366563593218976, -0.431591797529901, -0.30610577240377, -0.327273235480633, 
-0.273207706797577, -0.186266040971559, -0.341965614575915, -0.304918603283270, 
-0.415013948746107, -0.236394348632942, -0.314142574259278, -0.326578265466842, 
-0.288895179739358, -0.389087242718202, -0.244218521245664, -0.337602708307875, 
-0.172681890719104, -0.26299333468027, -0.101701793851025, -0.310269906292004, 
-0.324447857374807, -0.401114407566555, -0.340220623448553, -0.210973544275298, 
-0.306157946561893, -0.168505839575596, -0.418430991354584, -0.331759443211462, 
-0.234913792769389, -0.339886168771134, -0.188627831876612, -0.210592589332433, 
-0.451118478025148, -0.356494339067848, -0.340884809237981, -0.147902458119105, 
-0.390833985175735, -0.351893802488507, -0.29882964852007, -0.2652724433224, 
-0.203356544641033, -0.300544871513828, -0.436950415722367, -0.12366827397981, 
-0.298947701667486, -0.100158005727064, -0.236928198287972, -0.483464178348997, 
-0.415590247913113, -0.173578588008701, -0.40936372314159, -0.297442973078245, 
-0.237953652889677, -0.39760122322431, -0.429844612134406, -0.183495995418618, 
-0.138321200339987, -0.265426718654931, -0.187371129205694, -0.357193507434403, 
-0.239633771926797, -0.250314374365183, -0.487995011962398, -0.347086591064663, 
-0.19570738205162, -0.187741293438314, -0.286237219238531, -0.222086808090746, 
-0.221355229518469, -0.31579286572377, -0.358670958692573, -0.239522365166569, 
-0.194009922806925, -0.203675819926844, 0.0428181660648757, -0.317709966559821, 
-0.277663742948998, -0.274799478673019, -0.326011824962109, -0.271643032429051, 
-0.288826371185868, -0.143490129894996, -0.413800972735167, -0.304685465728710, 
-0.514498730356559, -0.27731380230869, -0.394673901829814, -0.164650113153515, 
-0.469045017417555, -0.282912738718130, -0.336955556387608, -0.435643376898871, 
-0.304935062178515, -0.521680870386345, -0.246238586184836, -0.430201568167964, 
-0.147079483540003, -0.235869308123798, -0.26942277282142, -0.147345992217913, 
-0.260091750124124, -0.274566121090643, -0.340803373009935, -0.270315732630265, 
-0.418371749058073, -0.188393542914608, -0.318021977046892, -0.395635501047147, 
-0.497766111528084, -0.350258035128146, -0.391925677471163, -0.310098129582823, 
-0.237435854967081, -0.332926430806154, -0.250632050720824, -0.0587266411312904, 
-0.466509640368183, -0.174151418930138, -0.157658023290803, -0.366425030969720, 
-0.384466741411165, -0.111033274059038, -0.230024765833869, -0.23892721274502, 
-0.316837680210616, -0.110724930030348, -0.377673717979302, -0.40828789151223, 
-0.153155767978446, -0.276284787589416, -0.208910724300995, -0.270640895351777, 
-0.300005319844574, -0.452388976214556, -0.280744632707142, -0.424380738161417, 
-0.159392932778450, -0.135444108201088, -0.220958551846059, -0.284405568779265, 
-0.320272407895433, -0.337355964302938, -0.301525384859306, -0.192139277385457, 
-0.375524847316281, -0.298509179499371, -0.278878761421283, -0.233226401335730, 
-0.206224060884836, -0.330562459742156, -0.233477420580774, -0.339703708020752, 
-0.134974609658410, -0.323776428894124, -0.206201938941728, -0.358339726786518, 
-0.211981700378457, -0.209410480190387, -0.222026789672503, -0.250644029425097, 
-0.437992670177427, -0.273395252729485, -0.116292215822704, -0.293842377297441, 
-0.242734789969078, -0.439015387747237, -0.342105052444131, -0.177832137085308, 
-0.204662043210826, -0.335069198077354, -0.354573739512119, -0.168911245334503, 
-0.274271359547364, -0.316929406763391, -0.261208525588610, -0.215964068787236, 
-0.363850692578945, -0.309896842673747, -0.214683889293638, -0.209561122886196, 
-0.342853720932648, -0.341018619325268, -0.197989452908881, -0.276437945382178, 
-0.263979176090477, -0.449925725697136, -0.423021759285198, -0.318873149127962, 
-0.0407248433107173, -0.334960840475312, -0.263897336462557, 
-0.373970368711114, -0.369688190306795, -0.257385746574386, -0.442883310825951, 
-0.381402668568126, -0.047415330965637, -0.292207466412973, -0.187196608932784, 
-0.389984374486994, -0.230243642242333, -0.315715771953548, -0.344891104686722, 
-0.301240841270514, -0.445506698601914, -0.225836408839843, -0.217826037033504, 
-0.364441275842461, -0.135553243496515, -0.483112474757458, -0.443666797868351, 
-0.0977697338599786, -0.474305837772629, -0.387013992065343, 
-0.336738714147975, -0.290219709475121, -0.253688373442055, -0.447460405661155, 
-0.309769367445658, -0.284496960435792, -0.127903836897254, -0.0834487544426693, 
-0.164540764547136, -0.241280925274242, -0.343936266030205, -0.172685707447894, 
-0.522024431817369, -0.088145877344308, -0.305360948608551, -0.254361846820065, 
-0.370541757839111, -0.244336635757782, -0.0723574811733315, 
-0.347929370371182, -0.251668457067334, -0.270983475300915, -0.235376596565492, 
-0.146100700773337, -0.308046045017380, -0.291062264338213, -0.189638067450538, 
-0.170852251731539, -0.289722638211494, -0.35680169957697, -0.213915877991366, 
-0.285408374172969, -0.325986448152297, -0.345588513424437, -0.303720433000656, 
-0.545460337848498, -0.205184344363282, -0.433931064612755, -0.279608599081922, 
-0.309517086843896, -0.288407995262217, -0.418830108654470, -0.288420065931664, 
-0.210284827277087, -0.188882535442603, -0.34606362203604, -0.143043010457070, 
-0.168524891073421, -0.409477653267090, -0.0797094354484934, 
-0.561337248799518, -0.260394700073969, -0.213793792509761, -0.295708763028805, 
-0.269958703418903, -0.17895235084174, -0.334988623047344, -0.407544998325353, 
-0.134956178571068, -0.397959485123459, -0.338785099922655, -0.104120430315197, 
-0.351272362162937, -0.299041465855729, -0.237383425981584, 0.0184886582393854, 
-0.040540556242686, 0.00102669881428919, 0.0400401792107037, 
0.0582555640774323, 0.0691562994549126, 0.13575995180597, 0.195273033636998, 
-0.0589758874758491, -0.0133994655313456, -0.0261557613703463, 
-0.197599876636565, 0.181324511992178, 0.0277422533318305, -0.0366750973865902, 
0.132800036868783, -0.197449233501658, 0.103383259321581, -0.0132383570431259, 
0.0189116388020124, -0.0521401973789142, -0.0127037867693071, 
-0.230923193088721, -0.00127301818445772, 0.0873248767713991, 
-0.220711160668049, -0.0822286489532731, -0.058668362034557, 
-0.0302541442560171, -0.0437068225659411, 0.125337025976363, 
-0.0300829341747183, -0.0437980569350816, 0.134580424017304, 
-0.157148000763630, -0.0719446677403383, -0.0120568361169768, 
0.00544968653288126, -0.0782590953879055, -0.0561060351034422, 
0.131461881789881, 0.0822866396638486, 0.0852744218023468, 0.0909347444683601, 
0.0258889778677013, 0.0226486060362108, -0.109291580785263, 0.183317626591387, 
-0.00348434967406866, 0.0466020804152637, 0.120556273588490, 
0.24320575778132, 0.268941373654965, 0.120614227612786, -0.0227938109122940, 
0.113291564177184, -0.0392906793224779, 0.0162661103187497, 0.176167164923816, 
-0.04307081498873, 0.0428165891822322, -0.120296658883229, -0.0739317719297649, 
0.0810611899171695, 0.072447071137741, 0.0085689439097426, -0.148390420032782, 
0.0241021901831112, -0.0314353544360696, 0.118994642999292, -0.0455753900977606, 
0.0109739182302402, -0.0842796769667879, 0.09046438323005, -0.0251834172866365, 
0.0087260311486705, 0.116035734131187, 0.0536761327120664, 0.0173748240151196, 
-0.0119557784029445, -0.0160243074375692, 0.0858615073525507, 
-0.0832451881037595, 0.0946304206756317, -0.0425902974272528, 
-0.0126988961548589, -0.0265272308862685, 0.0137121617845245, 
0.0202736541556608, -0.0235572836144565, -0.0737312078574648, 
0.196197004245036, 0.0785055744817578, -0.0586178311288492, -0.00159193647561978, 
-0.0206996429995518, -0.0379542615716875, -0.203637632713460, 
0.00285998914681963, -0.0581214990837082, -0.0449722211835818, 
-0.0561831825031948, 0.0560524305139116, -0.013705616817436, 
0.0190557787095402, 0.0799421842924493, -0.0322861807397928, 
-0.0504870543594787, 0.0604820284921584, 0.0863941410092718, 
-0.275406073315901, 0.00535756239920652, -0.163372168890396, 
-0.0149318447022950, -0.0814167383005099, -0.0246052082069137, 
-0.0154708506643551, 0.268719120898015, 0.0375878900694791, -0.0306258041218266, 
0.0168176935611982, 0.070998935112504, 0.00417250707578748, 0.116466492528806, 
-0.101259482536595, -0.123736182870612, -0.152920712688829, 0.272491450566897, 
-0.0217375075978574, -0.0152007450244274, 0.00454145311859327, 
0.0751948614816513, 0.0323425235931500, -0.0221719405622129, 
0.0361380095965147, -0.0505928164156348, 0.0324750501431255, 
0.167788970424368, -0.0603727334384817, 0.00110203369153884, 
-0.0222302396467144, -0.139922335170592, 0.0082949134224768, 
0.0986288897689677, 0.323772802350324, 0.167700292452278, 0.125903627369553, 
-0.115978968190636, 0.0320505153245358, 0.0455499872126041, 0.0138244283522745, 
0.0907097175198468, 0.106735350824632, 0.131038488173383, 0.0214225810148291, 
0.157576430182548, -0.0106798309832297, -0.057591474228819, -0.08886618069268, 
-0.331419976872485, 0.107012178410670, -0.105616438448829, -0.081139952464289, 
-0.000621426249249354, -0.0260145352511477, -0.0163716045848474, 
0.0264137140681438, 0.123828442130536, -0.0723486055996847, 0.0243829850380653, 
-0.211069160178302, 0.0151751738558503, 0.0226990830321300, -0.0652666858859613, 
0.082069240582775, -0.00192639233656344, -0.155367597705002, 
0.196720587551961, 0.0257841619939773, -0.0298009393377581, 0.149361693973152, 
-0.202618103610102, 0.0328744985554901, 0.138555402757206, -0.107849720022121, 
-0.257195895177683, 0.0190422321284543, 0.0878685994375566, 0.307606961660562, 
-0.0177918819677605, 0.0646170893574945, 0.132617274429295, 0.176989638753105, 
0.0379673654855409, -0.0161287005081420, -0.0220760679704712, 
0.225226953743192, -0.0350669639661739, 0.323884411044478, -0.00814330108937597, 
-0.110288744470057, 0.0671391060445587, 0.0243343613547381, 0.0410394584757063, 
0.032855940478484, -0.104538549597674, -0.117739891546685, 0.0264854023326189, 
-0.114245755497691, -0.168922922436771, 0.133868083289368, 0.075694493136611, 
0.083207809654405, -0.0276612214124732, 0.00573876329203843, 
0.238034447221353, -0.0170872654110483, -0.125873740728404, -0.0319600723862517, 
0.0242037744429171, -0.0246509868442555, 0.0116149175436594, 
-0.0138037562081999, -0.000206109222111037, -0.00352022284553576, 
-0.0313768720418733, -0.0372602463684429, -0.00340401344107464, 
0.0908801415113481, -0.0760341663847977, -0.0448121637397608, 
-0.0173836313222006, -0.081659484275157, 0.150020031400842, 0.176017025377719, 
0.115891374970311, -0.00834465855521963, -0.0292637585426828, 
-0.109172370439523, 0.0372869217699718, 0.0136385781050626, -0.0120849497400583, 
-0.0614937460291922, -0.0296029924750283, 0.066915453812014, 
0.0900229654666891, -0.0209496199949076, 0.212879787145661, -0.0274598579773623, 
0.0366911660777341, 0.015994602645623, -0.0180108904972124, -0.171207680973414, 
0.100918745209051, -0.123068377613942, -0.00667902547684294, 
0.0250027521610992, 0.031647995853806, 0.0452682821806378, 0.0662953219453851, 
0.0152260851479992, 0.05417327459245, 0.0893389360271252, -0.065867464943667, 
0.114949313308970, -0.00894838778127079, -0.00122268746449112, 
0.0314171695825060, 0.104643142193106, 0.0791775832260959, 0.0924677834372801, 
0.110467712086309, 0.115009918747367, -0.0252414778083905, -0.00686558022329737, 
-0.0597128682383688, -0.0727864832649958, 0.132033875396492, 
-0.0204805901921725, -0.0203186467211166, 0.00153545798820926, 
-0.0662397698297369, 0.0553193259977544, -0.106472143697057, 
-0.0510509211062469, -0.00175194427766459, 0.139764276935789, 
0.0443219577426392, 0.0604564460344352, 0.0391480279304223, -0.00362005016521407, 
0.041332987317664, -0.122238713981898, 0.168671238395954, -0.0203856319932568, 
-0.0197989927007102, -0.209214357783519, -0.128505896241889, 
-0.0165106186223810, 0.120478221063654, -0.0911039415856385, 
0.148103048451203, 0.081410552373647, -0.0267670813252396, 0.0452066281834121, 
-0.130516751086532, 0.0517685346006174, 0.0418094101198751, -8.32388473898113e-05, 
-0.0783915087281876, 0.103434041580783, -0.204499792204770, -0.160187621583459, 
-0.0352725943523726, -0.0838722278711245, -0.076856678573878, 
0.122577868318068, 0.0198523003722887, -0.0199525814003463, -0.0376623616518317, 
0.0782948073223238, -0.00713634840064198, -0.112631296467066, 
0.0682213720398189, -0.0739061552413112, -0.0942693806617709, 
0.197912666141843, 0.0179729012478751, 0.0259564238851191, -0.0487037798577992, 
0.0749901403473346, -0.115362701096376, -0.163141198140469, -0.182982149995582, 
0.0690219595350735, 0.0538855380976729, -0.0710878812535536, 
0.0459315536987089, 0.089319644980593, 0.0739927588689811, 0.128146479044705, 
-0.0396595722168511, 0.119075016378793, 0.0199547671808425, -0.00369455988647238, 
0.113883752217736, -0.155865292935732, 0.158168827991778, -0.191044594167175, 
0.051715122301599, 0.111077323247623, -0.0140487807785956, 0.0602910919029559, 
0.227284860802060, -0.061441165915385, -0.102920488724871, -0.0509971281785733, 
0.0737534463355531, 0.00727715056224727, 0.189657997636672, 0.0674852027621401, 
-0.0588880262850094, -0.033276387318929, 0.106813793441647, 0.000249762317101216, 
-0.00398999242834389, 0.167600290634612, -0.118366878589809, 
0.0157976356438159, 0.149402302049702, 0.0756670313023969, -0.185558431008242, 
-0.0427156867733763, -0.0501895638918173, 0.0827827665802314, 
0.0968356520662915, 0.20249325845987, 0.0568227712058682, 0.00313549524901012, 
0.0194233188280704, -0.0396752168152946, -0.0159239665864337, 
-0.134185918417970, 0.0128062399271697, 0.135689806658448, -0.124684700055402, 
-0.0276236508878837, 0.179389582066030, -0.0125628855048518, 
0.0327975431067390, 0.0487955292583984, 0.0925045618542762, -0.0834578713469294, 
-0.0507697864202771, -0.0350115109701587, -0.0249260269462534, 
-0.00472775439655541, 0.205138941887099, -0.146062799690628, 
0.082874350208084, -0.0815702616085952, -0.0261752424510635, 
0.00293545192866293, 0.058236107215236, -0.0490543387460876, 
0.0656032877508888, 0.0282927939068042, -0.166382211649957, -0.106355447662117, 
0.0159232587671386, 0.0740792039435978, -0.0106259918977335, 
-0.0456686065199681, -0.0177673447408807, 0.0482555557179825, 
-0.0595432352718387, 0.120579012108778, -0.217594946673641, -0.0250895220374681, 
-0.0162863209936636, -0.171218541995611, -0.0205818997559872, 
-0.0684804667372678, 0.096594571721364, 0.0290185998595786, 0.0292821705091846, 
-0.152781829604581, 0.019565575760771, 0.184444001250013, -0.0308924970589962, 
0.127527708978178, 0.00776906076984899, -0.0882617872584563, 
-0.214019276115378, 0.0314457884066915, -0.0508422523916275, 
0.0410214713379957, 0.0585887612453873, 0.00695040139061564, 
0.0163158111446024, 0.0945077483784644, 0.0957513054595847, -0.0639839116518632, 
-0.0280110512396163, -0.0143798382031748, 0.0388690573398135, 
-0.194768386616650, 0.116344971079896, -0.0467067495116044, 0.152831600877863, 
-0.166165687107775, 0.101868268955706, 0.0865336642332221, 0.00895085239448074, 
0.147204132551874, 0.091244960962868, 0.024527015691649, 0.00948300295796722, 
-0.0167982909282206, 0.125567095782971, 0.0497147411272416, -0.048415859545847, 
0.106010952499027, -0.0761198077147617, 0.156037762198378, 0.0664848941793403, 
0.171723690854938, -0.217351414061141, 0.19988864714474, 0.0787807275097107, 
-0.0286040634965975, -0.196239239205809, -0.0688146100870654, 
-0.0242891546144814, -0.00094706200278754, -0.105277048723957, 
-0.10755547405374, 0.0150114304538334, 0.134663007259086, 0.0130846968576762, 
0.148011364734241, -0.0104827173020412, -0.0755047651462442, 
0.0187070111696594, -0.202913161920183, 0.0473436608523842, -0.0361122181025363, 
0.066884203207558, -0.136982687533345, -0.0755451034024974, 0.0388296964818745, 
0.0780888627024028, -0.00220784686335498, 0.0678406541408938, 
-0.00471637302860053, -0.02078001825938, -0.132940802660934, 
-0.0029936606103507, 0.00572412714003384, -0.0574994333243236, 
-0.130441636236691, 0.0362467705646352, 0.0760928316416005, -0.112848880680380, 
-0.0727868301649966, -0.229984848015037, 0.0531053957050763, 
0.025445262494666, -0.156016260429150, 0.0795109966460592, 0.0931631234645638, 
0.0164890164222839, -0.00891305505822038, 0.0640209967143803, 
0.00314468695062572, -0.254485756117121, 0.00547966645687231, 
0.0110176649753724, 0.040377705086427, 0.0866371812094967, -0.0582040410577094, 
0.142079171534578, -0.0902429704898949, 0.00617916766229038, 
-0.0226523289469352, -0.0222211597099570, 0.19129955947965, -0.115152807190359, 
-0.0508229951138937, -0.094928270352932, 0.196341169611816, -0.0835168369597064, 
0.00627553738452052, -0.117973087700801, 0.121944386998171, -0.0607629694578719, 
-0.193236718973090, -0.160403277896093, 0.0748343623377033, -0.0171731357115121, 
-0.151253230846487, 0.140338073461620, 0.0681848280415691, 0.0214311385703898, 
-0.00234299983326279, -0.0537234002014554, 0.0478203157660876, 
0.064254699184081, -0.170199290926926, 0.179266352863192, 0.00425895664634737, 
-0.198504264144361, 0.00577867919224232, 0.02628583161648, 0.119124277985238, 
0.0375614112375452, 0.00390249800067964, 0.0381959327613042, 
-0.0790213952978964, 0.0583976307634938, -0.0513893412408884, 
-0.0292741887022325, 0.048867171462327, -0.126367377398304, 0.0242775553768510, 
0.0613297084784235, -0.00999984924602684, 0.155192954932606, 
-0.00169744719498369, 0.190750108522843, -0.0567095829144739, 
0.0451169024449565, 0.144858675787347, -0.0600209587888771, -0.103352223590023, 
0.0834842366606701, 0.00945332360097638, -0.0718933046756039, 
0.0167003874374970, 0.106037447669465, 0.147008272987297, 0.0538623205834227, 
0.0939024044953219, 0.0321631503072396, -0.0836045662367604, 
0.156219682384734, -0.0446400764343058, -0.000751270681690741, 
-0.161202261436614, 0.0754104062361911, 0.0859889265955953, 0.0145431298860164, 
-0.0156541446656434, 0.109069112717380, 0.0867582942596838, -0.0877729916117437, 
-0.0496698971438947, -0.177275597800739, 0.0225691635119639, 
-0.0801587333101163, 0.00916503412499945, 0.00516110758571595, 
0.058644647594412, 0.111824142139722, 0.102930289651871, -0.0468227156322750, 
0.0604873945113436, 0.0649620999939848, 0.0635114030693121, 0.115596922791882, 
0.144369701080799, -0.105955846890597, -0.135340993642641, 0.144685915705343, 
0.0664510182568392, 0.197979279687988, 0.0300383410687302, -0.0164787550425014, 
0.180901676816652, -0.0070349241366666, 0.0370889496727893, -0.0379671384978250, 
0.0579346711792516, 0.0563373242177467, 0.0482307246321975, 0.0535106714004457, 
0.0658210494867678, -0.0224535421200545, -0.0700967710322051, 
0.020863289328729, -0.00402656116729547, 0.0503387371715174, 
-0.118318082840886, 0.0233865470740124, -0.175441801008550, -0.0331189027121940, 
-0.125203407173621, 0.121666143230054, -0.0943588521385235, 0.0494979884070783, 
-0.0389287950802507, 0.0368098449972142, 0.0771317468085381, 
0.140508305385637, -0.0701552540133292, 0.0290750131253055, 0.00483455192075504, 
0.0539662785568226, -0.0941506208807406, -0.0482936367342564, 
0.0650181587180641, 0.000527861520470277, 0.0133364223165796, 
-0.0890191500785765, 0.00724362490364811, -0.0845902311697636, 
0.097212446065682, 0.0359958682825492, -0.0383379321579105, -0.0202740616527117, 
-0.0322408011952096, 0.0146167898223763, 0.0325476914075756, 
-0.0255528815809400, 0.0199167390972743, 0.0941911862619734, 
0.122454101034393, -0.00921499243407362, -0.0031292722372395, 
0.127458071154726, -0.0475648062094161, -0.0726381565396502, 
-0.0475041964987536, -0.157935816082168, 0.11903520241699, -0.0509949516870806, 
-0.100417575353836, 0.0787395976146993, -0.09870093003017, 0.0788445824887054, 
0.0953751199004428, -0.115755787537507, -0.109427814522008, -0.0631783283664414, 
-0.166137361470193, 0.0984566597369624, 0.0411731312920002, 0.0265508584708712, 
-0.0688616333839272, -0.0918952972780916, 0.0726480631508125, 
-0.059889189096527, -0.0249231236041279, 0.107012546622862, -0.116361166387585, 
0.00496970585349558, 0.00924302553818469, -0.00932169148574964, 
-0.0619054351441565, 0.0222483082993465, -0.113527502069303, 
0.00317282583381039, 0.0792985895207046, -0.0687449189973776, 
-0.0870794569955016, 0.204614226136860, -0.064328438641318, -0.0851212043201648, 
0.0217666748822956, -0.000176010329382911, 0.135641878259274, 
-0.0491868267192142, -0.0281512340585672, 0.128857028756868, 
0.040921881521777, -0.135829405597265, -0.146022888614956, -0.0152717641230619, 
0.00826465994522782, -0.0319622177440541, 0.207841489103049, 
-0.0888326038605757, -0.0724671262233123, -0.0433753506930948, 
0.0479815880043628, -0.0507066977565109, -0.124858895370966, 
-0.055647043144912, -0.193067302797192, -0.101898239613860, 0.0332446829735967, 
-0.0174877728487712, -0.068173702145411, -0.0177872270064734, 
0.0700205397416789, 0.0506975530007188, 0.169264178147032, -0.0930838097649466, 
-0.063097910833071, 0.0667161039881368, 0.080126256950516, 0.0544434516814549, 
-0.162077880532242, -0.0867579637061337, 0.08395074251928, -0.0952424453638493, 
-0.0228602170953385, 0.133835545867396, -0.067992830003486, 0.0564565320117875, 
-0.081217480398379, -0.0231701492044228, -0.105767896255991, 
-0.101726911354793, -0.00919735223684807, 0.0120308451841111, 
-0.0248413105747755, -0.0193687293257283, 0.123418330778524, 
-0.140709456369499, 0.145996178746945, 0.0613137819276044, 0.0187568930898040, 
0.127775194874518, -0.0515187276572226, 0.086715189483287, 0.0434469347928100, 
-0.101870879253165, -0.0593066116603082, 0.0481383305129351, 
0.146300206413446, -0.062055153362078, 0.0365614695394226, -0.0609471397931386, 
0.0381058483401658, -0.190522572130149, -0.0177449306868157, 
0.195666803215868, 0.0565932415753629, 0.0405173202189401, -0.0322538882456939, 
0.070980805352581, 0.00156792220942367, -0.0534123629972059, 
-0.0443598948466176, -0.125496457325670, 0.0120905566101717, 
0.194639491918322, 0.182501371898244, -0.0607338873082551, -0.0292655935341399, 
0.069574038715454, -0.0211262868593951, 0.0357161229823211, 0.0625615618334449, 
-0.0159054210890939, -0.159787595461680, 0.0854586984691393, 
-0.143748917687251, -0.0545076880432462, 0.117146161903644, 0.0224149876608927, 
-0.0200688325129002, 0.0390929343273778, -0.0219203775555019, 
0.0160788607987430, 0.0324465723177367, 0.00450025811442318, 
0.0696750965027725, 0.121307753198522, 0.121364928960095, 0.0559107188338228, 
-0.0596144393507911, -0.0116039822467107, 0.0651069574404634, 
0.0632455576961829, -0.111965725307999, -0.0411624937828109, 
0.100865288316028, -0.114722199671277, 0.171608793180302, 0.0797497336293447, 
0.0644532866891056, 0.0200833156990262, -0.180039678894644, -0.0425287887852247, 
0.0050032866274334, -0.0857761357524887, 0.165498371905358, 0.0714314644933515, 
0.0320762851746966, -0.0447329656389457, -0.116263807191446, 
-0.172080175598450, -0.00983747882967755, 0.00456623708020824, 
-0.080819727064496, -0.19285528131135, -0.154047908679844, -0.0548460452349308, 
0.0549460471114989, 0.143334847017447, 0.0533188315139199, 0.0474746745098906, 
-0.0378476544917891, 0.147143991257464, 0.0365883862454605, 0.0483703284041472, 
0.0814367891824195, 0.114130934625449, 0.279855524966227, 0.100958732503567, 
-0.0263748568656215, -0.149968889720168, -0.102823066241394, 
0.163505707389615, 0.107230962724149, 0.0400215763672751, -0.165374459255207, 
0.0776694893194849, -0.0919644530509388, -0.111091567916265, 
-0.037112921194556, -0.0362003523962409, -0.0514932437085728, 
0.0735626112054293, 0.00603921805086351, 0.0232976121613629, 
0.0522173805098252, -0.0313492970524849, 0.122641611130330, 0.0629846439380115, 
-0.0459071599340405, 0.0502800436176635, -0.140292620248511, 
-0.0188619964908753, 0.041682579662925, -0.0636691821307991, 
0.043752913514268, 0.0790521830513072, 0.0669730084364051, 0.0266237786221201, 
-0.0818508200252224, -0.0275076893512118, -0.0893682603778456, 
0.0453812706882648, -0.094164208533851, 0.0236791574313594, -0.0227410143754306, 
0.163282628177104, -0.107100468988827, 0.112631741522901, 0.0198759740494438, 
-0.0434772454095588, -0.144196322403956, -0.0417108232415536, 
-0.134098736886354, -0.0289807638394817, 0.0746527545307472, 
-0.0114767972424178, -0.0514015278052878, 0.00981707844021704, 
0.0992519569303563, -0.148008970099151, 0.152695177925460, -0.0344959744181509, 
0.0552816657061188, -0.0405938261926278, -0.0488625713648986, 
-0.0702973977221673, -0.0252057206494262, -0.0420523288106928, 
0.111112837423075, -0.00662350132171234, 0.0342614411389728, 
-0.0136635677345143, -0.086298932067491, -0.0578089657558389, 
-0.133883288313197, -0.0601509138271816, -0.0812196500003506, 
0.275471944503225, -0.0278736350810706, -0.0712390509902608, 
0.0284230394279689, 0.110014408276102, -0.102735887871274, 0.0272963116582217, 
0.0438709056897269, -0.0272351858958068, 0.104052162474032, -0.185763724428996, 
-0.0227006949949365, 0.157387498450993, -0.0760405501122584, 
0.149446376980962, 0.00783474554088931, -0.002048547093493, 0.0667366464368408, 
-0.0353054213895206, 0.0272491991055422, 0.24418900983311, 0.0637172253216528, 
-0.0742623638207463, -0.148569368366174, 0.0424189691221345, 
-0.046947132115974, 0.0766812617412853, 0.142400741874561, 0.00847363598269676, 
0.105432803030021, 0.0279344320700872, 0.0190322694765262, 0.0464606392343066, 
-0.137512938590710, -0.0390918378606607, -0.176784241231995, 
0.0612098570098271, -0.0237731661492007, 0.0475766651632390, 
-0.0811538274043826, -0.0342840582110029, -0.0477777554959422, 
0.024033258286636, 0.111618085315442, -0.0961409812749213, 0.0972122491198695, 
0.0185780585679862, -0.0116378397494510, -0.129134267331830, 
-0.0701029283966348, 0.0306355376839501, 0.0172481023246121, 
0.0332168432802932, 0.0998754759245793, -0.00522702236697736, 
-0.335449132631442, -0.0439634052924812, 0.0756306019505492, 
-0.000575201758995234, 0.0146500052349075, 0.172955346314109, 
0.0808937569590805, 0.094089602594393, 0.0442355373703767, 0.0671491566941676, 
-0.0432904833633017, -0.0910410243788071, 0.0224846570846815, 
-0.048859613546003, -0.0372757124978269, -0.110667238820036, 
-0.0267631190543803, -0.0524646048077226, 0.0289819955693633, 
0.0276123997622747, 0.00956140736210488, -0.0640404438225145, 
0.0917066295229771, -0.0868859011257268, 0.238462832476847, 0.379380098021843, 
0.281768582559972, 0.466714925334884, 0.149463504711791, 0.234200618733185, 
0.308560962234847, 0.306277485959136, 0.323437853506053, 0.382087543616487, 
0.190170131894459, 0.281214743329232, 0.418244879268831, 0.293671675650248, 
0.363845204336922, 0.331181991920670, 0.255515878654942, 0.336270870037659, 
0.355315741478624, 0.285797177139006, 0.445326696215148, 0.499133701544371, 
0.178617205682434, 0.301306631064358, 0.295747771689688, 0.51838721095222, 
0.252193967462606, 0.216768317423860, 0.367969221492117, 0.37447237134698, 
0.379748302768328, 0.0408953470510203, 0.317512570979519, 0.36929786384628, 
0.238179870247398, 0.29648738871631, 0.311563843162769, 0.328360969866135, 
0.281314889560936, 0.258760716760196, 0.168815973787095, 0.351113915393052, 
0.197693043480720, 0.362027786225557, 0.376537456215798, 0.333418155616415, 
0.163383797503220, 0.403426451933767, 0.169880899261369, 0.511065675052795, 
0.31106124956627, 0.236243373596483, 0.316971796412020, 0.289692504749207, 
0.456660271676338, 0.188874484268194, 0.287123306281076, 0.308714749572130, 
0.319365986988698, 0.214221537247844, 0.279581089504848, 0.279451767036566, 
0.358731491091956, 0.302146552320743, 0.301220921855286, 0.287362693105144, 
0.325674262745783, 0.398793654596536, 0.221286290941233, 0.306593648374825, 
0.372447881749669, 0.271404320897052, 0.308981771623552, 0.327755351693399, 
0.373836152405425, 0.259399395310700, 0.213107858648538, 0.203441572939139, 
0.594982962669897, 0.445801619838889, 0.243335084788072, 0.280893501074951, 
0.279291931983450, 0.281937791789139, 0.29858437835615, 0.321191864979435, 
0.260851242758822, 0.194368470550504, 0.220911387337647, 0.188824307973894, 
0.228098298965889, 0.249303738915232, 0.46722767064237, 0.30497538762975, 
0.27453612501645, 0.208451525563977, 0.392525675103153, 0.248712548805734, 
0.356813554226157, 0.245160064111244, 0.260594278653127, 0.206960352502497, 
0.216026407071025, 0.337216147227678, 0.233591259515116, 0.209518483139168, 
0.316012246421823, 0.307615436225579, 0.243442134231505, 0.195685353831510, 
0.337819086980966, 0.288001076266020, 0.278303418610267, 0.31104863309979, 
0.343496285614774, 0.296405666225016, 0.285918873082799, 0.311280793496413, 
0.42197019139522, 0.240360419253258, 0.207235090935027, 0.204649345399404, 
0.196014345873606, 0.435416773108723, 0.223956212233299, 0.079136807951092, 
0.246298850392214, 0.364569065945001, 0.209487002628305, 0.239343176592611, 
0.477012047883391, 0.136460442718482, 0.274682878231187, 0.347176339806852, 
0.174749913352007, 0.234861076975609, 0.293708473961116, 0.274292482967576, 
0.321220358701604, 0.327098720509329, 0.38253167335705, 0.342148566883636, 
0.279483040555814, 0.369507875608462, 0.373939940457641, 0.320746462838228, 
0.271210773481559, 0.487067229478769, 0.401796307354504, 0.223580056128657, 
0.359986399570266, 0.260160349191162, 0.262180523086907, 0.227703552195545, 
0.167975367592138, 0.440505384452557, 0.273609496044368, 0.320477862479607, 
0.263218465054785, 0.325211244983864, 0.112167182089773, 0.165692827843824, 
0.225434999418264, 0.203918770117819, 0.279582490070568, 0.353063046268537, 
0.226100863633963, 0.273745286457195, 0.24012513549353, 0.230599376025651, 
0.325153522350913, 0.241678682315550, 0.218921158552213, 0.272620298300167, 
0.296343990720639, 0.178648046271176, 0.231818731973305, 0.335186919656199, 
0.204414969267082, 0.304511782572636, 0.27885611709518, 0.368537950045045, 
0.267730789516670, 0.565344651221701, 0.579648353601266, 0.431549754025364, 
0.391888676932978, 0.313411900033153, 0.368050243538816, 0.272667881753203, 
0.244523369353863, 0.464800680651204, 0.256970881992345, 0.259042067385232, 
0.331939538116625, 0.0543796089270987, 0.329091286615449, 0.0419723638835544, 
0.275642742235359, 0.352174195795344, 0.50138140674717, 0.280929029688408, 
0.379393650600282, 0.339848347455418, 0.247756468869519, 0.275849686955299, 
0.347431404384861, 0.321786499936995, 0.284787504686542, 0.187030702867814, 
0.432237795591349, 0.150148588193868, 0.323911801535831, 0.329700474407929, 
0.227571689490375, 0.289777805527176, 0.308020289427993, 0.270735652376402, 
0.414203822390444, 0.495222044021481, 0.440798432830481, 0.443513823025026, 
0.373627646934828, 0.355451114813066, 0.449882129147626, 0.28062218944739, 
0.140706123516796, 0.283395317469489, 0.231517831290406, 0.435932639226353, 
0.335297623688091, 0.369192416587103, 0.288388517041935, 0.228118449691780, 
0.345021435673949, 0.281503600775262, 0.115240404403375, 0.242772276258802, 
0.334973575424482, 0.131557237269807, 0.316374673318792, 0.431126498087593, 
0.381275010481696, 0.240627193653525, 0.253977980832812, 0.191799123591428, 
0.456446001365478, 0.371345311539559, 0.379963264141126, 0.488183056240799, 
0.527859115652957, 0.265165588333933, 0.445166195281966, 0.353367911888258, 
0.205501963635835, 0.269701541799482, 0.352173476820126, 0.0918760667207755, 
0.326797288677522, 0.292994738599543, 0.392995984371152, 0.187509281895494, 
0.288326647856284, 0.435041784796195, 0.411428979599134, 0.280063840376897, 
0.495554131767821, 0.00284451037473533, 0.395172795091423, 0.279487234684508, 
0.246883077415702, 0.256899309692981, 0.372683081362397, 0.367469335511752, 
0.413309740370162, 0.297991647420491, 0.23961088396635, 0.380751900964997, 
0.242179126109253, 0.482761831699607, 0.0317113502942811, 0.267017193896780, 
0.279434947511538, 0.308423524994226, 0.222222612313802, 0.189411915046062, 
0.282930996726289, 0.221258887033106, 0.416745657323398, 0.138216101168599, 
0.260958071443016, 0.377388217602979, 0.445263997469046, 0.281354037564335, 
0.378955552826276, 0.351376598000722, 0.272093040041763, 0.267446575278135, 
0.276643455607647, 0.165226987467685, 0.219033787271102, 0.223872192776208, 
0.176001542240291, 0.105447648978950, 0.458096344973984, 0.470561323815843, 
0.285342465458807, 0.203519834558765, 0.267062269507916, 0.21095542051363, 
0.34853429546612, 0.349344265923005, 0.330339242162550, 0.262745710124426, 
0.311085193903060, 0.184659820832440, 0.223918828423582, 0.389830699556651, 
0.360141279348337, 0.228940224989897, 0.196272972307567, 0.421395818389632, 
0.32777867973207, 0.272820827292949, 0.374721119482409, 0.343956093722442, 
0.305630268487214, 0.31376549455502, 0.276838876522767, 0.133129489571088, 
0.498938017073249, 0.28010171722448, 0.12718466254957, -0.0237959134687526, 
0.194053852581776, 0.222565963430864, 0.0875042599754836, 0.375052497060238, 
0.366120948336312, 0.304533425585341, 0.435524302342725, 0.345223062548731, 
0.255011183460594, 0.232107458496164, 0.376089075457924, 0.222580202947296, 
0.471013788964398, 0.274809933685848, 0.372415966085078, 0.3224520113524, 
0.35348041560019, 0.360158117027668, 0.352139700046585, 0.365513590355135, 
0.285352491173703, 0.265994253698678, 0.407242511832565, 0.301374189553862, 
0.335131580304833, 0.357041254468919, 0.308454733516731, 0.206950484606657, 
0.434225148845602, 0.346412118974057, 0.481350399915461, 0.344547289009241, 
0.296927552949365, 0.345058279538253, 0.291906298118016, 0.358792011136009, 
0.251098320509064, 0.414779624254645, 0.452981578701664, 0.385201765645219, 
0.221114793960916, 0.315692592892159, 0.287316042453573, 0.169196534723750, 
0.390240041604456, 0.249648994046096, 0.231565676989941, 0.293449421858472, 
0.423042344347606, 0.269077813213391, 0.249674021023985, 0.312498646957657, 
0.374311226144192, 0.480338443149279, 0.374449881428062, 0.316096924428223, 
0.160819586541947, 0.321080433389396, 0.301204878919647, 0.383868590072871, 
0.316687552441071, 0.349879560014137, 0.325458593416525, 0.313092322226847, 
0.265210817251762, 0.243492510608638, 0.422542292411224, 0.276438305912402, 
0.414598566581673, 0.389009169625192, 0.342684751665145, 0.210360131179649, 
0.337531075264155, 0.432249471501831, 0.275885019036312, 0.478278864918395, 
0.228235381929618, 0.382985001775635, 0.264998637000401, 0.331114484708465, 
0.237047304747128, 0.313776729045873, 0.301241067970306, 0.177891397718108, 
0.284179137658435, 0.241069034844803, 0.281562194080984, 0.326009964639551, 
0.483369800531309, 0.243922143956323, 0.215116010184221, 0.362013146497555, 
0.288043418447628, 0.348853511909423, 0.140887516739971, 0.3155562787477, 
0.395732784455783, 0.400815649799411, 0.437073107562585, 0.319278996563934, 
0.249378719640270, 0.197245114495134, 0.243501324483416, 0.339224220802332, 
0.393318112764101, 0.308073157640732, 0.372052281242042, 0.423683931251466, 
0.362974336237788, 0.391043809636419, 0.418871720139962, 0.326669367238764, 
0.00325883675959805, 0.242965223888343, 0.176597179213707, 0.408547625487753, 
0.24621022603935, 0.186189735574804, 0.176535311209878, 0.288726885770526, 
0.234988529378076, 0.292338510835725, 0.248221809137878, 0.386608888887955, 
0.386508929063599, 0.196685992006029, 0.190273756276861, 0.38751293565033, 
0.283839198163545, 0.342652436451871, 0.30853662436351, 0.300094234749792, 
0.410968975398073, 0.174292058664930, 0.247143819887338, 0.190878507184228, 
0.313886071618931, 0.189811063887099, 0.207914038187567, 0.283587437507120, 
0.190557740108536, 0.387538394638845, 0.397042268984619, 0.376928217973835, 
0.399805279770881, 0.399364187176024, 0.335748654063019, 0.354451668785664, 
0.376819292662709, 0.325100754247405, 0.339551183416849, 0.184662382560016, 
0.143822397973317, 0.240152736448066, 0.270284003892908, 0.374125497167873, 
0.120099446415614, 0.192136213335180, 0.270688801624355, 0.333560058785007, 
0.274116193153894, 0.250695593904545, 0.186860812613109, 0.258381353617176, 
0.326436823854068, 0.448048952945474, 0.367805634884701, 0.236142609130569, 
0.296044622522833, 0.362956505795725, 0.253438161744170, 0.213067181327640, 
0.313158420083203, 0.364085904869172, 0.240450503974725, 0.189507819093801, 
0.365530346706815, 0.338063009003964, 0.336071452536147, 0.291459506139247, 
0.205216668899046, 0.247104264447425, 0.164470190069344, 0.21434096863101, 
0.271043656023124, 0.388028686379212, 0.252800141289917, 0.456182703093988, 
0.384543923065312, 0.253900587926055, 0.183753906815051, 0.303854425750860, 
0.219014943808325, 0.455685303149393, 0.240594357817259, 0.304437148746414, 
0.264114069470970, 0.148402250712989, 0.327937083286026, 0.288515734686725, 
0.126292999287355, 0.179833573558278, 0.157693955952215, 0.372228856783103, 
0.396817390377054, 0.389516511100033, 0.273882623040506, 0.463944501356980, 
0.281273559504935, 0.370886215165323, 0.342463828119788, 0.264583966280847, 
0.253512913698592, 0.377784433024825, 0.266568585320532, 0.372732686413899, 
0.378406685513749, 0.278258712808607, 0.296324772029655, 0.316561098872129, 
0.181603543967039, 0.190070794227233, 0.280606689557807, 0.157116651341271, 
0.470540387428095, 0.270093288465753, 0.292682272346312, 0.389647449507309, 
0.245047786289462, 0.496129234507904, 0.370612005708072, 0.423488736461002, 
0.427348559222904, 0.270421633998093, 0.293661557501154, 0.306966904798979, 
0.406718508267724, 0.265286812227663, 0.320367627317342, 0.402003258588003, 
0.300777987051637, 0.276380295427784, 0.239011007138764, 0.292207742029303, 
0.417089636884239, 0.272604598331525, 0.344054433461825, 0.238217294482249, 
0.386001438230229, 0.198667396496781, 0.199333222787497, 0.39416933810157, 
0.391978249761949, 0.263301577187044, 0.237740088915738, 0.277832050810526, 
0.294143804616220, 0.234925159227368, 0.287780914523523, 0.244613032926663, 
0.232778710454077, 0.129492346240460, 0.246969078621474, 0.227361804953685, 
0.285190950037132, 0.323215195950618, 0.433679679886525, 0.257134542763472, 
0.293023333763064, 0.324054103176763, 0.428613825271138, 0.315440504768884, 
0.44494606906786, 0.278665387715623, 0.241892191168477, 0.0956795397813773, 
0.300468401764947, 0.308415891183756, 0.268490977404901, 0.398837579571614, 
0.283480464975654, 0.216335196244276, 0.251384230189473, 0.303017600415363, 
0.259220467464913, 0.272558063313604, 0.221808663960347, 0.364315751389055, 
0.461451944000804, 0.244811922304556, 0.397627425211789, 0.223515677170439, 
0.573292282176664, 0.252948290950386, 0.310073819982565, 0.452173604007829, 
0.0860339946061392, 0.280845170431631, 0.284533363681779, 0.329905649011731, 
0.332323282238139, 0.352513767983741, 0.221876158967875, 0.410095157106422, 
0.31112330925707, 0.27803784069737, 0.281067800496471, 0.314066595661205, 
0.356066669049746, 0.409307005997899, 0.189898549262344, 0.282695277195066, 
0.318097147081586, 0.380345922409128, 0.379398629305418, 0.330875686651801, 
0.320645146468964, 0.283841566999485, 0.378310324263167, 0.246178432429005, 
0.42482719913605, 0.343113631947670, 0.248460549176070, 0.289670793625384, 
0.193851958637086, 0.430666222314123, 0.327113112356344, 0.443507705715484, 
0.294392489499136, 0.44366652145936, 0.281792037971179, 0.193044937418336, 
0.256508535243828, 0.316337115968433, 0.261430299165640, 0.294425110066994, 
0.50859243162003, 0.3874121862643, 0.414244166252704, 0.415011836021617, 
0.235558349969549, 0.287516469310579, 0.192514052070101, 0.295785639321579, 
0.282926829097319, 0.313935044517655, 0.273195597952992, 0.438609533569729, 
0.186176187848225, 0.272203676216657, 0.218796059073894, 0.289962819490831, 
0.132018872142369, 0.153773419659025, 0.285509300307287, 0.301408718885617, 
0.167392686232026, 0.209613206207342, 0.354585074518708, 0.433783754277685, 
0.269322302804673, 0.325532161376140, 0.356156634535786, 0.339740153496334, 
0.478251535650348, 0.213323751167134, 0.363945261017057, 0.337679244163547, 
0.185029835067159, 0.270836130214935, 0.331820913544343, 0.449150853651689, 
0.38240795054009, 0.402988933137230, 0.275986411264949, 0.263537204352645, 
0.234092373941191, 0.357850695720506, 0.407677477893575, 0.209459042630888, 
0.182459091342364, 0.282469746813166, 0.243207582907600, 0.258068007965924, 
0.193804582376260, 0.379353868243927, 0.338578611610950, 0.36062243852432, 
0.290632915238088, 0.337649940925065, 0.173209900550485, 0.0817749346424572, 
0.38915374165892, 0.374034593117846, 0.260987645326919, 0.439866769160186, 
0.212722236750925, 0.412623913832649, 0.252932234620333, 0.218004407976183, 
0.296599100074426, 0.395178378010789, 0.273502080887753, 0.210899200934730, 
0.314842518302186, 0.202756199700653, 0.319656820464434, 0.141147454817745, 
0.149614098377708, 0.462272804595893, 0.177072250752918, 0.554109654649971, 
0.235857621246333, 0.324947726797058, 0.225415031751644, 0.216251152041582, 
0.520899597515898, 0.254647998232891, 0.297685760283216, 0.263784296158177, 
0.226887091443713, 0.315416895915306, 0.271343972031310, 0.213115995099655, 
0.365504217802620, 0.282014095766976, 0.223433727680515, 0.367189830129236, 
0.37982285955008, 0.221690436479883, 0.175621868602620, 0.229110955365234, 
0.310974647428534, 0.286241262004743, 0.438768753509394, 0.337131439423919, 
0.516039896932003, 0.0847526468121236, 0.282055141414891, 0.236765979569198, 
0.205717774134114, 0.249883147269389, 0.364438340323767, 0.278131327424292, 
0.477461374188740, 0.305529925597791, 0.397037293195195, 0.338315110471060, 
0.396402827460165, 0.273239033314708, 0.302988612181024, 0.158719720246816, 
0.255036784102598, 0.347609637295466, 0.312067021156325, 0.53452473131724, 
0.252803222947064, 0.216632132912815, 0.418664295241200, 0.139005235281901, 
0.60233754196305, 0.417303282427967, 0.326780961193811, 0.201606107497473, 
0.271991148095556, 0.395773867416531, 0.119349308183216, 0.279840525121848, 
0.174482778375371, 0.403680331698536, 0.172360863595171, 0.353965323567753, 
0.338735949104654, 0.336076610198242, 0.356527427855942, 0.308867745210644, 
0.336989441226411, 0.206431808441607, 0.289767403545155, 0.387767613032884, 
0.179298786960691, 0.298665758827919, 0.356123379839465, 0.377567129956492, 
0.364518165405706, 0.139498977978797, 0.279746803871269, 0.389629725258273, 
0.374918786805478, 0.196968748090336, 0.378815203450529, 0.354223070184722, 
0.0752096605124568, 0.373159989050389, 0.341268700529002, 0.416514660422223, 
0.333577464991267, 0.271580181799793, 0.434778537000341, 0.327598612214115, 
0.309692429945023, 0.326605943798018, 0.341151813119466, 0.254767951806885, 
0.105437543064095, 0.513165334931681, 0.326064751324158, 0.387745221179094, 
0.337999728738536, 0.392220512498902, 0.381298311042119, 0.144192966469998, 
0.361377366900587, 0.426102094830625, 0.331411518559774, 0.309024821458306, 
0.349888779710016, 0.268563966145092, 0.36373852452048, 0.0929901641998691, 
0.319648869341217, 0.165108079450690, 0.267632899191503, 0.386924609502451, 
0.397813813036434, 0.245524573814489, 0.393619638694470, 0.308899807110012, 
0.380418190741014, 0.298345443005431, 0.2786449234806, 0.379643449521795, 
0.215968187587085, 0.231459807618663, 0.27287916160791, 0.267003924806458, 
0.288214530601621, 0.319822968146396, 0.272356766215393, 0.217767019128056, 
0.341311007943180, 0.276512167954277, 0.305013313686002, 0.135203708473457, 
0.268458593817411, 0.212169121240242, 0.246823565371914, 0.196442334300526, 
0.279427886741931, 0.286204822087724, 0.448125906370511, 0.301557107228816, 
0.393810229389220, 0.0199895250090078, 0.3350325856436, 0.302190517308928, 
0.263226837971794, 0.230872573411548, 0.160557500331591, 0.394555443812513, 
0.263172112884393, 0.213319744317606, 0.243797102252389, 0.510337945137145, 
0.23744861104501, 0.389099765102191, 0.292241798318203, 0.371215548589343, 
0.301525955889235, 0.225217221089219, 0.357395702628227, 0.36571588163771, 
0.3004007501332, 0.286953513893729, 0.415745063534197, 0.417724537759392, 
0.303829376925814, 0.471199686769124, 0.200037188833258, 0.327291685324928, 
0.293687680543557, 0.285758385674755, 0.324283650260438, 0.380355882780703, 
0.397481860325906, 0.176520308711731, 0.451307005136828, 0.244251856560426, 
0.301809988600825, 0.320560872285447, 0.267134057251059, 0.415898373290247, 
0.286535358415175, 0.455152599058517, 0.42679414906994, 0.390994018736555, 
0.338209670523987, 0.371917136254733, 0.371292429570881, 0.224069664737543, 
0.191596658829988, 0.432595429131131, 0.311067448280207, 0.205079229039871, 
0.31112404543446, 0.377590934255341, 0.439024104587866, 0.183204631802051, 
0.262126132268393, 0.336308965506642, 0.315907212597558, 0.451572964618328, 
0.300315627575012, 0.447833207877906, 0.427310696062467, 0.295796343327417, 
0.289634929202634, 0.203013415191572, 0.341747605435065, 0.362597208040640, 
0.36273215341416, 0.372272187110015, 0.339498924637233, 0.247328766152537, 
0.244040312805412, 0.204030072835463, 0.249988648746162, 0.364923425114672, 
0.254005524568805, 0.404552778630262, 0.280371291786498, 0.337068193849500, 
0.090016416987439, 0.213395968895638, 0.340402786463672, 0.305935740855063, 
0.329570148822758, 0.356031199700021, 0.124937446542103, 0.425537232516622, 
0.268701586487124, 0.424612132489619, 0.220788711001921, 0.262632230130394, 
0.280767375250282, 0.344172281983723, 0.308040447622594, 0.267515204784048, 
0.452643132329997, 0.335557394892898, 0.378547569398058, 0.135856844637892, 
0.324298914656653, 0.195810379881281, 0.206445945916347, 0.317149932105562, 
0.367933867119325, 0.291662814002542, 0.384675032242618, 0.256298683393202, 
0.298829832733193, 0.359534402821542, 0.425870445130754, 0.210416108559828, 
0.581990475551143, 0.137233950045344, 0.535273975998222, 0.685326217004716, 
0.655576645090559, 0.59417424215944, 0.560768804561701, 0.511217354215446, 
0.536310673012915, 0.505730022171361, 0.637358839942153, 0.560939218049262, 
0.562845879715207, 0.513589389563482, 0.555579789546023, 0.608812841114737, 
0.607433037220888, 0.595077200005055, 0.632280613908486, 0.649817585269606, 
0.608781016479189, 0.599074939058189, 0.630961955435467, 0.516767074522207, 
0.459274131501217, 0.556258000671318, 0.564701004871853, 0.558635915565092, 
0.756029806234416, 0.710610783275298, 0.527597619142548, 0.689559091936037, 
0.650913034099474, 0.636578091525903, 0.656604384617098, 0.599488111578725, 
0.639568600145382, 0.553366530549597, 0.814190540055685, 0.6028724245519, 
0.589976270218032, 0.572805037819789, 0.545301575696918, 0.638885344453945, 
0.591862935192609, 0.507238275289189, 0.604645848644423, 0.570562335199597, 
0.68710414306217, 0.634550349694371, 0.701321694981946, 0.499152232499354, 
0.606659373372978, 0.541190307569121, 0.547997096046744, 0.651566926940302, 
0.67037327557279, 0.592110412713252, 0.399241546398588, 0.540915866963088, 
0.562265000369127, 0.474641249499891, 0.604117674076679, 0.460877052525693, 
0.640965875659125, 0.530527820470046, 0.535131780246411, 0.688059743623115, 
0.633262382775387, 0.591970214559217, 0.614940182673448, 0.524441724859905, 
0.613608122739472, 0.570865962771767, 0.584169807074049, 0.630594761517859, 
0.53884166207543, 0.587379665087654, 0.510642066397389, 0.493737376811086, 
0.598712791862981, 0.534750203113786, 0.501263584594201, 0.556951436885928, 
0.421649499108029, 0.544727612544047, 0.629343614945322, 0.492681587682051, 
0.499794642544889, 0.698987471483144, 0.543700468606677, 0.494519561234692, 
0.658425150080215, 0.558909725897542, 0.677643218309241, 0.593457709783681, 
0.648987628983372, 0.678007946019219, 0.635548885557585, 0.563749099447694, 
0.569087014272451, 0.577867905777967, 0.67587131753715, 0.397866506574368, 
0.59971583187771, 0.621350562422746, 0.618875452685713, 0.577214992592973, 
0.52343247112041, 0.615518586946506, 0.563464649885561, 0.723682466229112, 
0.527714980824223, 0.63972769880531, 0.627477383336035, 0.647204305467335, 
0.596094572025729, 0.588002045786539, 0.568713431713121, 0.613741825872194, 
0.604601884726364, 0.702021448178532, 0.648722327817018, 0.557836078963897, 
0.559718770457476, 0.573458526226682, 0.554032487204233, 0.529154757602743, 
0.564470016071057, 0.651606539014667, 0.568967702145262, 0.530823242528950, 
0.657344063126226, 0.563351577293112, 0.567653086631664, 0.538090301600132, 
0.557636178172904, 0.784711576688502, 0.597590812343864, 0.629903176188623, 
0.656474302367481, 0.626725372265676, 0.527487143932535, 0.613783095539266, 
0.614119480472102, 0.486424769472254, 0.586737569398511, 0.517785191052093, 
0.671944269860597, 0.679433210299562, 0.69324258657142, 0.551007906031375, 
0.558505360528437, 0.471484982989906, 0.493158916191425, 0.671920894313502, 
0.676200650246136, 0.60590630902036, 0.66705084835379, 0.612998274904274, 
0.663225869118908, 0.59640700113632, 0.683887114517075, 0.498749900972259, 
0.57267639373277, 0.652180908129636, 0.481724003810517, 0.563324086626197, 
0.436007355514673, 0.660208539549111, 0.599080351365829, 0.528990985628679, 
0.581374223870922, 0.4724594221839, 0.635349324043695, 0.398747358107638, 
0.659330531257351, 0.643300917228067, 0.599334199051259, 0.49237689879083, 
0.48524249242461, 0.561429251573293, 0.571629553691845, 0.572950979974418, 
0.555055914285287, 0.653965494284657, 0.433338991003244, 0.578690550144855, 
0.611022567630047, 0.704746084403373, 0.638160278600776, 0.652507603642225, 
0.681808395053505, 0.598122734936254, 0.602534247730853, 0.519546633445257, 
0.547640886605878, 0.767073253456735, 0.535497563996464, 0.511654844749307, 
0.718706558640124, 0.519981407212113, 0.588940483099147, 0.627109182571663, 
0.509410557047391, 0.675875738060067, 0.63445852030119, 0.698715291519407, 
0.659140161240468, 0.572305793074846, 0.562861144152527, 0.718333120085872, 
0.541734192947628, 0.620248311412211, 0.600767065623157, 0.575056473624858, 
0.585280573544804, 0.599076757338845, 0.577596790153659, 0.666471406966194, 
0.546732916099162, 0.72030818123907, 0.604429531988735, 0.560295018716714, 
0.552412735537015, 0.614866248192581, 0.467857414968890, 0.562374643177905, 
0.618307492192997, 0.670200995729922, 0.495883440226779, 0.535342843284633, 
0.65679965374279, 0.62490735071349, 0.528742151932398, 0.693925981303444, 
0.784403996998668, 0.467230986533076, 0.566493820809927, 0.557465879875614, 
0.578690793004022, 0.678416639769444, 0.59961325246758, 0.598103292512908, 
0.654266776478869, 0.580357889931423, 0.515326065302768, 0.565990957372164, 
0.52147194391731, 0.567721351061809, 0.575684812553887, 0.593574674180648, 
0.585492833342438, 0.510689305813207, 0.504747442447997, 0.533726746141948, 
0.632079342369624, 0.571793644525262, 0.662460657353206, 0.515142437196802, 
0.553787564901652, 0.6656299413796, 0.51657215510407, 0.508671833639607, 
0.482391460286084, 0.635683514048111, 0.675685693619914, 0.663290009265534, 
0.660211401305067, 0.637667418629708, 0.60943596372627, 0.724739005856371, 
0.604291151570702, 0.535524895627004, 0.562923246438362, 0.615149873203549, 
0.584054493260968, 0.593104151905127, 0.67302408852701, 0.44164390452415, 
0.64726904999542, 0.564892769174624, 0.674163797318993, 0.596362580294256, 
0.577118105017776, 0.57807463870339, 0.573342599438294, 0.528299480722201, 
0.649966028855265, 0.600692507286303, 0.562279056402561, 0.667188411923634, 
0.753714854254465, 0.656288453088104, 0.604875062368367, 0.494597680883526, 
0.507319605223501, 0.576939428193923, 0.678591614466615, 0.550616978324605, 
0.58733894610835, 0.697274599931259, 0.509073101096324, 0.499677419952158, 
0.67592150339419, 0.604753037409616, 0.529743118411741, 0.562744016074865, 
0.536050356784, 0.608374727063229, 0.678684592692837, 0.510776817198888, 
0.571038192407594, 0.689031997171587, 0.72873915083612, 0.679778363527206, 
0.625651727235778, 0.596480195223194, 0.642171088669421, 0.603114506638452, 
0.532853103195474, 0.519539813803806, 0.648686886042931, 0.534596483681136, 
0.716005824483569, 0.645225964978186, 0.670300257678272, 0.550202987128687, 
0.605006735500235, 0.589330512372233, 0.62371008561918, 0.636059139879495, 
0.594265402243227, 0.599093488907866, 0.619500784079867, 0.681580551268064, 
0.386899202907572, 0.612108077015699, 0.575373315455142, 0.517790907498188, 
0.567197577021492, 0.642798217279244, 0.547401990635632, 0.635155932754336, 
0.715446132504028, 0.601242363126964, 0.591413301821294, 0.644076795040849, 
0.511929279476414, 0.48719142972862, 0.565652381896886, 0.628229504442603, 
0.63236034311059, 0.635404591655916, 0.402892385090165, 0.621161956501248, 
0.605704652002076, 0.666599231188624, 0.678331433880553, 0.782866332411606, 
0.584251692496099, 0.640695662657135, 0.414441766472139, 0.619332608467862, 
0.548217963752092, 0.493608719241161, 0.534954311116144, 0.754597830242541, 
0.557078187884841, 0.663991238861686, 0.574729666853914, 0.541685769817677, 
0.55095430910351, 0.697932513994859, 0.602901952411634, 0.555922432842853, 
0.625396171404363, 0.572671522080919, 0.563863017760252, 0.692177507583517, 
0.675447991005372, 0.590022364374373, 0.54553175068815, 0.681924251716822, 
0.639192706144421, 0.598746512549312, 0.724205042842098, 0.613735663644464, 
0.557637026273072, 0.597556501367287, 0.679072917084644, 0.471465010285506, 
0.445425707880605, 0.63038702733507, 0.65948004701759, 0.572482652222315, 
0.520991711175504, 0.640995188992749, 0.546122091505459, 0.63432866067961, 
0.70539346886841, 0.694232605994478, 0.582694157782528, 0.74260650366456, 
0.603246123062715, 0.672750451116502, 0.582627519171146, 0.534468465897576, 
0.607534528995029, 0.681602940692251, 0.668834287920997, 0.578394142400282, 
0.51065750882744, 0.654458964935964, 0.505236614842521, 0.572250155034307, 
0.564933835537712, 0.672182010579497, 0.678377434251853, 0.462114371574126, 
0.727013035042587, 0.609713174945406, 0.553919754631861, 0.680176582709133, 
0.684994027316616, 0.634283051050763, 0.572286100748097, 0.496201093584299, 
0.573405892656406, 0.554492052860259, 0.863194582038267, 0.527890027447095, 
0.638035533780514, 0.59629995445517, 0.627455644936035, 0.499182431637016, 
0.458804350423605, 0.483041100017358, 0.5230743139639, 0.651869962189925, 
0.552889651686194, 0.545521172830803, 0.532924246557826, 0.683709183498646, 
0.612535287308371, 0.579288902807668, 0.54752471842644, 0.702164812878534, 
0.615198228724768, 0.595669683286993, 0.610175650367509, 0.537346831302303, 
0.576228087652904, 0.565264992084838, 0.683840199948456, 0.682154412774282, 
0.707345522158008, 0.506328019339791, 0.627875289959637, 0.613858937408062, 
0.699288819630885, 0.537899943060221, 0.513850978213273, 0.610881991418292, 
0.649650444100569, 0.563697568136854, 0.5716781907138, 0.595597236877924, 
0.59976590348599, 0.625054105070236, 0.511489776681411, 0.558281864442218, 
0.544507906649788, 0.709104068283937, 0.574922793364562, 0.546257115211629, 
0.72102274405517, 0.450490578764817, 0.628723495816117, 0.593662686881767, 
0.618757988866413, 0.658084005446277, 0.610953531626945, 0.635833956849187, 
0.660732691465243, 0.665443153455964, 0.649149238030126, 0.578752339070155, 
0.600303994829389, 0.66453943540023, 0.6109459778514, 0.646509164013207, 
0.544379432150094, 0.634020169336635, 0.667071928055344, 0.541647402798745, 
0.525333352602582, 0.624617647686803, 0.712729904978993, 0.6601039563703, 
0.572863313286675, 0.68761247781553, 0.794676923343112, 0.500487960307407, 
0.508379412680397, 0.619174291828254, 0.51748168021322, 0.672469006934975, 
0.53821570815559, 0.708837377565995, 0.58824350168657, 0.599158581337668, 
0.651441491814562, 0.632333265171346, 0.628574658990426, 0.604003363497703, 
0.506607623290029, 0.64501013166678, 0.405237498408183, 0.627674246613382, 
0.604813927231492, 0.620134976437917, 0.583942356856188, 0.569292906749886, 
0.608673048564336, 0.553389617938207, 0.502959198846434, 0.577903245644031, 
0.544369982160916, 0.63419821079148, 0.690457808307881, 0.652840229154042, 
0.592714702747804, 0.500836697604274, 0.595352497331367, 0.724776998769296, 
0.528897192276552, 0.554165544635977, 0.657096669961956, 0.570945280055265, 
0.613128840628074, 0.542153164431318, 0.56812356887322, 0.541549640273682, 
0.439568402257697, 0.633916222732154, 0.59598524330119, 0.626361158020914, 
0.639652712483719, 0.467943624446697, 0.595017304312952, 0.690189870511769, 
0.710695138293527, 0.635966380163447, 0.643401987862308, 0.635682007111815, 
0.586606850852168, 0.530702432515046, 0.509555181230811, 0.599847904900129, 
0.504904374417537, 0.563637442817241, 0.545655369981132, 0.588996751827443, 
0.602728115434886, 0.63951589605154, 0.596757668215174, 0.592371405606963, 
0.652241348932423, 0.759359577547093, 0.518451057641751, 0.59284359132608, 
0.514334308458490, 0.61240460574925, 0.736952562169632, 0.597054279100641, 
0.664542331244724, 0.586370940744854, 0.525341976086941, 0.642795178011713, 
0.516319013887553, 0.59395483820697, 0.583133430566191, 0.693663896315993, 
0.575462187391724, 0.64644356296992, 0.797895756478978, 0.48323502140365, 
0.639602860870894, 0.638236191146594, 0.611594139985549, 0.482273311851283, 
0.655049752724567, 0.58901105834001, 0.574759736374103, 0.620596625071988, 
0.747596768261774, 0.610949788680166, 0.602016659494189, 0.534960535323138, 
0.624812286772204, 0.476993476151851, 0.461517247447866, 0.663706187133542, 
0.57482534161639, 0.547653381138793, 0.505742007051444, 0.562914039321424, 
0.462762294443601, 0.529386799305411, 0.415402193956868, 0.593969798071248, 
0.531129707350509, 0.628304841053577, 0.645261883743624, 0.758025060001934, 
0.666051620206512, 0.594753476510251, 0.556873562944975, 0.525532632633701, 
0.561897889878773, 0.567559887822321, 0.56538467279238, 0.657994717937803, 
0.64500972766179, 0.548559701918949, 0.655486881380263, 0.669814027435621, 
0.636720719036758, 0.526634421370796, 0.619713057646812, 0.682592219039848, 
0.517104377439247, 0.61214842288813, 0.602769331569285, 0.608656770628809, 
0.580906897240618, 0.609004347140515, 0.527526767855431, 0.520671163361109, 
0.550051808205483, 0.543113838998497, 0.549884053397161, 0.505765535468624, 
0.588758871291805, 0.519872053511369, 0.621966197350329, 0.532418371272631, 
0.636063441753428, 0.638773140706347, 0.579572967316924, 0.532119348232434, 
0.629207014104475, 0.645304121866089, 0.654113468711987, 0.574987617042069, 
0.649716605198868, 0.540361699959013, 0.549242741773429, 0.626348107543891, 
0.564981551109749, 0.637618760466777, 0.559280663793821, 0.668583202408035, 
0.554545528982967, 0.554446062835598, 0.618193785545047, 0.652860126319253, 
0.622350713686167, 0.595112044710207, 0.680219716968169, 0.563304593521974, 
0.525212050114071, 0.580828544444185, 0.561868647610236, 0.500334061878153, 
0.685813105990609, 0.518475382909326, 0.573844503541968, 0.645417409040205, 
0.592958349506943, 0.602346596743258, 0.712197146973897, 0.686118986799479, 
0.747827017527924, 0.693267269311882, 0.625631603839825, 0.547576496722494, 
0.543477307579805, 0.650722935004236, 0.702199297212564, 0.674513470795002, 
0.612737857863886, 0.539430091673946, 0.616210964085038, 0.607652080071275, 
0.558088774603714, 0.559681291009321, 0.705863847291028, 0.734375083809196, 
0.638065151171044, 0.549471016639594, 0.692431393407462, 0.537501391951484, 
0.468857401286079, 0.602160728046204, 0.655566724471136, 0.572417987318205, 
0.734079719835057, 0.652980365904244, 0.627556639857851, 0.700919926874611, 
0.612572799481989, 0.662791224760695, 0.702921075177463, 0.601917974877468, 
0.679131072692636, 0.689521075240493, 0.612069856762067, 0.652729439125714, 
0.664894230853626, 0.612961091006248, 0.544591307312024, 0.61888133404567, 
0.709917397033107, 0.417445179090467, 0.726974315260806, 0.660918126397276, 
0.580316985802858, 0.681710518258885, 0.631063722891508, 0.582996597607828, 
0.627638187914036, 0.644267845106976, 0.658594183719772, 0.641019546516591, 
0.660723552923977, 0.635900344263507, 0.63792714438524, 0.560757316515635, 
0.690344708789015, 0.601024361353534, 0.574168317022904, 0.480326102576261, 
0.60338057938343, 0.619649405494741, 0.830632564551164, 0.732787209937462, 
0.66606906177907, 0.563165966925786, 0.726474151264159, 0.550471907966095, 
0.664173866647708, 0.510630846664696, 0.627298931857038, 0.651001317485124, 
0.604666175104066, 0.60880644295523, 0.716709187551037, 0.630187179686091, 
0.484756731052487, 0.639935803115804, 0.669205546357685, 0.608327408967544, 
0.576365353517966, 0.618266776636011, 0.442875029764849, 0.499750002668966, 
0.654084420923477, 0.454309605698178, 0.571078163592083, 0.51316942930399, 
0.587606778969637, 0.60927729913123, 0.628657218529541, 0.583711654142323, 
0.515853177860883, 0.55806039236246, 0.687391393950379, 0.568888793253495, 
0.668093970114663, 0.538581813233998, 0.607294515321844, 0.54937491068642, 
0.624826725648918, 0.663993785132628, 0.514719054015837, 0.53583403258564, 
0.57162799957401, 0.479841043679139, 0.66752610597943, 0.594763407879586, 
0.619677927677367, 0.607134286912942, 0.447233045221833, 0.72449817535809, 
0.65403782766105, 0.541395716514186, 0.698912696318236, 0.51344769868455, 
0.619816944005832, 0.572971728368481, 0.624950771522652, 0.653297637900981, 
0.517107595800969, 0.523022162342946, 0.575585559397692, 0.58757381360034, 
0.668357561617667, 0.610403478051234, 0.559062572733979, 0.650496120871151, 
0.598667716799367, 0.576308103443102, 0.505390902808581, 0.513624565697632, 
0.668853269124268, 0.691601959095327, 0.517301395561874, 0.487120131689673, 
0.705796556017303, 0.583546544082346, 0.736371023987767, 0.659101611982315, 
0.611855912513961, 0.627154173055549, 0.69213669578511, 0.644534076437263, 
0.59885364097096, 0.694374447677469, 0.644187858800969, 0.661940571695549, 
0.600884312440092, 0.695624159998908, 0.650685035137961, 0.591952412211102, 
0.53247539317357, 0.626034347914787, 0.640541544644112, 0.70177858913556, 
0.686463963541925, 0.595744524392107, 0.581783822342958, 0.643801394834452, 
0.65354457640802, 0.694869201557362, 0.56225735521657, 0.496284705142608, 
0.659830587741465, 0.694883314848268, 0.567986923550694, 0.61612397587643, 
0.666000402897705, 0.60822130874371, 0.531562923324611, 0.544880680744067, 
0.587779375346178, 0.751016052721896, 0.572135071832594, 0.732308508803577, 
0.578909823908528, 0.573446214651537, 0.584813859173096, 0.58272324188445, 
0.586738872739408, 0.567684109942101, 0.617441561629116, 0.673376251556639, 
0.67832999435775, 0.554187382551919, 0.399943339796387, 0.375819875424161, 
0.548663433686414, 0.584439594592107, 0.741353058982255, 0.578012980918759, 
0.707515415037109, 0.603328541395658, 0.528494688937089, 0.565979725056315, 
0.589053156627392, 0.666577593411744, 0.747414785868162, 0.58113085785441, 
0.497275506067485, 0.627402936307494, 0.671547372748919, 0.636806365543827, 
0.604931144259916, 0.692620716507621, 0.668826548545108, 0.549549300746301, 
0.598876746510796, 0.642082084645757, 0.493746413167459, 0.683601735499377, 
0.670945756788172, 0.555523632396076, 0.620919787541085, 0.669729690250629, 
0.6069918376648, 0.639822249826033, 0.544330139720448, 0.589586723570833, 
0.582027588483727, 0.664754155566592, 0.622085832266555, 0.442705658202177, 
0.556873551714845, 0.458233375673186, 0.716254190585346, 0.694740542778941, 
0.548361219420893, 0.609976738324618, 0.633054543588131, 0.665890351199572, 
0.65499821022136, 0.558374659744969, 0.611190243726063, 0.681787198517437, 
0.53963240214126, 0.562012181297865, 0.633294826614352, 0.527084284677896, 
0.767307118222497, 0.608314066860381, 0.570903357321799, 0.668333682707608, 
0.626782200471016, 0.488877239278766, 0.584346234063142, 0.455686327026813, 
0.527476433791027, 0.576121340919262, 0.525871308966789, 0.599117121403162, 
0.566902891924144, 0.624278945139276, 0.531469225236733, 0.534696524608396, 
0.597113535327902, 0.693346577476915, 0.659051472045414, 0.626308937109803, 
0.661427189118647, 0.52714002041538, 0.605395513005364, 0.723507580617497, 
0.607875703563261, 0.55416404460154, 0.513794564517697, 0.539030397223352, 
0.585819216537946, 0.517362782903373, 0.571390946662525, 0.579847001591318, 
0.650274880495488, 0.740287126209923, 0.614606080730683, 0.633735399397667, 
0.462655430761957, 0.510913943924825, 0.51803670959134, 0.645099671116766, 
0.585944159541628, 0.625057537933608, 0.73743221685805, 0.571657091205348, 
0.649159790345398, 0.637403337526113, 0.510205622356949, 0.620404766634886, 
0.584222687478061, 0.537772375035538, 0.669963834044145, 0.587092306694261, 
0.550614412031287, 0.583104408460953, 0.497429993053663, 0.678738925040723, 
0.608510897894287, 0.578064469698389, 0.605683278403113, 0.521810010106318, 
0.694457376128932, 0.621057565929143, 0.805265765407471, 0.56871907388536, 
0.67600355920237, 0.529787914010927, 0.675238873934243, 0.527163430364277, 
0.636430865738231, 0.612368462496688, 0.612351323467236, 0.67284918670639, 
0.68713205335069, 0.509920781097388, 0.698420336738808, 0.582819025911295, 
0.661448068243693, 0.45132519850236, 0.894148588650312, 0.84884876877944, 
0.863509375578681, 0.897967152601242, 0.921985343175084, 0.960690655059765, 
0.844864816987235, 0.87855819161713, 0.871095228256403, 0.88388558840857, 
0.877398495165292, 0.877210977548808, 0.877199337760814, 0.868369873673868, 
0.87461565034496, 0.854932565696351, 0.854570336810173, 0.887482577692738, 
0.911241311594928, 0.823983352957513, 0.911312263435584, 0.850629742700925, 
0.904234086875526, 0.942694609569969, 0.891423263555778, 0.916302875054566, 
0.85665613513272, 0.817908265910392, 0.889907269889593, 0.887654977053026, 
0.879973745213378, 0.866105503110243, 0.919235960952011, 0.866186615670541, 
0.857839359697407, 0.915228953637569, 0.936120734775144, 0.928146123660317, 
0.859785749815716, 0.85373259420612, 0.893926386626618, 0.897713536133252, 
0.950932577745231, 0.895499036300444, 0.929903406033985, 0.922020153721122, 
0.903329904709516, 0.883204563119376, 0.860834080233148, 0.890566833785302, 
0.878266189537847, 0.873973228445133, 0.90383506669439, 0.913739825285994, 
0.878940719059994, 0.904060012270837, 0.855125552046541, 0.88389493634577, 
0.897048266441097, 0.893147500893795, 0.946961215990304, 0.871810454091591, 
0.90820938695502, 0.955735283062472, 0.91495048296537, 0.912513356486385, 
0.937660668841275, 0.913964938191405, 0.908497882373912, 0.890049426777603, 
0.848130778895495, 0.895808866958568, 0.890379909362164, 0.937624578701728, 
0.876250062886346, 0.889130282638573, 0.88300153965398, 0.844923111040596, 
0.884390805415769, 0.839382973743764, 0.88907572458529, 0.87284729990182, 
0.898374078673504, 0.781106243640088, 0.912139447904933, 0.866819415488217, 
0.846335627417633, 0.843977083681774, 0.956357412239765, 0.88000706056216, 
0.915458293498622, 0.93526578202774, 0.920956677067376, 0.875462704673343, 
0.854106918892976, 0.884579584602664, 0.806817564130055, 0.851578900665292, 
0.825951477658971, 0.877008438946603, 0.831057628764638, 0.834740935848622, 
0.92486182635472, 0.94145238367329, 0.90749204241963, 0.893877533311508, 
0.850589359360034, 0.89840307537485, 0.896498111386711, 0.899388612787895, 
0.872754399959414, 0.890733876540142, 0.834382295559833, 0.842716168033258, 
0.85170438966102, 0.923397276020885, 0.92225272564635, 0.907480741560386, 
0.833840481569081, 0.913892669923575, 0.89767582292993, 0.892972331286901, 
0.912353734217306, 0.876678796125443, 0.904615939102602, 0.86356005754351, 
0.8675433176984, 0.879825470191277, 0.870938670122366, 0.83607929971089, 
0.872178860352707, 0.92543561126077, 0.824487821924692, 0.868013692001074, 
0.891945300612901, 0.885467659792331, 0.929156633213392, 0.914095641822772, 
0.830919563849709, 0.87435201853388, 0.88000690241321, 0.901126125403784, 
0.879386833325193, 0.856011907337711, 0.919255139339712, 0.94224592775871, 
0.885415683796284, 0.8815661050856, 0.83334498835902, 0.87993564477134, 
0.83596496515598, 0.896983209934654, 0.893805761117705, 0.9145276759904, 
0.930687615897485, 0.893842572007625, 0.872314889087184, 0.888570534782038, 
0.814709144358044, 0.816157201645541, 0.878337303833699, 0.929793686909912, 
0.832241056366028, 0.87023906801728, 0.893599655312248, 0.886746208146735, 
0.895408486652329, 0.882737547219247, 0.919001911453756, 0.922354806068205, 
0.85660100216549, 0.866495561632757, 0.963848542078497, 0.892842426406649, 
0.838111457665995, 0.869110780265934, 0.919218033923406, 0.857464487132605, 
0.845972414902668, 0.796831724282685, 0.891831662459817, 0.893499685823466, 
0.894415318869474, 0.914907833009619, 0.91037901486065, 0.840125825047475, 
0.929316206776028, 0.88125747067492, 0.85241267761487, 0.888231969349315, 
0.940962477265994, 0.890106902227255, 0.83055432006734, 0.91605707565016, 
0.881546467819264, 0.839671852973628, 0.865328903063026, 0.919363066858166, 
0.888441005964952, 0.817442894956563, 0.831311051119619, 0.85841657690203, 
0.871245115618642, 0.858656652727146, 0.884889136037015, 0.920509924176618, 
0.868423744311025, 0.867170410405706, 0.899161471652469, 0.844552741319514, 
0.87023477005742, 0.884058899895493, 0.87961495002658, 0.809579299316787, 
0.914941309618496, 0.837418079230775, 0.84936128566271, 0.879295644946927, 
0.887805898723762, 0.918017986309733, 0.875216532346633, 0.801546059851198, 
0.910721819275411, 0.911225457806328, 0.822477152651968, 0.822933525421855, 
0.911383347104192, 0.880631352325848, 0.879150875285504, 0.909558592694496, 
0.880193603350189, 0.902096523086429, 0.851546980030828, 0.931470259538553, 
0.940361837254075, 0.880837270875086, 0.867835467560932, 0.876648533267433, 
0.899691650866777, 0.923041695155252, 0.863423633072534, 0.907597014644846, 
0.90314358834388, 0.91080855232146, 0.835718630232469, 0.835065344160415, 
0.868633487761725, 0.906105085629649, 0.849485679595529, 0.926244675605796, 
0.92388150648524, 0.84207683902921, 0.857365088140173, 0.922102185290764, 
0.91270872867457, 0.896301143494264, 0.903683755208165, 0.835607357505224, 
0.854210639004806, 0.893764514883747, 0.858830213385645, 0.90152639215053, 
0.873093553557952, 0.89068409844305, 0.91809533882346, 0.856875049745245, 
0.853310762537209, 0.880080434701926, 0.835719632085556, 0.886132495289914, 
0.852006379106244, 0.904141747152135, 0.895519820457819, 0.866004432488562, 
0.877839452657536, 0.854680948285129, 0.830712360086164, 0.899214610392701, 
0.94726787606594, 0.828575610408802, 0.832701601883571, 0.879733673852955, 
0.844945794814648, 0.880940742822591, 0.88372751076378, 0.912920921401193, 
0.90140232889129, 0.922862682027832, 0.916884801770806, 0.892410792365266, 
0.912010852075782, 0.861572730666162, 0.871345318758371, 0.914889375054313, 
0.827953577234791, 0.897071965269931, 0.906849939887827, 0.933630230168982, 
0.874341396855527, 0.883370688739174, 0.905350912963378, 0.914785015623567, 
0.893599467011379, 0.867050953906243, 0.88473615412878, 0.931342457209367, 
0.925336305520135, 0.905778378643345, 0.809023771574327, 0.851515838128614, 
0.877928287607348, 0.851815860389627, 0.87859054210263, 0.83669033350994, 
0.923889272183385, 0.917625321394624, 0.891493553185136, 0.904409281689131, 
0.844842864414962, 0.87807495214974, 0.919265641924925, 0.91290078828165, 
0.822643706270992, 0.91063702674787, 0.920311211357216, 0.824311076772977, 
0.908842058690913, 0.89387626233571, 0.903683189161019, 0.876213810425727, 
0.873285831252072, 0.812071327213587, 0.890146776355802, 0.936826683972707, 
0.919781747657888, 0.876969382185068, 0.84910040322118, 0.917512786391405, 
0.892270925741467, 0.883307249700643, 0.91646654185409, 0.875875896402683, 
0.877839794277847, 0.858168359287103, 0.86928320076221, 0.892865054220478, 
0.90560189418688, 0.898334703375879, 0.929347047379869, 0.864899328520048, 
0.94050530110484, 0.866537678825947, 0.912882357659005, 0.936022259316244, 
0.814360329195163, 0.855390424323635, 0.885999830520827, 0.903079129762547, 
0.870803080598448, 0.889219486801713, 0.875915866791676, 0.883114794145218, 
0.892783023803292, 0.959481571966193, 0.895831900800966, 0.803455578698851, 
0.860405480175435, 0.860327865586512, 0.921218097273195, 0.888188953059013, 
0.852437626502553, 0.881752889409695, 0.84496132159008, 0.818202837809842, 
0.856785166253177, 0.926605923655902, 0.946815741182828, 0.876641853802552, 
0.877061391259974, 0.847794330274573, 0.848468708903435, 0.936160626504424, 
0.846076201695002, 0.88839059897109, 0.853296149307679, 0.860874160278553, 
0.873272158481618, 0.865140735857688, 0.881131842030013, 0.890733086730115, 
0.908677578917785, 0.933541055697266, 0.92107605929056, 0.858546817475495, 
0.900363985505252, 0.941953506294984, 0.821706864877185, 0.932380253303298, 
0.944233354444196, 0.853152086262276, 0.893588036706954, 0.885116019614747, 
0.93798667089895, 0.863172425394504, 0.892066005855582, 0.915573058167175, 
0.876559797674753, 0.925255291909548, 0.880070510955133, 0.82622781730204, 
0.880565819160256, 0.866292732281264, 0.841901971504579, 0.851858416390253, 
0.903715653233594, 0.908222136441057, 0.885804537691019, 0.944251789252232, 
0.940504469644664, 0.947638583049857, 0.81693838810192, 0.871964747155592, 
0.875233784132326, 0.912909962367295, 0.866975746171191, 0.888899808762008, 
0.875008800107118, 0.886990704373034, 0.93025555676002, 0.869899976696845, 
0.899866821998612, 0.886435475914077, 0.878960520033643, 0.810675919357601, 
0.869925144609101, 0.823297241613916, 0.967457998603152, 0.840296917029392, 
0.856008255553067, 0.912930176505846, 0.852165800321966, 0.894134312052174, 
0.867948615477696, 0.909086022244145, 0.866959052752935, 0.868063482409571, 
0.859773373874622, 0.89487960874229, 0.91395494931842, 0.888643492381205, 
0.87828390101035, 0.927547385936464, 0.924599510214678, 0.926374864390796, 
0.919820671527493, 0.889167069355019, 0.820904967469684, 0.938962810100338, 
0.939059455234514, 0.922600561148122, 0.889019807130884, 0.908979205960074, 
0.884133285011852, 0.926809089863744, 0.86694090339116, 0.922878637159429, 
0.884276425027627, 0.90821336849934, 0.858898770374597, 0.886479173184932, 
0.918978698669495, 0.870113665412686, 0.868670982995092, 0.920143806030156, 
0.916584625885144, 0.847278034154929, 0.929607856089682, 0.910989237400593, 
0.909335546794728, 0.884532198802096, 0.854315130579273, 0.824252539100442, 
0.871767689981293, 0.90763966765085, 0.897188365783387, 0.890665490751673, 
0.840651316314487, 0.868133103775808, 0.873492864767546, 0.877858304866079, 
0.850593754119306, 0.891532116408663, 0.91784663380515, 0.861230265453442, 
0.853852824419077, 0.873311061364531, 0.883639874473028, 0.92143166768035, 
0.91831561556448, 0.908824940216204, 0.947674549372647, 0.897501057257958, 
0.846361542755884, 0.890269179192582, 0.816486041970618, 0.82661859363537, 
0.863947836425143, 0.90779300663059, 0.895735897524553, 0.794369383949562, 
0.888765811108188, 0.879832158826526, 0.865204744278975, 0.912860043073893, 
0.891082689589627, 0.904877119468982, 0.845741830221488, 0.839940363173963, 
0.9117635534351, 0.871951817895684, 0.845449462951447, 0.873664034789858, 
0.908565107294836, 0.906762489608487, 0.897557503423542, 0.930704905013337, 
0.840741013754396, 0.848028634068229, 0.914625132548027, 0.868576438257579, 
0.907330204756094, 0.830388902601899, 0.907686976789042, 0.851824478119148, 
0.860452996884527, 0.906591843332473, 0.886708683756566, 0.872587441729412, 
0.943544966626716, 0.911642035891821, 0.836290599460652, 0.88448398362981, 
0.941004998104506, 0.877961580749612, 0.892924388276719, 0.881680638592417, 
0.858598895439759, 0.830603461780615, 0.885090068382975, 0.921960450742188, 
0.941056650848152, 0.849051010200024, 0.862101762254248, 0.85888041792438, 
0.820515342615322, 0.851775436893504, 0.897109048448587, 0.832623745056417, 
0.923470698749268, 0.839330560179542, 0.881989204329396, 0.778906878933662, 
0.873102240567436, 0.831608563490241, 0.857865552872858, 0.899139044803198, 
0.84621372370245, 0.890694874693168, 0.860818494671411, 0.893402702244747, 
0.874875993339895, 0.850909094016845, 0.916172281052288, 0.907867810837932, 
0.859134737178025, 0.885726415051754, 0.852634564639875, 0.9009387381788, 
0.866865199575957, 0.935797247199663, 0.915446970554129, 0.892729893263077, 
0.879466727311726, 0.91149687130237, 0.95397138539029, 0.824523782567519, 
0.885560143544396, 0.9283759683435, 0.883651348729461, 0.929284541765703, 
0.890105456347239, 0.879057333434274, 0.847889504562887, 0.905650959572118, 
0.735853237657488, 0.87182471045236, 0.909621014224238, 0.86166188046426, 
0.89261614939447, 0.916075347833019, 0.921418861613112, 0.820618348344854, 
0.925418915404022, 0.823662518053644, 0.885654917015756, 0.857849595413877, 
0.909939620122919, 0.89202628589859, 0.903928794262969, 0.867997918244588, 
0.888730443954323, 0.904410701329174, 0.912020967447733, 0.903021903339033, 
0.881275097128043, 0.907173215667703, 0.940319465673178, 0.916868017739022, 
0.844642876841488, 0.927491872235362, 0.803808937229258, 0.841134239985869, 
0.893169367606173, 0.882876505895959, 0.829249603047774, 0.839898604598527, 
0.911096511858143, 0.925918924944513, 0.923417770171942, 0.883759859043511, 
0.892875646254808, 0.921268298656487, 0.891083328219895, 0.90661159162438, 
0.8450230286041, 0.823264706428657, 0.875456316336257, 0.892026843038603, 
0.864131923788594, 0.89726930104696, 0.877027071220591, 0.897124494331701, 
0.87238564165951, 0.890338409860316, 0.841309893942584, 0.897914490271669, 
0.884577154738276, 0.912326472015967, 0.920828180932676, 0.870213931088182, 
0.932008097744675, 0.935413512347764, 0.844069854720604, 0.91726285111942, 
0.885624765118033, 0.890814241848133, 0.930497376832059, 0.933838208992108, 
0.852741942589342, 0.961447722368843, 0.84411277049571, 0.848387525856922, 
0.888414184478832, 0.898270217666939, 0.847851963013629, 0.917716917335725, 
0.856320650521242, 0.873463978030527, 0.911333384328713, 0.90700732180365, 
0.90053530367597, 0.827328629592902, 0.837250683840835, 0.919855792523542, 
0.859771874528497, 0.844737673822891, 0.881517551026748, 0.892370771673192, 
0.798444019675355, 0.87232317260761, 0.902571186874627, 0.929071967101571, 
0.84619366682381, 0.78470663097279, 0.900230822247845, 0.91096965809577, 
0.873578507325056, 0.828740403860889, 0.848953277769619, 0.815076427128674, 
0.855702114824003, 0.91118851301301, 0.835322061433438, 0.913700219136611, 
0.892895625868962, 0.914933463587648, 0.826426869168664, 0.88757330519027, 
0.863514708352483, 0.873605074171587, 0.856972196377764, 0.826113679889807, 
0.838000760610174, 0.829763614155232, 0.908799914402584, 0.879594901012935, 
0.914794766157925, 0.859631077074107, 0.866399163701272, 0.889485856096428, 
0.895407271353861, 0.92604665852885, 0.891051783356675, 0.889517577613761, 
0.861212742615457, 0.823558685217251, 0.880960612793726, 0.810990543145728, 
0.910188077151318, 0.843799654691064, 0.883820915551223, 0.873898939118586, 
0.88665126314944, 0.859059798870507, 0.817198931084133, 0.923273452916002, 
0.87870155911583, 0.899104909500623, 0.858608511538348, 0.912300222955378, 
0.851557332372112, 0.856497785196168, 0.90453407051493, 0.874759079497885, 
0.888138445749133, 0.883202298522894, 0.850583060966886, 0.892945226489646, 
0.911331924902238, 0.857995731331396, 0.925739332294699, 0.84334052244433, 
0.844703175433722, 0.899976320031707, 0.80770811337882, 0.862421269542107, 
0.910881457987552, 0.893235156406985, 0.82965823788929, 0.916159863618095, 
0.877690343324582, 0.875569186883303, 0.89653844159422, 0.889626057546412, 
0.933744228211485, 0.867356205733971, 0.858250052823981, 0.914239572661294, 
0.816976780256084, 0.848914024915051, 0.919179420947842, 0.916032972524548, 
0.878368890330913, 0.838707242332187, 0.884152575315808, 0.895655121980122, 
0.945511320083098, 0.876096902848747, 0.810283823882194, 0.935111745589056, 
0.880330757972421, 0.839144698871501, 0.880697218859726, 0.879562009549772, 
0.873247299057367, 0.889494353199069, 0.842631062471192, 0.884716927884447, 
0.946050773049878, 0.821200481201501, 0.89449157837836, 0.88099209878433, 
0.888498716085637, 0.899639566435548, 0.896299382575454, 0.950887646229024, 
0.896902951163033, 0.894347238843116, 0.8827240517297, 0.868354316141694, 
0.878167126617017, 0.82287680711248, 0.89490802404505, 0.859295113725615, 
0.865890528633905, 0.869105933703938, 0.858922119329694, 0.935558218720912, 
0.865263661731849, 0.88109790050752, 0.873990266074353, 0.891698029215466, 
0.900639470071009, 0.828055417625517, 0.912943438580863, 0.90213852287757, 
0.890386273002971, 0.84035083260118, 0.896453893796232, 0.906602752190606, 
0.92749286503448, 0.916654247304163, 0.837396566405364, 0.904434134860738, 
0.848117218553454, 0.887877287748366, 0.868658895504317, 0.899156680878, 
0.862458703798226, 0.874389410845018, 0.908282059838326, 0.914776393801882, 
0.817600456968706, 0.893532013120692, 0.952703239875867, 0.89142173521634, 
0.877477923939993, 0.933446076566563, 0.879085730118969, 0.957244323763604, 
0.893249501635153, 0.910995371940729, 0.927070887051886, 0.887028387548827, 
0.886459005404016, 0.84209648092295, 0.867152386490686, 0.841438948969444, 
0.883256561791224, 0.89177007079479, 0.852560106349115, 0.888261915307716, 
0.876841147185589, 0.871096184489682, 0.888820417282124, 0.818362409283439, 
0.883670352686834, 0.856339157111312, 0.926558873352569, 0.890563856710917, 
0.789603706953544, 0.942480471178776, 0.878067901138356, 0.91370406133002, 
0.89586737199403, 0.873626819206266, 0.879456553339288, 0.833455859402903, 
0.89858380338899, 0.888683234695118, 0.920854409482312, 0.940264169587583, 
0.844479984784959, 0.952662543075592, 0.81566246370556, 0.888965744050716, 
0.900803990202101, 0.860328809555163, 0.906089717638364, 0.926565874651606, 
0.882499359982196, 0.90219675070759, 0.937251157043339, 0.92095051684732, 
0.868225613345087, 0.92042332900576, 0.86777466314294, 0.856070832547415, 
0.873852780170004, 0.82811558267209, 0.862914058455259, 0.824783036221985, 
0.904421373506803, 0.901023075271616, 0.9477649505302, 0.860228100255368, 
0.868395228794133, 0.85896942064996, 0.855824693838283, 0.885907211636688, 
0.889109050249224, 0.886245582430434, 0.930660270149658, 0.947673724758765, 
0.886009546779929, 0.91115148309012, 0.877914147469504, 0.845746759480045, 
0.867674953433098, 0.882855660467723, 0.93302199708889, 0.912947000785131, 
0.871743995445535, 0.93419395791444, 0.922257779973505, 0.795265001078986, 
0.853278797706175, 0.934134391875273, 0.92702860763262, 0.896275420488497, 
0.900111556050574, 0.788105083326776, 0.912483943475803, 0.900791462920524, 
0.922890565451016, 0.925854133563035, 0.900245157861984, 0.90226341633524, 
0.873053331537727, 0.902252877678212, 0.874767284807048, 0.924334587250635, 
0.919819072418074, 0.849335281370137, 0.916941797161661, 0.915655964906451, 
0.936388908657182, 0.959211734469319, 0.859686640645854, 0.875709749728442, 
0.844241363938266, 0.885948485277949, 0.867794125395128, 0.849675598636124, 
0.917901694279723, 0.892926289701868, 0.834444844489737, 0.848540638194008, 
0.876943140424484, 0.91064247883194, 0.8686725280809, 0.935625043558796, 
0.92918377572353, 0.896581078113267, 0.835358882101842, 0.844324744189353, 
0.92426302279305, 0.867865858553257, 0.937830164865916, 0.894566287749143, 
0.87497459178935, 0.882323019844723, 0.844005376990588, 0.87428328465325, 
0.863562427078964, 0.95957116784666, 0.87712049337011, 0.875103560654188, 
0.894672047406873, 0.902130654738609, 0.835800772073887, 0.905039446522759, 
0.862840670294468, 0.910179185838252, 0.840795546525669, 0.955589634534544, 
0.892676410889953, 0.839426576580254, 0.865448413874536, 0.840978794110092, 
0.896105177907458, 0.826813146064638, 0.902437095629298, 0.854567164542432, 
0.884108692752415, 0.888216793458978, 0.79926497017713, 0.939189713056817, 
0.866381535471506, 0.863910625215685, 0.872927426243792, 0.8569985812008, 
0.921035351479886, 0.870714124103376, 0.879216996001196, 0.890435690145761, 
0.930553613717976, 0.79698472158619, 0.879697184360309, 0.942427771522774, 
0.896016770922687, 0.876639358163509, 0.800916471674542, 0.877447900955007, 
0.875829747374621, 0.84870761124957, 0.859945960901326, 0.939321921135985, 
0.90209608574485, 0.900621601176308, 0.947944177600858, 0.970656775664809, 
0.925936413971612, 0.928778293837766, 0.9330417291898, 0.961492734782527, 
0.885948358430541, 0.970306576679728, 0.926859687431347, 0.926063509273335, 
0.939385238746404, 0.906815148241137, 0.885350903812454, 0.915830179280708, 
0.928212972672351, 0.931106216768487, 0.922556722482035, 0.944449122466428, 
0.902846459647365, 0.913318533059375, 0.94800294451316, 0.945825460473378, 
0.960764163236581, 0.92236563468699, 0.94371264804256, 0.94253720268809, 
0.919689856413235, 0.872487495216983, 0.8850073782251, 0.911560923117998, 
0.912610240961263, 0.943548074706216, 0.95120455375195, 0.954413980405156, 
0.957934583161713, 0.942026349962168, 0.905759666150724, 0.931462403020998, 
0.918065329709942, 0.95568181367827, 0.960890106507332, 0.904380591384283, 
0.920025791016746, 0.907185038243579, 0.924930792196456, 0.874859168004052, 
0.917292758773651, 0.920950245926777, 0.936847342314804, 0.970978859405515, 
0.876388105870414, 0.948638660390921, 0.924771476525001, 0.914353926710739, 
0.93500950163981, 0.95490113963734, 0.935726145281688, 0.924492121105098, 
0.9244798429707, 0.869588167468555, 0.945488797369235, 0.905040958747804, 
0.955113087363669, 0.919771432193866, 0.938957540834489, 0.941815265886285, 
0.928871878115082, 0.923804714121836, 0.923907224572278, 0.920533280646718, 
0.87580649735722, 0.951635090179207, 0.938242967189922, 0.926823879424691, 
0.938203157483342, 0.844310717612008, 0.946015624401254, 0.918844461869129, 
0.94760175783079, 0.91726250790548, 0.979446338139702, 0.910548902513877, 
0.927814671309485, 0.94754968586939, 0.958499406840723, 0.941321125713273, 
0.948185024393787, 0.933532615172401, 0.928461361258821, 0.897356030298417, 
0.931106566814024, 0.961180474668567, 0.921503147766537, 0.896289764788911, 
0.937503509567419, 0.933126131092745, 0.896830907035966, 0.949365351648884, 
0.961951055958998, 0.917933051846648, 0.937382253764162, 0.939077888424447, 
0.941328396643027, 0.939077454174488, 0.959715391700911, 0.955274862732456, 
0.93792259290174, 0.928274301373427, 0.940052915830599, 0.927195719029803, 
0.944516044432381, 0.93497228852206, 0.963803896342945, 0.927095477812179, 
0.923488275527205, 0.906880870243663, 0.878148169302905, 0.887787598381552, 
0.945278290535524, 0.907897328963594, 0.958532832453744, 0.925631851571233, 
0.95724726395313, 0.92701900624336, 0.941314972120733, 0.922747066763423, 
0.928279777178563, 0.919323323016095, 0.938851146584035, 0.924555755876341, 
0.930242526226072, 0.928838345984873, 0.959855512604666, 0.934706049821576, 
0.916823109355575, 0.9246088626644, 0.915832221183883, 0.939302935961773, 
0.93081702989979, 0.933773138032222, 0.931930860845898, 0.962344152855615, 
0.880433405960437, 0.936194936677769, 0.930167898666714, 0.900901395667548, 
0.94784125861579, 0.929561834750938, 0.88987654453307, 0.939292527848642, 
0.971216853561727, 0.920054274099611, 0.937131335053177, 0.971125248095015, 
0.943427978154574, 0.954080222870222, 0.920733153007758, 0.946553928179594, 
0.929547921499359, 0.90346496949747, 0.902152942044001, 0.907709561570841, 
0.927011489064301, 0.933397139787605, 0.924341301311634, 0.933233627473895, 
0.913209925798126, 0.932796219434625, 0.915923736820914, 0.94719546500622, 
0.911852127844959, 0.893901785642681, 0.949061490724148, 0.910769225379684, 
0.864298863641653, 0.951495576554236, 0.954033678182812, 0.945079002166614, 
0.947080137809925, 0.967549008452362, 0.928342348849242, 0.971315042086723, 
0.918681013322168, 0.946804877589397, 0.935997376016572, 0.931341650362621, 
0.872916371722154, 0.948807666323413, 0.932313036754252, 0.946854089344845, 
0.952251410876988, 0.894717521136259, 0.937234078868221, 0.968256592694908, 
0.94686679648005, 0.935953176425026, 0.94498439027958, 0.936481287560984, 
0.912620444643992, 0.925106701231179, 0.934984632119596, 0.911717676888618, 
0.948232263835292, 0.94650547379805, 0.926435867829628, 0.947985377943344, 
0.927822013145541, 0.945654982552063, 0.941034754642881, 0.958818975491761, 
0.925456722644591, 0.85830419891611, 0.895411374351959, 0.944336810365584, 
0.942710589736822, 0.96068264488614, 0.965895830595872, 0.888964488226883, 
0.87859029773956, 0.905317480859056, 0.92440258931806, 0.903900966603086, 
0.941375364981481, 0.944261681955273, 0.90370208430195, 0.92252138769136, 
0.9404357350147, 0.953983395757024, 0.913676619840405, 0.93924931512056, 
0.938920288953981, 0.96321759267433, 0.909159948903243, 0.948895783315045, 
0.924996952939545, 0.922757775851385, 0.95231798895985, 0.953032252351198, 
0.968987395619787, 0.90405914634841, 0.946041809455629, 0.936042953556624, 
0.912639912368033, 0.960413888943801, 0.921175939984061, 0.94082445663527, 
0.965374630739792, 0.93863962968973, 0.931996242669964, 0.919175903974797, 
0.960240005639883, 0.93432260931615, 0.930450289883074, 0.955251207908877, 
0.925902191820887, 0.94706508788731, 0.948008381112248, 0.909354592430291, 
0.869448465744046, 0.96183356002216, 0.964153781469042, 0.969509261311302, 
0.88880280406135, 0.94605478789443, 0.930323085383092, 0.942310505992318, 
0.948192625586674, 0.927054541355269, 0.901729681258076, 0.96966068138045, 
0.958236353586025, 0.924440351320348, 0.963949709882514, 0.950442639962308, 
0.949332102142035, 0.928986014371724, 0.957968918685305, 0.947234053018951, 
0.938300032647004, 0.926947666224474, 0.925248822880916, 0.907044980737882, 
0.954007575594803, 0.910567168413726, 0.92541394261171, 0.906564729028611, 
0.937020314570712, 0.915975765571508, 0.854823073826704, 0.933046401419925, 
0.8921097827554, 0.912778501466411, 0.93350578696351, 0.904688058233565, 
0.917924104241337, 0.919214444164703, 0.937465791722494, 0.960633322499219, 
0.945312317948053, 0.944839358904443, 0.972059129582587, 0.959656221632921, 
0.943997569140978, 0.947109156889585, 0.905578760517856, 0.969163378053639, 
0.949628146630982, 0.933082568901365, 0.93345148161802, 0.902236576663771, 
0.949682038415773, 0.915238773295763, 0.970700300974742, 0.945844231698582, 
0.907355384672915, 0.906872394864871, 0.933797741535856, 0.93849824461364, 
0.918836643763028, 0.920833081942524, 0.94278254975268, 0.924223074805382, 
0.954277141046504, 0.951769166708957, 0.928836522331438, 0.944916088169351, 
0.907891789016865, 0.896863025800527, 0.948479550074285, 0.9430810583621, 
0.959338363460915, 0.958053804400154, 0.92622392583942, 0.94945959888632, 
0.937546492214007, 0.956181874825371, 0.962907609404652, 0.954016735756, 
0.881567750996927, 0.94559149661817, 0.878331982949248, 0.941455808377937, 
0.935592955568911, 0.91652993735124, 0.958771976234732, 0.975957488926847, 
0.963836018187677, 0.946428366033277, 0.941973156101284, 0.886376784711147, 
0.895370972969744, 0.910450781194306, 0.943212976122683, 0.925582280181369, 
0.798775533026919, 0.935078683090105, 0.952326646605835, 0.884111596590828, 
0.95800664964805, 0.934607188419957, 0.93206542979099, 0.952378148284783, 
0.892700163601342, 0.947469040344275, 0.97155282849322, 0.945417474509902, 
0.921027606539551, 0.94145340227616, 0.925923184874659, 0.95237056536826, 
0.975827586680236, 0.938480930008617, 0.970415496317634, 0.957738415936465, 
0.94597037937589, 0.925921016665769, 0.933014313793515, 0.890935787621437, 
0.941321572134868, 0.882920285438856, 0.970855108135827, 0.899360892474633, 
0.924013009510247, 0.932622202412505, 0.927001387074999, 0.943500883334387, 
0.947149908958, 0.95766541468127, 0.938384179091831, 0.951169251078228, 
0.880101756702557, 0.924218919101352, 0.9482647149347, 0.95821527975205, 
0.941480817954035, 0.926132444944896, 0.865049484672138, 0.894453418817857, 
0.942148442401742, 0.910533477749877, 0.963817645604605, 0.927373582226086, 
0.911965484228376, 0.912775039934028, 0.899570086617457, 0.958033225179082, 
0.919246263044704, 0.93223117593296, 0.887334132103172, 0.942857076606474, 
0.932549192287577, 0.910637844683802, 0.933469066704678, 0.928321362330219, 
0.941970443588593, 0.91226890745493, 0.935979939080688, 0.95462402504805, 
0.938150050371222, 0.89774826421327, 0.835355739075525, 0.896949504876831, 
0.882613874933492, 0.927635620948683, 0.92484204477401, 0.937069082090788, 
0.922822361981054, 0.936591336047435, 0.927348700002957, 0.961479409380846, 
0.972963249018495, 0.925524641817627, 0.965960737532984, 0.902455268487987, 
0.92737312066691, 0.921604825798147, 0.928622800879008, 0.917894502016273, 
0.898091446839997, 0.947891988544532, 0.9233997191711, 0.95863007381811, 
0.950302332570062, 0.939781750505193, 0.912512950270222, 0.938886136469802, 
0.959123948168836, 0.922618544021967, 0.95614729722470, 0.938854275603197, 
0.930804308577439, 0.94752502421714, 0.958631569137375, 0.939055827688292, 
0.931739816086364, 0.929361177710601, 0.945998906735717, 0.96833691802358, 
0.922773800952943, 0.97535115254054, 0.905823678205345, 0.972080032247637, 
0.891453993632064, 0.949889990604566, 0.922572626486851, 0.892199812405098, 
0.96198603880643, 0.948834453361178, 0.942287246656975, 0.973882264341294, 
0.842738297433463, 0.946113331831796, 0.94086779082309, 0.963009019757044, 
0.913168047956217, 0.93256954444953, 0.930612935526894, 0.958594657785135, 
0.94377964611113, 0.962822718120918, 0.95374259692672, 0.94716069783656, 
0.944182267017498, 0.945395221959456, 0.952050008748944, 0.887707365595213, 
0.951736635558564, 0.94758488482787, 0.925408554822863, 0.945531550221472, 
0.934742840875526, 0.934634241674435, 0.932487153404867, 0.956288062656406, 
0.941787783242995, 0.95862413523689, 0.958889564409488, 0.954754793434026, 
0.932452480196857, 0.943068521605766, 0.94731377366919, 0.925273444498052, 
0.889469927522987, 0.917496302255, 0.931325892705753, 0.866830703550999, 
0.929999541968148, 0.9685579487003, 0.928696654907542, 0.942151429781218, 
0.936854095829054, 0.9298228434502, 0.911530716886825, 0.943335862697329, 
0.967761039519234, 0.954042387876313, 0.963142402723093, 0.950373102714582, 
0.923113452712761, 0.928275848424793, 0.950763050666313, 0.912966137986928, 
0.928603039075392, 0.959166075709813, 0.924553105249721, 0.96134302923758, 
0.932165613323095, 0.953082370090388, 0.83971703283864, 0.913216870688003, 
0.926469515481989, 0.93750966752256, 0.936992304932837, 0.942052571536453, 
0.910182682949963, 0.94592597962829, 0.954887119624132, 0.886006764719143, 
0.91654220358304, 0.931277177143376, 0.916466155700923, 0.964070551509672, 
0.929865756126638, 0.914665554072821, 0.899193914519224, 0.932852308408824, 
0.89585048417145, 0.921668268018878, 0.94334473125216, 0.928612974650218, 
0.917968514105417, 0.933630297851615, 0.969600327367497, 0.974510877312626, 
0.904671589307377, 0.901289316191295, 0.934963609157605, 0.911327897970625, 
0.953261877081992, 0.919834332034098, 0.94029012551753, 0.929879745305087, 
0.927594369738328, 0.955061516030895, 0.924776753049703, 0.951236430686944, 
0.927921044459771, 0.939409454920805, 0.968196237543177, 0.918214701849899, 
0.921996301220752, 0.930677559659367, 0.905876943340185, 0.940821206685848, 
0.927134201469191, 0.919989986454798, 0.954388076622084, 0.927074932751169, 
0.953857802424928, 0.976323763098013, 0.929262334390982, 0.909136511603787, 
0.943070371090778, 0.91513085104785, 0.974132430369625, 0.896069704464621, 
0.96909584537758, 0.924865858371845, 0.960464118038025, 0.955443027982948, 
0.958077868508021, 0.96106729475086, 0.95228697047667, 0.959001697581705, 
0.85325697241716, 0.95504230608492, 0.967689083878668, 0.901647237855026, 
0.972547620202465, 0.962944207692781, 0.928288478522438, 0.932641707741889, 
0.966611059716727, 0.912791658035882, 0.947044678701397, 0.942180917752447, 
0.925417601621677, 0.925148492705495, 0.937871148222503, 0.911958772033855, 
0.915190614274425, 0.891940174517521, 0.890656082803571, 0.916927825388786, 
0.943520663927414, 0.924880983619747, 0.942306295063927, 0.928715114875782, 
0.939003265943357, 0.96362813136114, 0.937696610723105, 0.951898839229967, 
0.888861503655581, 0.921755559782355, 0.895587682445876, 0.964926744497163, 
0.922013858210295, 0.922905865804419, 0.911893803542352, 0.939865576321383, 
0.922376738648418, 0.934451335203658, 0.942597954722923, 0.94797287859863, 
0.918415314949886, 0.913823949762203, 0.919319670086795, 0.951024270963425, 
0.93514853059267, 0.926144767260263, 0.941737669388552, 0.936000199216215, 
0.918944306245907, 0.9140402123334, 0.92378943865125, 0.902960870681622, 
0.903174938566072, 0.929718581581095, 0.915415278688015, 0.942852716275744, 
0.935320200689495, 0.92269210431241, 0.919113674709329, 0.922331536496389, 
0.92337722718328, 0.960065050829268, 0.939875746000651, 0.910967263643638, 
0.946953219684347, 0.916543112659247, 0.951626643595575, 0.937091729306655, 
0.951908376057255, 0.94402223150228, 0.910362876708083, 0.861338410760606, 
0.9111154652239, 0.954504079830476, 0.924142319959516, 0.912646966606403, 
0.925212305355574, 0.925222751868743, 0.961502761721327, 0.906658200492704, 
0.943686070090668, 0.958889598600472, 0.898644799028218, 0.917828106660514, 
0.913384937969431, 0.913133261276767, 0.94144292615113, 0.933875119131105, 
0.94849531201941, 0.960466880690194, 0.954510911927904, 0.898744946457022, 
0.91119569973053, 0.968616711234657, 0.967603579632835, 0.947994571524, 
0.950841609079116, 0.90210507741746, 0.933140695818197, 0.930202162236943, 
0.9245707407972, 0.962340854105954, 0.895986284232494, 0.932623714869311, 
0.901450125391008, 0.916476399281898, 0.897000591956567, 0.902528181680095, 
0.979781673331121, 0.936244498534554, 0.926055199101122, 0.90795967483618, 
0.969338055652247, 0.91413506844052, 0.961999225833796, 0.955065825925376, 
0.953787085710903, 0.94130680965702, 0.92759902612082, 0.95164721310763, 
0.92236441425076, 0.88985524413726, 0.952919253003052, 0.939689761264103, 
0.965870292653787, 0.951844902719944, 0.89416091573582, 0.917572182301821, 
0.944193580474085, 0.8781153871469, 0.946019730052302, 0.909960127395915, 
0.852665674802887, 0.87461284723046, 0.938163522337707, 0.902784626245305, 
0.887667881320602, 0.946618501394577, 0.909125859570926, 0.901969167544487, 
0.95931145355785, 0.925247475554708, 0.9341735409898, 0.93368663049588, 
0.935215182024235, 0.931969791157563, 0.963564820184104, 0.94123395078681, 
0.882834001868111, 0.917883941209152, 0.931483074183641, 0.919986539382798, 
0.942191674792326, 0.927116376309895, 0.92817162737567, 0.937237759030208, 
0.902480392581904, 0.949623757707273, 0.940026227703953, 0.94828632021259, 
0.936497384736282, 0.944181687236055, 0.917337578287384, 0.901674474431229, 
0.922142372468285, 0.948093192342413, 0.966646915232342, 0.96320884057134, 
0.921419164433783, 0.916208888602564, 0.945759325969764, 0.907805230372415, 
0.900517157382277, 0.954642783598364, 0.953144332017861, 0.947617648357245, 
0.938634029200466, 0.950546727932197, 0.871587645530717, 0.952066286483116, 
0.928218660197522, 0.886722525340442, 0.928064280907043, 0.93457059255937, 
0.907692148030713, 0.91733988166546, 0.925264695248994, 0.955967168649813, 
0.898249454606539, 0.947228969658627, 0.927546020037813, 0.925935029039983, 
0.960170276091976, 0.956672505328586, 0.922529155081127, 0.943304422886571, 
0.947253081268143, 0.947884260393876, 0.886506472290769, 0.922409254115535, 
0.970488198685537, 0.947561417397825, 0.911594670456026, 0.92711556418928, 
0.932124438518034, 0.970825768063181, 0.95291462390681, 0.940398126035256, 
0.945085833131102, 0.933312122368143, 0.952138779601942, 0.93863620404080, 
0.873283964042873, 0.952650389436661, 0.93032913302684, 0.937433317839173, 
0.944087930494125, 0.892509239222284, 0.949830728674926, 0.959066932514274, 
0.937457089764898, 0.92757245104545, 0.945846326202348, 0.908683112609492, 
0.931168937827162, 0.965327542826171, 0.923921277581888, 0.943662929715106, 
0.949360379896295, 0.907210667682694, 0.912300903722573, 0.942986005038353, 
0.941426378067442, 0.922258920979406, 0.954082647821511, 0.962979764589816, 
0.929282285427257, 0.931977523426284, 0.926318307427248, 0.940716590921243, 
0.926488508138777, 0.94906538183619, 0.87381531170745, 0.959267937851298, 
0.935557569267204, 0.959263833214639, 0.905488706430865, 0.950887406928634, 
0.890938297727987, 0.924454949888657, 0.962441497232673, 0.932735131204355, 
0.892093810957591, 0.950971267706552, 0.92236942891157, 0.925114501929705, 
0.913676742248955, 0.959353358524327, 0.896320769081094, 0.939659784627696, 
0.931072693649933, 0.882791354023874, 0.897470728727932, 0.892445520122286, 
0.932853960233294, 0.949128950139337, 0.913554091472594, 0.955464194294404, 
0.943149538335674, 0.949418579681702, 0.945030905877268, 0.927378763624243, 
0.925932408844719, 0.93421088201121, 0.890731883243732, 0.92505003000066, 
0.919484768304835, 0.936813888122012, 0.956338208390416, 0.966929836555026, 
0.953231966606567, 0.919822350332905, 0.936453430474566, 0.946009256151523, 
0.947488039333942, 0.962352697076105, 0.895192576972026, 0.955867862134298, 
0.935831402923098, 0.920746159418662, 0.911011199393202, 0.94735615279643, 
0.932008769603341, 0.923482524607457, 0.950382824650836, 0.9516297181721, 
0.926076046011334, 0.955539639338016, 0.958955244464475, 0.898957930635457, 
0.946849758081402, 0.934744141373571, 0.882789240125876, 0.918153427803588, 
0.968052948685144, 0.933466749918748, 0.915677717553784, 0.945876311491517, 
0.919571336545941, 0.961932604873003, 0.92410439078261, 0.904351807024828, 
0.92366773582748, 0.951770775383731, 0.913318223192786, 0.916488511974022, 
0.946521105744042, 0.899450440663002, 0.89905589325107, 0.906556170068973, 
0.931917205786962, 0.952259469021016, 0.942198569211985, 0.916538672163465, 
0.970011229483632, 0.899975615046937, 0.947481585917066, 0.896702644050005, 
0.905177841592302, 0.915604656736902, 0.917850037091342, 0.937879467919334, 
0.895948606012828, 0.926547487243551, 0.916228837017805, 0.93351816546569, 
0.923018181236216, 0.907695454414608, 0.940870302534032, 0.916246238926267, 
0.94086590971965, 0.948805947406683, 0.963043603744554, 0.953746550207496, 
0.866224855435678, 0.909599586953831, 0.942004976768523, 0.936054284498528, 
0.876774849014647, 0.94470543644087, 0.896719802825575, 0.944976078744711, 
0.913276115127804, 0.92584444545779, 0.919206367951944, 0.915554242060162, 
0.948536748429226, 0.942726327636574, 0.979970696618586, 0.918128901073598, 
0.921824195265375, 0.960946131797664, 0.892743690637763, 0.971310071711279, 
0.934811233969472, 0.969027643995596, 0.949323772879905, 0.905685351500493, 
0.896008522085683, 0.87269998033783, 0.933414642820837, 0.958062279386067, 
0.94898351107216, 0.917022334251826, 0.931549910504301, 0.915509518937207, 
0.9264639336443, 0.885642092858528, 0.93635015040465, 0.949290977322608, 
0.93911663707009, 0.91110127206194, 0.919590267556333, 0.956189265348663, 
0.955464524967618, 0.916483632226985, 0.908542829921039, 0.932753862481719, 
0.918000021662333, 0.95541766506426, 0.920367646944357, 0.943976930257873, 
0.957712600924667, 0.929508485270816, 0.96304246692934, 0.931992648484723, 
0.91276839753285, 0.93401899913029, 0.959967376542113, 0.931522549475861, 
0.940937498336747, 0.950731582777145, 0.939278809864793, 0.95921000573762, 
0.967529951292071, 0.950651404826993, -0.938040752312962, -0.95797708326426, 
-0.959811482945274, -0.937828041037939, -0.947780911218512, -0.913895656658106, 
-0.925924393620367, -0.947511646311076, -0.939668203022775, -0.949529232901896, 
-0.953737624009876, -0.96163675118914, -0.970155952415442, -0.91652037027236, 
-0.961336110068303, -0.931094215801936, -0.953415407610876, -0.954679122136816, 
-0.929667123176122, -0.924584228634903, -0.934985269491561, -0.945231786521753, 
-0.937736307200827, -0.941358874199523, -0.946318350150928, -0.92944279902574, 
-0.953945854863708, -0.943999240911746, -0.96072183823626, -0.922968283229385, 
-0.919906089477438, -0.933086218793398, -0.95493545127167, -0.962346544961618, 
-0.95526957868670, -0.948440421122897, -0.95083325563319, -0.955115321684792, 
-0.935209943177048, -0.962259806743223, -0.941544200264907, -0.932518137355318, 
-0.933211413753422, -0.943094299262406, -0.956748114968368, -0.921455186119918, 
-0.929623518490513, -0.948679560554573, -0.960194189754184, -0.956488961241613, 
-0.940990275440244, -0.941152369683893, -0.951363883705366, -0.941580373847563, 
-0.942368473794643, -0.967028087257031, -0.967666817551364, -0.934014434372166, 
-0.947658393627302, -0.962436381775899, -0.945397102776742, -0.967280377007134, 
-0.955443986090203, -0.915230208255786, -0.944524878274985, -0.938205185692775, 
-0.951930674365082, -0.941939335311374, -0.944360084186023, -0.957580070881491, 
-0.953111538319119, -0.965786434780779, -0.947146022482732, -0.964943601387415, 
-0.950173875101194, -0.93740451431146, -0.942799601335035, -0.96408193169974, 
-0.930729969794144, -0.942859764875786, -0.948576363910843, -0.95293051927585, 
-0.956500345801697, -0.955911680321712, -0.93103831403603, -0.943016151958004, 
-0.951263461745764, -0.960301095765419, -0.943695386710518, -0.959180836426677, 
-0.946774921367194, -0.950817839253463, -0.94208391947732, -0.945808608500122, 
-0.959897357013148, -0.913204191456722, -0.940654256598153, -0.917124462929978, 
-0.913539726569002, -0.919599750179892, -0.954278787761547, -0.913001735172125, 
-0.961691468221745, -0.943114512398234, -0.940610000509387, -0.932625576347246, 
-0.934843707262099, -0.952033080501228, -0.952228246862257, -0.97531948313525, 
-0.941791134269058, -0.944052095273223, -0.945978534920582, -0.93515268315626, 
-0.944570559540402, -0.936765903071941, -0.938608016678627, -0.937616194971641, 
-0.940867518675968, -0.935963557000668, -0.946626280152652, -0.95406827244763, 
-0.96377136182262, -0.957700637846216, -0.953937610103107, -0.922731140226207, 
-0.954497944657128, -0.975420943311666, -0.948194688574994, -0.945753546006694, 
-0.945678316925334, -0.968134035235093, -0.9439712571514, -0.941622976428294, 
-0.939675045720733, -0.951717809850334, -0.945975252392448, -0.950368016855428, 
-0.964356192809472, -0.943447785760642, -0.937772139494298, -0.949401338626355, 
-0.927715610780428, -0.964659286604692, -0.932628902416744, -0.938910157995018, 
-0.930835436287769, -0.9415126860148, -0.940409661465053, -0.944947610545748, 
-0.96007479057439, -0.964627020329609, -0.934522670917703, -0.969598680217183, 
-0.954452398686137, -0.934686957370513, -0.923308689687755, -0.925644941787716, 
-0.952750697491796, -0.926589349346532, -0.953448315107602, -0.931741999584344, 
-0.939712446302435, -0.951987991650894, -0.947682796110419, -0.936710727795613, 
-0.9625963419336, -0.937169222157472, -0.96012760253358, -0.968566473798866, 
-0.93926381674970, -0.937645038914883, -0.966849129754167, -0.940412605610681, 
-0.951180695214084, -0.95955680314076, -0.955612197171309, -0.964574756010387, 
-0.9381223474133, -0.938041748323116, -0.936971827488755, -0.96003058543059, 
-0.942638538775598, -0.952550462197386, -0.97175784915468, -0.924805788647898, 
-0.934985756794618, -0.926747133353912, -0.898187468000165, -0.941220306308193, 
-0.943484474337317, -0.973317215321933, -0.9398824825592, -0.886057116326093, 
-0.945474267056416, -0.943793485366548, -0.964559156253912, -0.937954459777369, 
-0.938155386521176, -0.964139855518293, -0.928300806402954, -0.948681113452196, 
-0.942261135194396, -0.94367672147132, -0.918011863367903, -0.955154844380529, 
-0.96676221059201, -0.95260862826863, -0.945168840688087, -0.948371486466956, 
-0.931558441876349, -0.941224347566527, -0.937702112736597, -0.943657434713696, 
-0.945172620453088, -0.942551858921846, -0.95068284420467, -0.945020818309425, 
-0.947978370048029, -0.957103403857873, -0.896181990014763, -0.937445648245458, 
-0.954561077379696, -0.926555365137966, -0.916244132314647, -0.934117738723391, 
-0.952616628847684, -0.952754637147576, -0.93000386309549, -0.953838847588308, 
-0.95554218811381, -0.938859528660967, -0.944681736823614, -0.952810931667266, 
-0.956330528988133, -0.95612111338469, -0.946050825694786, -0.956981733972284, 
-0.946866087068916, -0.96456656692371, -0.94007461170166, -0.947862262924646, 
-0.909069086408757, -0.956089979184159, -0.93693059354471, -0.945133447502726, 
-0.943476282997637, -0.900702473699454, -0.950639715946223, -0.96505826495416, 
-0.94309386741594, -0.946050835211321, -0.960288656172481, -0.926076786211306, 
-0.892387780882695, -0.958938182828306, -0.938841153269694, -0.9421251588247, 
-0.957658241376164, -0.965406379105955, -0.9379326104819, -0.9216603592243, 
-0.943852114332112, -0.941783613794043, -0.943567582865755, -0.941151371414167, 
-0.952750479893308, -0.944388181490819, -0.945144097391047, -0.933473739020048, 
-0.944102942846683, -0.95121027264169, -0.94896151281280, -0.935326372285682, 
-0.964725485439472, -0.938308601211927, -0.919310359854878, -0.94372802025515, 
-0.955119343588357, -0.94207803435937, -0.962991270714488, -0.95214082771862, 
-0.942847277301656, -0.94617158152995, -0.928261455806124, -0.937178733752683, 
-0.95340602328322, -0.959842518978427, -0.946261445909375, -0.953104272494945, 
-0.950405418748462, -0.955712261859274, -0.957656303999332, -0.93182873403124, 
-0.948691576843908, -0.937952503757197, -0.958899782928263, -0.950677574333855, 
-0.946064598305439, -0.934163796894187, -0.936861167332317, -0.950773888531506, 
-0.952350751131918, -0.938132092103456, -0.956346618993662, -0.948804015247025, 
-0.9325961777235, -0.921791247370343, -0.97652025285214, -0.91305417527906, 
-0.95378213480716, -0.945285718410288, -0.927685450606191, -0.942019963707577, 
-0.938948251167491, -0.96011044889729, -0.961666405970184, -0.945595046381227, 
-0.932396080271526, -0.965778544591327, -0.954529354049536, -0.944762393232813, 
-0.938091795982806, -0.967450066380652, -0.960263747614835, -0.937728921675703, 
-0.970280842112474, -0.949413031850007, -0.931543405449909, -0.945848541584204, 
-0.96179315037058, -0.930701381943055, -0.94478531543571, -0.964543015193339, 
-0.943976924969694, -0.960229654222355, -0.929989019524678, -0.923554190721468, 
-0.97421444812267, -0.953232823470324, -0.915837793355476, -0.916787380157182, 
-0.93833198535123, -0.953327072772851, -0.94933180013529, -0.954802786235024, 
-0.952985848631734, -0.95158623874847, -0.937491046940984, -0.972282493960497, 
-0.96006422013864, -0.954097241458048, -0.950648583592352, -0.949066901058346, 
-0.965996768800344, -0.952752834891512, -0.957633479303067, -0.96034526063473, 
-0.922016008458009, -0.949232561633433, -0.950989060477543, -0.94255090171202, 
-0.946867645569976, -0.970535781724562, -0.939787386782837, -0.944536872763822, 
-0.948829092555112, -0.89637581302798, -0.97380997403378, -0.96305528894055, 
-0.962989487632044, -0.939200633354837, -0.950177217740855, -0.94543029050774, 
-0.942684303620854, -0.947766853025758, -0.939031717895703, -0.920649710069255, 
-0.964040676379132, -0.928530199414192, -0.94708531750258, -0.941579264397791, 
-0.94068610525288, -0.939095744493613, -0.95510485491039, -0.947595530605468, 
-0.925401336290648, -0.96295514363045, -0.95215180116772, -0.92712017579329, 
-0.931304819493687, -0.95467046403014, -0.963855030793021, -0.95841414886778, 
-0.943213417058067, -0.926341287400955, -0.951966490089865, -0.964470113994683, 
-0.977666658061185, -0.937671982264908, -0.944618536478506, -0.952562567569792, 
-0.939965085211865, -0.933248021021987, -0.937319190402396, -0.958311420489383, 
-0.948924059423918, -0.948839341568452, -0.963389647719191, -0.948023655673213, 
-0.93889035603689, -0.934507147850906, -0.930612531493604, -0.937526152287808, 
-0.918313650917388, -0.948403007038265, -0.949287443109784, -0.941866713368272, 
-0.9498618718126, -0.94959369545268, -0.945033714453351, -0.933211288852862, 
-0.950239612915598, -0.930725292730095, -0.958244133847241, -0.940991338963852, 
-0.962627572917505, -0.959903947476111, -0.940266739968598, -0.922577224884329, 
-0.940967593694193, -0.943619473947707, -0.929940677804725, -0.96135543289608, 
-0.940285651199156, -0.944525077723837, -0.936594068620337, -0.958141256086195, 
-0.942149569421205, -0.956116865684082, -0.920518246996876, -0.947080595372907, 
-0.940895438259167, -0.946378881548896, -0.953788197592045, -0.96004932675595, 
-0.952042481023085, -0.94478110507411, -0.947824116329213, -0.930144065123746, 
-0.92983775023279, -0.94282908576751, -0.956772796909243, -0.944441591543694, 
-0.966982241365803, -0.945794985593305, -0.948190174519696, -0.967616536493578, 
-0.95100647252889, -0.946754432140769, -0.963196522678547, -0.949919960659237, 
-0.956390133488238, -0.936777419690434, -0.979488462534502, -0.930240309105064, 
-0.947120953006141, -0.939614941376049, -0.94615245580648, -0.932065232136115, 
-0.928456228562338, -0.95019877011909, -0.950175929841221, -0.956832396574044, 
-0.969475744657415, -0.939887032152931, -0.951068578953401, -0.958793264566017, 
-0.954400628128037, -0.966911743412878, -0.93618527187335, -0.933106792296276, 
-0.963635823145086, -0.969814782752871, -0.953715340975696, -0.907244333604929, 
-0.939365750500294, -0.960394203023286, -0.967209964601854, -0.908915876635657, 
-0.950999175854564, -0.929068548688879, -0.949636808446578, -0.94434324342503, 
-0.959107351376047, -0.956251013507228, -0.937728492349954, -0.943124885126436, 
-0.960978577036725, -0.968816937797543, -0.940951609663892, -0.96298473899843, 
-0.936253881558566, -0.927042558227166, -0.945308065755762, -0.929543179383254, 
-0.970732587965728, -0.95462461751289, -0.939637184055006, -0.94236141627358, 
-0.906966246200104, -0.928635735311447, -0.968977270753906, -0.920698178491478, 
-0.952517061092894, -0.967853159318639, -0.931343607812887, -0.961721521742207, 
-0.943994169014866, -0.924145380042785, -0.948249415939872, -0.964484529561109, 
-0.94264003048919, -0.944683118377496, -0.946197411140722, -0.944184953378334, 
-0.916658987842393, -0.94483857161065, -0.927417098173047, -0.925687504405575, 
-0.924761195923636, -0.957450328011776, -0.93358826340946, -0.938217064138063, 
-0.956573733936821, -0.935375900473581, -0.970367091085646, -0.963342708463486, 
-0.95169609013032, -0.934155678779902, -0.93319720946516, -0.96264079643616, 
-0.957912015292815, -0.954021220969608, -0.958103826294114, -0.957379619722571, 
-0.964324473673082, -0.951639992354401, -0.955658320561302, -0.948615893345006, 
-0.936284816429099, -0.943381481596771, -0.955432551526254, -0.939431819273545, 
-0.973875266180004, -0.943821316350156, -0.947971102266906, -0.966998823115389, 
-0.929823372661562, -0.952696226337323, -0.955417719932647, -0.931575448876884, 
-0.945715936617993, -0.96404018713781, -0.954005881871245, -0.95733414497425, 
-0.971954226023556, -0.937990970544711, -0.929816343315618, -0.967744776859085, 
-0.931006021602062, -0.926894472860631, -0.922635156526043, -0.956653073819818, 
-0.962223749924841, -0.947439198495215, -0.962332786688332, -0.951649707221771, 
-0.944216583103688, -0.94272123712782, -0.948401122851357, -0.954412448606204, 
-0.965253487490858, -0.945597488875626, -0.934807234168416, -0.95344161462529, 
-0.941759834695927, -0.961726882663215, -0.942186157212646, -0.946785066798804, 
-0.93971111919622, -0.9431673648606, -0.928487897450643, -0.955998157894718, 
-0.939565362648733, -0.944661442604041, -0.961881819076065, -0.93554549393732, 
-0.966393917695693, -0.940619317877966, -0.926563903314029, -0.945424020157996, 
-0.964414100700107, -0.949075326033876, -0.940999077428012, -0.969666052971335, 
-0.939400450926655, -0.966008228630825, -0.936343715074648, -0.946301443334639, 
-0.940765102824801, -0.942263597946746, -0.935944263825148, -0.97507317042442, 
-0.963469000015063, -0.96105467798124, -0.936197177283719, -0.950737013372766, 
-0.939167538756751, -0.945673949958147, -0.9196836974446, -0.972725557803506, 
-0.964601244621027, -0.938748356251682, -0.93904839749458, -0.970948612403314, 
-0.923680357357424, -0.964579249665507, -0.93248160842826, -0.955463363274322, 
-0.947489610007242, -0.95004697758158, -0.950245274906993, -0.951551671653514, 
-0.938377861378447, -0.943164043078811, -0.958874060236838, -0.970137189968003, 
-0.957616944492455, -0.928090890278568, -0.93724104576087, -0.965596335610942, 
-0.947479974667108, -0.967883711889506, -0.94778392250611, -0.964136783811532, 
-0.962617058246658, -0.94840728133446, -0.962085990124643, -0.905880944645295, 
-0.960121248103888, -0.95829204248214, -0.96830705008165, -0.966640561011545, 
-0.935796251393428, -0.954411637379913, -0.909597412724383, -0.95373948523216, 
-0.940947276900349, -0.946364785290628, -0.944652397601642, -0.955311737059116, 
-0.914741714601638, -0.959098518483177, -0.957022438722742, -0.960537321768963, 
-0.96946828622804, -0.943320690023317, -0.955196059099743, -0.95476164607645, 
-0.941834274273487, -0.93484077348723, -0.943733158715931, -0.936189719268736, 
-0.924098190381227, -0.959523228890746, -0.94740961419277, -0.966936673178406, 
-0.950268609025383, -0.931149304021733, -0.933822144759038, -0.915167653366975, 
-0.931307120566794, -0.934748599099985, -0.966233191463468, -0.933846700328192, 
-0.964930199511104, -0.942106545651244, -0.96295645728259, -0.943141396617958, 
-0.949727975364943, -0.958045499265582, -0.960161777864994, -0.945466812695842, 
-0.950449080474536, -0.949377097559445, -0.954634068986014, -0.967006283870457, 
-0.969802886613817, -0.941838754787175, -0.943977619218697, -0.924647228108708, 
-0.913818732108278, -0.962006699251171, -0.925542392208062, -0.955960590583823, 
-0.971013618227973, -0.944517970772094, -0.94327263467394, -0.955841370910965, 
-0.953493061926353, -0.964186636668935, -0.972150723522915, -0.927536178045604, 
-0.945072954506395, -0.932068082731819, -0.977718324702933, -0.941598717947472, 
-0.947303630291477, -0.954256461107527, -0.930637955129285, -0.93552477760338, 
-0.943532858428919, -0.962913693115154, -0.922413538007629, -0.952915984985353, 
-0.95323250034948, -0.936432622137991, -0.948004765357523, -0.963898975238674, 
-0.936209078583619, -0.942829351786796, -0.937449273830113, -0.93889103642027, 
-0.905779246723013, -0.930377904357327, -0.915481574077418, -0.938947769957236, 
-0.922479384322551, -0.965042165382559, -0.952356217564219, -0.95954383479892, 
-0.91553453453679, -0.947513103599993, -0.952389847409407, -0.962013099111542, 
-0.968024936288421, -0.931482980504736, -0.9492531854451, -0.944118808067152, 
-0.950725240102232, -0.96070054530006, -0.946098644900074, -0.919496851694482, 
-0.949052194032817, -0.929428181827616, -0.960296949096775, -0.94233051676139, 
-0.940026318743722, -0.941405202859687, -0.946730513116088, -0.968318408669312, 
-0.950369924052446, -0.949827441014876, -0.935656393376514, -0.950163096278015, 
-0.935285220904256, -0.951477686973597, -0.950715467724377, -0.944926820817063, 
-0.916917229953829, -0.934222945883898, -0.953957063428637, -0.939881382128805, 
-0.924417072092177, -0.933799670909425, -0.955261940111747, -0.934743975111248, 
-0.965299750354167, -0.954117419906933, -0.949534291297575, -0.950862335843638, 
-0.958155847708813, -0.932743412588535, -0.925117902776366, -0.940619057492655, 
-0.954618987832277, -0.939154784282426, -0.95567670630137, -0.927921672985218, 
-0.95055820347044, -0.944293913245105, -0.948735780049912, -0.958366893664822, 
-0.956967111051715, -0.944033493672502, -0.960008096792408, -0.950393399778946, 
-0.96317770986594, -0.951500799686157, -0.94826452482686, -0.94115017400761, 
-0.949703271452695, -0.950449452012792, -0.95138794306105, -0.953180726226167, 
-0.951281597276324, -0.891325755292946, -0.937874390035803, -0.939699372106388, 
-0.950027491870033, -0.95043644253159, -0.959807962611667, -0.942541651553, 
-0.943970691080046, -0.943577933150917, -0.955867439909686, -0.944761720553108, 
-0.945815685045236, -0.949641773942066, -0.940315549337156, -0.963319152617966, 
-0.966937091321101, -0.952829824870072, -0.967278791591155, -0.92649351278879, 
-0.956703137367532, -0.951174360098776, -0.950450469505172, -0.954360551481858, 
-0.963151655322439, -0.946566577488605, -0.941659987507946, -0.96198995384578, 
-0.94266305766615, -0.944141563776789, -0.948773852654698, -0.94196661960767, 
-0.95541555783707, -0.947556932475475, -0.95181810473271, -0.94471501563211, 
-0.95026225135104, -0.951610195984572, -0.964638763708143, -0.96709467192315, 
-0.936920877003762, -0.948186543225786, -0.953456302617358, -0.96457179680296, 
-0.964281122198322, -0.9298523711191, -0.935626047115958, -0.945643002889375, 
-0.936564785411528, -0.939056327005572, -0.941746171817942, -0.952720825566366, 
-0.94035052662911, -0.9675840401366, -0.942139497768328, -0.936346325980014, 
-0.943828289065846, -0.954779840830073, -0.928142675884896, -0.954447296395855, 
-0.9511765603084, -0.945420971832463, -0.964963891126764, -0.950272771458308, 
-0.93501411016486, -0.939052019401795, -0.966471571726353, -0.966063616631745, 
-0.939545994101622, -0.949638281318462, -0.95561531633991, -0.9723651106414, 
-0.942228682182404, -0.938602176047911, -0.963415501294661, -0.954507848618993, 
-0.961553033566154, -0.913776479685677, -0.938765398915134, -0.927606700768581, 
-0.920804748882583, -0.962122201738859, -0.952296123418155, -0.916779640899289, 
-0.912374495463775, -0.9499991569529, -0.936873923138602, -0.945403652142136, 
-0.953565636135827, -0.943227370070983, -0.96312683144559, -0.932181619030643, 
-0.958263938389792, -0.94169080099328, -0.940976178095066, -0.92871091190065, 
-0.948276468939798, -0.949252631431663, -0.951354039948432, -0.947964858285877, 
-0.932527491993106, -0.96021921004602, -0.969599095886212, -0.959016181596418, 
-0.9597388700599, -0.952001077377175, -0.956692705607946, -0.94907964764684, 
-0.969196325201877, -0.943935179570903, -0.961008558513931, -0.953157231088948, 
-0.955679165133204, -0.912690980574813, -0.962395740932375, -0.958503931945029, 
-0.967247852927229, -0.961210199319297, -0.956398256617569, -0.949553370577036, 
-0.935342589559226, -0.954210066652725, -0.928959325704517, -0.966589972090526, 
-0.965582349697297, -0.940832583316438, -0.955787784751728, -0.937067392795186, 
-0.895210566375246, -0.959102742299985, -0.94100580368507, -0.955045095626799, 
-0.931806246425974, -0.93763262780961, -0.93213591414495, -0.930577391051699, 
-0.960474052410731, -0.977400568337567, -0.961482986334114, -0.945986444138606, 
-0.949236050195653, -0.962483355345264, -0.927819839324002, -0.95522184934188, 
-0.956082192917778, -0.954489814141687, -0.943353676382085, -0.951245437453173, 
-0.95181871521956, -0.957951568247094, -0.956184536816568, -0.96863303515191, 
-0.971114274461088, -0.954303915295775, -0.94093156225714, -0.950470274950552, 
-0.957387540478434, -0.951594008222579, -0.940453750251445, -0.923934869259012, 
-0.960523208825531, -0.918838040567704, -0.942618079929968, -0.96038571406721, 
-0.950008524260366, -0.936374865046224, -0.949134951886815, -0.92304908665735, 
-0.937436268985848, -0.95326979680564, -0.932321491898747, -0.952840437754014, 
-0.960337947415709, -0.97138971834529, -0.94076906762336, -0.958844950814866, 
-0.951171080606492, -0.953289045642498, -0.940273663854515, -0.95870529489435, 
-0.944206080901045, -0.929909482788272, -0.942518906259385, -0.955143453268315, 
-0.972287106724939, -0.950202015719797, -0.94818818969556, -0.948211733301033, 
-0.936770674467423, -0.919270536415062, -0.945834011894648, -0.956529231952615, 
-0.937889282175075, -0.934299946212764, -0.887311903043937, -0.876743556509637, 
-0.901903313908546, -0.867898682275485, -0.892480907384378, -0.881466826414484, 
-0.855664589156374, -0.914833461659754, -0.876276191036886, -0.892971519379188, 
-0.923112058798513, -0.90052549048447, -0.82127085166364, -0.867202334408554, 
-0.856729690127364, -0.916897510597576, -0.871124982084517, -0.89118696013952, 
-0.887445228205042, -0.90915062330774, -0.888660007938997, -0.876818111883959, 
-0.90196456881216, -0.900699104896049, -0.857283316308798, -0.916661756804454, 
-0.887356789227179, -0.858957313920543, -0.899673825232113, -0.888909887883088, 
-0.861582920713399, -0.89377348895971, -0.870691482642805, -0.869533358907346, 
-0.9391408530481, -0.909085620980214, -0.90107415332484, -0.903677654541398, 
-0.87338752284383, -0.868132194408278, -0.881366677128733, -0.908596631546604, 
-0.878536862576684, -0.88978357310383, -0.913025962705408, -0.885627027053257, 
-0.887510039332295, -0.905852531269644, -0.905824801584261, -0.880861509601384, 
-0.90521334361723, -0.874790721009255, -0.880055317132355, -0.878368591650625, 
-0.904914127632556, -0.920541499720642, -0.884392828251826, -0.897282121490013, 
-0.852492153561418, -0.908975434536422, -0.868322506389188, -0.91104186718122, 
-0.864375665017056, -0.88155089236413, -0.88574469462989, -0.85646073452305, 
-0.924382630664, -0.877351876866062, -0.84613249864415, -0.934396659948981, 
-0.9024331876086, -0.900731205300839, -0.93159890513157, -0.87686197961461, 
-0.857427066906384, -0.887573143029879, -0.887484820671629, -0.9280283537506, 
-0.919147800674298, -0.885010882560034, -0.91078532918327, -0.902550730839418, 
-0.938891101342468, -0.919655296181508, -0.882798056991274, -0.924856864955254, 
-0.9029266219856, -0.878109342555062, -0.90730433862617, -0.901618486626951, 
-0.851058859565464, -0.894819762033638, -0.902190376010218, -0.8912257712772, 
-0.863957988785311, -0.894710337418325, -0.929968043519545, -0.881954383217041, 
-0.86206014855586, -0.911828526923213, -0.847337261977437, -0.87371746866804, 
-0.852569314050181, -0.895377546675907, -0.905639479571598, -0.888852925068442, 
-0.890321914311853, -0.860678104940078, -0.878024563194751, -0.863641818360195, 
-0.892010909022181, -0.915643509715504, -0.895095712535581, -0.934672712091645, 
-0.855562214463459, -0.918978268908792, -0.926237861395564, -0.889828104882895, 
-0.915935213458073, -0.918482271054396, -0.88764700047698, -0.882049808274615, 
-0.853179437377006, -0.958067336273866, -0.871926522072187, -0.865696562633997, 
-0.923369704252854, -0.863196089441838, -0.916083935219834, -0.862444562135822, 
-0.883427521123643, -0.90759264067508, -0.911930337067143, -0.886562084874384, 
-0.903978128031844, -0.917681153347823, -0.919498106225934, -0.91190960959976, 
-0.934536489832685, -0.849938081020043, -0.874897540675292, -0.883971461691862, 
-0.902835052093866, -0.938853648587037, -0.852736133157632, -0.880182527367875, 
-0.881461347810118, -0.880525033587256, -0.90843138490676, -0.869012719424356, 
-0.873503504302558, -0.904331910582223, -0.91672526195983, -0.903451348499857, 
-0.888064816776844, -0.865901272546794, -0.886010991957922, -0.925128928234595, 
-0.89989240286178, -0.924056972682321, -0.877339250345059, -0.923793725606167, 
-0.853206254892746, -0.85056906473403, -0.933240643980379, -0.856638509969746, 
-0.920406085095223, -0.900920824364344, -0.902396474966866, -0.880602332820907, 
-0.877302014190183, -0.91114743444457, -0.863701842936694, -0.896115031871686, 
-0.843657812030747, -0.896373412408702, -0.908049818040803, -0.911929798183689, 
-0.906443324319833, -0.910798498408896, -0.933009152085463, -0.905441041756038, 
-0.896582847194046, -0.898694929434277, -0.897474896629322, -0.913694311307194, 
-0.873548104631209, -0.878531522081628, -0.837152123419657, -0.927786102017743, 
-0.898312238856618, -0.92303353427807, -0.89150648394546, -0.895795442662921, 
-0.872590950817283, -0.819986675002002, -0.858764105813431, -0.874062781944372, 
-0.853446917960041, -0.915955298328972, -0.871395990895143, -0.89517232746458, 
-0.871027486706513, -0.909965434418354, -0.910429989585192, -0.8980534324561, 
-0.889045683643678, -0.851704584556078, -0.912295877718747, -0.914463633586411, 
-0.883148751384267, -0.873470679659047, -0.868864559477959, -0.856939913165634, 
-0.879528232452802, -0.928840399396656, -0.8965598585704, -0.854937791434488, 
-0.897135205697145, -0.887133060257837, -0.857194937241883, -0.899594019482572, 
-0.911473580442375, -0.872584735019224, -0.86269585938925, -0.872182561482598, 
-0.901013219641718, -0.872498424580128, -0.873526757192942, -0.920591231305684, 
-0.893215521148994, -0.881836782647064, -0.89459485978972, -0.876652775674785, 
-0.830571669362225, -0.895024226793028, -0.93356833137302, -0.898441434270544, 
-0.873074396426579, -0.919936609223787, -0.896150700622936, -0.880351646265893, 
-0.911551833312333, -0.875826552058058, -0.907833058421543, -0.918561300113423, 
-0.871899390912427, -0.899799271718973, -0.890355821318712, -0.93389235102904, 
-0.896496125149121, -0.824609973850695, -0.878858397677119, -0.881350126037454, 
-0.882972552845955, -0.905789293808162, -0.889664606348892, -0.909727371227815, 
-0.843707910248616, -0.909053495494704, -0.860032799086277, -0.878617666669051, 
-0.901012178186407, -0.891508934841928, -0.882563996688262, -0.886900117949979, 
-0.862993974365431, -0.8794777779668, -0.939151880231588, -0.900193654372835, 
-0.918481423989895, -0.907064112704801, -0.896350486865829, -0.850972728651046, 
-0.857522596051842, -0.912820677082492, -0.932019334712051, -0.897965094352561, 
-0.903276918192966, -0.905192489779293, -0.880983123691802, -0.90185138182718, 
-0.859695735439678, -0.855551147243238, -0.910949547425094, -0.884776715181306, 
-0.90751177352479, -0.836765159010287, -0.8822807085653, -0.912554734636973, 
-0.889384536994834, -0.881092212483728, -0.90528207873583, -0.909453251430822, 
-0.934175037149196, -0.930423708680602, -0.857339847070669, -0.88170041850399, 
-0.924947747816706, -0.848636410161133, -0.862091015360932, -0.903067617691422, 
-0.893485427104068, -0.898826395450167, -0.942454000118483, -0.884661228273278, 
-0.905425984748527, -0.88912951898687, -0.905886377875705, -0.89026803160082, 
-0.88521221975385, -0.925494219291959, -0.912520906524656, -0.894684293514598, 
-0.886278245135343, -0.898220951845876, -0.90207009917442, -0.887150735104658, 
-0.873619372169134, -0.861355159893528, -0.926210071928947, -0.875815746704506, 
-0.915928806905652, -0.92033708429416, -0.83844774585585, -0.891594281789509, 
-0.884124836567992, -0.931470997751615, -0.86979586068668, -0.878451820123855, 
-0.86968377360171, -0.89958818974859, -0.885630134306812, -0.877390190556066, 
-0.893024004107949, -0.869087929262232, -0.902709284072859, -0.934165673993778, 
-0.948471785995434, -0.866458207228788, -0.902395668023048, -0.915213677993955, 
-0.882838908173736, -0.878097441546073, -0.89974123361439, -0.923017866513197, 
-0.867878125653543, -0.877538946114896, -0.898523667896618, -0.890283439753647, 
-0.938087040435434, -0.88021023815736, -0.897600183522051, -0.914351310156223, 
-0.863335221815014, -0.931342390760417, -0.85556362661391, -0.853404992673988, 
-0.88540311550311, -0.908219670264017, -0.876057811319634, -0.87935725767764, 
-0.860157765169035, -0.83870718423649, -0.902577468185395, -0.886938476194706, 
-0.874487601434186, -0.892401703029687, -0.879748655746646, -0.879684837322296, 
-0.850797853567719, -0.898988807386147, -0.85775071370906, -0.884423227400749, 
-0.870589514843162, -0.905816907591911, -0.910691033715209, -0.915228349991333, 
-0.930010810147486, -0.874433933158047, -0.891210566754795, -0.915582871405017, 
-0.908466709591653, -0.899294575499667, -0.926181353952154, -0.889976861630609, 
-0.86289090212298, -0.873658541311686, -0.902029902385335, -0.878042664028019, 
-0.904314297700945, -0.892587433963712, -0.884546497624363, -0.88736348497461, 
-0.910509940892716, -0.822235830854522, -0.907218996823727, -0.907528721206456, 
-0.92496493497768, -0.873745727304678, -0.868766248695285, -0.90302428613627, 
-0.863390873872774, -0.901776015489775, -0.899632067407486, -0.902501231897508, 
-0.87773107267382, -0.868364562486181, -0.936855235675053, -0.912030492617594, 
-0.920176240565177, -0.880132961987256, -0.901404797929189, -0.92555238555763, 
-0.889777141533355, -0.867731188579694, -0.8801570452666, -0.926715033247485, 
-0.893861729874828, -0.896360991371885, -0.897485561358704, -0.921252858446117, 
-0.894861148669939, -0.87137477235489, -0.89141299172084, -0.886318918010036, 
-0.894135398649172, -0.909094590909273, -0.863411057371762, -0.874813474601484, 
-0.890723498852043, -0.903137652523002, -0.895354002242926, -0.898006892868744, 
-0.88832176636417, -0.885319125897453, -0.925686926894212, -0.877433167795611, 
-0.837846302350217, -0.894980620265995, -0.90340923482305, -0.868572877948152, 
-0.925373547264057, -0.899298349997563, -0.879677450813288, -0.929505795990237, 
-0.922420979891116, -0.881383134326272, -0.881099162888275, -0.926094023044219, 
-0.856016905449086, -0.85422436235332, -0.892705037065607, -0.892400006108054, 
-0.908085378180623, -0.881580036525344, -0.877848847369411, -0.895128428925409, 
-0.882665746130680, -0.883864226588176, -0.909735908990553, -0.881733842065829, 
-0.890632725187465, -0.878028728428058, -0.919485191887299, -0.870904456329469, 
-0.871563684064609, -0.90082390621275, -0.90772077201914, -0.883202954485566, 
-0.851286383158778, -0.88034476104024, -0.888562022463066, -0.887368551909124, 
-0.896634784877871, -0.906044725529255, -0.886140452075378, -0.87398050042407, 
-0.881899963826628, -0.90155531806574, -0.874792414057936, -0.903484177669668, 
-0.90857805508497, -0.872940404269037, -0.878985998593927, -0.883377814014066, 
-0.842270797350551, -0.903868695096927, -0.911849464638227, -0.929227177230986, 
-0.913584286783495, -0.893669897767385, -0.846838769397785, -0.867406954550595, 
-0.857236914482652, -0.891831179129034, -0.903855794524639, -0.863219594747612, 
-0.870074883212683, -0.91530101820232, -0.865255559408192, -0.899327630075315, 
-0.856201252947569, -0.902763020298647, -0.887782711335689, -0.890350965487595, 
-0.878754205418696, -0.892619460315034, -0.883576674373068, -0.889965762348228, 
-0.85867215252593, -0.862820557053665, -0.912223589709243, -0.888005924782173, 
-0.905490335574048, -0.905151915718528, -0.906813817169179, -0.887988003307478, 
-0.918203598848806, -0.888348695437046, -0.906643439163756, -0.883596222914074, 
-0.877563143320335, -0.859137332800433, -0.9022046393361, -0.86483524430475, 
-0.917366902432372, -0.875267286366176, -0.918624074241157, -0.883081287938397, 
-0.898799627532704, -0.904215348272274, -0.885606766787875, -0.866982174843544, 
-0.905970810824356, -0.920499855292515, -0.898593619100963, -0.87061453320602, 
-0.903980307170687, -0.866046432378731, -0.839936320605635, -0.879362037511879, 
-0.878388445597829, -0.883418147472828, -0.870372930525277, -0.871347818080898, 
-0.858775454063913, -0.91767968427525, -0.88240083556136, -0.892046523628862, 
-0.887479698468525, -0.892697442294609, -0.89910601395757, -0.873880991359527, 
-0.893680967667283, -0.889967332121684, -0.876367153327288, -0.94567971735412, 
-0.905896676055347, -0.87871420893523, -0.920856840219428, -0.869634026519865, 
-0.897318440581218, -0.895762336783388, -0.915764358924163, -0.875816747941923, 
-0.9080902289503, -0.906354963928216, -0.921077252502476, -0.884911787882763, 
-0.882885085167064, -0.854843247655536, -0.94545236519476, -0.900750240346268, 
-0.878500130854913, -0.863877798524849, -0.9173347741204, -0.903062387521185, 
-0.901876753863764, -0.886979029555843, -0.91384020322848, -0.893023336626557, 
-0.844428673138026, -0.856455507423864, -0.865697606852683, -0.894421713856569, 
-0.844116774716685, -0.87277846609489, -0.889309559208, -0.88049470600402, 
-0.905429119408731, -0.886327691604936, -0.903903106735618, -0.881211309291758, 
-0.901621378871097, -0.916466460974573, -0.880161937164932, -0.895936022430322, 
-0.87971224532107, -0.860094575857982, -0.89016546069376, -0.842829448354848, 
-0.930347775133685, -0.889315010118364, -0.898862887952814, -0.867883143497473, 
-0.905982979891903, -0.8709029523395, -0.912485021253724, -0.88890153212925, 
-0.90865633326181, -0.895721028451038, -0.883625499494785, -0.936363666513357, 
-0.870369797886533, -0.89429677548515, -0.904036789557479, -0.855382734327914, 
-0.87123170575171, -0.92449761590742, -0.888588384764439, -0.911795690787518, 
-0.9003731253964, -0.895877817639587, -0.849900065144195, -0.91918232033118, 
-0.8429192318884, -0.861100206395294, -0.854102549801089, -0.923093835009009, 
-0.912897014963122, -0.929857031432633, -0.846613616659406, -0.916261444576706, 
-0.913836148757458, -0.896623015805668, -0.898579104957902, -0.862705451204777, 
-0.934760065402191, -0.898449581481289, -0.897752276266457, -0.900383921120594, 
-0.876897325298323, -0.885489055529618, -0.926955461102187, -0.888274572857085, 
-0.896971793711408, -0.89808329219808, -0.87920524385509, -0.892302055293705, 
-0.887364797039868, -0.887204564321007, -0.858101384143942, -0.9169627350021, 
-0.866347093026067, -0.874882315230374, -0.887733132447275, -0.849520154556168, 
-0.90926676618486, -0.87734920567937, -0.873777685630298, -0.929766513083384, 
-0.843947962577337, -0.885072817836555, -0.913171772736419, -0.899152626823443, 
-0.929135926638593, -0.870257586289282, -0.886632576144095, -0.939067799798183, 
-0.911895066112368, -0.88499857301623, -0.863637567650079, -0.900305854543823, 
-0.902697699163466, -0.887261961960166, -0.891825725687058, -0.897022263559606, 
-0.851204039264671, -0.903095039642084, -0.913259692004866, -0.878666683016065, 
-0.889913305938989, -0.884909749496363, -0.88446017407411, -0.909899686350419, 
-0.903459338297418, -0.875086014830874, -0.896692370270602, -0.898723525705482, 
-0.905130544824557, -0.88864279561063, -0.906006671132916, -0.873343460452923, 
-0.841250154016155, -0.90781056920576, -0.906813814692479, -0.888719034771642, 
-0.881904268271273, -0.919891353756917, -0.879230983428534, -0.907133656690683, 
-0.932498664126354, -0.828121322771393, -0.86734103508207, -0.917726106107585, 
-0.871219911979666, -0.876764613170444, -0.877243110692567, -0.908648722156672, 
-0.871450237697644, -0.914813404584775, -0.898267106329631, -0.93954175580744, 
-0.87142999606528, -0.883412547737948, -0.870066017208013, -0.89162542904195, 
-0.895092727528533, -0.910884504605216, -0.898761647076208, -0.897832557565208, 
-0.867495915860757, -0.87404758775772, -0.924573450404938, -0.895562588625053, 
-0.905693909573389, -0.889520216002317, -0.873958941387438, -0.908962010857128, 
-0.894164482368881, -0.889302098911033, -0.915487430999087, -0.892405353978716, 
-0.884217729431474, -0.895973669476472, -0.889418466383117, -0.87665187078274, 
-0.8642200727943, -0.892056955480937, -0.918400945135186, -0.936744916293177, 
-0.851974403413234, -0.856478480580012, -0.939982940411846, -0.882144009630703, 
-0.878782491988682, -0.904484554903978, -0.844979091396923, -0.846057007949997, 
-0.88611363270071, -0.906097651372334, -0.882313445411126, -0.900236338660553, 
-0.917062012141042, -0.919304183116137, -0.908718060330393, -0.907964756163109, 
-0.869576594997529, -0.910491560907528, -0.876088148611273, -0.87511310068455, 
-0.894867792704494, -0.928651816200247, -0.874770566537578, -0.89146388307034, 
-0.935495350550052, -0.846227400412196, -0.897132416409429, -0.876397742103007, 
-0.901885491051642, -0.88917320933233, -0.898930670245222, -0.907629820190699, 
-0.876111872089948, -0.856783544871418, -0.875793028785333, -0.875434938888035, 
-0.897116017207911, -0.898159259667937, -0.85662696289252, -0.890004777676781, 
-0.9195062475219, -0.87372983984257, -0.902939952351742, -0.919029387725183, 
-0.864184618970379, -0.905257451454757, -0.935496739789141, -0.876199999332532, 
-0.886862322614864, -0.91957869557876, -0.874422834058115, -0.903399772110273, 
-0.868622571724556, -0.856574836856433, -0.846238719387823, -0.891453043293264, 
-0.885516479486876, -0.886297499815545, -0.900555382607249, -0.868437553723582, 
-0.88608689054621, -0.87648075627982, -0.915745719662957, -0.907502646343765, 
-0.878700727975105, -0.889846310849097, -0.844166882757115, -0.918714248407936, 
-0.867197926444218, -0.895712690326278, -0.884842474241947, -0.893583581244495, 
-0.882578014139902, -0.872662724284954, -0.910083085436337, -0.931276830564615, 
-0.864707026508063, -0.85620322190967, -0.868002433696016, -0.893917920447827, 
-0.875102684599428, -0.891618575875965, -0.882235605628201, -0.922017372643134, 
-0.865867403389666, -0.885663809769702, -0.875936863951764, -0.872601030281216, 
-0.87238523483101, -0.865028380667243, -0.876644198087906, -0.88638547717433, 
-0.911655988328848, -0.879155637969696, -0.885428700597897, -0.90817840163197, 
-0.880591957421219, -0.882600565990307, -0.820666701946748, -0.940726191816089, 
-0.910932235755767, -0.86661406475779, -0.876325537112699, -0.925220023888117, 
-0.905636140535288, -0.86987921127397, -0.898398961015965, -0.886817868519258, 
-0.883404361068234, -0.913177789547224, -0.903300055593024, -0.868284927846071, 
-0.914248335948882, -0.888747488222495, -0.897913737011037, -0.903227753579097, 
-0.871927381472606, -0.88936235755885, -0.905402168379508, -0.865555158290176, 
-0.854012143166246, -0.922356606328057, -0.891766322295148, -0.897379453604108, 
-0.911994149891075, -0.906096214470126, -0.906742077030474, -0.886850140768635, 
-0.896791836048742, -0.903269991642754, -0.90682857876264, -0.900223390159748, 
-0.8744039517671, -0.869846686843188, -0.848939420690042, -0.875241314418357, 
-0.954622100599411, -0.890297249382696, -0.87679100461537, -0.861547239190968, 
-0.931418544973514, -0.892003499951318, -0.897234539448773, -0.87129583480925, 
-0.900979638323912, -0.880815709551585, -0.89246241319482, -0.899723018900005, 
-0.854649002684314, -0.85162632466047, -0.872976895809351, -0.85278537618305, 
-0.850593218292608, -0.883416601501562, -0.892925042744937, -0.909261189443763, 
-0.909883595184813, -0.868498229407959, -0.888669241331724, -0.892352406958517, 
-0.88819652730591, -0.885774002787416, -0.876952277502895, -0.85439964731325, 
-0.91260954230222, -0.84461941071793, -0.873958832176091, -0.884576632319064, 
-0.909640947152523, -0.914843146591713, -0.90584858148856, -0.908061795034798, 
-0.882814001844248, -0.877268779662729, -0.889019028478845, -0.847043550261593, 
-0.876931412042756, -0.932105393002419, -0.883346186290636, -0.867963544588551, 
-0.867887310639262, -0.923026228906789, -0.879009940779576, -0.915039721381286, 
-0.888103373237424, -0.885730561251423, -0.867177548987384, -0.909121039512573, 
-0.907662911657633, -0.923884644015854, -0.856806101106297, -0.859646956661784, 
-0.892888480316795, -0.882182909613592, -0.933382246882122, -0.889425056778401, 
-0.890489595136879, -0.902862337770472, -0.924342753812406, -0.91772214174846, 
-0.888893415526627, -0.862501105359165, -0.874269112539868, -0.896820768757687, 
-0.876270769656985, -0.919168430663123, -0.904012742533243, -0.920379135219392, 
-0.894104139889398, -0.84616190102084, -0.878086425305966, -0.920806046450159, 
-0.903958983077366, -0.869678082654978, -0.861851215990134, -0.875334407739776, 
-0.908081262003617, -0.857034080995938, -0.893484225511567, -0.869139493082686, 
-0.900673852150974, -0.893312214925949, -0.923710413436342, -0.835433525764917, 
-0.9104105009204, -0.937580540266745, -0.923857689623408, -0.856049479977168, 
-0.904274574823902, -0.924059509453352, -0.920085908065631, -0.894283951672392, 
-0.900241584607562, -0.863716002909202, -0.86610829931601, -0.846128948820674, 
-0.900321834889285, -0.910701768665734, -0.885252801507518, -0.900479088978178, 
-0.916608993675913, -0.93308718891063, -0.876403986925514, -0.923160086616637, 
-0.896871809104071, -0.881626118385866, -0.859456603785463, -0.872727261102276, 
-0.896282407645094, -0.899551982860368, -0.89445647018941, -0.87789419511462, 
-0.890878313460826, -0.89334292096835, -0.869862793960998, -0.908443169963777, 
-0.902382254527005, -0.904736793570113, -0.57608459332583, -0.605907621726533, 
-0.630842941547539, -0.62957863348515, -0.619159113728593, -0.612564895534928, 
-0.607225235265835, -0.607957671847871, -0.5778579823021, -0.57617088912143, 
-0.552824203145946, -0.64504067842648, -0.619529155350049, -0.550455052249194, 
-0.633553364474133, -0.56807567146735, -0.646810884797982, -0.550225385486761, 
-0.481955367240681, -0.642233653546647, -0.679135552877865, -0.564661066544817, 
-0.602383648812806, -0.616025940792611, -0.625606383728903, -0.562908358244878, 
-0.59686794718534, -0.576531193662554, -0.623337897449026, -0.512088027559605, 
-0.554081092159305, -0.609007966601413, -0.543372766729954, -0.511641544932334, 
-0.570026110593894, -0.547013406475412, -0.524944935164724, -0.581477172632587, 
-0.520988372761799, -0.548826230261664, -0.588304269632051, -0.522123055225758, 
-0.606390181587467, -0.612036382394875, -0.582348916597009, -0.614348409532839, 
-0.653667260383268, -0.56549515152386, -0.574009693184493, -0.649348545719713, 
-0.59991771118, -0.57401295562682, -0.613216526140115, -0.584724328861272, 
-0.548699187427933, -0.564361549742275, -0.626348966997188, -0.598049279246023, 
-0.531565179820029, -0.592810473301595, -0.604128539263654, -0.638284937666465, 
-0.55577171226527, -0.559730952676292, -0.641229388693538, -0.623169347620099, 
-0.642958494380296, -0.534326106865714, -0.577901000831717, -0.567111698802738, 
-0.578733663572402, -0.614599286022681, -0.570146734634951, -0.594672735256247, 
-0.600842761628234, -0.606927319742946, -0.559670313271753, -0.62713715622658, 
-0.653846049053169, -0.558726177852655, -0.569674859979243, -0.597805112494596, 
-0.603640079654707, -0.584210844578398, -0.54499314236647, -0.625664074772661, 
-0.581211777355524, -0.589224786516034, -0.555099789915375, -0.550472619352412, 
-0.582538687666553, -0.632406156142998, -0.547399326125525, -0.580664548388501, 
-0.566408371002906, -0.59049087304063, -0.656745541549835, -0.560735883874693, 
-0.611566804444484, -0.541281281038706, -0.624771023098374, -0.636171504001588, 
-0.529233534078739, -0.640763026039094, -0.664127951072818, -0.608762905225632, 
-0.574554418402277, -0.576330567121235, -0.661772559582211, -0.492933223867139, 
-0.604075299199869, -0.584271574061861, -0.557573460863389, -0.625588366573096, 
-0.629768110526265, -0.564821810200208, -0.557239953582251, -0.535702291898276, 
-0.559695257809278, -0.536995335242592, -0.5438468810499, -0.568459945287763, 
-0.606795359489867, -0.610564447152807, -0.537148573201499, -0.594940218492212, 
-0.591948880643655, -0.635646774391236, -0.592589340368512, -0.554834901534797, 
-0.599016681750347, -0.653369620666083, -0.595394483281744, -0.490472280277085, 
-0.58649536666637, -0.627128584527967, -0.58574383020849, -0.617827358959331, 
-0.58186338934901, -0.540335558349811, -0.56444301633303, -0.593383202955858, 
-0.539377064159129, -0.582912022052867, -0.674342451768718, -0.636023600340559, 
-0.616616689880086, -0.528675236335686, -0.620589800997719, -0.607734447388967, 
-0.49733069138673, -0.546193766133429, -0.590425482800963, -0.51355091665816, 
-0.561485774361122, -0.623325611187937, -0.566912250882728, -0.57494069697998, 
-0.607086390974641, -0.564479404868514, -0.524344368820161, -0.597221550740035, 
-0.598043909971476, -0.587436267390492, -0.552403444640797, -0.629311299913843, 
-0.604119452255153, -0.632928912826192, -0.555709720091155, -0.602075740151928, 
-0.614214683552844, -0.604725687468403, -0.674518600937475, -0.598112241249931, 
-0.575074466843746, -0.509164859060375, -0.554646173790463, -0.59458056499632, 
-0.532535950076821, -0.545440860720524, -0.580448011400374, -0.666037986301373, 
-0.655241084440642, -0.632923215610506, -0.612553666064212, -0.609701766187968, 
-0.560369797172353, -0.537388716391609, -0.540794838648959, -0.52723473485082, 
-0.563427262442641, -0.5274391166815, -0.549872287622513, -0.683072248704382, 
-0.650508312384198, -0.565107662730994, -0.568918842877426, -0.562311492228313, 
-0.603022769724594, -0.551218801332007, -0.581386416704496, -0.545363271536133, 
-0.65843031726847, -0.584033979877127, -0.625295966854914, -0.533792694920245, 
-0.586739855828767, -0.526827955160639, -0.487664935142842, -0.555305788746323, 
-0.614896643731273, -0.610844787636329, -0.464524828581698, -0.564733065477187, 
-0.600259331720448, -0.595548118504884, -0.684547773621666, -0.618587978961785, 
-0.621806307825499, -0.666205234202208, -0.591685402979801, -0.647849454588186, 
-0.496436434810325, -0.589240593246205, -0.650335797654691, -0.619980321996358, 
-0.568421342440092, -0.584142997356348, -0.5993335092094, -0.489114801641784, 
-0.590695151997929, -0.465724878626551, -0.637366259867134, -0.521404600418229, 
-0.61293120141622, -0.589155181298025, -0.599602678576906, -0.558188789518404, 
-0.601545608824431, -0.573872596682085, -0.593800079064912, -0.576072833723765, 
-0.601719589193594, -0.605447446970056, -0.548457615703448, -0.523721420415674, 
-0.617911516679397, -0.558330845675843, -0.616794161564137, -0.583826716828543, 
-0.562735840634788, -0.67303176192181, -0.489018329562188, -0.601665819992622, 
-0.621808650017282, -0.560974059897009, -0.604991602867717, -0.702749672420224, 
-0.537068648397846, -0.545782264215707, -0.538334590533934, -0.579103176136916, 
-0.499812112132181, -0.50776355139331, -0.609791675645055, -0.657638380148977, 
-0.50554591511908, -0.639968574595856, -0.624369808273499, -0.551110205638705, 
-0.561413750746725, -0.619764900637661, -0.60305679267754, -0.575508207485693, 
-0.583687461223525, -0.691854805127191, -0.63273533920085, -0.65352364245678, 
-0.689585807925473, -0.576666630225688, -0.573283889264956, -0.628862448260183, 
-0.541615563650773, -0.513093134716345, -0.57918070436071, -0.619349375255952, 
-0.673683517720885, -0.624149499512081, -0.664072593060335, -0.682912269966818, 
-0.606002678140548, -0.57008679190176, -0.560649628019795, -0.655242848509666, 
-0.562632148163622, -0.612950161189887, -0.637426244875641, -0.610806548715509, 
-0.621111334521135, -0.653816272501507, -0.594452401747195, -0.54403072067781, 
-0.597074987968339, -0.566108808997534, -0.621350626985547, -0.53300854545567, 
-0.537038660622436, -0.648990150935034, -0.580934071522298, -0.68072920126319, 
-0.614487692663493, -0.579236389250843, -0.509434403261836, -0.590470361969679, 
-0.567296107626943, -0.5489474528149, -0.625158013186568, -0.576821825304195, 
-0.558818016980275, -0.645599625916577, -0.573851272410055, -0.518426683467755, 
-0.600930858829526, -0.628653744872479, -0.594878168410923, -0.533197286066306, 
-0.61902251762542, -0.526641200747498, -0.541714705986344, -0.521678009340147, 
-0.545239029278724, -0.606195243077953, -0.59568701882322, -0.628513369370289, 
-0.594946520672587, -0.61671750111108, -0.559612012493441, -0.618049605354102, 
-0.582732083245105, -0.584495333900102, -0.644407811729187, -0.585017629053979, 
-0.577899670822421, -0.609930038986676, -0.628188497283395, -0.643954180475668, 
-0.576401148337151, -0.613165029123587, -0.551077530473919, -0.602241403805941, 
-0.613940797562732, -0.571021345061828, -0.593342177364204, -0.631823310051448, 
-0.573101424058895, -0.523269508273154, -0.610002223988874, -0.510621469397478, 
-0.660990687191705, -0.606788437177967, -0.59318680673085, -0.597632451854884, 
-0.534429589668863, -0.558381239494733, -0.565816739003117, -0.572656838745525, 
-0.578563821560878, -0.621551916035928, -0.631853145889765, -0.570017327844143, 
-0.618103113030213, -0.552364253598218, -0.552402100030577, -0.654256381381693, 
-0.57682773138481, -0.601221705980097, -0.503569944436204, -0.547855739912923, 
-0.603730259262925, -0.600175342716875, -0.603923690937263, -0.56380715323163, 
-0.544397692136056, -0.598715537746804, -0.620930847167783, -0.532678361187621, 
-0.535009554175892, -0.639386071090134, -0.568192368059617, -0.542759367367944, 
-0.644092127797777, -0.572915487973077, -0.639019083740593, -0.588555094080989, 
-0.562549425901718, -0.661442292879201, -0.619046031143094, -0.618716643800411, 
-0.607638760822938, -0.474760932421173, -0.596810707156352, -0.543392836040962, 
-0.621740238348429, -0.580074239246094, -0.621122042250828, -0.5808463378169, 
-0.615566956431614, -0.580792661166118, -0.661974124748803, -0.572628573151004, 
-0.609960397178867, -0.648509607773067, -0.658634933250954, -0.570646763489364, 
-0.558320575753577, -0.636570274859859, -0.561622520670063, -0.647318336830817, 
-0.646064753050501, -0.595312751184989, -0.552658102362202, -0.596711636952535, 
-0.603403558119448, -0.587447785012994, -0.605802354659285, -0.563501935684671, 
-0.536808939948812, -0.579932693005816, -0.615947186162852, -0.540705530492549, 
-0.61547262690486, -0.633411680090433, -0.558746835422185, -0.57642831880688, 
-0.633212519558673, -0.680891359429648, -0.555317798483644, -0.578524294062307, 
-0.595158441844827, -0.613199330028384, -0.586880916033666, -0.63640832409372, 
-0.548244040087818, -0.536345651654234, -0.555863991068463, -0.543378949924467, 
-0.657944563435853, -0.597561307293659, -0.560711621042432, -0.638150439141891, 
-0.655153746257955, -0.600989901136704, -0.600317437736425, -0.53529811857834, 
-0.620590796124236, -0.592670537324887, -0.666938702214646, -0.640714382404992, 
-0.540378811548471, -0.647011006315114, -0.571828859009605, -0.623954646238581, 
-0.559363217944973, -0.6041640021042, -0.65780742913438, -0.541721754001573, 
-0.641372575075542, -0.565847716316081, -0.625880991919121, -0.551833993230641, 
-0.598560746837709, -0.52096702697724, -0.613419661839545, -0.592403556450447, 
-0.647423974429332, -0.590448476252011, -0.571705779918712, -0.546257095804206, 
-0.676612506322877, -0.654971072718313, -0.55522100151025, -0.559491707565598, 
-0.613696451440592, -0.532545881186362, -0.553456181503545, -0.574398021198841, 
-0.583755583839746, -0.618503586283043, -0.596161162809832, -0.584525791094659, 
-0.611953332680834, -0.580625198978891, -0.575392527800571, -0.556320619245425, 
-0.63644314733434, -0.601941071692782, -0.573180565639361, -0.552261072776623, 
-0.603552059706088, -0.611083671987499, -0.603646006505644, -0.669887153558361, 
-0.677986076963999, -0.57669964070746, -0.537687114552586, -0.555047871495001, 
-0.600445612333711, -0.53200645671977, -0.705940731710194, -0.61539558526199, 
-0.533684738682804, -0.617898865194922, -0.567726484285326, -0.529112082457633, 
-0.624154070335841, -0.58803131885781, -0.577269825536622, -0.548402607532551, 
-0.532880946333238, -0.60884676278309, -0.675859924189443, -0.574178965779512, 
-0.644876560517685, -0.623472994547014, -0.539268949683142, -0.666508009031131, 
-0.68858007244276, -0.549704368105379, -0.618666834568869, -0.575967110320159, 
-0.59870623727184, -0.578175404323028, -0.614138337301947, -0.552556766077214, 
-0.618253637306993, -0.647055858097805, -0.598511712954207, -0.592207173338478, 
-0.617473336231873, -0.594688820395281, -0.506715551423794, -0.579786969939932, 
-0.587375354457608, -0.630303919930387, -0.60807424492131, -0.622828544554608, 
-0.612058262199418, -0.595071770707494, -0.593109974657173, -0.585678793924176, 
-0.616304636339353, -0.663126340842601, -0.620898116273002, -0.582379551577126, 
-0.517708586592022, -0.601284845666501, -0.572754372158924, -0.640537625190652, 
-0.591112097899204, -0.537526724876361, -0.624868382575735, -0.60641559676014, 
-0.681904056659822, -0.547640541640889, -0.598670711273251, -0.665056121515244, 
-0.592261798576412, -0.599326037123395, -0.633243333988317, -0.636754172506226, 
-0.573529527730258, -0.717884490923483, -0.574691710483110, -0.59853185401833, 
-0.61562212850095, -0.58846026638203, -0.534654247719483, -0.582564059594682, 
-0.550950691350393, -0.682919498449721, -0.69080605632374, -0.515164197620099, 
-0.657808336166288, -0.570647166124933, -0.674733104765754, -0.528157256183747, 
-0.697001779525023, -0.586551795084445, -0.611556256966648, -0.589972428389226, 
-0.66334177545539, -0.554984630889855, -0.619770698742246, -0.569147456331915, 
-0.548581903257755, -0.56994937448552, -0.542008651205812, -0.527992011285228, 
-0.559718117400644, -0.642585788672985, -0.62581050399096, -0.578238700006155, 
-0.485213885509873, -0.539005208379473, -0.593266625339971, -0.595455764246181, 
-0.622702350698784, -0.585320433038083, -0.594722188032383, -0.54169662565605, 
-0.685262913941957, -0.620816604881476, -0.519354122649436, -0.604292811176551, 
-0.579162139704981, -0.584078486015186, -0.471900843395262, -0.603760598082655, 
-0.639560583800785, -0.622117611732214, -0.579784789330764, -0.577246695602227, 
-0.680807001013035, -0.593712949014043, -0.538740622694448, -0.575656972443426, 
-0.628138486206838, -0.540451786654747, -0.54734518502234, -0.677148861553235, 
-0.672246411865511, -0.604890651521341, -0.658015130255632, -0.613815175994988, 
-0.674940731444898, -0.555249555268461, -0.530649034001076, -0.564186020979712, 
-0.615079219927984, -0.598339894113704, -0.576923984443822, -0.610641022063728, 
-0.571546781033664, -0.590603121827262, -0.598767676872817, -0.5311359123093, 
-0.633598047836402, -0.546591898015099, -0.555080001727027, -0.536049813565962, 
-0.544247300738515, -0.65826008103857, -0.615164633237555, -0.688915041302075, 
-0.604563532528255, -0.537995162236767, -0.648620421581274, -0.633598108256028, 
-0.603238429822652, -0.602520753323138, -0.574484806496456, -0.60002872614039, 
-0.613183618632024, -0.582740617867508, -0.529825056457743, -0.538136614311212, 
-0.590007977803409, -0.576677248610134, -0.625686788709636, -0.646655236680879, 
-0.603484499923606, -0.605442577091956, -0.586602230952739, -0.639236858242456, 
-0.697689352796649, -0.534888726778864, -0.596685646076066, -0.633229102014075, 
-0.585138213814542, -0.676071826235638, -0.520168721058099, -0.678008579775484, 
-0.629982666409917, -0.612654848050707, -0.556675225660901, -0.594045347410088, 
-0.582174474063898, -0.58783572372054, -0.576972097803814, -0.602301025765479, 
-0.575506614022575, -0.640436054187493, -0.539343166538816, -0.587650716609338, 
-0.542146767096125, -0.573291761493437, -0.569904916808736, -0.566293236407267, 
-0.583466165346626, -0.535212543597046, -0.643180040016441, -0.585692520010724, 
-0.515764420962576, -0.633347322122578, -0.577303438833342, -0.6909939860141, 
-0.613847220167344, -0.510895689947883, -0.436545853008625, -0.566757041251334, 
-0.518157881197765, -0.595829390269223, -0.673935710009819, -0.64922724486451, 
-0.59556644294147, -0.632538579111919, -0.600672402086942, -0.596383976395715, 
-0.597412464324806, -0.603944643106343, -0.618909209867378, -0.591519739370594, 
-0.561182584428024, -0.550517833922219, -0.541992400565201, -0.628457252718878, 
-0.613246971320414, -0.607132770420861, -0.571345773410317, -0.556109630192663, 
-0.584300392715865, -0.606348715616523, -0.628296561066993, -0.558339637237625, 
-0.562856493742894, -0.691422855904658, -0.5427865666939, -0.564387918105368, 
-0.583185805307745, -0.608256991412737, -0.526410308058752, -0.651247488557116, 
-0.65524924300639, -0.574914018975042, -0.597995508036662, -0.570577087795745, 
-0.525594255211149, -0.64348396932, -0.530217895230834, -0.64928225831583, 
-0.530514331225589, -0.534925210034126, -0.650465551201704, -0.547139984924803, 
-0.562177563726341, -0.618660406822948, -0.599257560926909, -0.639536225180868, 
-0.567555033716932, -0.650227327765565, -0.531929991345344, -0.615044589093393, 
-0.518649047521996, -0.460477307323687, -0.639401143758223, -0.588050800882362, 
-0.650848560680899, -0.545386556792032, -0.615196960894608, -0.595202523622536, 
-0.594573382353676, -0.634623850498397, -0.655206220834573, -0.555490449616212, 
-0.566829414821239, -0.60666519868857, -0.677867046117682, -0.592387771520948, 
-0.496688974204235, -0.591847015472666, -0.567109658796292, -0.563045488858397, 
-0.618159224306548, -0.683885050855305, -0.619416423910721, -0.652656997584514, 
-0.5296117139401, -0.580154500354661, -0.565663935797143, -0.603318949515042, 
-0.569886798307087, -0.593929012612552, -0.632576755644772, -0.514992128940763, 
-0.634183589150907, -0.583621712910459, -0.616781469706811, -0.63463131708539, 
-0.626501995655727, -0.562241938355459, -0.608110211292684, -0.582163476112212, 
-0.589173935477476, -0.64948354940196, -0.697747908846288, -0.548398166393493, 
-0.59973543120996, -0.524856896850954, -0.556001171918282, -0.576297055569077, 
-0.594991050554631, -0.533346121767944, -0.650179975775877, -0.535218719847059, 
-0.56436491776209, -0.59584856211889, -0.570739396512085, -0.663497408767876, 
-0.495140367055629, -0.636541978201855, -0.546398202725514, -0.564419626340174, 
-0.543109723085793, -0.590639671752579, -0.559159550841524, -0.674256049503053, 
-0.594072301168538, -0.561145116748475, -0.592284688891486, -0.538162070109873, 
-0.579482382412139, -0.572541647320621, -0.54964871706532, -0.529967308713891, 
-0.616412940901006, -0.64243656844841, -0.584625088390044, -0.679607774732289, 
-0.518014870000898, -0.594206573071765, -0.547975441072763, -0.613310466907712, 
-0.570154697229952, -0.638688603330651, -0.668664867188117, -0.664293205041397, 
-0.58447077094251, -0.617548543597856, -0.614510589746124, -0.613361292674029, 
-0.608651311456833, -0.605720740511566, -0.632309233212584, -0.611132340234154, 
-0.522751073718463, -0.595872795178293, -0.662110796166073, -0.562495018054028, 
-0.555424270719528, -0.56533871926253, -0.560299870749978, -0.571936100100419, 
-0.633988539246192, -0.529560541320112, -0.607749036613425, -0.552784542386238, 
-0.591962494211383, -0.624048181929948, -0.616631532479367, -0.54438383809481, 
-0.632571355905022, -0.627584984190912, -0.627033068331248, -0.585424309769391, 
-0.605117154438709, -0.571092990889676, -0.606890409565335, -0.476761032253175, 
-0.597539040151156, -0.657352201811148, -0.574974768325394, -0.5716179328233, 
-0.586637178411384, -0.612784949736808, -0.710656145309974, -0.595872688320115, 
-0.592873883942603, -0.584472430829431, -0.494607356463004, -0.565669403620951, 
-0.525391261064425, -0.584598699837686, -0.636484359130155, -0.57182557759296, 
-0.579304047825752, -0.575604377256137, -0.561644705387191, -0.590250675675945, 
-0.476572184390053, -0.568759462481805, -0.61820080728467, -0.588492915415212, 
-0.571152281979257, -0.554145648334865, -0.55011157122526, -0.622084419857818, 
-0.633632541874358, -0.595436912239621, -0.597181692947983, -0.555852934081338, 
-0.654154520130406, -0.602123356708929, -0.561282651884202, -0.657446578544473, 
-0.630193323523647, -0.644802424157175, -0.585797168905715, -0.566493267229265, 
-0.584238460741696, -0.664391992235408, -0.50464040750383, -0.591071745113205, 
-0.61614723968214, -0.538221474542515, -0.62989531968174, -0.537070252279288, 
-0.60619853502697, -0.670958918093458, -0.576041765504026, -0.60410143661198, 
-0.536274535474333, -0.539197291331407, -0.63469432696117, -0.584419996957486, 
-0.653833192453701, -0.609831268845015, -0.703254266220797, -0.580731453358038, 
-0.582957234488949, -0.596521428818444, -0.527818927015372, -0.524755192267779, 
-0.628084836193586, -0.659547976647593, -0.542181879230293, -0.607347352215914, 
-0.585204709616442, -0.575012518340944, -0.548236241457575, -0.595696957369852, 
-0.504822531254936, -0.622771514508854, -0.617864548980205, -0.61469242327675, 
-0.632346122721771, -0.578630110909467, -0.64574023803676, -0.540056641400841, 
-0.572645418171356, -0.533206926314728, -0.619865994059989, -0.647544888855136, 
-0.689351559868074, -0.550724433710789, -0.545079924981817, -0.596770978026924, 
-0.606597632868787, -0.561984270111282, -0.629463857788786, -0.658547254883371, 
-0.630882182611719, -0.583943116153017, -0.563238105773796, -0.609532569860204, 
-0.551182607540675, -0.585569102283308, -0.573492622888706, -0.618106269875142, 
-0.554058677613292, -0.569190631584621, -0.633621479298555, -0.5995935323103, 
-0.61547041039146, -0.665887392623983, -0.642199125619091, -0.595240020289779, 
-0.603942594763266, -0.598307302383078, -0.552653061132897, -0.506457636316021, 
-0.666681321724656, -0.565701396870269, -0.555036330238781, -0.554200966986525, 
-0.535330178062815, -0.612372025386477, -0.633648269384537, -0.539730119814852, 
-0.63554459768994, -0.532860303698692, -0.306889255298137, -0.276021282708062, 
-0.318955928579935, -0.369158127388063, -0.243335949884923, -0.248649781160170, 
-0.252563252545799, -0.394863827975146, -0.280800690961845, -0.295291034621746, 
-0.259792539052564, -0.237920746662688, -0.335373090760838, -0.343451229605079, 
-0.335434246282635, -0.356411275117498, -0.296933173695409, -0.328559015186261, 
-0.202008397148932, -0.352345603946933, -0.304042167763528, -0.236534519061534, 
-0.372598302255420, -0.295446644612152, -0.153714390439099, -0.311721999004345, 
-0.283251915045618, -0.246122066559452, -0.27361099591357, -0.305025089999028, 
-0.187055284416054, -0.336150470750959, -0.294156743004318, -0.291644239745067, 
-0.253740110475034, -0.367520617573629, -0.350225182224861, -0.27768769407365, 
-0.246621502086438, -0.280118124731685, -0.258058496179855, -0.276935321917048, 
-0.384629210807851, -0.345443244792395, -0.335568650364866, -0.337283679277508, 
-0.314718189273461, -0.327887066697732, -0.247480546252350, -0.273889945442486, 
-0.340866286946827, -0.308385810262185, -0.321876131870678, -0.346225025501675, 
-0.306589185139857, -0.242181305365303, -0.253153523256137, -0.376394185658944, 
-0.160323624327128, -0.351659665582393, -0.244066097394576, -0.172944337264964, 
-0.267142854360475, -0.218974279521676, -0.320515146296648, -0.332673410713486, 
-0.254666336290280, -0.186432090587897, -0.258344220053402, -0.272796594282614, 
-0.204623949239248, -0.278485494017956, -0.215683603937782, -0.391487818591429, 
-0.280999473291765, -0.400575232126039, -0.288616896855034, -0.28950296084819, 
-0.331439955510628, -0.257227404820828, -0.217834022730421, -0.218156683180846, 
-0.242180873400343, -0.359076126436496, -0.348116313757717, -0.364371827565878, 
-0.282718987277415, -0.390016156353112, -0.327891469627064, -0.216250863901691, 
-0.335276959806313, -0.247601937132569, -0.284806829301836, -0.2873786115433, 
-0.309986237488523, -0.262788329775559, -0.305131415379892, -0.338694160623856, 
-0.314079738635153, -0.378880437490634, -0.241592354824125, -0.266689904075400, 
-0.301060571303175, -0.238318926544530, -0.295921184137765, -0.334738388824913, 
-0.215181156232431, -0.306493984298047, -0.321680055595638, -0.296838990213303, 
-0.338949796462224, -0.285504551985556, -0.291156906341868, -0.249033754951014, 
-0.266565879138514, -0.28265749720599, -0.252300142274865, -0.324485802959628, 
-0.280793317555776, -0.273675064380563, -0.326891463869978, -0.295445257232447, 
-0.309554032854363, -0.270189889007365, -0.293542492910102, -0.308472143142387, 
-0.328473938529655, -0.342448209205784, -0.289665197705397, -0.224412367527355, 
-0.285047173601818, -0.249092114607326, -0.335056341931022, -0.325020433847539, 
-0.262545717852581, -0.226074583363201, -0.243097134712576, -0.290689265488234, 
-0.190028991945863, -0.261414746081226, -0.327463938982224, -0.41212516256976, 
-0.24985073615979, -0.258315379032957, -0.27599198543165, -0.337585254004039, 
-0.307120738601673, -0.261149736317305, -0.341494575259492, -0.426982905579166, 
-0.33875496942047, -0.300469879326609, -0.390605598923309, -0.200081830025973, 
-0.295687990993375, -0.248945333283082, -0.262155015407333, -0.279051510215273, 
-0.346327430630146, -0.355929467498298, -0.280945946842318, -0.266917095004452, 
-0.326091449854216, -0.197063608346743, -0.261277539247897, -0.369947074838044, 
-0.273576239618411, -0.233097518982216, -0.210538814603019, -0.332394980314755, 
-0.29326302209107, -0.288772441234315, -0.293269601055858, -0.30985813052116, 
-0.334561304392217, -0.315956741730407, -0.415309040675456, -0.256726296541516, 
-0.301247789731072, -0.278892563698937, -0.247986007695856, -0.287363412877234, 
-0.357381947239211, -0.260430783427618, -0.273716628632855, -0.279843984355329, 
-0.315902621210009, -0.334349592734081, -0.279821897599019, -0.317275793346205, 
-0.295624069173286, -0.276613573928672, -0.304387064158796, -0.240222082786879, 
-0.313311963478666, -0.424796492091925, -0.294889835139168, -0.335807206471993, 
-0.325899520529221, -0.264271392011977, -0.338766106124665, -0.360302052183243, 
-0.239277316253044, -0.239894694648839, -0.377211447652908, -0.262704977833831, 
-0.305636284783814, -0.342121337969989, -0.319904891724692, -0.323624914125238, 
-0.222647931975845, -0.276222227815271, -0.305119607568313, -0.215762887070865, 
-0.274277357076034, -0.369602002890599, -0.310735174078774, -0.369295257530024, 
-0.276280375515232, -0.295793008690288, -0.284865201703994, -0.267502653249456, 
-0.310175228362010, -0.313680406880862, -0.276383991773789, -0.364542855149889, 
-0.300296333678251, -0.301045064981058, -0.223695582059680, -0.246884923267181, 
-0.254747751923458, -0.253791236129776, -0.378415768714888, -0.242267937149454, 
-0.308394643840162, -0.256419396280291, -0.261300958032945, -0.197510471613716, 
-0.407947781222638, -0.247155119615032, -0.362743432007845, -0.262656763033482, 
-0.342099273056731, -0.221795245786442, -0.290181991962587, -0.239222552463717, 
-0.410032107239355, -0.272919251538331, -0.222092190220624, -0.396817122087213, 
-0.387570636923425, -0.283147671708866, -0.277592479871832, -0.365425777883267, 
-0.273697384332828, -0.269524920866319, -0.199850242430646, -0.257499082463572, 
-0.407106768066208, -0.168246841930493, -0.356824895514911, -0.358389585262759, 
-0.276763639161656, -0.251899019776805, -0.247928981228941, -0.276928593499649, 
-0.33387764692664, -0.34405625473299, -0.150403146067425, -0.197193497108364, 
-0.148955978026533, -0.346509923153938, -0.224901512572393, -0.264412399398636, 
-0.319176575017139, -0.192190624509469, -0.296537481211504, -0.288687041600362, 
-0.199707523058873, -0.293234698753824, -0.254408596438073, -0.280016377379916, 
-0.241209637644932, -0.358309246618716, -0.311094829191454, -0.337595407163627, 
-0.242071569659432, -0.255109221358291, -0.320442979163536, -0.237643799288436, 
-0.194735350026104, -0.399519795894893, -0.212682724871881, -0.428290883784295, 
-0.156192701131932, -0.394398751569166, -0.40486231785612, -0.32529417807925, 
-0.309272783122467, -0.297075323538718, -0.285409968534331, -0.293349131799115, 
-0.323594387434322, -0.264754957868554, -0.302148681798075, -0.2997920421894, 
-0.331445252067635, -0.268930739211974, -0.244377737952107, -0.262087199479624, 
-0.295158044232797, -0.234425176502567, -0.240337461169864, -0.247812358013903, 
-0.427870402821084, -0.293019673973095, -0.315483695681977, -0.38158174322178, 
-0.401329541490270, -0.341477768775581, -0.376901266728246, -0.255189171347660, 
-0.284379642985913, -0.261183766938869, -0.359651429609050, -0.394331191700966, 
-0.246044793928838, -0.286649959468258, -0.372459502963866, -0.284987830699312, 
-0.365204870351816, -0.306288311205263, -0.326572894898027, -0.273942269714046, 
-0.423535502640528, -0.288680101005558, -0.265461466326014, -0.303711076612115, 
-0.362450581593049, -0.385699750452026, -0.315029576172202, -0.217856995725371, 
-0.360075599354605, -0.365206273720854, -0.381275311019274, -0.348360202504142, 
-0.228643369591607, -0.275510917457201, -0.309828647905305, -0.406619122185935, 
-0.220075637678095, -0.244629279269047, -0.288099463250132, -0.295134716510933, 
-0.216216837320516, -0.275340861389232, -0.353398332848054, -0.37566106559545, 
-0.390272042483472, -0.283149368335195, -0.284668555352911, -0.313953896181758, 
-0.265856903207923, -0.292971134042799, -0.372621501177299, -0.319753037633133, 
-0.307562399941069, -0.34029797891339, -0.245372401573789, -0.231180276272585, 
-0.197237471539354, -0.320576349100473, -0.246909119627982, -0.360616712713048, 
-0.387435960164811, -0.211276383536595, -0.266778845283875, -0.354060711889908, 
-0.295270907448006, -0.390238705156556, -0.218022023159435, -0.292700661884410, 
-0.355933792043255, -0.157548764079025, -0.395620651690541, -0.260918662426430, 
-0.337836753824517, -0.331961722096335, -0.288333150880927, -0.294982102542122, 
-0.347279123383622, -0.257672497080452, -0.170899826269332, -0.261813972660736, 
-0.318856319052703, -0.369431257666847, -0.287546498773192, -0.206220911038963, 
-0.321090537898868, -0.290314266599952, -0.227066970777653, -0.337033858080625, 
-0.292516753789244, -0.182945167153923, -0.325766847800265, -0.242028892837005, 
-0.312392421060371, -0.310779148220817, -0.352952213525753, -0.313810592746521, 
-0.295964737546374, -0.37857968458484, -0.26266868916556, -0.269993827832515, 
-0.401418904852036, -0.221481097989279, -0.297360116421584, -0.301197714975838, 
-0.230136463008643, -0.363405111756590, -0.370321761173205, -0.276357561432776, 
-0.254262046448998, -0.313189936204656, -0.290667804375531, -0.404149892597622, 
-0.321545984538010, -0.359941622557634, -0.299061545175925, -0.374959677151859, 
-0.286865144967933, -0.360888877127755, -0.311166184591741, -0.224937527568045, 
-0.323990847905880, -0.239018604225732, -0.287230827623821, -0.258903042639736, 
-0.296987487391315, -0.298156657674454, -0.259182068257481, -0.410056381024653, 
-0.158615417903620, -0.372351462993455, -0.248396665355144, -0.261690035889704, 
-0.289619441907627, -0.238717191591512, -0.2542274306139, -0.303797846858421, 
-0.377816000833801, -0.376688860274, -0.289134504924847, -0.333431365709503, 
-0.258697200999234, -0.321694288682209, -0.278970252056126, -0.372601771022293, 
-0.424877530279122, -0.277439998210394, -0.258383239023586, -0.403936162473078, 
-0.336483919809705, -0.272796466486445, -0.281580375854873, -0.315347175182523, 
-0.293531223981788, -0.231083641478255, -0.287601378405609, -0.30282172254698, 
-0.231406963158372, -0.297470051301171, -0.379394543110368, -0.255633192526168, 
-0.364498359919753, -0.284710998362276, -0.173088521746379, -0.228801118671400, 
-0.304079295144535, -0.290479680936915, -0.317704323729798, -0.30658708108721, 
-0.289588773304502, -0.278866934902028, -0.347046769320524, -0.205805974119178, 
-0.329758638985414, -0.269895439992349, -0.32375981814092, -0.235105469686088, 
-0.290218217957478, -0.383089681570422, -0.271531439722095, -0.286172938429859, 
-0.286353148799433, -0.282553961691948, -0.290989826656323, -0.348374814366627, 
-0.210943275764654, -0.262170560247635, -0.270198409387809, -0.307268207770301, 
-0.291499242973483, -0.371715081108532, -0.341712653292073, -0.324715477479417, 
-0.269794724333825, -0.347827956230202, -0.220406192263088, -0.39783722802723, 
-0.362284416512750, -0.263719090510331, -0.340456997305315, -0.271191145164632, 
-0.307046438535787, -0.322163318918659, -0.351965058355174, -0.320362496858399, 
-0.245792712143467, -0.280457879791967, -0.374371138175119, -0.382330547373903, 
-0.276312637878946, -0.311946063784697, -0.368730725481724, -0.140810516398367, 
-0.304903007507582, -0.344670674000504, -0.275942769899832, -0.223750244781374, 
-0.37666359852556, -0.392017028029615, -0.222201514966836, -0.275637480752375, 
-0.234369434622089, -0.219945473176136, -0.355120269799938, -0.148735634075976, 
-0.282067144785445, -0.219251363727551, -0.219251988988708, -0.312085839289722, 
-0.285751684161107, -0.245053552122976, -0.330422786424088, -0.300225179463171, 
-0.266823584609596, -0.317331481542804, -0.24568240022901, -0.179715945304769, 
-0.370508864592074, -0.260550980156227, -0.313133421306293, -0.335146480960494, 
-0.239101872693238, -0.299659746426420, -0.315400146815557, -0.2360783257623, 
-0.248606413954704, -0.21071528273662, -0.311654050151596, -0.319606099768285, 
-0.255056490417300, -0.258802396948053, -0.302889347797607, -0.349655225616829, 
-0.323291969803755, -0.300518037608763, -0.284303512072911, -0.332909407378999, 
-0.221061190318858, -0.273189528451587, -0.370314988105141, -0.259441310730629, 
-0.190268374860037, -0.235129290045681, -0.349612030006644, -0.281871554174534, 
-0.301367750572800, -0.270461981892058, -0.347624272929428, -0.228638698648998, 
-0.344987755731322, -0.287322367327949, -0.165785718869849, -0.357293704895923, 
-0.207523935225929, -0.232772617643315, -0.222608858328296, -0.270144707221269, 
-0.393331716556398, -0.350569736521191, -0.253334595474068, -0.276020683836907, 
-0.321705834804323, -0.285943149877015, -0.252619111775152, -0.199209436810703, 
-0.208866791072879, -0.357914477869731, -0.3147047039132, -0.40570818348893, 
-0.260623467216923, -0.272344463843878, -0.328148032630597, -0.360499250541648, 
-0.328298972790721, -0.243122659184582, -0.335297507134999, -0.322109136932659, 
-0.314408356406335, -0.261150551111364, -0.314355062715622, -0.391709457972255, 
-0.302842715742625, -0.373466332692843, -0.246087777394577, -0.322133132931112, 
-0.262072245990438, -0.248587826708741, -0.258882922990100, -0.348075452419186, 
-0.278590992362333, -0.287312221883717, -0.169423987841014, -0.233978954804777, 
-0.414221340638936, -0.398120360051888, -0.312019323740259, -0.288478832161015, 
-0.371348538637751, -0.212287733319388, -0.24831410250849, -0.273852979760044, 
-0.253633088113459, -0.30158081899521, -0.322015762151624, -0.248923830333181, 
-0.323037783382206, -0.386806781287973, -0.208681882063991, -0.354484649170295, 
-0.307638428389175, -0.327048561246293, -0.356165761965826, -0.341603491386188, 
-0.332875882096173, -0.284627669598743, -0.246391019265285, -0.239820438790507, 
-0.315752907607152, -0.238055979892517, -0.260008519326042, -0.296685089418414, 
-0.311396239068907, -0.269324846108299, -0.239563971578889, -0.310202045599638, 
-0.145914475316603, -0.200372263286099, -0.351642830256089, -0.172636168397965, 
-0.397700034163758, -0.243030055630009, -0.321250048811407, -0.288449997489871, 
-0.259239016877676, -0.297641298690632, -0.418782496350423, -0.199226959611846, 
-0.273815358903314, -0.422894513653383, -0.29287100201679, -0.36850629815195, 
-0.351209646831914, -0.250687254243372, -0.380204260714761, -0.202275147485698, 
-0.366702577543811, -0.129326818253774, -0.235825252362643, -0.223881547776666, 
-0.289644274543674, -0.278904489093995, -0.259157979278047, -0.323615808861500, 
-0.26868582483532, -0.324251427680747, -0.323942829515747, -0.376797769673967, 
-0.284286410781403, -0.238683963571016, -0.366627832405097, -0.210823617703368, 
-0.288067767606661, -0.326670617010864, -0.309809159159844, -0.318529295653229, 
-0.329539157640317, -0.291934359270456, -0.253310867176308, -0.343787135864976, 
-0.198960380160070, -0.318380352390342, -0.27870896544363, -0.323611755057787, 
-0.369027695957727, -0.198771395596859, -0.271740870943172, -0.250093899517151, 
-0.273660557618751, -0.253302995794483, -0.290809048458579, -0.305328579112792, 
-0.261685527651140, -0.242763255918135, -0.297463219952435, -0.237304337557333, 
-0.250293440020003, -0.317736761941189, -0.210702016019615, -0.405968799583553, 
-0.34267608206179, -0.292723878476636, -0.290461681184487, -0.312968308049346, 
-0.335730671637103, -0.277526851362867, -0.229394761525008, -0.353416660725212, 
-0.311778401236708, -0.207353176787207, -0.331171812536652, -0.233669887805712, 
-0.375441446528277, -0.270320920387845, -0.356225128346168, -0.295513157472739, 
-0.312671636772747, -0.336077107471317, -0.369484052186346, -0.258053907171272, 
-0.295595970332959, -0.239597208412267, -0.275579575678781, -0.246287694938765, 
-0.256983488886479, -0.406196232993216, -0.293143029105287, -0.323370420382913, 
-0.315001956945277, -0.336049258718636, -0.333983446771808, -0.252885368410221, 
-0.336115279724712, -0.273635962731101, -0.213363733529046, -0.190482256628405, 
-0.275293930085260, -0.288038434851909, -0.324950420222948, -0.228356521180393, 
-0.258480941162062, -0.241383660301658, -0.294416430828244, -0.34912341698814, 
-0.376458950524368, -0.32358975782449, -0.226139270662882, -0.249213279662903, 
-0.266836244374187, -0.326712891087231, -0.243727903417695, -0.311423234322987, 
-0.30813374484886, -0.360100032288352, -0.384638777035386, -0.275750089171501, 
-0.337557765326496, -0.287719744005100, -0.286486870120543, -0.368426142153613, 
-0.265908387923513, -0.278375952195981, -0.207416574461174, -0.264631293659631, 
-0.328691645596763, -0.316635264793622, -0.245538352350167, -0.301289712935521, 
-0.34209778767072, -0.327795007121806, -0.396050520715573, -0.208702281399280, 
-0.288734785275043, -0.363397694006298, -0.25299109761946, -0.232103112175741, 
-0.323627022837391, -0.249587360053532, -0.341808018040192, -0.27502312380474, 
-0.162681213607223, -0.173690023052007, -0.213280881187814, -0.244863472481006, 
-0.293353345910748, -0.278102578798299, -0.377023324878098, -0.220251431308014, 
-0.250853774386598, -0.253398768644135, -0.376889905742742, -0.307208535898818, 
-0.321138678613325, -0.297961652723079, -0.336123068259975, -0.238708209715858, 
-0.276929242113038, -0.306368907324826, -0.331487244721744, -0.318814282999880, 
-0.347477034216636, -0.311684242757831, -0.282301471705320, -0.255210675688014, 
-0.385893039160048, -0.269031898114446, -0.212713749534602, -0.239906208638765, 
-0.178338187874456, -0.157918341404545, -0.175805655766290, -0.251203965684562, 
-0.317811890436024, -0.283873930318827, -0.36543311887345, -0.343354599191246, 
-0.368727198825480, -0.235080296099098, -0.277409871751276, -0.363574335739354, 
-0.331870115457256, -0.252843054986976, -0.283227664933443, -0.370152557731191, 
-0.316338698832658, -0.346587729903313, -0.272289473237939, -0.242326015723763, 
-0.245574288181563, -0.228920697517334, -0.278425983124000, -0.245536798351851, 
-0.328638836160538, -0.303004534240711, -0.230731750887358, -0.392779350093711, 
-0.393075865171237, -0.203872170282893, -0.255037383565337, -0.365735073096499, 
-0.338367116613933, -0.307823605846593, -0.282594850767592, -0.250224979928414, 
-0.331221305556090, -0.290964140786177, -0.279949255316666, -0.356347103035307, 
-0.297397658746167, -0.378601319766872, -0.282889368399305, -0.29632256572232, 
-0.343426667547484, -0.351805471618271, -0.285408363871892, -0.336540121447081, 
-0.250739113001447, -0.347982194584376, -0.275449753827986, -0.237586708122903, 
-0.327309282100917, -0.345291362130340, -0.337522646431234, -0.255160380716158, 
-0.341780700772016, -0.289579130642, -0.343573114645551, -0.281689389989405, 
-0.232306553726922, -0.174804897317046, -0.244771838894673, -0.196154710890755, 
-0.264602635713064, -0.282596412435554, -0.267748565476379, -0.303197991515416, 
-0.383288338685715, -0.263888650264673, -0.281932068942105, -0.318315608018434, 
-0.244945064125490, -0.321067983670884, -0.35120745764699, -0.337899513602342, 
-0.320224184047117, -0.251994368958342, -0.296137726707865, -0.335698482667969, 
-0.297845477519909, -0.181711801932614, -0.365315450073093, -0.255507327159565, 
-0.312709362409203, -0.357956142267123, -0.338544519279505, -0.28249125368974, 
-0.32139046947232, -0.355699051036959, -0.294874989413706, -0.259379459679061, 
-0.230285695663318, -0.248993148841674, -0.280972690832487, -0.324715513545526, 
-0.335942147284319, -0.313581103423739, -0.302447427216167, -0.340810304540307, 
-0.160213885581861, -0.433733467035447, -0.288897227403577, -0.344374074709418, 
-0.247110090967234, -0.307993623766503, -0.309253725187312, -0.1550655902703, 
-0.208017650729877, -0.305968142038024, -0.357752342045034, -0.265063180738617, 
-0.354110662110027, -0.310595282344190, -0.259985642081291, -0.287196390809698, 
-0.278943944494033, -0.277586550834105, -0.266851128799257, -0.272396093133762, 
-0.314999494366310, -0.184176414793966, -0.374016370379264, -0.231046960794966, 
-0.314001790758616, -0.267904622505452, -0.350293832827087, -0.23996560488100, 
-0.341148340714615, -0.289612973004816, -0.326824667193924, -0.274304457147491, 
-0.268678252339674, -0.254454682870784, -0.291209271694450, -0.283452926362111, 
-0.289635630288697, -0.237204172831641, -0.34882205365108, -0.274345214848201, 
-0.333584034046718, -0.363846653763427, -0.286658897786566, -0.226549716106550, 
-0.236485891121121, -0.225363633307412, -0.300103991790304, -0.326221533734486, 
-0.278315490576008, -0.281865660612073, -0.269932216175925, -0.387398101642212, 
-0.291328866161849, -0.386014446104331, -0.258211880342237, -0.175198863184758, 
-0.388885175003618, -0.281474673732886, -0.302476873719562, -0.226170888498295, 
-0.285032490444682, -0.342058488165859, -0.267885940329937, -0.311413793102657, 
-0.273141730656231, -0.244862301396039, -0.299342174066924, -0.250258928006289, 
-0.266593956422380, -0.345093561215375, -0.0900436514843874, 
0.121966251358389, 0.0502809050098965, -0.123961168658962, 0.00987608510462443, 
0.0098458379892502, -0.00305010736294481, -0.0278573463173678, 
-0.0534582314025973, 0.0805886989710018, -0.0411080802127433, 
0.0343490401383363, 0.0594625203593077, 0.0373309251462791, -0.0498583883309909, 
0.077544605160632, -0.0759304583483276, 0.088831263701127, 0.0259445599126967, 
-0.089577903610877, -0.0349279423088325, 0.0494792885031794, 
0.0545654317217575, 0.0146315414839887, 0.123191983899424, 0.0221054542119285, 
0.0901024177365734, 0.0994848367477905, 0.153287094535397, 0.0966326070062483, 
-0.0157923213430428, 0.00510225033813078, -0.0439135775174861, 
0.0525099574145786, -0.0094472571321012, 0.119869159078448, 0.071323308413234, 
-0.0552561080680317, -0.0266489196698687, -0.0244128936799369, 
0.0306586526598561, 0.0209350660314842, 0.0244518561806716, 0.00889760150291475, 
0.0389963979933685, 0.0439227069539174, 0.0109114022834828, 0.0323601737523203, 
0.0455015608629689, 0.044398991332816, 0.0753063921130931, -0.0994113892993615, 
-0.0462676617464177, -0.116978006289470, -0.0279802233703079, 
0.123822173411765, 0.0278732177989629, 0.0203294124276147, 0.101989084605113, 
0.0495547512879218, -0.0386361688736431, 0.0828843032730289, 
-0.00643210457572237, 0.045161080528649, 0.099855759481263, 0.094746011472375, 
-0.0636866321233091, 0.10647203037655, -0.0243549848173077, -0.0561300726613854, 
0.0147853939225228, 0.0551563210445299, 0.00594927437431818, 
-0.0779217472079644, 0.040312237037243, -0.00137477871106723, 
-0.0714975636412921, -0.0971887732002955, 0.00809622005184436, 
0.07379491650907, -0.0188736883757153, -0.0878176533142425, 0.0516891626055575, 
-0.031627999098067, -0.0465539394916174, 0.0630943158938575, 
0.0372168089889149, -0.0156321518227572, 0.0557436983261906, 
-0.0425707652062953, 0.00226395509327409, -0.0368341418657963, 
0.0338494071747764, -0.0080476098532717, 0.134574576700768, 0.0629312965611937, 
0.0797905766213776, 0.0373761783220289, 0.0252043688682701, -0.0486107333938892, 
0.14521521968673, 0.0367663170458137, -0.0387507241010419, 0.0941955521836393, 
0.0188720243066601, -0.0283453791527511, -0.0741177376029753, 
-0.0553871688823947, 0.103143523150606, 0.0626143388300448, 0.0504327150544369, 
0.0068103395727433, 0.044709678911966, 0.0146281291337886, 0.0824464105985755, 
-0.0139953603287361, -0.0905940745274461, 0.0693636341384306, 
0.0216572925541078, 0.0694246204457471, 0.085322553758368, 0.0239913771222245, 
-0.0486536313874763, -0.101289735689031, 0.101119207647484, 0.0329804855401219, 
0.0553868826877932, -0.0243624055376469, -0.00224655182883299, 
-0.0129531653892599, -0.0093950212555699, 0.0475983332347955, 
-0.060080144219983, 0.0328423830964501, -0.0477994990799322, 
0.0449093263845071, 0.0264790649101704, 0.0377397378334808, -0.092657086302923, 
-0.00938664762012544, -0.00564327028440735, -0.00501167651494498, 
0.0360315045884955, 0.00936003491583626, 0.061293955407232, 0.0212404218157124, 
0.0199387405784941, 0.0588558352391031, -0.0352637983992188, 
-0.0712135722278235, 0.0552088299686735, 0.0474867962991563, 
-0.0709157100263422, -0.0660343769227447, 0.0249043683125442, 
-0.0542740895316165, 0.0292116776509551, -0.00792954913887674, 
-0.00723139089596426, 0.0383181209963059, 0.0191783338656915, 
-0.120697927613673, 0.0555553836754101, -0.0665546570833865, 
-0.0526657427291505, 0.134798636137553, 0.0251842064008045, 0.0374684439887912, 
0.0891904669672347, 0.0455291393329222, 0.0818281798316732, -0.0178956650865995, 
0.139096881937187, 0.0168885841252148, 0.0257976821977472, 0.0200004212898056, 
-0.139125299044280, 0.038588378557633, 0.0306546933433521, 0.0176414200058445, 
-0.0246886624699705, 0.0638068191669466, 0.0669886863691229, 
-0.103220374930785, -0.0455680673073626, -0.0113240891779422, 
0.0903053135830649, 0.0736893661439871, 0.0245355043096106, 0.0216927831110246, 
0.0157760366446685, 0.0597633871358541, 0.0441992990099965, -0.00669364223229757, 
-0.0159071920240333, 0.0154086725982781, -0.00108525056383665, 
-0.0862666378964621, -0.0129066524689572, 0.115150303705406, 
-0.0640905824518891, -0.0500842781524352, 0.072091924443433, 
-0.0208955900535577, -0.0238517412064865, -0.0152163513223754, 
-0.080832267369683, -0.0659784578305573, -0.0601584762428227, 
-0.0531018533587241, -0.00581909783465107, -0.00854421230052906, 
4.61144627618618e-05, -0.0170593855571184, -0.0261764556565269, 
-0.00690641647152283, 0.0676446850851575, -0.0891753390660048, 
0.0303495970403055, 0.00443988605292577, -0.000143884373252550, 
0.0250696203396157, -0.00761826692024586, 0.0842030415833568, 
-0.0917603580472243, -0.0192013004125150, -0.0434865362955031, 
0.0725187211988825, -0.039793168439618, 0.0800498362221216, 0.0565261100633273, 
-0.0333727887110855, -0.0156561557091652, 0.0297732297448759, 
0.0374230064109852, 0.00248465211527474, -0.0727290755055174, 
0.073021051715371, 0.0335107693143717, 0.00364129999367570, -0.0648900092973959, 
0.0247754425163535, 0.0713324673763269, 0.0100962880440441, -0.00675087768708093, 
0.029472718091196, -0.0328755922905741, 0.0201022049765317, -0.0424336667881196, 
0.030568194789429, -0.0714274653924673, 0.0493859192680018, -0.0817566174844047, 
-0.0448299687891132, -0.037899982757533, 0.0978932322019304, 
-0.00253356811589353, 0.0524521109741427, -0.100893836254721, 
0.0625767795037562, 0.0509533303695255, 0.0271588572584529, 0.0163538831623435, 
-0.00215857104965402, 0.0164689188086730, -0.0153400437431180, 
0.0394750838989316, -0.0171718398260903, -0.0674366027402082, 
0.0353392260522815, -0.0764984099775681, 0.0451530326659781, 
-0.0598653564952861, -0.0152589569064592, -0.0607070087937677, 
-0.0162859691880140, 0.0418623533721351, -0.0505600041394545, 
0.0078953742923015, -0.0959615578771311, 0.0878925826224867, 
-0.0070843945150174, -0.0282101464990176, 0.107579872609495, 
-0.0118575643681265, 0.00133829632795752, -0.0114340484524366, 
0.0154099701334207, -0.06985428361113, -0.0093990821014634, 0.0343306538605099, 
0.00452100550910663, -0.0913089984777083, -0.117080072134515, 
0.0739575328793969, 0.108668619977343, 0.00357944715280188, -0.0280479035824962, 
0.0674842342794878, -0.0181115256001464, 0.0340543514400773, 
0.00981929745306614, -0.0264579747585803, 0.0528152542522003, 
-0.0664935467208838, -0.0278069539357060, -0.0471013789211550, 
0.038439308807632, -0.0460834712980429, -0.0216851530151079, 
0.0287681570164152, -0.0421071311138863, -0.030029877225678, 
0.149968380032012, 0.0792171398906659, 0.127016112741936, 0.058252203697815, 
-0.0738086826400476, -0.0956536249101953, 0.0127907024048928, 
-0.0189733618055331, -0.0407335616275609, -0.0481164739204545, 
-0.0291042403402267, 0.00445423756114804, 0.0298409535637598, 
0.122478451836527, -0.024847819333089, 0.0305498532581161, 0.137575307735665, 
-0.0248852732905755, 0.0576571297577987, 0.00149284729988180, 
-0.0785102277646519, 0.0420725550382626, 0.0140721966568064, 
-0.0235503412255724, 0.070362486175311, -0.0941385976818127, 
-0.0246019798206956, -0.0576398141966559, 0.00284079553213810, 
-0.0308390918061599, -0.0306977604602971, 0.0667290046028233, 
-0.0582481581380969, 0.00300837632068361, 0.0313637728928537, 
-0.0097999878496783, 0.00439091327444756, 0.0284098539920457, 
0.0356736109155045, 0.0643618372682403, -0.0498653440168028, 
-0.0473060808969264, 0.107500543877365, 0.0293613677822669, 0.0125789855763898, 
0.0675350136260304, -0.0235812750302944, -0.00186606642201910, 
-0.0381869543737086, -0.0723491849034416, -0.0299619220124505, 
0.00311416251755714, 0.0261234733595837, -0.0914605472451756, 
-0.0258718787113056, -0.0556485351926956, -0.00190354026048436, 
-0.0480693166233814, 0.082588564406961, -0.0849427524490191, 
0.0142459103572823, -0.000310070087109269, 0.094904846868328, 
0.00673779444867085, 0.0179928286563756, -0.123614706375611, 
0.0277933263232813, 0.0321718385980962, -0.115718218895363, 0.00344457890643593, 
0.0190071015604239, 0.07317539963259, -0.00158327236982945, 0.0385147034500375, 
-0.0145110291933289, -0.0118435034598450, 0.0140581876240855, 
0.0560988266161303, 0.00675854379730926, -0.0528325036554574, 
0.0890103847322023, -0.0313506821257829, -0.00752291077156393, 
0.0554885430269902, 0.00292078877493089, 0.0564859252341076, 
0.0937436831381461, 0.00423699155629572, -0.110675869841751, 
-0.086705548767776, 0.0271979537926748, -0.0671924972102397, 
0.00457312349902285, 0.0081121258845182, -0.00878001444046762, 
-0.0251079037730209, 0.0451422273959149, 0.058626033542021, 0.0149227634345389, 
0.108683827612258, 0.0107222508875482, 0.106314269635732, -0.098481704086329, 
0.0404883747462608, -0.0960709602315536, 0.037667716675962, 0.0279126205221411, 
-0.0915487881028925, 0.0241610334285675, 0.0189321372903868, 
-0.0400220199650504, -0.0240312362799648, 0.0125941732993770, 
0.0185674387346729, -0.0106151640148249, 0.0621446327299639, 
-0.0759265558622874, -0.0426466069736782, -0.0139283862371775, 
-0.0575793869399881, 0.0408274818378328, 0.0450029687724555, 
-0.0691136045508206, 0.035306560880316, 0.0399451761105031, -0.00101848716293979, 
-0.118362123641786, 0.136831909723200, -0.0766881296843866, -0.00769539653315803, 
-0.11590471926984, -0.0348528313256959, 0.0220896200114373, 0.0277233143571054, 
-0.0810250834758424, -0.0618214798421717, -0.0408268590196762, 
0.0797605552242844, -0.0648894198472798, -0.0441035587674282, 
-0.062179511972341, 0.0374189960072808, 0.0527465733518, 0.0824323830547125, 
0.0177712540594874, -0.0326024891679378, 0.0539133151555289, 
-0.0411918677514099, 0.000500665631374216, -0.113990329345873, 
0.00903727027343276, -0.118772627054388, 0.0318004772097493, 
0.00515525655632835, 0.0925618973282226, -0.0177812966196558, 
0.00462311721390099, -0.0649450484863308, -0.0508545754994337, 
-0.0562757307215654, 0.0904121087246582, 0.106743804890664, -0.0452445203772735, 
0.0997425527535823, -0.0342969799616774, 0.0438354371422924, 
0.135944220257079, -0.0221533119410485, 0.0148829352250457, 0.0722736884075822, 
0.0652269840048083, 0.0566060285435389, -0.0463254088387443, 
-0.00158749037699557, 0.0200515475911208, -0.0331074235551208, 
-0.0474642630779006, 0.0599599577539489, -0.0929945828127652, 
-0.0392620891485547, -0.00268196756589617, -0.0406464587972733, 
0.0427054513973539, 0.0268350957638214, 0.0393789016402123, 0.0869128112543841, 
-0.0465066998800466, 0.0598205445698453, -0.0174307231494838, 
0.00284970882939255, 0.0219905982234903, 0.0765179917237301, 
0.0333726332724805, -0.020147144232857, -0.0639011832369663, 
-0.0344574989943286, -0.0203969429780664, 0.0153756445064422, 
-0.00864676598457495, -0.0507496363381474, 0.0489519678229611, 
0.0585351591197452, -0.0117151066904779, 0.0150926570500240, 
0.0322122323283098, 0.0911356291455367, -0.165815690759169, 0.0391202091913068, 
-0.132222024971757, -0.0210348504070674, 0.0104431200976361, 
-0.0568500095516843, -0.0231031738806422, -0.00134559463100121, 
0.058942093354398, -0.033731690143474, -0.0751677345869325, 0.0515432313746991, 
0.0448411503150509, 0.0341712904465018, -0.0761888494636169, 
0.17944646329849, 0.000405347104353251, 0.0504853803773326, -0.120975442645167, 
-0.0808354828479587, -0.0468816514314903, 0.0545851568068838, 
0.0079812975997866, 0.0735738406641955, 0.0150761879561092, 0.0212993911873038, 
-0.006107398772663, 0.0369979161706153, 0.0369925982029427, -0.0126094462502139, 
-0.118777112891615, -0.0148005757322315, 0.0721771611596053, 
-0.116718173289114, -0.00685839079009652, -0.00986369952536256, 
0.0926816745038483, -0.0310853062795791, 0.0169375879127501, 
-0.0624384081046086, 0.0676101813884367, -0.0569007134000122, 
0.0495363744448661, 0.0346193653734993, 0.0418551033943498, 0.0700488166397498, 
-0.0327480146785826, -0.163121156591493, -0.0362335702677211, 
0.00688504442300246, 0.00287507798550641, 0.0401307237744682, 
0.0357337871770218, 0.0295873041543716, 0.066045248724657, -0.0145724131260056, 
0.0458649373349053, 0.0423726586149745, -0.035874578486852, 0.0292525098778037, 
0.104718768884049, -0.0359816985264592, 0.0610533675932854, 0.0209418377907314, 
0.0889262636775977, 0.0443553456211247, -0.0188011402721565, 
0.0505395651656635, 0.0174926596773364, -0.0159722902935209, 
0.0201085978769402, -0.0686649416629349, 0.0708343293586677, 
0.0310969824705044, 0.0600485770153069, -0.0206011344003262, 
-0.0093076008041997, 0.104706948803970, -0.0638048834415142, 
-0.0121273173495238, 0.0419989126666909, -0.0871354970166422, 
0.0627813414751867, 0.0136405322967456, -0.0710306318224032, 
-0.0245713430846116, 0.116548588054525, 0.0407377402256127, 0.0255403241318391, 
0.0868060288032352, 0.0994912773250326, -0.00241504402186514, 
-0.0121431327198589, 0.072446647187234, -0.0489468917518329, 
0.0103027102336237, -0.0284161231464484, -0.0210323140923129, 
0.0226961967985465, -0.0100120668800180, -0.0685553726830809, 
0.0202505905728419, 0.0344663953256867, 0.0288738273349353, 0.0326224047302953, 
0.00271942473229910, 0.085689301379904, -0.0211238738548391, 
0.0951635867252359, 0.00160623374732237, -0.0934609696318734, 
-0.0549575479419274, -0.0645997131724427, 0.0912366418704124, 
0.0499234895806811, -0.0631205938375573, -0.00518369276801186, 
0.0603301995736017, -0.0702450786059523, -0.0439804872166425, 
-0.0659073478626316, -0.0311275626325522, -0.122129829363140, 
-0.0307992876468261, 0.0295358709407544, 0.0101740642557940, 
0.0178918434500933, -0.0101127851330404, -0.0177142759381409, 
-0.0417683978249988, 0.0410198567031564, 0.0557949478201685, 
-0.0127177329249865, 0.0113956809542947, -0.0246246456662667, 
-0.0408097811510988, -0.0231935875954456, 0.0169399771104759, 
-0.0370090822241987, 0.0433082374507451, 0.0535998801080727, 
0.00906180016952926, -0.017790310056731, -0.00236319292445528, 
-0.0246508413997699, -0.0752909696917755, -0.0672344253421701, 
0.0556005690138116, -0.0565728400675914, 0.0368822390210191, 
-0.0144419863510500, -0.113019478725758, 0.00317515698183101, 
-0.0240891946066219, 0.0375185732942592, -0.0470951392510023, 
0.00821809424688105, 0.0254487598591434, 0.0610496555706961, 
0.0677707812987121, 0.0820773552512198, -0.0658733192221822, 
-0.161582712369151, -0.0470617471405206, -0.110857045947883, 
-0.093040061655294, -0.0173040456272551, -0.00314969923997793, 
-0.0411633818378647, -0.00136091111368205, 0.0292422358587073, 
0.108600938713180, -0.125460096158391, 0.021899498531766, 0.0577624301871122, 
0.089148357929794, 0.0371648457206525, 0.0260584254734989, -0.0824802350179528, 
-0.107698779484478, -0.000695913719784928, 0.0183900559130452, 
-0.0182484864845922, -0.0274874131665064, 0.0085858539405486, 
0.05046663662171, -0.105858502283796, 0.0364910075825335, 0.0174424536002077, 
-0.0198448448316869, -0.0152240696389014, -0.0646610956905724, 
-0.0861233222095582, -0.0436570131824431, -0.0289781832747046, 
-0.0166357773653576, -0.0541144363527671, 0.0503941413667307, 
0.0818106316271451, 0.0259686908265957, -0.0639115247025283, 
-0.109762499597338, -0.0867191809136706, -0.0197210663865213, 
-0.0466779190561592, -0.0716284810118646, 0.0312402444053743, 
0.0638293551407167, -0.0211777114969494, 0.0822551627375076, 
-0.0125706204410484, 0.0658275728212592, -0.0189340817103023, 
0.0712486987044729, 0.0524900629689355, 0.0651910764588906, 0.0206045464153274, 
-0.0120032046378776, -0.0810474067017465, 0.0404741604754084, 
0.0829956106837733, -0.00557236946191259, -0.0890197897449013, 
-0.00685459197610569, -0.145764530349500, -0.0268861130019551, 
0.0289668604754345, -0.00988594176377988, -0.0715096795430712, 
0.0516137750752562, -0.0831696558422582, -0.0176355384529899, 
0.0698496766014776, 0.0122338364075607, 0.0933717941467222, 0.0519731416209576, 
0.0970700488803618, -0.110670602101698, 0.00557083668597703, 
-0.0604049146077782, 0.0670768633194676, 0.0232543305046189, 
0.163777215037485, 0.0477063800652429, 0.0486996198482971, 0.0294382147585988, 
-0.0716143396617663, 0.0311151723257556, -0.0710753510109465, 
0.0237521270669179, 0.0278912380894202, 0.0134130603995505, 0.0710054090955483, 
0.0523767442205277, 0.0396217224248884, -0.082978365977956, 0.104889420727023, 
0.0212981173733784, -0.084713317281461, 0.0198505025276512, 0.0347517954254026, 
0.0699930965399045, 0.0548033026976383, -0.0162533297075377, 
0.0284944563162034, 0.066275975533534, -0.0252326406072273, 0.0110999308377033, 
-0.0049571230878201, 0.059776521358576, 0.0166894893272972, -0.0587281305519785, 
-0.099436632679032, -0.0461125396300614, -0.0744569715257657, 
0.0448039325486935, -0.200611745909603, -0.0650627735179877, 
0.0507910655215155, 0.00339890686778337, -0.0611891727964596, 
0.0597665436070547, -0.0312310330815517, 0.014165489753943, 0.0903899218971738, 
-0.0764387343710187, -0.0803480836618872, -0.086180233445603, 
-0.103758549401162, -0.0148437479204053, -0.0763924452663672, 
-0.0135181992248481, -0.0678498129259245, 0.0232868961958272, 
0.0424510753656649, 0.134783951650453, 0.00914794095758902, -0.0321464610757823, 
0.0810989680634194, 0.0178788409510527, 0.0853373300855678, -0.0323170434374575, 
0.0411713923021496, 0.0146879034242263, -0.0597694724325988, 
-0.072135777590042, 0.0302401757807516, -0.0686253368320955, 
-0.0326354315051621, -0.0182303038040087, -0.0268202744187644, 
0.0560809239323957, 0.0165972452854575, -0.0822358747979673, 
0.111257180697948, -0.0565049437257227, 0.0123316284136456, -0.0249847648306239, 
0.115825968036601, -0.00373322079444222, 0.0808452525984095, 
-0.00914657872686232, 0.00846123893841867, 0.0391296603630879, 
0.0252007022452665, -0.0148568510649806, 0.0049411260355627, 
0.0354033121698702, -0.0495554342183499, -0.0675621724755397, 
0.0152850612156243, 0.112292877914272, 0.0554563999575869, -0.019789740611006, 
0.0520355947448929, -0.0703719723397492, 0.0500856699039526, 
0.0778835078594192, -0.0505599506795226, 0.0362161551861083, 
0.0215246948314488, 0.0288734418767334, -0.0697904439807352, 
0.0390047419696543, 0.0177456707452700, 0.0124488006905185, -0.0173329792648684, 
-0.0457235954660559, 0.0306930082344234, -0.0419080557236362, 
-0.0917077188979195, 0.00307776628573513, 0.086766068226509, 
0.0187750871998790, -0.0654268942810294, 0.0171552508719481, 
0.00576633013647442, 0.0351771458480403, 0.0544110066948165, 
0.0614830202418237, -0.0165073028256434, 0.076156365068795, 0.0195083298913992, 
0.0823004960583447, 0.100772766262261, -0.110553828718481, 0.0213262521150632, 
0.0241893401932118, 0.117163695012428, 0.0536492933354201, -0.0185525115173822, 
0.0177561514701895, 0.0226218822490274, 0.00690944425351215, 
0.0444106520366024, -0.0700276147492067, 0.0633820797112538, 
-0.000300533824194184, 0.0555824211251311, -0.0206592572523882, 
0.144511550664850, -0.0770370674984032, 0.0511711752272293, -0.0695045075158962, 
-0.00429394302061837, 0.00708884756824506, -0.0995879541548768, 
0.0430011033109957, -0.0374987376807817, 0.0275785594374023, 
0.00674695801173285, 0.000370246020727084, 0.0856570292551571, 
0.0562490775050724, -0.0287360997292298, -0.0663078353975714, 
0.0209865714497333, 0.0459522292118643, 0.178972019466681, -0.0131893934923389, 
0.0953035886541681, 0.0129451291047358, -0.109078802673568, 0.040649615994511, 
-0.00305760371258851, 0.0104930060708836, 0.0384725391087377, 
-0.0149621934538844, 0.032749436891537, -0.0619268476499213, 
0.00838384827318204, 0.0779387788221838, -0.0816982020591277, 
-0.0749251132572921, 0.0443913260967472, -0.109161666266611, 
0.108353935437658, 0.0570577975798388, -0.0276720375583252, 0.0100917124914357, 
-0.0677034122269681, -0.0452311195491264, -0.0304492692669080, 
0.0349238351176777, -0.0568074285786037, 0.0419072359302425, 
0.0616659849000985, -0.0361354422008088, -0.0142937482972150, 
0.0214143448805302, 0.0576482169875957, 0.119108695034428, -0.0667569296403038, 
-0.0799252171549918, -0.0773240784834148, 0.0634749995789512, 
0.100722785030134, 0.0456586713807725, 0.0411385304822491, -0.0468313977084939, 
0.0316220827075825, 0.0286300510834507, -0.0337111999263839, 
-0.0665640641965921, 0.0345403998699839, 0.0110290761692004, 
0.000109350849343372, 0.0161347414920771, 0.00253012057682462, 
-0.0102298308382435, -0.0202967221278413, 0.0848273442624692, 
0.0379008925262196, 0.011730994676913, -0.0477243661492938, 0.0825581639875616, 
-0.0151581727992552, 0.0775061400487004, -0.00331141986985054, 
-0.0502243295202819, 0.0587814395060925, -0.0566794224021757, 
0.0119836429808024, 0.117637373705104, 0.0298113162012516, -0.0575626251392147, 
0.0128664166242027, 0.0589051922470755, -0.109900626194917, -0.0529811802204339, 
0.000481292250557917, -0.0167029538699233, 0.0234313521166014, 
-0.0476471107759688, -0.0659958422631374, -0.0400690094951878, 
0.00447066590125523, 0.0749353083308331, 0.00725775167588745, 
0.0276235608756489, 0.0371332141992509, 0.282949480532404, 0.183420791994146, 
0.305716960243872, 0.212929497578609, 0.284081781902486, 0.212774212920573, 
0.312742998561851, 0.387641466494079, 0.363424384000921, 0.282440346165562, 
0.341972447405349, 0.276969437454169, 0.29618485616236, 0.401947324210272, 
0.284842504244281, 0.322602931828779, 0.209630213303826, 0.401860530221417, 
0.263031401205073, 0.395397660101624, 0.310556853208088, 0.441471152714029, 
0.253935095853624, 0.33138838464104, 0.334215222749712, 0.267526632541018, 
0.288855143726871, 0.315236158258203, 0.381873998727857, 0.347599476997469, 
0.279784341159430, 0.335146505148427, 0.240722475588094, 0.234976256431645, 
0.420909323497122, 0.231915331540646, 0.342927944606756, 0.332068958223859, 
0.319788741750255, 0.283338687299109, 0.263443603184013, 0.302383024792158, 
0.301908823077773, 0.252034866623694, 0.33849745501708, 0.251415971929401, 
0.265788521723782, 0.363782269323753, 0.271545077004944, 0.341831214388374, 
0.294707545942521, 0.276069301142175, 0.183336569812899, 0.248654808278543, 
0.311360551150568, 0.311603052592924, 0.41700924620439, 0.283121027485123, 
0.332936340517807, 0.339661461557352, 0.365293350499153, 0.352163565341448, 
0.290030783162888, 0.434681561619111, 0.321165214073478, 0.288831110029845, 
0.259286306527832, 0.240896034284558, 0.305796887835478, 0.351544641898389, 
0.260502210874724, 0.319456317890326, 0.320716792344788, 0.379363156222174, 
0.264407073436534, 0.230265492220025, 0.356657612778796, 0.32490739505856, 
0.233299026404706, 0.237497074455946, 0.260620245377728, 0.298526466435145, 
0.275484369598878, 0.271744809278388, 0.43809580039619, 0.27526614041072, 
0.277969012424995, 0.235393643039069, 0.351171143685522, 0.287835096741060, 
0.242405799631406, 0.38920648200174, 0.306180078009215, 0.247279315687863, 
0.353640643131825, 0.204762115112138, 0.290455676135400, 0.232546352063229, 
0.389831699410757, 0.367520483429188, 0.338929364588126, 0.304852769961722, 
0.326658285710125, 0.354410725654214, 0.343988869539778, 0.310359649261773, 
0.326697779927438, 0.433315607490909, 0.280520378719806, 0.216110168004609, 
0.347995065555438, 0.215333764602222, 0.300611213202579, 0.374489826730772, 
0.397892840141772, 0.260912977555764, 0.408222451134916, 0.324627081373551, 
0.260458457736227, 0.367776120877123, 0.320310577565315, 0.360521730567665, 
0.379545822298138, 0.234686902392336, 0.327380275180594, 0.296904341743799, 
0.341454162465095, 0.330957619764133, 0.296973434447445, 0.321888016328592, 
0.293516241972731, 0.207797225557414, 0.287485115889483, 0.338408855890719, 
0.357039639246837, 0.255251665438147, 0.291052254411834, 0.338924980887778, 
0.210592308634244, 0.190852907745548, 0.270508689968071, 0.271189591498775, 
0.310687100559187, 0.273366930082721, 0.162419924680056, 0.278281879338744, 
0.264945269134721, 0.252669443634206, 0.320381600736433, 0.265449914565696, 
0.397372869471037, 0.292685835834602, 0.307051150208214, 0.309609493634453, 
0.186042617709584, 0.128332274972835, 0.212865123058935, 0.389870294167262, 
0.349019182754467, 0.244603021699580, 0.300927953087406, 0.198195687833615, 
0.240859334079795, 0.294537825638565, 0.328468152576965, 0.363254847799998, 
0.339760252715556, 0.309600783447069, 0.246356364767558, 0.332120163387884, 
0.366156824161027, 0.294007998274236, 0.250761468506553, 0.348959056565487, 
0.308074775914411, 0.279782800399208, 0.274044616963579, 0.295092968022867, 
0.358480119039271, 0.408675367679503, 0.353008484375128, 0.328123596094351, 
0.338882796660845, 0.322775420537526, 0.274399920171056, 0.328375895077763, 
0.348267795436106, 0.321876549799787, 0.289442788251523, 0.358081860267568, 
0.207698885841175, 0.331148775861707, 0.414200784860449, 0.195799862062188, 
0.413698020041752, 0.26306640261112, 0.183739264431284, 0.420022722343703, 
0.307901101144662, 0.180589873393166, 0.215590312389760, 0.267325067038754, 
0.296477064270637, 0.314938833002994, 0.226025114603341, 0.240295345296743, 
0.198793544297060, 0.337409307149216, 0.226083229590564, 0.347286244389690, 
0.317468604663726, 0.229909827829157, 0.319317948009444, 0.259833015490543, 
0.231811160103806, 0.342521885084803, 0.278131589109747, 0.350054652209660, 
0.2352140667217, 0.220369409150334, 0.342695828550798, 0.41326229068091, 
0.343512068438983, 0.291530750438092, 0.266706486782100, 0.328172829316968, 
0.272114158403261, 0.255738995954561, 0.355857576446488, 0.343569320032030, 
0.434186450852912, 0.280638746187881, 0.387239769993433, 0.327584271678759, 
0.293458658293820, 0.330823976654678, 0.239538677993834, 0.309985570148579, 
0.320455873265917, 0.244210944117596, 0.418323323329607, 0.280780148130011, 
0.31847850611567, 0.350228293004303, 0.31634310226907, 0.269411970847814, 
0.329182002544074, 0.319014379814796, 0.341461435381392, 0.286078240442656, 
0.233297812055833, 0.255311547095421, 0.299315499900567, 0.301350470234775, 
0.303371792400176, 0.338650516719967, 0.242747991639501, 0.0993156367263534, 
0.310448699533515, 0.253598428807595, 0.270231717023246, 0.272304964808864, 
0.284034982477965, 0.376289967849739, 0.319517122326129, 0.264690031891767, 
0.394564625820137, 0.384726376664246, 0.321755119225643, 0.361646922094442, 
0.202143656575213, 0.289136101472786, 0.341220474049703, 0.272973854264969, 
0.313821581388752, 0.360093687016156, 0.311211192692324, 0.283497449870763, 
0.302560375095069, 0.242222328510252, 0.289351651555613, 0.238692794980976, 
0.357049052352194, 0.263864551776083, 0.374630479255811, 0.231181457341572, 
0.325957291594048, 0.34676727412981, 0.375080975582704, 0.234562225512682, 
0.339989554852156, 0.301930164810106, 0.239097903575462, 0.35695686202467, 
0.331983567615612, 0.326149140483938, 0.344900188084227, 0.388336541790492, 
0.267822573302883, 0.358578312988352, 0.226618789393234, 0.420692158061735, 
0.269039604632836, 0.21357025202009, 0.274144493028969, 0.216471463869836, 
0.267075260554667, 0.308833420047254, 0.188911784408159, 0.350527207301342, 
0.334160305405184, 0.294661766117678, 0.273089282798100, 0.298851930849576, 
0.275796211358752, 0.313273911813884, 0.309237821862683, 0.238062662146501, 
0.263852037571100, 0.334690615111753, 0.284378528146228, 0.201845853933198, 
0.220815369864577, 0.414529614451722, 0.321840157849653, 0.314044954859620, 
0.363342069824268, 0.225563496747175, 0.333964608249504, 0.342161708558923, 
0.295992376265060, 0.224085830115741, 0.294027365365847, 0.342238254734471, 
0.263911008713976, 0.246440825248976, 0.330489775453900, 0.310647466282722, 
0.286786420075624, 0.229239225237136, 0.300266279019498, 0.287553923255026, 
0.299794918327056, 0.307804472439609, 0.250568873316504, 0.334989934887237, 
0.270650635577664, 0.347147584964369, 0.197958811453978, 0.383016929766704, 
0.317764794300783, 0.308790768419314, 0.295937301672420, 0.380227287197923, 
0.378006597745634, 0.204795933948993, 0.296011023360739, 0.336861472821912, 
0.194698692564463, 0.361882057860102, 0.258831056246064, 0.327574806804339, 
0.284741969101689, 0.406887501743048, 0.305117346466891, 0.325411878211273, 
0.188563094870866, 0.299889627533085, 0.303179064532324, 0.417484045299716, 
0.302016607055695, 0.374535310390935, 0.248000451103946, 0.371860420074522, 
0.329215585243060, 0.441876876403619, 0.337887584816996, 0.387335376676164, 
0.220037068757972, 0.330399942868598, 0.393791897756397, 0.288053231048255, 
0.355532599884346, 0.319088660527519, 0.330316090305927, 0.342363280844806, 
0.296584093513053, 0.330307443748079, 0.155761825861067, 0.340574985176586, 
0.186644828222285, 0.270332289071488, 0.297073134027426, 0.359905221270618, 
0.317374319874043, 0.350082758065347, 0.215236045228623, 0.250709278087299, 
0.358460096819683, 0.350846677489628, 0.337992023545559, 0.268629857697287, 
0.293163472000919, 0.384919809694484, 0.352339212224283, 0.192732130009030, 
0.285070843752236, 0.274701133356164, 0.305407609201288, 0.319446015847241, 
0.316181944833369, 0.353456940896668, 0.242656252556491, 0.275673180016002, 
0.356098742308011, 0.30874465046903, 0.391898101135296, 0.288534280809808, 
0.290936703618176, 0.359325284677195, 0.346217006501942, 0.261054909585089, 
0.306476817330418, 0.331596743886622, 0.316229058125408, 0.230587051586308, 
0.340237658805982, 0.272399485776088, 0.266452862346399, 0.329042338820781, 
0.205382505324886, 0.207857489491536, 0.350675303802891, 0.357873220114725, 
0.228235091022222, 0.229224234033768, 0.268723929731668, 0.250398319230841, 
0.254724673868926, 0.269735202288079, 0.26874309262819, 0.342521307416932, 
0.326468039252658, 0.322758491009735, 0.274266851883893, 0.284047372064664, 
0.368755019515323, 0.167511115004605, 0.247086958929361, 0.288882201752699, 
0.269354222348092, 0.237013560150809, 0.261582447142375, 0.500679851550658, 
0.346418920291784, 0.273425072848710, 0.224505707758645, 0.320857898355143, 
0.255985809293736, 0.343295051294307, 0.36719353944013, 0.309055054004462, 
0.350445139923109, 0.261463651141688, 0.314995250385531, 0.317853336565529, 
0.357771134143818, 0.279429156524014, 0.249996934438495, 0.365002754964397, 
0.287633101946789, 0.168127651362226, 0.420855784667102, 0.255433017363361, 
0.2743402275473, 0.302678042243504, 0.264067913144492, 0.23993780889061, 
0.300824872817552, 0.255368102541845, 0.285998768683159, 0.320987437918711, 
0.233514081077390, 0.356532194419561, 0.360804094151907, 0.270832276917087, 
0.202526682908463, 0.481378570872795, 0.306456200302994, 0.304278325048408, 
0.337317659886269, 0.26248651037668, 0.300823545838245, 0.305468141640145, 
0.300228028420144, 0.243709317600878, 0.279115249955920, 0.304724137032381, 
0.372378200459818, 0.275814206367909, 0.373862067464635, 0.293387362438546, 
0.241458003539406, 0.254913598799364, 0.321257921240173, 0.277762668758380, 
0.318961762353544, 0.27797882062923, 0.238839598673419, 0.28176184069714, 
0.332800589783934, 0.251800996297342, 0.310781506967216, 0.297281798271607, 
0.274080874382704, 0.283224627865898, 0.332207318316469, 0.356283493407063, 
0.270563487088992, 0.279118052367128, 0.241747539823165, 0.269829579153315, 
0.410792146411519, 0.204043032402631, 0.308596345573170, 0.263806397250265, 
0.328800724755457, 0.29141416326221, 0.360676671925823, 0.269426683576523, 
0.286997109188283, 0.255880707515725, 0.370136934170576, 0.246267336471549, 
0.33950475512487, 0.32875003161788, 0.225255500818446, 0.360611251539656, 
0.259645773959431, 0.305965982241493, 0.320291141113661, 0.280519579096519, 
0.401840712022494, 0.285290733009697, 0.278886033819694, 0.343512853787961, 
0.297787946463047, 0.366353962244325, 0.339208348414347, 0.261372026269988, 
0.296528754175689, 0.363050727625134, 0.249487269889237, 0.343721183978863, 
0.192389902559201, 0.335534860456889, 0.210007260746604, 0.295191688163847, 
0.32425942761106, 0.317817744505076, 0.274282157466686, 0.282894976559522, 
0.291563678475662, 0.341876874660341, 0.283015738280455, 0.297364062334377, 
0.322969710223618, 0.276031830282078, 0.227538006440072, 0.299533041222506, 
0.382405079910995, 0.349794381548505, 0.255317478549417, 0.372762724499217, 
0.307173146144302, 0.313521242732704, 0.349023532685595, 0.209554201477011, 
0.266474359006419, 0.267580958058875, 0.37452069221549, 0.283938529477453, 
0.343852022976855, 0.376538313210932, 0.261325621612125, 0.267868713189062, 
0.256496235239252, 0.318154729794574, 0.252414869365622, 0.199040707714667, 
0.294040542190263, 0.386056569478721, 0.321119927589516, 0.24617616991783, 
0.302147891822518, 0.272019632266601, 0.249449818828449, 0.36305360569661, 
0.255157172274028, 0.369534789320331, 0.295017937845739, 0.313214562280101, 
0.245631139601027, 0.372758065893326, 0.319416109989512, 0.340370453690179, 
0.280338033737163, 0.3061602304737, 0.291142633746884, 0.350185364138864, 
0.188633331592669, 0.269929044694734, 0.333768774063045, 0.275344092586020, 
0.394986727361761, 0.374302993921081, 0.319684439911145, 0.412817335120103, 
0.327246525852933, 0.343610106511392, 0.238712716252587, 0.239054817379644, 
0.330007149881045, 0.29406764531053, 0.362216934287302, 0.357888399458939, 
0.271891345478745, 0.378217495798826, 0.325116059143441, 0.274490394661951, 
0.356395690735836, 0.255101830381246, 0.250782497165522, 0.327147982351961, 
0.387037843720824, 0.267085813125978, 0.31618381621074, 0.396258315906924, 
0.363928400781489, 0.285200611046287, 0.237938485717238, 0.253159559843920, 
0.185144422290697, 0.334468720821365, 0.248363893329655, 0.258752399064923, 
0.319858594608073, 0.326776304377416, 0.313417314959531, 0.335570119799675, 
0.233196140017357, 0.275872439155688, 0.272007495262823, 0.232195170523633, 
0.339569779512918, 0.240439191656443, 0.295316430696412, 0.297228825957178, 
0.23692369135496, 0.341895466721058, 0.253083784360509, 0.342773801033718, 
0.280267316685981, 0.335679231133203, 0.261260886942798, 0.259746185223810, 
0.376113101207934, 0.345554857098727, 0.27436040430034, 0.178238163806493, 
0.379713976189213, 0.314343333841359, 0.36800291420243, 0.328774854051394, 
0.282413048231079, 0.264140696038123, 0.273599213439478, 0.245154058287706, 
0.325466073344607, 0.303630750511345, 0.331079333164596, 0.290090005290267, 
0.273231386502173, 0.241497899488611, 0.253081686180022, 0.358624511805263, 
0.264332254479665, 0.123003059263137, 0.388462955723724, 0.337897605228397, 
0.310385251043304, 0.253974175377014, 0.272922451183719, 0.314388687739972, 
0.267381530977520, 0.333624453275348, 0.333229903972559, 0.314090902051876, 
0.295379350790832, 0.309896251588035, 0.317221879859, 0.319870852624839, 
0.253741876028837, 0.249867702578675, 0.300749464274366, 0.327141772207723, 
0.448150253721712, 0.318343450388926, 0.383075437649364, 0.225990917944795, 
0.272016765459736, 0.365925627224429, 0.315904040396501, 0.270868437085112, 
0.277795409930713, 0.245483976595898, 0.384489067601637, 0.288511052458868, 
0.280042789525603, 0.274683953535041, 0.303553557176, 0.341285982492866, 
0.323751031916031, 0.399085784249698, 0.473055428946197, 0.281298493972753, 
0.365611873157750, 0.345059100851023, 0.254476205574746, 0.21788952987054, 
0.264349972513646, 0.266742426464356, 0.415651234830359, 0.279759030911097, 
0.203420620110088, 0.377014922905711, 0.348342059953035, 0.355570868166679, 
0.304581980855294, 0.34706148416354, 0.313270582031464, 0.297397593436544, 
0.338277198134721, 0.333537289214763, 0.283470952887773, 0.283612512976018, 
0.40041042579503, 0.338570471001385, 0.309016865072945, 0.281255590653319, 
0.362771706482764, 0.250257007041714, 0.305933050264271, 0.279474505883210, 
0.240301670286248, 0.295243542541642, 0.276070779605593, 0.284708677460362, 
0.323095190985875, 0.19631648926281, 0.304636072417318, 0.274853192102745, 
0.274517787646672, 0.382173145039194, 0.332917148538604, 0.342271565896854, 
0.255222355664947, 0.304707520249219, 0.230405998077725, 0.339711572213072, 
0.284721035856145, 0.419824314263242, 0.279982597366289, 0.296361343669343, 
0.308426380237592, 0.355041273693147, 0.337854762802885, 0.287722358778981, 
0.281093937816937, 0.326359732162346, 0.391688410623706, 0.379633250860271, 
0.319156153288249, 0.270655558801376, 0.242290835472025, 0.326972381462415, 
0.306972352444688, 0.291908277395748, 0.256522925180221, 0.311893532170065, 
0.305689136424979, 0.326973826904814, 0.235272062211693, 0.308350712482059, 
0.29999795015528, 0.337672822518699, 0.218095440674411, 0.264061689893466, 
0.267504122671711, 0.233956789730531, 0.304196675782206, 0.274306236535002, 
0.304760701566913, 0.345951988414768, 0.254927711794119, 0.368164483943623, 
0.254890483866733, 0.377966727871254, 0.171432893044958, 0.325681797450235, 
0.308116552460216, 0.21956594525742, 0.276051839243787, 0.306680277065186, 
0.233391273937380, 0.389287323347685, 0.305193827318813, 0.312170295311103, 
0.340769367079606, 0.262186337579645, 0.305508068898898, 0.256190598253504, 
0.285688504251165, 0.219835517624659, 0.375616874507089, 0.335027814122711, 
0.283983759238972, 0.44539139758673, 0.341860999475557, 0.212705191180953, 
0.406248273524623, 0.297845273693775, 0.310488243017891, 0.336065579108514, 
0.22616749805249, 0.330709489440245, 0.274416781327928, 0.280778559538418, 
0.340162338913374, 0.263167293938176, 0.384985282754794, 0.304675522159458, 
0.374371078151884, 0.435909880863359, 0.337342657139847, 0.325909842029904, 
0.254626564197018, 0.244261018339922, 0.315575945314184, 0.198401737766355, 
0.295317620731779, 0.276365403862389, 0.273264044079221, 0.278201135642376, 
0.235285042683679, 0.365488795622096, 0.34018661668948, 0.34531464873918, 
0.377026041007172, 0.326787937833955, 0.349816384199996, 0.266679019749197, 
0.407539997283936, 0.220721600043799, 0.264573170968134, 0.290121967202793, 
0.242405530095037, 0.202252535757041, 0.174152659034691, 0.273378736937174, 
0.293045431406883, 0.331700871805904, 0.407082870863485, 0.291361555249424, 
0.31909347980982, 0.270816422367184, 0.303881142355627, 0.34889035379173, 
0.297665389573656, 0.346387962087553, 0.301527306724134, 0.325164422002019, 
0.288714747273937, 0.378506629970608, 0.339193428579193, 0.333871507896842, 
0.317681711258528, 0.304387081992372, 0.277221650462808, 0.292905864965592, 
0.333456018525761, 0.393026965579279, 0.235428791095371, 0.375203901210545, 
0.192267405666549, 0.253825201204180, 0.258799797749456, 0.330733254841793, 
0.272461422767784, 0.271127894449326, 0.27705023837305, 0.347926303451529, 
0.264989738285088, 0.311396580099097, 0.433075146124365, 0.310214972755426, 
0.317815028322463, 0.307777498055688, 0.180688118135675, 0.352553658220851, 
0.221762643809347, 0.300453428912511, 0.295040344764217, 0.183167582410804, 
0.31260489591298, 0.260338411522722, 0.253004933008333, 0.392180625389104, 
0.24178934708292, 0.304444891209358, 0.213366225603177, 0.170742292988487, 
0.283967852806866, 0.252250448360881, 0.274929392238076, 0.247772114907867, 
0.308634142874, 0.266431147112755, 0.287833033395917, 0.257518811079104, 
0.186868569459361, 0.302066174992891, 0.313907984052465, 0.331755605039473, 
0.417398291818359, 0.277397170896578, 0.280370974859058, 0.221724423651135, 
0.296442277306733, 0.433929087064491, 0.344177680634293, 0.306086944749284, 
0.301878991682742, 0.151563602668114, 0.334417450264727, 0.362028709839724, 
0.254563255903537, 0.252253802990631, 0.31168252464641, 0.320716104726211, 
0.279906939947741, 0.282962495921475, 0.443147041111998, 0.30536024793693, 
0.296024697182507, 0.358107540277094, 0.322850793617737, 0.316828529446659, 
0.312190625789407, 0.206835340696943, 0.245464634943295, 0.259822219421921, 
0.272307901126967, 0.342462592562675, 0.274840103689245, 0.331197558690321, 
0.404926947391544, 0.343869583606131, 0.263637825003111, 0.199999250539571, 
0.318771766989538, 0.288900782944981, 0.169410879275310, 0.292256943515826, 
0.260937872190562, 0.228972171046082, 0.341254757762868, 0.275782261213241, 
0.289438478146574, 0.336943253624271, 0.372712731476537, 0.293357259141704, 
0.257689685133258, 0.253087593524207, 0.318173626981747, 0.32232192649769, 
0.309558561043159, 0.312848651534926, 0.249644293935045, 0.330540248960557, 
0.311606516690516, 0.491862768519943, 0.309757368275759, 0.263896798917626, 
0.181366994757761, 0.326941718908814, 0.272640014441854, 0.294779758275573, 
0.257121496258212, 0.294774173419199, 0.607825533081897, 0.580273263027707, 
0.531137511880554, 0.533169195704517, 0.555434908415617, 0.557039047044044, 
0.6251106968307, 0.620441948636565, 0.631553249519508, 0.590289929244905, 
0.583592873111899, 0.631220873637296, 0.6032070280643, 0.702926114145948, 
0.61407984436829, 0.535549216868541, 0.507337947285079, 0.59151470434755, 
0.607322927212046, 0.568788695288993, 0.635713601708944, 0.577580948185649, 
0.642539441106983, 0.627085331530287, 0.57998096620146, 0.603616217856415, 
0.647087611785973, 0.564002738953658, 0.533580136028769, 0.586150345218503, 
0.666204106926336, 0.695835177558376, 0.622646030692963, 0.645867296659569, 
0.605470097123377, 0.666191231333409, 0.620250844725916, 0.649987926846528, 
0.650546055653874, 0.643420911497729, 0.596243870792737, 0.590702214493337, 
0.624968863197892, 0.520325378275486, 0.511106153317622, 0.716232511785262, 
0.565656647810731, 0.685822423161134, 0.584744357731071, 0.523687338485213, 
0.564577462580271, 0.621175199158825, 0.675395123647365, 0.629458109086384, 
0.657799680689582, 0.585356452619875, 0.657186496473181, 0.549492230475543, 
0.532102925396758, 0.60038377021221, 0.56734387522921, 0.515839468637586, 
0.603130162021709, 0.654054834891567, 0.534977030817602, 0.585848285015856, 
0.616882287887871, 0.614892957143906, 0.605291424807604, 0.628508440039839, 
0.58650110003214, 0.587858247440662, 0.688479946529877, 0.564479359071971, 
0.631089338333356, 0.507220609518805, 0.542241784986115, 0.586186090193545, 
0.616398337309751, 0.686073099647876, 0.54472705287508, 0.620088128860597, 
0.506486828707946, 0.690756560598098, 0.540301505042137, 0.584041436296495, 
0.622810797842625, 0.61314709177522, 0.569418167533534, 0.64151135784769, 
0.627194208790439, 0.648480756462919, 0.533648092581408, 0.555756949660411, 
0.617846166876587, 0.59101188174781, 0.674587469926962, 0.563085275845992, 
0.603217680412366, 0.594317763109183, 0.514868851423707, 0.581775555410947, 
0.649629739021527, 0.590876084908093, 0.563999407855517, 0.596228808675253, 
0.598501198093547, 0.566701480568406, 0.68217483485932, 0.600712596073933, 
0.620156015145556, 0.642661009801504, 0.511594847285212, 0.644091193802607, 
0.632740711158638, 0.542253078709738, 0.546668585644307, 0.638182162133862, 
0.498587653231513, 0.506839990144459, 0.670474212572338, 0.571361603687874, 
0.568596183710385, 0.621830346392406, 0.628926150123885, 0.584691504990671, 
0.532751811229589, 0.619489363820636, 0.555029076100034, 0.602895822470115, 
0.657899704744568, 0.507811608753665, 0.685132287589771, 0.60628134350032, 
0.592053650271922, 0.584359141495873, 0.575861388061466, 0.678869893976584, 
0.589250955229504, 0.572941757631501, 0.651717187508735, 0.593673245357782, 
0.623649778891955, 0.635883421092203, 0.607493972022328, 0.569592863917518, 
0.696777377567192, 0.535991534891549, 0.621377521826042, 0.656215658463989, 
0.684526536560704, 0.65061356683457, 0.600685258773902, 0.623700127189419, 
0.622703292777475, 0.617989893613084, 0.568196667320587, 0.593519571565115, 
0.562875260628409, 0.614833550434183, 0.621512897303118, 0.617158993957222, 
0.599518227268703, 0.590255724220974, 0.579609312638657, 0.511471188188335, 
0.549916197263957, 0.65042677246559, 0.556639204258625, 0.594048642272301, 
0.591131344353324, 0.550669562032916, 0.574301495835495, 0.57294296876483, 
0.611559002214296, 0.588005267218569, 0.62771156562694, 0.607958522090356, 
0.58912932622187, 0.583734536910800, 0.585170111083883, 0.561212653770101, 
0.480767956536761, 0.578808795554564, 0.560032260961394, 0.559485787840043, 
0.606763491648815, 0.585375900983955, 0.536760249869249, 0.59187623504293, 
0.626301076558351, 0.539934610106041, 0.615865253364818, 0.538451982657769, 
0.584177820270847, 0.615513373695085, 0.63409169049489, 0.536725864128287, 
0.648010777524675, 0.633764194640652, 0.54570553019484, 0.599534198382102, 
0.568334612144673, 0.577952706196292, 0.630648417822393, 0.579394802031282, 
0.56486755363931, 0.608266889673245, 0.61835377473696, 0.582619927244394, 
0.512592932420937, 0.540988461736082, 0.631018119588611, 0.604521505269461, 
0.538714532121372, 0.600192548218572, 0.588341129885811, 0.607583748890986, 
0.596161537629586, 0.603558215716018, 0.622696886913167, 0.587340102830713, 
0.636865026839718, 0.66846580556952, 0.637244827363284, 0.571026880716362, 
0.649557125235667, 0.516541269986397, 0.53154690038001, 0.593173314661709, 
0.645511184802322, 0.542665164899874, 0.598061613812194, 0.585111174841946, 
0.672346710584103, 0.689453927065195, 0.629538792384855, 0.553867626931493, 
0.571479783101856, 0.614939127875993, 0.574235791636891, 0.63325925700798, 
0.563893360050741, 0.611116234000285, 0.557438855651718, 0.6337203071391, 
0.603701476863374, 0.499092565404592, 0.536028045999805, 0.580048634284097, 
0.636698395887363, 0.567142823847687, 0.598024584679874, 0.57369814763711, 
0.60428566834796, 0.535132532632810, 0.626574405544264, 0.66492940219524, 
0.541763479659138, 0.69260763616664, 0.575379518328486, 0.558833214304834, 
0.589617629159307, 0.616195819021933, 0.554538234763171, 0.592235506871722, 
0.615153092521218, 0.640060572254846, 0.571898914381248, 0.593424868514752, 
0.551414653029023, 0.616105895557722, 0.655011074822188, 0.64508034562113, 
0.538944854681009, 0.510905779280177, 0.537250102286254, 0.650457639344018, 
0.65483540726318, 0.651528784194075, 0.63594911219554, 0.549713976486624, 
0.548140083524041, 0.641719866501756, 0.58449546881666, 0.579913201836451, 
0.590055668921476, 0.562876870676412, 0.639933344771514, 0.558926456876404, 
0.704288547273668, 0.566436341052493, 0.592964053544219, 0.64420246448164, 
0.622932067752625, 0.524994752941797, 0.61297526417859, 0.660860997392325, 
0.645112802796023, 0.534966574762713, 0.544644412745537, 0.67872333387358, 
0.553699747523802, 0.634237912890253, 0.603440005006255, 0.592800930696407, 
0.624528184793866, 0.57124471563359, 0.678300824080039, 0.543974424158913, 
0.595717548565325, 0.612054292694146, 0.527254905766745, 0.589832623707671, 
0.48626443048209, 0.648376413862886, 0.584296026624496, 0.571968422886587, 
0.546234527658416, 0.651707826301171, 0.545558624513516, 0.607358501376581, 
0.612045268635432, 0.628674990877001, 0.599187075885155, 0.652226220582893, 
0.583752363211471, 0.542248468231912, 0.60332047854224, 0.63781549365403, 
0.635813819324456, 0.623336475178008, 0.511168386514572, 0.59099708382447, 
0.644284258838757, 0.559642325789589, 0.586404649744659, 0.634463645338322, 
0.550652603605338, 0.590558693108646, 0.534480961006375, 0.553881373999203, 
0.626373491985262, 0.532239621164382, 0.552873384328828, 0.581334573098384, 
0.551165842418068, 0.552500839046285, 0.641613597057899, 0.601102321805363, 
0.543933546960475, 0.645497469870297, 0.606134644962322, 0.61291013356783, 
0.635395943259344, 0.640862772089226, 0.662733546831798, 0.56756130835727, 
0.593010207996654, 0.63313411838507, 0.549236273485949, 0.45265273755344, 
0.622574383957728, 0.569468391683018, 0.576100503270906, 0.650307546195558, 
0.64918341076127, 0.6386682971037, 0.616075886222939, 0.545634521966423, 
0.555333392022919, 0.540255471057717, 0.629194402555803, 0.519102562469307, 
0.683314422597071, 0.66851746682772, 0.649011932871711, 0.595862547797233, 
0.675698956990785, 0.668351607852896, 0.583433033628902, 0.648112829955008, 
0.565660017585995, 0.51307910196226, 0.55393872068302, 0.570340692779277, 
0.630963257925143, 0.534005572553169, 0.632085113310808, 0.570521375782698, 
0.597157280794698, 0.64675931734367, 0.585750602844882, 0.523525862279732, 
0.581400270351144, 0.56731901605797, 0.633498267130434, 0.5949197519577, 
0.53552750912868, 0.530384180783441, 0.624595495588832, 0.526961761765067, 
0.653751877112844, 0.531271806673103, 0.591173866132703, 0.567533315419935, 
0.631843191475888, 0.618958660242645, 0.532647881428895, 0.640065156717318, 
0.552431109511113, 0.6754332658792, 0.662770801440958, 0.543265853973383, 
0.603720236549545, 0.61643021697442, 0.694541904224622, 0.591720154062109, 
0.634216226448306, 0.579591763347489, 0.639260554742462, 0.538121512420269, 
0.589124943127327, 0.599830237605671, 0.61408265476544, 0.655435086141389, 
0.591484838416364, 0.579091478267478, 0.57075868617876, 0.531861657926473, 
0.61734837413399, 0.626240492664357, 0.546821350473169, 0.673887154588145, 
0.610971928124996, 0.615736605394923, 0.61166175167453, 0.594812387546866, 
0.675643585887976, 0.580337566864499, 0.54874715564987, 0.598197323849732, 
0.61381272632788, 0.567689545412021, 0.6870536412004, 0.550698350985345, 
0.669811353294262, 0.558453752630082, 0.570780330774314, 0.609797686077054, 
0.558445599077253, 0.628117383995353, 0.57257757163343, 0.566399386792853, 
0.660391879022358, 0.692198017238239, 0.607206225186917, 0.68672919677977, 
0.513522636209929, 0.561449710778565, 0.650211069611816, 0.620642318644242, 
0.651918284274052, 0.656714479923885, 0.600753867131767, 0.601222761424003, 
0.539110953584862, 0.741465655615967, 0.622135740265942, 0.608758061023782, 
0.571431025787278, 0.537445520207838, 0.610006176105938, 0.618726930298379, 
0.525849397295884, 0.56110722379698, 0.582931113293696, 0.562800311025776, 
0.640884029043482, 0.648699445597202, 0.549132282668088, 0.493561082249963, 
0.67827397488486, 0.641070644400474, 0.463620623370221, 0.662555403715514, 
0.569902608784886, 0.716837085128648, 0.60119760657187, 0.549988934391863, 
0.671889394580881, 0.638544467126052, 0.630660879602879, 0.676645836224065, 
0.567429214274848, 0.530192108659754, 0.650484329631827, 0.599398013168343, 
0.64298809332212, 0.584256955843275, 0.58116720203383, 0.563193875726041, 
0.704555386044548, 0.63532308163908, 0.741883097198, 0.599965730444907, 
0.555967549259393, 0.569336715965571, 0.56344311431386, 0.595032302670529, 
0.600107640397727, 0.547427738516862, 0.558406170120078, 0.61455125371918, 
0.595747433932827, 0.654246318021821, 0.64294285605689, 0.533944627319337, 
0.571742090483942, 0.662875126750388, 0.483071473329549, 0.664872117136683, 
0.545992483219101, 0.588812174903155, 0.597018665891187, 0.62252630469702, 
0.618844009809168, 0.575356821557155, 0.642006644976376, 0.541701250071142, 
0.65233336253592, 0.652246558853462, 0.598144868569851, 0.644051046335555, 
0.65745106962851, 0.542161636273316, 0.667658116367233, 0.617808740067359, 
0.602824385661359, 0.647071659699551, 0.564418580682864, 0.631622439995847, 
0.54782434832114, 0.559302483987103, 0.580362743978325, 0.62467529415499, 
0.649479646626762, 0.559449561161641, 0.677760309098477, 0.581496445680254, 
0.588083091078299, 0.61312418013004, 0.614519000321521, 0.585069902709363, 
0.605952339327786, 0.653024062876086, 0.557851101816504, 0.622861043233949, 
0.580491957858409, 0.577666444729704, 0.56012206888846, 0.548173077365178, 
0.612048039275928, 0.660807986464623, 0.464887704972213, 0.589093353813373, 
0.575807303436781, 0.577695056759428, 0.633209981257614, 0.5621832236662, 
0.497590955518885, 0.631070301716581, 0.562316927942029, 0.585939815812075, 
0.624604766585368, 0.656370679353198, 0.604508003319898, 0.548952870787096, 
0.550822496631489, 0.611904735020206, 0.579562783734619, 0.564085274785105, 
0.604700610660335, 0.593864497907455, 0.579278109742898, 0.638675443376221, 
0.603294587949999, 0.60993802388581, 0.578148721195802, 0.584710519576086, 
0.532553287226205, 0.711468327545048, 0.535917296635684, 0.558924952431971, 
0.612653787361306, 0.565008375507163, 0.527594985959986, 0.570946886140957, 
0.628327352053736, 0.578274690113224, 0.577253210913033, 0.609323700674955, 
0.582630223060592, 0.554016841147961, 0.512457894878317, 0.625320303730735, 
0.64021719911239, 0.670342501189369, 0.648347550195055, 0.569417240912462, 
0.525611367300833, 0.603569655431556, 0.651864845676191, 0.55802258290306, 
0.565454971114869, 0.621768657874529, 0.569493701872833, 0.544440913555182, 
0.584766336777254, 0.566257685010221, 0.622516794609963, 0.637496472948957, 
0.596191508646062, 0.505085395437122, 0.568032915388821, 0.627467793431026, 
0.52277296961326, 0.638931021878962, 0.650056517428126, 0.656733730261453, 
0.527173693713842, 0.562748001344143, 0.612473595959579, 0.647738004473364, 
0.507089868769235, 0.557628526746828, 0.599331531150708, 0.673174722197981, 
0.574401758650167, 0.546983657403934, 0.5331879750491, 0.616179378128215, 
0.5268196081795, 0.596559640884119, 0.540634556736272, 0.603996074445437, 
0.593686569014058, 0.594730465605779, 0.532594661645151, 0.52842405272844, 
0.594980895230886, 0.570566283059562, 0.649635453955129, 0.532690261082201, 
0.578538591560156, 0.60748208891636, 0.624681915375743, 0.559256868926858, 
0.64896071185839, 0.565959289715374, 0.607665759372236, 0.563346936500701, 
0.613192240979573, 0.516900335890959, 0.69902353076224, 0.560173000541861, 
0.599322766730584, 0.533020788606232, 0.601599924063547, 0.5733902618986, 
0.605104922077567, 0.619450562467505, 0.639270726876664, 0.532383406007963, 
0.592573503386018, 0.536439261450772, 0.546515748981702, 0.571734905420074, 
0.497044389878035, 0.577987087504121, 0.556221098647219, 0.579222881787696, 
0.655704814374764, 0.658480321151534, 0.662898575270462, 0.596054572170359, 
0.543035923691559, 0.615426132442587, 0.700730815277894, 0.507872629875268, 
0.613768969411121, 0.631249010483866, 0.558386592035237, 0.629432676098878, 
0.585725501100357, 0.532117725501152, 0.621639992920724, 0.593759217764687, 
0.605817492661339, 0.590240081288483, 0.561949156277311, 0.658191282179606, 
0.594019546230325, 0.648596999165036, 0.61587065870474, 0.570641100974076, 
0.602256639412423, 0.567779198664264, 0.635894807190647, 0.644879424395153, 
0.557709109381163, 0.555791691378144, 0.555828895569254, 0.561491795258188, 
0.583692450145696, 0.570722687068757, 0.586252045776516, 0.620169348783169, 
0.563132920099689, 0.673404501123666, 0.586569995635318, 0.590711028817245, 
0.547757040342965, 0.565791116108133, 0.717201431939886, 0.547571730376254, 
0.630245544016718, 0.623881365728422, 0.667427132678254, 0.596202181134114, 
0.568161318617124, 0.609393307905502, 0.62666524134265, 0.64547476948106, 
0.608688994985475, 0.674507718073933, 0.569170441722681, 0.555211901664629, 
0.640780271285806, 0.576765799390284, 0.637174503818161, 0.634658999947185, 
0.58470366704434, 0.650567665794265, 0.572265141695481, 0.573837842821501, 
0.641630664965656, 0.57624737179415, 0.564923796543874, 0.554440590617029, 
0.548206900857456, 0.673049105302593, 0.589137431743632, 0.5831775218626, 
0.553987075129141, 0.622642113912561, 0.641288720265899, 0.592391215023927, 
0.574496933747581, 0.572834275130451, 0.607746817109702, 0.635303945491245, 
0.660303010750942, 0.564633372939892, 0.572771196669506, 0.65740957110965, 
0.45594267054062, 0.643195124921899, 0.65955412975497, 0.590758441139652, 
0.542207161024844, 0.644179277153662, 0.63674992581178, 0.524313291557624, 
0.736327946936256, 0.639979592778288, 0.602174634517370, 0.576433376079488, 
0.632804136210639, 0.58953462893379, 0.561826225902004, 0.60603849249214, 
0.565994685592385, 0.508260305978415, 0.617998110985027, 0.615717303991701, 
0.551957174947145, 0.642597214237743, 0.671775327137725, 0.675103071508762, 
0.565056185770455, 0.648042447198658, 0.545993922898994, 0.52960773961138, 
0.581637355331788, 0.649631664920319, 0.623103090530459, 0.546382470085437, 
0.63298388477148, 0.571277146541768, 0.6292653899835, 0.599856716192279, 
0.59474199474356, 0.557987373022665, 0.583457192390841, 0.491245098032097, 
0.634614867135194, 0.580011625987319, 0.608343418449136, 0.685843739525971, 
0.554823032640446, 0.63008725486686, 0.588059745937758, 0.563617347753718, 
0.613175308839889, 0.639640486271302, 0.655083494345241, 0.59530590955975, 
0.642159347051397, 0.615301651187657, 0.578067965016606, 0.585951360220887, 
0.577457918105386, 0.583492538152738, 0.5782124940628, 0.571931669791669, 
0.571118654299767, 0.675688725791375, 0.698338347341182, 0.596361751207949, 
0.629982947558399, 0.629203487636058, 0.582056615247486, 0.59813422187156, 
0.569962040060681, 0.60275601716318, 0.594972130017012, 0.651835047347805, 
0.609754721827945, 0.567439802146345, 0.662641073145071, 0.530397339898028, 
0.651010046090225, 0.576525762127106, 0.649713925042864, 0.59827610272309, 
0.540773475186327, 0.593110061094664, 0.528383411069896, 0.61876188359412, 
0.627456920974566, 0.594697651534098, 0.622427165496807, 0.563852787978484, 
0.581840387924071, 0.545485723226468, 0.615232988404574, 0.565568038338704, 
0.628331275035264, 0.566045779841895, 0.610253769522844, 0.585018656302324, 
0.665342157382565, 0.621683101104706, 0.54152746725286, 0.697118026778239, 
0.637826826125555, 0.604423964782784, 0.618359267287705, 0.591607790928519, 
0.627500053573646, 0.601331494018878, 0.595317420090172, 0.556781671753404, 
0.522246570061922, 0.577905978972574, 0.577372597947053, 0.69068494833474, 
0.600756691116312, 0.659172163359573, 0.52687412053959, 0.575149341553578, 
0.582426099530734, 0.59394056520161, 0.570424010113827, 0.655582756201226, 
0.601495748412793, 0.644651030047529, 0.66228793380329, 0.678375564660077, 
0.623816886480194, 0.618369406568992, 0.658508143492816, 0.598335874998773, 
0.524666197808577, 0.607052415899778, 0.542767561613656, 0.600357505628606, 
0.599119657042001, 0.614149124216357, 0.650501200041316, 0.585610885290754, 
0.570527681364177, 0.495465338949071, 0.612888371293136, 0.635839404633849, 
0.62025262405138, 0.621487453030667, 0.665186096867637, 0.555692560616774, 
0.590911764572923, 0.578326470292697, 0.588687775281989, 0.593218180110975, 
0.663557947073436, 0.534307293665609, 0.680589603213958, 0.578971323182723, 
0.669133534682024, 0.614257628295482, 0.588204748383973, 0.591410145121769, 
0.450439743372164, 0.621880682042324, 0.587767223769518, 0.607534994841509, 
0.63034651949305, 0.506905702351096, 0.531063821241037, 0.654654411855234, 
0.58163463801417, 0.567462072837109, 0.690632498579988, 0.560145715717054, 
0.697203454234333, 0.558990608214814, 0.633522327636336, 0.648527335008923, 
0.494290988288058, 0.641988332717402, 0.594829036150842, 0.650433622376967, 
0.598232901372098, 0.595251140839276, 0.570792828062456, 0.571819543851072, 
0.580153021170095, 0.554155286037429, 0.563588427835841, 0.607430653539244, 
0.575897893503853, 0.603266949123174, 0.571173279705736, 0.659902214247372, 
0.608535345328135, 0.67678297833812, 0.572957605886546, 0.616624297658537, 
0.624776161416435, 0.592997793613118, 0.642038773817475, 0.616776373900072, 
0.583521375904497, 0.608816041708935, 0.620013268433092, 0.588335596144929, 
0.568610618144607, 0.586305027648173, 0.651051135317157, 0.620383440009484, 
0.581786484653075, 0.653572440688285, 0.632789033230069, 0.588014980026289, 
0.51506936483924, 0.673004567996688, 0.590983661191419, 0.695420650447721, 
0.62819850692201, 0.607019426717459, 0.564165793542934, 0.642019165711328, 
0.550395828167526, 0.6316465796674, 0.62080252828095, 0.561666776289373, 
0.566793347269695, 0.568636647780204, 0.592046582993577, 0.664922715414379, 
0.675357003935928, 0.587475846710726, 0.637063928996768, 0.542294981621914, 
0.609224791093105, 0.614077603583617, 0.601459834736469, 0.621356729455376, 
0.588917880669293, 0.577389519911763, 0.868579541259607, 0.89873670942841, 
0.887491884025261, 0.879740091675116, 0.916520874426658, 0.886553397515752, 
0.86419205240493, 0.862993750949467, 0.872976508507759, 0.89088836089037, 
0.846748704568655, 0.880355544312996, 0.897792654349963, 0.914149788670595, 
0.909936774951393, 0.883764841751378, 0.854869899435217, 0.923210126229522, 
0.906262986474575, 0.948807576914679, 0.907663974917976, 0.911589487610922, 
0.89138653264958, 0.841339400516619, 0.906677346239517, 0.904538457625068, 
0.892428986988465, 0.90344077175892, 0.906230079772647, 0.893854443671048, 
0.908036398479068, 0.87375286957187, 0.883188639333139, 0.864526033930985, 
0.881890495504901, 0.912132802378842, 0.899920036908929, 0.942178832023689, 
0.902165188928816, 0.889204103395442, 0.920494818836865, 0.881993786895191, 
0.869810203057549, 0.919075598051005, 0.911689618406639, 0.891728550802166, 
0.872036778243774, 0.857101439411068, 0.89580729932209, 0.86821983682969, 
0.914207098071602, 0.827526767929158, 0.88897817436911, 0.903448219708019, 
0.893191203432285, 0.920566536738585, 0.879521001894083, 0.888185425551638, 
0.880024664294803, 0.892652668193416, 0.896120257433999, 0.894097041650344, 
0.917171242545335, 0.890303490960277, 0.907065933965653, 0.867690782060047, 
0.86312923258568, 0.898782856745317, 0.915851199081876, 0.887360875786844, 
0.86894543972601, 0.910472943913853, 0.899917412299152, 0.902985983118243, 
0.91870619021326, 0.885344993417266, 0.903307712257734, 0.84847642979851, 
0.859893013354842, 0.902175469920915, 0.929987796309259, 0.890654482494203, 
0.867247596511454, 0.902590527346577, 0.884285629027828, 0.906020271906375, 
0.86116323361512, 0.861330034424339, 0.879496280207404, 0.889286598335938, 
0.89679246471042, 0.851376644724724, 0.886570049150481, 0.895268562884373, 
0.93463854957373, 0.868311955262596, 0.913238382597946, 0.917816277140756, 
0.8835987343533, 0.930868377117494, 0.861966666011247, 0.89344337178783, 
0.856509421733371, 0.922485393758848, 0.891633063169106, 0.849708196559033, 
0.880309322848652, 0.902255249625833, 0.90092633312036, 0.915212322725993, 
0.872904436161803, 0.937857857992643, 0.902557887878777, 0.90978503963762, 
0.912116989904341, 0.833300950749333, 0.893584835022356, 0.887121822164845, 
0.933371088615152, 0.896157989790287, 0.900936117946062, 0.895163859578403, 
0.924131934339708, 0.886833057463992, 0.912219261988627, 0.906041237956804, 
0.89336985261101, 0.894847643519654, 0.884543921671057, 0.915257415745697, 
0.85465316922486, 0.869575154322126, 0.885423651448191, 0.857086467401794, 
0.881546510809386, 0.882809097212024, 0.907318315890819, 0.892428657382882, 
0.89781303448987, 0.909728500874762, 0.868881755207166, 0.84312511822413, 
0.88561580730305, 0.91039725311459, 0.886784189179625, 0.939987296321357, 
0.889301574693354, 0.881714097657983, 0.900096663596457, 0.877803861095207, 
0.885323077104394, 0.890066745744475, 0.901477453675678, 0.888848817368433, 
0.885928438709541, 0.880817781982237, 0.893688853690447, 0.854937302848595, 
0.881817094518958, 0.892900525369847, 0.909914910065408, 0.899352625332971, 
0.901001145215745, 0.89413039156471, 0.922967093530443, 0.893927602178585, 
0.922380483124413, 0.911043155178236, 0.902871006119444, 0.85181703748557, 
0.89472035227151, 0.898271843911885, 0.875345115343454, 0.88838041154494, 
0.897528562681621, 0.871338617229859, 0.900371677990708, 0.910986389361668, 
0.859978275691214, 0.916825331481918, 0.893549723336173, 0.908522374748239, 
0.886965626441626, 0.900084584349102, 0.89334414935038, 0.907922610631793, 
0.872862027093979, 0.876866039964585, 0.895867449201742, 0.858076826664213, 
0.90236962818708, 0.892775458181708, 0.909736877692177, 0.911879685772656, 
0.850525333657626, 0.894186039425993, 0.900519467400588, 0.886911535864962, 
0.866521398596405, 0.894771218957901, 0.909929146435757, 0.870780983983288, 
0.903447091549603, 0.941932862226967, 0.90797102684486, 0.873753884241834, 
0.924312223984001, 0.895324039866805, 0.879519873929732, 0.9066156875553, 
0.93074743585444, 0.811030826227932, 0.938768560307287, 0.869775382865021, 
0.857059263399092, 0.883050245962692, 0.87597340365861, 0.908232846534978, 
0.875149660159593, 0.89616052374681, 0.904971465443783, 0.940310309649792, 
0.848800425084002, 0.872828741148698, 0.858469391839947, 0.851681867643048, 
0.919342922391147, 0.91689566212167, 0.931722031117752, 0.87458056964765, 
0.8636927790996, 0.921154982599233, 0.885808753713336, 0.880155511623416, 
0.866766159937584, 0.896023710649553, 0.884501317167325, 0.87680443174069, 
0.864270085485472, 0.906578531577148, 0.905924889363491, 0.894475030554403, 
0.839169674057136, 0.8787633131237, 0.863352333188916, 0.90888806798352, 
0.880078069710838, 0.892389108851318, 0.870997456360577, 0.901018507514013, 
0.92929835535052, 0.838238710950716, 0.89201506028174, 0.87987486084244, 
0.887490872003115, 0.912879458781522, 0.87005119539044, 0.877657777650496, 
0.871908414931919, 0.928907795312315, 0.861270754077235, 0.90046002569262, 
0.867674062387577, 0.875292777262394, 0.866507440977986, 0.88624376797454, 
0.878866922689278, 0.904063072572404, 0.91748264470402, 0.859993079168467, 
0.855563087049379, 0.922690576420213, 0.917780194120316, 0.854169285728337, 
0.88329728257258, 0.877368841822045, 0.882283677275352, 0.89936854119124, 
0.872124971525245, 0.898868622089826, 0.875189304743714, 0.88764940323475, 
0.878865061483382, 0.896556694728531, 0.92064814696312, 0.880783369033126, 
0.908396835008457, 0.90991436470734, 0.901747920359673, 0.893270515969359, 
0.932410987446333, 0.911323851543103, 0.880996648676387, 0.864458155940727, 
0.881377241465292, 0.834736853501771, 0.891769609880409, 0.92312372347305, 
0.887858165762641, 0.887636038480286, 0.908463910900568, 0.873067432160427, 
0.89341624763018, 0.906547960246853, 0.856228923613272, 0.856763998844574, 
0.879867886564364, 0.906746418093726, 0.890388999554451, 0.880845971915858, 
0.87499703006827, 0.909501988580104, 0.897557854764067, 0.872554021292664, 
0.857326378235091, 0.87156743678175, 0.87116964195932, 0.884693177667426, 
0.87682612137423, 0.904513369732646, 0.87159517601259, 0.907148667713254, 
0.913820297162931, 0.903989770441185, 0.869717216743619, 0.865455139709213, 
0.935212360162926, 0.914590111625697, 0.883609184956371, 0.838010035338163, 
0.848039917309576, 0.910493290019659, 0.900920065802001, 0.875850873983939, 
0.919532830974108, 0.943182551006489, 0.887870061854755, 0.909984417627158, 
0.903226024915875, 0.886182929747415, 0.882733690768474, 0.889190774483763, 
0.916169979598949, 0.930912603858366, 0.87662750613471, 0.927849479096983, 
0.88912630277754, 0.91262540233439, 0.851414646802855, 0.882245429048519, 
0.91042173714584, 0.86660929404579, 0.89341183578654, 0.847903267321577, 
0.88148200107724, 0.902534503387628, 0.916063444960574, 0.915706124646954, 
0.876518947852382, 0.925731288136135, 0.920855478883961, 0.88931579325235, 
0.907808535081621, 0.887127993393495, 0.904039568712976, 0.875565472820424, 
0.87955273489965, 0.898032472378966, 0.850837486566714, 0.906867726905745, 
0.893371592676133, 0.86640957740083, 0.90085185416278, 0.922068783491946, 
0.872564653882763, 0.879019310496596, 0.906104503900375, 0.865431264179593, 
0.901157254833855, 0.892773291478855, 0.865474036018683, 0.91923541543125, 
0.91874443700626, 0.943562717533343, 0.856259912695467, 0.92758960985714, 
0.923229675466614, 0.905622728962545, 0.904932457227935, 0.888695034460009, 
0.869612322751921, 0.920477040208357, 0.83142481266129, 0.878811059520194, 
0.922840018178901, 0.911635447371733, 0.887843613531587, 0.903396176188158, 
0.861816859766057, 0.891728802308675, 0.893713641618587, 0.90956195409297, 
0.903263478366091, 0.895960447468662, 0.897276099935588, 0.864991130034814, 
0.92942773930579, 0.919642031580243, 0.879911398888273, 0.918191368786635, 
0.904481795794786, 0.864920957708871, 0.865163279981933, 0.918179568480324, 
0.887067466777095, 0.890370018623177, 0.892904888838614, 0.924796919461391, 
0.923001451949456, 0.90406137561763, 0.84347440678187, 0.889708573388874, 
0.93826165315127, 0.904087547534217, 0.871834635506058, 0.882553637775842, 
0.922164383737917, 0.879410956161792, 0.910959758716172, 0.91429530717096, 
0.857890683765649, 0.858521146163801, 0.910057084735362, 0.864736654891652, 
0.87747781430848, 0.885662231779471, 0.885266443143712, 0.906071802495973, 
0.935494335583171, 0.898684773966075, 0.922910481506923, 0.885388261649445, 
0.875077737079656, 0.901097305070517, 0.902894130546472, 0.889618208660181, 
0.846952100456957, 0.889013176607067, 0.883521730215631, 0.883886972634731, 
0.912942368349796, 0.896496250623635, 0.889760416785852, 0.8900098708688, 
0.90380190308851, 0.899631764533126, 0.91150468731009, 0.887548649059689, 
0.910905268961867, 0.842030969922672, 0.942576685567198, 0.930284878952145, 
0.901665554215155, 0.9062213984024, 0.88981384903276, 0.909895902747844, 
0.869883010674603, 0.88156241515162, 0.904099613688141, 0.895068196813614, 
0.871366043209113, 0.855016675127964, 0.912311355966793, 0.880374917140826, 
0.892997004282045, 0.897755285964276, 0.874285803618236, 0.911059179731832, 
0.875451756842407, 0.885339088545658, 0.86380589894429, 0.902618522291381, 
0.883848389534111, 0.881999376231512, 0.898241514926576, 0.855951790462152, 
0.86971882349486, 0.914279831847528, 0.882426357581633, 0.879352472748127, 
0.885817656293716, 0.89897602615853, 0.885792820410613, 0.884659233674676, 
0.840122917476153, 0.854027688260426, 0.85557961546926, 0.886673594629045, 
0.8923352789389, 0.929376200047438, 0.87157874171167, 0.90062145196398, 
0.93639319417804, 0.897108938475125, 0.921233248139482, 0.877694400546302, 
0.85929097919417, 0.862891385428501, 0.90169728422076, 0.942009423649088, 
0.900028519380432, 0.857800385976731, 0.886154607739207, 0.89594202441476, 
0.870006472309756, 0.891829126597622, 0.903643250411669, 0.895322794723778, 
0.902433912692736, 0.918336048358092, 0.89956079954811, 0.883577330662637, 
0.910955034834096, 0.920424415688358, 0.875687269525762, 0.896598215338269, 
0.88804979649189, 0.877504890373044, 0.889018099035131, 0.901068774115242, 
0.845670715745066, 0.928059406450803, 0.92789271345401, 0.930080821663886, 
0.886487330774528, 0.915861527778678, 0.900823595244751, 0.900423281249777, 
0.844072203695968, 0.833991338212755, 0.888320095760972, 0.92159852810525, 
0.855837890267264, 0.92306631409599, 0.932004547664187, 0.868643598838991, 
0.89176243111441, 0.904175097710908, 0.912141634676352, 0.909294162242448, 
0.889268711174848, 0.83173265047445, 0.888688960137752, 0.883150653392996, 
0.908861766525223, 0.875382735085594, 0.877628225687217, 0.881361398779644, 
0.882159229680836, 0.918608112488578, 0.941369095036111, 0.878056737515388, 
0.888197349682537, 0.898561759551618, 0.893545992190804, 0.873516223409915, 
0.906170897849035, 0.883053770637128, 0.928448306225909, 0.865730001804476, 
0.881240317761965, 0.907621461721784, 0.919961348840202, 0.909970753467655, 
0.933206801708402, 0.909701674046234, 0.850615477431422, 0.905152865957343, 
0.898823888409402, 0.876934913043322, 0.932408629737735, 0.87949367186704, 
0.943877563344111, 0.870261321570996, 0.883708857595202, 0.86316996628903, 
0.9232877721169, 0.899628237420924, 0.894673222679723, 0.887089679100314, 
0.865609954731961, 0.915098177688626, 0.86201417187068, 0.884062617619827, 
0.902340869772858, 0.902116293496105, 0.924144225393839, 0.92120196942193, 
0.882635247901632, 0.918299133370322, 0.926776092392326, 0.864656663096056, 
0.92445568172776, 0.867483901047817, 0.895218250000908, 0.916539151287063, 
0.90738827044336, 0.907796361897597, 0.910463818615331, 0.906248882520622, 
0.875539161993891, 0.90450287252798, 0.848417617564167, 0.896416871971664, 
0.879199941436119, 0.88661121612192, 0.882525152567433, 0.932228456883396, 
0.909039745474343, 0.90877627270024, 0.894320144039031, 0.887023822585656, 
0.876226979704735, 0.895907332250299, 0.919543318525948, 0.90462439708315, 
0.90205869334584, 0.840270468013629, 0.892023619819458, 0.922304492616943, 
0.892092519620571, 0.857895053679994, 0.908017862022565, 0.892533403881273, 
0.91463768118988, 0.899211366901913, 0.863782967895932, 0.92534575564872, 
0.904909971401434, 0.893144782380821, 0.896695633762431, 0.879337308205554, 
0.91195011144485, 0.904172921103713, 0.836985202616086, 0.91059732554901, 
0.899842611797008, 0.862582247103306, 0.887093797611128, 0.87633296855511, 
0.891114078947728, 0.921747801033227, 0.913285225840411, 0.899085298697457, 
0.8855601286341, 0.891620982859628, 0.90610006903974, 0.855954364521309, 
0.904923591664935, 0.851327382262067, 0.8892433826138, 0.883945689121103, 
0.869292980143656, 0.867571509153794, 0.878187883747427, 0.923319872030847, 
0.861195131363876, 0.877941919183333, 0.917211328349696, 0.884914482727862, 
0.890092759942876, 0.899019778137663, 0.856634777855114, 0.871613141062527, 
0.895084953958302, 0.883680177810038, 0.886471983197764, 0.883731075454623, 
0.858491821141252, 0.88198649940962, 0.875663034096125, 0.887816447084697, 
0.868317836184741, 0.859769500682261, 0.901761605574374, 0.88281781741482, 
0.89957747058183, 0.887456347247536, 0.840242309978694, 0.880290196967562, 
0.928874607652923, 0.907300595835751, 0.879035999983559, 0.880897025895066, 
0.886669415975856, 0.88733654684003, 0.852351147011109, 0.87669134807385, 
0.891873302651644, 0.890561539098566, 0.904100002400471, 0.904669958659817, 
0.930947851641136, 0.881787701433478, 0.893537722223673, 0.922487101836602, 
0.910886398295722, 0.919319279005294, 0.875964027323904, 0.895884472081106, 
0.878138078852432, 0.917759475089049, 0.901511008853993, 0.925936968960175, 
0.848422546012872, 0.862377759304336, 0.889919387370424, 0.882439719610476, 
0.916862842988957, 0.86054069499108, 0.89210244894551, 0.875768601346997, 
0.868591372697751, 0.870369109783912, 0.9078929902423, 0.892088918883341, 
0.90292721956584, 0.898509251154835, 0.897192053227639, 0.883289480131592, 
0.86851032559477, 0.871924140462929, 0.924388941517612, 0.886636362402978, 
0.92327741436191, 0.867460772514049, 0.9006665448161, 0.914447685087277, 
0.910875350457858, 0.882588689125246, 0.90876740578555, 0.910099967016315, 
0.869886422379875, 0.936650312180672, 0.914284237174672, 0.862273484573381, 
0.911383364802969, 0.911190938400074, 0.89662404436741, 0.847196457318919, 
0.895084293765284, 0.926104271606058, 0.870834414925964, 0.904502792668486, 
0.922689811767838, 0.880141714992427, 0.905390167283798, 0.900934256169209, 
0.877622696344846, 0.924670396724602, 0.890911398776874, 0.887584450725965, 
0.898650247636204, 0.92009219026889, 0.879046850099975, 0.842807689038397, 
0.908706391604877, 0.859352643533106, 0.849423507195168, 0.852788589015622, 
0.915314104813792, 0.925919251494857, 0.88126325036432, 0.87524725460546, 
0.845348049572042, 0.935358804130734, 0.850557787883986, 0.891012058595734, 
0.935036988535272, 0.878775502763588, 0.890685098750866, 0.918769731137801, 
0.917007858849733, 0.896966123919208, 0.888763661189084, 0.897654580558529, 
0.910813651896939, 0.92368296378101, 0.909370186046605, 0.889275105839405, 
0.906001491818725, 0.900251296099543, 0.829178579213111, 0.930945867500145, 
0.883597835384663, 0.901785851532292, 0.910670332680415, 0.890684172844837, 
0.86070719591389, 0.875672721498754, 0.894606016767444, 0.927038088227199, 
0.910974559255657, 0.866116965144118, 0.888789124447779, 0.860299502563025, 
0.909967497631118, 0.885694212275595, 0.894750650687238, 0.862854017956344, 
0.869548098968844, 0.893898908613774, 0.943435217297733, 0.900965724483352, 
0.863029553563028, 0.902832915690815, 0.888176455418022, 0.918868324379785, 
0.894664345055655, 0.89197588014115, 0.86934841149977, 0.886399840191682, 
0.88994023472921, 0.893201956356111, 0.89409417700041, 0.918261039886858, 
0.905818980444819, 0.881863169899395, 0.855088182638104, 0.922028232046212, 
0.929406195297858, 0.880324449954038, 0.913628322311202, 0.90793805365472, 
0.894119683042317, 0.899921615977857, 0.8849120969653, 0.919194988721417, 
0.89309195451148, 0.871109589993109, 0.909298308055121, 0.911128699621726, 
0.904657015814204, 0.919429919009382, 0.87450482169203, 0.899565393730463, 
0.904402422117609, 0.86696511301046, 0.84052510180479, 0.855904017073973, 
0.88119419493783, 0.909827951543019, 0.931703727131246, 0.861307616649933, 
0.901987854378518, 0.869104870214016, 0.931965174644616, 0.835669869687675, 
0.882515951723237, 0.888554985315232, 0.893729741269707, 0.905355462187207, 
0.879338029087374, 0.956840764080361, 0.890618455427658, 0.902340209115845, 
0.873994633392001, 0.868271855888895, 0.88183454179707, 0.904085720844381, 
0.874551243475496, 0.915854094696428, 0.875616863125853, 0.899022207092213, 
0.929053897839007, 0.873277368949397, 0.925044242857804, 0.86395986190978, 
0.920143190244355, 0.888210604787617, 0.911806299984223, 0.879149432679457, 
0.876588953621113, 0.902233842063479, 0.934973118348539, 0.842560536402505, 
0.894703611292093, 0.865430115316341, 0.893505138477076, 0.899229794815492, 
0.855292863956916, 0.894036003356403, 0.917447981802552, 0.866346511383774, 
0.89950886351364, 0.901463384351362, 0.873102008254112, 0.884536896414438, 
0.88254541100963, 0.90020551094, 0.870858368927371, 0.91448187253379, 
0.867167588133012, 0.867050534459089, 0.905773552827305, 0.866485971849008, 
0.881478765671101, 0.86993802227235, 0.923377974911, 0.910047120128894, 
0.900397437936816, 0.882874619955415, 0.877363367926385, 0.888102547361, 
0.924067518009579, 0.901430449438824, 0.91856682182654, 0.912509415220561, 
0.869676391802165, 0.9262677392423, 0.890847146271552, 0.871622008662499, 
0.917052527149141, 0.87782678801699, 0.905410251633391, 0.89799987097762, 
0.90035215312611, 0.925980867569632, 0.884410542957306, 0.90492999583939, 
0.876916679726177, 0.916298683592994, 0.89508764825301, 0.905408817127384, 
0.886340490509004, 0.93330955891858, 0.929649776791325, 0.903577266247155, 
0.923582105171656, 0.90314172417447, 0.876395386116425, 0.890086802081218, 
0.897679364589282, 0.894641548851221, 0.862870822422177, 0.906811700108758, 
0.871414571968352, 0.895827451415313, 0.866228715950137, 0.89485913016657, 
0.878580547723104, 0.922988272917055, 0.872092859900621, 0.877112354062319, 
0.907568647650775, 0.900744453477781, 0.903237487538511, 0.841603339558504, 
0.877158735679604, 0.922083788097202, 0.888583676215971, 0.86295344960717, 
0.913145583313885, 0.890587269193562, 0.869882888819495, 0.924688885494724, 
0.863723964672765, 0.920954364643531, 0.894437834986152, 0.838707229771346, 
0.902587576164265, 0.854039188007138, 0.889168098147164, 0.925316983584117, 
0.883259974735555, 0.953468124285037, 0.893395333423062, 0.917595261729371, 
0.911430941187182, 0.893977487848898, 0.901990309418075, 0.888285758020083, 
0.90322741495075, 0.892590931026406, 0.906326228053889, 0.91671672867418, 
0.893983733184649, 0.927504343347427, 0.878938803116693, 0.896118268982337, 
0.886310992434564, 0.878923962481546, 0.9165365597801, 0.844454652423875, 
0.905106852896126, 0.887697070500143, 0.887152763340411, 0.870952867667547, 
0.885325376249829, 0.870087174335453, 0.95323685717259, 0.93427605658593, 
0.946815135193927, 0.951918904816635, 0.965683044053501, 0.95274946663295, 
0.932189696424006, 0.953049488266563, 0.958915968150801, 0.95250141991505, 
0.959062202280023, 0.949797590251357, 0.936079085419787, 0.931595262603616, 
0.955253257582081, 0.949213731272008, 0.940582965042703, 0.95409632175799, 
0.93356380964428, 0.928519016759837, 0.96751535322986, 0.938160010219922, 
0.94439194932091, 0.949416048906196, 0.968137474035776, 0.931569079280976, 
0.935202529050136, 0.923808167824171, 0.943939922042462, 0.95576703592462, 
0.937498558398228, 0.941545611890058, 0.961617272708538, 0.944112092196747, 
0.946329184845277, 0.945549137686103, 0.941763597144976, 0.943980761390444, 
0.945268773376084, 0.94571400316844, 0.952264207546378, 0.95304007304358, 
0.951932374033136, 0.944063052070408, 0.948249512903413, 0.934290267619924, 
0.950656702309475, 0.93966874506374, 0.932684942175132, 0.957541909044757, 
0.962276315940308, 0.940441907104117, 0.939142655343802, 0.95493060175656, 
0.961023984589687, 0.92289788333376, 0.947184173767431, 0.967779717825906, 
0.94775665149826, 0.953857158031114, 0.961870534945567, 0.961065961639327, 
0.948191893792851, 0.953651539124077, 0.926675484922117, 0.9305894671446, 
0.935343258952469, 0.93923906285876, 0.947069141895886, 0.960916648999431, 
0.929361283070848, 0.958690663894693, 0.95519529551647, 0.95074237353713, 
0.93642825978953, 0.937361446054094, 0.936437908253751, 0.927863610029888, 
0.960410716519564, 0.943507358429686, 0.934095739764896, 0.912957267680097, 
0.957466620494358, 0.95380034135445, 0.948748145132542, 0.948070262874767, 
0.928325731221435, 0.94440730096412, 0.939672378350718, 0.966209357685866, 
0.964289448435311, 0.95110317580682, 0.954635649761978, 0.954642171668824, 
0.949170267735394, 0.939538667927176, 0.929489361886663, 0.948339529822518, 
0.948113216286453, 0.95287480392039, 0.944189464640248, 0.953896392309808, 
0.967409982780842, 0.943581848490016, 0.919622477857263, 0.916398064374448, 
0.945938511954548, 0.955547233429635, 0.91440759688615, 0.942575538242677, 
0.936219467986658, 0.954695368073684, 0.94212664855764, 0.966108228690648, 
0.922841714646189, 0.960255100856894, 0.951857726979434, 0.96282086580196, 
0.923860089778869, 0.947778740469157, 0.933570438350253, 0.954971922166172, 
0.932244089094524, 0.931933479648812, 0.953820381955358, 0.958167047698548, 
0.945883706666552, 0.94496569473919, 0.919518467098643, 0.921476817185195, 
0.95036531488692, 0.926175017304227, 0.930194610964329, 0.966434863844017, 
0.965222022518617, 0.9768476358262, 0.916724384162591, 0.939891567903873, 
0.949374546018957, 0.946375986542049, 0.966374644708143, 0.968649394763894, 
0.935165802360582, 0.948513004963236, 0.934299157306287, 0.924400809216703, 
0.942563505355483, 0.935477700780282, 0.95920544100585, 0.96024194069755, 
0.927074308443393, 0.950857152951238, 0.932578800597646, 0.968920309463962, 
0.959883421918566, 0.955328836868555, 0.944133843292708, 0.943510692647115, 
0.941777110607986, 0.94456066122622, 0.920178493565743, 0.909582792768885, 
0.948544842928267, 0.937459998587482, 0.938930423803283, 0.941122409808165, 
0.931471229152255, 0.924246366818539, 0.940962428971624, 0.959323209267083, 
0.93325563437356, 0.954239582645797, 0.943412341714758, 0.949254690562527, 
0.940604150697335, 0.946882555628834, 0.9332015220951, 0.950111986635035, 
0.950220895886086, 0.947085146954572, 0.955234302013778, 0.953920646265263, 
0.935451234582838, 0.963137996080687, 0.940540950845616, 0.95348941697071, 
0.954481447704294, 0.926254247428752, 0.94867458319289, 0.921630779229763, 
0.958415067175545, 0.953293799481975, 0.960614179822473, 0.932782633198155, 
0.949855256010766, 0.96142562313617, 0.941704439276999, 0.940693815100505, 
0.962574433929636, 0.957296813812244, 0.944110965041192, 0.948766969093311, 
0.940887276259093, 0.9413898429891, 0.943556766603904, 0.956902035888375, 
0.957469679206954, 0.91196620854637, 0.961794273876687, 0.955870965679387, 
0.966332904451508, 0.941468274011772, 0.934034634971148, 0.938951571848822, 
0.956911139791193, 0.95807916440298, 0.96038345411147, 0.94673313572097, 
0.955426455508566, 0.927790757742154, 0.962203832319236, 0.945289483477081, 
0.941642618887302, 0.966197718071669, 0.950259646282336, 0.947160015956338, 
0.915272233240178, 0.955538645425906, 0.932271055714316, 0.950441764070062, 
0.964463485630931, 0.950138038621437, 0.939897736170752, 0.92176588456029, 
0.95377679603623, 0.926632515917068, 0.95945788697404, 0.954924739767814, 
0.943496986025462, 0.973583455719408, 0.933018739605452, 0.929009417654833, 
0.94269239121792, 0.959810786833329, 0.944210244301077, 0.93870086350736, 
0.938656233754928, 0.947954770135326, 0.958506945794535, 0.959011117419893, 
0.955283441659626, 0.96880668978501, 0.932748045683758, 0.95784534213957, 
0.940785289568879, 0.948442143596987, 0.936779678589058, 0.93291485274884, 
0.931810939605165, 0.940575044037175, 0.934089288557027, 0.953587832018698, 
0.93873285105081, 0.959208532236385, 0.942533470173215, 0.945466537614864, 
0.940530915000215, 0.947125935751057, 0.943476853506989, 0.92000239650803, 
0.942695799186757, 0.941000465029442, 0.953215997088785, 0.967255345953784, 
0.92132876720716, 0.95264165194845, 0.911743385917306, 0.952329309297056, 
0.95646533256535, 0.961335457014485, 0.929732716796836, 0.939174299317216, 
0.924314621125536, 0.940875787228147, 0.976337940060442, 0.94136435070025, 
0.955038270318013, 0.965140456290147, 0.92982581822964, 0.926658271243261, 
0.940441331130703, 0.936432042342501, 0.970069802811034, 0.952551424661934, 
0.951787725473336, 0.920758010570505, 0.957514780139726, 0.96482779804564, 
0.936439583149784, 0.958914902141254, 0.93949100117017, 0.96247252375278, 
0.937932437301803, 0.93959613540309, 0.93471721649505, 0.93910097918884, 
0.931193980928572, 0.952137590825843, 0.91923308229076, 0.958168635309023, 
0.930245368850411, 0.950816282899419, 0.95638928392635, 0.939874027998098, 
0.943432877610758, 0.942581972156236, 0.957997948490817, 0.963580937492524, 
0.925446349035917, 0.931549686233452, 0.948812517117593, 0.96257045795726, 
0.9381813191616, 0.955213487561924, 0.95914553753645, 0.924536772010221, 
0.965880121123402, 0.920283754963356, 0.95544048665761, 0.951395840700186, 
0.948006391833787, 0.95309086171012, 0.950722885188964, 0.917292841350955, 
0.943780719465733, 0.944698229376324, 0.939726526231244, 0.933746280456138, 
0.945459818320223, 0.952537485549329, 0.956406299111913, 0.891146071198166, 
0.959137392217122, 0.959086947670427, 0.957306866345361, 0.931322828008222, 
0.947619854928587, 0.949199840461858, 0.959511553975816, 0.951166164792258, 
0.960412414284416, 0.955257579584366, 0.942567062292265, 0.962621434127043, 
0.959378107764858, 0.957957553426869, 0.948439804656476, 0.951090223447226, 
0.90883933150714, 0.969041024442518, 0.951403616035413, 0.939761004025365, 
0.945635453723533, 0.9178246901356, 0.944404442594118, 0.925018335332088, 
0.972234523773403, 0.919667300892216, 0.938048890674514, 0.958241002240892, 
0.929930451804782, 0.954638858199096, 0.935066208806098, 0.94115258954089, 
0.93038687111823, 0.953959154877068, 0.954912591978603, 0.956023256500715, 
0.951969265564594, 0.93713114165409, 0.939764089570144, 0.96185966427366, 
0.955092633292378, 0.943023592039265, 0.955089361176576, 0.95318586115034, 
0.928540687674034, 0.948423196865467, 0.956488534584275, 0.93852012921901, 
0.920603273301505, 0.951989340928334, 0.940632878571576, 0.946831464840426, 
0.94253252902103, 0.94243341290211, 0.92490659403412, 0.950489162986614, 
0.968248420643334, 0.96328898110682, 0.968789775621482, 0.942003199013032, 
0.965341705037183, 0.960128900281042, 0.94971275255626, 0.915251800099392, 
0.944740474513992, 0.94077813631018, 0.953387598885837, 0.932608218158106, 
0.91604818921629, 0.949811535753256, 0.951144681449412, 0.953376514476886, 
0.952351157083503, 0.96106131497259, 0.941975659833322, 0.960565899288106, 
0.968708629522919, 0.933206392311794, 0.915987348768486, 0.959659137890933, 
0.935021536648375, 0.962898518842409, 0.944196897690535, 0.944487902887779, 
0.954799906558168, 0.952783972485986, 0.960743038905512, 0.957275933264075, 
0.949374096766801, 0.937092259223684, 0.928424967205931, 0.949130847828339, 
0.95071401816456, 0.949035194932864, 0.935491748947646, 0.930306454536245, 
0.933414057833412, 0.950774823850172, 0.938769103453288, 0.949803217238651, 
0.934369404587992, 0.948714474657472, 0.956023097742106, 0.937065204531189, 
0.965418518493245, 0.929592996641547, 0.901501383324031, 0.946705824450844, 
0.950289917710728, 0.960357838296242, 0.948342675303297, 0.926492763674966, 
0.930449021977095, 0.920015643109266, 0.954033823837796, 0.960728075783065, 
0.953121203894526, 0.95508989698545, 0.961705392607097, 0.927990317760901, 
0.947132005012736, 0.928846990065635, 0.956681625065817, 0.958105580900596, 
0.912946598717618, 0.93368505333294, 0.951505347166724, 0.938392818073723, 
0.949110153287682, 0.929961123804549, 0.933340324245321, 0.941456813403025, 
0.93343507275339, 0.960872166106596, 0.940106769001248, 0.92081615862784, 
0.943657944022533, 0.923585999648028, 0.930604708197474, 0.935030881897342, 
0.959042662031877, 0.937877458245766, 0.955971971869286, 0.9327357186657, 
0.93683304316431, 0.91328036841741, 0.948368433010978, 0.942862560211014, 
0.935210681139471, 0.959614126397163, 0.93700036796959, 0.938492681527034, 
0.91309760161831, 0.961669774033956, 0.9417812715091, 0.923129716341405, 
0.927285292152742, 0.925675631823568, 0.951066108996528, 0.956293508899932, 
0.9453015951135, 0.943989312601828, 0.918792561813465, 0.965562932065928, 
0.936815702952473, 0.951196214804447, 0.960040365924385, 0.939927628021655, 
0.94522433644483, 0.94460694728642, 0.95929771589424, 0.923783743062283, 
0.93350873769934, 0.962296082158371, 0.963171587695147, 0.952989999550257, 
0.941365470518732, 0.945876145494373, 0.934085548666224, 0.947638871920803, 
0.9601175851361, 0.97092916889692, 0.9491656771185, 0.931880596213424, 
0.94622747714438, 0.963556347770729, 0.92754549113071, 0.931766306577289, 
0.970760840182692, 0.935903024095103, 0.947699444849965, 0.937327514420594, 
0.948367168647264, 0.958069248233711, 0.966262926322483, 0.97023119449018, 
0.949972563054342, 0.940229045768758, 0.967008716753726, 0.931532784054253, 
0.957284198903938, 0.965983821740825, 0.94650155665972, 0.976050972313405, 
0.918643371236433, 0.921296686423809, 0.934213690547999, 0.951019044763364, 
0.94127472304207, 0.965154648530193, 0.954459260811165, 0.942934093879047, 
0.957478688023645, 0.959283172840599, 0.945042933196208, 0.938596152527849, 
0.951101760004221, 0.955233649863602, 0.962586245827582, 0.946481545257954, 
0.942079566116914, 0.94138282144266, 0.954567832218944, 0.957441635976744, 
0.933545926610608, 0.947727137480582, 0.94335759527793, 0.940546849652832, 
0.930727528944673, 0.9491804881971, 0.927920656855449, 0.933070586633118, 
0.952307214973498, 0.948929428179638, 0.935220395820261, 0.941001690515342, 
0.953887948121426, 0.934217521777312, 0.934937099633727, 0.923035678509688, 
0.940380784069433, 0.965581325631417, 0.944830647242464, 0.938073621510143, 
0.954551878778393, 0.92413029122483, 0.927308004631019, 0.909515158473405, 
0.95906323745004, 0.937844345066873, 0.952563590097361, 0.943208551095906, 
0.938288738350719, 0.953376542147044, 0.924593837640715, 0.94068290196102, 
0.939356739666666, 0.931511736743823, 0.917704401094282, 0.944020557051302, 
0.963814070455144, 0.957074406822274, 0.968607812201929, 0.935259275295233, 
0.945048121382134, 0.94090630420155, 0.947346023338571, 0.962250906119495, 
0.956030563875194, 0.917136404145968, 0.955593678908214, 0.929814373971568, 
0.95154232505975, 0.959859150335994, 0.95236584810798, 0.937483582345979, 
0.949026000841912, 0.967133658918813, 0.934847346007147, 0.95618127481448, 
0.921411019507452, 0.96111714028408, 0.92571629214809, 0.93723151213771, 
0.945832963266205, 0.942117510524737, 0.948505621968922, 0.92872507282735, 
0.961323965692335, 0.944857481711088, 0.954140138923004, 0.968108982773186, 
0.92740338267929, 0.965460291025633, 0.919587957054913, 0.95094648203653, 
0.952927820776388, 0.952847410362642, 0.959875710793593, 0.904811823689303, 
0.94866237420235, 0.949489725299723, 0.939388121431152, 0.95717440046341, 
0.956169606883487, 0.954374060682716, 0.950526049318408, 0.936411400296799, 
0.937342616209985, 0.947043051874178, 0.953649656106026, 0.91671104498816, 
0.948004827681425, 0.93512539027572, 0.94456620017595, 0.903563416823716, 
0.960761223557249, 0.933441922634921, 0.928441259629906, 0.95046863774582, 
0.955566306575703, 0.95890053043025, 0.95630172492391, 0.948852973467763, 
0.971603187862377, 0.932507129158837, 0.951443668194954, 0.95758837653072, 
0.95103324445885, 0.93282901876854, 0.957112699503534, 0.959880381055226, 
0.955713251478998, 0.938215498383493, 0.93878509311293, 0.940734484199032, 
0.967061750422367, 0.955788546936042, 0.92197910902756, 0.972550126856567, 
0.929865186743799, 0.952496212800727, 0.930029706792669, 0.906611669185584, 
0.925450371388943, 0.948467858243317, 0.938713362069693, 0.95475611799923, 
0.95279871631859, 0.962329964268003, 0.94838223591229, 0.92851181193892, 
0.956128472103768, 0.916420083177124, 0.938620481756775, 0.96366057362389, 
0.9572834778176, 0.945932143526076, 0.930064358137319, 0.933878651669349, 
0.9629595707056, 0.959236750363568, 0.919197324176638, 0.947363614885795, 
0.94390002909109, 0.949130072074915, 0.932660859008805, 0.945944991353987, 
0.928506441252614, 0.949604752041222, 0.965123582764234, 0.935698658668275, 
0.956911582259371, 0.936110071067876, 0.964079488609063, 0.952985396512838, 
0.94395722072029, 0.949576298665257, 0.947868048230107, 0.944116008619456, 
0.939525056884455, 0.952792954222268, 0.9554136863274, 0.95157979861161, 
0.933155607547062, 0.949921013127217, 0.952994443038939, 0.917251210777063, 
0.950149975245983, 0.949245059086122, 0.939234273105326, 0.944644268724644, 
0.944216566690855, 0.958597899173773, 0.934074853871754, 0.936223085987813, 
0.945820260686761, 0.955189732752167, 0.94867915416632, 0.943576714218566, 
0.958483959408626, 0.949802825626605, 0.94790891900734, 0.945719389950396, 
0.946369303770968, 0.945456380839384, 0.916750427155647, 0.944691414735325, 
0.94911698300856, 0.952586443517676, 0.95816600362887, 0.951958231577384, 
0.957009188115925, 0.924525586471578, 0.947297115748106, 0.972954813306013, 
0.937571811609988, 0.936295270452186, 0.931391978470693, 0.949493746522416, 
0.923495071065441, 0.930388217294319, 0.922251826772746, 0.955029789259733, 
0.944000655166312, 0.958166912896608, 0.950098695789676, 0.94334986367734, 
0.928998029420705, 0.92266075710362, 0.962053098559096, 0.93148195488798, 
0.955614254037982, 0.950143334184085, 0.941196210178845, 0.943134680561088, 
0.95920668836861, 0.921604694361916, 0.922978793613291, 0.963127095101593, 
0.935568166382575, 0.95004245841684, 0.941516598618984, 0.9492755624452, 
0.948968881415152, 0.947118069241423, 0.9638109500388, 0.95628137440223, 
0.936955700664321, 0.954943001644364, 0.939711831743373, 0.956906125585003, 
0.946143862929436, 0.956129204552192, 0.944307289115812, 0.918646135437804, 
0.937006192327607, 0.93932964385864, 0.928115922138425, 0.961375993567437, 
0.918969411573027, 0.9523340778463, 0.957478428645177, 0.952293175378961, 
0.936015370849432, 0.929693607883858, 0.95263566187358, 0.936426806022132, 
0.935029384802607, 0.931665265012126, 0.942024664211294, 0.961202681673211, 
0.956794886884037, 0.945845067315375, 0.953153585355008, 0.924787040626095, 
0.948728134962392, 0.94706798961364, 0.922010658565927, 0.954959737819671, 
0.960348271930404, 0.950778297376995, 0.945978383087987, 0.96555776949705, 
0.945475191043776, 0.95547965485043, 0.949135957215943, 0.950016139764326, 
0.957679461525498, 0.95159314742248, 0.931003243121715, 0.944772484619254, 
0.944686938337638, 0.95367754905924, 0.951206430397493, 0.938974342575577, 
0.954004588618636, 0.946926014337758, 0.95509623119612, 0.943689201273923, 
0.936325591768315, 0.929116581277207, 0.957581481089276, 0.932753194239995, 
0.92837071570989, 0.950444112110225, 0.942819494455064, 0.957260859693667, 
0.935925375056551, 0.939545871696054, 0.956410994611443, 0.95335587665889, 
0.937052705127147, 0.959074348066108, 0.938091002766014, 0.94899139265087, 
0.948057288686709, 0.965343678847613, 0.93737368114577, 0.911896873709846, 
0.959074791833882, 0.936782139690257, 0.948166811677763, 0.942854476334313, 
0.937361615750034, 0.929340599386237, 0.951044740583722, 0.952648178502348, 
0.94738780769253, 0.950839201277144, 0.9367590717665, 0.952883852107241, 
0.962031109643003, 0.92545011897894, 0.924810537952664, 0.935261348015497, 
0.947062611466234, 0.952330794737584, 0.945307120704482, 0.935192281589612, 
0.932109870366209, 0.951719499255867, 0.943564695993668, 0.942095488356359, 
0.953014374907632, 0.96084705749166, 0.934664616910465, 0.941787288100534, 
0.938793740876028, 0.947912881173976, 0.943635938993652, 0.95341008169205, 
0.928087241050702, 0.92739517680161, 0.943880383742723, 0.930257397914799, 
0.93558411197958, 0.94155807927721, 0.971132643165176, 0.954254872074508, 
0.929724062812872, 0.903187933549657, 0.941632607497668, 0.948793359940829, 
0.945313758370587, 0.945091456971166, 0.957048749251732, 0.955997118960436, 
0.92735771649447, 0.960652671091072, 0.957556972846415, 0.948610699441734, 
0.934162472249935, 0.935780418689298, 0.954630738321387, 0.93429677111407, 
0.957117168340758, 0.95788653393151, 0.934311437931031, 0.966110324479895, 
0.935832861521161, 0.951000976714452, 0.926871641515998, 0.95988336593328, 
0.96722987860316, 0.958263578630278, 0.962402389692014, 0.912726274076663, 
0.962000144939532, 0.92719365152482, 0.949827102765207, 0.960202449937703, 
0.961368894499537, 0.933474406508334, 0.937772594879748, 0.938015003353639, 
0.954789952492481, 0.945588966465717, 0.950294638145335, 0.957564287352204, 
0.97137014436807, 0.930306317861633, 0.93173112805963, 0.937136274838499, 
0.954063760800922, 0.94715156644928, 0.96711609609145, 0.955558634909308, 
0.954850473873795, 0.932123000290965, 0.966892093021101, 0.951844408878757, 
0.913428675543955, 0.939382764839043, 0.941880278668422, 0.953341543293394, 
0.936458663645408, 0.959760635686933, 0.936556305225624, 0.93505797615825, 
0.924824913389802, 0.949895850858328, 0.941024283180005, 0.937936169451066, 
0.937884415374734, 0.938836981047467, 0.9474036607292, 0.94048450615152, 
0.947492272389424, 0.957409909479811, 0.938649018243971, 0.95524302598603, 
0.924578868761863, 0.959045721605425, 0.955492468918234, 0.956420457977548, 
0.945628697544737, 0.930158224343952, 0.95418913417362, 0.94905210379308, 
0.929829141709543, 0.938849172240467, 0.943406670449264, 0.941417720274813, 
0.946967751469233, 0.96270107366503, 0.940986840965707, 0.953551439842001, 
0.893434994550275, 0.946881916698288, 0.957585268931057, 0.96390097671536, 
0.931360978002206, 0.968861037431944, 0.956836423110344, 0.960207383615207, 
0.957704391111456, 0.956170634649812), .Dim = as.integer(c(1000, 
9, 4)))
`thExact` <-
structure(c(-0.893522320215802, -0.999999105055822, -0.99999931213595, 
-0.999999533400042, -0.999964312732452, -0.95579747542213, -0.999999496642157, 
-0.860867791520924, -0.956767697352581, -0.99999966574645, -0.999998271414898, 
-0.999999067661386, -0.999996557103722, -0.912984216665233, -0.999997070641874, 
-0.999998476439194, -0.999998499849547, -0.868125130228502, -0.999998980491979, 
-0.934932387044583, -0.999999881126224, -0.742728415762598, -0.999999329393874, 
-0.945882085825272, -0.999999776628687, -0.999999703823544, -0.999999434995874, 
-0.999999619509899, -0.950433848775555, -0.99999949898567, -0.87590533846386, 
-0.999999775961482, -0.999993737322253, -0.939969603271576, -0.999999821680725, 
-0.99999128616564, -0.891500280980686, -0.96730241559154, -0.994832641344752, 
-0.99998608465882, -0.999999544695373, -0.999998281164014, -0.999999378686465, 
-0.972552431523248, -0.999999984030309, -0.99999950056698, -0.999999705029122, 
-0.999996430216607, -0.911419188264302, -0.999999879649466, -0.999999556843034, 
-0.999994207790112, -0.999999975987806, -0.999999514039004, -0.999999402333545, 
-0.999999928001238, -0.999999489238788, -0.99999969461126, -0.999999403877626, 
-0.931915417338824, -0.999950802169197, -0.95764897354816, -0.967814212724458, 
-0.999999879105, -0.999995835467788, -0.951129791164174, -0.976410482712013, 
-0.930329791448159, -0.999999102349196, -0.859236907539533, -0.926739684730693, 
-0.999192521144573, -0.967668664921237, -0.967605555587827, -0.98447851459948, 
-0.999999714011921, -0.999999305031853, -0.9999995574114, -0.999999186121256, 
-0.978020524609545, -0.999999786956429, -0.803594257417874, -0.999999496782168, 
-0.96519958593676, -0.99999949674858, -0.999999651526437, -0.99999967024044, 
-0.97535360914837, -0.999999361082948, -0.926690494368597, -0.841495262407955, 
-0.965984927981464, -0.999999709301356, -0.853124044667328, -0.999999546091209, 
-0.905011907172098, -0.83694687397669, -0.999999076886789, -0.999999985362528, 
-0.974345694576234, -0.99999927738875, -0.67761845019748, -0.988318273034271, 
-0.999999518980128, -0.999997605904415, -0.999999601258178, -0.983675262580381, 
-0.999999631279468, -0.973020034647447, -0.99999967454709, -0.91925737919484, 
-0.923805384836443, -0.9999998246295, -0.999998602344367, -0.960741401983522, 
-0.999999469144238, -0.99999962478879, -0.999999445425624, -0.99999896657383, 
-0.999997247826666, -0.862621435898657, -0.999999425006553, -0.944499664161937, 
-0.999999862899018, -0.999999611819587, -0.999999534361888, -0.999998736978292, 
-0.94126484630178, -0.999999500006051, -0.999999037313072, -0.928500261090264, 
-0.956060569849594, -0.93416615197255, -0.999999641722107, -0.999999367333906, 
-0.925808173229204, -0.872805275046523, -0.999997195886775, -0.939941600638547, 
-0.99999982942334, -0.874975922495142, -0.999999265661181, -0.99999993474054, 
-0.999999635486415, -0.98665895468202, -0.99999935813322, -0.99999992181778, 
-0.950276593643916, -0.999999677841137, -0.999999486735804, -0.918357804159776, 
-0.999999699002973, -0.999995529191384, -0.95657235966089, -0.87306117070923, 
-0.999999491642088, -0.999999930525206, -0.974814946547534, -0.999996473275332, 
-0.963766270988052, -0.999999238160728, -0.919395144021969, -0.999977054117809, 
-0.999999566548666, -0.999999024132996, -0.999999701801496, -0.999999647438517, 
-0.9999998271475, -0.912014327474179, -0.999999126236768, -0.999999179686913, 
-0.999999345114704, -0.9999997723858, -0.99999696233936, -0.951693760845888, 
-0.999999877511663, -0.809113022010629, -0.957478285265484, -0.999996536564866, 
-0.999998189435708, -0.99999984108349, -0.999999448013528, -0.939065100673397, 
-0.99999961805528, -0.999999658087507, -0.999986295791517, -0.82243832039861, 
-0.999999570878065, -0.90634217434179, -0.933382938405183, -0.933308058479623, 
-0.999999516552218, -0.85903168394701, -0.999999057053614, -0.999999403127011, 
-0.962857611209916, -0.99999955654341, -0.950682399171018, -0.99999850340486, 
-0.999999559603252, -0.99999283817655, -0.955314263763647, -0.999997257414712, 
-0.999999434817756, -0.895630644231554, -0.944422975881712, -0.999996370382613, 
-0.999999637156723, -0.999996771123239, -0.870506193910945, -0.99999846361049, 
-0.999958415347868, -0.999999834385657, -0.999997440762, -0.980923439220733, 
-0.999999551172327, -0.999999159718133, -0.999999711859262, -0.99999950614905, 
-0.746878332167182, -0.999997286357695, -0.999999744916585, -0.999993596043815, 
-0.999998068635097, -0.918782185202522, -0.917720792833433, -0.999999559994532, 
-0.999999539816867, -0.999999406661265, -0.999999730215515, -0.999998379051263, 
-0.982837141275285, -0.96260805446893, -0.999999157691412, -0.999999432494832, 
-0.947876862579653, -0.9999994916794, -0.980274506067544, -0.99999958294085, 
-0.999999154469075, -0.999999652622946, -0.999999600969197, -0.999999773291083, 
-0.999995889078872, -0.861042300058078, -0.999999423060014, -0.999999629822471, 
-0.991639531435799, -0.99199818439206, -0.958512469732026, -0.940539675737137, 
-0.999999651251557, -0.915649725715746, -0.999999188692226, -0.96259837292874, 
-0.999999828316588, -0.999999842018904, -0.999999883000746, -0.968853392128112, 
-0.999999545782527, -0.960473729443212, -0.999999490421006, -0.99999865182794, 
-0.999999701559625, -0.999999890028715, -0.892659072072682, -0.999999328937778, 
-0.982861268904818, -0.999999771213282, -0.915986258848368, -0.999999674818847, 
-0.927853654891981, -0.99999883360019, -0.99995497106764, -0.999999502918652, 
-0.999432353826382, -0.999999654455573, -0.999999708232384, -0.999999977121143, 
-0.9561296665418, -0.944738203721876, -0.893349264055463, -0.959560600551704, 
-0.999999468818106, -0.999999204746528, -0.94042983958241, -0.999998760463543, 
-0.999999520189007, -0.99999834782794, -0.999999515467228, -0.999999881039574, 
-0.956770372078348, -0.92024216677601, -0.914036203732194, -0.987583837454942, 
-0.999999466561182, -0.999998930085985, -0.982281468406625, -0.927179325320812, 
-0.999999850757929, -0.999998426236155, -0.999999423729402, -0.98117721728025, 
-0.999999073031802, -0.924278435519504, -0.999989916338641, -0.999999934483825, 
-0.99999984114155, -0.999999695477856, -0.999999804205674, -0.913586446211851, 
-0.850722575737794, -0.9999996540795, -0.999999407640695, -0.999999432964375, 
-0.999999676122845, -0.999999006589564, -0.999999606593218, -0.999999728702014, 
-0.999999595442, -0.999999508376854, -0.917432918492153, -0.914297141775867, 
-0.999999390434143, -0.999999376567784, -0.980614098145732, -0.999999411110372, 
-0.999999510042276, -0.930110210878662, -0.926614236300932, -0.715299842682895, 
-0.999999969642244, -0.907234758880128, -0.999999758722174, -0.999999500678294, 
-0.999999858935086, -0.963809346977798, -0.999999466580315, -0.908205478397257, 
-0.999998716837398, -0.999999579160357, -0.999999889091228, -0.999998884713952, 
-0.999999962377125, -0.99999989896115, -0.999909018253652, -0.999999851315939, 
-0.99999978216146, -0.99999998807349, -0.99999930907606, -0.999999656232542, 
-0.999999753272564, -0.999998754344807, -0.681365632603639, -0.952420686045422, 
-0.901705950863545, -0.926119117585891, -0.999999511708807, -0.999999158356274, 
-0.916362178786873, -0.919712129603306, -0.960986333542644, -0.99999917616368, 
-0.999999997287792, -0.99999969184555, -0.99999958950905, -0.999998478587878, 
-0.999999613049586, -0.956142413868555, -0.889689932161378, -0.887601351240055, 
-0.999999573127422, -0.999999066602474, -0.999999648412385, -0.983892101571204, 
-0.841150455057249, -0.94072370924454, -0.879876133861617, -0.999999245016656, 
-0.943019242093465, -0.899838461725444, -0.999999515092593, -0.999998289308284, 
-0.815912254565746, -0.87677883887486, -0.999998572856914, -0.999999847851322, 
-0.999999418651803, -0.914497790696836, -0.919028875345934, -0.99999015948159, 
-0.999995692169484, -0.999999197915833, -0.933337906733512, -0.937017438362922, 
-0.828050282642282, -0.999999993081618, -0.999999199583193, -0.999999390462435, 
-0.999999594004348, -0.999999672042827, -0.910181328724905, -0.999991609763798, 
-0.970953689467358, -0.946819437685225, -0.999999559275651, -0.999999911814917, 
-0.99999953301961, -0.999999490925362, -0.999999112541603, -0.999994589386312, 
-0.999997194350197, -0.999999502896763, -0.999999382572179, -0.999999555097703, 
-0.999999394298325, -0.99999947569905, -0.907520099223992, -0.896828936274307, 
-0.999999499862787, -0.999999195006435, -0.999999485324412, -0.999999505964496, 
-0.999999767884273, -0.941483692732872, -0.999999583354453, -0.999999221659867, 
-0.999999719998064, -0.945588356209809, -0.993941042317786, -0.922816228448366, 
-0.999999345188774, -0.907305606239144, -0.99999911896278, -0.999999537971337, 
-0.946951313739687, -0.999998940751227, -0.999999503977225, -0.978283268963795, 
-0.983803014984325, -0.946913793083082, -0.999999512144712, -0.999999652162715, 
-0.999999691308681, -0.999999993192333, -0.99999808509263, -0.999995806069912, 
-0.999999617826865, -0.959302932437156, -0.881993389712265, -0.999999520742571, 
-0.999999540247784, -0.999999582352615, -0.999999745426555, -0.999999588031966, 
-0.927374786574727, -0.999999515058017, -0.999999624837852, -0.999999746854848, 
-0.999999232773309, -0.999998000696834, -0.99999060243107, -0.99999910032752, 
-0.999999764322217, -0.880378189633234, -0.931973026630232, -0.999999499878983, 
-0.9025291728852, -0.999999576378332, -0.952625335582025, -0.99999894105558, 
-0.999997396040201, -0.999999364854607, -0.99999952149608, -0.999999559658884, 
-0.99999769108905, -0.999999501631131, -0.999999993128266, -0.999999905615082, 
-0.973406135344164, -0.999999684640632, -0.99999949416155, -0.999998939481816, 
-0.999999277275106, -0.999995042291409, -0.999999636787879, -0.935048895516284, 
-0.999997353306187, -0.932942265856394, -0.949563261344743, -0.821253427678901, 
-0.927730567937881, -0.96074610354968, -0.819083584194525, -0.986825554820032, 
-0.999998887462235, -0.999999916752218, -0.958562593927668, -0.804126663792526, 
-0.999999229055663, -0.893146466507125, -0.999999536990237, -0.844020792300487, 
-0.999996722063958, -0.790328226840912, -0.888758298386285, -0.897183011220299, 
-0.8942567241856, -0.999999501106542, -0.999999577801385, -0.857658033556387, 
-0.99999953188385, -0.99999995539822, -0.929282948070978, -0.99999857502423, 
-0.944773807645656, -0.999999638999952, -0.999999631075021, -0.999999477140066, 
-0.99999956735751, -0.999999392730496, -0.916826707039877, -0.999999584198555, 
-0.920892859160367, -0.760195467579071, -0.999996418104568, -0.947954945044301, 
-0.960278907111182, -0.957514871785932, -0.907257518261674, -0.999999537096458, 
-0.999999439001303, -0.80988462813789, -0.999999509998802, -0.969978623834441, 
-0.99999949311065, -0.921819478996602, -0.999999115527896, -0.940626467463996, 
-0.966852429686281, -0.999999491212623, -0.999999515449228, -0.999999942701027, 
-0.665079828823347, -0.99999999657746, -0.999998935520306, -0.999999646531658, 
-0.999999767198845, -0.88823417333315, -0.999999353122352, -0.999999685592978, 
-0.930877950555454, -0.999999954016363, -0.999999808453415, -0.999970102595838, 
-0.999999470679664, -0.99999790961134, -0.836456471760199, -0.999998305422858, 
-0.999999611181648, -0.9783500585972, -0.964346291436588, -0.92697738174674, 
-0.999999198652175, -0.99999773544487, -0.999999578482658, -0.999999591129308, 
-0.914518433972045, -0.999999499906832, -0.999998489419944, -0.999999866798787, 
-0.946716100666185, -0.99997503300809, -0.887218971208421, -0.931231540539314, 
-0.999988252284457, -0.999999195700084, -0.836980010485887, -0.999999513272045, 
-0.99996564537804, -0.924298694990094, -0.975275815713225, -0.92528511470681, 
-0.99999954688701, -0.999999337037279, -0.865588475386501, -0.99999948890178, 
-0.999999371175984, -0.99999936012178, -0.93741524740627, -0.99999131833201, 
-0.999999674819066, -0.999999483644272, -0.999998961182935, -0.904520933085623, 
-0.99999781882718, -0.99999998508327, -0.99999734939208, -0.99999668594345, 
-0.96299245020279, -0.928025607184623, -0.99999979909677, -0.829811606718678, 
-0.999999574831072, -0.999999582624209, -0.999995882533426, -0.99999914652677, 
-0.99999950725056, -0.99999931873238, -0.999999958636746, -0.873488365799707, 
-0.908702839567858, -0.845975262251054, -0.99999958825504, -0.954350579870554, 
-0.999998039697861, -0.99999949394818, -0.999961120455858, -0.999999499676775, 
-0.999999127075131, -0.99999381408795, -0.999999594495715, -0.999999422509746, 
-0.95302338498117, -0.999999687608504, -0.999988377968977, -0.97741861425371, 
-0.999998330548307, -0.99999960955324, -0.932480156316491, -0.999999567442658, 
-0.999999969581607, -0.966180922616345, -0.96356271928247, -0.779264784610145, 
-0.999999686642587, -0.999999776295361, -0.999999595785176, -0.99999992444944, 
-0.999994772604432, -0.999999108973077, -0.999999506652407, -0.771928730693417, 
-0.99999990887489, -0.999999641824333, -0.98854126559287, -0.999999497723752, 
-0.999999574114054, -0.999999862734187, -0.866429627329369, -0.999999783961642, 
-0.999999052597174, -0.999999630344755, -0.888408006100723, -0.909743605865325, 
-0.999999958176149, -0.999997326618225, -0.999999921294833, -0.86726758186809, 
-0.999999507704152, -0.89565653146838, -0.999999348949103, -0.999999681655126, 
-0.909742823018787, -0.999999800920109, -0.936643083277103, -0.999999537276278, 
-0.938623682972164, -0.938422823384604, -0.999999725845691, -0.904480432747837, 
-0.936505666986198, -0.999999750561631, -0.999998911707774, -0.999993637662726, 
-0.999999882621078, -0.919827816848062, -0.999995389007265, -0.9999995821478, 
-0.9999994435031, -0.951327546771373, -0.999999497730837, -0.863822556315006, 
-0.926261223302613, -0.999899224277484, -0.999999975878404, -0.999999856115107, 
-0.960097710489992, -0.999999639349142, -0.999999999143376, -0.999999415799668, 
-0.999999501127278, -0.98130813279268, -0.893650857966469, -0.999999810756295, 
-0.999996983836887, -0.999999500017945, -0.999993520488785, -0.999999635028576, 
-0.999999016490046, -0.999996105023322, -0.752775128553217, -0.999998813271061, 
-0.920304358271121, -0.999999937244158, -0.999998522217358, -0.999999727136249, 
-0.99999979619683, -0.999998292036907, -0.999999418541335, -0.96749497349802, 
-0.999999473013263, -0.903317942366985, -0.929941778811688, -0.999999859505369, 
-0.892420748892511, -0.999995859389481, -0.999997983719848, -0.977804696796076, 
-0.999998983895578, -0.829776867988793, -0.999999556445336, -0.941373882151368, 
-0.92610880678542, -0.941908879434906, -0.999999512002894, -0.999999467853257, 
-0.999992416430316, -0.99999967786281, -0.999999514525888, -0.999999553441416, 
-0.9999951987311, -0.999999904474688, -0.999998654807823, -0.999997700664091, 
-0.903265895064719, -0.999993183098305, -0.636135675159099, -0.99999961968635, 
-0.939853390980757, -0.999999457314827, -0.84471978137419, -0.965620116934626, 
-0.999998850144616, -0.999998853981937, -0.999999602709397, -0.999999508872376, 
-0.99999637514014, -0.927524160181823, -0.999999813075395, -0.952801419674087, 
-0.899505768960623, -0.68000128793075, -0.999989268893554, -0.999999783429293, 
-0.999999087436572, -0.999999463052367, -0.999999504393298, -0.99999859202989, 
-0.99999976729013, -0.99999992408772, -0.96270257887711, -0.999999500165723, 
-0.707126302451634, -0.979388793963424, -0.905800771858626, -0.958864039362966, 
-0.999999547125215, -0.926251339133236, -0.964176656710653, -0.999999646316996, 
-0.999999114254896, -0.918059672422282, -0.88446310123272, -0.883292246230046, 
-0.999999501875835, -0.999994319725288, -0.999999884402043, -0.999999240966555, 
-0.918297796832083, -0.999999591007417, -0.837351432430685, -0.908070766361018, 
-0.999999839811745, -0.616552791298006, -0.999999522256929, -0.811378298927333, 
-0.999999756482823, -0.919805907515066, -0.999999547483633, -0.967247562178508, 
-0.999996951258509, -0.780459477791666, -0.999999699133403, -0.99999553600777, 
-0.99999987945035, -0.999999327017216, -0.96979428579289, -0.850525935941403, 
-0.999997864137773, -0.999999581495857, -0.898422297616704, -0.999998419141782, 
-0.999999560361675, -0.999999864371687, -0.99999975233604, -0.96215718784027, 
-0.999999668254517, -0.99999978484136, -0.999998861942534, -0.999999553872872, 
-0.94949712344222, -0.99999938668219, -0.999998430483867, -0.906539618764557, 
-0.939527676235205, -0.954337456242533, -0.999999641868354, -0.999999387000288, 
-0.912907901783644, -0.999999750768608, -0.999999485944776, -0.999999716351192, 
-0.928183698425952, -0.999998342609037, -0.999999488066425, -0.908995275181283, 
-0.918506250314291, -0.99999962395161, -0.999999975716527, -0.721446166588275, 
-0.999997128430606, -0.999998634852241, -0.999999881994265, -0.999999531154005, 
-0.999993771513889, -0.999999496115005, -0.999999830037555, -0.874104790481448, 
-0.999999516003803, -0.943210164088914, -0.86926651170129, -0.933810705038826, 
-0.967329560501793, -0.999995516293243, -0.880290368441047, -0.999999823604254, 
-0.999999680223966, -0.999999757255053, -0.999993375488864, -0.999972811692154, 
-0.999999657047475, -0.973370707577972, -0.999999057901545, -0.969659950126676, 
-0.924429945051259, -0.692456369448109, -0.999998871205252, -0.975198756628936, 
-0.999998903008648, -0.999999449567681, -0.99999981124179, -0.999999921316442, 
-0.999999853279219, -0.999994358944818, -0.999998883010392, -0.96233515224868, 
-0.958186974120629, -0.999999298837671, -0.999999513141108, -0.99988141254977, 
-0.999996673851715, -0.999999691204041, -0.999999760979381, -0.934417635465528, 
-0.947446324014452, -0.82990281975868, -0.999999489669712, -0.99999809139223, 
-0.99999939220292, -0.999999503892508, -0.999999499743799, -0.99999914083202, 
-0.91835793116492, -0.99999965963065, -0.999999871982965, -0.96910740915961, 
-0.949484190157361, -0.999999330293825, -0.829812546612234, -0.999999871325323, 
-0.878227836961038, -0.99999959781428, -0.999999572677048, -0.94551403380220, 
-0.959634981420734, -0.905086201649613, -0.999998008446094, -0.999999945955741, 
-0.999999500187312, -0.999998309869638, -0.999998410890076, -0.999999496131757, 
-0.999999615187806, -0.95399282575842, -0.999993676180892, -0.999999855033145, 
-0.999978475556978, -0.999999768623006, -0.776057616028397, -0.999998404294268, 
-0.999999905645088, -0.99999905862386, -0.97333806392239, -0.96335317183187, 
-0.943889579385636, -0.99999147195066, -0.999999792354672, -0.979982762569089, 
-0.880291508154721, -0.956024177986856, -0.900322899237334, -0.96854379462424, 
-0.930687916589994, -0.930390253684468, -0.902863399054513, -0.973888669472463, 
-0.999977246544877, -0.91498093801065, -0.999999597564936, -0.952389495916233, 
-0.929868561109048, -0.927033255987991, -0.99999950634729, -0.999999545955048, 
-0.999999142717387, -0.999999736285639, -0.99999995746429, -0.941130992316407, 
-0.92213244583425, -0.921049210218389, -0.95190840613659, -0.891847074079798, 
-0.999999484149336, -0.99999724859397, -0.999999770070713, -0.999999436802096, 
-0.999999500800416, -0.999999504753678, -0.999999975669748, -0.948758282190347, 
-0.999999686221257, -0.85236075202426, -0.99999899817151, -0.999999903384623, 
-0.999999610242722, -0.886324819203416, -0.895837759894138, -0.999999580429481, 
-0.999999479202282, -0.999996133178843, -0.999999730010654, -0.886315592271038, 
-0.999999090641688, -0.9031261969966, -0.999999885174156, -0.94474387417790, 
-0.970656256688828, -0.999999852530687, -0.999999470686502, -0.970647137008654, 
-0.999999855503266, -0.999999782794602, -0.875642967442786, -0.999999712661542, 
-0.999999992078897, -0.97685894986107, -0.902206747695884, -0.846308470002316, 
-0.937710940198977, -0.899961789507677, -0.999999500203725, -0.703922673575472, 
-0.99999955729408, -0.894511526075797, -0.942666327283753, -0.990523206582026, 
-0.950553592742835, -0.99999988250167, -0.926064468176931, -0.999999500538174, 
-0.999999780951387, -0.999997131067972, -0.900615625119591, -0.870525871203472, 
-0.899887196470965, -0.799666472393398, -0.967837732644848, -0.868290981617609, 
-0.999999878884968, -0.854192276233445, -0.82490013789274, -0.999999702198016, 
-0.968728000439338, -0.99999974182704, -0.999999538727316, -0.899990454176936, 
-0.999995636170216, -0.999999708154387, -0.833458715582128, -0.874780648950218, 
-0.86822044761345, -0.920590576535734, -0.928459347010455, -0.999999852977185, 
-0.999999203311036, -0.99999615488881, -0.886599000917351, -0.939476043053034, 
-0.999997923440864, -0.999996733752436, -0.999999365559048, -0.970048615427303, 
-0.97028553229381, -0.910765764314346, -0.998810395716573, -0.749516610827022, 
-0.893102719808589, -0.97490863833021, -0.999999636063212, -0.981116303871851, 
-0.999999367306835, -0.999999480753664, -0.999999745571705, -0.851886958335445, 
-0.955903330099318, -0.732837172073342, -0.855440273812502, -0.955286426750457, 
-0.89682338995232, -0.999990223805101, -0.999988550191058, -0.661527819264002, 
-0.999999975969728, -0.856699586709295, -0.909492999961771, -0.836001191309733, 
-0.91366248290571, -0.957438364409385, -0.881237922689033, -0.923384751249942, 
-0.999998554339038, -0.999999498675769, -0.999999890602766, -0.999999760151638, 
-0.965760283433907, -0.890038239148779, -0.931948061576594, -0.96396041435642, 
-0.999999687000436, -0.832888517780916, -0.914623166098775, -0.900637225807817, 
-0.94098919552629, -0.827737725641228, -0.791167499068226, -0.857509558512055, 
-0.999999397358108, -0.874327295932086, -0.77678448428975, -0.62813889648966, 
-0.907155144091305, -0.781013344053275, -0.934927932530323, -0.773558090089397, 
-0.99999996441246, -0.871215606808478, -0.875269472491919, -0.942781344697185, 
-0.912220994763049, -0.999999483721381, -0.823760758654837, -0.963231099565743, 
-0.999999353429723, -0.925761405889243, -0.99999964371738, -0.999997069035796, 
-0.752905647512323, -0.966370034281928, -0.999999682655066, -0.884635244884883, 
-0.826374295893416, -0.999999272019153, -0.807649605854897, -0.914489209663444, 
-0.83013022376032, -0.898108581767257, -0.999998428257152, -0.865542699255415, 
-0.999999676125921, -0.999999737197971, -0.999999759950762, -0.855620937574414, 
-0.961512701582439, -0.901765295302864, -0.894553408533386, -0.999999993528906, 
-0.999998758187605, -0.999999972064849, -0.99999951136244, -0.999999792362673, 
-0.86543634046329, -0.772278719027373, -0.999999571707506, -0.804273460874446, 
-0.879216518606936, -0.999998801389265, -0.824032481802578, -0.84706920241176, 
-0.99999946586956, -0.72223792707958, -0.74893140662225, -0.818948149404172, 
-0.833493681211204, -0.999989617313965, -0.999999701508965, -0.865067851283266, 
-0.880826794517608, -0.857441420641, -0.865432656948428, -0.985167929687103, 
-0.82764569093115, -0.876132451659032, -0.999999894133331, -0.999999659059353, 
-0.99999992749996, -0.851180724223123, -0.589362617971878, -0.703573773752511, 
-0.96695347576686, -0.999999540428602, -0.79837071498422, -0.999999709794047, 
-0.999999448883848, -0.999996806763983, -0.999999416633703, -0.827570652028459, 
-0.96459810692186, -0.99999973922928, -0.945024009866567, -0.95658007391143, 
-0.76345038963804, -0.999999723146807, -0.896152896353338, -0.934708095923604, 
-0.912033590802118, -0.999999905212506, -0.899856638983197, -0.999998144614963, 
-0.999999529736197, -0.892084257113957, -0.999997431926242, -0.827518801544554, 
-0.944827023876174, -0.909497700124088, -0.939054010463072, -0.925567612510576, 
-0.87175077786389, -0.999999499596529, -0.863156824952415, -0.827174421649232, 
-0.9212977945067, -0.813473262706184, -0.731578725639363, -0.881196276142448, 
-0.844947621299444, -0.999999528431326, -0.759576520867897, -0.923303305610174, 
-0.92470481824826, -0.999999784888428, -0.906842100559365, -0.902673510912872, 
-0.812064129548684, -0.999999598078762, -0.948879706793463, -0.757820139690213, 
-0.853725885275219, -0.999973793912028, -0.999999686002418, -0.99999988245443, 
-0.908370200475046, -0.880342496353537, -0.999998793414991, -0.992676180227778, 
-0.99999955503318, -0.804660030889046, -0.815476790936658, -0.865726761510601, 
-0.999999596980507, -0.788013774129433, -0.99999944242044, -0.873709313070336, 
-0.943161209053665, -0.932291466294743, -0.909010300326284, -0.912026318522626, 
-0.929268219485618, -0.9361452127873, -0.915641934831768, -0.999991995255886, 
-0.920486582269274, -0.868671733468635, -0.590004574756634, -0.811058570844121, 
-0.785803786426727, -0.999998018333414, -0.999999572222638, -0.877218236666091, 
-0.999999574032833, -0.900824607050957, -0.945456816591243, -0.944192445245413, 
-0.936565624448606, -0.799073932822925, -0.95237592941494, -0.771976551180562, 
-0.99999963642166, -0.731694860783801, -0.999999152674783, -0.74733562504961, 
-0.999994394957227, -0.926623835478077, -0.87897836761442, -0.821373081567008, 
-0.999999521752557, -0.999999960198601, -0.847500685733878, -0.808465677774944, 
-0.999999611406242, -0.75240878536105, -0.999995032698692, -0.738324642051063, 
-0.852504529550364, -0.930510773957373, -0.999991033425933, -0.999998451762728, 
-0.999999998701718, -0.496176574133704, -0.999999440067348, -0.839719714934071, 
-0.999999710684136, -0.895783006462934, -0.99999934778665, -0.876722423418669, 
-0.869091330831364, -0.843141088813384, -0.848603032380171, -0.999999677570042, 
-0.803044057962677, -0.885291840202173, -0.913453005666368, -0.922654599937731, 
-0.848130952830225, -0.999999438279218, -0.911411774369733, -0.866649617226671, 
-0.883627099697017, -0.824080121442045, -0.999999442482277, -0.91146110644468, 
-0.999998010623226, -0.817380145256707, -0.999999373430116, -0.999998201174482, 
-0.999997119652642, -0.999995912971124, -0.854336275143086, -0.856547006860453, 
-0.920756773025417, -0.792116371070668, -0.888269808810163, -0.999997447123722, 
-0.999998558509656, -0.94176019084183, -0.99999959225288, -0.940791437995393, 
-0.910669618680104, -0.79292480200877, -0.744914191953982, -0.71958058324735, 
-0.999974127530184, -0.88044862830383, -0.999998764180383, -0.999999953056715, 
-0.764061768732951, -0.796829454433352, -0.79873254619742, -0.999999520377676, 
-0.921256606935051, -0.799120378391001, -0.999999501465347, -0.9999988622347, 
-0.999999827465931, -0.644260947107682, -0.84045678355104, -0.954012932208207, 
-0.769400236719121, -0.849584678170262, -0.999999046136594, -0.861651350721126, 
-0.917645754700585, -0.999983823658192, -0.903214254693969, -0.99999943517164, 
-0.99999991813705, -0.999999835751321, -0.723917128440502, -0.999994270939104, 
-0.949408228446799, -0.87800211309497, -0.754318451327513, -0.902829475014889, 
-0.877929415120353, -0.898378169765555, -0.955447303359117, -0.668257975770281, 
-0.999999910190142, -0.999999325270404, -0.99999955159441, -0.863747009599577, 
-0.752392169762979, -0.94017048397078, -0.894827191169884, -0.940138121966925, 
-0.908365881830258, -0.951953855454046, -0.856636979082126, -0.99999817567608, 
-0.999996853248796, -0.837875924280233, -0.976668495962497, -0.999999490482978, 
-0.890288958206285, -0.948925165806214, -0.900284399771325, -0.710507757219347, 
-0.962398030493443, -0.86741487717875, -0.88202627457274, -0.80361103662318, 
-0.924560309780683, -0.90069921713618, -0.742733201357876, -0.999998879075399, 
-0.999991770300376, -0.875400603822589, -0.900249487305812, -0.999999540020589, 
-0.923517872811542, -0.99999978862618, -0.90510394406556, -0.84704569417598, 
-0.958615622382373, -0.999999944179022, -0.999999742989706, -0.811577861755103, 
-0.999997805429679, -0.876001866502345, -0.912563449558758, -0.99999950188749, 
-0.930501880366343, -0.94625903227491, -0.999999729371257, -0.999996981195747, 
-0.586096337443257, -0.93665627260927, -0.893770097299681, -0.9999960251064, 
-0.999999017246296, -0.877550503989966, -0.879732837200563, -0.940601545559583, 
-0.909140194508277, -0.999999500357548, -0.880476406797282, -0.975875579736003, 
-0.888169113552718, -0.828883752838717, -0.879350953932281, -0.839044561715482, 
-0.741406647815558, -0.999999500955878, -0.999999842987011, -0.980149547079611, 
-0.999999530873389, -0.999999989441058, -0.916814077642842, -0.894260025657543, 
-0.828525711685194, -0.876040463257562, -0.911082193072737, -0.850056247082306, 
-0.999998999442671, -0.783398787891257, -0.999999532596043, -0.916348700359552, 
-0.927993076141391, -0.959807375660646, -0.870372173441708, -0.891029097705594, 
-0.999998198854702, -0.908531865630563, -0.9999984533287, -0.931440144739164, 
-0.87322039199552, -0.901008786353054, -0.96740170096901, -0.735003757629461, 
-0.873410338838552, -0.99999992495236, -0.999999629713553, -0.999997798234721, 
-0.892943968089443, -0.999997522650821, -0.639330558955793, -0.878473556454935, 
-0.999999805540232, -0.683502732394422, -0.999999716636022, -0.877435944746465, 
-0.999999455214051, -0.915638457402736, -0.90689094647606, -0.99999818124109, 
-0.941349654184854, -0.910116233868495, -0.9999995006329, -0.91659012692868, 
-0.88740064927426, -0.985577082154313, -0.840119333801926, -0.951877708048237, 
-0.88513729607672, -0.748165003955774, -0.878667865490073, -0.812030125532645, 
-0.745530737757181, -0.948910972336849, -0.801977514902622, -0.97431480133073, 
-0.921324196912263, -0.821677217212229, -0.84755044199109, -0.9999885288034, 
-0.999999511522586, -0.950446630074455, -0.999999694509781, -0.970185706803325, 
-0.720949208640283, -0.92447568720762, -0.831878523889772, -0.882434083527524, 
-0.935271580710592, -0.9360975371271, -0.858839771552649, -0.853242582628921, 
-0.99999984749387, -0.895940190637642, -0.879135566509198, -0.9103052601355, 
-0.886401353928006, -0.719535821929594, -0.885947096712689, -0.999999487911396, 
-0.86494937005368, -0.919536198016193, -0.818603700980881, -0.907390551211995, 
-0.763418596233491, -0.737532683592215, -0.823388702647142, -0.871423970587602, 
-0.9659118420601, -0.919816998601057, -0.942869397051048, -0.77449357862396, 
-0.99999949394779, -0.906709065428458, -0.855047608849303, -0.89163113988877, 
-0.782809306846234, -0.99999992047709, -0.895511808828127, -0.893132314757436, 
-0.915550663173805, -0.999999284082146, -0.861053507898697, -0.860214062274233, 
-0.999999503742672, -0.852593280302105, -0.969674649783912, -0.827504233518346, 
-0.882930262714944, -0.944027390594532, -0.830633377290677, -0.999999289017892, 
-0.727359576499607, -0.860578262386636, -0.999999466431845, -0.999999286568011, 
-0.999999835720283, -0.999999609139166, -0.790364134904469, -0.848491214911458, 
-0.964577978108105, -0.804548026087661, -0.943177856353355, -0.918539765058349, 
-0.999979956593867, -0.999999697217182, -0.908957962009869, -0.9999993980113, 
-0.945920472736452, -0.856429190418323, -0.857971030170345, -0.99999923318426, 
-0.815641976004191, -0.846579894461144, -0.863666397686238, -0.999999614464487, 
-0.972114826218993, -0.949039125614804, -0.984570519346708, -0.870289103575557, 
-0.880722399758367, -0.833547052465454, -0.97084740116816, -0.898276962342071, 
-0.753639859698169, -0.999999838659979, -0.99999917882371, -0.84426176920237, 
-0.888365070411969, -0.913136991886249, -0.833819873054403, -0.908567145471716, 
-0.999999550124781, -0.999999677340172, -0.906968703024628, -0.83271071361971, 
-0.999992426838245, -0.650144591616314, -0.999999653041571, -0.803430061266435, 
-0.999994977124148, -0.878676658594452, -0.999999832973011, -0.999989397987887, 
-0.919978717130384, -0.999999771908542, -0.999999897562643, -0.87395905280678, 
-0.874290705013425, -0.850036315304002, -0.930898502956228, -0.999999482984615, 
-0.911706171142298, -0.91087664876151, -0.81961829059852, -0.916696285450552, 
-0.999996542973713, -0.977203921781144, -0.999999681998525, -0.81070731587482, 
-0.999989953569834, -0.999999834916656, -0.875098930213499, -0.999999218444568, 
-0.999999502149418, -0.844831228443893, -0.759894939481102, -0.999999476890992, 
-0.999999556983988, -0.765341570087654, -0.83428674616382, -0.865366336052687, 
-0.822775587053828, -0.999999724242806, -0.99999960821928, -0.87721908099568, 
-0.999999918347133, -0.8458872964523, -0.99999956125994, -0.929094486488798, 
-0.759026135435408, -0.99998204476742, -0.978518975571731, -0.999999287667734, 
-0.978037575059313, -0.89234918921689, -0.791521935401553, -0.999997931662614, 
-0.883323671620517, -0.9999995808175, -0.927634826829093, -0.893567944460016, 
-0.999997502637538, -0.919357624184068, -0.927883599852323, -0.848393640046139, 
-0.876466417505734, -0.999999510703155, -0.889947828773287, -0.890613089628753, 
-0.99999641138131, -0.999998955599682, -0.74660936208395, -0.969017304627105, 
-0.912575526230219, -0.999999467637981, -0.973552698633265, -0.86089372076744, 
-0.91871480774245, -0.94000792850473, -0.883761520389847, -0.760960005002846, 
-0.424272726700093, -0.884649744031692, -0.895151321057045, -0.834958361418543, 
-0.999999498537462, -0.999999602676078, -0.99999767061455, -0.89239656521567, 
-0.999999911944637, -0.91795257179575, -0.836788102611865, -0.99999960130323, 
-0.889180916928021, -0.85550425866793, -0.963648562783728, -0.804964188028838, 
-0.967033113421712, -0.845454989292797, -0.897703706194312, -0.892190782209701, 
-0.999995962440905, -0.99999949253851, -0.99999935369704, -0.898563811934718, 
-0.903653866441626, -0.9442923565722, -0.788283661591877, -0.846933420511037, 
-0.880895401318242, -0.814678284140949, -0.999999475007904, -0.915028752670083, 
-0.859230574396368, -0.771879427727501, -0.863121170734885, -0.796674290526621, 
-0.811069079265911, -0.831062067867973, -0.99999996628437, -0.99999920182209, 
-0.953817776274084, -0.780963620946841, -0.702263594210496, -0.999999644840357, 
-0.890273508120864, -0.859559258427726, -0.767207887243162, -0.871928541861774, 
-0.797944186336617, -0.999986618968165, -0.765577971878243, -0.853851691146633, 
-0.922368735210554, -0.889776405753565, -0.872062043415545, -0.840100635743827, 
-0.839542606433324, -0.877503987552363, -0.999999965197174, -0.817479374671627, 
-0.999999947541336, -0.846654837066593, -0.788390318641324, -0.906070577790008, 
-0.99999963256054, -0.99999950153562, -0.656031742163866, -0.921013837684995, 
-0.859963598421111, -0.999998384472583, -0.884118829480108, -0.92700219856681, 
-0.999999715424437, -0.910518696328505, -0.815615042473145, -0.774687441077351, 
-0.853080626027463, -0.999997822645211, -0.818505411252049, -0.999999770258164, 
-0.99999960684727, -0.905163640924475, -0.878316629480939, -0.999999729355146, 
-0.9999995111819, -0.999996887635536, -0.932414382694522, -0.938573692791363, 
-0.858818343843286, -0.999998714418624, -0.950233033486054, -0.855406428935614, 
-0.999957227557537, -0.999999925488658, -0.79853062820907, -0.999998767322919, 
-0.826498949181025, -0.894511179252105, -0.999999854270804, -0.99999967336006, 
-0.885429367218472, -0.953636786881522, -0.999998697352267, -0.999999990151325, 
-0.845515554992512, -0.924873761955372, -0.860052687819275, -0.879857954118325, 
-0.976954957434783, -0.999999507508727, -0.801572641721062, -0.9999992057671, 
-0.838792455776728, -0.999999869621173, -0.512332449986952, -0.911339422451195, 
-0.999999581354621, -0.888121946957641, -0.710072789267971, -0.88343042791991, 
-0.898380634557924, -0.865179627939198, -0.999999670174114, -0.82540989689125, 
-0.999999503253132, -0.910255656038751, -0.875723436621365, -0.999999660562424, 
-0.85790838542319, -0.845397604157595, -0.932865699097124, -0.999998039363535, 
-0.99999907591804, -0.891200594381013, -0.890774640739932, -0.921889603058742, 
-0.801761576465285, -0.643727138163298, -0.999999373730136, -0.99999788744163, 
-0.99999995496408, -0.791040008958251, -0.977878408708172, -0.918319427635285, 
-0.909483934342712, -0.999999574013641, -0.99999967903532, -0.753617059819518, 
-0.840194509165347, -0.898122227961192, -0.905093839291216, -0.818002321718313, 
-0.88701933185713, -0.92725835833033, -0.999999588797867, -0.999981015214146, 
-0.916012824718503, -0.756910695700647, -0.999998868480963, -0.999999717439992, 
-0.914517530772474, -0.927278932517141, -0.96084549107271, -0.999999977172658, 
-0.807053564237825, -0.909267736036277, -0.864692194695827, -0.999999726841166, 
-0.859334412455583, -0.841747381509229, -0.95662481914114, -0.999997778006132, 
-0.999999554003556, -0.927144129151545, -0.9033653424836, -0.806423984183447, 
-0.999999965326389, -0.823328011728913, -0.999999546702542, -0.99999965223056, 
-0.999999677617073, -0.999998111472343, -0.76297697086286, -0.935629676395535, 
-0.999999829440883, -0.788101851915161, -0.999999160114968, -0.882464668836404, 
-0.855363923889612, -0.999997346491457, -0.894653477734478, -0.999999513447453, 
-0.675014147459301, -0.9028637193228, -0.814745720112735, -0.850609301509826, 
-0.896036212809588, -0.999998860742825, -0.952433960418531, -0.999999634725, 
-0.999999968379608, -0.815219406547582, -0.872729226086098, -0.700738262617059, 
-0.960807668563892, -0.870213395433942, -0.99999924123964, -0.999999118210411, 
-0.913785683359949, -0.920787822489104, -0.937180956594757, -0.764179086321413, 
-0.99999958149533, -0.82387550718501, -0.767857674559022, -0.932328299216418, 
-0.999975239113628, -0.999999348544098, -0.85162466809384, -0.799135096295718, 
-0.999999408276836, -0.844986952711427, -0.841245974791207, -0.999999678431756, 
-0.943321733266098, -0.999999536899062, -0.777980788855231, -0.999999495492837, 
-0.758651196898875, -0.846212355541126, -0.818589864520552, -0.882063440011183, 
-0.999999708462234, -0.999998589658829, -0.999999959660433, -0.929317061216743, 
-0.999999949854912, -0.905141210486107, -0.999999962721587, -0.927692352787372, 
-0.65754449270501, -0.999999481882102, -0.999954973264778, -0.958634901931264, 
-0.883270473543997, -0.947984844605562, -0.713675488540473, -0.836236223923886, 
-0.901426017029874, -0.889391425015304, -0.79663474242399, -0.789080016538566, 
-0.929042444845877, -0.645351818440469, -0.905490659764725, -0.999999438555543, 
-0.863837261520935, -0.904926407026624, -0.999995741606405, -0.999999689462707, 
-0.999998918971442, -0.917427086980718, -0.999999513784762, -0.999997821760149, 
-0.831038773244393, -0.867637785456297, -0.95145418736556, -0.999999781906315, 
-0.856048828555919, -0.999997643433326, -0.88532753169443, -0.999985743409724, 
-0.966618485728582, -0.895781034068025, -0.999980369279853, -0.865969004444788, 
-0.87450534588926, -0.593346278486981, -0.686688607396495, -0.94726928041754, 
-0.885031189165426, -0.76739955634987, -0.804605061998282, -0.83661438445728, 
-0.908276954291135, -0.94926070288492, -0.984895486083515, -0.921371859999119, 
-0.9999997934725, -0.873656139758005, -0.896662657449014, -0.999999203853696, 
-0.863186279234893, -0.999999615091106, -0.891299307145606, -0.79961075337869, 
-0.798429411893806, -0.999998479199407, -0.843318049531183, -0.749430751544541, 
-0.927864326282597, -0.999999736817806, -0.723236326584275, -0.821237750299817, 
-0.941598201179453, -0.944990346206415, -0.898352513614444, -0.919574499676776, 
-0.981787222076975, -0.81257000195916, -0.943971822441549, -0.905528358762824, 
-0.999999741527767, -0.965114868219464, -0.999999302536655, -0.999999937603388, 
-0.96446623116224, -0.882358612459198, -0.880886506082248, -0.941000618243044, 
-0.908977530783394, -0.845948323061174, -0.89306428591677, -0.763845614498585, 
-0.944777491344071, -0.95742418380636, -0.999999499689886, -0.810117776615615, 
-0.774621170457538, -0.825663402842856, -0.923546677487841, -0.758592201747675, 
-0.999999866065593, -0.99999999359579, -0.855212308172077, -0.931871701274761, 
-0.99999949971909, -0.888812696577754, -0.846463585502596, -0.856875587240572, 
-0.854630612268491, -0.999999833670507, -0.896762201772556, -0.917299388523872, 
-0.962532296521162, -0.824303620904448, -0.896596872410337, -0.754304178966136, 
-0.927445140362947, -0.88365117158058, -0.875349930650401, -0.793350236195992, 
-0.954396716375414, -0.596579192878478, -0.892745229368977, -0.87175955158913, 
-0.968004018831867, -0.82424077253099, -0.8903428411365, -0.999998933470141, 
-0.885301042733755, -0.899219422349592, -0.999998698518502, -0.921003745110079, 
-0.999996155549187, -0.999999500983523, -0.842443407508439, -0.876882525244466, 
-0.878930323591866, -0.819974126102473, -0.872717306236518, -0.937186547823253, 
-0.937359085119024, -0.743388743782706, -0.999999606133428, -0.552277356722356, 
-0.914005525520554, -0.578076499548973, -0.412457361580505, -0.482665895098982, 
-0.558459626853514, -0.502692694260346, -0.650324808240387, -0.772633641264396, 
-0.63799828652736, -0.75429120138563, -0.65626500267619, -0.591754385107051, 
-0.8007471829508, -0.468378472431544, -0.552270031573805, -0.719286336265037, 
-0.278800933676847, -0.531232564446465, -0.468397310417219, -0.55072666914759, 
-0.352579379962904, -0.404554501474317, -0.569832188932167, -0.770956567306994, 
-0.566258618132555, -0.859885866458782, -0.456106788320332, -0.612853942118093, 
-0.636431886344832, -0.564996650225851, -0.706360381597, -0.651981351924811, 
-0.519248911584365, -0.424302300241689, -0.581104938413763, -0.581018605413794, 
-0.532525400568362, -0.595928820632369, -0.48405089059274, -0.572595835082881, 
-0.767348509369121, -0.552808869809797, -0.465629680792324, -0.657777755486437, 
-0.636976872889224, -0.651889806260528, -0.766828338441098, -0.527181839849366, 
-0.719018202212669, -0.530216346401293, -0.859125800071115, -0.70083462286394, 
-0.578523040652302, -0.854650873818443, -0.555228228135645, -0.434080022778556, 
-0.67770048303234, -0.625888053865136, -0.704151849115026, -0.64955719038648, 
-0.404558952827149, -0.476496029219913, -0.56298723094941, -0.946094225742272, 
-0.643057344878172, -0.604411718613211, -0.682064344026386, -0.945283616223093, 
-0.539169730499466, -0.496745201789625, -0.579890770958504, -0.550304940779517, 
-0.610986515583673, -0.466421318106251, -0.607213079510113, -0.547454284058723, 
-0.529564765547647, -0.864804554895428, -0.459164380525181, -0.761857574709932, 
-0.707713762979348, -0.546299274226964, -0.646915318037952, -0.640895280225421, 
-0.448798204144172, -0.463324774846868, -0.616495118281834, -0.778278618309135, 
-0.670198380577526, -0.556152997971303, -0.616596548209251, -0.999999444692646, 
-0.682380762290081, -0.419593976915142, -0.367101225805683, -0.492847423000568, 
-0.519153555196815, -0.617135675648155, -0.500316515999025, -0.424558504580755, 
-0.565911013528765, -0.461872127397631, -0.393177812149354, -0.508577402485202, 
-0.507783949496854, -0.705091812904069, -0.541136134807122, -0.300856718295541, 
-0.579663024092296, -0.722620633685155, -0.69735374388395, -0.714943252800021, 
-0.397828965512653, -0.551263431782816, -0.574873337871216, -0.616634611241692, 
-0.300410905969849, -0.537640710808238, -0.627816773618924, -0.646690966581022, 
-0.649680015494025, -0.848116124814085, -0.646561097440305, -0.586230150601019, 
-0.662680913703083, -0.674517906900198, -0.764832566533997, -0.656446405624759, 
-0.575983667018498, -0.486769099983737, -0.548151779906396, -0.668728889188593, 
-0.481870709187952, -0.630008592159131, -0.540849633384828, -0.621938233602404, 
-0.537938116185734, -0.806410393318732, -0.733431982051781, -0.71324558661658, 
-0.684177590667035, -0.540312858476164, -0.395785159539375, -0.826846795396903, 
-0.333880794259821, -0.381267092241036, -0.806473955758715, -0.782743770507075, 
-0.500853652319431, -0.628587851373582, -0.495397767563628, -0.551861516818422, 
-0.655063208203261, -0.655709629931478, -0.802220919336413, -0.71032490209222, 
-0.46013162388952, -0.516725926428978, -0.638618136183541, -0.407969668224824, 
-0.682652946704066, -0.466333645695889, -0.999999491946312, -0.414558759249081, 
-0.672047041175962, -0.673420129992389, -0.56172117596484, -0.671351103669322, 
-0.61702775552459, -0.460863447086682, -0.425728573376102, -0.549385027522508, 
-0.628095176077946, -0.437389006439246, -0.513956441155505, -0.417169187647298, 
-0.690395867968508, -0.584513296975181, -0.299879262161996, -0.507259840434621, 
-0.481038821291212, -0.808831006787358, -0.60745500102259, -0.692567428829256, 
-0.68933655907678, -0.654599987612625, -0.899699894821854, -0.617802805530984, 
-0.54156842238707, -0.745279050453147, -0.815628241034297, -0.778768231103711, 
-0.492564054873071, -0.57734595838846, -0.67914478873678, -0.455510694126115, 
-0.428019313448628, -0.610431279457805, -0.453663167941333, -0.726245619956621, 
-0.65435181969055, -0.659000305072498, -0.632402783118717, -0.354738134136656, 
-0.55131729268512, -0.696868742885801, -0.51431431672101, -0.734666993884312, 
-0.70610089372095, -0.60618489813684, -0.371928190128177, -0.704065419323506, 
-0.760586680965649, -0.451523051627668, -0.687440404464938, -0.54334199776056, 
-0.471090813725067, -0.642219050906392, -0.665072370761053, -0.866034392280647, 
-0.481137577368207, -0.630104532637481, -0.54654438147922, -0.595095593397227, 
-0.796516077229342, -0.720139082296014, -0.540319233268411, -0.624875395785001, 
-0.954379285269377, -0.830523652729439, -0.728283324686846, -0.584853850118919, 
-0.733906310723323, -0.584748197284626, -0.468917118111838, -0.617538908322447, 
-0.709438972922692, -0.531543365999873, -0.514659463667067, -0.635998721598718, 
-0.596140868712586, -0.83838292602297, -0.366529208129986, -0.625304415936643, 
-0.60964647144407, -0.484836520147153, -0.821133441607244, -0.626954118332802, 
-0.406565537875526, -0.683179466823238, -0.587494670296815, -0.758499703830017, 
-0.681927831579857, -0.545750192302669, -0.647722975820764, -0.669326956482633, 
-0.999999792972263, -0.666077374120747, -0.516909972335645, -0.733141712510469, 
-0.594355953036597, -0.519292902972229, -0.446471049140376, -0.571843883868433, 
-0.622780701239354, -0.62857403638285, -0.542642608788381, -0.644627734363264, 
-0.32245216174825, -0.668713392770992, -0.63753245930976, -0.652014259514302, 
-0.576914838563235, -0.278345647836356, -0.81172519662109, -0.78486485945351, 
-0.676309270964436, -0.527628718111655, -0.77387712671775, -0.473557219884279, 
-0.613177946417259, -0.480544088406817, -0.531719772747532, -0.676994606435033, 
-0.691726573011228, -0.624789804400898, -0.488682316036376, -0.523112301070897, 
-0.668203966217813, -0.46705416099282, -0.692855707935086, -0.629017889592393, 
-0.445933653820338, -0.569824532459027, -0.622416778873125, -0.840945621614453, 
-0.90569698584498, -0.632300477392753, -0.93619124339187, -0.534618712411519, 
-0.692307733988791, -0.565661093637516, -0.695143880062642, -0.515282103726056, 
-0.588028791164475, -0.709976716055139, -0.806052052851056, -0.55971354234972, 
-0.901035890904995, -0.579874166815634, -0.604757151440397, -0.498112907275285, 
-0.553591626780301, -0.68837790330694, -0.468790046492071, -0.507462206780934, 
-0.669573475199232, -0.83253876418535, -0.64016852822249, -0.550997515352189, 
-0.678472031658476, -0.424039328120628, -0.480690960397249, -0.752186118030003, 
-0.720254976136555, -0.642922947792486, -0.822270745316656, -0.478181760479071, 
-0.336689694180620, -0.408871590673532, -0.667777144298548, -0.693502789708106, 
-0.590514755854472, -0.648322732890538, -0.612233706725190, -0.650466515029528, 
-0.638835328039134, -0.186472162811125, -0.353520194881728, -0.526944014601348, 
-0.467204716279361, -0.606642957969772, -0.790158544767558, -0.663279785487423, 
-0.550371236368513, -0.302444833476159, -0.438385000312832, -0.71754637862106, 
-0.318936220626235, -0.50161716479926, -0.536223124905028, -0.653161165883609, 
-0.664433009709707, -0.586870926490594, -0.459725492019649, -0.547197462530742, 
-0.744875360729494, -0.999998148506871, -0.598388379525947, -0.68056925716829, 
-0.451998429317450, -0.566648053539321, -0.837649349902701, -0.742237320723136, 
-0.597714959176366, -0.462579108350828, -0.623018522326171, -0.676594657829275, 
-0.68016087754187, -0.447154836366804, -0.599296890120218, -0.70740879037481, 
-0.518940833376167, -0.590938113531353, -0.61558952127518, -0.783043593948814, 
-0.590085104891365, -0.518918564141859, -0.551510405979224, -0.751503182536209, 
-0.8372597120027, -0.616527794027941, -0.66410087800938, -0.639556226399798, 
-0.52631015565792, -0.652571200749536, -0.663313259124536, -0.592640259150924, 
-0.752575771635665, -0.633651971694748, -0.424717129055906, -0.628814410104065, 
-0.688433576116181, -0.60736881814659, -0.645347537331521, -0.567662648340922, 
-0.6500924395134, -0.557423671527177, -0.799144105122552, -0.572654150800237, 
-0.74028961611692, -0.910628324363824, -0.423100909399448, -0.779401485409216, 
-0.698398918418737, -0.498985490462826, -0.564515131166781, -0.565051758027825, 
-0.764461491205824, -0.717727113371909, -0.502328064119617, -0.84429549895884, 
-0.622947458441421, -0.615752523064936, -0.586055971919418, -0.687383372124312, 
-0.653954697628851, -0.513564539666899, -0.639694747002424, -0.566038369844906, 
-0.450093450974822, -0.66054439635971, -0.613064323888739, -0.736968783399544, 
-0.673133845959686, -0.825226325303096, -0.563041279687628, -0.570413123530877, 
-0.66445202276115, -0.999999998208767, -0.505325789749534, -0.57565186165705, 
-0.614303558198876, -0.557131168949314, -0.472072302271302, -0.665397469998832, 
-0.562845055408342, -0.526461906332607, -0.647475949016789, -0.469885536756332, 
-0.579732002907256, -0.477985124418784, -0.186541762930762, -0.381905511531627, 
-0.430914345674564, -0.499350450726393, -0.60980860771822, -0.590502196940829, 
-0.826976034354137, -0.589730208114276, -0.71767505869604, -0.599285005921904, 
-0.675372115993216, -0.729691768740688, -0.669574378129456, -0.841356032672929, 
-0.40882363283547, -0.552736094186026, -0.480810596321862, -0.803742682711813, 
-0.605909496020145, -0.755065243886959, -0.414219442383301, -0.722511226746258, 
-0.559579079262942, -0.953337456948697, -0.444910042463792, -0.527908700245023, 
-0.424523647232851, -0.569898562100456, -0.628597719712008, -0.5639007224794, 
-0.763123608886, -0.450397182173919, -0.768162011102458, -0.571459979673373, 
-0.433938005947875, -0.589171097133986, -0.707596294207455, -0.804044687787586, 
-0.552511617667949, -0.65198656125718, -0.572470340303224, -0.59290986358307, 
-0.572638375304956, -0.676435513141294, -0.726851863054917, -0.657161368321804, 
-0.622195529312733, -0.686134949878006, -0.488815149967647, -0.682219853968465, 
-0.435157237037872, -0.642187262148746, -0.357347229765421, -0.7689970089522, 
-0.608449233723761, -0.642973532220948, -0.672692408790324, -0.690123897783749, 
-0.441324609030079, -0.519466242740509, -0.432721877266078, -0.959814802443566, 
-0.554893651439508, -0.620433903726287, -0.479788446675777, -0.820822636241008, 
-0.641514480222888, -0.447075295896751, -0.541791197648601, -0.5867284050167, 
-0.574665548669879, -0.521658366201528, -0.727482193010856, -0.657060205540163, 
-0.47954521060445, -0.769467976497498, -0.608638813578997, -0.520052611990822, 
-0.622229545954486, -0.904910536006464, -0.486155404100453, -0.351607096684137, 
-0.514276793546558, -0.333568773441808, -0.407493319826102, -0.655100533790004, 
-0.569860290198297, -0.499856881717562, -0.590193247304774, -0.873724919932381, 
-0.654309365870782, -0.436336186599974, -0.518523434361326, -0.601052668756094, 
-0.5563317064882, -0.544257147416545, -0.489841589196865, -0.612584147379006, 
-0.76154953260289, -0.999999656944208, -0.57999303570473, -0.430457851035712, 
-0.897369573437925, -0.664710591573753, -0.533586698883567, -0.660458159087544, 
-0.56436243088246, -0.471941064888239, -0.624164781794688, -0.595436969699346, 
-0.499218763617363, -0.779813140627455, -0.611290686108345, -0.442368363329734, 
-0.712637891850206, -0.633027935529654, -0.521996314223356, -0.41444282078817, 
-0.735465069537833, -0.688303258111063, -0.43212925827763, -0.540828850284539, 
-0.490162278803656, -0.485390062499186, -0.568616303077526, -0.55653418772465, 
-0.57857250770814, -0.575481331275699, -0.585613936228369, -0.646154495778785, 
-0.344679202199090, -0.703563492713032, -0.524857367691963, -0.677460424917595, 
-0.676014837629492, -0.539724736082002, -0.558526641604083, -0.584861524777589, 
-0.58696794893931, -0.520472703180682, -0.650539580141031, -0.400831929721368, 
-0.437927652123231, -0.663267316705721, -0.601694044043885, -0.739962716099957, 
-0.589368331419849, -0.672111467951193, -0.479331745468909, -0.866038294302502, 
-0.86371443280975, -0.786787687033893, -0.582687193816607, -0.73187340654864, 
-0.56418571165575, -0.617107899634489, -0.556373068439452, -0.372418103902683, 
-0.708330095823964, -0.579409096272125, -0.709089440087606, -0.493646239329087, 
-0.651469833287, -0.999999467301149, -0.600620593066742, -0.999999339034218, 
-0.816547897869843, -0.593155360549898, -0.574698421311348, -0.670779770701225, 
-0.604284237833296, -0.563255613015764, -0.637088897480605, -0.713245368309584, 
-0.804447903603683, -0.632929825824065, -0.528381104578628, -0.641945989944796, 
-0.531527775324639, -0.379167417444124, -0.590311173218567, -0.640186909154938, 
-0.459173872522053, -0.579767257955011, -0.762614985381896, -0.7279981855647, 
-0.438754107460924, -0.553189633596902, -0.506966175574761, -0.877946738618254, 
-0.481481541663569, -0.466683213130859, -0.435270596669174, -0.603696540053424, 
-0.62546906635899, -0.627303749274785, -0.814306500025774, -0.768346284080383, 
-0.715965994521572, -0.660952158387841, -0.545650659791612, -0.491988774760753, 
-0.407514743645012, -0.599488756556, -0.55247324776673, -0.565264977002909, 
-0.722125293059662, -0.520160553114128, -0.640325499171951, -0.54603245963933, 
-0.622147323164082, -0.684139318960585, -0.746415374159753, -0.381576486585873, 
-0.731425540453817, -0.625249495178802, -0.668349594173821, -0.664047631689865, 
-0.743150505949616, -0.598480239554834, -0.362068484995483, -0.431828810373771, 
-0.802918576428483, -0.789104873406463, -0.561041103370937, -0.540091049175388, 
-0.564984668912586, -0.618780524116888, -0.791913729999267, -0.700712655636548, 
-0.645851185589335, -0.537920599982462, -0.592637796999657, -0.471883285038005, 
-0.999998290636435, -0.517224842848856, -0.422817870804038, -0.649053915535686, 
-0.572816026699603, -0.74058188654615, -0.680107151457387, -0.609249378965782, 
-0.740944627032736, -0.705866555385905, -0.717331875072926, -0.641960067263314, 
-0.788117711762786, -0.587027920551786, -0.612486602151547, -0.373265141620766, 
-0.648698247660035, -0.529184013195371, -0.641731726622336, -0.593944609327409, 
-0.619971203520856, -0.61087579768498, -0.726947652004865, -0.583505901095564, 
-0.604854811994563, -0.538785311149331, -0.657230971016285, -0.497433719294317, 
-0.753508089268735, -0.81679565217428, -0.609869070101838, -0.442310831105695, 
-0.58683262457286, -0.435699671960317, -0.733930005089326, -0.628744144599675, 
-0.736120099771362, -0.630822884764592, -0.716861797407981, -0.654009446161298, 
-0.570724480876754, -0.709485931820982, -0.739263949753048, -0.315202456630271, 
-0.565192452141245, -0.590556058849009, -0.672495955343972, -0.696184899190392, 
-0.593137870530464, -0.780226828219601, -0.791648712079878, -0.435858735580061, 
-0.999997866920055, -0.75292490581796, -0.584447745876021, -0.486309990883575, 
-0.999999461620362, -0.61006354271512, -0.774724724904023, -0.708700732832146, 
-0.541576653124098, -0.602284779763567, -0.550242307078711, -0.473568486213037, 
-0.58953784082622, -0.74107467945916, -0.568776253205732, -0.592739700543089, 
-0.830302524837966, -0.759070823106365, -0.705490787907147, -0.906892226830758, 
-0.658941209797938, -0.632344041470992, -0.935455160371673, -0.710448596821346, 
-0.468836892155551, -0.59098504867245, -0.703840141416124, -0.470448237528859, 
-0.481586683615969, -0.690219714257888, -0.667225214507088, -0.765285978084501, 
-0.709380732896942, -0.384500969775959, -0.707300289921661, -0.645122222157967, 
-0.651199049748859, -0.568394885342199, -0.836303466022897, -0.622025423404365, 
-0.574606818961834, -0.533462038948169, -0.717722757154471, -0.546201622735523, 
-0.641517865878346, -0.599394581739238, -0.488023645212516, -0.592742973683465, 
-0.487753067991025, -0.648694156088154, -0.281229348990588, -0.647586116288972, 
-0.682086782873916, -0.653600694999438, -0.487689800808695, -0.552814054733721, 
-0.480720220360989, -0.352557709595124, -0.471926515932533, -0.56981504973573, 
-0.757753423846604, -0.339397969660651, -0.648134975893254, -0.706590210689328, 
-0.491367952796633, -0.495589630274788, -0.691096416278489, -0.501479479776797, 
-0.999999529832455, -0.82221490768569, -0.631705914398902, -0.558928357990911, 
-0.543255750254012, -0.478965354778658, -0.57685903223354, -0.672849601840016, 
-0.818174854169892, -0.835342020506827, -0.782369552808203, -0.396880392807684, 
-0.479662303600291, -0.747633990292067, -0.560525681897976, -0.61886094253307, 
-0.753766121361797, -0.759406326492953, -0.721925622517793, -0.658101578271359, 
-0.554377374487016, -0.588828911446514, -0.602336051744695, -0.762023675677562, 
-0.573201942128614, -0.821441037272222, -0.503706469094488, -0.711964210356326, 
-0.558931404872038, -0.738156041660265, -0.722468452590336, -0.694972251055718, 
-0.913741555547115, -0.951079938407727, -0.653040179007516, -0.435156165140167, 
-0.660143742698043, -0.504531594707186, -0.530481753939251, -0.546231162352676, 
-0.495629900618241, -0.511535429081323, -0.586263461937425, -0.773354534826133, 
-0.555762164967443, -0.664078440459521, -0.546827309796939, -0.385937636221930, 
-0.541831870722629, -0.65853787705053, -0.657045314323545, -0.313306586286562, 
-0.72358073217814, -0.358499225359422, -0.451722728136694, -0.595521368419865, 
-0.631639135392399, -0.550360715252757, -0.691288725117702, -0.638177726667648, 
-0.517706387141503, -0.709856322694451, -0.59528970920365, -0.834299456515573, 
-0.397613709730633, -0.712317034275063, -0.755949633285998, -0.547998460002041, 
-0.65461449893714, -0.672644938499669, -0.693075611255478, -0.620303605933445, 
-0.572962580936961, -0.550584399228198, -0.652605820467335, -0.963666026137944, 
-0.556565024784545, -0.727887374801828, -0.518569325251002, -0.546775690291519, 
-0.66486800872007, -0.685089219407367, -0.532986581132079, -0.508642346894060, 
-0.612782041997288, -0.772608368113693, -0.697865222143752, -0.555856229968922, 
-0.698489195340599, -0.667932963820783, -0.599857640195779, -0.796529066308809, 
-0.881675151619311, -0.671503590226689, -0.559163563394048, -0.667344610802104, 
-0.654070283526222, -0.7054244142867, -0.461491689481932, -0.48428311645877, 
-0.624775832688458, -0.687746365647772, -0.704210648057343, -0.74643200370035, 
-0.655039308356668, -0.684414793420545, -0.731783886148853, -0.654236567517045, 
-0.89630576441123, -0.545104827958366, -0.761418435131992, -0.554051680500338, 
-0.350375189188928, -0.376324350759068, -0.655374445536509, -0.267601188399468, 
-0.732937699801448, -0.531619974893091, -0.61409909191408, -0.599236328335374, 
-0.718552267375906, -0.773231451854164, -0.630566773553532, -0.480754206246553, 
-0.658316015356984, -0.634691451454037, -0.379815558284482, -0.814439810646998, 
-0.216958883026767, -0.588654411950458, -0.669957707246841, -0.62146634950792, 
-0.468339070868707, -0.560993106512571, -0.777856547979694, -0.513355428703678, 
-0.525147659548183, -0.623482719250436, -0.587243651028281, -0.354136683325739, 
-0.72791337235066, -0.352368702434929, -0.563760068439391, -0.372410463803745, 
-0.999999999995897, -0.891678159192508, -0.549906489878004, -0.627726194250117, 
-0.524671080652055, -0.404053290624486, -0.67856536772826, -0.457883559905775, 
-0.722402447817825, -0.691142117883883, -0.591262244900242, -0.766073514876958, 
-0.368203102786389, -0.693560174121465, -0.746421014049256, -0.582849713669188, 
-0.9999994733878, -0.655393524303663, -0.583136463546593, -0.944309064059181, 
-0.86228114371098, -0.59070447986798, -0.621368457963858, -0.689865434758139, 
-0.441941737285566, -0.562976536560675, -0.527520005993678, -0.553595386613239, 
-0.479247337195814, -0.736675459231402, -0.69375950734526, -0.664658019030828, 
-0.62464177628723, -0.519216359221138, -0.638957849863227, -0.230230765239971, 
-0.602762171091311, -0.712097981942359, -0.66241934038817, -0.703383591094488, 
-0.813168692410693, -0.47693830900345, -0.443585826566336, -0.594510685372213, 
-0.558636493077076, -0.698359897477287, -0.716930073462299, -0.638124868291279, 
-0.913006303810291, -0.559064931767984, -0.47392783063095, -0.662964740255458, 
-0.963989071417123, -0.999999600089324, -0.57360349579734, -0.733965960540031, 
-0.587716204525692, -0.315214865250552, -0.241512422619212, 0.0344122439311478, 
-0.469040063427449, -0.275390076472249, -0.488321763202237, -0.239595037980824, 
-0.279616400888898, -0.335172534065674, -0.553515060717333, -0.419819944030727, 
-0.394581793215941, -0.297454168182774, -0.253883225377137, -0.448372154811275, 
-0.407560860171668, -0.288311595140608, -0.248226626901947, -0.152682415009872, 
-0.105621343465521, -0.282255701793753, -0.493121825163903, 0.144881617481831, 
-0.614384788342834, -0.246973241302771, -0.0751760076377658, 
-0.160648343242991, -0.369369516741228, -0.116028583261685, -0.167492506361115, 
-0.285824458599562, -0.208397612974621, -0.276921296722026, -0.103115841160655, 
-0.343443558157171, -0.391044378252901, -0.000834882383126893, 
-0.334558739465769, -0.267150462968315, -0.346363346432152, -0.108269164902480, 
-0.556083913453074, -0.109178348813438, -0.33162016111864, -0.284118997084614, 
-0.264814446077784, -0.366568033298187, -0.445428954767206, -0.330282302627806, 
-0.203648125340702, -0.275230960245475, -0.281363192578811, -0.329231280580603, 
-0.287710726683978, -0.377808311391507, -0.173025989546948, -0.265017391332919, 
-0.238837913653499, -0.350781241711966, -0.177300838385912, -0.529315820786841, 
-0.117657592596442, 0.0384977083768324, -0.497055053660252, -0.393757886573212, 
-0.341317776242129, -0.3365185091863, -0.255120309230833, -0.286869235040559, 
-0.428421101454772, -0.231796860276839, -0.245190522620517, -0.162032420662758, 
-0.177568350196791, -0.67140709690953, -0.42553482113461, -0.319784810254351, 
-0.437036971957241, -0.305522711825741, -0.349801156839221, -0.280587825598342, 
-0.372165815798708, -0.281344468328279, -0.285979865951135, -0.371586746230859, 
-0.502516893514524, -0.6131582296621, -0.0240826043694271, -0.289197893708954, 
-0.220108102149593, -0.379991487224649, -0.321502018409695, -0.272560500207129, 
-0.275228742360780, -0.331472844580313, -0.0566666158375806, 
-0.133165542854370, -0.290717665868419, -0.0599034092096078, 
-0.245800147718843, -0.107981841274640, -0.566453804847885, -0.581846300193977, 
-0.220669295726662, -0.384871058220888, -0.339836356485718, -0.262648768147816, 
-0.314060720416157, -0.284939127176525, -0.558374412312825, -0.205256958310948, 
-0.27425038117694, -0.439049018088304, -0.354008525844569, -0.278724602932551, 
-0.226836188228549, -0.192656242820333, -0.154568830880900, -0.0562186052470474, 
-0.393705645427574, -0.359235629749361, 0.0622801691638393, -0.270478250070988, 
-0.0567348944284808, -0.483950388155393, -0.272524993735851, 
-0.44078491402461, -0.310278827064943, -0.183564786687017, -0.137655216117279, 
-0.366512421846465, -0.412563642392595, -0.373678736392455, -0.681552728331757, 
-0.585025150361794, -0.479171119422854, -0.534012920340334, -0.389074481792236, 
-0.406905389479701, -0.370390834428265, -0.063568723466692, -0.260944962137874, 
-0.132047144343359, -0.202840058632761, -0.404716645074096, -0.274451136390888, 
-0.258870068290193, -0.515934324471417, -0.456672866503595, -0.401522886706548, 
-0.280707958550079, -0.100583990678021, -0.483804901563724, -0.283578847938029, 
-0.626360664728757, -0.159509625078221, -0.322344695838747, -0.376525708340756, 
0.102219245321666, -0.339509905480789, -0.230440278887786, -0.219878740696499, 
-0.283331188114435, -0.129896244654240, -0.468205485973384, -0.382649263411763, 
-0.490752997301693, -0.580197239122219, -0.222897357146859, -0.316323754069695, 
-0.330486408371878, -0.297243921036265, -0.350152055068599, -0.490634478660041, 
-0.395727828984049, -0.34366218821911, -0.182791855948029, -0.565579708583057, 
-0.672038329943928, -0.212584511397596, -0.223638457552697, -0.480727514621472, 
-0.5112637438801, -0.381985922140748, -0.125540528099331, -0.359682658510116, 
-0.137578657645313, -0.340337497968215, -0.266812681251168, -0.392578255353919, 
-0.127714238586828, -0.434232146484309, -0.459199764068769, -0.457942271284224, 
-0.207374561026953, -0.153609975197840, -0.325193168913204, -0.245977146233480, 
-0.261883259643342, -0.352039634279949, -0.585950763024662, -0.435114755051239, 
-0.183999213357371, -0.248184979382623, -0.463403121713857, -0.704931534069679, 
-0.505184756786667, -0.368530201022735, -0.263955170261937, -0.230949992439262, 
-0.323658508577804, -0.331494582807036, -0.143162620872942, -0.137848851774369, 
0.123937503372923, -0.370323184322106, -0.0323135682991811, -0.413177649073132, 
-0.435250166103942, -0.434394642996539, -0.276397572563611, -0.0143271258602821, 
-0.340884006466091, -0.339701044206922, -0.253290262064155, -0.0578937130794141, 
-0.57601338356319, -0.340043773139459, -0.0324856488879198, -0.0490369827132434, 
-0.258946854464623, -0.289638910822409, -0.109240493556576, -0.311910529786735, 
-0.0698182712350532, -0.0256387762833846, -0.296346047905907, 
-0.462547796818791, -0.435442125003870, -0.248483595880645, -0.220120867643499, 
-0.402767188841223, -0.496995373693217, -0.346020704746851, -0.222447821146246, 
-0.508854403295943, 0.0872208828973952, -0.146679569684939, -0.342581098772355, 
-0.294095735639942, -0.346903164022768, -0.238594707690666, -0.304887174648844, 
-0.284754533533502, -0.120503235189082, -0.236097575943149, -0.186520151617002, 
-0.511061265760857, -0.386743335457136, -0.330124340917543, -0.487381311368552, 
0.020447907912004, -0.285540826692304, -0.333002129376751, -0.500028588678528, 
-0.091816912782335, -0.111116490377706, -0.055373660587342, -0.50581738531223, 
-0.0484563215580772, -0.00876074759502197, -0.134463005898096, 
-0.228786165269994, -0.509371675909917, -0.146516368849815, -0.279201078233520, 
-0.538396919323644, -0.247997472250599, -0.62725786044043, -0.290349128558822, 
-0.0404909983450392, -0.0189185286876247, -0.130823133853531, 
-0.76446893521292, -0.135181600095215, -0.2873658926052, -0.172184426859143, 
-0.211233369462226, -0.752285992364, -0.256234054422362, -0.448010120177332, 
-0.0857718258246713, -0.300974276842914, -0.189296082723453, 
-0.498807203847484, -0.142760678706557, -0.141125756780119, -0.423447294548082, 
-0.338488720802175, -0.285984853521792, -0.295561933901286, -0.309734181157621, 
-0.43342984138194, 0.0877906060088604, -0.0616201430881233, -0.514532530344962, 
-0.310434734940075, -0.198754178850359, -0.0524803408311579, 
-0.301754275982573, -0.434320764516474, -0.131225182998366, -0.22406769813029, 
-0.321899448111787, -0.43467661026919, -0.407456840729281, -0.339980581256988, 
0.0614333064844128, -0.223028539717671, -0.424076623524303, -0.21493642401085, 
-0.436036664573884, -0.206187079552948, -0.136620413975870, -0.278862972036386, 
-0.417786884162843, -0.278090371866711, -0.396002803925693, -0.265970690338544, 
-0.198654506412346, -0.192271777200181, -0.736598156967415, -0.244153524926371, 
-0.240954514160229, -0.385815340939632, -0.238718733247931, -0.197222409849079, 
-0.153852604548406, -0.00788526081487268, -0.265488073083297, 
-0.352349568831164, -0.131761943992435, -0.373724168023128, -0.431029539951185, 
-0.317033476332975, -0.479706411085096, -0.144872273719440, -0.340239332567079, 
0.0312721855055606, -0.229052707986733, -0.233063163215997, -0.377762615439429, 
-0.133709977375836, -0.645624429710289, -0.370390003022469, -0.206842871210307, 
-0.380142461107841, -0.189396576143469, -0.169743686789902, -0.156332295068276, 
-0.322212128111468, -0.184277329630854, -0.229628709116561, -0.51707233247017, 
-0.0981500112584736, -0.314158526989704, -0.219592536910053, 
-0.385282752682254, -0.140865507791339, -0.138842276710374, -0.0753595310599126, 
-0.249158253953350, -0.408354340775179, -0.4652982384635, -0.0421628058933146, 
-0.330355838690056, -0.396512127191466, -0.0746492043039361, 
-0.0980346837025687, -0.365944055773288, -0.180824690055584, 
-0.175660552247459, -0.377061192576287, -0.325123010042563, -0.547842110140578, 
-0.467221331873836, -0.335245826264471, -0.361604394944412, -0.488399573083713, 
-0.447636317376387, -0.163888585430423, -0.115342902278539, -0.150881895389954, 
-0.188860507754212, -0.429128824808245, -0.459527481102004, -0.0915878817979123, 
0.30064040636995, -0.499057372937342, -0.171331002346408, -0.364584479374624, 
0.0137332274722436, -0.277722707911626, -0.106145989197793, -0.0169746457090196, 
-0.217342425425084, -0.403477270190022, -0.430316949393481, -0.119634023005584, 
-0.306839882747214, -0.619536050482896, -0.200692617762456, -0.377026126449326, 
-0.200375140043533, -0.172435795417165, -0.591049090730366, -0.445605941850639, 
-0.423823560388419, -0.252712528878587, -0.382356563527044, -0.328511502125592, 
-0.240023910332954, -0.0389344867249955, -0.274885360573469, 
-0.161985167275541, -0.210357241687808, -0.277561114130878, -0.476414398915461, 
0.115421250393410, -0.342692995219159, -0.363042361438222, -0.304884255662011, 
-0.49900955210359, -0.216493463436334, -0.434913534851544, -0.311079262980538, 
-0.311212903166554, -0.19523010314244, -0.202128698839063, -0.132221103758664, 
-0.427492613002116, -0.164266527691458, -0.245897132029209, -0.219213972076405, 
-0.387859460801421, -0.26094122284424, -0.232811224337277, -0.0626662610252774, 
-0.222848814739679, -0.353458949287808, -0.192918948825337, -0.201176507984057, 
-0.261185271739596, -0.261743669491094, -0.225729349055232, -0.196717507838744, 
-0.29864127573217, -0.502801327472641, -0.27896151711804, -0.307654480884917, 
-0.130153027489293, -0.206230516989368, -0.397953229643573, -0.549078001635833, 
-0.304322721253732, -0.150435572851337, -0.473694796313163, -0.00326313587555035, 
-0.336568482281463, -0.267338976592032, -0.216617770708833, -0.29566651864361, 
-0.572972295574268, -0.247259117533622, -0.538815147385138, -0.42421449416703, 
-0.407559117100946, -0.60335687228275, -0.204462368697387, -0.478928650244042, 
-0.319765593536545, -0.148839702235746, -0.177112264572426, -0.227898998082707, 
-0.423909196192294, -0.601793490210988, -0.158809087602854, -0.397023233154732, 
-0.0101444112809366, -0.270397516591511, -0.425686482343057, 
-0.161794134451269, 0.181478850967533, -0.415877957508109, -0.240059079635261, 
-0.134683855214212, -0.164338724224977, -0.252228676255305, 0.014742225508261, 
-0.281313780304266, -0.219983525672175, -0.0932214747917003, 
-0.408012561149841, -0.47107783845288, -0.255104535281133, -0.293155588929797, 
-0.418584333311283, -0.261625334967625, -0.40019391934401, -0.343832731643463, 
0.0344167260380310, -0.245896267774196, -0.0987603920530153, 
-0.150011386643749, -0.291028223346442, -0.380976524580182, -0.396208647308371, 
-0.350647028560643, -0.170720188035622, 0.0949910997664884, -0.293350522081477, 
-0.227329367602169, -0.189711995321901, -0.358627547590183, -0.280898452060092, 
-0.483836396999156, -0.286716963372784, -0.290586577679159, -0.293717465863958, 
-0.180759348807675, -0.232951571892574, -0.00155380721585917, 
-0.129632634153154, -0.252802749688044, -0.159944611521584, 0.224583183830233, 
-0.33891887188784, -0.424885686776915, -0.199394585203381, -0.232597968656629, 
-0.334498792931331, -0.457932919628086, -0.112622167272514, -0.527544587379283, 
-0.339714024786929, -0.273181988313094, -0.186548418941382, -0.527985874214156, 
-0.50850633272319, -0.475552822413334, -0.405260232341735, -0.246777048836884, 
-0.00554855496773448, -0.452438456004279, -0.099521950309161, 
-0.756802760448793, -0.160406143449751, -0.176224075866747, -0.430369321610557, 
-0.30185032701717, -0.458360175362711, -0.119003227845294, -0.331929479288362, 
-0.0291812331682280, -0.222953336043172, -0.412778367098265, 
-0.530339467375842, -0.347590626265496, -0.238906737092606, -0.277778667770835, 
-0.174950306625642, -0.130250586427893, -0.163710723777377, -0.0391353312794989, 
-0.524396923592426, -0.384818556579231, -0.406561988350614, -0.207743990057955, 
-0.344716055986027, -0.605724511146444, -0.298013543324474, -0.173344997329221, 
-0.533200194693508, -0.271869956260913, -0.273002371940463, -0.253270930484150, 
-0.0549259095933945, -0.261449917565237, -0.294369471758431, 
-0.299255352751500, -0.254146650658084, -0.144472058061110, -0.305140622656189, 
-0.382827658329649, -0.203654646837973, -0.082709437307839, -0.271043609908221, 
-0.410185860821456, -0.373019776832908, -0.262700376648504, -0.277143856034719, 
-0.778729739027254, -0.277732559697971, -0.256951690547803, -0.316528997787592, 
-0.293424286986065, -0.279509073673635, -0.278890949905906, -0.154456509686185, 
-0.317481589507803, -0.525883706378156, -0.339343078809872, -0.246144559729692, 
-0.255205700309712, -0.163452956870072, -0.300753272685609, -0.324449041248652, 
-0.23994587891168, -0.139621948277723, -0.0244819137693425, -0.127741931389883, 
-0.368274193245950, -0.134700598036406, -0.322356458350014, -0.154464416594432, 
-0.357285660568953, -0.255597933289387, 0.154509887244931, -0.0405723241616683, 
-0.342549909857177, -0.305198310411026, 0.205245631499026, -0.296912807056603, 
-0.347473634977968, -0.490503023575181, -0.555968227448880, -0.547560740604836, 
-0.209602545035831, -0.203174458661338, -0.149891363966174, -0.307866776659532, 
-0.38419772588657, -0.221916601401916, -0.37285504606419, -0.321253370725219, 
-0.375652643345323, -0.184128404485484, -0.260678474631333, -0.603926305806207, 
-0.759884055440427, -0.0186739447392030, -0.0221378389514625, 
-0.494793039205973, -0.166690631191871, 0.0240530760190612, -0.198123877018256, 
-0.151356450883901, -0.194753065012045, -0.0447428517307056, 
-0.365749898825453, -0.359868595514344, -0.83075447706672, -0.408416116448364, 
-0.333633254892719, -0.301504696242251, -0.170519466228144, -0.259967876375249, 
-0.372251812473085, -0.563344338929478, -0.403047728566724, -0.288145291659317, 
-0.206201115704925, -0.174270445107155, -0.158981965684181, -0.296290578353962, 
-0.083823285837669, -0.368651494190017, -0.358516482423427, -0.0406324120406307, 
-0.149609575845685, -0.160625548149793, -0.228308545290412, -0.268003543843825, 
-0.490360206655794, -0.571853160697879, -0.586029850178058, -0.381110721660639, 
-0.385841899748092, -0.402637501708915, -0.432741495799544, -0.0843856187361106, 
-0.106978807824446, -0.304015612168614, -0.589474181828989, 0.041367211931104, 
-0.369750836845956, -0.286462106486816, -0.307995800954609, -0.293762833898557, 
-0.190840292044129, -0.235706086322027, -0.473841288707404, -0.639822779924038, 
-0.258299058842593, -0.257468946042206, -0.174792810762360, -0.193384712838935, 
-0.0817008076009316, -0.338617089240336, -0.363933237806635, 
-0.1646847736492, -0.265370243965889, -0.652803703138919, -0.317340453212523, 
-0.496644072349095, -0.324548210997432, -0.399416476373008, -0.0433931311309715, 
-0.374247980201594, -0.250453288553945, -0.0812542996280866, 
-0.0494545372858835, -0.421780643582255, -0.0423374851914124, 
-0.409948527624257, -0.249932796452366, -0.250888829435763, -0.166907174564941, 
-0.294553255128772, -0.0960617143014628, -0.265349336736512, 
-0.558012726966566, -0.24853138919314, -0.0955368138607327, -0.0503487967117225, 
-0.279724426504224, -0.165241127206032, -0.755523783144254, -0.528385176858696, 
0.028927890538976, -0.313267159962592, -0.178411684005582, -0.191480086201348, 
-0.270403232392196, -0.469820169394861, -0.169653518784461, -0.489171671900818, 
-0.214416211908688, -0.0305825358985707, 0.101329470161444, -0.157407511883809, 
-0.189872295879730, -0.497458288240336, -0.184307684203720, -0.358660164608424, 
-0.251856301509520, -0.272664121546612, -0.324437901837638, -0.253069236650409, 
-0.278932943167462, -0.462720635795424, -0.623314740634648, -0.37719719576701, 
-0.227709642156981, -0.432459047983480, -0.254773810353068, 0.0702037770905051, 
-0.371379296401824, -0.376843053176924, -0.352938930663697, -0.397528466940677, 
-0.285298773705202, -0.334349371819874, -0.215855792522340, -0.299857194194895, 
-0.267784175143164, -0.150588356548142, -0.291539739330352, -0.280391726934883, 
-0.239487128993061, -0.283598466366591, -0.211922094375964, -0.312255864597104, 
-0.21842596236349, -0.30256753498221, -0.185873224836598, -0.236992750007239, 
-0.350012568099999, -0.161662559580848, 0.00480015609816596, 
-0.491364588822447, -0.582685223844227, -0.331059739417654, -0.466544933039419, 
-0.24074439931663, -0.120744249602382, -0.595033549688658, -0.398532435084002, 
-0.26039239517501, -0.180821514674624, -0.176781205933332, -0.357374117297522, 
-0.278228804636374, -0.0115590871013838, -0.374980571286278, 
-0.289211396430334, -0.340809214383881, -0.120078188734133, -0.340718618551976, 
-0.168093103679286, -0.152422919960213, -0.276288612546879, -0.325014289489152, 
-0.201925275838252, -0.114944173025167, -0.321778271356664, -0.184673571979717, 
-0.411582701173414, -0.171620543619065, -0.275752759132303, -0.297773170868949, 
-0.270346222674626, -0.353801553814881, -0.227906380454192, -0.307123773164032, 
-0.425888693947938, -0.707980229477223, -0.379409406657356, -0.0337336728517036, 
-0.149707857399514, -0.132245436816832, -0.108088463339853, -0.294398076273792, 
-0.076208028938314, -0.460487382344266, -0.209391863901581, -0.352754909695739, 
-0.293282538928013, -0.183989754689113, -0.346296401295739, -0.350253288789953, 
-0.117765075173081, -0.235818381767724, -0.352652020961508, -0.443080939428683, 
-0.898830732604278, -0.390285716052873, -0.611872888443333, -0.435276112878945, 
-0.193992053066828, -0.269322936757488, -0.305760045937783, -0.230290459039724, 
-0.451675073321111, -0.23437229408339, 0.0474428107317752, -0.23710093442971, 
-0.472449095079547, -0.260366427661561, -0.409616099722001, -0.48752425129657, 
-0.259954372907444, -0.100319852886955, -0.0887576244757334, 
-0.436429534606873, -0.95021300674654, -0.449830418845238, -0.464958942705929, 
-0.292656415131534, -0.164620963270555, -0.253160065831290, -0.215445905075913, 
0.0195006647266890, -0.430594522045293, -0.0987745148380464, 
-0.269496653753212, -0.32937906824635, -0.347422527355651, -0.208038896531798, 
-0.313303305679825, -0.483826919128392, -0.173721312513036, -0.317377845092172, 
-0.566976791729641, -0.493477923887242, 0.109743988182821, -0.431766063971045, 
-0.370581296358210, -0.265887440703289, -0.291096588435460, -0.478321528399575, 
-0.240475587950755, -0.282068895574780, -0.328902661428684, -0.159510026619892, 
-0.352022984832049, -0.332806959818588, -0.224260806323998, -0.216965630609856, 
0.0621307982724706, -0.242606767763022, -0.313720178202285, -0.520520403931175, 
-0.438799402926643, -0.373101442947363, -0.420963836719641, -0.362397957103857, 
-0.34897939260016, -0.292271288694743, -0.737637494124877, -0.338121183237407, 
-0.282393150481534, -0.457137780931818, -0.116595782618962, -0.215303186103484, 
-0.0526548404925429, -0.259855541523159, -0.249366291437011, 
0.096311699693528, -0.048439530993806, -0.679788632795742, -0.420357315014438, 
-0.489285773853764, -0.362504337435407, -0.100867943656760, -0.00135478556597031, 
-0.320148188450287, -0.280636340635246, -0.405206249314498, -0.459978924968173, 
-0.349722152004458, -0.273931610855678, -0.47593305054848, 0.0324344653361651, 
-0.352349001999605, -0.146000248211684, -0.226828595201369, -0.256261794542615, 
-0.364849388483080, -0.297561511948261, -0.0410939054252389, 
-0.320069006835574, -0.175994728720671, -0.387146146721496, -0.387984007003238, 
-0.333955058965706, -0.435898236043916, -0.0913640009023001, 
-0.186842826422639, -0.568020170393515, -0.308382986399065, -0.508016953744548, 
-0.262549237087724, -0.148707987641359, -0.380315741790281, -0.296336206404527, 
-0.594548444585902, -0.282423715162864, -0.0101337261088965, 
-0.178284884401604, -0.306701477299941, -0.431723473899939, -0.0677217280658744, 
-0.483726935174918, -0.299456558322522, -0.238232389069389, -0.289434172578545, 
-0.275585948462469, -0.350881644716799, -0.33071518639015, -0.29065367445225, 
-0.263876765698108, -0.287661356552499, -0.378819014738412, -0.274237373559346, 
-0.299891187132643, -0.346931136506158, -0.257857540880016, -0.271272944257884, 
-0.286994795118749, -0.478657594651088, -0.221611393559228, -0.163001589875327, 
-0.148848862339417, -0.131740858034908, -0.82844221662932, -0.263804152557745, 
-0.326491988006836, -0.113812350659345, -0.383337827198911, -0.315468192629395, 
-0.176295907515624, -0.145508673451967, -0.264805959213672, -0.180931802440977, 
-0.454672561262066, -0.357847115395488, -0.147131203071626, -0.186469603030192, 
-0.351648274969082, 0.138198250869686, 0.0509252778096100, -0.491156196879967, 
-0.0407205821339199, 0.0435788693049359, 0.439580906544819, 0.0409865033779754, 
0.0120365192113798, -0.122094366877858, 0.157832526159288, -0.0483408397284501, 
-0.0686440169645082, 0.291518346821888, 0.00488407422606611, 
-0.0718261658181041, 0.0489125737275099, -0.0162057599380575, 
0.202421929066443, -0.0641860793175477, 0.554846960829299, 0.156281291824107, 
0.436655403981151, 0.0341823448248442, 0.170985402068708, -0.38597462273851, 
-0.0708733138318817, 0.0385009636008455, 0.143472118351101, -0.255860103743564, 
0.0650337736943492, -0.123001902931419, 0.0312845230124353, 0.0206057610090561, 
0.00547967525358038, -0.240643612728146, 0.000518195238422982, 
-0.09561618803558, -0.0298303427286252, 0.00931334455640319, 
0.115440726435161, 0.045297467794691, -0.0415432400625692, -0.0279291528833274, 
-0.0638483208745056, 0.110427327774050, 0.402417651417269, -0.0866095859646383, 
0.0659572096551875, -0.0557536996593359, 0.168957700533169, 0.155439827845919, 
0.0798186463011505, -0.0563408342384228, -0.231797425504295, 
0.171620198183153, 0.0567975640503573, 0.124174464234834, -0.0256853873980346, 
-0.123612476910284, 0.0543742597411623, 0.0774498779489546, 0.181241350062175, 
-0.147823119451952, 0.0668494264389815, -0.00638668573072015, 
0.120057122591442, -0.140752870768693, -0.324652572965171, -0.153674057583103, 
-0.264582575046387, 0.0068679681771188, -0.054619977877998, 0.130189208696938, 
-0.0799930121485415, -0.34549542561828, -0.124497869772588, 0.446157798418504, 
-0.0455027579132163, 0.0812335899528716, 0.0083151623760095, 
-0.122689952512499, 0.171877005564222, 0.186149413842680, 0.324202951531326, 
0.273488771310325, -0.19546892859859, 0.0739898360404396, -0.0362061937453558, 
0.306103177421738, -0.0267868733736288, 0.0974329297924025, -0.161912309775683, 
0.281190162202914, -0.0709416120241914, -0.0258561532628623, 
0.255536468290880, 0.0831453222723585, 0.236610077917219, 0.322983014293756, 
-0.143768259060474, 0.109901983745376, -0.0282958042830787, 0.197188959430953, 
-0.0580017279439896, 0.109345730044557, -0.233592169744909, 0.094759839104048, 
0.08659471529001, 0.103133403186661, 0.145811333340818, -0.0211418118048739, 
-0.201968612936942, -0.0320998820224797, 0.0432188830649708, 
-0.000222722595995547, 0.113178765082551, 0.0542219825484407, 
-0.0295843902925614, 0.0742791617878257, -0.118885616539747, 
-0.175879091801578, -0.0419295278095885, 0.0461831943121819, 
-0.0154898260918007, -0.307583772415956, -0.192074647392888, 
-0.0186584321631822, 0.00870568334158992, -0.252589295143615, 
-0.00513890848523608, 0.0163397374613872, 0.287297736110426, 
0.113435188961993, 0.155983340666714, 0.371509328067634, 0.0238681739783961, 
-0.151897535438048, -0.144842672323595, 0.215368838819727, -0.0158486382662902, 
-0.00952044895382981, 0.135315190602877, 0.080071271737628, 0.0130049898358561, 
0.0741988131756928, -0.157828653350060, -0.0421819293697823, 
-0.0690122103799435, 0.19573144791643, 0.348412205097194, 0.122006808798393, 
0.208802960420257, -0.0803349209453502, -0.119381396648505, 0.0665656951835397, 
0.123963516436602, 0.115977094568247, -0.0968939537964696, 0.09212029927842, 
0.0783723308711995, -0.14473349036366, -0.0930384763132157, 0.0373275771199707, 
0.0401075724858621, -0.067601301381624, 0.186516917981849, 0.0659230120832109, 
0.189229256061557, 0.125237438388553, 0.0126530935159606, 0.118310685684169, 
0.165884819545589, -0.107935454297373, 0.0477773346454290, -0.157428512565110, 
-0.0250891146527920, 0.0359857195929661, 0.226014000710821, 0.0841478061031958, 
0.235702409842358, -0.0796924682274578, -0.0402684794527507, 
0.000185414748828792, -0.0482823976434143, -0.0527249977262127, 
-0.208789634349382, -0.0845322573265499, -0.00169190185389875, 
0.203185928666284, -0.0761199894678708, -0.123713765205605, -0.00337473799449238, 
-0.0716118244129843, -0.0227003202158489, 0.0357711392255300, 
-0.113147466297017, 0.165326706888112, -0.0398529846798643, -0.0701413029304617, 
0.135215400473594, 0.145645185931366, 0.00474267056422303, 0.241812249391910, 
0.126140548815053, -0.164802059472220, 0.0505762164958527, 0.0867363990942923, 
-0.0801949483518092, 0.0569761275012967, 0.0877752598323757, 
-0.0814268217213015, 0.284303525517642, 0.00568383961435377, 
-0.0206644866144482, -0.0900998970159963, -0.259491569410628, 
-0.178458414880096, 0.343958680265081, 0.118140286191631, -0.106914299224223, 
-0.0274746444351271, 0.0460569753004799, -0.227506309163750, 
-0.0901045860188982, -0.0477411324603217, 0.385925143664174, 
0.513543560261423, 0.110363411657312, 0.224496058685973, 0.0961538268415742, 
0.0437649367096353, 0.0991001424073224, 0.228351999182569, 0.135088662387686, 
0.115329527825411, -0.0890122130530993, 0.148370566556794, -0.0573460774355769, 
0.176232572376128, -0.147372673122019, 0.120081308335282, 0.0646807308572412, 
0.050505711850457, 0.0631990039244089, 0.0597274822562502, 0.143883101672930, 
0.132476377250608, 0.146261132393281, 0.320427783022774, 0.175056038833608, 
-0.262982646060023, 0.160543267990843, 0.0550210085449968, -0.121459357803558, 
0.0372794687794043, 0.138050404297230, -0.0974989587224614, 0.324758284916811, 
0.155523081984484, -0.0308488390762432, -0.300165720109991, 0.140024801247132, 
-0.0679683527506484, 0.00154184058142297, -0.203299498455240, 
-0.079602524203549, 0.114370563270390, -0.11889579470354, -0.224445483765602, 
-0.203312986904346, 0.138965544044465, -0.0342280171569269, 0.0498879598674428, 
0.258155631524441, -0.0584142429550947, 0.092419313088057, -0.108860433805262, 
-0.0216140612509802, 0.106384677413161, 0.199923868321282, 0.058544419807577, 
0.108138415792874, 0.0425329336448803, 0.0726437490684015, 0.268667985656458, 
0.121884660983414, 0.225298649662257, -0.257173021561870, 0.143004750875248, 
-0.0759622329019282, 0.174196910174216, 0.0802119377195477, 0.150322669041157, 
-0.379623991158092, 0.060261224277301, 0.314668819058772, 0.195209338853044, 
0.136703849724463, -0.0341614344037753, -0.0444490252203202, 
0.0770750294630018, -0.181630680592674, 0.099965466563162, 0.204914537352291, 
0.0515412890750057, -0.0587133612265397, -0.128445537472111, 
-0.0237261925073509, 0.262918045113279, 0.0474039454215946, 0.159423348166640, 
0.310962027651728, 0.0206581767846227, -0.125729384667081, -0.186314654915491, 
0.121041921760899, 0.128381784124206, 0.135230869996305, -0.101780231596118, 
-0.0394446494858716, -0.0177052983847827, -0.0852923708007705, 
0.0123976439869781, 0.107350302207751, 0.104156204446077, 0.0962350352455797, 
0.0936141436732763, -0.105825427358359, 0.287900646193305, 0.0629071071099645, 
0.257867824441122, 0.328438577027176, 0.160091953029232, -0.174893634730123, 
0.123426334788569, 0.0110550866621473, -0.0292133599046317, -0.203263151188727, 
-0.267461181037625, 0.162037519299183, -0.0672957417340107, 0.276573276804925, 
0.0122606942065186, -0.320669431763157, -0.0241051252918358, 
-0.276409405109482, 0.268365098573922, 0.101794851541961, 0.00651060507828647, 
-0.0618758560219344, 0.168874009321022, -0.103830669259619, -0.182085165530035, 
0.0275815698950553, 0.0799750835068583, -0.0172546289067584, 
0.0536440601036588, -0.00606585081806151, 0.07219947016129, -0.251007530130871, 
-0.0706929433574328, -0.210478762300037, 0.00896862622283628, 
0.197418431180315, 0.083417101317685, -0.123440073305782, -0.0532014713375362, 
-0.0376251678464481, -0.000115808335484508, 0.183334826458480, 
0.136828319246266, 0.289102869962578, 0.0299655940870678, -0.066531105764789, 
-0.0115459664092063, -0.288836611860834, -0.132344830651112, 
0.0474796911025372, -0.198678341635679, 0.0480761279028097, -0.270392268141966, 
0.0173815351195789, 0.08246987001885, 0.180624684977319, -0.0502103079897993, 
0.145224618915206, -0.0503880269315460, 0.174655083363236, -0.112312299357826, 
-0.0694797484594778, -0.162589872160488, 0.461724805254240, -0.0319920527124626, 
0.0302480934421223, 0.150471264896125, 0.0101979024055251, -0.198608390129675, 
0.0294520464251153, -0.157127991945647, 0.194313910170729, 0.0488540934640787, 
-0.188600536195872, 0.0154136845402308, 0.0659422817720359, 0.128177382754510, 
-0.0942299609869508, -0.114180617283272, 0.0961974000538752, 
0.0686175665627749, 0.0876214829052167, -0.186689506124411, 0.0508522640772085, 
0.642348634654923, -0.316133349653608, -0.103575466948672, -0.106172414627030, 
-0.142934180987827, 0.101908425089064, -0.0957402124501879, 0.122929770827673, 
0.0255748908950629, 0.080511644040495, -0.0118849347344412, 0.143240721904125, 
0.153647282398435, 0.0282766630814944, 0.0683293999158108, 0.200132709734610, 
-0.271952064057716, -0.140229330086683, 0.0429492292507941, 0.0938278377292012, 
0.0245346453483657, -0.0413573145856415, 0.118857368981496, 0.230472213836302, 
0.277817555042247, 0.0986615959764058, -0.0785447410925175, -0.0143999382051246, 
0.253209173529626, -0.144431898072354, 0.174552487314429, 0.182189807766163, 
-0.210723624675008, -0.0293512806463056, -0.0366842412605419, 
0.083245252414655, -0.212384246740356, 0.163758438042613, 0.214577556891208, 
0.0403378844737571, -0.301504223756889, -0.00702034730922417, 
0.0315840885676262, 0.151873851599775, -0.165337262624214, -0.0676279614072235, 
0.269644889913496, 0.0980415796130392, 0.244772800943247, -0.221516846293402, 
-0.101318652954916, -0.241561965200750, -0.0825888863156712, 
0.355097910602382, 0.109525351516223, -0.076440903853208, 0.00943282337667566, 
0.0274605091474834, -0.370812307176047, -0.189572387041582, -0.289380494643991, 
0.119744097422109, -0.0528783143894218, 0.215757415084987, 0.171883984944031, 
0.158277180333447, 0.165780610505170, -0.0640518848249537, 0.129156001810708, 
0.0079886571409483, 0.0514735019866385, 0.0453344697669695, 0.0854520755918845, 
-0.101153330729858, -0.142524963908188, -0.161482832794027, -0.050960602687393, 
0.117111620904212, -0.208147879648387, -0.122403678736083, 0.0415889748162721, 
-0.192406082187757, -0.09534410306159, -0.0228801268359836, 0.159953248160688, 
0.167378739194147, 0.0130966400114027, 0.000318224618005868, 
0.29824108519013, 0.111841374708220, -0.105319270265913, -0.232326987958586, 
0.00530031746317666, -0.0704845473079778, 0.0400700408801246, 
0.0538993876253815, 0.121879691071072, -0.286739760955411, -0.0121928767483857, 
0.0712654515385622, -0.290717079936919, 0.0495661712411958, 0.170763999450501, 
0.285537701817547, -0.155877780550396, 0.0269402174164474, -0.0924115177232995, 
0.107462032458539, 0.0570454482743489, -0.0432465557838085, 0.225520799042590, 
-0.0716560104412141, 0.155316109047408, 0.0603062954796258, 0.125581461927082, 
0.471072572128457, 0.197154747297503, -0.186789745651756, 0.125906517964399, 
-0.0422795724574851, -0.181365590165932, -0.0229722407338613, 
-0.0146306254413162, 0.0499223366241648, -0.22402588527852, -0.145207051719184, 
0.0184030286459507, 0.231217772364519, 0.0746048512250262, -0.0167342480349311, 
-0.0948400438412979, -0.188341421696047, 0.16188239648897, 0.0891785435411327, 
0.048740767401479, 0.258728275436686, -0.119986307308971, 0.0682633435229845, 
0.30930036228188, -0.0430114906666464, -0.165018156726984, 0.133945791134555, 
0.0126037967716676, 0.0991605696767695, -0.143953578411274, -0.133338707382090, 
-0.21465689044126, 0.242967573311911, 0.0882240468033188, 0.0764098395146134, 
0.147550288788631, -0.095470039279141, -0.16948885690411, 0.0710304798543712, 
-0.197217225204845, -0.183689994337362, -0.0571812776277136, 
-0.115391001448591, 0.158928929104315, 0.214191938770112, 0.0567594940486979, 
0.0364737089264319, 0.135141540888567, 0.171656916859731, -0.170953058744941, 
-0.192883713869079, 0.0254684032734290, 0.246288290223984, -0.116581515441771, 
0.344272826666911, -0.129994786192039, -0.143744458143039, 0.155374583674610, 
0.154925760605988, 0.1293684226068, 0.0689135948680674, 0.106348426274168, 
0.075054934208008, -0.0386535785360850, -0.231476424844985, 0.0237291118171951, 
-0.118420000251197, -0.0742851774977267, 0.0767648680316631, 
0.252522674593552, 0.279450769069525, -0.0306880807898645, -0.170381755044027, 
-0.111355542681208, 0.155287001837322, 0.146225136973538, 0.192776578769106, 
0.0557848647487822, 0.0208886812410739, -0.158960319461993, 0.0478327387813117, 
0.0373574276644715, -0.162032607057282, -0.184307410308570, 0.0606423672779283, 
0.0677969287609862, -0.122393783571513, 0.266309270364200, -0.00340795426714390, 
0.0379096053908512, 0.0761886171613526, 0.000600734999476714, 
0.119153943835368, -0.00671097663558659, -0.0782880728332368, 
0.27118150970113, -0.273389669555949, 0.388390535474298, 0.00184107134894116, 
0.0618437318293224, -0.014794852008608, -0.196237739855544, 0.180380435747588, 
0.00166597216776985, 0.0916859782876194, -0.221252385046112, 
-0.137461791653538, -0.00552788546507843, 0.393869698762769, 
0.00135659921323675, -0.118909746361577, -0.0389551808953924, 
0.209898383360975, -0.0519202234212445, 0.047145584600603, 0.0491437950983527, 
-0.0370724445244316, 0.412852635251309, 0.22549356062768, 0.111726664657425, 
-0.0474217063319549, -0.121588052192506, 0.80328760218363, 0.2610531264498, 
0.151992121780652, 0.214617740605164, 0.0312227213088674, -0.165309368221767, 
0.0391558033178557, 0.00405957689239223, -0.125134616339985, 
-0.106667594134957, 0.0484526483000283, 0.0645400790776277, 0.0926806233719986, 
-0.121243004434900, 0.177712679150577, 0.0112331681027198, 0.237004505558497, 
-0.0107854381763202, -0.0057069668765614, 0.0592904669385657, 
0.0591030693905948, 0.0743394645499486, -0.109186355549970, 0.00400781483195253, 
0.0339921083327705, -0.00785917497479181, 0.450063742396398, 
0.139348274239373, 0.0428842353812611, -0.0635212810898411, 0.127827770543932, 
-0.0245647198030307, 0.132150201390722, -0.0155892074780530, 
-0.0105201554017306, -0.279151246369071, 0.264011618664672, -0.184006949766249, 
0.0874185618329561, -0.396441831557491, -0.473803777599462, 0.0141887981106844, 
0.0240357942179953, 0.168641258218774, 0.109607816004489, 0.0312755774302721, 
0.220697919792777, -0.08557419275471, -0.0656282882700724, -0.265872606196592, 
0.0941564315093625, 0.137031912329463, -0.100553518856294, -0.0632924633548427, 
-0.0172035461374311, 0.0775856218559927, 0.0273112205548752, 
0.165899773133214, 0.072710899729639, 0.0274112894935514, 0.219981307444471, 
0.239529525082102, 0.088827052443331, 0.237199884775325, 0.0238192350693578, 
-0.0216678367907763, -0.166174912724453, 0.0416548936042741, 
0.0297583356211201, -0.0944646765985154, -0.105369974425439, 
0.0207406395889162, 0.197359207616020, 0.180142088079912, -0.0562092718540643, 
-0.107768905272803, -0.0549158575285412, 0.0274406991227652, 
-0.091899937599418, -0.0448233953700779, 0.0770870967378303, 
0.000971585002174568, -0.146091067534238, -0.0735424043233307, 
0.0215714600332085, -0.157013683609489, 0.0137538139169043, 0.126355093819091, 
0.251315411860551, 0.136915893056936, -0.267824545741466, 0.157053741745979, 
0.0934277748365294, -0.0150115123510236, -0.0398023031968, -0.0121644239319394, 
0.376635704268033, -0.0934659113771601, -0.102474941063456, 0.0708374782842747, 
0.0948467791140887, 0.00381455361318679, -0.0186206734638563, 
-0.0435401163591261, -0.133361378564941, 0.199500326837775, 0.0986776768390888, 
0.0506237739137005, 0.274500158850296, -0.15299408855306, 0.0425284715645169, 
-0.224374350151589, 0.288799643196180, 0.115302139731830, 0.186681148860720, 
0.176304463508165, -0.121671875178799, 0.0991227351777858, -0.0816177572078178, 
0.148732912757814, 0.404354367885787, 0.0788443331885615, 0.0227286094052612, 
-0.0697152162284896, 0.0615009931815416, -0.219523063297125, 
0.0541135485020360, 0.0670067992586091, -0.148246976582647, 0.184964063980443, 
0.0517341735412074, -0.156069799362282, -0.0325249158264885, 
-0.0319963366146692, -0.0783304205601053, 0.235368676437983, 
0.144489197950753, -0.212714248364677, -0.0180253216349637, -0.238272594369853, 
0.0438506821057583, 0.0222583573906718, 0.0729051076007018, 0.00507471283199021, 
-0.233877953586859, -0.102066006639576, -0.0436426376953604, 
-0.119742739048759, 0.100777251724790, -0.126560601778562, 0.35137198531166, 
0.197137736069836, -0.0135454933190312, 0.0204914156123221, -0.145235907496378, 
0.173220146748078, 0.16075065953046, -0.127918798729239, -0.0823951819481675, 
0.390930768959286, 0.085509043485444, 0.0862544828989382, 0.0314270515555695, 
-0.0347905746455027, -0.169925298695801, 0.204434052461143, -0.101095601307872, 
0.175688074815004, 0.203731778584294, 0.0649878138992673, 0.0100511420197704, 
-0.109568521073790, -0.0414986341296605, -0.0192327414930562, 
0.0240106705165151, -0.221019170569363, 0.260315665108622, -0.00558075022475955, 
0.128149750825981, 0.0495175294748454, 0.364736603631164, -0.40088402997285, 
0.123217332330197, 0.146860567808488, -0.0228294258572351, 0.0370964312869112, 
-0.103707732242938, -0.036105776062291, -0.118347500943206, 0.223190967360999, 
-0.199346524443792, 0.079115676942965, -0.122213314501795, -0.0339967456948736, 
0.0368967351655908, 0.0590140551359503, 0.0795774584059856, -0.102039216334071, 
0.0649549997366356, 0.0432334986490654, 0.0639292839464488, 0.146633478181875, 
0.0433935031805877, 0.0645279630597423, 0.209543163847679, 0.0734329028372728, 
-0.259843500337549, 0.388668246512971, 0.252031274171384, -0.0711283781606474, 
-0.183118632698923, -0.0564625680253187, -0.188486427479958, 
0.0137915224537425, 0.0229802134767210, -0.32494160533846, 0.236663906418818, 
0.324430068196025, 0.0355923835803851, -0.120985909860197, 0.495617884319287, 
0.00351244760890793, -0.0848625358358908, -0.142426887241513, 
0.41790849452495, 0.243632662584105, 0.106443374709360, 0.0713510164247347, 
-0.0236953111918332, 0.172444815337976, 0.118076668907567, -0.0573245970054181, 
0.242924214579052, 0.188682494184126, 0.162934879926863, -0.123045293246967, 
0.142678490642335, 0.0554300936032455, 0.14515543366985, -0.100827971756488, 
0.0146123661941613, -0.0782086834216708, 0.00745165193992166, 
-0.0630010056680867, -0.00829462518236234, 0.206553971795283, 
0.144803443995604, 0.0405500750990425, 0.163477139585031, 0.121036125504351, 
-0.109808941543036, 0.122231288752992, -0.0692369950591132, -0.339372089389308, 
-0.0234319075246229, -0.153170637000237, -0.171187393329949, 
-0.0739515736050252, -0.262462559174262, 0.0294900381043685, 
0.0335320037272204, -0.0975682398883043, 0.0457103879551265, 
0.0488604700974917, 0.0194829133440264, -0.117757875972502, 0.0643219518766845, 
0.195115205182126, -0.274992848781924, -0.187629133049258, 0.350990436939744, 
0.0331077961720265, -0.100167382413181, 0.479002366902983, 0.0278871504449044, 
-0.231651443335643, 0.0364840801792054, -0.00275113684090862, 
0.0723468177073791, 0.281112403819904, 0.0941750495519177, 0.345684693470433, 
0.107810377115175, -0.000491788111190203, -0.112489473468042, 
0.207906482784471, -0.0420643069425222, -0.215546554304178, 0.0538333150448348, 
-0.070721852291706, 0.0333323634122097, -0.140158145583225, 0.193833122861591, 
0.0357181179233887, 0.127168358240763, 0.426363817239012, 0.0567201550352944, 
0.0985929821930693, 0.114649396666937, 0.0211532195316691, 0.0599323307713547, 
0.163330042295301, -0.103290687270225, -0.255020652332527, 0.131447924432247, 
0.0140621373325241, -0.308223393672899, 0.0123692597914238, 0.053921724053595, 
0.0817382721386105, 0.0767117295655912, 0.0115499817503071, 0.0949316718451033, 
-0.212713537499421, 0.0108334237200364, 0.163354901145603, 0.188161054752703, 
0.221640698641573, 0.0254026436650025, 0.100785164418656, -0.00780530974534984, 
-0.070767011106206, -0.194293705616594, -0.138557001362051, 0.391279310045842, 
-0.0110415942509919, -0.168816293848698, 0.222400008779239, -0.0644807498397872, 
0.0795673002700242, 0.239010209623248, 0.0499161393386976, 0.313002023026271, 
0.0587951347442915, 0.0955469105739442, 0.0774436919110155, 0.123446782592033, 
-0.0800066734307143, -0.0772744729059905, 0.0307500838330907, 
-0.0221134012457413, 0.0439635228625527, -0.031570514450826, 
-0.0750980437828817, -0.0559921270126091, -0.0693061979851989, 
-0.0752546782534674, 0.0460841177479079, 0.0553098461980105, 
-0.201097361871576, -0.0774451944099593, 0.295744002033739, 0.38844485914914, 
0.456453060700481, 0.397230348823305, 0.139496161651786, 0.177924874617117, 
0.0450884491260176, 0.370446763213713, 0.267706338925021, 0.293858586441273, 
0.411533616823547, 0.273270627004511, 0.409092478056268, 0.280974650986563, 
0.58799612999747, 0.312590090320953, 0.271489461146663, 0.508620204665473, 
0.0406752576100419, 0.382030039247147, 0.0162145058386475, 0.273125795519585, 
0.538736680494394, 0.376113451375697, 0.999999492172716, 0.27853502890765, 
0.413221195474873, 0.343162503742176, 0.459805338168135, 0.270558586496989, 
0.56326687879056, 0.381256114975157, 0.469379855740889, 0.344736102061428, 
0.130939733814471, 0.449707028340775, 0.349953174445241, 0.352953753339468, 
0.417021848957174, 0.266938818205665, 0.485903881564087, -0.267209975276739, 
-0.076832004414021, 0.492286360523222, 0.144454225262307, 0.311986247425214, 
0.48203020868439, 0.326075419528562, 0.488187990341705, 0.393389807677816, 
0.637725941089456, 0.397373184890231, 0.144889283384781, 0.356706964073032, 
0.493764444248339, 0.521541632332337, 0.533565024450805, 0.137235733798344, 
0.259266402860653, 0.396020511694035, 0.149460288603371, 0.438920246234691, 
0.483979200809555, 0.173512279619326, 0.258288218432352, 0.603202778361826, 
0.142352043613621, 0.611180207580494, -0.0127707772125287, 0.431485678727451, 
0.365714207658795, 0.298671063464991, 0.0273777195360393, 0.695288323239564, 
0.289043501549367, 0.389094082012933, 0.388916178859127, 0.359209939582993, 
0.255277845730219, 0.332804017243096, 0.187575973705046, 0.181990249588856, 
0.274792615097335, 0.35238980524864, 0.0651072495359896, 0.222257310219964, 
0.999999171448495, 0.753347580947417, 0.459398047774495, 0.305939489290497, 
0.48493227628171, 0.149500046881217, 0.179218215211341, 0.560230987648532, 
0.199639750559470, 0.348005048005208, 0.227043152655232, 0.209497879320350, 
0.497579698184834, 0.515033343304919, 0.716481225938983, 0.0658191234146094, 
0.151581736138064, 0.392074335124808, 0.59916366545085, 0.42312450967657, 
0.0519593349588907, 0.246588708667511, 0.471412746816693, 0.346344607945013, 
0.508357048921719, 0.773319467087559, 0.450694593732616, 0.657912952745055, 
0.329770979656808, 0.273256541320006, 0.451677950705204, 0.342448565991769, 
0.182591576876019, 0.184770669207465, 0.383139108321414, 0.0863935583160526, 
0.634436655454086, 0.347521131789269, 0.0412666171941447, 0.526214946990059, 
0.420486916492984, 0.375733774686895, 0.479504386600053, 0.257652304097007, 
0.318600997531322, 0.50691952746396, 0.182600349329573, 0.215457461276908, 
0.523347614936496, 0.622961998052011, 0.615560186433124, 0.311117508071726, 
0.31928266321896, 0.420356434078124, 0.21306400983533, 0.218593952187631, 
0.296489277020397, 0.237343207233184, 0.294504493273226, 0.405030482885371, 
0.162365079486685, 0.752409819525044, 0.348047533566835, 0.311909766383527, 
0.673343376010068, 0.270689777257939, 0.433656498228247, 0.594770887586103, 
0.265262983575232, 0.245617961038014, 0.0467858186053917, 0.999999503241724, 
0.260469667253145, 0.288955446526204, 0.457268392567794, 0.306937215221438, 
0.329848459780318, 0.295740012792853, 0.481853102537735, 0.451790804829823, 
0.384368990920475, 0.391814135640956, 0.999999390627337, 0.0543993074137054, 
0.393589137542124, 0.245884725179836, 0.517093741904738, 0.122549079776546, 
0.151560135493291, 0.455166483481108, 0.370894017061525, 0.255827304321975, 
0.388831753153164, 0.248168129027459, 0.593335267005344, 0.417018948339269, 
0.772748847983731, 0.289834507658255, 0.280545219084986, 0.307683959402249, 
0.0972514781618755, 0.33444654398082, 0.439762610383199, 0.353491591170775, 
0.450212472321261, 0.246037951406850, 0.336619653029087, 0.478957038278902, 
0.178329631710768, 0.264364585641599, 0.30490358898326, 0.523027342948873, 
0.143203395767719, 0.0827052333141622, 0.0991978816697146, 0.220120582856594, 
0.501720171210189, 0.209144537581871, 0.0634358381456188, 0.0525151631025833, 
0.571932188944321, 0.204821041660877, 0.999999499604656, 0.153032503390350, 
0.569890891375493, 0.606189356373161, 0.36666171439335, 0.400582551224127, 
0.309533912194889, 0.553734752441863, 0.255633999281900, 0.415735419298671, 
0.374802066882577, 0.538933197273264, 0.314170405314716, 0.333868993234038, 
-0.0224894021859139, 0.666676441928518, 0.345470648860387, 0.126268282904515, 
0.252446509301783, 0.081950940693021, 0.297496290266139, 0.258947523719526, 
0.314945109298971, 0.227070718282395, 0.413376519776117, 0.231585520149863, 
0.360345681987251, 0.496884881466314, 0.5414418312909, 0.687432171144826, 
0.484440914783179, 0.207518484289535, 0.37092388423977, 0.283707179178205, 
0.432377687063582, 0.354600674412486, 0.142158325927665, 0.421116676169023, 
0.176504573857205, 0.116567510321858, 0.106001024106060, 0.297754576761684, 
0.409229489278434, 0.374533788891725, 0.34637308543457, 0.46768785147697, 
0.271668168476814, 0.504201728083682, 0.318852696761215, 0.43092679193378, 
0.139696086129035, 0.390007534733297, 0.138937134943703, 0.33566072865731, 
0.382599917939418, 0.605163922059082, 0.534433027967723, 0.786378838389251, 
0.195708678063169, 0.455161131474161, 0.382890975445825, 0.311358928590629, 
0.436467919839708, 0.239171062169274, 0.550390251182836, 0.451337555138905, 
0.571456669081006, 0.113922950984459, 0.451808109438467, 0.274035144427317, 
0.111744354696268, 0.665890869227128, 0.398898146825146, 0.204757749873802, 
0.250760514446317, 0.437178708967706, 0.306593206489464, 0.297519055023843, 
0.999999500206762, 0.265519134424754, 0.355059754871622, 0.401146284997095, 
0.256993787968372, 0.50914098738812, 0.487402373279774, 0.212025337267764, 
0.61689103753989, 0.298443389810023, 0.540182452114768, 0.328433034098276, 
0.409242479611839, 0.223536675816601, 0.120609679574701, 0.355459492652349, 
0.277058505781491, 0.377927396914488, 0.494306900652932, 0.0727615642436072, 
0.399599470197207, 0.64855829697135, 0.58977257787728, 0.462732736130488, 
0.213149626790021, 0.337321345610312, 0.432994418338903, 0.175483205356471, 
0.597808673546015, 0.0344782654876438, 0.673953097597791, 0.241589790026082, 
0.0707451275637372, 0.561145715155958, 0.444303496271686, 0.339090823328378, 
0.168929853448139, 0.215950256747838, 0.0960269339443915, 0.74599853796737, 
0.231085149082739, 0.248491726200533, 0.74523915685432, 0.50585284283674, 
0.325970007401399, 0.103321988683130, 0.124108474876961, 0.399942438216083, 
0.378464507904942, 0.331366537068647, 0.355711003274391, 0.540695264371922, 
0.0969487453650597, 0.566796750647037, 0.400332986423185, 0.224058343443027, 
0.709059908797323, 0.0464556414789645, 0.493401643021696, 0.441890040239417, 
0.308613751075118, 0.303137481485507, 0.23653137780274, 0.365749419417386, 
-0.0189623184324017, 0.411838852365115, 0.666762838892545, 0.516302199953177, 
0.249449971800621, 0.685999899909665, 0.267772173150653, 0.114865049996369, 
0.743227556123642, 0.240419868635763, 0.528002348675483, 0.843297595838592, 
0.231770430522334, 0.107919647953232, 0.226098014114987, 0.471651967595174, 
0.48855489670443, 0.346372069106338, 0.463046884107279, 0.368264839328671, 
0.361323880072234, 0.388655676726351, 0.241325245960033, 0.271709003377997, 
0.250801363766521, 0.476866893559119, 0.228347697637948, 0.265192853780628, 
0.434290876669773, 0.304200621785857, 0.903699381171598, 0.304363908544159, 
0.236839456575159, 0.575857033756655, 0.429391714279478, 0.0699330766311109, 
0.399460773890447, 0.335712320747802, 0.0309401267886255, 0.400886349332584, 
0.472310937366631, 0.59523014705485, 0.447925748754462, 0.2979558158601, 
0.266983175366070, -0.0384683507248247, 0.366813126978771, 0.471787692182924, 
0.435311839101175, 0.501580623969123, 0.391610015896143, 0.0950515992980004, 
0.491076086084001, 0.231364655658042, 0.401033337152423, 0.311563014482994, 
0.190674878124604, 0.201480599251289, 0.218864242723334, -0.0289640927586423, 
0.282254197190255, 0.552498105977646, 0.384750173173574, 0.56083485749321, 
0.411872005397688, 0.212141810685872, 0.444790646193735, 0.261386041951462, 
0.363237438135493, 0.160184361389692, 0.252810711752897, 0.46828014485928, 
0.403492812959307, 0.285707668928552, 0.331523179759153, 0.317390006737864, 
0.40776546141673, 0.293198030472841, 0.084387423739074, 0.304009993899816, 
0.226219704850998, 0.220299378042342, 0.273266771172822, 0.442297943016522, 
0.625877219613086, 0.480143764440045, 0.450199492755882, 0.210027566450318, 
0.620777559877729, 0.220767459578437, 0.277198895113053, 0.462240894663618, 
0.539953933722938, 0.372581608956777, 0.176374331804896, 0.473580021706288, 
0.0343075497148826, 0.339899222713669, 0.0887422771582404, 0.246737040741685, 
0.223848779112925, 0.276154483810319, 0.326041233863645, 0.361938597555186, 
0.138852160749696, 0.179194891147313, 0.21292498649359, 0.490930739268054, 
0.198089561563515, 0.189812277310377, 0.462332687367282, 0.149819482877337, 
0.300102127115179, 0.482644429038447, 0.440688808834494, 0.246601585246702, 
0.126878240277816, 0.253895319954681, 0.60227584297132, 0.140958314981181, 
0.307153631589814, 0.416208855444603, 0.418708689505379, 0.425246136852329, 
0.311577256654764, 0.399603688520303, 0.352764234295138, 0.239870693043946, 
0.382116902127767, 0.135417666822301, 0.407577821694844, 0.406315686959721, 
0.149342253540641, 0.337355852287873, 0.129143984256605, 0.442072822201378, 
0.0399774393332032, 0.556987852306417, 0.414957634826353, 0.333025372541731, 
0.311996661257320, 0.469571146933471, 0.40836348309123, -0.0920804797835651, 
0.252494919147453, 0.315414743726952, 0.558295700374951, 0.447233939348835, 
0.43750428416916, 0.419946637567809, 0.189226336721044, 0.416447747523042, 
0.24018771612857, 0.394882058057358, 0.413823343658382, 0.099567666898511, 
0.401156289633651, 0.450160653136515, 0.550717439901317, 0.0476075326321733, 
0.367934019407261, 0.511276941671994, 0.0977174048245073, 0.456333158383374, 
0.399238111794956, 0.308617819742274, 0.298415168727713, 0.370810802353614, 
0.219196081515326, 0.313200541960609, 0.424155126083024, 0.246732176554138, 
0.63467079303411, 0.355085482747603, 0.205047695178970, 0.256384823267893, 
0.358011783611647, 0.464478661099219, 0.331569231871115, 0.201438105219532, 
0.539404398372392, 0.504301685738302, 0.180381262912987, 0.121472344904051, 
0.086872990891872, 0.37422451719448, 0.453805757915598, 0.221563253095201, 
0.424994323995980, 0.307087338900218, 0.408218343210639, 0.140125297468504, 
0.471655221403449, 0.466454631163916, 0.590109932977112, 0.416127136338601, 
0.066450934160958, 0.492034115429273, 0.999999215045143, 0.659222155873006, 
0.355175207041379, 0.289162263320500, 0.55621694411049, 0.129240152230729, 
0.146928500446594, 0.272683287727708, 0.233249453980744, 0.498589890717467, 
0.582435405182835, 0.505953089267731, 0.326710677192917, 0.248841544622504, 
0.400902410776963, 0.102874542317259, 0.336916042781258, 0.50314614285453, 
0.113765351758968, 0.539602388081945, 0.476708528346933, 0.33830766130399, 
0.249563995926824, 0.130505938954421, 0.24675110475402, 0.400990167029873, 
0.477160681324483, 0.592329153005612, 0.156889713394190, 0.205001843467807, 
0.394000785574981, 0.0404081817804767, 0.470102463349667, 0.397222258608943, 
0.253308611383351, 0.140672833662426, 0.498604548112984, 0.184488029762147, 
0.229070321077185, 0.46392457877112, 0.474297418720447, 0.364991053463908, 
0.339075858997417, 0.322899223817938, 0.250188297484609, 0.332015818674003, 
0.201896286032278, 0.163928965584402, 0.165401077523044, 0.248457135943272, 
0.507699179060373, 0.199689971623770, 0.396557575891312, 0.640871207552233, 
0.716793029129224, 0.187648481167351, 0.546318502548067, 0.414943506408433, 
0.421169443858306, 0.368448053580012, 0.655217916952827, 0.542615506634868, 
0.367441766997729, 0.0973201350714365, 0.420346258401865, 0.27645312619815, 
0.265220656701877, 0.496655310464089, 0.54053851732138, 0.472346530376149, 
0.054062186351725, 0.353141746280154, 0.528196870063849, 0.386893519716804, 
0.240636418531186, 0.641729349019815, 0.10609837835503, 0.425499743730223, 
0.393367919526017, 0.999993919668968, 0.211219008822358, 0.212160214610415, 
0.427953452255643, 0.331573402089329, 0.275871905382691, 0.265883217354343, 
0.690734474994117, 0.263990117781681, -0.0433854210097362, 0.298937163718178, 
0.230636150597274, 0.263800561356074, 0.106162881674080, 0.249798283104106, 
0.337289262326355, 0.119142952433937, 0.407855144761992, 0.128531128807959, 
0.173319594405547, 0.355402768259024, 0.229115031123116, 0.263755877556939, 
0.261947529827399, 0.999999500000841, 0.248785996951334, 0.108677783704272, 
0.192955263330452, 0.182846073746479, 0.380265086271015, 0.473871593108711, 
0.729804177931096, 0.294771604633255, 0.468115912195047, 0.269724951499719, 
0.169213839591192, 0.267044582753450, 0.506824109136087, 0.243002151408049, 
0.324987231343684, 0.253701425010235, 0.259671140259372, 0.409552301162819, 
0.445241273994778, 0.221873258787379, 0.670950129370148, 0.366811748438547, 
0.516837570769666, 0.139539193647937, 0.307905525992453, 0.65971846158183, 
0.214189647253189, 0.29214086061585, 0.197203132459436, 0.316405792312071, 
0.298418109199082, 0.338130188289927, 0.327130893617989, 0.622215861606094, 
0.398269013524289, 0.349163298198196, 0.248398956869477, 0.368545668654218, 
0.175707619292245, 0.348371704058823, 0.463506126520319, 0.212689674056368, 
0.164067157362965, 0.544589267253394, 0.283751356941931, 0.234866938920267, 
0.268010965748277, 0.214508562042814, 0.402619083412794, 0.268269157770054, 
0.334246465182824, -0.0215032010170633, 0.105240286323047, 0.497687270825601, 
0.65075487453335, 0.315965398067003, 0.167646962279876, 0.259412826965802, 
0.359266203805748, 0.556052078761164, 0.581627804570323, 0.346341117394534, 
0.286164338908526, 0.440840006475004, 0.291500393269891, 0.740453413200168, 
0.00673266459828729, 0.303159530252955, 0.374166415855561, 0.470638974804021, 
0.137607151108515, 0.466447093058468, 0.123346310350685, 0.479638158734669, 
0.378764458563805, 0.380497211485728, 0.464160530265265, 0.110452030767683, 
0.433315668205229, 0.438266870667580, 0.542235216150486, 0.0860958758114096, 
-0.0196410709705595, 0.363746095541326, 0.635698140679227, 0.483034244487113, 
0.345967618211281, 0.445190334074709, 0.423125894533891, 0.272594345615644, 
0.349933470501754, 0.153983285124295, 0.178526696825677, 0.258978365309547, 
0.135210911451064, 0.0910541716600298, 0.0740466231904372, 0.253553990560095, 
0.245163994939411, 0.233725932985912, 0.269027041704312, 0.169118536288555, 
0.477622803203965, 0.574141379093651, 0.406291704310402, 0.238900089184571, 
0.286963674955399, -0.0531329793890899, -0.120748484352036, 0.55471348640283, 
0.508752462574027, 0.390119779102001, 0.0531856187571005, 0.388850585034836, 
0.602613032818344, 0.170067468916225, 0.320713977830604, 0.535160944664901, 
0.379250517946495, 0.333070155685152, 0.271206276162144, 0.172504389404118, 
0.426558875564068, 0.162359276667002, 0.304689950548131, 0.117769374374736, 
0.199448565522135, 0.497262113751195, 0.610938036942797, 0.438856762245781, 
0.203550968445862, 0.238921205262850, 0.362362794204776, 0.458606668082144, 
0.209503829231135, 0.613678722471685, 0.0926689459662943, 0.174681351462872, 
0.0938287071844105, 0.0734885729853844, 0.380114249873405, 0.492623544537193, 
0.487249132548677, 0.180766156516850, 0.819156011341335, 0.208885170508794, 
0.442775618035895, 0.154088240703515, 0.509631576136804, 0.591860337229342, 
0.500392326127599, 0.449394593821968, 0.412036014814347, 0.208266586229642, 
0.14132303368249, 0.222844438899427, 0.16189960256325, 0.469511097033273, 
0.168671491539873, 0.114112042544176, 0.410900644367144, 0.569408433037532, 
0.351818494881031, 0.0948881900317794, 0.235571772886984, 0.0539987384997774, 
0.135494748412038, 0.355149674296699, 0.397086111039115, 0.285492961116292, 
0.472097846320708, 0.0897708581443351, 0.435522441726965, 0.221117122724144, 
0.365563161827047, 0.331012398613379, 0.172663175682941, 0.306020912901126, 
0.0621044194828099, 0.393820117001921, 0.442448437142853, 0.203120184477373, 
0.369436959631185, 0.399979239018171, 0.227112383389112, 0.436806994050582, 
0.339969686944842, 0.180887393879033, -0.0654105062772898, 0.460056608954825, 
-0.129961968979387, 0.241782381963947, 0.192729876191512, 0.579813185229837, 
0.420672785116771, 0.149783637911595, 0.320921295323393, 0.565691053015688, 
0.306792090435205, 0.104884035574966, 0.437223681572537, 0.263506575203557, 
0.459425588985008, 0.267119859482183, 0.376830651914364, 0.241710343852965, 
0.426291762427797, 0.386253206848833, 0.321067730488761, -0.0368040552562095, 
0.772496618613163, 0.526355403673842, 0.478388782119373, 0.119831156544792, 
0.493625514816621, 0.294064586966421, 0.203888317789590, 0.306212539574430, 
0.606576835187382, 0.451703628298224, 0.52064618976703, 0.252481512246518, 
0.369344717643245, 0.170283834289367, 0.162994358419858, 0.218577844154291, 
0.212390684307587, 0.300941483332918, 0.519335277498445, 0.300035752108098, 
0.593880020604994, 0.0896170156341985, 0.520733101267125, 0.396352519718404, 
0.138833703199773, 0.173651171722558, 0.341762607042888, 0.497914559317093, 
0.296753163044643, 0.361225363058641, 0.295951995237008, 0.473430989308892, 
0.36034419232495, 0.49839611686885, 0.228187769176964, 0.259106602278465, 
0.445368403675965, 0.200163909110981, 0.309282956957928, 0.350630991911329, 
0.276520205014886, 0.211434758450119, 0.194314920245843, 0.155917732067514, 
0.210891633430313, -0.0139621054814886, 0.156261730328927, 0.541493011535352, 
0.203658642489826, 0.444327588518472, 0.257415325555902, 0.472466641395783, 
0.349075995073354, 0.201571937158519, 0.321445387751820, 0.224415417921881, 
0.563907522485407, 0.288935712176635, 0.419369043378312, 0.379180989297082, 
0.21863939973358, 0.198731039648665, 0.120450939810844, 0.52455331147799, 
0.191754484291318, 0.745347080763713, 0.410922940839728, 0.175666042369606, 
0.234150822799187, 0.295053333639516, 0.409791830225929, 0.223298666048486, 
0.268898349349387, 0.263484156075285, 0.257783253725412, 0.176661832896425, 
0.346533914267933, 0.28495414773788, 0.440214615331768, 0.215326015182276, 
0.304604780021593, 0.364671847020097, 0.406277082332501, 0.125833725042868, 
0.033329126528068, 0.280834825890412, 0.107797747395545, 0.272225758932510, 
0.583175253842971, 0.725738761176094, 0.205783279600139, 0.359694366837547, 
0.200602271059956, 0.136333388708786, 0.460859222344155, 0.283781936608337, 
0.419458565712622, 0.560211474114847, 0.402517152363705, 0.324377716326781, 
0.165279349670365, 0.221954490045255, 0.310150380199004, 0.374115064503126, 
0.339816007020593, 0.200059511766966, 0.418934658285294, -0.0793634500582894, 
0.502610139088198, 0.474559222690669, 0.371625263785434, 0.407550445307967, 
0.371346001666964, 0.470411831457014, 0.250394247912812, 0.327061465788819, 
0.616166160190205, 0.0221926801529494, 0.00284363843237704, 0.136593644734519, 
0.82760482069681, 0.0965564980618002, 0.586364766441035, 0.425112302545781, 
0.407472352655999, 0.371087749011275, 0.434089132296226, 0.597719908912266, 
0.445460955911177, 0.520172307113416, 0.179660402635268, 0.560118111337525, 
0.362713254542496, 0.508796744899872, 0.352718533084265, 0.310211012178538, 
0.494655871234581, 0.260187970389018, 0.450674900166631, 0.801209708592214, 
0.429640029637361, 0.999999499931694, 0.665044238122611, 0.684158600917508, 
0.999997063734631, 0.784981763954522, 0.618833587677164, 0.658394878401983, 
0.478753104404246, 0.42416410658666, 0.718239287733526, 0.601105249914196, 
0.825098647506522, 0.764337726960848, 0.999999654333088, 0.644638450134631, 
0.760206838738723, 0.589087918715934, 0.728195229931297, 0.577034473972067, 
0.640107387980471, 0.692575659124755, 0.844707070051144, 0.999999499241162, 
0.667212897791377, 0.712315695118166, 0.586033230171492, 0.498050791917579, 
0.999999535403144, 0.81186231805206, 0.666051517248535, 0.999981983547965, 
0.837656586614579, 0.50621736950254, 0.75632316762467, 0.489020289562775, 
0.639244491827142, 0.822471576399403, 0.751783965712462, 0.363229487412541, 
0.999999506365186, 0.456565820252651, 0.64006055837005, 0.6523363995795, 
0.634456771656642, 0.807676644191664, 0.55906663365952, 0.650194775158104, 
0.637075062243015, 0.512939734297691, 0.393804759863924, 0.511486604599499, 
0.588575253187339, 0.439850458318918, 0.999999444996237, 0.74798958775217, 
0.557895513232597, 0.608865799000551, 0.594439266014532, 0.9999940100121, 
0.675070613889674, 0.561884556739217, 0.822866446985046, 0.572046444564632, 
0.733828312735513, 0.745966029175872, 0.397504120442332, 0.516511355579594, 
0.594657844737673, 0.637776178091442, 0.734718953009999, 0.556619929651742, 
0.454850046174637, 0.61663951543973, 0.599327274997636, 0.337603478029858, 
0.509941944019935, 0.76380604085513, 0.680142631258762, 0.473420422487827, 
0.64818107001519, 0.405843928437501, 0.63299871144904, 0.576309964129572, 
0.999999505529841, 0.75686367954618, 0.30717745507542, 0.602966609709532, 
0.713236669081523, 0.641979134655818, 0.698893166555807, 0.395284777335494, 
0.627079019367666, 0.633012861026986, 0.99999892918315, 0.999999454407193, 
0.571044841294456, 0.569582339878106, 0.504553267279501, 0.577531761424502, 
0.631602562143183, 0.84668334572137, 0.602570417426055, 0.803061166662962, 
0.572550998895914, 0.561226983843265, 0.795460942661814, 0.689639364764599, 
0.4401202375308, 0.585055041360408, 0.905278697756792, 0.597512743901594, 
0.99999950013309, 0.99999949610136, 0.599904122617068, 0.403142062427872, 
0.999999511033107, 0.999999542665886, 0.691165128965268, 0.632080528191555, 
0.999999969127794, 0.494679028133829, 0.64393858306275, 0.618188901785072, 
0.530228694910752, 0.680241893829391, 0.699785025594112, 0.84817466160968, 
0.0680724303841276, 0.87980734104196, 0.425578418437781, 0.747050902500746, 
0.508699601765755, 0.513886022506783, 0.709971148880314, 0.745545880461217, 
0.999999662539506, 0.616022095004008, 0.359570292006622, 0.999999499624286, 
0.74666006090698, 0.678864771886995, 0.553923209280134, 0.694596405021496, 
0.710139419340025, 0.56134088840211, 0.676595633610805, 0.496743374338506, 
0.750971469734801, 0.533209974555614, 0.642854119342844, 0.620914452794045, 
0.727286685278975, 0.465350358974177, 0.790911944572139, 0.538832730283292, 
0.58483794842352, 0.588791797533311, 0.533298966380433, 0.713209084745968, 
0.825634810529029, 0.816708077762539, 0.546327355711857, 0.642079050324599, 
0.749937787889126, 0.610142315375568, 0.400856028950523, 0.494223589250369, 
0.524163692015529, 0.617517363895931, 0.999956770929533, 0.740478623404648, 
0.448879505549688, 0.870696885499073, 0.659375402033178, 0.669313613419158, 
0.856680603792263, 0.75359885435735, 0.831537996971876, 0.567560394119814, 
0.469698406515603, 0.999999500004712, 0.857617940226455, 0.617334884137122, 
0.470826204169028, 0.600587116419836, 0.666119076231143, 0.759692116785432, 
0.722173756036716, 0.502944968841463, 0.497035209015796, 0.676245483526304, 
0.582514098543867, 0.499718612949476, 0.741743801004739, 0.999999654552547, 
0.615956195526267, 0.590230848582396, 0.999999518470018, 0.680774286095612, 
0.557767286263383, 0.641929700760675, 0.554848053369572, 0.666224681308946, 
0.66402631865197, 0.398404405688658, 0.471062416006259, 0.75165560622566, 
0.662309795554818, 0.614558047197697, 0.999999564288874, 0.580455892451541, 
0.707217666578175, 0.71422691634896, 0.866141688112249, 0.663432510479305, 
0.792189904292433, 0.999999498376317, 0.521471536402221, 0.51750905935331, 
0.567169729918811, 0.999999703932263, 0.426924595550496, 0.820342743701609, 
0.99999949668228, 0.562141037073434, 0.820757056168278, 0.739850491184132, 
0.53239279865081, 0.591264595333486, 0.511979203119731, 0.99999949970839, 
0.999999500042353, 0.70629218273787, 0.453254005948068, 0.495750592749726, 
0.999993549274725, 0.999998237825466, 0.557250206885391, 0.594635474039727, 
0.840502062696915, 0.618116348977682, 0.617189549829727, 0.563948163203419, 
0.470126131814243, 0.999999512268527, 0.538396424771684, 0.999999734530848, 
0.616731115252906, 0.576053669186174, 0.613211669169388, 0.706518575127805, 
0.692344514591955, 0.561522173202324, 0.683320519331327, 0.762527880175794, 
0.589446549807583, 0.754222366994219, 0.716936067305917, 0.999998887043367, 
0.565481151852314, 0.656781845632587, 0.489497932746346, 0.999999509905608, 
0.626176813101933, 0.514451873501468, 0.484307706250205, 0.696597137382727, 
0.704150248425238, 0.713776048710347, 0.601389600783051, 0.99999949963195, 
0.73545634317277, 0.999999521385232, 0.680935236045024, 0.467665048037443, 
0.647693172627604, 0.676373878151884, 0.681851607966713, 0.557956371422997, 
0.644417870360792, 0.643472200647173, 0.620867351606034, 0.548272481259229, 
0.999998442105364, 0.704507049784583, 0.69564398012257, 0.99999954588784, 
0.9999995249554, 0.65663621598114, 0.685966442523091, 0.999999465069116, 
0.787280462322497, 0.611957684242156, 0.66214521298306, 0.999999664539005, 
0.521545304376557, 0.90082049681662, 0.362717595076237, 0.48527080947822, 
0.999997100731661, 0.705427386991392, 0.758393634460186, 0.669134486326798, 
0.699911083751159, 0.886924741253214, 0.99999927307383, 0.65482511595365, 
0.785257595023626, 0.898968265439594, 0.714634884663442, 0.815702057922091, 
0.605292607741778, 0.731967710217365, 0.730649168200202, 0.657233906364514, 
0.400338799690094, 0.677818129880984, 0.777886862246653, 0.532483995487453, 
0.352427015164713, 0.834260922621856, 0.69656580442706, 0.834154752442301, 
0.497475987622878, 0.543594224881666, 0.382104195481393, 0.596553632880523, 
0.71978351253526, 0.999998162551135, 0.622702392467882, 0.536399107244312, 
0.656825155661559, 0.642692033718221, 0.705658130451273, 0.999999592969542, 
0.624694343220275, 0.507697054070548, 0.761289706596444, 0.595961896725085, 
0.792800900572012, 0.635395704514386, 0.274937310884268, 0.704670988952649, 
0.605163083293339, 0.51575236537643, 0.642616041935458, 0.448062439424992, 
0.538826516141734, 0.651785407477201, 0.622335886990961, 0.732254825275353, 
0.7965228446492, 0.481984768411337, 0.548977793232592, 0.506392322200778, 
0.588205767853397, 0.688359214341478, 0.447638883573410, 0.610695146670748, 
0.671273075786892, 0.675606589940351, 0.423208519027543, 0.423777591670634, 
0.644359205056618, 0.999999500491625, 0.595791477207823, 0.67149244809449, 
0.707725096263874, 0.99999956475776, 0.54330091329745, 0.498614873546942, 
0.623422487952805, 0.620319714387977, 0.578281544530300, 0.643019443152151, 
0.747419750123751, 0.999999499822618, 0.999999823358304, 0.758060649514755, 
0.508751714832712, 0.67664142201777, 0.461365759338568, 0.646896617353319, 
0.630744815029612, 0.70338477587054, 0.570464169706632, 0.579670928576932, 
0.498416916203267, 0.494823776876366, 0.723725247193365, 0.72045589217481, 
0.596111944123058, 0.736636298120513, 0.578087947693753, 0.688993784002241, 
0.618870637195991, 0.753710940337548, 0.520217339938717, 0.8899459790525, 
0.737962658295634, 0.61452906205616, 0.622692224040699, 0.419020728456749, 
0.600358554722753, 0.692391858663616, 0.84450470076551, 0.676919279927384, 
0.478170501373129, 0.788932341201498, 0.999999491878028, 0.573745045137719, 
0.499807033925821, 0.530538879777865, 0.9999994999348, 0.999999860059204, 
0.9999995057633, 0.543069820107764, 0.59680664091529, 0.578491519028893, 
0.450855910062226, 0.587323146633067, 0.999999499915643, 0.860297656375733, 
0.479411701248960, 0.575712174183965, 0.544248087182362, 0.565528358487429, 
0.999966324661698, 0.61078682837087, 0.605377361630796, 0.598394547457735, 
0.511147678194184, 0.643380506635168, 0.648848103203302, 0.70437319835431, 
0.553553789437946, 0.999999520347132, 0.685771660597825, 0.443332040502677, 
0.490617547617876, 0.756213324435328, 0.525996209098385, 0.329938987554010, 
0.669503333362302, 0.650937533782966, 0.548792683829091, 0.462590530915632, 
0.53469555223297, 0.539545066226883, 0.496296966348584, 0.686016860291025, 
0.76362167306139, 0.99999985196215, 0.642922380959083, 0.729138927752578, 
0.77046454116756, 0.654494435418298, 0.999999500110682, 0.604430605508677, 
0.999999524085345, 0.676506794922139, 0.646840287897852, 0.618512980580755, 
0.735896930611606, 0.999999501559808, 0.687403795284236, 0.688432150774651, 
0.694741306860429, 0.562217772247376, 0.586301707731476, 0.523962926184214, 
0.488486272365815, 0.643922411137177, 0.53290158786045, 0.681236807059416, 
0.561022298698231, 0.70171200661366, 0.499638477052953, 0.727573439209578, 
0.802341804891482, 0.999981695743786, 0.696495756697528, 0.597903966053245, 
0.557390680667957, 0.596252274106638, 0.65638618049054, 0.424591898783784, 
0.68619144711489, 0.664943487586357, 0.747609494178817, 0.999999508480634, 
0.529416811983446, 0.497078631161433, 0.727300733098266, 0.99999972069626, 
0.99999965933082, 0.3373906807867, 0.99999971592042, 0.664534303028819, 
0.632149590250308, 0.613948234131565, 0.590941967600704, 0.657368187156534, 
0.999999499924716, 0.410374116471725, 0.836242331993413, 0.655101914575021, 
0.783470673815966, 0.60954923981186, 0.86657915787562, 0.671490561897892, 
0.664654895549503, 0.68749913506732, 0.761363917479266, 0.999999509734572, 
0.693742000751732, 0.601376288395287, 0.713820857073262, 0.999999501903711, 
0.575204370239943, 0.999999490197022, 0.99999950012405, 0.778794350128931, 
0.50933953009242, 0.999999500107222, 0.519385175847248, 0.593385816523045, 
0.99999950210557, 0.55855696640066, 0.372692011638612, 0.807112326518249, 
0.6315173947832, 0.643673866712318, 0.99999997094412, 0.646230735642263, 
0.684409368060205, 0.468810482069113, 0.439128272327075, 0.315996094286162, 
0.641793311728385, 0.581067845845355, 0.614117470101057, 0.999993784042288, 
0.681867389297246, 0.654417076850905, 0.60414446462739, 0.657910992333853, 
0.8251692695855, 0.692546231562209, 0.571025284972612, 0.782167286040118, 
0.725680165755767, 0.999999504662571, 0.999999773058767, 0.418896334281344, 
0.999999500096794, 0.596935316521368, 0.579947744911611, 0.765087026981943, 
0.528833453096503, 0.617645074075574, 0.529292167053002, 0.597717826845008, 
0.749307219257925, 0.746063959250917, 0.576284124968728, 0.549759383466953, 
0.660861024968465, 0.999997167226681, 0.777852199295211, 0.567335000661152, 
0.660038611856812, 0.624731028624944, 0.831339120026198, 0.561927980179987, 
0.677103993657398, 0.605320355838815, 0.459930488870309, 0.582659631021361, 
0.999999497300233, 0.572971000544587, 0.719595809515346, 0.99999948842652, 
0.619456257410285, 0.999999478360638, 0.548241398247953, 0.29634526192294, 
0.99999949999792, 0.812295078972533, 0.726098736959143, 0.806618493143898, 
0.580272583874017, 0.999999511797993, 0.99990945103184, 0.693980110551028, 
0.799666990345418, 0.851156712060564, 0.633808335151418, 0.604435153055409, 
0.404316419629934, 0.499008001378722, 0.774042190103816, 0.611773531543715, 
0.72758437493262, 0.550610519866395, 0.513932084373258, 0.260633036580294, 
0.717510242413537, 0.665046998511014, 0.572039330185652, 0.999945107930904, 
0.749096315127118, 0.550604846103782, 0.58110765172922, 0.636115832322657, 
0.71179999454995, 0.782907046456264, 0.580720888009959, 0.999999989015148, 
0.886071767163862, 0.999999683017475, 0.719986753755583, 0.595989581006127, 
0.999999142099888, 0.747918608757781, 0.726578658213582, 0.640713081215099, 
0.594144098753598, 0.66791915981635, 0.475537539054742, 0.84571280400091, 
0.645101295451699, 0.719611620257514, 0.601727695080002, 0.660857837455915, 
0.759803246648524, 0.827032782067486, 0.815749459057794, 0.629233273464965, 
0.403142479067139, 0.579956704791806, 0.56137798140531, 0.545594982271068, 
0.741410940045373, 0.559794205113687, 0.616152680272208, 0.99999988845861, 
0.30365556606421, 0.493548275592727, 0.999999458895791, 0.676365677231561, 
0.634888011939501, 0.790234273433374, 0.676667542347138, 0.875291060580001, 
0.410374163890308, 0.538614426316174, 0.999999879209258, 0.637545411899867, 
0.834227511794925, 0.808059140266177, 0.754702514032755, 0.794167867670625, 
0.286800013204994, 0.934402835075576, 0.626608861512299, 0.384476434021968, 
0.663651689592233, 0.651471153624059, 0.999999480762282, 0.99999964320491, 
0.268175305342487, 0.337757268464056, 0.377104238736954, 0.556862711131389, 
0.526008854895845, 0.71965143477504, 0.471889547631362, 0.999999500528143, 
0.665221225436807, 0.68237715748692, 0.298841705624075, 0.588678805520619, 
0.676629725614142, 0.99999950255592, 0.632956348017883, 0.583683103633838, 
0.499920702797239, 0.442223226284368, 0.999999739217329, 0.782069064247379, 
0.661363833277796, 0.999993095713952, 0.659543249192215, 0.999999522752892, 
0.382401064429318, 0.626383964432981, 0.555983822753005, 0.65891962310179, 
0.556078374257649, 0.680500655482675, 0.762451251147902, 0.31473204023765, 
0.743908034074181, 0.999999429600064, 0.753930588394772, 0.653067777272856, 
0.361391157328605, 0.706577406953673, 0.999999500804414, 0.375476949587018, 
0.556491709048084, 0.63632284776226, 0.504440926738434, 0.613278744995278, 
0.999999427296491, 0.691284684427378, 0.523606725279547, 0.501794947118035, 
0.702544762397473, 0.493635723842653, 0.772203703377886, 0.824990983397694, 
0.99999714285797, 0.646601772991655, 0.643986512602976, 0.498462576020887, 
0.63831615515952, 0.622342438565358, 0.660152975733819, 0.377975227229656, 
0.999999438869708, 0.999998719143599, 0.635414615794116, 0.403014428311221, 
0.569443971920569, 0.777160372858633, 0.389656657736598, 0.999999496237623, 
0.53330431783132, 0.999999512170736, 0.490837666723721, 0.581153785892454, 
0.441665322245056, 0.999999500142747, 0.822190478238033, 0.378795469481211, 
0.506466003135089, 0.854208713843394, 0.617486847049604, 0.681014421237136, 
0.698825357162072, 0.843801404806761, 0.604374335301952, 0.440366728984561, 
0.614710470783485, 0.70719630692197, 0.693138794271533, 0.588102421018101, 
0.53749018913728, 0.891742599894444, 0.815210457690255, 0.495331707275683, 
0.618300691334120, 0.58454317610401, 0.841584987448996, 0.43558256644928, 
0.754003525386938, 0.541230061841403, 0.581090276959979, 0.682401747912627, 
0.558962838806608, 0.585172955025397, 0.99999944660612, 0.491009822713261, 
0.451817130736124, 0.456705246634138, 0.999999539068455, 0.384916980320869, 
0.67587396485085, 0.799530851739768, 0.67326346072773, 0.770372699204656, 
0.622670814623469, 0.605513796118721, 0.61414838872408, 0.661736459470539, 
0.999999588564281, 0.339964880570501, 0.589355737868704, 0.623673897845333, 
0.751096758496615, 0.7517276297587, 0.677887003954901, 0.634853958960307, 
0.741707056198927, 0.692488508517179, 0.697694953128507, 0.613609720699111, 
0.824820064202767, 0.66139679338374, 0.641720997763603, 0.719175210418006, 
0.698242511945901, 0.529163793505316, 0.77157786700043, 0.625651423552582, 
0.634963616110537, 0.782941115663657, 0.683478041889, 0.695563671620054, 
0.600797256837024, 0.74572587460046, 0.999999434248754, 0.99998925235792, 
0.58668625286852, 0.588236710410516, 0.999999497929427, 0.999999950614269, 
0.583732065024297, 0.999999167752261, 0.64575540447936, 0.597255482858236, 
0.682324810160694, 0.534780881921408, 0.428220964546496, 0.265410595104563, 
0.765213330960446, 0.558768548386334, 0.647780743089907, 0.70659205022751, 
0.799478623167094, 0.566856610463472, 0.620886070339103, 0.602260401424071, 
0.565324109445957, 0.541190794666083, 0.99999941110093, 0.72739425595822, 
0.617240436645996, 0.633441797971035, 0.482320734192106, 0.792241569169906, 
0.759696138229284, 0.589416604019987, 0.525956570345416, 0.698443146571035, 
0.663689476739174, 0.561361078037059, 0.582408351917332, 0.583878545580187, 
0.999999402004142, 0.646823146760721, 0.668287778174462, 0.63223202150684, 
0.664656582439161, 0.467542666137123, 0.58933465896628, 0.726772048446553, 
0.767601974831721, 0.590195349449417, 0.491111823127236, 0.682197016563376, 
0.371963235857283, 0.685212321197704, 0.999999391934163, 0.530446217438956, 
0.560847770521999, 0.480428541852566, 0.636058903332176, 0.454461064567422, 
0.750462878306705, 0.9999994988375, 0.669129732131037, 0.519203418482536, 
0.782764849555775, 0.746314197207812, 0.613102128895575, 0.999999691275235, 
0.727370750233080, 0.636423048868907, 0.796641970980153, 0.854616309797833, 
0.804206779156619, 0.78452802646262, 0.618233932223494, 0.541788925907452, 
0.718967399224451, 0.777459100767415, 0.99999953118138, 0.609657906111369, 
0.999988873091437, 0.607075052134564, 0.668040042672629, 0.54579101579214, 
0.567419230391092, 0.417502021826865, 0.55420620938668, 0.56071213839427, 
0.834195163189214, 0.623515719829943, 0.839255284849531, 0.728735680675964, 
0.482739962065048, 0.999999509001585, 0.999999501906712, 0.999999619739677, 
0.466165703451935, 0.704725544985766, 0.742977723953804, 0.551197089491416, 
0.520216041898622, 0.638288701419706, 0.758334077457192, 0.496202314900265, 
0.595017055300846, 0.697950989501774, 0.661230021143911, 0.623877850946418, 
0.457468876169049, 0.759527282877048, 0.677000532625408, 0.640699436020023, 
0.762899305998857, 0.739033101509766, 0.570969137247023, 0.571612859515853, 
0.999999544527692, 0.427719288699935, 0.833259847044457, 0.622602105628009, 
0.732108979896825, 0.608283220038785, 0.437120708209617, 0.664037697330402, 
0.999991465479307, 0.999999079636607, 0.554016144492349, 0.664850251462138, 
0.682290821157568, 0.679001032157081, 0.657559977024126, 0.336838983212512, 
0.678474057551301, 0.7060545581495, 0.696428417726387, 0.683625373800017, 
0.762190070991504, 0.629737955757531, 0.848250306902429, 0.560134889660355, 
0.654639146626225, 0.728248616365961, 0.999999533365948, 0.322288659952998, 
0.462393187839364, 0.517911906162551, 0.768856037442718, 0.485494299362862, 
0.709156690925964, 0.466392358117292, 0.567639717951138, 0.999997748010296, 
0.999999474800921, 0.459902541816616, 0.610323775675756, 0.99999950008305, 
0.843933457208106, 0.532620950718693, 0.999997815207945, 0.669345895128952, 
0.5066013307371, 0.723392911623305, 0.557287254464638, 0.656370739832641, 
0.610600752457347, 0.882126604855534, 0.3340767206294, 0.734133156049903, 
0.999999998594825, 0.999999518809406, 0.6484491346282, 0.333068090023287, 
0.524141603774874, 0.742681790619041, 0.999995178986697, 0.999999847753016, 
0.869624374722134, 0.393781108306551, 0.507926180778311, 0.442180490040309, 
0.426097700057798, 0.706748055622183, 0.808009132094323, 0.999999375618193, 
0.556601954681278, 0.73937792249, 0.99996900504655, 0.99999831114719, 
0.82548808636188, 0.999994487114308, 0.9999996931012, 0.999999520267321, 
0.999999503080945, 0.999999569669483, 0.999999789199107, 0.999999500408018, 
0.99999889317096, 0.999999909446854, 0.9999994970704, 0.999999500273277, 
0.999999457716484, 0.999999521087193, 0.999999112016804, 0.999999623832157, 
0.999999535069062, 0.999999500166508, 0.999988870364188, 0.999994974869072, 
0.865624321236162, 0.99999721420347, 0.999999454336103, 0.999993114545968, 
0.99999950596463, 0.999999807581172, 0.99999950430932, 0.788282416609027, 
0.99999996771036, 0.999999501206592, 0.916400810009351, 0.999999499995637, 
0.999999504069068, 0.99999949592344, 0.81860738053251, 0.999999500975235, 
0.99999952760651, 0.99998225748653, 0.999999494737873, 0.999995144971434, 
0.999999523679009, 0.999999519873107, 0.999999635341533, 0.999999502931717, 
0.999999319006022, 0.999999566953092, 0.999999491916042, 0.999999498824921, 
0.999993342783605, 0.999999931594085, 0.999995984390158, 0.999999514365295, 
0.99999948350804, 0.999999499916101, 0.809755463953672, 0.999999598663925, 
0.999999508006742, 0.999993911081643, 0.999999539837736, 0.999998770216043, 
0.999884751301388, 0.99999953774747, 0.999999507251063, 0.99999952496998, 
0.99999952764955, 0.999999555753577, 0.999999449330838, 0.99998922631839, 
0.999999483485617, 0.999999502824472, 0.99999937093759, 0.999834002862167, 
0.999999467917892, 0.999999502821394, 0.847879989689916, 0.999999500198763, 
0.701022679364019, 0.843836082757844, 0.999999505504243, 0.999999501736919, 
0.999999498684502, 0.999999500220817, 0.99999943459346, 0.99999475183865, 
0.72548088890434, 0.897701526243818, 0.999999474638445, 0.99999960408255, 
0.999996163836878, 0.999999602801734, 0.999999611719083, 0.999999566270126, 
0.999999500154133, 0.999996904363776, 0.99999954609553, 0.99999996763146, 
0.999999970188117, 0.999999427621443, 0.99999954348855, 0.999998901942345, 
0.999999652530748, 0.999999500313407, 0.999999600375585, 0.784443013999919, 
0.999999500994241, 0.99999950467139, 0.81194062061408, 0.999999569330504, 
0.999999573942371, 0.999997766941734, 0.999999154710248, 0.999999514980951, 
0.999999918369473, 0.999999572089188, 0.999999463111756, 0.999999607206094, 
0.999999523752728, 0.999999713829804, 0.999999658868944, 0.999999502875235, 
0.85669769782287, 0.999999519561673, 0.999999592999006, 0.99999949067026, 
0.999999500841817, 0.999999495316219, 0.999999500651463, 0.999999407448489, 
0.999999498631827, 0.999999501266125, 0.999999565145719, 0.999999574043547, 
0.761150593229854, 0.999999501434194, 0.999993754632724, 0.99999955594594, 
0.99999971629614, 0.816347193283575, 0.90088924339656, 0.999999543300311, 
0.999999500106597, 0.999999508662874, 0.808962648877801, 0.999998162488185, 
0.999999499164845, 0.999999478422867, 0.99997942725997, 0.999999499425067, 
0.999998189781508, 0.999999511737007, 0.999991114342474, 0.999999500209573, 
0.848156000955865, 0.99999950077117, 0.99999949085001, 0.999999666278775, 
0.999999481871157, 0.999999452046574, 0.999999488076792, 0.999999501372115, 
0.99999958075505, 0.83999306537194, 0.999998640938226, 0.999999537220102, 
0.9999994998839, 0.999999520550317, 0.999999503480354, 0.999999495512837, 
0.999999558685419, 0.99999949970354, 0.999999265375397, 0.756655478942771, 
0.999998637039902, 0.802375808091892, 0.999999848237447, 0.999999442032938, 
0.999998863447108, 0.999999485043872, 0.999999560743134, 0.999999197087902, 
0.999999648106141, 0.999997207778816, 0.643147506528829, 0.781040239312189, 
0.8215921629945, 0.999999460078707, 0.999999536797354, 0.999999499407568, 
0.999999640192652, 0.999998900376709, 0.999999451226314, 0.99999949856757, 
0.999999498220396, 0.999999572453746, 0.999999492515206, 0.817063836877555, 
0.99999943506649, 0.99999947768564, 0.999998410525182, 0.999999500152037, 
0.999992765935543, 0.99999950786753, 0.999998690938314, 0.999999502762542, 
0.999999509396287, 0.999999502901136, 0.999998573431348, 0.999999509745532, 
0.81559235825147, 0.999999049093976, 0.999996756210066, 0.825984146231929, 
0.700803562250921, 0.9177857912222, 0.99999950910265, 0.99999965875259, 
0.99998699317911, 0.751096675731921, 0.99999950065848, 0.999999390322989, 
0.999999500001552, 0.999999507258964, 0.891643306907344, 0.999999565867179, 
0.790803590781748, 0.99999378328838, 0.999999864433697, 0.999999578092847, 
0.99999566519934, 0.999995868409113, 0.999999499247272, 0.999999941432119, 
0.999999511372743, 0.99999950437475, 0.999999408183348, 0.999999999085307, 
0.758239299666126, 0.999999883909062, 0.999999593766268, 0.99999950013863, 
0.999999546719295, 0.99999910897107, 0.999999557840472, 0.87356901456668, 
0.999999493298473, 0.873866861331282, 0.999999662654677, 0.841998507622537, 
0.99998643967116, 0.999999499524635, 0.999999645298748, 0.99999953834271, 
0.99999999935541, 0.999999639082381, 0.999973755182808, 0.99999959548938, 
0.999999683132146, 0.999999499702695, 0.999998597003797, 0.999999431388116, 
0.999999499521702, 0.999999540378605, 0.797774765533077, 0.756507536365974, 
0.999999586176679, 0.999999469500565, 0.999999604500246, 0.999999499587473, 
0.81880616230432, 0.9999995189668, 0.999999474621961, 0.999999163005885, 
0.999999499884072, 0.862768903414916, 0.911878312185807, 0.999999562690412, 
0.99999999507614, 0.99999878251112, 0.99999950000096, 0.999999480490293, 
0.999995190710275, 0.999999697075792, 0.999999511757762, 0.999999821249233, 
0.897759640948166, 0.99999950786316, 0.99999952133588, 0.844605166106844, 
0.999999567981534, 0.999999481814098, 0.99997691023357, 0.99999777765176, 
0.999999597991955, 0.999999496934952, 0.999999501493847, 0.999999509528637, 
0.999810995026544, 0.99999950149206, 0.999999389111368, 0.999964338990515, 
0.999998553537717, 0.999999492160057, 0.999995859762125, 0.873937897813467, 
0.999999491175132, 0.9999999869033, 0.99999610199712, 0.999998918055852, 
0.811360594559406, 0.999999522668235, 0.999999512955184, 0.999985589175334, 
0.999999721454023, 0.999999502374903, 0.999999821626821, 0.999999503579532, 
0.776403530375391, 0.999999499750108, 0.999999370688006, 0.841215901451503, 
0.999986981107003, 0.999999852427133, 0.893264206738485, 0.999999559599813, 
0.999999528468097, 0.8108987248296, 0.747368432288653, 0.999998080020094, 
0.99999950118027, 0.999999499901552, 0.999999501285376, 0.99999606685358, 
0.999999708427928, 0.999997383179146, 0.99999947929008, 0.687115346410576, 
0.999999760486518, 0.999999501892878, 0.853703443102952, 0.999999452899618, 
0.999999500849244, 0.99999950332431, 0.999999478943936, 0.999999715509778, 
0.999999730636058, 0.846146652854977, 0.99999958623968, 0.99999950215568, 
0.999999500024529, 0.999999504224928, 0.999999500057208, 0.999999191754546, 
0.999999501996566, 0.999998447769789, 0.999999159550547, 0.999998587606642, 
0.99999933369764, 0.76419389709129, 0.872492404339085, 0.84391497427864, 
0.999999817114543, 0.999999961043688, 0.999999447019864, 0.999999757037314, 
0.99999997716179, 0.999999512493647, 0.999999783395776, 0.99999938121582, 
0.752857543245098, 0.999999468553842, 0.999999501690977, 0.827886134024155, 
0.999999495862603, 0.999998344944847, 0.999999938493145, 0.99999805491789, 
0.803992740584484, 0.99999839377254, 0.999999495757442, 0.999999800881962, 
0.999999504371993, 0.999999567283817, 0.709348674234789, 0.999998231408268, 
0.999999499917627, 0.999999511394168, 0.999999496718184, 0.999999501652218, 
0.696616484746378, 0.834779000574295, 0.999998976500037, 0.999993569103263, 
0.999988648252693, 0.99999949096475, 0.99999950920342, 0.999999884104754, 
0.999999512230405, 0.785988085185598, 0.999999497793447, 0.999999504483942, 
0.999997511988163, 0.9999989629088, 0.999988300090395, 0.906324975037922, 
0.999999504783032, 0.99999949993528, 0.999999673652499, 0.797517297286452, 
0.999999485425073, 0.99998999943032, 0.999999545873248, 0.999978801301231, 
0.905937988537845, 0.78455563324495, 0.999999507094663, 0.999999537922266, 
0.890344230627935, 0.846108975465317, 0.999999500318937, 0.999999558776464, 
0.999999510185828, 0.999997528208882, 0.999999537741302, 0.862179429838338, 
0.740971541267934, 0.999999499713034, 0.999999446164523, 0.999999538723637, 
0.999999485217237, 0.999999505361697, 0.9999993077397, 0.999999511488004, 
0.999998036472515, 0.999999495891315, 0.800741785821149, 0.750320834283425, 
0.999999409995222, 0.846766743675817, 0.999999500328516, 0.999998627120896, 
0.999999491849412, 0.999999498647896, 0.999994804320295, 0.999999500980987, 
0.999999501234461, 0.999999502008757, 0.771506280599084, 0.999999509839412, 
0.999999518482797, 0.999983679162114, 0.843254522661103, 0.893502954056771, 
0.999999119599487, 0.999999277345939, 0.999998628678057, 0.999970628735649, 
0.99999950066677, 0.999999496251495, 0.999998865608998, 0.99999942101743, 
0.999999509847692, 0.99999956524647, 0.9999992705292, 0.99999950453769, 
0.763079067060857, 0.779338981453611, 0.999999500150837, 0.924451246347407, 
0.999999609877883, 0.999993596510944, 0.99999993096966, 0.999999500992776, 
0.999999541163463, 0.99999950456512, 0.999998573196265, 0.824288098748579, 
0.57877462295562, 0.712522417095925, 0.99999883408704, 0.899956963689006, 
0.879059056177266, 0.99999880643769, 0.999999589298032, 0.999992408286605, 
0.999999775601559, 0.999999827891345, 0.99999946087686, 0.999999499971397, 
0.862388026696814, 0.999999597405345, 0.999999517120302, 0.999999389756436, 
0.999999501672897, 0.999999750047436, 0.735171153530679, 0.999999500028343, 
0.999999651907598, 0.999999489908481, 0.99999948199883, 0.999999687615666, 
0.999999599268672, 0.99999949856379, 0.999999480562234, 0.999999700719093, 
0.999990950413566, 0.999999525831193, 0.999999536416604, 0.821516280280801, 
0.999998905841082, 0.999999494488038, 0.817439843965848, 0.99999950041946, 
0.99999941540901, 0.999999495835252, 0.999999485565011, 0.99999955125958, 
0.802389108007268, 0.99999950085201, 0.999999774043335, 0.999999482255907, 
0.99999955264236, 0.99999954181112, 0.99999949671621, 0.99999955759674, 
0.999999494099601, 0.999999500155254, 0.99999545669667, 0.99999996193028, 
0.999996218036694, 0.78675960809043, 0.880838665256282, 0.999999996864403, 
0.999999486873719, 0.881025197149956, 0.999999932947905, 0.73310524977659, 
0.77555829734073, 0.99999934584539, 0.999999483388022, 0.999999500816916, 
0.9999996199645, 0.9999995012933, 0.999999262255945, 0.999999488729992, 
0.999999932161202, 0.99999950806605, 0.818572062848385, 0.999999960474758, 
0.999997617205014, 0.999999814343477, 0.999999648540414, 0.884572196560649, 
0.999999529444025, 0.999989323750623, 0.999999490998373, 0.99999946896935, 
0.99999951898037, 0.999937482521096, 0.767693238808593, 0.99999950736546, 
0.512647129139623, 0.999999746790014, 0.862934920284302, 0.999999500629786, 
0.871196455814705, 0.99999950090679, 0.999999657892466, 0.999999678952995, 
0.999999582738373, 0.999999846783422, 0.99999949948884, 0.999994441316994, 
0.999999468639051, 0.99999939030402, 0.999999470194231, 0.999998348795914, 
0.999999518572237, 0.99999942442699, 0.999999501736466, 0.99999950010776, 
0.999999618361058, 0.999999541897598, 0.999999500003816, 0.999999183521794, 
0.999999501284984, 0.99999693899702, 0.999999501740718, 0.999999490980445, 
0.999999536747815, 0.99999931836857, 0.999994863253342, 0.99999935984888, 
0.999953342492912, 0.999999504377381, 0.999999622970697, 0.999995135758854, 
0.771973306230134, 0.99999879861856, 0.99999991900938, 0.999999501389676, 
0.99999950022923, 0.999999500004971, 0.999999509195915, 0.99999949935756, 
0.999999503604092, 0.999999500606325, 0.999999065943357, 0.999999068873097, 
0.999999498507447, 0.683204331399925, 0.999998019058077, 0.99999950118337, 
0.801698944495968, 0.999999649866915, 0.99999961408766, 0.999999587978478, 
0.865953726419786, 0.867708659945049, 0.99999952408371, 0.99999715376429, 
0.999999497098754, 0.780435247957944, 0.999999521820308, 0.999999461185968, 
0.999999718509138, 0.999990079625463, 0.999999511359743, 0.999996773960413, 
0.715511330063399, 0.999999510687683, 0.999999643161391, 0.999997593706207, 
0.999999502121398, 0.999997992981768, 0.879481073368532, 0.999983631680497, 
0.99999954626585, 0.999999675300069, 0.999999494931867, 0.999999498514003, 
0.999999350772824, 0.999999510352621, 0.999989921613186, 0.999984157188085, 
0.879998299341444, 0.681025301731926, 0.999999432360495, 0.999996775158208, 
0.999999511363027, 0.999999360464722, 0.999999542068176, 0.99999961237778, 
0.999999497941874, 0.99999932930885, 0.999999896758472, 0.99984748536777, 
0.999999500037395, 0.999999668552577, 0.999999502656518, 0.999999643377052, 
0.999999459900264, 0.999999506135334, 0.999996739301438, 0.99999949969999, 
0.999999585152995, 0.999999512083044, 0.999999617146542, 0.999978429366244, 
0.999999517404121, 0.999999500168926, 0.863215921006908, 0.999999618942057, 
0.999999487683607, 0.99999954358296, 0.999997441889715, 0.999999630354368, 
0.999960575834897, 0.999999499988125, 0.999999520399286, 0.999999324744603, 
0.999999501901459, 0.999999981180996, 0.999992724379175, 0.99999950045796, 
0.999999500008949, 0.99999949999693, 0.999999505112823, 0.999997343020268, 
0.779987097850586, 0.999999496900444, 0.999999493559916, 0.999971179351479, 
0.999999525297855, 0.999942181489255, 0.877013203060317, 0.999999306454045, 
0.99997239371065, 0.999999576738571, 0.743238261027503, 0.999999540934496, 
0.999995141920947, 0.900744335836001, 0.913434921439499, 0.999999504976187, 
0.999999392459744, 0.999999501182877, 0.999998380179975, 0.99999950955088, 
0.999999294750708, 0.999995869495046, 0.999998611052268, 0.99999993736636, 
0.870197408061898, 0.99998778296427, 0.999999924276792, 0.99999948988532, 
0.999999583533522, 0.99990636146905, 0.999994170370357, 0.999999518759874, 
0.999999491396645, 0.999999521689633, 0.99999968925778, 0.99999950263776, 
0.890387647138938, 0.99999957300033, 0.999999512800088, 0.999999236367915, 
0.99999968623087, 0.999999660382301, 0.999999655736239, 0.999999085518268, 
0.999999123330761, 0.999999310438497, 0.999999516541582, 0.999999499904836, 
0.645258482307814, 0.99999950086635, 0.999996571248569, 0.999999470836746, 
0.832223241193444, 0.999999984175597, 0.811521087735006, 0.999999500164064, 
0.999999499238293, 0.99999948566349, 0.999998185076104, 0.99999930463147, 
0.769707133591955, 0.263869895211314, 0.999999499516971, 0.999999496093994, 
0.999999679741524, 0.999999499635432, 0.72954459477085, 0.99999751530983, 
0.999999525225394, 0.99999955530911, 0.999999500208742, 0.999999525384992, 
0.999999499916806, 0.999999505571025, 0.99999973489445, 0.762972439616471, 
0.999999982213818, 0.999999767745284, 0.999999500562644, 0.999999086828236, 
0.999999501768081, 0.999999613675264, 0.999999499772849, 0.999999478802618, 
0.999999350410246, 0.999999506127214, 0.99999931986588, 0.999999499242361, 
0.99999942159618, 0.793608065007242, 0.844048522095194, 0.793461274738628, 
0.999999510157887, 0.999999495994265, 0.99999989549444, 0.999999880350958, 
0.999999265876237, 0.999998652300336, 0.999961447637328, 0.999999459655551, 
0.99999946945095, 0.999999523059488, 0.861117554371337, 0.999999497925911, 
0.999999500316163, 0.719776037327257, 0.999999539823668, 0.99999949994797, 
0.999999499826394, 0.999999529960983, 0.880585176589636, 0.790592650498482, 
0.999999498464956, 0.99999947387932, 0.99999987719742, 0.999999439944706, 
0.999999515748521, 0.999999499735632, 0.999999599906663, 0.99999950097742, 
0.999999678177637, 0.999999493545823, 0.744677744006866, 0.999999599588479, 
0.99999944500729, 0.876826700028939, 0.868416655449189, 0.999999501728116, 
0.999999487183476, 0.999999814727854, 0.999973610371578, 0.999999500393163, 
0.99999969926909, 0.9999881205083, 0.999999498794263, 0.999999490583849, 
0.549487374162168, 0.99999950503712, 0.699449058690265, 0.999999534837816, 
0.999999503285329, 0.999999503584243, 0.999998571224814, 0.999999852446326, 
0.87903022305224, 0.999999475137818, 0.99999949998196, 0.999999496650536, 
0.999999498462198, 0.999999492312693, 0.999999501575574, 0.999999500121074, 
0.999999521002409, 0.776030334606177, 0.853598661005643, 0.999999984065034, 
0.999999501065633, 0.999999500693413, 0.999999573357936, 0.999999470001184, 
0.999999506383647, 0.999999039370284, 0.999998254191516, 0.999993744071306, 
0.999999473687568, 0.999998807458337, 0.99999950027968, 0.999999567037623, 
0.999999527525258, 0.999999504471078, 0.999999590832704, 0.999998036261172, 
0.999999948054742, 0.999999500601803, 0.999999507081095, 0.999999515591234, 
0.999999521993362, 0.999999491956418, 0.999999494822475, 0.999999524570184, 
0.99999958928618, 0.9999989096875, 0.999999777852861, 0.999999524135295, 
0.730376559162732, 0.999999957493344, 0.999998474316133, 0.99998728562607, 
0.887717999790627, 0.99999985568695, 0.99999950266207, 0.999999509576139, 
0.99999982651016, 0.999999507198405, 0.802582355789594, 0.999999504999713, 
0.999999501123536, 0.999974480679895, 0.999999513957363, 0.999999930119132, 
0.999995520625094, 0.999997586087076, 0.99999965267763, 0.999992660525658, 
0.999999526787176, 0.999999505286297, 0.999999456912811, 0.999999364814307, 
0.99996726265813, 0.99999440404628, 0.999999534687792, 0.999997143191064, 
0.92031584152633, 0.999999420354572, 0.999999643510837, 0.999999505515653, 
0.912155369201508, 0.999999500003254, 0.999999784738325, 0.999999509444048, 
0.999999879869137, 0.999999499491528, 0.999999659558156, 0.999999499999578, 
0.999990879928927, 0.999999549157568, 0.99999942516381, 0.550847367428795, 
0.855635655097003, 0.99999941438553, 0.999999516934051, 0.999999501129415, 
0.999999511812702, 0.99996828353659, 0.837788349686533, 0.999999499303436, 
0.999998653023352, 0.999999698820494, 0.83468667234067, 0.762040980852295, 
0.999999499900115, 0.999999504399116, 0.99999949886943, 0.999999528709405, 
0.999999500785842, 0.999999967699162, 0.99999972743588, 0.999999748355635, 
0.999999490762909, 0.99999950087047, 0.999999509712296, 0.999992687181016, 
0.999979282033966, 0.999999499569258, 0.999999500979452, 0.999999478324925, 
0.999997302979695, 0.99996886394136, 0.999999586266666, 0.85293543063739, 
0.999999499096721, 0.99999950997147, 0.999999468482315, 0.999999500605456, 
0.99999949944324, 0.999999500049386, 0.999999502096712, 0.999999510881589, 
0.999997556115714, 0.999999499281585, 0.999999605719106, 0.999999498118078, 
0.999999499877793, 0.99999949624007, 0.999999900962962, 0.999999517987668, 
0.999999500880774, 0.999807114476818, 0.99999950960763, 0.677715368655008, 
0.99999952177644, 0.999999498984884, 0.99999946865003, 0.999995758472985, 
0.999997025079396, 0.999999637023997, 0.999999594952318, 0.99999950168994, 
0.999999491049154, 0.999998061480172, 0.999999669522165, 0.99999950009681, 
0.797575132660113, 0.999999533383666, 0.999999500019749, 0.99997725094906, 
0.999985841245287, 0.999997540137721, 0.999999503890478, 0.999999783769436, 
0.999998214863166, 0.999999530142706, 0.999994487464339, 0.999999500146552, 
0.999999500055153, 0.999976511544745, 0.999999517063215, 0.999999501330095, 
0.999999502678793, 0.999982415029347, 0.999983735382768, 0.999999507494401, 
0.999999549452214, 0.999998680397068, 0.999977437925209, 0.999999569425174, 
0.999999503345673, 0.999999517616145, 0.999999534388375, 0.999996822400196, 
0.999999657285754, 0.999999500092764, 0.999995651284787, 0.7839838602847, 
0.999999534235904, 0.999969113117502, 0.999999520615839, 0.999999363572106, 
0.999999994816175, 0.999999469088673, 0.999999504257686, 0.999999415438554, 
0.99999958082896, 0.999999503086349, 0.99999950009013, 0.999994835788202, 
0.999999499713019, 0.999999556063028, 0.999999499231211, 0.99999955580861, 
0.999999500912038, 0.999999499737694, 0.999999506881275, 0.999999623483224, 
0.999989447269625, 0.999999500112315, 0.999999736468319, 0.999999667575887, 
0.999999484192445, 0.99999950092816, 0.99999956110578, 0.999999495235388, 
0.999999500604757, 0.999999447810709, 0.999999498958332, 0.99999971748249, 
0.999999498870465, 0.999999448269222, 0.999998846019736, 0.999999092861131, 
0.999998221262667, 0.999994948763471, 0.999999499688545, 0.999999501888656, 
0.999999507222458, 0.999999592964954, 0.999999499952187, 0.99999950176903, 
0.999999470528122, 0.89195814354808, 0.999999611368877, 0.999996523337162, 
0.999999500360406, 0.999997476684721, 0.999999925819308, 0.999994045256837, 
0.99999951066418, 0.99999956566996, 0.999999504420968, 0.9999992418295, 
0.999999858644978, 0.999989149718956, 0.999945360703087, 0.99999945642986, 
0.99999949997894, 0.999998792040515, 0.999999505550889, 0.999999510285169, 
0.99999950912019, 0.999999492052988, 0.799921145451588, 0.9999978285334, 
0.999999504660612, 0.999999492564386, 0.999999540101099, 0.99999949343574, 
0.999998420401349, 0.99999944441488, 0.99999950153485, 0.999999787546286, 
0.999999500783504, 0.999999500069449, 0.999999503881513, 0.999999503215713, 
0.999999557318133, 0.999999907841706, 0.999999852805965, 0.999999422102792, 
0.999999504368424, 0.999999933297013, 0.999998732366028, 0.99999545419069, 
0.999999527351826, 0.999961371821225, 0.999999499957063, 0.99999946476705, 
0.99999952079547, 0.999999717039516, 0.999999504826982, 0.999997746311008, 
0.663150211674445, 0.99999950003833, 0.999999462988074, 0.99999950016621, 
0.999891382165858, 0.99999950322806, 0.999999316006043, 0.999999513242708, 
0.9999990154472, 0.999999598100175, 0.999985252454315, 0.999999586035738, 
0.999999525165928, 0.999990311268418, 0.999999524035506, 0.999999495029208, 
0.999999767778212, 0.999999374029109, 0.999999503676398, 0.999970367477858, 
0.999998812829207, 0.999999497131693, 0.999999499998872, 0.999999708898282, 
0.99999950709275, 0.99999953043781, 0.999998819710652, 0.999999501177213, 
0.999999498218026, 0.99999958889435, 0.999999651464353, 0.99999950001376, 
0.999999656790142, 0.999999418067102, 0.999997464706476, 0.999999606863745, 
0.82723016982428, 0.999941802178798, 0.99999992409104, 0.99999934121784, 
0.99999990885812, 0.999999534005601, 0.999999500973502, 0.84605085524386, 
0.999997843320143, 0.9999995339024, 0.844867027005731, 0.999999503110896, 
0.999999935430236, 0.999998049071367, 0.999996960448692, 0.874027284729832, 
0.999999503378887, 0.999984593507636, 0.999997812136017, 0.999999742211937, 
0.999999808211575, 0.99999953423043, 0.999999500442233, 0.999999173579215, 
0.999985496031391, 0.99999954287098, 0.999999583520949, 0.999999497802582, 
0.99999947193918, 0.999999500964216, 0.999994452530003, 0.999996200605046, 
0.999987563847942, 0.999999500532426, 0.999999994038654, 0.99999963375981, 
0.999996862930083, 0.99999993733469, 0.999999393852528, 0.999999494916542, 
0.999999581208005, 0.999998895441882, 0.999999494886121, 0.999987098600183, 
0.99999950464143, 0.999998921175924, 0.9999993290555, 0.999999544133762, 
0.999998782844379, 0.99999950009808, 0.999989512451937, 0.999999434110584, 
0.99999944342309, 0.99999964134402, 0.9999913041628, 0.99999950053008, 
0.999999515811876, 0.999987657780142, 0.999999488029111, 0.999999430113086, 
0.999996246866176, 0.944339784244323, 0.999999841484006, 0.999999536715308, 
0.999999467706941, 0.999999487929786, 0.99999948097618, 0.999999496716395, 
0.640439175355979, 0.99997753633958, 0.999999499517475, 0.999999688624994, 
0.999999137102439, 0.999991661229399, 0.999999562942922, 0.999999502177602, 
0.999998993392405, 0.999946846108503, 0.999999507958033, 0.772633366221156, 
0.999968048924243, 0.999994075058405, 0.999999470196066, 0.874541245250201, 
0.999949586016036, 0.999999500518945, 0.999999502337078, 0.999994322570506, 
0.99999941400743, 0.999999315679174, 0.999998233031143, 0.999999505031281, 
0.99999950215047, 0.99999958091902, 0.99999945158566, 0.999999507027464, 
0.99999947694756, 0.999999500334494, 0.999988498388845, 0.999999500338939, 
0.999999495011718, 0.99999949510402, 0.99999950009431, 0.999997084717299, 
0.999999505419715, 0.999999514772418, 0.999999535183152, 0.790304974908825, 
0.999999493089393, 0.99999891883836, 0.999992187191525, 0.999999554777952, 
0.9999976713546, 0.851353661291921, 0.999999513130496, 0.999997376620768, 
0.999997788842494, 0.999998777076923, 0.99999946620005, 0.99999958847723, 
0.999996858777017, 0.999999500343666, 0.999999499790867, 0.999999583984772, 
0.999998679161604, 0.999999505453158, 0.999991651636195, 0.999999500353366, 
0.999999503044635, 0.999999478674612, 0.999999496765968, 0.999999500294476, 
0.999999508442818, 0.99999950010302, 0.99999946008052, 0.999999382324292, 
0.99999901328659, 0.999999506672038, 0.999999537065087, 0.999999499654063, 
0.999999619529337, 0.999999540572928, 0.999999952776955, 0.999999704141691, 
0.999999448505732, 0.999999717676975, 0.999999624370406, 0.999911391511704, 
0.999999503314737, 0.999999375475636, 0.999999499961845, 0.999999574878851, 
0.999999496857419, 0.999998898593601, 0.999999499028292, 0.99999949478963, 
0.999999484441684, 0.999999535757304, 0.999999507811786, 0.999999500624234, 
0.999996224563492, 0.99999951761429, 0.999999649347824, 0.99999981095945, 
0.999999504812525, 0.999999525002452, 0.999999179976027, 0.798297259951993, 
0.999999074580893, 0.999996763034775, 0.778603357482408, 0.999999410658908, 
0.999998683070033, 0.999999524969338, 0.999999503053402, 0.999998204670481, 
0.999975533748907, 0.999998406113687, 0.99999948134666, 0.999999527373152, 
0.999998394337636, 0.99999938558922, 0.999999523929907, 0.99999952337524, 
0.99999949989069, 0.999999499993816, 0.999999560231714, 0.999994469269424, 
0.999999499315844, 0.999999500006638, 0.999997619758594, 0.999998467240001, 
0.999999711350628, 0.999999824265787, 0.999999697322056, 0.999999492387403, 
0.99999950014855, 0.99999964536269, 0.999999499986525, 0.999999820739201, 
0.822623676377645, 0.99999983462142, 0.999999847317883, 0.9999994919628, 
0.999999917738424, 0.999999295774357, 0.999991532581476, 0.99999972955689, 
0.999998783335002, 0.999999938756174, 0.99999950274434, 0.999999501013306, 
0.907491459392735, 0.999999499690362, 0.999999812390734, 0.9999989204256, 
0.999999873607715, 0.999999555264425, 0.99999949844766, 0.999999568067665, 
0.999980815848185, 0.999999502053506, 0.999999517421192, 0.99999130578202, 
0.99999954113768, 0.999989771522003, 0.999999352917926, 0.999997583946172, 
0.710886167704557, 0.999999737483083, 0.843142691643776, 0.999999500401658, 
0.999996363947135, 0.999999500537064, 0.999999499750196, 0.999999512494975, 
0.999928029952196, 0.999999516401004, 0.999999504808797, 0.999999672994757, 
0.999999483133323, 0.999999501934123, 0.999999521284278, 0.999999479864168, 
0.99999950254478, 0.9999994912354, 0.999999495174496, 0.999999485682203, 
0.999992129081744, 0.999999547551083, 0.99999949119351, 0.999999499685358, 
0.999999496821805, 0.999999513493566, 0.99999409160793, 0.999999495060154, 
0.999999559209787, 0.99999932264811, 0.999999502195628, 0.999999583108558, 
0.99999954264412, 0.999999481668633, 0.999999521492051, 0.999999633922315, 
0.999995081039827, 0.892658498105284, 0.999999527179975, 0.99999971489469, 
0.999979156238187, 0.999999495414748, 0.999993761998264, 0.999999696493777, 
0.999970346629582, 0.999999873149492, 0.999999582379233, 0.999997563482117, 
0.999999535247894, 0.999999496006617, 0.999999502589266, 0.99999981821143, 
0.999999584540025, 0.999992745841125, 0.999999691616854, 0.9999995006866, 
0.999958430430373, 0.999999516794184, 0.99999944934588, 0.99999786759948, 
0.999999485048188, 0.9999994920692, 0.999999544411966, 0.999999497825706, 
0.99999959217309, 0.999999499805212, 0.999998824252423, 0.999998416089149, 
0.999999542108, 0.99999951241645, 0.999999499249613, 0.999999404915037, 
0.99999948328939, 0.999999481777782, 0.999999670814619, 0.999999793249022, 
0.999999534897623, 0.999997768017766, 0.999999501907255, 0.999999693931048, 
0.999999534030725, 0.999999602297252, 0.999999569651002, 0.999999506853364, 
0.999999362851388, 0.999999506561286, 0.999998446426162, 0.999999225359583, 
0.883948979362708, 0.999999501818213, 0.999999690143015, 0.999996612164668, 
0.999999505414057, 0.999999570274169, 0.99999960534207, 0.999969712384476, 
0.99999950056437, 0.999999863971233, 0.999999495144236, 0.999999961997322, 
0.999999449604759, 0.999999490690156, 0.99999899962455, 0.999999500131556, 
0.99999951009545, 0.999999499977874, 0.999999501418583, 0.999999625058442, 
0.99999936799494, 0.999998623109701, 0.999999655411268, 0.999999494598428, 
0.999999078533757, 0.999999460407176, 0.999996091876228, 0.99999938262531, 
0.999999587379918, 0.999999565723646, 0.999999503746272, 0.99999950432616, 
0.999907147673831, 0.999999499375604, 0.99999883700619, 0.9999995271387, 
0.999998868880158, 0.99998470641519, 0.99999708129773, 0.999991146652133, 
0.99999920659404, 0.999977640032576, 0.99999949835493, 0.999999500089209, 
0.766693595484014, 0.999999501494481, 0.999999532305383, 0.999999861987783, 
0.895923115399378, 0.99999188982426, 0.99999949971146, 0.999999603934727, 
0.999999254535565, 0.999999534434193, 0.999947602060421, 0.879508017844666, 
0.772808933795056, 0.99999949697374, 0.99999952802437, 0.999999275199864, 
0.999969100055095, 0.999999509957821, 0.999999493284273, 0.999999504037447, 
0.999999505566196, 0.99999950146051, 0.999999502141815, 0.999999499367403, 
0.999999500602055, 0.999999460994143, 0.999999499505073, 0.999999501447382, 
0.999999507506779, 0.999999455347159, 0.999999649034886, 0.999999200438935, 
0.9999994964792, 0.999999968616164, 0.999999502192108, 0.99999840097658, 
0.999999510848149, 0.999970846075751, 0.999999523163993, 0.999999491354259, 
0.999998073818138, 0.999999513678403, 0.999990306042849, 0.999999506920323, 
0.999999642590982, 0.999999498169789, 0.999999504356575, 0.999997540605514, 
0.999999922515232, 0.999999502189657, 0.999997322509965, 0.999999500167487, 
0.760448439228675, 0.999999503593465, 0.999999517136836, 0.99998173008053, 
0.999998991147767, 0.999999469129654, 0.786243179148387, 0.999999500022922, 
0.999999500364061, 0.999999498483816, 0.999999457626312, 0.99999951097744, 
0.999996279983296, 0.99999921584252, 0.999999500262271, 0.999999397113428, 
0.999999485357792, 0.999999500002017, 0.999999503102262, 0.999999504470855, 
0.999999895894307, 0.999999483299095, 0.9999995253832, 0.999993570481828, 
0.999998598268825, 0.999999515167176, 0.999999490271021, 0.999999001135108, 
0.999999426971399, 0.99999100911737, 0.999999998803752, 0.99999950038865, 
0.999929120765661, 0.999998355402012, 0.999999600436684, 0.999999521402569, 
0.999997901113527, 0.999999572488038, 0.9999969321899, 0.999885565345028, 
0.999999561186967, 0.999999511246305, 0.999999450434053, 0.804867688648097, 
0.999999485056762, 0.9999882089871, 0.999999949737767, 0.999999503722427, 
0.999999554194223, 0.999999500257142, 0.99999983456223, 0.794300632812616, 
0.999999500009358, 0.999999445104999, 0.999999507894323, 0.999999517983442, 
0.999999969596286, 0.999999862723165, 0.9999998748912, 0.999999982400517, 
0.99999950208058, 0.999999140939388, 0.999999878636146, 0.999999708505126, 
0.999999547756929, 0.999999460841672, 0.9999995394763, 0.99999574161852, 
0.999999706309881, 0.999999443858757, 0.999991169470053, 0.759019585525836, 
0.999999512816127, 0.999999694287771, 0.999999540234145, 0.999983466002232, 
0.999999151453743, 0.99999954518787, 0.999989374097746, 0.999999500571906, 
0.999999410437325, 0.999999510647588, 0.999999511905779, 0.999999372838448, 
0.999999481898678, 0.999999496671767, 0.999999447685796, 0.999999244356487, 
0.876067085054534, 0.999987183158905, 0.999999287159936, 0.999999542867804, 
0.999999527871045, 0.999989890936879, 0.999975608998933, 0.916125991247968, 
0.999999519883236, 0.999999597459954, 0.999999500495025, 0.999999500939359, 
0.99999969757719, 0.999999251467878, 0.784581357446343, 0.99999949908561, 
0.999983531689248, 0.999999860049326, 0.999999502149236, 0.999999524938493, 
0.999999500194983, 0.999999589794862, 0.999986912673712, 0.999999513684832, 
0.99999954743996, 0.99999949896144, 0.999957203144875, 0.999999502797524, 
0.99999950003435, 0.999999486873074, 0.999999595508858, 0.99997950532885, 
0.999999513938075, 0.999999933548388, 0.99999813835374, 0.999999690653416, 
0.999998977443968, 0.99996638180937, 0.999999341554338, 0.99999952105573, 
0.999999397352974, 0.854933513323562, 0.999999499198906, 0.999999500552896, 
0.9999994999651, 0.999999506670597, 0.999999499589793, 0.999999536757899, 
0.741733320139548, 0.999999314454705, 0.999999484303643, 0.845675728247518, 
0.999999605389548, 0.9999995348629, 0.999999499985738, 0.79250828734126, 
0.999999499986301, 0.938517869569322, 0.999997376684427, 0.999999500219624, 
0.999999529691023, 0.999999504205147, 0.999999461590785, 0.999999536558708, 
0.999999505509322, 0.999999760304145, 0.999999500479143, 0.99999951941243, 
0.897266880165902, 0.999999576421936, 0.999999497645182, 0.99999949990095, 
0.999999503515609, 0.999999497669842, 0.999999519116017, 0.999999599039966, 
0.999999549786442, 0.999995920045758, 0.999999873632481, 0.999999500154147, 
0.999999501440308, 0.999999138354055, 0.999999688654377, 0.999999500153129, 
0.999999934689613, 0.999999500815287, 0.999999929524532, 0.999995027146675, 
0.999999414987099, 0.99999950121738, 0.999999399721788, 0.999999634538334, 
0.809751888101418, 0.999999500452397, 0.999996965887475, 0.999999500037539, 
0.99999949655458, 0.999999484513482, 0.999999651119753, 0.999999510217617, 
0.891315691460079, 0.999999500031244, 0.999999916549567, 0.999999511421166, 
0.999999310424371, 0.999951375720094, 0.999999753456656, 0.999987403365173, 
0.99999955066277, 0.999999503242916, 0.99999948842449, 0.999999571039539, 
0.999999499934955, 0.999999501817011, 0.999999821405625, 0.99999961857512, 
0.999998226694413, 0.999992669163288, 0.999999513435715, 0.99999940038189, 
0.99999959151415, 0.999999499774243, 0.999999500005442, 0.99999949589331, 
0.999999503339049, 0.999999501140001, 0.999999499992568, 0.999999500418134, 
0.999999518974413, 0.999999315183566, 0.999999514408184, 0.999999498225154, 
0.99999939894895, 0.99999548932171, 0.999999484758413, 0.99999950774994, 
0.999999542369133, 0.999998432939047, 0.999999978087462, 0.999999500341494, 
0.999999500066203, 0.999998812796718, 0.999998172577595, 0.999999602346605, 
0.999999319548837, 0.895627963981868, 0.999999510889776, 0.999999501035592, 
0.999999497037539, 0.99999971375076, 0.999999470056122, 0.999998767474023, 
0.999999549096687, 0.99999950156438, 0.999999435850881, 0.999999616341033, 
0.999999500362588, 0.999999503684636, 0.999999156413762, 0.999999500544667, 
0.999999501290521, 0.999999499591852, 0.999999533902072, 0.999999495349206, 
0.999999618225606, 0.999999362313762, 0.999999299322986, 0.999999508065353, 
0.63014243662763, 0.999999495114323, 0.999999518260134, 0.999999689242815, 
0.999999500761099, 0.99999949528182, 0.999999519120434, 0.999984906527693, 
0.99999950027123, 0.999999532657177, 0.999999912099333, 0.999999699877013, 
0.999998726490302, 0.9999797912925, 0.99999976200571, 0.999991367634969, 
0.999956303182875, 0.999995444705378, 0.999999422689682, 0.99999950067311, 
0.999996646710132, 0.999999499933504, 0.835540313138776, 0.869521701001238, 
0.99998206112746, 0.999999499997743, 0.99999949011329, 0.999998979985805, 
0.999999510819472, 0.99999954075895, 0.999999500403315, 0.999984818258475, 
0.999999563450249, 0.999999552402742, 0.999999620385144, 0.999999368947397, 
0.999999453351196, 0.999993599639566, 0.999995468771669, 0.999999662189961, 
0.999995276323563, 0.999999524935365, 0.99999950257223, 0.541134249934612, 
0.999948388140264, 0.999996296484564, 0.999999547875016, 0.999980933095658, 
0.99999952849481, 0.999999836360212, 0.99999942898232, 0.999999532718866, 
0.999997893925436, 0.999995695071704, 0.99999997010354, 0.999999660857233, 
0.999999500384128, 0.999995235705956, 0.999999492611557, 0.999999603537508, 
0.99999952274757, 0.856725202768572, 0.999999478102542, 0.99999945657251, 
0.999999501600457, 0.999999556739493, 0.811035391971315, 0.999999500911821, 
0.999999505660384, 0.999988767836804, 0.999999513254473, 0.999999540088325, 
0.999999385261342, 0.99999958963128, 0.999999524278634, 0.999999499406618, 
0.999999503453483, 0.99999946147077, 0.999999452754729, 0.999972255074937, 
0.999999500000604, 0.999999507159668, 0.999999653691477, 0.999999427755852, 
0.999998615646736, 0.999999507235264, 0.999998802332765, 0.999999491486997, 
0.999999500111354, 0.999999491150703, 0.999999501490228, 0.99999990233704, 
0.999985880200497, 0.999999501238472, 0.999999499037375, 0.999970109759327, 
0.999999499983192, 0.99999953634716, 0.999999790354429, 0.999999543719358, 
0.902879350273506, 0.99999950040613, 0.99999894570612, 0.999967728071589, 
0.999999499996368, 0.9999960571631, 0.99999950209398, 0.897447097147768, 
0.999999513154643, 0.9999994572442, 0.999999793965216, 0.999999508561223, 
0.9999995071329, 0.999999512946714, 0.999999499684887, 0.99999940413026, 
0.999999504084286, 0.999999591323033, 0.999999520053384, 0.99999950012867, 
0.99999953707139, 0.999999504280843, 0.999999595730805, 0.99999993703872, 
0.904967146924805, 0.999999500359218, 0.999999385806535, 0.999999506088015, 
0.999999791962112, 0.99999950012314, 0.999999502942776, 0.99999959389813, 
0.99999951155074, 0.999999912270994, 0.999968317098218, 0.999999496267241, 
0.99998699393151, 0.99999947565222, 0.99999513958333, 0.999999503281208, 
0.767749599187818, 0.99999997722824, 0.99999967836139, 0.999999527364694, 
0.894798359701916, 0.99999988816467, 0.999999611099126, 0.999999594577128, 
0.999981692077695, 0.925919517310211, 0.99999923631605, 0.999999498049131, 
0.999999500314015, 0.999999515757965, 0.999999505876655, 0.999999500462937, 
0.999999529849764, 0.999999488922956, 0.999999551164247, 0.99999951224828, 
0.99996324212098, 0.999999576492401, 0.999999496523208, 0.999999502197017, 
0.999999498438474, 0.999999499313777, 0.999999503174333, 0.999999496836228, 
0.999999553143262, 0.99995224169036, 0.999999232816425, 0.999999485429224, 
0.999999498232573, 0.999999511656285, 0.99999950033034, 0.999999186587845, 
0.999999500591362, 0.999996510323324, 0.999999198220872, 0.999999924548582, 
0.999999868958966, 0.999955448623171, 0.999999577099485, 0.999999510972225, 
0.999997094846508, 0.999999541728823, -0.99999975787793, -0.997288611251614, 
-0.90898740302244, -0.999999632344432, -0.970532015957218, -0.999988228152896, 
-0.964994130725128, -0.986733798872272, -0.999999955709352, -0.949048692537554, 
-0.999999809481533, -0.99999970135537, -0.96627982637827, -0.999997338045246, 
-0.999999523316823, -0.967022171765966, -0.999999514204096, -0.965673193238468, 
-0.999999773744838, -0.999980152654256, -0.989028538503806, -0.987044605311336, 
-0.999999496080213, -0.978531064179036, -0.929733629352402, -0.999999731083726, 
-0.999999907507258, -0.99999934152202, -0.99999950819029, -0.99999963302109, 
-0.999999507970092, -0.999999862200828, -0.999998983161924, -0.992967173899704, 
-0.999997808591153, -0.9999999794613, -0.999999630976201, -0.999997073963039, 
-0.999998153361462, -0.999999995000222, -0.999999899708737, -0.999999596769032, 
-0.99999954987527, -0.99999983450513, -0.992252357208549, -0.999999632785033, 
-0.980435952229953, -0.977538983740156, -0.99999977943686, -0.999999566586332, 
-0.99999974196892, -0.99999747003604, -0.999999485257107, -0.945288435258255, 
-0.986493906940352, -0.977702874506196, -0.999999785575569, -0.99999965767281, 
-0.999999531867309, -0.999996984973082, -0.999999494795523, -0.999999544478204, 
-0.999999979670562, -0.927284003404917, -0.999999500164003, -0.999999599755845, 
-0.999999499232079, -0.893452032010313, -0.999999483851667, -0.97106843208071, 
-0.99999960986528, -0.953628260922704, -0.99998593227804, -0.999999435705087, 
-0.999999693440763, -0.946809120687396, -0.948837057878152, -0.99999965963277, 
-0.999999131841906, -0.999999487265818, -0.99997071534907, -0.999998627648998, 
-0.974686611531125, -0.918425846571255, -0.999999996459193, -0.981153569438673, 
-0.993385759625121, -0.999999875104593, -0.95721160174147, -0.99999974142405, 
-0.946161512387044, -0.903170557189987, -0.999999893584324, -0.999999503138932, 
-0.964097746162935, -0.999999929773094, -0.999999826242044, -0.999999958983359, 
-0.9999995716569, -0.99999996086401, -0.999988689983887, -0.999999722076451, 
-0.999999868534424, -0.999999798539793, -0.999998859068098, -0.999999341151872, 
-0.999999798791894, -0.999999925521664, -0.949989796945648, -0.999998436474636, 
-0.980700156931057, -0.942848459324157, -0.99999995518587, -0.999999696612046, 
-0.999999774958071, -0.999999637639695, -0.999999543354262, -0.928273863553871, 
-0.951101213541428, -0.999999894176006, -0.99980800661149, -0.999999444345311, 
-0.999999265534754, -0.999999476063276, -0.999999407098078, -0.99999992346391, 
-0.94804403996218, -0.991486167814893, -0.99999995940539, -0.99999983977074, 
-0.99999998005504, -0.999999542966825, -0.999999933678435, -0.99562067593518, 
-0.999999965167955, -0.94779385498068, -0.99999975937805, -0.953004813148923, 
-0.95341023145527, -0.99999929150777, -0.943180822986243, -0.999999969704165, 
-0.97945075804978, -0.974773866577138, -0.999999484769506, -0.999999709845036, 
-0.999999277019262, -0.999999977053706, -0.999997750793964, -0.98313833058124, 
-0.945605720315666, -0.999992799448346, -0.907184997398895, -0.999999362354967, 
-0.999999216179609, -0.999999505220005, -0.960572871153355, -0.99999979510307, 
-0.999999731188579, -0.855827244191718, -0.999999509974747, -0.973025106664387, 
-0.996065084404687, -0.969336531141162, -0.999999860835587, -0.99999950947439, 
-0.954075540710744, -0.999999753786606, -0.999999560374483, -0.969863451098346, 
-0.942025939038371, -0.999999985287879, -0.99999492965625, -0.916744751817553, 
-0.984885664196952, -0.999999444165101, -0.999999960124414, -0.999969297890792, 
-0.99999995870984, -0.999999029518955, -0.944567852138106, -0.974717227904353, 
-0.959985455425467, -0.96083842675213, -0.999999487475043, -0.999999524588725, 
-0.999999851367688, -0.99999173982671, -0.96282010425567, -0.994679359101836, 
-0.999999561351956, -0.999999968479065, -0.969675554084743, -0.982843646525797, 
-0.999999822922756, -0.99180601491023, -0.976348298815898, -0.999998194325531, 
-0.99438370771829, -0.999994549898902, -0.999999119193169, -0.999996431662385, 
-0.989947899570612, -0.999999320966437, -0.999999593498415, -0.999999508803938, 
-0.999999593102298, -0.999999357937979, -0.999999569125352, -0.967242145870895, 
-0.999999531702605, -0.99999988561795, -0.999999648469606, -0.999999592278719, 
-0.999999891294778, -0.986777651899597, -0.999999662455025, -0.999997496402536, 
-0.99999970802724, -0.99999973277695, -0.976370037692797, -0.999997696865386, 
-0.999999487805217, -0.99999988714407, -0.999999552628832, -0.932289974804208, 
-0.946069103065235, -0.999999767893298, -0.98198101508441, -0.895757173014781, 
-0.999957057993, -0.983217050945851, -0.963321321417356, -0.999999985154826, 
-0.9999994356966, -0.982679703603029, -0.99998935894545, -0.970934453607077, 
-0.91770881953332, -0.999999507929948, -0.999993223399503, -0.99999998034041, 
-0.999999479320866, -0.999999465118115, -0.93779349944984, -0.999996681958452, 
-0.999998796207634, -0.999997599393139, -0.95626852385831, -0.999999500141003, 
-0.999999503470653, -0.999999182706458, -0.968295108609877, -0.9295829280341, 
-0.999996038163782, -0.999999621325531, -0.99999981848489, -0.999999734916735, 
-0.999999984535743, -0.978033469000892, -0.99999957057428, -0.999999773156539, 
-0.882474181905833, -0.999998017611762, -0.999999618569498, -0.999999770019804, 
-0.957672173353483, -0.999999580917715, -0.97255658572605, -0.999999797537186, 
-0.945560941629125, -0.999999528607246, -0.999999420222758, -0.999999874752804, 
-0.978473251837674, -0.95476356940635, -0.999974236650565, -0.954909475058898, 
-0.999999499678063, -0.999999156272203, -0.948981454549692, -0.999997155456808, 
-0.999999602824599, -0.966389172228768, -0.9999988740535, -0.99999951188665, 
-0.999999500659744, -0.999999801992645, -0.999999536570802, -0.99999959672732, 
-0.999996332127082, -0.999998367247605, -0.999999892854712, -0.999999512028665, 
-0.965269561131038, -0.930000580023236, -0.999999643779926, -0.995144137837153, 
-0.993259868776468, -0.969551334425398, -0.999997973531859, -0.999999515938201, 
-0.999997637540226, -0.856436509775416, -0.959793191052363, -0.999999481138847, 
-0.999999560318078, -0.960811214891977, -0.944705779491383, -0.98184057549694, 
-0.929550772552563, -0.999999981582177, -0.999999903997645, -0.991135201424961, 
-0.999999455192063, -0.999999801755028, -0.999998241291574, -0.999999956689435, 
-0.999999724455888, -0.89702088601066, -0.999999705966013, -0.97507471462545, 
-0.999999166462026, -0.991026725503297, -0.907139823835253, -0.999999224365103, 
-0.999999302395451, -0.999999600995465, -0.999999513169867, -0.971850185186067, 
-0.999999531524115, -0.914707095923479, -0.99999969102185, -0.999998883259378, 
-0.970905024230986, -0.999999856769225, -0.999995101793528, -0.981267718576664, 
-0.97838153824258, -0.99999875995738, -0.999998410413105, -0.999999999353465, 
-0.999999685849756, -0.999999871481137, -0.962061899864959, -0.999999568154087, 
-0.999999817876654, -0.999999964377039, -0.850821984143603, -0.999999782366338, 
-0.962833869616435, -0.999999670180458, -0.956595521781956, -0.999999939280137, 
-0.999992055232605, -0.803334658379963, -0.99999968557822, -0.999999474749259, 
-0.999989646231657, -0.944661463836753, -0.958770161280205, -0.999998801544144, 
-0.999999593344364, -0.911409420239368, -0.952134659304407, -0.999999682871034, 
-0.999993396491716, -0.99999975961416, -0.999995836573346, -0.98691523818769, 
-0.999999030467147, -0.999999610495012, -0.999999508250848, -0.999999455112933, 
-0.93471358761429, -0.999990793955003, -0.999999909766152, -0.999998942064237, 
-0.999999554932447, -0.999956788829064, -0.947395554115903, -0.999989465499744, 
-0.999999729165554, -0.999998402195718, -0.999999637137226, -0.958827316551214, 
-0.967975771808568, -0.999999399734078, -0.970675924337248, -0.999999501690864, 
-0.941241828264124, -0.999998955240244, -0.999999317239494, -0.968749269325567, 
-0.901054347630853, -0.99999999672177, -0.97576592157079, -0.954790387128046, 
-0.99999879874937, -0.999999328487926, -0.981816078820305, -0.964468952762516, 
-0.915134337555827, -0.999999574045491, -0.999999501461747, -0.995288999347203, 
-0.999999851928343, -0.952028352808243, -0.999999900704078, -0.961097539526015, 
-0.999999925689395, -0.999999508172224, -0.911213403267353, -0.98747040029634, 
-0.999999558554812, -0.999999677217661, -0.999999415875005, -0.999999521059548, 
-0.947343751725858, -0.955531128737651, -0.999999743885603, -0.9999999533674, 
-0.999994853464228, -0.999997692302936, -0.999999512229481, -0.999999961291531, 
-0.94237586550926, -0.999958323849548, -0.962043262937376, -0.999999811812762, 
-0.999998502414479, -0.999999633816863, -0.974150470563458, -0.999986049354519, 
-0.999999500317709, -0.999999515142223, -0.964802797450912, -0.911443997956335, 
-0.948868943718744, -0.98492574533163, -0.999999690291957, -0.93302615707141, 
-0.995084150883905, -0.932535158800727, -0.930678789655872, -0.970721068030847, 
-0.999999542421855, -0.99999948417542, -0.986828270121037, -0.999999659907529, 
-0.969705416123365, -0.968423282090144, -0.999999609169003, -0.98112720857587, 
-0.969595442276793, -0.999999998810977, -0.972712649279102, -0.999999637427378, 
-0.999999893080747, -0.982907474254016, -0.991426812556551, -0.999999797136529, 
-0.99999951246917, -0.999997753758497, -0.999999651767278, -0.999999510313759, 
-0.999999775335133, -0.99999989886058, -0.999999040041325, -0.955071133740895, 
-0.999999516442908, -0.99999801292625, -0.999999955740456, -0.918091222719549, 
-0.993365338587932, -0.965562677470092, -0.99999958343586, -0.935188230284873, 
-0.999999708544392, -0.924113666007606, -0.962929507357792, -0.980765174552936, 
-0.989823392030806, -0.999999577666477, -0.999999878447295, -0.977410920229443, 
-0.999999969498045, -0.999999512706576, -0.999999491995199, -0.948956958435105, 
-0.999999430925966, -0.999999272394865, -0.999999680984664, -0.999999822238769, 
-0.999999871359173, -0.999999809777453, -0.999999937602792, -0.999998017267108, 
-0.99999971380734, -0.999999807073862, -0.999994073923966, -0.999999477410408, 
-0.999999461210988, -0.9999996012763, -0.968744572811163, -0.99999950934687, 
-0.999999510034107, -0.999999565431059, -0.983470925466945, -0.999999500027414, 
-0.999999832048985, -0.999999624949863, -0.977982243501066, -0.999999507082864, 
-0.977869155662664, -0.949985476631037, -0.913138793484195, -0.999999309318723, 
-0.99999993054287, -0.999999306469021, -0.99999947934019, -0.999999911241666, 
-0.999999884822601, -0.971194129867384, -0.989437350148016, -0.923979250390936, 
-0.99999967287775, -0.999994437088749, -0.981362590969871, -0.937566193270828, 
-0.99997242740159, -0.898756309925233, -0.999999396094895, -0.999998160381793, 
-0.999999848596192, -0.980641510070357, -0.99999974629091, -0.99999290446957, 
-0.970706725520043, -0.960502186391674, -0.999999674312385, -0.99999953036605, 
-0.999999535544974, -0.999998315132381, -0.99999939022711, -0.968092573351245, 
-0.999999514284788, -0.889908541284254, -0.964621653088531, -0.999999710153413, 
-0.999999900076926, -0.99999925939615, -0.99999950525112, -0.99998856779926, 
-0.959750095497409, -0.953374681148746, -0.999999912648213, -0.999999959695918, 
-0.93693060195906, -0.999999734997515, -0.999999992269676, -0.973455437789996, 
-0.954652753832922, -0.956974667614335, -0.96172805674285, -0.954030804853626, 
-0.999999603397076, -0.999990951448537, -0.999999630217198, -0.999999475872225, 
-0.999999551190395, -0.914148884911684, -0.98433957813101, -0.951241405922884, 
-0.971060352816738, -0.99999946619589, -0.978709146143425, -0.999999194108965, 
-0.999999687571288, -0.971318927329546, -0.975183547801093, -0.999999672066234, 
-0.97428854082108, -0.955861829206703, -0.999999979125044, -0.999995069893692, 
-0.99999974222741, -0.999999502498385, -0.961124074314927, -0.99999952006654, 
-0.975623061883716, -0.999998024104624, -0.985662934990184, -0.99999949212407, 
-0.999999394558002, -0.963056185707163, -0.969577537664738, -0.999999654372708, 
-0.999998157975396, -0.991191327363558, -0.999999534712458, -0.916044802862165, 
-0.999999822397129, -0.999999471336804, -0.970502327946078, -0.995732700492215, 
-0.955928591913569, -0.985294528290071, -0.999999788223831, -0.999954097003165, 
-0.99999902000235, -0.99999602443919, -0.999999824838162, -0.965018845407899, 
-0.999999804016511, -0.999999774945254, -0.999999481290763, -0.99999977151684, 
-0.999999826336265, -0.999999220349226, -0.982546521327268, -0.999999910886188, 
-0.983587402370845, -0.99999736879563, -0.999999592543145, -0.981747056700097, 
-0.976407346019645, -0.999994905389133, -0.999999954224443, -0.999999561795423, 
-0.999977482110537, -0.99999950393828, -0.999999808244794, -0.999995313050204, 
-0.99999977049051, -0.999999406131736, -0.999998580736656, -0.962949701331881, 
-0.999999880291538, -0.977689199915765, -0.999999750293092, -0.999999838670813, 
-0.999997104560215, -0.980878260872504, -0.999997081504581, -0.983588318051978, 
-0.967684684742062, -0.999999527073652, -0.991192435228948, -0.999999500868064, 
-0.999999898055258, -0.999991980279828, -0.999998055871593, -0.999999483127693, 
-0.999999501711002, -0.99999973816013, -0.94512031325843, -0.999999630276781, 
-0.970643863064715, -0.977548886868792, -0.976893484264043, -0.999999500099912, 
-0.9999998310043, -0.999995108578137, -0.999999983959538, -0.99999950120217, 
-0.999999603517356, -0.987565566701606, -0.999998408422323, -0.999994210991986, 
-0.999999795146233, -0.999999659064786, -0.999993133150783, -0.999999792841332, 
-0.952158067048922, -0.971067496312723, -0.965825357346052, -0.999999727829902, 
-0.999999884204733, -0.967137875072307, -0.98159170030067, -0.98094084533833, 
-0.999999913751813, -0.99999953489627, -0.999999453287264, -0.98896062667735, 
-0.999998036243877, -0.999999811090056, -0.99999784593715, -0.903731928259888, 
-0.99999984955019, -0.99999908584121, -0.961045667813747, -0.999999477726655, 
-0.999999500250458, -0.99999985095224, -0.999999623623138, -0.999999233715603, 
-0.999999674874894, -0.965500622644017, -0.984811475824746, -0.999998603910703, 
-0.999999599974748, -0.9999951879867, -0.982806582768339, -0.999993633980793, 
-0.967965831232655, -0.970794673139496, -0.99999326920458, -0.999997901478868, 
-0.99999982514758, -0.999999826357677, -0.99999979373606, -0.999998091041429, 
-0.999997177725735, -0.999998700198358, -0.999999770402507, -0.999996073809935, 
-0.999999845957287, -0.99999923305296, -0.999999823449516, -0.999999500789989, 
-0.972592148558605, -0.969368394702573, -0.968320112980655, -0.999990536292714, 
-0.984093974718724, -0.940036712742513, -0.999998086526855, -0.999999343267619, 
-0.999999759037674, -0.964131057188372, -0.94520043057455, -0.999994485477797, 
-0.99999998468103, -0.99999969470186, -0.999999510079264, -0.999999963752642, 
-0.993366126005644, -0.999999447565942, -0.984559001375631, -0.966260270728588, 
-0.999999758570407, -0.999999881483245, -0.960459784876262, -0.999993846020821, 
-0.999999505000497, -0.989073513454278, -0.99999955665661, -0.999999857789716, 
-0.999999503923672, -0.93267505000494, -0.954237200592853, -0.877908107780454, 
-0.895383924052791, -0.940427174516222, -0.892252323783504, -0.999999963021016, 
-0.98158118735269, -0.999999337047256, -0.973828547062806, -0.964100521812076, 
-0.999999593381127, -0.999937843186203, -0.926543567191847, -0.999999999630497, 
-0.958343693427891, -0.99999136994043, -0.999999508341135, -0.999998784048094, 
-0.999998398318622, -0.999996360921313, -0.999999026107778, -0.970103703433565, 
-0.902508008026697, -0.999999552560023, -0.999999696414534, -0.99999842960828, 
-0.999999403036608, -0.999998093758387, -0.999999671330874, -0.929186088831018, 
-0.99999950100109, -0.9999991535438, -0.958158105191681, -0.999997440444446, 
-0.910219722200228, -0.99999945181953, -0.999999438930975, -0.99999971422583, 
-0.99999981944221, -0.974562610269977, -0.999999496768778, -0.999999706135108, 
-0.95999289766993, -0.954995338058423, -0.999999511457096, -0.958508991490436, 
-0.99999959352261, -0.99999910515621, -0.99999866836569, -0.999999783018598, 
-0.976803866373087, -0.999999981180203, -0.99999998597683, -0.976864968989437, 
-0.99999978128433, -0.999999520595876, -0.999999552963039, -0.99999970145578, 
-0.99999998592449, -0.999999686153608, -0.964195730202882, -0.999999504514308, 
-0.891618658014033, -0.99999696144908, -0.999999956961956, -0.957926270528567, 
-0.999999370352695, -0.999999596259711, -0.99999994401339, -0.999999529066642, 
-0.98053665205425, -0.999999872875783, -0.960335496860065, -0.947202897753167, 
-0.945685838509738, -0.999999961165306, -0.937112794736495, -0.99999858562741, 
-0.990571812100687, -0.91146197496898, -0.963448899122034, -0.999999554620673, 
-0.999999259546999, -0.99999950640315, -0.999999501622926, -0.999999820856476, 
-0.961082131503247, -0.999999548506735, -0.963566289240595, -0.999999749928722, 
-0.970243672595647, -0.899919830258898, -0.991772499174688, -0.99999953591355, 
-0.999996779652821, -0.99999996861652, -0.999999493582274, -0.999999563149006, 
-0.99999973247926, -0.999993978517657, -0.991947672372548, -0.999998551120525, 
-0.948359883331421, -0.99999913806947, -0.999999741442791, -0.83369097465766, 
-0.999999510642563, -0.999999720886042, -0.946477228397732, -0.999999512363362, 
-0.999999924885154, -0.95721888400012, -0.999999949226813, -0.999998502004823, 
-0.999999973813496, -0.999999482480394, -0.999999897154553, -0.99999985916057, 
-0.999998212501721, -0.930928750163391, -0.99999997494, -0.99999955122543, 
-0.984802898389436, -0.999999911224432, -0.945550962031868, -0.973227754227, 
-0.954378922873048, -0.999992369930542, -0.973682117667873, -0.999999506607748, 
-0.968135164737858, -0.999999385803967, -0.99999951181541, -0.999999633486403, 
-0.974299052001287, -0.999999697271074, -0.979718955203455, -0.999999687035729, 
-0.905338480355402, -0.999999775327071, -0.978727640756742, -0.999999734997862, 
-0.999999515720381, -0.93051384528792, -0.999999974419853, -0.99998814819212, 
-0.999999488255923, -0.99999957140139, -0.995735056483598, -0.999998943312032, 
-0.978051906800087, -0.999999540161612, -0.999997413731981, -0.972507457763303, 
-0.999994139892768, -0.999999564455997, -0.999999839841532, -0.973888985579584, 
-0.999999661060349, -0.8773459492548, -0.999999835708282, -0.999999892809767, 
-0.953672976758896, -0.999999490634484, -0.999999740798007, -0.999999579763905, 
-0.999999877133593, -0.99999955710477, -0.999999778168513, -0.971315805299508, 
-0.972838225805768, -0.999999573031293, -0.99999973393619, -0.999999993167722, 
-0.999999513979996, -0.999993083456909, -0.977593448745628, -0.99999949987747, 
-0.974099077642607, -0.999999535917689, -0.999998791204736, -0.970149354123537, 
-0.975358385275986, -0.99999484604745, -0.979521562982544, -0.999999877235402, 
-0.96030810644338, -0.999999692702806, -0.999999677114928, -0.999999780229269, 
-0.989577748870236, -0.979213121019544, -0.999999834728678, -0.999999086652244, 
-0.99999943195902, -0.999999853760928, -0.97995063843437, -0.999999827889474, 
-0.98302394077992, -0.99999948737345, -0.972110332111713, -0.999999894193442, 
-0.999998853822364, -0.99998952848908, -0.99999919044496, -0.9999996533862, 
-0.701280286020869, -0.999998938748329, -0.999999899569958, -0.999999106909728, 
-0.999999529098106, -0.966429648522288, -0.999999846603845, -0.980811932188792, 
-0.867840295698909, -0.999999520845822, -0.999999895839342, -0.99999950366317, 
-0.959898627188985, -0.999999743867095, -0.999998981423274, -0.981726702729656, 
-0.999999457878393, -0.999998648424339, -0.999999570857105, -0.999995525992589, 
-0.999999602395433, -0.99999959271438, -0.9664698666849, -0.99999969603451, 
-0.999999476667426, -0.999999500672127, -0.982122040348688, -0.97864865808354, 
-0.988572772035968, -0.99999969522007, -0.916996019625139, -0.99531535261383, 
-0.999999619990978, -0.969492651304221, -0.999997658277271, -0.968954498778454, 
-0.999999591522457, -0.980934564119826, -0.999998383053927, -0.999998140773071, 
-0.999999889392358, -0.999999618616367, -0.948664833731556, -0.999999177431803, 
-0.92292607040693, -0.980607725943496, -0.928088350807466, -0.863280958233317, 
-0.99999970166817, -0.892359179945753, -0.972919466819081, -0.999999085280568, 
-0.950621735048385, -0.758972462910406, -0.781649195593866, -0.90872440676798, 
-0.913531691753101, -0.893996176629355, -0.913987200171687, -0.840235015042224, 
-0.84973100656888, -0.878118165437243, -0.855250956163405, -0.825652589694873, 
-0.866509021649497, -0.980577787269006, -0.9789535810007, -0.923792549598302, 
-0.9584268464997, -0.870624991418895, -0.820505636283946, -0.999999951321428, 
-0.856568721784042, -0.950391435385573, -0.9146188846549, -0.991574987792485, 
-0.97254713195571, -0.91296798373629, -0.908758045611081, -0.913023575057343, 
-0.999999611482181, -0.888711003925193, -0.877939808467529, -0.926914906708825, 
-0.914146541722015, -0.932543936874182, -0.89170006226042, -0.858675394792983, 
-0.930531292002881, -0.924857388494705, -0.969821650056417, -0.999999624724869, 
-0.927173691183468, -0.910457785469073, -0.957505426854175, -0.943051866019429, 
-0.899985338270417, -0.853700234318287, -0.939780940134974, -0.929942199889308, 
-0.900155819917227, -0.903109973986202, -0.90857026853943, -0.894111674635271, 
-0.952830132547493, -0.999999509294735, -0.871861456033001, -0.89521417697154, 
-0.907543168041479, -0.873602385411756, -0.960166134282434, -0.90687917453691, 
-0.900188513141385, -0.813587647935396, -0.913676082939785, -0.86980303671308, 
-0.887733552808096, -0.981758013857382, -0.863991975717893, -0.839470694125917, 
-0.890547641686326, -0.999999490730134, -0.92153163304472, -0.859837056480717, 
-0.86352651785622, -0.966871482430423, -0.751578116759878, -0.85530851535212, 
-0.771265240706104, -0.867926439222806, -0.92811014830197, -0.929655018267825, 
-0.987660824092773, -0.999999828700648, -0.966579540136347, -0.856826267327207, 
-0.903333886657315, -0.85846586525862, -0.934662205050896, -0.821197425728398, 
-0.934240433292203, -0.891686257217028, -0.9326065745246, -0.901320786247706, 
-0.932849200580396, -0.931005753408945, -0.914007444133613, -0.999999923570915, 
-0.903172559937485, -0.912020922449102, -0.907032670521543, -0.879454399658255, 
-0.887175995211559, -0.814571849592881, -0.928105159319957, -0.999999949441597, 
-0.911400268697495, -0.836533115943635, -0.917897180336972, -0.762467337157994, 
-0.900276949320091, -0.761635420352326, -0.898280604261892, -0.958317676724329, 
-0.953336786804893, -0.924381662274606, -0.689640644726458, -0.793222158407724, 
-0.92119611976805, -0.893279975690696, -0.916408427504931, -0.846137015297334, 
-0.912906533075502, -0.920766516675787, -0.809502081342156, -0.872363355333242, 
-0.961659723370583, -0.903254468351235, -0.933827697536363, -0.864515862396722, 
-0.92499190821736, -0.926514772743366, -0.999999517563361, -0.83534143166862, 
-0.789477264061408, -0.96725996699103, -0.999995945075487, -0.94662865068056, 
-0.999999584321781, -0.870955533418263, -0.9999944910246, -0.960572059840108, 
-0.840783816862761, -0.909119955121076, -0.899688675406184, -0.919823477565098, 
-0.843017295356753, -0.881794331675607, -0.940697413251121, -0.922000619693845, 
-0.987401169140072, -0.821131649771165, -0.91962126041848, -0.999999630332899, 
-0.999999025563757, -0.916338193013063, -0.912619911532369, -0.877909145402413, 
-0.74715415008567, -0.999999436465066, -0.968945172671108, -0.936869211168488, 
-0.925119957125705, -0.856039931422829, -0.989503883758193, -0.928226570734266, 
-0.849598129490599, -0.856719478491408, -0.887862489581014, -0.891799277574747, 
-0.999999994772222, -0.921239453175252, -0.858661352778703, -0.940037723575724, 
-0.946324791482126, -0.926283505806362, -0.905893410734109, -0.952207539839442, 
-0.936579816142155, -0.973466178904343, -0.914139210754129, -0.96520909564992, 
-0.999999654477818, -0.811471406606913, -0.890658333298622, -0.917916416700977, 
-0.874761104217893, -0.891044313605774, -0.914019753486684, -0.855063863595756, 
-0.942168533601262, -0.928443734858533, -0.999999827776456, -0.848210944818155, 
-0.84779837247038, -0.877013648834639, -0.824243592530924, -0.929875004843296, 
-0.887674047244184, -0.96039668232855, -0.851064907496933, -0.911628169305816, 
-0.844283912726712, -0.854859228246806, -0.941773435261638, -0.89914148282906, 
-0.970151649236138, -0.901267354299606, -0.992236804919086, -0.937879595680483, 
-0.877482481936266, -0.93023948452159, -0.856345681803543, -0.950437158502745, 
-0.900020794360954, -0.999999736728836, -0.999999731551806, -0.92420375073192, 
-0.91471999612361, -0.999998154320142, -0.911509762966887, -0.932436534063833, 
-0.929593508537362, -0.853235126348608, -0.900694579712417, -0.915115832670036, 
-0.90039111767352, -0.880054932418241, -0.841256350108367, -0.999999527821877, 
-0.999999507772714, -0.886894735222301, -0.919711940612167, -0.94610440545472, 
-0.928520997411057, -0.877036929443188, -0.946061445698382, -0.999995695365254, 
-0.884408534030756, -0.895135635986891, -0.906137090381659, -0.91293386312922, 
-0.999999715847579, -0.890215383484949, -0.80965659101186, -0.956418342153782, 
-0.914656936965641, -0.900089683687517, -0.914808485947492, -0.854555320016036, 
-0.95940760968167, -0.910889570011593, -0.903523992444128, -0.904444446608641, 
-0.881467874083337, -0.999999488691974, -0.847129229101704, -0.94103879262914, 
-0.923236031506313, -0.966745244689678, -0.949035431332477, -0.87437238363346, 
-0.999999721279044, -0.873098631627096, -0.92441248679425, -0.948102845675497, 
-0.919892324975856, -0.999998701503905, -0.89496132679291, -0.877742903124947, 
-0.85786301595447, -0.886051427834312, -0.949310051549874, -0.940852502524505, 
-0.929523909336961, -0.92776933629632, -0.868471289443613, -0.908646489486012, 
-0.892184980064993, -0.999999604925191, -0.967959404524102, -0.974551655236996, 
-0.999999764093135, -0.99999902514067, -0.939939074893623, -0.901674637586226, 
-0.963046116256337, -0.916298362678914, -0.896848011366303, -0.96511278411638, 
-0.99999952174978, -0.916007291992541, -0.999999959579576, -0.906782751961, 
-0.99999950212471, -0.906334059619918, -0.871691133060975, -0.838913153472545, 
-0.891827541831999, -0.81757111080372, -0.999996052180575, -0.971047461049178, 
-0.897758447136592, -0.99999946721477, -0.888150286814311, -0.88820249336635, 
-0.949018294979292, -0.930334026870663, -0.950093497119832, -0.99999974985163, 
-0.779597030563839, -0.88874405255809, -0.918001018613947, -0.983809400855365, 
-0.940558883754655, -0.99999896427549, -0.88691240274629, -0.895502663507599, 
-0.908748817809919, -0.869761314888392, -0.92375530085239, -0.902550214355462, 
-0.87409833554401, -0.84981257284764, -0.948563637353106, -0.928000679989317, 
-0.954620620070811, -0.9999996025357, -0.948685290580975, -0.905562460511836, 
-0.999999841447677, -0.956445567779066, -0.956520729693798, -0.895368477412481, 
-0.874763413599602, -0.887480560525767, -0.911964516834212, -0.898001632841605, 
-0.891144546426396, -0.874399482526671, -0.876292522291858, -0.905922769616377, 
-0.927826953887005, -0.935674543327172, -0.88579515015361, -0.999999771312892, 
-0.86095670628928, -0.95973597920179, -0.999999957025347, -0.909179115723395, 
-0.961537893122326, -0.928799847439192, -0.927607036814496, -0.830663311114456, 
-0.845935603017549, -0.896670299222534, -0.872902907997315, -0.94833422632066, 
-0.999933709699035, -0.899687450610612, -0.925193000853618, -0.882402015772203, 
-0.90279326405625, -0.87688549030753, -0.884938223274915, -0.894863887366067, 
-0.9999994929624, -0.999999572076642, -0.812273756711094, -0.999997434486713, 
-0.972742712407877, -0.879559621150361, -0.933205250876412, -0.84575885866317, 
-0.907050686390282, -0.951243853037064, -0.922982618691413, -0.917627823361832, 
-0.946967678072061, -0.97197469370679, -0.853906324594185, -0.816267508398737, 
-0.999999549192212, -0.978125831287503, -0.92357416497855, -0.773673303790937, 
-0.928313865809951, -0.999999510111178, -0.914006293996011, -0.871864144945574, 
-0.863752337477124, -0.860075286465421, -0.834093859331408, -0.839685263007471, 
-0.885882931267074, -0.855470482184953, -0.901081368717238, -0.90253190186969, 
-0.82601300612861, -0.999999513374808, -0.901036850871825, -0.87315891274023, 
-0.89962801810577, -0.930317059447684, -0.922432194626804, -0.909738016081546, 
-0.783874894427628, -0.866767332661151, -0.930637361983583, -0.918953029708785, 
-0.907337748637002, -0.920653362670444, -0.88715073782839, -0.952417613674652, 
-0.715195334964779, -0.999999995247918, -0.908704249696097, -0.888060386924978, 
-0.889038751145176, -0.999999727665353, -0.917234316786202, -0.83470181182337, 
-0.999999483630197, -0.847634804771795, -0.892616704931551, -0.867321352811464, 
-0.93492501532334, -0.865573295976587, -0.947161898694046, -0.833278386045562, 
-0.950572901215085, -0.802982037413634, -0.968177620635247, -0.816270523452417, 
-0.94068778470414, -0.957787466794101, -0.885996198313704, -0.832988969541079, 
-0.896405307848563, -0.973239773068402, -0.859445137710052, -0.91684109000517, 
-0.892782491602766, -0.999999285455725, -0.8951840879111, -0.894751133592974, 
-0.99999979388745, -0.90822086417289, -0.9071114927708, -0.876080833321901, 
-0.958226593526874, -0.929696693818875, -0.780241644435164, -0.909945836544197, 
-0.819337567614174, -0.990444425942233, -0.942493975136107, -0.882891952651925, 
-0.94180019024323, -0.880189114282017, -0.92194934493723, -0.879449881849647, 
-0.999999471985678, -0.999999521006344, -0.915174303944388, -0.88678698531205, 
-0.861478476301081, -0.912973665396178, -0.78319665638699, -0.999999554775589, 
-0.911904072002984, -0.879587043114047, -0.95941191754175, -0.91761506754751, 
-0.948188118943438, -0.905714032027827, -0.999999814806716, -0.887236650001465, 
-0.861160068035518, -0.929136433830065, -0.923767624194029, -0.999999723813077, 
-0.910551550525416, -0.964423793823352, -0.872189273137338, -0.894105333373521, 
-0.911429675911094, -0.943012085737067, -0.817147883776049, -0.906611136160266, 
-0.999999047906506, -0.9359108416011, -0.887697688808606, -0.934738975731933, 
-0.918134412475257, -0.891226545791446, -0.868094442689533, -0.736972611811438, 
-0.964604968518993, -0.915699972451254, -0.956289914912125, -0.899468486499754, 
-0.880668363050122, -0.907966434173585, -0.999999879254988, -0.999997820656007, 
-0.999999491436738, -0.845525081406878, -0.85837982260796, -0.9346392039533, 
-0.999999675827333, -0.933288872388206, -0.919768930497938, -0.897183618062194, 
-0.935217061509319, -0.909372224159357, -0.85804456449483, -0.901278245780156, 
-0.917874814336708, -0.999999539542364, -0.861942654444284, -0.940189995692523, 
-0.93992516413699, -0.881179798435692, -0.917016417225767, -0.999996505039389, 
-0.841350023453106, -0.999999551277873, -0.97802080640245, -0.925312484609626, 
-0.98446810839349, -0.868375002937634, -0.993432739511482, -0.970106903134325, 
-0.953060652696336, -0.896564922642834, -0.846184727166223, -0.952776497815548, 
-0.743830465054637, -0.857535726713356, -0.90656066585714, -0.883320091149939, 
-0.952996904976562, -0.952359378129638, -0.852976040379067, -0.885159900711898, 
-0.937293335407, -0.974484152540506, -0.8512020647042, -0.99999962925848, 
-0.81877984462691, -0.954828062889708, -0.813558364940824, -0.789738136567716, 
-0.903033838750977, -0.97034343718538, -0.999999698508244, -0.900600093585817, 
-0.939840954300316, -0.947810941926848, -0.9999997882331, -0.999999503451541, 
-0.99999387565817, -0.915203993042425, -0.926175978236894, -0.999999886282224, 
-0.890429121116558, -0.746255483418141, -0.999999818333218, -0.974997943289732, 
-0.999999678365373, -0.851357646149562, -0.829536717932384, -0.901420706965086, 
-0.93384022006076, -0.999999795285307, -0.966099842016892, -0.999999814866553, 
-0.999999950861712, -0.88598614428247, -0.929472561188403, -0.999995723574902, 
-0.982262739757703, -0.935252069725418, -0.999999485006907, -0.849684232977274, 
-0.884976871545548, -0.914175475938135, -0.995474129572175, -0.87947787584792, 
-0.843971455868005, -0.858768144635732, -0.97239165419544, -0.872069477790401, 
-0.84983747713612, -0.847551718961978, -0.855257090997234, -0.952426093489444, 
-0.742639566750732, -0.927363090706585, -0.877567584373522, -0.96319554414112, 
-0.914442452517874, -0.890811761573844, -0.999999494886627, -0.915133837418652, 
-0.917560907307247, -0.887531203626302, -0.93065086233527, -0.924656148730367, 
-0.93250968844719, -0.91708797096271, -0.924259314137286, -0.956398145097811, 
-0.880196021623702, -0.929768410260592, -0.915976471733378, -0.985441709868259, 
-0.841896734699636, -0.777584993629336, -0.883688677097944, -0.932356961197173, 
-0.923855681431669, -0.918468823186421, -0.789837222040438, -0.827588272545254, 
-0.899678473733246, -0.902249358294728, -0.88719067680163, -0.821127382840455, 
-0.877538479596956, -0.91562936762895, -0.948080696561178, -0.852546455200105, 
-0.895684978320985, -0.94485213733578, -0.999998025309489, -0.950680023407568, 
-0.918148513819168, -0.843942159107321, -0.883552613281508, -0.955494107690147, 
-0.891657780952859, -0.890267962093552, -0.969792514457982, -0.896362841352777, 
-0.945661905771613, -0.999998393125127, -0.911468266781284, -0.999999527793948, 
-0.82766502412661, -0.999999881503354, -0.960457514765844, -0.955159176055506, 
-0.875313751452965, -0.936880952179687, -0.89711205826767, -0.964997599378603, 
-0.920765471080069, -0.839131592770942, -0.957045251499618, -0.913583095226825, 
-0.717762794199173, -0.934301639484468, -0.862088268274566, -0.708724322619983, 
-0.99999983219719, -0.959472922992853, -0.891704134519892, -0.937918626785692, 
-0.999984204706021, -0.760414102617499, -0.999999745510114, -0.873380568678314, 
-0.794000600325721, -0.930151607212005, -0.889158396558025, -0.931672456519695, 
-0.872571337285618, -0.896188752662811, -0.900857263135318, -0.96265645817299, 
-0.891286330665608, -0.757370987986776, -0.99999950257536, -0.942676424779601, 
-0.999999746604371, -0.903255826555238, -0.889743261027969, -0.925158489281997, 
-0.952800277425808, -0.929902622672342, -0.917010425645925, -0.928431813765433, 
-0.899378513875666, -0.869225054913548, -0.935387092873612, -0.811219515810417, 
-0.753529658230584, -0.941798491296117, -0.87488697673895, -0.927298218342905, 
-0.895771970548456, -0.828227215447301, -0.999999761983172, -0.955303283513156, 
-0.95904941810603, -0.876113793717083, -0.889111086472066, -0.941747628642598, 
-0.849713608858811, -0.902445759765791, -0.895088345050363, -0.883409719388683, 
-0.904229689420131, -0.99999902862327, -0.850012648408131, -0.897860216170158, 
-0.951060496870808, -0.9407920241076, -0.89758475363063, -0.916964881581042, 
-0.842774141628305, -0.86700625658756, -0.902680787390905, -0.910428892133513, 
-0.999999821703895, -0.864448152969048, -0.861928695137074, -0.999999245974997, 
-0.98864647292918, -0.908068460326513, -0.999999566974895, -0.906156057543466, 
-0.871952977236585, -0.90177662687834, -0.880626483594096, -0.903218874029404, 
-0.999999036931034, -0.88595386666025, -0.883335305959698, -0.999999588336939, 
-0.90127163799753, -0.908782148119485, -0.807335683821447, -0.957457033588308, 
-0.929493495516674, -0.877947426734378, -0.920566431495787, -0.99999951289688, 
-0.917368385993835, -0.999999989892474, -0.911273699146692, -0.97410983297696, 
-0.953672324775849, -0.982865401032614, -0.900812557467323, -0.892676300624924, 
-0.917902185929403, -0.929910735015478, -0.953605734586591, -0.841355212334667, 
-0.933889531752114, -0.896258664019208, -0.976652645166919, -0.90938633546014, 
-0.846221841955969, -0.866349415851239, -0.700601416661376, -0.999999471144098, 
-0.85984317064074, -0.979995268055974, -0.845380921825762, -0.9520391160685, 
-0.932304664438962, -0.958237331172955, -0.816045794950173, -0.802722640185928, 
-0.900875668270382, -0.851214833793802, -0.999996683095492, -0.999999461062731, 
-0.970940075119497, -0.863041402280316, -0.958297004701967, -0.914131123453549, 
-0.889451144832266, -0.947670804145253, -0.920555607164673, -0.91945697601516, 
-0.872998532060133, -0.872091698778706, -0.857599887485456, -0.920088082141592, 
-0.932071605307191, -0.839080157906743, -0.94689558663414, -0.938146473132466, 
-0.999999693770779, -0.881180845148978, -0.89016515248747, -0.99999950180188, 
-0.893086127942338, -0.907400047526525, -0.89994504184195, -0.99999964119603, 
-0.955186971828583, -0.939568698605036, -0.899083710415626, -0.885090378622454, 
-0.896644186618876, -0.91700829619769, -0.999999526328529, -0.898002494777801, 
-0.804592675375096, -0.786486138371577, -0.918541720036704, -0.901017254585767, 
-0.905832981578622, -0.953134596721624, -0.83174592763368, -0.877387862232985, 
-0.909073844546096, -0.93047967524565, -0.876115909157549, -0.939778259683314, 
-0.817003662605843, -0.802645598319008, -0.999999986687606, -0.885242560598285, 
-0.88872727755166, -0.876164246588158, -0.940508461704032, -0.947373510102815, 
-0.878032331700324, -0.976807799710347, -0.821485366917127, -0.896988657345847, 
-0.858656856907574, -0.8770547754246, -0.999999718731733, -0.99999786010982, 
-0.943415466571183, -0.949956602434833, -0.895616101452023, -0.926176725553992, 
-0.975559181164648, -0.918859660711224, -0.99999952274576, -0.915575925060847, 
-0.862026921642668, -0.906552796550395, -0.887905830449552, -0.999999968613206, 
-0.930079772618589, -0.80935785485345, -0.963427937059117, -0.890052626556473, 
-0.78354822424294, -0.92278406193755, -0.999999552131602, -0.868345152964583, 
-0.835151612249958, -0.907961913152586, -0.941853037707498, -0.917932636474272, 
-0.99999975806289, -0.895050549445337, -0.8755360436797, -0.894257844755652, 
-0.884076527314862, -0.999997390316837, -0.983517590952213, -0.865498077994355, 
-0.91514159638235, -0.946127941418227, -0.999998675928953, -0.937242712790542, 
-0.864534415302258, -0.932825596875417, -0.999998988492645, -0.997489434036227, 
-0.999999505085774, -0.956245037794053, -0.830077729233818, -0.895350359649782, 
-0.839966574863034, -0.885368355082644, -0.884508034902908, -0.896053265871428, 
-0.949263782833105, -0.954081127991167, -0.94796889329917, -0.999999693323603, 
-0.90630389657993, -0.89451158459125, -0.892545520143849, -0.85641321342139, 
-0.838046097654901, -0.96807982683417, -0.90324122133705, -0.781890030165665, 
-0.940949850923282, -0.973270315282783, -0.959030980557239, -0.942245636662973, 
-0.809169416038145, -0.868969443137411, -0.903719560409318, -0.884313708238953, 
-0.907978856794945, -0.796999770006014, -0.97367260932373, -0.906242162123104, 
-0.92073037325821, -0.890716847986607, -0.91963300663715, -0.872176675645295, 
-0.983436912835917, -0.899277171616052, -0.937819224054085, -0.848655184308814, 
-0.904062181834922, -0.91334236405721, -0.882356976734624, -0.930499294756796, 
-0.93847261836453, -0.971317799116173, -0.834631873893298, -0.897980271122504, 
-0.983291905151362, -0.907132443270563, -0.907055170457486, -0.916646622803425, 
-0.960352655491257, -0.865086296383436, -0.910471634812153, -0.874474916708242, 
-0.964120573811354, -0.852854995567063, -0.942424920181736, -0.944416062014108, 
-0.916960765516069, -0.999999874622967, -0.94518828247719, -0.96636066311665, 
-0.913761253393958, -0.85223547127096, -0.852048300808791, -0.866993668319846, 
-0.959767523347264, -0.870100941376755, -0.904845090557487, -0.973295545373278, 
-0.92028705729345, -0.962719686506529, -0.962743464402169, -0.905464599270456, 
-0.924737960463273, -0.918620362102687, -0.93087998133292, -0.942934976945552, 
-0.919820662911428, -0.79770465725572, -0.877408993858686, -0.958724775578539, 
-0.877656040907986, -0.927032232979581, -0.996694631841341, -0.92578931269836, 
-0.902746266123036, -0.929195669630816, -0.865953479799628, -0.926520653455969, 
-0.999999719630444, -0.99999958521789, -0.866718183033204, -0.85986267557357, 
-0.800181377487086, -0.804561771459768, -0.936013813631676, -0.893295488387075, 
-0.999999706389878, -0.95007080064618, -0.873076284187014, -0.949252432751442, 
-0.999999505249408, -0.811326295601756, -0.87284376775951, -0.857093940761415, 
-0.999999800270956, -0.990316581505713, -0.572992621940733, -0.640694168513368, 
-0.544265461585204, -0.669676070772505, -0.542873568548524, -0.465807127406981, 
-0.733912817743803, -0.545666352367601, -0.513012113660814, -0.49959314686959, 
-0.579209949480007, -0.595808081723494, -0.852705903958283, -0.568674603720135, 
-0.573746545968577, -0.567140907667721, -0.631316382362344, -0.628665349317528, 
-0.649309346916091, -0.57041158918876, -0.509465585203221, -0.558453037540503, 
-0.679507181027559, -0.582526897216273, -0.630192942022694, -0.484256114055429, 
-0.584957934604011, -0.567402617616097, -0.539505204319605, -0.601937420582969, 
-0.681501653443325, -0.640405532259162, -0.663970459793298, -0.616836253669992, 
-0.508295367147836, -0.565159737935646, -0.53015800692971, -0.580869630863382, 
-0.52427951881694, -0.645780886320983, -0.480301378108576, -0.531434928046591, 
-0.580208791592123, -0.6046237982289, -0.517153396738687, -0.574172966885902, 
-0.7317050010792, -0.583891357870684, -0.642577332550671, -0.769132349409226, 
-0.52888969032432, -0.494560210972653, -0.665977661747524, -0.592682783997016, 
-0.48355110103406, -0.526634513469259, -0.445705535577213, -0.526673365131653, 
-0.580506857218352, -0.620097868584394, -0.623137926435112, -0.524181330724836, 
-0.498823813076975, -0.532844626943855, -0.630424949305181, -0.633539733647929, 
-0.468919447008168, -0.492164568852615, -0.676544071214311, -0.584784346607978, 
-0.498108742486016, -0.698839610066512, -0.492043080022798, -0.510014117839435, 
-0.584881040874888, -0.573522701533733, -0.438740960915339, -0.673800016767194, 
-0.539815584067939, -0.529254865519304, -0.590022197014236, -0.692240953819211, 
-0.577815754062439, -0.626658820980563, -0.685133814151762, -0.74517510634956, 
-0.53613185282851, -0.715775659698254, -0.639939928383806, -0.648007511376776, 
-0.633645430050372, -0.651952839407482, -0.685149836745876, -0.550904675358875, 
-0.610793962023275, -0.546222971523788, -0.660230780367288, -0.705962074800164, 
-0.616413862602194, -0.586298269549542, -0.607907856729833, -0.583698651030882, 
-0.46257391145211, -0.665880762442906, -0.56888051422012, -0.623866963889119, 
-0.640656894648867, -0.569141142176011, -0.673967215714214, -0.73688739866443, 
-0.339008853294764, -0.674408115569716, -0.668507960139405, -0.495890090841555, 
-0.628852662190095, -0.565799465916259, -0.687967735491103, -0.588803782165847, 
-0.63513292511287, -0.644326726318741, -0.575702241028581, -0.630774321095075, 
-0.396974283813242, -0.505549256828537, -0.627898997816205, -0.474598641587298, 
-0.671404034325618, -0.503097518377726, -0.686725447897684, -0.716488456176179, 
-0.665243222598055, -0.603068697755336, -0.650774772280853, -0.532048378637104, 
-0.595304701840858, -0.529733819078872, -0.719716957711872, -0.536948023294584, 
-0.604519360790402, -0.734810776928453, -0.793718927767867, -0.496459441479471, 
-0.486464927767994, -0.51695068834094, -0.694480000744352, -0.767674068766087, 
-0.539463580283861, -0.598421609970574, -0.589698597801635, -0.594338988641034, 
-0.736102123761947, -0.61605714686618, -0.70003781924918, -0.5461678848352, 
-0.668743929127476, -0.633700271432862, -0.588603651018431, -0.442425571534945, 
-0.589280707907792, -0.647980837750033, -0.751086459112656, -0.442095438599560, 
-0.438819859924798, -0.509448739635066, -0.521395509906932, -0.570924817331772, 
-0.606063985266297, -0.470713170288912, -0.607229179337809, -0.655440505086176, 
-0.601480109174081, -0.646803696951303, -0.611754189318746, -0.645432506545245, 
-0.654567793673869, -0.684361156448719, -0.622370761236921, -0.563693648828535, 
-0.667418152210204, -0.640698553529385, -0.594938173100495, -0.567024214013348, 
-0.796044275112699, -0.541487837769430, -0.446384137433243, -0.710932176005424, 
-0.609578557785523, -0.66036852209275, -0.545232825337734, -0.469128094127018, 
-0.400921237993448, -0.51321873317091, -0.50575231498046, -0.706672818316781, 
-0.635587649845001, -0.573791498054857, -0.647963600547721, -0.696100885505399, 
-0.546483811158017, -0.740614325449545, -0.614264390955254, -0.554438146145256, 
-0.694449484481724, -0.701845557655064, -0.605325687006553, -0.592528319474633, 
-0.624483542345669, -0.482425085382986, -0.653611190540623, -0.660435325589342, 
-0.638928547803693, -0.784878547893919, -0.579305304256194, -0.778125277448385, 
-0.591585486602483, -0.635406003532474, -0.633624307798916, -0.534803281812195, 
-0.597487560983045, -0.700041918703864, -0.609327816358036, -0.587885069142337, 
-0.544810317983523, -0.649946319295716, -0.73082180553802, -0.725986546179364, 
-0.60294930030789, -0.412196885738881, -0.572419057045211, -0.604215198139294, 
-0.57659418090603, -0.535269679244992, -0.647494956517626, -0.627446717120323, 
-0.849465289394204, -0.673956514395464, -0.60231219073357, -0.619950612404665, 
-0.642363825243837, -0.55876816733343, -0.663353454905031, -0.662015969683071, 
-0.519524005207752, -0.674767459226045, -0.551813143221872, -0.536039778443628, 
-0.620726062904893, -0.630436867747693, -0.52836199845368, -0.737233444225775, 
-0.542001245728701, -0.612189684472966, -0.418699526422732, -0.482725149855654, 
-0.632588588618645, -0.520929459160792, -0.74982907926742, -0.584003140852092, 
-0.47828689655521, -0.655847135650625, -0.686245410085664, -0.68853377707883, 
-0.47902067004254, -0.627493871531477, -0.55298400173806, -0.619674275095729, 
-0.471437027432278, -0.557348601695649, -0.541713774248383, -0.767460044320344, 
-0.687723865342422, -0.575625814515308, -0.609235690883199, -0.582321771385761, 
-0.48187380165874, -0.54522927402055, -0.793397491701552, -0.606470299601941, 
-0.644457721300558, -0.691682518151603, -0.621218222076871, -0.557799534832276, 
-0.618509055946731, -0.687061982268928, -0.609252501937282, -0.389852437168518, 
-0.64873221428067, -0.741966865707725, -0.602328140045237, -0.715119660386314, 
-0.583849486032278, -0.757261966443854, -0.349027352011085, -0.467113329718101, 
-0.583203021149595, -0.677350799559586, -0.641519736254195, -0.580656395883234, 
-0.540090111474867, -0.582289945446743, -0.469510664105072, -0.633649666351163, 
-0.648082980076006, -0.646923082007882, -0.572800697081938, -0.807448010570115, 
-0.641434183862736, -0.742527374493144, -0.598797392441703, -0.545481590034339, 
-0.728820321127256, -0.638570259317556, -0.80986612344796, -0.578401034541904, 
-0.663310558541877, -0.488703737443537, -0.544943173828148, -0.636985780038193, 
-0.662492118493129, -0.618171362889611, -0.469074492147182, -0.593203229669827, 
-0.537629848677157, -0.633211866080461, -0.613991836227815, -0.518483596568428, 
-0.559013456258823, -0.513687124378727, -0.543257586813634, -0.74122198931383, 
-0.72941130289593, -0.424261677865072, -0.63247309594727, -0.643402304417776, 
-0.684189225558298, -0.588283067152995, -0.581133186722456, -0.635584112935009, 
-0.621974095292799, -0.641583085500446, -0.593994579273475, -0.467434231411771, 
-0.480010418990053, -0.70525187810352, -0.585790709798561, -0.355270047891547, 
-0.534506684909011, -0.747551752506086, -0.685369472003486, -0.588179625240016, 
-0.511095175136344, -0.560251605012058, -0.679013435316144, -0.612773932125404, 
-0.653690045211971, -0.565116339002475, -0.594891088820142, -0.42715408875447, 
-0.431641219490382, -0.598405195182777, -0.542037191773236, -0.677596404806708, 
-0.50725592805393, -0.384744801464994, -0.624388966978675, -0.539387599058597, 
-0.66126353081269, -0.692318294230964, -0.494970475277129, -0.597206631165806, 
-0.673376665936008, -0.708918758723289, -0.599868833148151, -0.596660996485125, 
-0.384298630390255, -0.495373788551965, -0.759308507580146, -0.563469924407239, 
-0.431420062299585, -0.450685040084998, -0.634742502349505, -0.555850009697247, 
-0.45734812116674, -0.71692242987821, -0.668676669601838, -0.60799833911264, 
-0.534515616327262, -0.643323270506414, -0.56579602339774, -0.333367273591162, 
-0.521669340470349, -0.594916461833895, -0.560835732634535, -0.727633463344997, 
-0.671837857239846, -0.639713546594894, -0.979902486940855, -0.730462730024516, 
-0.6790711054999, -0.497478297015062, -0.703618071365243, -0.601243609750974, 
-0.656955455593574, -0.533474536231629, -0.671909223141133, -0.685693033212495, 
-0.636946703201017, -0.577349061645357, -0.620183967053498, -0.462414696353551, 
-0.633356590203183, -0.613987165844743, -0.645795912916653, -0.490431502178952, 
-0.665160473199625, -0.480319719857036, -0.566240562124898, -0.57039489219542, 
-0.645695581385669, -0.65034436737414, -0.627634562729385, -0.414406539059721, 
-0.68205787013015, -0.631117599932089, -0.581348238196494, -0.60533503849179, 
-0.663622445739455, -0.63344879204682, -0.560654596898699, -0.597790023906823, 
-0.708769602223475, -0.561032445853393, -0.489460800537169, -0.445149515571386, 
-0.539738977634201, -0.661430200727658, -0.563092218983721, -0.503369916066965, 
-0.574894889696112, -0.691442437999068, -0.646226872007654, -0.767727376183874, 
-0.67049220252893, -0.518715053856011, -0.597595051912326, -0.621805159759538, 
-0.539777957843728, -0.640347888043647, -0.637155070394128, -0.582911210710904, 
-0.670002880832422, -0.452469928177305, -0.43398860452873, -0.627816467497867, 
-0.603252542019912, -0.54515171924165, -0.68428886757271, -0.657946507686044, 
-0.596910295560282, -0.5746498434468, -0.53819386992422, -0.423471366670295, 
-0.759585032457025, -0.63644663244555, -0.544142807910295, -0.572575903861642, 
-0.403330528702076, -0.540205399856947, -0.421086342166713, -0.579496412237528, 
-0.638433432681948, -0.910229282260589, -0.668917090161138, -0.56708850603465, 
-0.609185683622974, -0.634922728224798, -0.547167127628008, -0.566077956186695, 
-0.725814808682775, -0.735020983689405, -0.366302171761094, -0.649294962908628, 
-0.654548324080081, -0.576562006365425, -0.658658471444868, -0.567724212272877, 
-0.698281972965513, -0.536022452965696, -0.50520738956836, -0.718429182551526, 
-0.651219931194577, -0.516717529296013, -0.638425373051634, -0.688847407130415, 
-0.565385185014183, -0.62178747872593, -0.609703478185858, -0.651868404181139, 
-0.578973945592762, -0.661320283963922, -0.521012402913404, -0.710999080563125, 
-0.629630299398135, -0.531983554509320, -0.481059118023228, -0.728462568435037, 
-0.652347793570914, -0.576625918116889, -0.493441174315372, -0.563565951907216, 
-0.524104339949682, -0.672240149558624, -0.491798603443369, -0.614454353880415, 
-0.4134532585029, -0.581059929490865, -0.545373697738608, -0.524578921789612, 
-0.644132715024309, -0.565341006600756, -0.561626604484309, -0.425470960815069, 
-0.667716929450662, -0.550518668122395, -0.686391933968006, -0.713666888551795, 
-0.67768180200294, -0.542495658516009, -0.591092934731082, -0.496755246601137, 
-0.597062921783035, -0.561414849029661, -0.514325854701334, -0.648839498280092, 
-0.60679350455545, -0.693536935367633, -0.70646801663586, -0.657825231319764, 
-0.652284120752642, -0.688250953829125, -0.497754803411308, -0.652050092892919, 
-0.619491771476577, -0.54550599684639, -0.574352807892093, -0.574104510884522, 
-0.578693452677993, -0.6131912098356, -0.617825327091597, -0.529835265867012, 
-0.626630603263484, -0.567368304959336, -0.673287141519308, -0.569670071559812, 
-0.584668579515338, -0.824426313971663, -0.822075977566593, -0.569784461020787, 
-0.629172282147205, -0.825822604613913, -0.75293788867994, -0.669155089496627, 
-0.81963458417433, -0.46602162380968, -0.551721020022313, -0.704838068701572, 
-0.845944970753068, -0.63376643008963, -0.656469375490768, -0.567993025089409, 
-0.615107539826378, -0.466603584247485, -0.608673202338703, -0.610603656287018, 
-0.475164423661621, -0.491955731896686, -0.71816149957463, -0.517033422982354, 
-0.73080963392216, -0.669013019924209, -0.537359341297733, -0.607050895867398, 
-0.638830716484473, -0.641881506860695, -0.659566955692452, -0.569002910534557, 
-0.558370798643213, -0.421190272109113, -0.617782556325346, -0.511511742516289, 
-0.594840156186148, -0.560396253851449, -0.598443312100426, -0.609193556550157, 
-0.655242230422721, -0.537876474673442, -0.694170937307409, -0.478113909236802, 
-0.796739041836137, -0.63713448011248, -0.524463387361186, -0.688460425618399, 
-0.541750950324622, -0.608780990927597, -0.70452598378125, -0.679556091934869, 
-0.583785996929599, -0.524541685870363, -0.583774395742796, -0.514502408242937, 
-0.5637444255293, -0.69068703862108, -0.543091908035609, -0.573571305711753, 
-0.598571988280328, -0.597899893311122, -0.511713389380563, -0.555426200340476, 
-0.746146439986712, -0.643340478547296, -0.519193654099616, -0.702977681617676, 
-0.618045551443144, -0.588859668881482, -0.469789081333464, -0.701383062109663, 
-0.63604788322517, -0.44339285268195, -0.565672203037916, -0.488594437507138, 
-0.401984786495384, -0.548010163611597, -0.636638892507137, -0.697184057210168, 
-0.509524010188821, -0.512833328397071, -0.553972898416617, -0.663128501865693, 
-0.667152296707747, -0.638928034436603, -0.714535296559471, -0.604716260355956, 
-0.62657719327208, -0.693064823127205, -0.621360868642159, -0.652281382843025, 
-0.563203935916864, -0.508781203900369, -0.5716724552374, -0.591185798157959, 
-0.507605090021962, -0.59027050788894, -0.523704666659077, -0.488376606501934, 
-0.588355933860841, -0.554154010771691, -0.572301851372457, -0.629048676640766, 
-0.645467999077116, -0.552201206275929, -0.617925666822205, -0.531051497544567, 
-0.548264957494249, -0.583988381107565, -0.62400756132031, -0.747368518672076, 
-0.815690235626813, -0.598229737395505, -0.585070392652745, -0.511397464107877, 
-0.607701737418962, -0.63918570094896, -0.62220162176808, -0.656691138398017, 
-0.548946529188576, -0.739698283729163, -0.671392597765297, -0.67088092287996, 
-0.535107830166093, -0.708350764760145, -0.683372136228376, -0.57651006961467, 
-0.692847295369779, -0.63234525553819, -0.551190764078043, -0.523818953370657, 
-0.542703464015744, -0.73249785969324, -0.629498277782115, -0.481339343969368, 
-0.558982438433797, -0.649666397692524, -0.481535969684896, -0.648689827015874, 
-0.673543103137122, -0.729258859881447, -0.616195390089394, -0.58016234179684, 
-0.576979500722651, -0.721428845099445, -0.595648109337709, -0.616449760502507, 
-0.559681213757366, -0.627421077768238, -0.592654582549245, -0.529719169281595, 
-0.608810017048452, -0.515298211016731, -0.546659188034304, -0.690457521693359, 
-0.457352260059804, -0.613760774294914, -0.703969578264702, -0.526620993623782, 
-0.469871336665961, -0.66716591358152, -0.746728007500709, -0.803089890791244, 
-0.462738868733065, -0.676487031537259, -0.469852286996032, -0.667004928854532, 
-0.615258869115061, -0.584134280172404, -0.521288784494140, -0.785305278071086, 
-0.578714229454124, -0.477573569612446, -0.577916843658681, -0.58671869540978, 
-0.623484490154074, -0.690845421090733, -0.641368556949772, -0.60627228868469, 
-0.564430660546484, -0.495160664715426, -0.617488885413304, -0.68204364586331, 
-0.474925877099571, -0.504467379729865, -0.495862820473892, -0.530909757913001, 
-0.606959392644089, -0.793286252459255, -0.472325189533999, -0.494882206359848, 
-0.420928586441561, -0.601083867564549, -0.640984909278586, -0.651739957054033, 
-0.759088214989808, -0.69774407904936, -0.634877002228261, -0.657341734538297, 
-0.599690249587687, -0.672064397062757, -0.495309387139816, -0.68246092197279, 
-0.496586786541875, -0.644992986683815, -0.697728345376923, -0.597431540953607, 
-0.561459820351914, -0.614510234190925, -0.49232821312265, -0.580967929226628, 
-0.515600471219435, -0.633906917573362, -0.558739201573765, -0.605571862547632, 
-0.602417038526516, -0.53061078343583, -0.789895437546282, -0.540467428130238, 
-0.559522415307939, -0.493648263177642, -0.437151584929456, -0.633416233050052, 
-0.596742513884481, -0.586126977966828, -0.664352755973193, -0.332754921861818, 
-0.591066011257891, -0.624695875816326, -0.576056005684707, -0.751364628460479, 
-0.743113102151849, -0.582864381033894, -0.641000638216509, -0.688701893305832, 
-0.652735146192006, -0.512011611462593, -0.508980807325919, -0.50667211398584, 
-0.621095314000384, -0.630578036432957, -0.502014155489203, -0.732974276901306, 
-0.626806151680081, -0.55792289574779, -0.515707913870466, -0.696362398396259, 
-0.595604330506171, -0.602400025559936, -0.628658813605655, -0.609601403573168, 
-0.453849768474288, -0.748481042296671, -0.727959621477511, -0.751562703049426, 
-0.620815919641663, -0.52221191554726, -0.495457505271033, -0.474001378145798, 
-0.446412272441289, -0.496365601817758, -0.733196528435595, -0.682236802151882, 
-0.75269931560947, -0.510446709869322, -0.582302244731186, -0.509018722876377, 
-0.573093883306387, -0.733635187578744, -0.599321987044748, -0.631974239712532, 
-0.752069585000294, -0.660459815906272, -0.586171865651553, -0.547822506900826, 
-0.537177200130258, -0.518836050868839, -0.608372397289036, -0.542423492774165, 
-0.677708017470977, -0.566727763264948, -0.663947706435007, -0.390455552428273, 
-0.594423708922455, -0.592968047183955, -0.659155445881344, -0.625973719175023, 
-0.671484412168923, -0.675985234646772, -0.577300724331179, -0.610433539275974, 
-0.589381572701328, -0.531630425302942, -0.591657608994267, -0.769848682046804, 
-0.725813327814505, -0.623328817716012, -0.570183077043755, -0.580391489565751, 
-0.574673574522904, -0.684222048217496, -0.686306335378724, -0.581379534315424, 
-0.596631884390674, -0.589115865079724, -0.61128555974485, -0.70115441952202, 
-0.641404573639864, -0.5072816553718, -0.563090738233052, -0.712069282107754, 
-0.67220183916705, -0.527358758462378, -0.400407852817325, -0.593461632700497, 
-0.594555655885291, -0.630229535654252, -0.583712822083625, -0.404052318770844, 
-0.506509645273406, -0.673046925315545, -0.477771023506228, -0.642565782741079, 
-0.741371371308294, -0.623128101300094, -0.555151071743325, -0.597467515397057, 
-0.353270946198723, -0.668768840767193, -0.624901118323448, -0.66521335506795, 
-0.464938920585901, -0.542034951213805, -0.677626852391827, -0.66872113203841, 
-0.56374160047547, -0.527953939997405, -0.543576817140624, -0.597665474999177, 
-0.756924700081806, -0.638811519107662, -0.462524638027214, -0.718207426067133, 
-0.706169635073784, -0.556780167762352, -0.469566761345376, -0.570272968990248, 
-0.605617981359248, -0.749345629156501, -0.520800365124557, -0.700302042763038, 
-0.57434002535064, -0.466437268091242, -0.72803976956135, -0.528028207081176, 
-0.479375898008882, -0.572337164099309, -0.492169208027505, -0.62018163613868, 
-0.563772254168191, -0.599434330120035, -0.566014775059279, -0.646205865054614, 
-0.616734843020929, -0.801613048204486, -0.577532535450435, -0.419196199211205, 
-0.52021280495445, -0.455989187118538, -0.568257601968295, -0.605043226933543, 
-0.672454945188749, -0.61486419339164, -0.638035003599004, -0.488372638158741, 
-0.744122050226172, -0.501941946566666, -0.62141503324238, -0.616017093927356, 
-0.617295884754896, -0.570463738253005, -0.611059360192612, -0.58399312714376, 
-0.601557168123372, -0.574710001776322, -0.42096341782449, -0.67351507084751, 
-0.595693488169385, -0.543979574625722, -0.654570140664317, -0.542958125634808, 
-0.606673236557769, -0.644519307770886, -0.684195425270445, -0.769511826952521, 
-0.658254042176445, -0.783477670507904, -0.599775256896053, -0.597385974851518, 
-0.55684897029823, -0.603024486824373, -0.534580461687953, -0.688857786839307, 
-0.582569110380934, -0.536302192828521, -0.68731212011526, -0.616642288449117, 
-0.403465755345525, -0.664814080005048, -0.628645285280373, -0.771636619946562, 
-0.721967769755058, -0.550038879101171, -0.596409659546398, -0.526398476150217, 
-0.535619989994303, -0.675960177209922, -0.471528959044504, -0.457642549729021, 
-0.600320269617613, -0.54729702753322, -0.710343593814965, -0.541534519215007, 
-0.60858076706028, -0.75001048132232, -0.452631009167329, -0.577729504959003, 
-0.540838880087338, -0.649825528324695, -0.56140532422734, -0.670563085049968, 
-0.577969814177397, -0.439963269551797, -0.668273492086053, -0.584483950818436, 
-0.490679089549011, -0.605284120077761, -0.496788092334074, -0.628581446437675, 
-0.548561952416287, -0.581429460651937, -0.628562383223924, -0.644833102411884, 
-0.635231714841677, -0.568070727098198, -0.318869622035424, -0.276450403109509, 
-0.433648056628018, -0.434562252823636, -0.53999791251775, -0.209828001180985, 
-0.222050051267602, -0.259228286419586, -0.160728419100164, -0.288584616932851, 
-0.201224097194236, -0.293460093022362, -0.150218680683417, -0.222512949854807, 
-0.366447122022329, -0.226615981425714, -0.216467292690800, -0.173573069211802, 
-0.365431853439592, -0.354076142172923, -0.264493140880075, -0.300570136143819, 
-0.226298086911508, -0.118654699343268, -0.193765831090466, -0.0757317128094537, 
-0.30305672580368, -0.268644329375046, -0.294286185744869, -0.303919275244609, 
-0.218054067878781, -0.430552093909829, -0.288682116126907, -0.288251975925667, 
0.00184887742667621, -0.194263949519974, -0.395590596132842, 
-0.343913132023617, -0.241515752077684, -0.422984904933431, -0.393882744004566, 
-0.233940637379801, -0.304546403434511, -0.295127476664501, -0.332893752503847, 
-0.129128530321869, -0.339631180061078, -0.102676927925366, -0.384998924014848, 
-0.503995537724535, -0.185335502245906, -0.452071971144025, -0.340922732007517, 
-0.321091832394478, -0.352756616309163, -0.135573532560727, -0.404550765006996, 
-0.182186814174604, -0.108921940935241, -0.324803695265528, -0.510859686478812, 
-0.136584253962888, -0.463072080115429, -0.182071102057460, -0.366292453374881, 
-0.372995173326426, -0.378454095457843, -0.378253224832312, -0.141128745014831, 
-0.419140758457114, -0.307483270142304, -0.285389555512863, -0.355736237743663, 
-0.399931740639443, -0.118829654274613, -0.184716577191584, -0.406143204121999, 
-0.328572103387641, -0.273747006636491, -0.177984545662057, -0.284589427802502, 
-0.0820080781987376, -0.302120425402454, -0.269379429750434, 
-0.287308485001912, -0.265100774809315, -0.263480947118108, -0.433373026611606, 
-0.166154082444381, -0.279857666522120, -0.235392914835297, -0.456203521604321, 
-0.362880613549624, -0.169412554073656, -0.349721270504565, -0.303009158681282, 
-0.174830237317165, -0.364553405949566, -0.275889765520604, -0.117022780403624, 
-0.452266413067709, -0.318515873078814, -0.321479610010229, -0.393831136274426, 
-0.294826201482295, -0.156233909275398, -0.461902479221849, -0.531117830203671, 
-0.132848580121955, -0.276910826391959, -0.309124440147164, -0.259993747888353, 
-0.138678272238935, -0.204025402027532, -0.357507011767961, -0.268708194659423, 
-0.180681684094960, -0.122061620441250, -0.333052786561094, -0.289138782430797, 
-0.251252593079844, -0.372709886303144, -0.290867147947129, -0.304429552222767, 
-0.185956732446832, -0.202097441370470, -0.371879992817610, -0.353991213631478, 
-0.346636019559936, -0.228967462381611, -0.288765050503705, -0.364307203507443, 
-0.321770400200648, -0.059400118224305, -0.148782004152609, -0.298383623367096, 
-0.303440467826898, -0.259122637420458, -0.415684558060974, -0.246772331363002, 
-0.363764904350207, -0.305140119458191, -0.229166132650429, -0.437806346543227, 
-0.103824213555239, -0.350903042988458, -0.340105837764218, -0.297578196831528, 
-0.324928634555266, -0.223121179651291, -0.318189454424746, -0.411866679985408, 
-0.289018115439729, -0.258995906077079, -0.395106380365065, -0.0573547672251893, 
-0.452102344075741, -0.289397498049902, -0.400941499064901, -0.347626901951025, 
-0.340981220653268, -0.375231741910449, -0.383628367221967, -0.159881344468452, 
-0.409868776168432, -0.117101216197030, -0.120307026523544, -0.0614596340846092, 
-0.341405082239951, -0.443397366405693, -0.376421618182409, -0.314846857581512, 
-0.166497589636870, -0.302759507588402, -0.439391376571058, -0.276360836368757, 
-0.299097209625903, -0.25332829381897, -0.41540446959146, -0.206287965530136, 
-0.246933638214553, -0.122642927182516, -0.498045428579938, -0.250837666583879, 
-0.246264260710177, -0.389086215288471, -0.201841806154648, -0.0759781615983103, 
-0.328357847291071, -0.303787314304548, -0.358000279345398, -0.381885252160325, 
-0.300761653706623, -0.439497498776245, -0.285570566164008, -0.683785591596431, 
-0.260440816577981, -0.274992329329847, -0.280615728458467, -0.403352061812016, 
-0.311110690125276, -0.347959753120109, -0.371582152427026, -0.34625971472547, 
-0.178739561393736, -0.361322120755983, -0.256267709993217, -0.444364311840449, 
-0.412962303436115, -0.279197444111871, -0.352337198785442, -0.376127475508055, 
-0.293951697155212, -0.222306513269248, -0.242377963225137, -0.308486525895573, 
-0.17041310432112, -0.33448466470874, -0.266005263156745, -0.281496779940673, 
-0.194328541456578, -0.0940435514872645, -0.355640011660511, 
-0.224420194360607, -0.407634979214085, -0.497488824084676, -0.379535591040036, 
-0.159838928831426, -0.337503214008359, -0.360317538886647, -0.226099823675756, 
-0.527050986619029, -0.177466597267314, -0.38421675545611, -0.250512907131206, 
-0.215341835246752, -0.298358176017932, -0.323374755458464, -0.0393608862767736, 
-0.184226081405855, -0.329526320756377, -0.335749163882479, -0.19526478485526, 
-0.336695173747669, -0.268448870925761, -0.33001100951809, -0.215862040955948, 
-0.380392655394757, -0.257558789007597, -0.448132593511479, -0.381043139480950, 
-0.408691695266365, -0.203599671781526, -0.341866338648067, -0.443773012726453, 
-0.280077685781255, -0.379325043764068, -0.306070668245676, -0.112743615926799, 
-0.350339898581992, -0.314359236724087, -0.516267422236051, -0.516377991165107, 
-0.0993939020962386, -0.491611392006651, -0.479994699142513, 
-0.315552201841660, -0.219150570382137, -0.23814058868314, -0.216738728168682, 
-0.306670056512326, -0.312023149927126, -0.386346329386211, -0.413440343287807, 
-0.285063507646730, -0.30248503637865, -0.384070737010683, -0.367356440761243, 
-0.342844705420812, -0.559530465903011, -0.406331058097727, -0.385342112728792, 
-0.256805063889971, -0.430493917214518, -0.40467375192882, -0.276701717929064, 
-0.249443090217312, -0.275735313144293, -0.195798868088218, -0.333171917293570, 
-0.236474726804117, -0.257025797422144, -0.369659280413455, 0.0903349346051026, 
-0.230819903480467, -0.314224977139818, -0.180313674628788, -0.164549253727946, 
-0.222764606122849, -0.290196287856060, -0.329307611888507, -0.231809615463164, 
-0.396776193266365, -0.321473740150596, -0.342070603165540, -0.183574075414002, 
-0.364772460029103, -0.371449205180224, -0.329534641112620, -0.247860321422278, 
-0.396539205121901, -0.36451464636759, -0.172725097912819, -0.289286091369608, 
-0.445242712795479, -0.151440592886169, -0.368159758854737, -0.165575939286135, 
-0.243242025635951, -0.248787026408091, -0.506113405417595, -0.233806808047338, 
-0.335067920573818, -0.346199147447325, -0.350627450145003, -0.340092020480179, 
-0.169897673351922, -0.50706651153009, -0.35525358824045, -0.122662034890446, 
-0.366211677290084, -0.462593868548169, -0.261661408264759, -0.323163848763863, 
-0.307727824309788, -0.31627986307394, -0.148599483755844, -0.398729014545828, 
-0.368811689339911, -0.341267824437756, -0.386303035262354, -0.150274372101813, 
-0.416185443208645, -0.400950157143858, -0.100400284033652, -0.258757142222022, 
-0.290102792314513, -0.379982799682105, -0.155845275048630, -0.179703361549294, 
-0.238156679526664, -0.183485853094451, -0.359577109742789, -0.237494400011949, 
-0.197797874316451, -0.292466881336563, -0.456262981851668, -0.315844320189201, 
-0.390604049026517, -0.327812274254286, -0.291328052415174, -0.271768937190157, 
-0.436152867391197, -0.455974479518248, -0.319831907881149, -0.202540447402207, 
-0.309664651302091, -0.353799564344658, -0.410799063910894, -0.308707283397338, 
-0.279997871589146, -0.542057075916612, -0.291018096991270, -0.289688189043326, 
-0.327523866518401, -0.357603907517489, -0.293923036063161, -0.294258833513567, 
-0.254117470190636, -0.357677558489323, -0.404476659067915, -0.370975390354594, 
-0.0857241978352322, -0.368298131581128, -0.312715586554712, 
-0.355879728347672, -0.41232582089304, -0.27358488539601, -0.559702293649809, 
-0.176224432869031, -0.23361899110309, -0.0525685397421197, -0.395524490983717, 
-0.241011121249129, -0.289032076405666, -0.0848136579575174, 
-0.0469557118222765, -0.450196595894299, -0.199625969357880, 
-0.291863163214937, -0.409209144907446, -0.296353381933792, -0.292359169460756, 
-0.367125395845723, -0.248405179490107, -0.589195955323168, -0.392490653691045, 
-0.290133845504327, -0.338818346376327, -0.388772078371716, -0.403257186415721, 
-0.281903520809703, -0.318309545438205, -0.35858570201036, -0.181556060857838, 
-0.307931180321648, -0.296408321778116, -0.130411520151227, -0.363274810660113, 
-0.338620535173198, -0.234844680862765, -0.181643026204176, -0.282265391724926, 
-0.064982039563797, -0.254993655104953, -0.358706072793249, -0.173913786418473, 
-0.282588671459916, -0.273917655546305, -0.335153883424349, -0.40300030383524, 
-0.334786078820175, -0.123052962978792, -0.197527308186647, -0.150796950213480, 
-0.604617074833988, -0.456712593628838, -0.118760118391213, -0.365386171614153, 
-0.263949896746568, -0.279029240102963, -0.308144480631062, -0.253833489095369, 
-0.327890064464875, -0.289367466246053, -0.415403199672559, -0.225495271498357, 
-0.275539250957957, -0.181140157178655, -0.285272698965438, -0.0569344940653907, 
-0.378516298572108, -0.280402767871846, -0.201842807993348, -0.321518923505747, 
-0.212503661498771, -0.527778906467659, -0.410094682087366, -0.364274947675141, 
-0.181758149473043, -0.339928529189972, -0.323531028713201, -0.351773071527052, 
-0.276943459942688, -0.340177792471940, -0.231389865274583, -0.196172166532138, 
-0.364442173037356, -0.268804241466034, -0.319964998353987, -0.379738831724251, 
-0.230254068749584, -0.326207688573304, -0.267979131375434, -0.215701456535254, 
-0.383673865843811, -0.36249050970237, -0.352227739235692, -0.185983635183442, 
-0.54483199449381, -0.203031394457071, -0.224192110307237, -0.392952919429026, 
-0.213985226445707, -0.382369296455478, -0.43629431218505, -0.237150612815379, 
-0.202051361900453, -0.250063494573486, -0.260443915738188, -0.332442224563096, 
-0.115602825174833, -0.192853276820767, -0.350969164165543, -0.292504104891668, 
-0.301554574277702, -0.213684049421716, -0.457541507014107, -0.137045316293511, 
-0.219994398038740, -0.160326277587004, -0.34045036953072, -0.223784251062079, 
-0.435951017433735, -0.349469583291917, -0.318150539771326, -0.296677719264328, 
-0.418988055594376, -0.426482508654398, -0.215524872473449, -0.349684506602459, 
-0.241015731571736, -0.38078456547941, -0.245871715051471, -0.263706177386189, 
-0.241256637746497, -0.381280609103254, -0.331908188724562, -0.392917834891822, 
-0.321105636289016, -0.372981543975825, -0.321300404676317, -0.154970296735085, 
-0.436166751591137, -0.320907655379495, -0.390599451854269, -0.300577325918852, 
-0.404601148891287, -0.371076093095136, -0.389675351166598, -0.542460401991928, 
-0.372836143191608, -0.282494038282526, -0.250914697069867, -0.188473266470347, 
-0.327051362763363, -0.257474618134916, -0.386344760747066, -0.321453550607521, 
-0.349585450247752, -0.341603603181278, -0.286034079693409, -0.276322421953698, 
-0.102610204129897, -0.478904385694594, -0.266710419968948, -0.335497065752658, 
-0.246732733638704, -0.296392720360568, -0.392697161838244, -0.486375248842139, 
-0.161330167492180, -0.266995372398192, -0.335243970642162, -0.291311505799636, 
-0.359817194166305, -0.318579962552423, -0.165514663946125, -0.397634972443171, 
-0.307694440644724, -0.422304039273236, -0.480597937968873, -0.291489930220992, 
-0.302620891776254, -0.178135370148501, -0.367889811372096, -0.393571502756648, 
-0.15861767031988, -0.314493271876895, -0.392187787154476, -0.152525973682781, 
-0.337359305139035, -0.331074589056014, -0.267724338151687, -0.325854092036153, 
-0.421827799845063, -0.394541061003846, -0.163640184478955, -0.261389090113534, 
-0.469873913843936, -0.227258918373219, -0.229763072526929, -0.29575425773761, 
-0.386156169804207, -0.195575620203297, -0.336800303195041, -0.236503495069019, 
-0.471266093998056, -0.186983144665663, -0.36051241809349, -0.203124552816374, 
-0.221315548901728, -0.354364790614876, -0.4226160112515, -0.162897952798432, 
-0.491495973454648, -0.375183668082044, -0.418446960377374, -0.288533247880694, 
-0.305456185189124, -0.250697429186757, -0.190779925242655, -0.105549819921063, 
-0.363029155818615, -0.299635055078847, -0.326584304722406, -0.270614574165274, 
-0.270122138544044, -0.360604467281715, -0.299441258362529, -0.376408982054284, 
-0.216557927895502, -0.222451557287252, -0.156378077885849, -0.354973227703601, 
-0.352818769860137, -0.23164691234515, -0.282953120118802, -0.30040531032323, 
-0.322122120145204, -0.243146320835369, -0.383473976960185, -0.184564705747074, 
-0.356812758259345, -0.199741676372848, -0.114924303711283, -0.352932513308061, 
-0.208254989960281, -0.452466224135282, -0.373805516078022, -0.254110401214254, 
-0.272090228476462, -0.223150116466375, -0.213254430251737, 0.0304082197932023, 
-0.317393385138023, -0.258486508919892, -0.259601407356745, -0.198660501466016, 
-0.166864432143834, -0.450702208565243, -0.37064654411094, -0.266768219932008, 
-0.377578400975554, -0.266518298445347, -0.299213059080962, -0.267243308213426, 
-0.366440312393747, -0.0885647999655748, -0.390186746997551, 
-0.163339903175236, -0.400033042234175, -0.306956163528018, -0.510808101462798, 
-0.232653325001128, -0.359411373513087, -0.312446962589533, -0.415836375359417, 
-0.373037528262345, -0.250580115605776, -0.314414776037330, -0.0949257708307352, 
-0.349662541531334, -0.237533343293459, -0.127454384143651, -0.351211974285976, 
-0.384327211823627, -0.508131304726589, -0.39932043339444, -0.298806463047811, 
-0.316537628205736, -0.295325842787847, -0.0755417486182832, 
-0.278359275396299, -0.398676218308183, -0.390005119439699, -0.57035514902287, 
-0.119271601670244, -0.0747429296855369, -0.381607027104538, 
-0.221193061201155, -0.346489734440966, -0.234690791090039, -0.428090861670928, 
-0.444838710667421, -0.231736278490911, -0.307038757726525, -0.28662520286162, 
-0.253555135361002, -0.21325981187251, -0.514970215015080, -0.302485108410143, 
-0.302504931421864, -0.246422177763481, -0.350685075317, -0.179955059042974, 
-0.235635540019153, -0.34792828233761, -0.358382997001025, -0.373097452213158, 
-0.279385959196242, -0.426791128744522, -0.252358304912746, -0.314810904009788, 
-0.27591122673048, -0.290111484028339, -0.313706402354836, -0.451891449031193, 
-0.437962512094275, -0.382444624638874, -0.236104100014285, -0.218662903555210, 
-0.249113729506504, -0.362159319369019, -0.299506066225837, -0.289090069929709, 
-0.304803790178787, -0.304942845485722, -0.263026406426839, -0.210697864959864, 
-0.330848139273278, -0.388550297319057, -0.307683054245446, -0.291630901978384, 
-0.198695708150724, -0.237591587960847, -0.315487824391348, -0.259014924650945, 
-0.446424011809994, -0.24229647224594, -0.370149008899889, -0.354611096493269, 
-0.270540112945344, -0.211030976865664, -0.193742498100651, -0.27409203051713, 
-0.374860261054161, -0.399518599409446, -0.201047106863119, -0.338105787015161, 
-0.315853292263928, -0.397418501608555, -0.169161418920102, -0.19003308822851, 
-0.448578021886101, -0.581268999154108, -0.179956761427189, -0.187842007537242, 
-0.190900386170196, -0.136382731250236, -0.486567556868948, -0.350491014129934, 
-0.326155526226486, -0.382881713899517, -0.127533704100042, -0.243751370771346, 
-0.242602297561021, -0.428615106990489, -0.255864034648004, -0.125350739419318, 
-0.312243024246379, -0.291401654797821, -0.268285724102322, -0.489159892974053, 
-0.228110835469906, -0.103596367371114, -0.215207798124606, -0.0762313363711014, 
-0.478793142059686, -0.366982786291143, -0.356253766367483, -0.273255760684177, 
-0.178773532504987, -0.285821940696362, -0.36486174975957, -0.207720431892683, 
-0.226957286661669, -0.377716607397481, -0.402116110498636, -0.457745525155753, 
-0.436667242190331, -0.145538288117363, -0.318348693038585, -0.223538687024566, 
-0.342284649767650, -0.18909405930422, -0.37791867182329, -0.414264660459185, 
-0.260836415974795, -0.234699022073775, -0.443464230239241, -0.258167914494387, 
-0.203372865875317, -0.309639550725774, -0.272978906539340, -0.410207641640290, 
-0.339434514709337, -0.396659467131301, -0.275570887524753, -0.396316240040465, 
-0.292954880451121, -0.473380169405794, -0.250072094003819, -0.138403569031393, 
-0.287872836458890, -0.266390581285989, -0.269448591518639, -0.344557358445712, 
-0.349612729878237, -0.283054522647229, -0.520434944582302, -0.229482254927552, 
-0.438069627670014, -0.332461781913093, -0.414809748798138, -0.315155920234194, 
-0.123145073998816, -0.337956833943488, -0.23870951671014, -0.420140136509136, 
-0.295565833021, -0.340456469906397, -0.299173668121045, -0.45032303498601, 
-0.348711459992396, -0.359441005533238, -0.310598366475312, -0.153490456336621, 
-0.30063125065254, -0.179094405643274, -0.159067602162378, -0.256083307961947, 
-0.319464042340181, -0.0599061741575378, -0.304688084509837, 
-0.294802563797808, -0.151837200338663, -0.30508378848128, -0.310663272729933, 
-0.249407623262150, -0.198440513739155, -0.234149657731464, -0.202013675280222, 
-0.232559351464858, -0.294967289795299, -0.404187707038363, -0.373421876982091, 
-0.203474455740545, -0.144863933840416, -0.351323410708239, -0.209641641891742, 
-0.282524670977534, -0.340810195547760, -0.384083400404201, -0.479405618249928, 
-0.169027865590768, -0.257483775236151, -0.337010024472118, -0.253916127925195, 
-0.458347292169229, -0.171509022279224, -0.274869313909705, -0.311776999180884, 
-0.330426656939774, -0.157448556724865, -0.367371103115199, -0.33832635562233, 
-0.256065062559468, -0.0806637431929808, -0.288837659975461, 
-0.354295153188685, -0.217843453541096, -0.440872568143234, -0.738237494685241, 
-0.137361357473761, -0.400330458997635, -0.234099195195863, -0.119385048890980, 
-0.502298824378694, -0.486946950925733, -0.288261242447984, -0.0940019180761743, 
-0.361423225766196, -0.237515059889358, -0.264829599198958, -0.358766188128709, 
-0.274972394775185, -0.499806051062557, -0.262241199679683, -0.255569003769992, 
-0.172325602304925, -0.227214457034383, -0.29412100046777, -0.255959921418052, 
-0.328275446314137, 0.0306171424165128, -0.40192196053527, -0.267341942212056, 
-0.255976090995515, -0.166902668449816, -0.212878194553583, -0.147171412390945, 
-0.192367819354603, -0.34656658279517, -0.216410813753964, -0.450281159887506, 
-0.156440557697742, -0.216506268118591, -0.139936367115926, -0.252055947843149, 
-0.421137756700731, -0.231163604344924, -0.308448601149361, -0.429217947593141, 
-0.243948721013097, -0.335660007231525, -0.31775012183197, -0.344728743613