% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyroscience.pumpresp.R
\name{pyroscience.pumpresp}
\alias{pyroscience.pumpresp}
\title{Convert Respirometry Data from PyroScience and the pump controller PumpResp to the FishResp Format}
\usage{
pyroscience.pumpresp(pyroscience.file,
                     pumpresp.file,
                     fishresp.file,
                     n.chamber = c(1,2,3,4),
                     date.format = c("DMY", "MDY", "YMD"))
}
\arguments{
\item{pyroscience.file}{the name of a file which contains raw data obtained from the 'Pyro Oxygen Logger' software (\href{https://www.pyroscience.com/}{PyroScience})}

\item{pumpresp.file}{the name of a file which contains logger data obtained from the pump conroller \href{https://fishresp.org/pumpresp/}{PumpResp}}

\item{fishresp.file}{the name of an exported file containing raw data in the 'FishResp' format}

\item{n.chamber}{integer: the number of chambers used in an experiment (including empty ones)}

\item{date.format}{string: date format (DMY, MDY or YMD) used in raw data obtained from the 'Pyro Oxygen Logger' software}
}
\value{
The function exports a file containing raw data in the 'FishResp' format
}
\description{
The function is used to convert raw data from 'Pyro Oxygen Logger' (\href{https://www.pyroscience.com/}{PyroScience}) and a logger file of the pump controller \href{https://fishresp.org/pumpresp/}{PumpResp} to the 'FishResp' format. This function should be applied before usage of the functions \code{\link{import.test}} and \code{\link{import.meas}}. The output is a file containing raw respirometry data in the 'FishResp' format (see Details in \code{\link{import.test}} to read more information about the 'FishResp' format)
}
\examples{
\dontrun{
pyroscience.path = system.file("extdata/salmon/salmon_pyroscience.txt",
                 package = "FishResp")

pumpresp.path = system.file("extdata/salmon/salmon_pumpresp.txt",
                 package = "FishResp")

pyroscience.pumpresp(pyroscience.path,
                     pumpresp.path,
                     "fishresp.txt",
                     n.chamber = 4,
                     date.format = "DMY")
}
}
