% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_plots.R
\name{density_plots}
\alias{density_plots}
\title{density_plots}
\usage{
density_plots(pdb_df, model_report)
}
\arguments{
\item{pdb_df}{Requires a PDB data frame generated by PDB_prepare}

\item{model_report}{Optional parameter to include data from cluster_ID}
}
\value{
multiple plots
}
\description{
Function plots a density plot set for phi/psi angle distributions, Fi-score and normalised B-factor. As well as 3D visualisation of angle distribution for every residue. The plots can be used for a quick assessment of the overall parameters.
}
\examples{
path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
# basic usage of density_plots
pdb_df<-read.table(path_to_processed_PDB)
density_plots(pdb_df)
}
