% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00.helpers.R
\name{SCC}
\alias{SCC}
\title{Tarjan's algorithm for finding strongly connected components}
\usage{
SCC(test_m)
}
\arguments{
\item{test_m}{A square adjacency matrix representing the directed network.}
}
\value{
A list containing two elements:
\itemize{
 \item{\code{n} - number of strongly connected components}
 \item{\code{sizes} - size of each strongly connected component, in order of discovery}
}
}
\description{
This function performs a depth-first search (DFS) on a directed graph to identify
strongly connected components (SCCs) and their size
}
\details{
This function is a modified version of the R implementation of Tarjan's
algorithm for finding strongly connected components in directed graphs by
Ettore Settanni at the University of Cambridge (see References).

The function consists of several internal steps:
\enumerate{
  \item{Node Labeling - All nodes are labeled with two-digit names for clarity in referencing.}
  \item{Successor List Creation - For each node, lists of direct successors are compiled.}
  \item{Utilization Table Setup - A table is set up for tracking exploration details such as depth and backtracking information.}
  \item{Main DFS Loop - The core loop where DFS occurs, including node visitation and backtracking logic to determine SCCs.}
  \item{Stack Management - Nodes are managed in a stack to keep track of the current path of exploration and to facilitate backtracking.}
  \item{SCC Identification - Upon finishing exploration of an SCC, it is identified and nodes are popped from the stack.}
}
}
\references{
Settanni, Ettore. ‘RtarD - Find Strongly Connected Components in a Digraph Using R’. R, 15 November 2021. \url{https://github.com/Dr-Eti/RtarD-Tarjans_DFS_in_R}.
}
\seealso{
Other SCC finders: 
\code{\link{SCC2}()}
}
\author{
\enc{Settanni,Ettore}{Ettore Settanni}

\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
\concept{SCC finders}
\keyword{internal}
