% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_optimized_arrangement.R
\name{optimized_arrangement}
\alias{optimized_arrangement}
\title{Generates an Spatial Un-replicated Optimized Arrangement Design}
\usage{
optimized_arrangement(
  nrows = NULL,
  ncols = NULL,
  lines = NULL,
  amountChecks = NULL,
  checks = NULL,
  planter = "serpentine",
  l = 1,
  plotNumber = 101,
  seed = NULL,
  exptName = NULL,
  locationNames = NULL,
  optim = TRUE,
  data = NULL
)
}
\arguments{
\item{nrows}{Number of rows in the field.}

\item{ncols}{Number of columns in the field.}

\item{lines}{Number of genotypes, experimental lines or treatments.}

\item{amountChecks}{Integer with the amount total of checks or a numeric vector with the replicates of each check label.}

\item{checks}{Number of genotypes as checks.}

\item{planter}{Option for \code{serpentine} or \code{cartesian} arrangement. By default  \code{planter = 'serpentine'}.}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{exptName}{(optional) Name of the experiment.}

\item{locationNames}{(optional) Name for each location.}

\item{optim}{By default \code{optim = TRUE}.}

\item{data}{(optional) Data frame with 3 columns: \code{ENTRY | NAME | REPS}.}
}
\value{
A list with five elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{layoutRandom} is a matrix with the randomization layout.
  \item \code{plotNumber} is a matrix with the layout plot number.
  \item \code{dataEntry} is a data frame with the data input.
  \item \code{genEntries} is a list with the entries for replicated and no replicated part.
  \item \code{fieldBook} is a data frame with field book design. This includes the index (Row, Column).
}
}
\description{
Randomly generates a spatial un-replicated optimized arrangement design, where the distance
between checks is maximized in such a way that each row and column have control plots.
Note that design generation needs the dimension of the field (number of rows and columns).
}
\examples{
# Example 1: Generates a spatial unreplicated optimized arrangement design in one location
# with 108 genotypes + 12 check plots (4 checks) for a field with dimension 10 rows x 12 cols.
OptimAd1 <- optimized_arrangement(
  nrows = 10, 
  ncols = 12, 
  lines = 108, 
  amountChecks = 12, 
  checks = 1:4,
  planter = "cartesian", 
  plotNumber = 101,
  seed = 14,
  exptName = "20RW1",
  locationNames = "CASSELTON"
 )
OptimAd1$infoDesign
OptimAd1$layoutRandom
OptimAd1$plotNumber
head(OptimAd1$fieldBook,12)
                  
# Example 2: Generates a spatial unreplicated optimized arrangement design in one location
# with 200 genotypes + 20 check plots (4 checks) for a field with dimension 10 rows x 22 cols.
# As example, we set up the data option with the entries list.
checks <- 4
list_checks <- paste("CH", 1:checks, sep = "")
treatments <- paste("G", 5:204, sep = "")
REPS <- c(5, 5, 5, 5, rep(1, 200))
treatment_list <- data.frame(list(ENTRY = 1:204, NAME = c(list_checks, treatments), REPS = REPS))
head(treatment_list, 12) 
tail(treatment_list, 12)
OptimAd2 <- optimized_arrangement(
  nrows = 10, 
  ncols = 22, 
  planter = "serpentine", 
  plotNumber = 101,
  seed = 120,
  exptName = "20YWA2",
  locationNames = "MINOT",
  data = treatment_list
)
OptimAd2$infoDesign
OptimAd2$layoutRandom
OptimAd2$plotNumber
head(OptimAd2$fieldBook,12)
                  
}
\references{
Clarke, G. P. Y., & Stefanova, K. T. (2011). Optimal design for early-generation plant
breeding trials with unreplicated or partially replicated test lines. Australian & New
Zealand Journal of Statistics, 53(4), 461–480.
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
