% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitcsi.R
\name{bitcsi}
\alias{bitcsi}
\title{Shifted Binomial probabilities of ordinal responses}
\usage{
bitcsi(m,ordinal,csi)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{csi}{Feeling parameter of the shifted Binomial distribution}
}
\value{
A vector of the same length as \code{ordinal}, where each entry is the shifted Binomial probability 
of the corresponding observation.
}
\description{
Compute the shifted Binomial probabilities of ordinal responses.
}
\examples{
data(univer)
m<-7
csi<-0.7
ordinal<-univer$informat
pr<-bitcsi(m,ordinal,csi)
}
\references{
Piccolo D. (2003). On the moments of a mixture of uniform and shifted binomial random variables,
 \emph{Quaderni di Statistica}, \bold{5}, 85--104
}
\seealso{
\code{\link{probcub00}}, \code{\link{probcubp0}},  \code{\link{probcub0q}}
}
\keyword{distribution}
