\name{run.analysis}
\alias{run.analysis}
\title{Test for Significant Peaks in FT-ICR MS by Controlling FDR}
\description{
Takes the file generated by \code{\link{run.cluster.matrix}} and tests the peaks using Benjamini-Hochberg
to control the False Discovery Rate.}
\usage{
run.analysis(form, covariates, FDR = 0.1, normalization = "common",
             add.norm = TRUE, repl.method = max, use.t.test = FALSE,
             pval.fcn = "default", lrg.only = TRUE, masses = NULL,
             isotope.dist = 7, root.dir = ".", lrg.dir,
             lrg.file = lrg_peaks.RData, res.dir,
             res.file = "analyzed.RData", overwrite = FALSE,
             use.par.file = FALSE, par.file = "parameters.RData",
             ...)
}
\arguments{
    \item{form}{formula used in \code{\link{t.test}} or \code{\link{lm}}}
    \item{covariates}{data frame containing covariates used in analysis}
    \item{FDR}{False Discovery Rate in Benjamini-Hochberg test}
    \item{normalization}{type of normalization to use on spectra before statistical analysis; currently, only \code{"common"}, \code{"postbase"}, \code{"postrepl"}, and \code{"none"} are supported}
    \item{add.norm}{logical; whether to normalize additively or multiplicatively on the log scale}
    \item{repl.method}{function or string representing a function; how to deal with replicates}
    \item{use.t.test}{whether to use a \emph{t}-test to calculate \emph{p}-values}
    \item{pval.fcn}{function to calculate \emph{p}-values if \code{use.t.test = FALSE}; default is overall \emph{p}-value of \emph{F}-test using \code{\link{lm}}}
    \item{lrg.only}{logical; whether to consider only peaks that have at least one \dQuote{large}peak; i.e., identified by \code{run.lrg.peaks}}
    \item{masses}{specific masses to test}
    \item{isotope.dist}{maximum distance for declaring isotopes}
    \item{root.dir}{directory for parameters file and raw data}
    \item{lrg.dir}{directory for large peaks file; default is \code{paste(root.dir, "/Large_Peaks", sep = "")}}
    \item{lrg.file}{name of file to store large peaks in}
    \item{res.dir}{directory for results file; default is \code{paste(root.dir, "/Results", sep = "")}}
    \item{res.file}{name for results file}
    \item{overwrite}{whether to replace exisiting files with new ones}
    \item{use.par.file}{logical; if \code{TRUE}, then parameters are read from \code{par.file} in directory \code{root.dir}}
    \item{par.file}{string containing name of parameters file}
    \item{...}{additional parameters to be passed to \code{\link{t.test}} or \code{pval.fcn}}
}
\details{Reads in information from file created by \code{\link{run.strong.peaks}} and creates a file named 
\code{res.file} in \code{res.dir} which contains variables 
\tabular{ll}{ \tab \cr
    \code{amps}\tab matrix of transformed amplitudes of alignment peaks \cr
    \code{centers}\tab matrix of calculated masses of alignment peaks\cr
    \code{clust.mat}\tab matrix of transformed amplitudes of peaks used in statistical testing\cr
    \code{min.FDR}\tab FDR level required to get at least one significant test given the starting set of peaks\cr
    \code{sigs}\tab matrix containing all tests which are significant under at least one scenario\cr
    \code{which.sig}\tab matrix containing all peaks tested\cr
    \code{parameter.list}\tab if \code{use.par.file = TRUE}, a list generated by \code{\link{extract.pars}}; otherwise 
        not defined\cr
}
}
\value{
No value returned; the file is simply created.
}
\references{
Barkauskas, D.A. (2009) \dQuote{Statistical Analysis of Matrix-Assisted Laser Desorption/Ionization
Fourier Transform Ion Cyclotron Resonance Mass Spectrometry Data with Applications to Cancer
Biomarker Detection}.  Ph.D. dissertation, University of California at Davis.

Barkauskas, D.A. \emph{et al}. (2009) \dQuote{Detecting glycan cancer biomarkers in serum
samples using MALDI FT-ICR mass spectrometry data}.  \emph{Bioinformatics}, \bold{25}:2, 251--257.

Benjamini, Y. and Hochberg, Y.  (1995) \dQuote{Controlling the false discovery rate: a practical and powerful 
approach to multiple testing.}  \emph{J. Roy. Statist. Soc. Ser. B}, \bold{57}:1, 289--300.
}
\author{Don Barkauskas (\email{barkda@wald.ucdavis.edu})}
\note{If \code{use.par.file = TRUE}, then the parameters read in from the file overwrite any arguments entered in the
function call.

To analyze replicates as independent samples, use \code{repl.method = "none"}.  This will also speed up the
run time if there are no replicates in the data set.

The normalization schemes are as follows: \code{"common"} divides all peak heights in each spectrum 
by the average peak height of the alignment peaks from that spectrum in \code{amps}; \code{"postbase"}
divides all peaks heights in each spectrum by the average of of all peak heights in that spectrum; and
\code{"postrepl"} first combines replicates by applying \code{repl.method} to the peaks and 
then does \code{"postbase"}.

If \code{masses} is not \code{NULL}, then the listed masses plus anything that could be in the first
six isotope peaks of each mass are tested.

If something other than the \emph{p}-value for the overall \emph{F}-statistic is needed, then the
user-defined function for \code{pval.fcn} should have the form \code{function(form, dat, ...)},
where \code{form} and \code{dat} are as in \code{\link{lm}}; and should have a return value of
the desired \emph{p}-value.}
\seealso{\code{\link{run.strong.peaks}}}
\examples{}
