\name{run.lrg.peaks}
\alias{run.lrg.peaks}
\title{Extract "Large" Peaks from Files}
\description{
Takes the files output by \code{\link{run.peaks}}, extracts \dQuote{large} peaks, combines them
into a single data frame, and writes the data frame to a file.
}
\usage{
run.lrg.peaks(k.biweight = 6, trans.method = "shiftedlog", add.par = 10, 
              root.dir = ".", peak.dir, base.dir, lrg.dir, 
              lrg.file = "lrg.peaks.RData", overwrite = FALSE, 
              use.par.file = FALSE, par.file = "parameters.RData", 
              calc.all.peaks = TRUE)
}
\arguments{
  \item{k.biweight}{parameter for robust center and scale estimation using Tukey's biweight}
  \item{trans.method}{type of transformation to use on spectra before statistical analysis; currently, only \code{"shiftedlog"},
      \code{"glog"}, and \code{"none"} are supported}
  \item{add.par}{additive parameter for \code{"shiftedlog"} or \code{"glog"} options for \code{trans.method}}
  \item{root.dir}{string containing location of raw data directory}
  \item{peak.dir}{directory for peak location files; default is \code{paste(root.dir, "/All_Peaks", sep = "")}}
  \item{base.dir}{directory for baseline-corrected files; default is \code{paste(root.dir, "/Baseline_Corrected", sep = "")}}
  \item{lrg.dir}{directory for significant peaks file; default is \code{paste(root.dir, "/Large_Peaks", sep = "")}}
  \item{lrg.file}{string containing name for significant peaks file}
  \item{overwrite}{logical; whether to replace existing files with new ones}
  \item{use.par.file}{logical; if \code{TRUE}, then parameters are read from 
      \code{par.file} in directory \code{root.dir}}
  \item{par.file}{string containing name of parameters file}
  \item{calc.all.peaks}{logical; whether all peaks were calculated when \code{\link{run.peaks}} was run}
}
\details{Reads in information from each file created by \code{\link{run.peaks}}, extracts peaks which have 
zero weight in the spectrum they come from when using Tukey's biweight with parameter \code{k.biweight}
to estimate center and scale, and creates the file \code{lrg.file} in \code{lrg.dir}.  The resulting file 
contains the data frame \code{lrg.peaks}, which has columns 
\tabular{ll}{ \tab \cr
  \code{Center_hat}\tab estimated mass of peak\cr
  \code{Max_hat}\tab estimated intensity of peak\cr
  \code{Width_hat}\tab estimated width of peak\cr
  \code{File}\tab name of file the peak was extracted from, with \dQuote{\_peaks.RData} deleted\cr
}
    and is ready to be used by \code{\link{run.strong.peaks}}.
}
\value{
No value returned; the file is simply created.
}
\references{
Barkauskas, D.A. \emph{et al}. (2008) \dQuote{Detecting glycan cancer biomarkers in serum 
samples using MALDI FT-ICR mass spectrometry data}.  Submitted to \emph{Bioinformatics}
}
\author{Don Barkauskas (\email{barkda@wald.ucdavis.edu})}
\note{
A peak is \dQuote{large} if has zero weight in the data generated by \code{\link{run.peaks}} 
for the spectrum it comes from when using Tukey's biweight with parameter \code{k.biweight} 
to estimate center and scale. 

If \code{use.par.file = TRUE}, then the parameters read in from the file overwrite any arguments entered in the
function call.}
\seealso{\code{\link{run.peaks}}, \code{\link{run.cluster.matrix}}}
\examples{}