% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directSearchGenerator.R
\name{directSearchAlgorithm}
\alias{directSearchAlgorithm}
\title{Direct search algorithm generator}
\usage{
directSearchAlgorithm(directSearcher, params = list())
}
\arguments{
\item{directSearcher}{Name of the direct search algorithm. The available direct search algorithms are:
\describe{
\item{selectKBest}{See \code{\link{selectKBest}} }
\item{selectPercentile}{See \code{\link{selectPercentile}} }
\item{selectThreshold}{See \code{\link{selectThreshold}} }
\item{selectThresholdRange}{See \code{\link{selectThresholdRange}} }
\item{selectDifference}{See \code{\link{selectDifference}} }
\item{selectSlope}{See \code{\link{selectSlope}} }
}}

\item{params}{List with the parameters of each direct search method. For more details see each method. Default: empty list.}
}
\value{
Returns a direct search function that is used in the feature selection process.
}
\description{
Generates a direct search function. This function in combination with the evaluator composes the feature selection process. Specifically, the result of calling this function is another function that is passed on as a parameter to the \code{\link{directFeatureSelection}} function. However, you can run this function directly to perform a direct search process.
}
\examples{
\dontrun{ 

## Examples of a direct search algorithm generation

direct_search_method_1 <- directSearchAlgorithm('selectKBest')
direct_search_method_2 <- directSearchAlgorithm('selectPercentile')
direct_search_method_3 <- directSearchAlgorithm('selectThreshold')


## Examples of a direct search algorithm generation (with parameters)

direct_search_method_1 <- directSearchAlgorithm('selectKBest', list(k=2))
direct_search_method_2 <- directSearchAlgorithm('selectPercentile', list(percentile=25))
direct_search_method_3 <- directSearchAlgorithm('selectThreshold', list(threshold=0.55))


## The direct application of this function is an advanced use that consists of using this 
# function directly to perform a direct search process
## Classification problem


# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('determinationCoefficient')

# Generates the direct search function
direct_search_method <- directSearchAlgorithm('selectKBest')
# Performs the diret search process directly (parameters: dataset, target variable and evaluator)
direct_search_method(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
