% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectThresholdRange}
\alias{selectThresholdRange}
\title{Select threshold range}
\usage{
selectThresholdRange(data, class, featureEval, p.threshold = 0.3)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureEval}{\itemize{
\item The measure used to evaluate features
}}

\item{p.threshold}{\itemize{
\item Number between 0 and 1
}}
}
\value{
A list is returned containing:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{featuresSelected}{The names of the returned features sorted according to the result of the evaluation measure}
\item{valuePerFeature}{The evaluation measures of the returned features}
}
}
\description{
Selects the features whose evaluation is over a threshold, where this threshold is given as: (((min - max) * p.threshold) + max)
}
\examples{
## Select Threshold range for iris dataset (filter method)
selectThresholdRange(iris, 'Species', determinationCoefficient, 0.3)
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
