% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SockeyeSR.R
\docType{data}
\name{SockeyeSR}
\alias{SockeyeSR}
\title{Stock and recruitment data for Skeena River Sockeye Salmon, 1940-1967.}
\format{A data frame with 28 observations on the following 3 variables.
\describe{ 
  \item{year}{a numeric vector of years}
  \item{spawners}{a numeric vector giving number of spawning fish (in thousands)} 
  \item{recruits}{a numeric vector containing the recruitment (thousands)}
}}
\source{
Carroll, R. J. and Ruppert, D. 1988.  Transformation and Weighting in Regression.  Chapman and Hall, New York.  140 pp.
}
\description{
Stock and recruitment data for Skeena River Sockeye Salmon (\emph{Oncorhynchus nerka}), 1940-1967.
}
\details{
The dataset is usually analysed without case 12 because a rockslide occurred that year.
}
\section{Topic(s)}{

  \itemize{
    \item Stock-Recruit
    \item Recruitment
  }
}
\examples{
data(SockeyeSR)
str(SockeyeSR)
head(SockeyeSR)
SockeyeSR1 <- SockeyeSR[-12,]
op <- par(mfrow=c(1,2),pch=19)
plot(recruits~year,data=SockeyeSR1,type="b")
plot(recruits~spawners,data=SockeyeSR1)
par(op)

}
\concept{
'Stock-Recruit' Recruitment
}
\keyword{datasets}

