% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.R
\name{simu}
\alias{simu}
\title{Simulate data following log-ratio model}
\usage{
simu(
  n = 100,
  p = 200,
  model = "linear",
  weak = 4,
  strong = 6,
  weaksize = 0.125,
  strongsize = 0.25,
  pct.sparsity = 0.5,
  rho = 0,
  ncov = 0,
  betacov = 0,
  intercept = FALSE
)
}
\arguments{
\item{n}{An integer of sample size}

\item{p}{An integer of number of features (taxa).}

\item{model}{Type of models associated with outcome variable, can be "linear", "binomial", "cox", or "finegray".}

\item{weak}{Number of features with \code{weak} effect size.}

\item{strong}{Number of features with \code{strong} effect size.}

\item{weaksize}{Actual effect size for \code{weak} effect size. Must be positive.}

\item{strongsize}{Actual effect size for \code{strong} effect size. Must be positive.}

\item{pct.sparsity}{Percentage of zero counts for each sample.}

\item{rho}{Parameter controlling the correlated structure between taxa. Ranges between 0 and 1.}

\item{ncov}{Number of covariates that are not compositional features.}

\item{betacov}{Coefficients corresponding to the covariates that are not compositional features.}

\item{intercept}{Boolean. If TRUE, then a random intercept will be generated in the model. Only works for \code{linear} or \code{binomial} models.}
}
\value{
A list with simulated count matrix \code{xcount}, log1p-transformed count matrix \code{x}, outcome (continuous \code{y}, continuous centered \code{y0}, binary \code{y}, or survival \code{t}, \code{d}), true coefficient vector \code{beta}, list of non-zero features \code{idx}, value of intercept \code{intercept} (if applicable).
}
\description{
Simulate a dataset from log-ratio model.
}
\examples{

set.seed(23420)
dat <- simu(n=50,p=30,model="linear")

}
\author{
Teng Fei. Email: feit1@mskcc.org
}
