% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{select_best_tree}
\alias{select_best_tree}
\title{Select the best tree (from the current set)}
\usage{
select_best_tree(x, data, goal)
}
\arguments{
\item{x}{An \code{FFTrees} object.}

\item{data}{The type of data to consider (as character: either 'train' or 'test').}

\item{goal}{character. A goal to maximize or minimize when selecting a tree from an existing \code{x}
(for which values exist in \code{x$trees$stats}).}
}
\value{
An integer denoting the \code{tree} that maximizes/minimizes \code{goal} in \code{data}.
}
\description{
\code{select_best_tree} selects (looks up and identifies) the best tree
from the set (or \dQuote{fan}) of FFTs contained in the current \code{FFTrees} object \code{x},
an existing type of \code{data} ('train' or 'test'), and
a \code{goal} for which corresponding statistics are available
in the designated \code{data} type (in \code{x$trees$stats}).
}
\details{
Importantly, \code{select_best_tree} only identifies and selects from the set of
\emph{existing} trees with known statistics,
rather than creating new trees or computing new cue thresholds.
More specifically, \code{goal} is used for identifying and selecting the best of
an existing set of FFTs, but not for
computing new cue thresholds (see \code{goal.threshold} and \code{fftrees_cuerank()}) or
creating new trees (see \code{goal.chase} and \code{fftrees_ranktrees()}).
}
\seealso{
\code{\link{FFTrees}} for creating FFTs from and applying them to data.
}
