% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{funMSE}
\alias{funMSE}
\title{Functional MSE}
\usage{
funMSE(object, overTime = TRUE, breaks = object$yind, global = FALSE,
  relative = FALSE, root = FALSE, ...)
}
\arguments{
\item{object}{fitted FDboost-object}

\item{overTime}{per default the functional R-squared is calculated over time
if \code{overTime=FALSE}, the R-squared is calculated per curve}

\item{breaks}{an optional vector or number giving the time-points at which the model is evaluated.
Can be specified as number of equidistant time-points or as vector of time-points.
Defaults to the index of the response in the model.}

\item{global}{logical. defaults to \code{FALSE},
if TRUE the global R-squared like in a normal linear model is calculated}

\item{relative}{logical. defaults to \code{FALSE}. If \code{TRUE} the MSE is standardized
by the global variance of the response \cr
\eqn{ n^{-1} \int  \sum_i (Y_i(t) - \bar{Y})^2 dt \approx  G^{-1} n^{-1} \sum_g \sum_i (Y_i(t_g) - \bar{Y})^2 }}

\item{root}{take the square root of the MSE}

\item{...}{currently not used}
}
\value{
Returns a vector with the calculated MSE and some extra information in attributes.
}
\description{
Calculates the functional MSE for a fitted FDboost-object
}
\details{
Formula to calculate MSE over time, \code{overTime=TRUE}: \cr
\eqn{ MSE(t) = n^{-1} \sum_i (Y_i(t) - \hat{Y}_i(t))^2 }

Formula to calculate MSE over subjects, \code{overTime=FALSE}: \cr
\eqn{ MSE_i = \int (Y_i(t) - \hat{Y}_i(t))^2 dt  \approx G^{-1} \sum_g (Y_i(t_g) - \hat{Y}_i(t_g))^2}
}
\note{
\code{breaks} cannot be changed in the case the \code{bsignal()}
is used over the same domain
as the response! In that case you would have to rename the index of the response or that
of the covariates.
}

