% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrendTimeSeries.R
\name{detrendTimeSeries}
\alias{detrendTimeSeries}
\title{Algorithms for data detrending}
\usage{
detrendTimeSeries(f, acqTime, nIntervals, algorithm, degree, w, pois = FALSE,
 max = FALSE, plot = TRUE)
}
\arguments{
\item{f}{A vector}

\item{acqTime}{Point acquisition rate (in seconds)}

\item{nIntervals}{Number of intervals into which the vector will be grouped prior to the detrending process}

\item{algorithm}{A character string. Choose between Exponential ("exp"), Polynomial ("poly") or Boxcar Filter ("boxcar") detrending}

\item{degree}{The degree of the polynomial function}

\item{w}{Moving average time window size}

\item{pois}{Logical, set to TRUE for detrending performance by adding random, uncorrelated numbers sampled from a Poisson distribution (see details)}

\item{max}{Logical, set to TRUE for detrending performance based on the highest value of the original data, rather than the first one (see details)}

\item{plot}{Logical, set to TRUE (default) to plot de result}
}
\value{
A vector
}
\description{
Allows to perform Exponential, Polynomial or Boxcar Filter detrending over a time series vector
}
\details{
First, the binTimeSeries() function is used to obtain a binned version of 'f' of 'nIntervals' points.
 
For exponential detrending, a model of the form (A0*e^(k*t) is adjusted to the binned vector.

A polynomial function of user-specified degree is rather used for polynomial detrending.

For the case of boxcar filtering, the moving average vector is calculated from the original series.
An amount of zeroes equal to (w-1) is added at the tail of 'f' to compensate for the moving average
effect when position (length(f) - w + 1) is reached.

In either case, the residuals are then obtained and added a constant value for trend correction.
When 'max' is set to TRUE, said value will be the highest in the binned vector of 'f'.

When 'pois' is set to FALSE (default), the trend correction value is directly added to the obtained residuals,
in a quantity that will make the average counts remain constant throughout the whole time series.
On the other hand, when 'pois = TRUE', the trend correction value is instead used as the 'lambda'
parameter for a Poisson distribution from which uncorrelated counts will be randomly sampled and
added to the whole series for trend correction. This procedure asures that only integer counts will
be obtained after detrending, at the cost of adding some noise and making the detrending process a lengthier task.
}
\seealso{
\code{\link{binTimeSeries}}
}
\author{
Alejandro Linares, Ad?n Guerrero, Haydee Hern?ndez
}
