% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expDetrend.R
\name{expDetrend}
\alias{expDetrend}
\title{Exponential detrending of a time series}
\usage{
expDetrend(f, acqTime, nIntervals, pois = FALSE, plot = TRUE)
}
\arguments{
\item{f}{A vector}

\item{acqTime}{Point acquisition rate (in seconds)}

\item{nIntervals}{Number of intervals into which the vector will be grouped before an exponential model fit}

\item{pois}{Boolean, set to TRUE to add random, uncorrelated numbers sampled from a Poisson distribution}

\item{plot}{Boolean, set to TRUE (default) to plot the result}
}
\value{
A vector
}
\description{
Performs the exponential detrending algorithm over a vector
}
\details{
First, the binTimeSeries() function is used to obtain a binned version of 'f' of 'nIntervals' points.
An exponential model of the form (A0*e^(k*t) is then adjusted to the binned vector. The full time series is then
evaluated using the obtained model and the residuals are calculated. When 'pois = FALSE', A0 is directly added
to the full time series residuals for trend correction, in a quantity that will make the average counts remain
constant across the whole time series. On the other hand, when 'pois = TRUE', then A0 will be used as the lambda
parameter for a Poisson distribution from which integer numbers will be randomly sampled and added to the whole
series for trend correction. This procedure asures that no photon counts with decimals will be obtained, though,
it can add some noise to the data.
}
\examples{
\donttest{
### Please navigate to
### (https://github.com/FCSlib/FCSlib/tree/master/Sample\%20Data)
### to find this sample data

x <- read.table("PB030.dat", header = F)

x.d <- expDetrend(x[,2], acqTime = 4e-6, nIntervals = 100, pois = F)

# Poisson sampling (this might take a little bit longer)
x.d.p <- expDetrend(x[,2], acqTime = 4e-6, nIntervals = 100, pois = T)
}
}
\seealso{
\code{\link{polyDetrend} \link{boxcarDetrend} \link{binTimeSeries}}
}
\author{
Alejandro Linares, Adan Guerrero, Haydee Hernández
}
