% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_gteach.R
\name{mlp_teach_sa}
\alias{mlp_teach_sa}
\title{Teaching networks using Simulated Annealing}
\usage{
mlp_teach_sa(net, obj_func, Tinit = 1, epochs = 1000, report_freq = 0,
  report_action = NULL)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{obj_func}{function taking an object of \code{mlp_class} class
as a single argument returning objective to be minimised}

\item{Tinit}{numeric value, initial temperature (default is 0.001)}

\item{epochs}{integer value, number of epochs (iterations) (default is 1000)}

\item{report_freq}{integer value, progress report frequency, if set to 0
no information is printed on the console (this is the default)}

\item{report_action}{function (or NULL), additional action to be taken while
                     printing progress reports, this should be a function
                     taking network as a single argument (default NULL)}
}
\value{
Two-element list, the first field (\code{net}) contains the trained network,
        the second (\code{obj}) - the learning history (value of the objective
        function in consecutive epochs).
}
\description{
This function can be used to teach an ANN to minimise arbitrary objective
function.
}
\examples{
# set up XOR problem
inp <- c(0, 0, 1, 1, 0, 1, 0, 1)
dim(inp) <- c(4, 2)
outp <- c(0, 1, 1, 0)
dim(outp) <- c(4, 1)
# objective
obj <- function(net)
{
    return(mlp_mse(net, inp, outp))
}
# create a 2-6-1 network
net <- mlp_net(c(2, 6, 1))
# teach (in real-world applications the no. of epochs should be larger)
netobj <- mlp_teach_sa(net, obj, Tinit = 1, epochs = 100,
                       report_freq = 1)
# plot learning history
plot(netobj$obj, type = 'l')
}
\keyword{teaching}

