% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{elongationqmult}
\alias{elongationqmult}
\title{calculate FA isotope distribution for elongated FAs using the quasi
multinomial distribution.}
\usage{
elongationqmult(S16, D1, D2, P, E1, E2, E3, E4, E5, M, vcomb16, mcombe)
}
\arguments{
\item{S16}{fraction of newly synthesized palmitate.}

\item{D1}{tracer contribution to M+1 acetate pool.}

\item{D2}{tracer contribution to M+2 acetate pool.}

\item{P}{overdispersion parameter. If different to 0, quasi-multinomial
distribution is obtained, while if set to 0, it is simplified to a multinomial
distribution.}

\item{E1}{fraction of elongated C18 FA from C16.}

\item{E2}{fraction of elongated C20 FA from C18.}

\item{E3}{fraction of elongated C22 FA from C20.}

\item{E4}{fraction of elongated C24 FA from C22.}

\item{E5}{fraction of elongated C26 FA from C24.}

\item{M}{total number of carbons for the FA.}

\item{vcomb16}{list of acetate combinations for C16 synthesis obtained with
combAcetate(16) function.}

\item{mcombe}{list of acetate combinations for each elongation step obtained
with combAcetate(2) function.}
}
\value{
FA isotope distribution.
}
\description{
calculate FA isotope distribution for elongated FAs using the quasi
multinomial distribution.
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
\keyword{internal}
