% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countBamInGranges.R
\name{count.everted.reads}
\alias{count.everted.reads}
\title{Count the number of everted reads for a set of BAM files.}
\usage{
count.everted.reads(
  bed.frame = NULL,
  bed.file = NULL,
  bam.files,
  index.files = bam.files,
  min.mapq = 20,
  include.chr = FALSE
)
}
\arguments{
\item{bed.frame}{\code{data.frame} containing the definition of the regions.
The first three columns must be chromosome, start, end.}

\item{bed.file}{\code{character} file name. Target BED file with the
definition of the regions. This file will only be used if no bed.frame
argument is provided. No headers are assumed so remove them if they exist.
Either a bed.file or a bed.frame must be provided for this function to run.}

\item{bam.files}{\code{character}, list of BAM files to extract read count
data from.}

\item{index.files}{Optional \code{character} argument with the list of
indexes for the BAM files, without the '.bai' suffix. If the indexes are
simply obtained by adding .bai to the BAM files, this argument does not need
to be specified.}

\item{min.mapq}{\code{numeric}, minimum mapping quality to include a read.}

\item{include.chr}{\code{logical}, if set to TRUE, this function will add
the string 'chr' to the chromosome names of the target BED file.}
}
\value{
A data frame that contains the region and the number of identified
reads in each bin.
}
\description{
This is the ExomeDepth high level function that takes a GenomicRanges
object, a list of indexed/sorted BAM files, and compute the number of
everted reads in each of the defined bins.
}
\details{
Everted reads are characteristic of the presence of duplications in a BAM
files. This routine will parse a BAM files and the suggested use is to
provide relatively large bins (for example gene based, and ExomeDepth has a
genes.hg19 object that is appropriate for this) to flag the genes that
contain such reads suggestive of a duplication. A manual check of the data
using IGV is recommended to confirm that these reads are all located in the
same DNA region, which would confirm the presence of a copy number variant.
}
\note{
This function calls a lower level function called XXX that works on
each single BAM file.
}
\examples{

data(genes.hg19)
bam_file <- system.file('extdata/minimum_1_25630000_25650000.bam',
                        package = 'ExomeDepth')
genes.hg19.TTC <- subset(genes.hg19, grepl(pattern = '^TTC34', genes.hg19[['name']]))
print(count.everted.reads (bed.frame = genes.hg19.TTC, bam.files = bam_file, min.mapq = 0))
print(count.everted.reads (bed.frame = genes.hg19.TTC, bam.files = bam_file, min.mapq = 35))

}
\references{
Medvedev et al (2009) <https://doi.org/10.1038/nmeth.1374>
"Computational methods for discovering structural variation with
next-generation sequencing"
}
\seealso{
getBAMCounts
}
