% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exactmed.R
\name{exactmed}
\alias{exactmed}
\title{Exact Mediation Effects Computation}
\usage{
exactmed(
  data,
  a,
  m,
  y,
  a1,
  a0,
  m_cov = NULL,
  y_cov = NULL,
  m_cov_cond = NULL,
  y_cov_cond = NULL,
  adjusted = TRUE,
  interaction = TRUE,
  Firth = FALSE,
  boot = FALSE,
  nboot = 1000,
  bootseed = 1991,
  confcoef = 0.95,
  hvalue_m = NULL,
  hvalue_y = NULL
)
}
\arguments{
\item{data}{a named data frame that includes the exposure, mediator and outcome variables as well as the covariates
to be adjusted for in the models. The exposure can be either binary or continuous. If a covariate is categorical,
it has to be included in the data frame as a factor, character or logical variable.}

\item{a}{the name of the exposure variable.}

\item{m}{the name of the mediator variable.}

\item{y}{the name of the outcome variable.}

\item{a1}{a value corresponding to the high level of the exposure.}

\item{a0}{a value corresponding to the low level of the exposure.}

\item{m_cov}{a vector containing the names of the adjustment variables (covariates) in the mediator model.}

\item{y_cov}{a vector containing the names of the adjustment variables (covariates) in the outcome model.}

\item{m_cov_cond}{a named vector (atomic vector or list) containing specific values for some or all
of the adjustment covariates \code{m_cov} in the mediator model. Please consult the package vignette for details.}

\item{y_cov_cond}{a named vector (atomic vector or list) containing specific values for some or all
of the adjustment covariates \code{y_cov} in the outcome model. Please consult the package vignette for details.}

\item{adjusted}{a logical variable specifying whether to obtain unadjusted or adjusted estimates.
If \code{adjusted == FALSE}, vectors \code{m_cov} and \code{y_cov} are ignored by the procedure.}

\item{interaction}{a logical variable specifying whether there is an exposure-mediator interaction term in the outcome model.}

\item{Firth}{a logical variable specifying whether to compute conventional maximum likelihood estimates
or Firth  penalized estimates in the logistic regression models.}

\item{boot}{a logical value specifying whether the confidence intervals are obtained
by the delta method or by percentile bootstrap.}

\item{nboot}{The number of bootstrap replications used to obtain the confidence intervals if \code{boot == TRUE}.}

\item{bootseed}{The value of the initial seed (positive integer) for random number generation if \code{boot == TRUE}.}

\item{confcoef}{a number between 0 and 1 for the confidence coefficient (ex:0.95) of the interval estimates.}

\item{hvalue_m}{the value corresponding to the high level of the mediator. If the mediator is already coded
as a numerical binary variable taking 0 or 1 values, then by default \code{hvalue_m == 1}.}

\item{hvalue_y}{the value corresponding to the high level of the outcome. If the outcome is already coded
as a numerical binary variable taking 0 or 1 values, then by default \code{hvalue_y == 1}.}
}
\value{
Returns natural direct, indirect and total effect estimates as well as controlled direct effects
    estimates on the OR, RR and RD scales.
}
\description{
Relying on a regression-based approach, the \code{exactmed()} function calculates standard
    causal mediation effects when the outcome and the mediator are binary. More precisely, \code{exactmed()}
    uses a logistic regression specification for both the outcome and the mediator in order to compute \emph{exact}
    conditional natural direct and indirect effects (see details in Samoilenko and Lefebvre, 2021).
    The function returns point and interval estimates for the conditional natural effects without making any assumption
    regarding the rareness or commonness of the outcome (hence the term exact). For completeness, \code{exactmed()} also
    calculates the conditional controlled direct effects at both values of the mediator. Natural and controlled effects
    estimates are reported using three different scales: odds ratio (OR), risk ratio (RR) and risk difference (RD).
    The interval estimates can be obtained either by the delta method or the bootstrap.
}
\details{
By default, \code{exactmed()} reports mediation effects evaluated at the sample-specific mean values of the numerical covariates
    (including the dummy variables created internally by the function to represent the categorical covariates).
    In order to estimate mediation effects at specific values of some covariates (that is, stratum-specific effects),
    the user needs to provide named vectors \code{m_cov_cond} and/or \code{y_cov_cond} containing those values or levels. The adjustment
    covariates appearing in both \code{m_cov} and \code{y_cov} (common adjustment covariates) must have the same values; otherwise,
    \code{exactmed()}'s execution is aborted and an error message is displayed in the R console.
}
\note{
\code{exactmed()} only works for complete data. Users can apply multiple imputation techniques (e.g., R package \emph{mice})
 or remove observations of variables used in mediation analysis that have missing values (NA).
}
\examples{
exactmed(
  data = datamed, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2")
)

m_cov_cond <- c(C1 = 0.1, C2 = 0.4)
y_cov_cond <- c(C1 = 0.1, C2 = 0.4)

exactmed(
  data = datamed, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2"),
  m_cov_cond = m_cov_cond, y_cov_cond = y_cov_cond
)

C1b <- factor(sample(c("a", "b", "c"), nrow(datamed), replace = TRUE))
datamed$C1 <- C1b

m_cov_cond <- list(C1 = "c", C2 = 0.4)
y_cov_cond <- list(C1 = "c", C2 = 0.4)

exactmed(
  data = datamed, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2"),
  m_cov_cond = m_cov_cond, y_cov_cond = y_cov_cond
)
}
\references{
Samoilenko M, Lefebvre G. Parametric-Regression-Based Causal Mediation Analysis of Binary Outcomes and Binary Mediators:
Moving Beyond the Rareness or Commonness of the Outcome, \emph{American Journal of Epidemiology}.2021;190(9):1846-1858.

Samoilenko M, Blais L, Lefebvre G. Comparing logistic and log-binomial models for causal mediation analyses of
binary mediators and rare binary outcomes: evidence to support cross-checking of mediation results in practice.
\emph{Observational Studies}.2018;4(1):193-216.
}
