% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.HazardShape.R
\encoding{UTF-8}
\name{legend.HazardShape}
\alias{legend.HazardShape}
\title{Customize legend for \code{\link{plot.HazardShape}} outputs}
\usage{
legend.HazardShape(
  x,
  y = NULL,
  legend = c("Empirical TTT", "Spline curve"),
  fill = NULL,
  col = 1,
  border = "white",
  lty = NA,
  lwd = NA,
  pch = c(1, NA),
  angle = 45,
  density = NULL,
  bty = "o",
  bg = par("bg"),
  box.lwd = par("lwd"),
  box.lty = par("lty"),
  box.col = par("fg"),
  pt.bg = NA,
  cex = 1,
  pt.cex = cex,
  pt.lwd = lwd,
  xjust = 0,
  yjust = 1,
  x.intersp = 1,
  y.intersp = 1,
  adj = c(0, 0.5),
  text.width = NULL,
  text.col = par("col"),
  text.font = NULL,
  merge = TRUE,
  trace = FALSE,
  plot = TRUE,
  ncol = 1,
  horiz = FALSE,
  title = NULL,
  inset = 0,
  xpd = TRUE,
  title.col = text.col[1],
  title.adj = 0.5,
  title.cex = cex[1],
  title.font = text.font[1],
  seg.len = 2,
  curve_options = list(col = 2, lwd = 2, lty = 1)
)
}
\arguments{
\item{x, y}{the x and y co-ordinates to be used to position the legend.
    They can be specified by keyword or in any way which is accepted by
    \code{\link{xy.coords}}: See \sQuote{Details}.}

\item{legend}{a character or \link{expression} vector
    of length \eqn{\ge 1} to appear in the legend.  Other
    objects will be coerced by \code{\link{as.graphicsAnnot}}.}

\item{fill}{if specified, this argument will cause boxes filled
    with the specified colors (or shaded in the specified colors)
    to appear beside the legend text.}

\item{col}{the color of points or lines appearing in the legend.}

\item{border}{the border color for the boxes (used only if
    \code{fill} is specified).}

\item{lty, lwd}{the line types and widths for lines appearing in the
    legend.  One of these two \emph{must} be specified for line drawing.}

\item{pch}{the plotting symbols appearing in the legend, as
    numeric vector or a vector of 1-character strings (see
    \code{\link[graphics]{points}}). Unlike \code{points}, this can all be
    specified as a single multi-character string.  \emph{Must} be
    specified for symbol drawing.}

\item{angle}{angle of shading lines.}

\item{density}{the density of shading lines, if numeric and
    positive. If \code{NULL} or negative or \code{NA} color filling
    is assumed.}

\item{bty}{the type of box to be drawn around the legend.  The allowed
    values are \code{"o"} (the default) and \code{"n"}.}

\item{bg}{the background color for the legend box.  (Note that this is
    only used if \code{bty != "n"}.)}

\item{box.lty, box.lwd, box.col}{the line type, width and color for
    the legend box (if \code{bty = "o"}).}

\item{pt.bg}{the background color for the \code{\link[graphics]{points}},
    corresponding to its argument \code{bg}.}

\item{cex}{character expansion factor \bold{relative} to current
    \code{par("cex")}.  Used for text, and provides the default for
    \code{pt.cex}.}

\item{pt.cex}{expansion factor(s) for the points.}

\item{pt.lwd}{line width for the points, defaults to the one for
    lines, or if that is not set, to \code{par("lwd")}.}

\item{xjust}{how the legend is to be justified relative to the legend
    x location.  A value of 0 means left justified, 0.5 means centered
    and 1 means right justified.}

\item{yjust}{the same as \code{xjust} for the legend y location.}

\item{x.intersp}{character interspacing factor for horizontal (x) spacing
    between symbol and legend text.}

\item{y.intersp}{vertical (y) distances (in lines of text shared above/below each legend entry).
    A vector with one element for each row of the legend can be used.}

\item{adj}{numeric of length 1 or 2; the string adjustment for legend
    text.  Useful for y-adjustment when \code{labels} are
    \link{plotmath} expressions.}

\item{text.width}{the width of the legend text in x (\code{"user"})
    coordinates.  (Should be positive even for a reversed x axis.)
    Can be a single positive numeric value (same width for each column of the legend),
    a vector (one element for each column of the legend),
    \code{NULL} (default) for computing a proper maximum value of \code{\link[graphics]{strwidth}(legend)}),
    or \code{NA} for computing a proper column wise maximum value of \code{\link[graphics]{strwidth}(legend)}).}

\item{text.col}{the color used for the legend text.}

\item{text.font}{the font used for the legend text, see \code{\link[graphics]{text}}.}

\item{merge}{logical; if \code{TRUE}, merge points and lines but
    not filled boxes.  Defaults to \code{TRUE} if there are points and lines.}

\item{trace}{logical; if \code{TRUE}, shows how \code{legend} does all
    its magical computations.}

\item{plot}{logical.  If \code{FALSE}, nothing is plotted but the
    sizes are returned.}

\item{ncol}{the number of columns in which to set the legend items
    (default is 1, a vertical legend).}

\item{horiz}{logical; if \code{TRUE}, set the legend horizontally
    rather than vertically (specifying \code{horiz} overrides the \code{ncol}
    specification).}

\item{title}{a character string or length-one expression giving a
    title to be placed at the top of the legend.  Other objects will be
    coerced by \code{\link{as.graphicsAnnot}}.}

\item{inset}{inset distance(s) from the margins as a fraction of the
    plot region when legend is placed by keyword.}

\item{xpd}{if supplied, a value of the \link[graphics]{graphical parameter} \code{xpd}
    to be used while the legend is being drawn.}

\item{title.col}{color for \code{title}, defaults to \code{text.col[1]}.}

\item{title.adj}{horizontal adjustment for \code{title}: see the help
    for \code{\link[graphics]{par}("adj")}.}

\item{title.cex}{expansion factor(s) for the title, defaults to \code{cex[1]}.}

\item{title.font}{the font used for the legend title, defaults to \code{text.font[1]},
    see \code{\link[graphics]{text}}.}

\item{seg.len}{the length of lines drawn to illustrate \code{lty}
    and/or \code{lwd} (in units of character widths).}

\item{curve_options}{a list whose names are curve graphical parameters, and whose
values are the corresponding graphical parameters values.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Put legend after run \code{\link{plot.HazardShape}} function.
}
\details{
This function is a wrapper for the \code{\link[graphics]{legend}} function.
It just adds two features:

\itemize{
\item \code{legend} has a default value, regarding that \code{HazardShape} objects
produces the TTT plot and its LOESS estimation.
\item \code{curve_options} is used to set legend parameters for the LOESS
curve. We encourage you to define first a list with curve parameters, and then
pass it to \code{\link{plot.HazardShape}} and \code{legend.HazardShape} (see example 2).
}
}
\examples{
library(EstimationTools)

data("reduction_cells")
TTT_IG <- TTTE_Analytical(Surv(days, status) ~ 1, data = reduction_cells,
                          method = 'censored')
HS_IG <- TTT_hazard_shape(TTT_IG, data = reduction_cells)

#----------------------------------------------------------------------------
# Example 1: put legend to the TTT plot of the reduction cells data set.

# Run `plot.HazardShape` method.
par(
  cex.lab=1.8,
  cex.axis=1.8,
  mar=c(4.8,5.4,1,1),
  las = 1,
  mgp=c(3.4,1,0)
)
plot(HS_IG, pch = 16, cex = 1.8)

# Finally, put the legend
legend.HazardShape(
  x = "bottomright",
  box.lwd = NA,
  cex = 1.8,
  pt.cex = 1.8,
  bty = 'n',
  pch = c(16, NA)
)
#----------------------------------------------------------------------------
# Example 2: example 1 with custom options for the curve

# This is the list with curve parameters
loess_options <- list(
  col = 3, lwd = 4, lty = 2
)
par(
  cex.lab=1.8,
  cex.axis=1.8,
  mar=c(4.8,5.4,1,1),
  las = 1,
  mgp=c(3.4,1,0)
)

plot(HS_IG, pch = 16, cex = 1.8, curve_options = loess_options)
legend.HazardShape(
  x = "bottomright",
  box.lwd = NA,
  cex = 1.8,
  pt.cex = 1.8,
  bty = 'n',
  pch = c(16, NA),
  curve_options = loess_options
)

}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
