% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.empiricalTTT.R
\name{plot.EmpiricalTTT}
\alias{plot.EmpiricalTTT}
\title{Plot method for \code{EmpiricalTTT} objects}
\usage{
\method{plot}{EmpiricalTTT}(
  x,
  add = FALSE,
  grid = FALSE,
  type = "l",
  pch = 1,
  xlab = "i/n",
  ylab = expression(phi[n](i/n)),
  ...
)
}
\arguments{
\item{x}{an object of class \code{EmpiricalTTT}.}

\item{add}{logical. If TRUE, \code{plot.EmpiricalTTT} add a TTT plot to an
already existing plot.}

\item{grid}{logical. If \code{TRUE}, plot appears with grid.}

\item{type}{character string (length 1 vector) or vector of 1-character strings
indicating the type of plot for each TTT graph. See \code{\link{plot}}.}

\item{pch}{numeric (integer). A vector of plotting characters or symbols when
\code{type = "p"}. See \code{\link[graphics]{points}}.}

\item{xlab, ylab}{titles for x and y axes, as in \code{\link{plot}}.}

\item{...}{further arguments passed to \code{\link[graphics]{matplot}}. See
the examples and \strong{Details} section for further information.}
}
\description{
Draws a TTT plot of an \code{EmpiricalTTT} object, one for each strata.

TTT plots are graphed in the same order in which they appear in the list
element \code{strata} or in the list element \code{phi_n} of
the \code{EmpiricalTTT} object.
}
\details{
This method is based on \code{\link[graphics]{matplot}}. Our function
sets some default values for graphic parameters: \code{type = "l"}, \code{pch = 1},
\code{xlab = "i/n"} and \code{ylab = expression(phi[n](i/n))}. This arguments
can be modified by the user.
}
\examples{
library(EstimationTools)

#--------------------------------------------------------------------------------
# First example: Scaled empirical TTT from 'mgus1' data from 'survival' package.

TTT_1 <- TTTE_Analytical(Surv(stop, event == 'pcm') ~1, method = 'cens',
                         data = mgus1, subset=(start == 0))
plot(TTT_1, type = "p")


#--------------------------------------------------------------------------------
# Second example: Scaled empirical TTT using a factor variable with 'aml' data
# from 'survival' package.

TTT_2 <- TTTE_Analytical(Surv(time, status) ~ x, method = "cens", data = aml)
plot(TTT_2, type = "l", lty = c(1,1), col = c(2,4))
plot(TTT_2, add = TRUE, type = "p", lty = c(1,1), col = c(2,4), pch = 16)

#--------------------------------------------------------------------------------
# Third example: Non-scaled empirical TTT without a factor (arbitrarily simulated
# data).

y <- rweibull(n=20, shape=1, scale=pi)
TTT_3 <- TTTE_Analytical(y ~ 1, scaled = FALSE)
plot(TTT_3, type = "s", col = 3, lwd = 3)


#--------------------------------------------------------------------------------
# Fourth example: TTT plot for 'carbone' data from 'AdequacyModel' package

if (!require('AdequacyModel')) install.packages('AdequacyModel')
library(AdequacyModel)
data(carbone)
TTT_4 <- TTTE_Analytical(response = carbone, scaled = TRUE)
plot(TTT_4, type = "l", col = "red", lwd = 2, grid = TRUE)


#--------------------------------------------------------------------------------

}
\seealso{
\code{\link{TTTE_Analytical}}, \code{\link[graphics]{matplot}}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
