% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indqi.R
\name{rend_ind}
\alias{rend_ind}
\title{Peeling Index and Industrial Yield}
\usage{
rend_ind(GEN, NG2M, MG, MC, RG, stat = "all", verbose = FALSE, ...)
}
\arguments{
\item{GEN}{The column with the name of the genotypes.}

\item{NG2M}{The column with values for the number of grains larger than 2mm.}

\item{MG}{The column with grain mass values.}

\item{MC}{The column with karyopsis mass values.}

\item{RG}{The column with the grain yield values (kg per ha).}

\item{stat}{Logical argument. Use 'all' to keep all the observations or 'mean'
to extract the overall average.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}

\item{...}{General parameters of ggplot2 for utilization}
}
\value{
Returns the peeling index and industrial yield considering the
standards desired by the industry.
}
\description{
Calculating the Hulling Index and Industrial Yield of White Oats
}
\examples{
library(EstimateBreed)

data("aveia")
# Calculate the industrial yield without extracting the average
with(aveia, rend_ind(GEN,NG2M,MG,MC,RG))

# Calculate the industrial yield by extracting the average per genotype
with(aveia, rend_ind(GEN,NG2M,MG,MC,RG,stat="mean"))
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
