% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{AlgoParam}
\alias{AlgoParam}
\title{List of datasets containing the Farrington Flexible and GLRNB default parameters by time unit}
\format{A list of 2 dataframes: one with 2 rows and 9 variables and GRLNB with 2 rows and 8 variables
\enumerate{
\item \strong{Default parameters for FarringtonFlexible algorithm}
\describe{
  \item{timeunit}{Time units available in the signal detection tool i.e. week, month}
  \item{w}{Window's half-size, i.e. number of weeks to include before and after the current week in each year
  (w=2 for weeks, w=1 for months)}
  \item{reweight}{Logical specifying whether to reweight past outbreaks or not
  (TRUE for both weeks and months, past outbreaks are always reweighted)}
  \item{trend}{Logical specifying whether a trend should be included and kept
  in case the conditions in the Farrington et. al. paper are met.
  (TRUE for both weeks and months, a trend is always fit)}
  \item{weightsThreshold}{Numeric defining the threshold for reweighting past outbreaks
  using the Anscombe residuals
  (2.85 for both weeks and months, as advised in the improved method)}
  \item{glmWarnings}{Logical specifying whether to print warnings from the call to glm
  (TRUE for both weeks and months)}
  \item{pThresholdTrend}{Numeric defining the threshold for deciding whether to keep trend in the model
  (0.05 for both weeks and months)}
  \item{limit54_1}{Integer, the number of cases defining a threshold for minimum alarm,
  no alarm is sounded if fewer than 'limit54_1' cases were reported in the past 'limit54_2' weeks/months}
  \item{limit54_2}{Integer, the number of periods defining a threshold for minimum alarm,
  no alarm is sounded if fewer than 'limit54_1' cases were reported in the past 'limit54_2' weeks/months}
}


\item \strong{Default parameters for GLRNB algorithm}
\describe{
  \item{timeunit}{Time units available in the signal detection tool i.e. week, month}
  \item{mu0}{A vector of in-control values of the mean of the Poisson / negative binomial distribution
  with the same length as range
  - NULL for both weeks and months}
  \item{theta}{Numeric, the pre-specified value for k or lambda is used in a recursive LR scheme
  - log(1.2) for both weeks and months corresponding to a 20 percent increase in the mean}
  \item{alpha}{Numeric, the dispersion parameter of the negative binomial distribution.
  If alpha=NULL the parameter is calculated as part of the in-control estimation
  - alpha=NULL for both weeks and months}
  \item{cARL}{Numeric, the threshold in the GLR test, i.e. c_gamma - cARL=0.25 for both weeks and months}
  \item{Mtilde}{Integer, the number of observations needed before we have a full rank
  - Mtilde=1 for both weeks and months}
  \item{M}{Integer defining the number of time instances back in time in the window-limited approach.
  To always look back until the first observation use M=-1. M=1 for both weeks and months}
  \item{Change}{Character string specifying the type of the alternative.
  Currently the two choices are intercept and epi
  - Change=intercept for both weeks and months}
}

}}
\usage{
AlgoParam
}
\description{
A list including two datasets containing the parameters used for Farrington Flexible and for GLRNB
for each time unit available in the Signal Detection tool
}
\seealso{
\code{surveillance::farringtonFlexible} \code{surveillance::glrnb}
}
\keyword{datasets}
