% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AER_table.R
\name{shapeECDCFlexTable}
\alias{shapeECDCFlexTable}
\title{Shaping the final table (layout, title, color, font)}
\usage{
shapeECDCFlexTable(ft, headers, fsize, fname, maincolor, lastbold)
}
\arguments{
\item{ft}{flextable (see \code{'flextable'} package), table to shape into ECDC table layout}

\item{headers}{dataframe including the multiple headers to add to the flextable object.
Please note that the column \code{col_keys} should contain the names of the flextable object
(i.e. \code{col_key = names(x)}), accordingly to \code{\link[flextable]{set_header_df}}.}

\item{fsize}{numeric, font to use (Default 7)}

\item{fname}{character, font name (Default \code{"Tahoma"})}

\item{maincolor}{character string, hexadecimal code for the header background
color (Default \code{EcdcColors(col_scale = "green", n=1)})}

\item{lastbold}{bolean, last row in bold (Default \code{TRUE}),
usually used when the last row includes totals (EU/EEA totals)}
}
\value{
flextable object (see \code{flextable} package)
}
\description{
Shaping the final table including titles, adding background color, specifying font name and size.
}
\seealso{
Global function: \code{\link{getTableByMS}} \cr
Required package: \code{\link[flextable]{flextable}}
}
