% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{stan_opts}
\alias{stan_opts}
\title{Stan Options}
\usage{
stan_opts(
  object = NULL,
  samples = 2000,
  method = c("sampling", "vb", "laplace", "pathfinder"),
  backend = c("rstan", "cmdstanr"),
  init_fit = NULL,
  return_fit = TRUE,
  ...
)
}
\arguments{
\item{object}{Stan model object. By default uses the compiled package
default if using the "rstan" backend, and the default model obtained using
\code{\link[=epinow2_cmdstan_model]{epinow2_cmdstan_model()}} if using the "cmdstanr" backend.}

\item{samples}{Numeric, default 2000. Overall number of posterior samples.
When using multiple chains iterations per chain is samples / chains.}

\item{method}{A character string, defaulting to sampling. Currently supports
MCMC sampling ("sampling") or approximate posterior sampling via
variational inference ("vb") and, as experimental features if the
"cmdstanr" backend is used, approximate posterior sampling with the
laplace algorithm ("laplace") or pathfinder ("pathfinder").}

\item{backend}{Character string indicating the backend to use for fitting
stan models. Supported arguments are "rstan" (default) or "cmdstanr".}

\item{init_fit}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Character string or \code{stanfit} object, defaults to NULL. Should an initial
fit be used to initialise the full fit. An example scenario would be using a
national level fit to parametrise regional level fits. Optionally a
character string can be passed with the currently supported option being
"cumulative". This fits the model to cumulative cases and may be useful for
certain data sets where the sampler gets stuck or struggles to initialise.
See \code{\link[=init_cumulative_fit]{init_cumulative_fit()}} for details.

This implementation is based on the approach taken in
\href{https://github.com/ImperialCollegeLondon/epidemia/}{epidemia} authored by
James Scott.

This argument is deprecated and the default (NULL) will be used from
the next version.}

\item{return_fit}{Logical, defaults to TRUE. Should the fit stan model be
returned.}

\item{...}{Additional parameters to pass to underlying option functions,
\code{\link[=stan_sampling_opts]{stan_sampling_opts()}} or \code{\link[=stan_vb_opts]{stan_vb_opts()}}, depending on the method}
}
\value{
A \verb{<stan_opts>} object of arguments to pass to the appropriate
rstan functions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Defines a list specifying the arguments passed to underlying stan
backend functions via \code{\link[=stan_sampling_opts]{stan_sampling_opts()}} and \code{\link[=stan_vb_opts]{stan_vb_opts()}}. Custom
settings can be supplied which override the defaults.
}
\examples{
# using default of [rstan::sampling()]
stan_opts(samples = 1000)

# using vb
stan_opts(method = "vb")
}
\seealso{
\code{\link[=stan_sampling_opts]{stan_sampling_opts()}} \code{\link[=stan_vb_opts]{stan_vb_opts()}}
}
