% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{mean.dist_spec}
\alias{mean.dist_spec}
\title{Returns the mean of one or more delay distribution}
\usage{
\method{mean}{dist_spec}(x, ...)
}
\arguments{
\item{x}{The \code{\link[=dist_spec]{dist_spec()}} to use}

\item{...}{Not used}
}
\value{
A vector of means.
}
\description{
This works out the mean of all the (parametric / nonparametric) delay
distributions combined in the passed \code{\link[=dist_spec]{dist_spec()}}.
}
\examples{
# A fixed lognormal distribution with mean 5 and sd 1.
lognormal <- dist_spec(
 mean = 5, sd = 1, max = 20, distribution = "lognormal"
)
mean(lognormal)

# An uncertain gamma distribution with mean 3 and sd 2
gamma <- dist_spec(
 mean = 3, sd = 2, mean_sd = 0.5, sd_sd = 0.5, max = 20,
 distribution = "gamma"
)
mean(gamma)

# The mean of the sum of two distributions
mean(lognormal + gamma)
}
\author{
Sebastian Funk
}
