% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_cases}
\alias{report_cases}
\title{Report case counts by date of report}
\usage{
report_cases(
  case_estimates,
  case_forecast = NULL,
  delays,
  type = "sample",
  reporting_effect,
  CrIs = c(0.2, 0.5, 0.9)
)
}
\arguments{
\item{case_estimates}{A data.table of case estimates with the following variables: date, sample, cases}

\item{case_forecast}{A data.table of case forecasts with the following
variables: date, sample, cases. If not supplied the default is not to
incorporate forecasts.}

\item{delays}{A call to \code{delay_opts()} defining delay distributions and
options. See the documentation of \code{delay_opts()} and the examples below for
details.}

\item{type}{Character string indicating the method to use to transform counts. Supports either "sample"
which approximates sampling or "median" would shift by the median of the distribution.}

\item{reporting_effect}{A \code{data.table} giving the weekly reporting effect
with the following variables: \code{sample} (must be the same as in \code{nowcast}),
\code{effect} (numeric scaling factor for each weekday),\code{day} (numeric 1 - 7
(1 = Monday and 7 = Sunday)). If not supplied then no weekly reporting
effect is assumed.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}
}
\value{
A list of \code{data.table}s. The first entry contains the following
variables \code{sample}, \code{date} and \code{cases} with the second being summarised
across samples.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}}
Convolves latent infections to reported cases via an observation model.
Likely to be removed/replaced in later releases by functionality drawing on
the \code{stan} implementation.
}
\examples{
\donttest{
# define example cases
cases <- example_confirmed[1:40]

# set up example delays
generation_time <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
incubation_period <- get_incubation_period(disease = "SARS-CoV-2", source = "lauer")
reporting_delay <- list(
  mean = convert_to_logmean(2, 1), mean_sd = 0.1,
  sd = convert_to_logsd(2, 1), sd_sd = 0.1, max = 10
)

# Instead of running them model we use example
# data for speed in this example.
cases <- cases[, cases := as.integer(confirm)]
cases <- cases[, confirm := NULL][, sample := 1]

reported_cases <- report_cases(
  case_estimates = cases,
  delays = delay_opts(incubation_period, reporting_delay),
  type = "sample"
)
print(reported_cases)
}
}
