% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.netsim}
\alias{merge.netsim}
\title{Merge Model Simulations across netsim Objects}
\usage{
\method{merge}{netsim}(
  x,
  y,
  keep.transmat = TRUE,
  keep.network = TRUE,
  keep.nwstats = TRUE,
  keep.other = TRUE,
  param.error = TRUE,
  keep.diss.stats = TRUE,
  ...
)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{\link{netsim}}.}

\item{y}{Another \code{EpiModel} object of class \code{\link{netsim}},
with the identical model parameterization as \code{x}.}

\item{keep.transmat}{If \code{TRUE}, keep the transmission matrices from the
original \code{x} and \code{y} elements. Note: transmission matrices
only saved when (\code{save.transmat == TRUE}).}

\item{keep.network}{If \code{TRUE}, keep the \code{networkDynamic} objects
from the original \code{x} and \code{y} elements. Note: network
only saved when (\code{tergmLite == FALSE}).}

\item{keep.nwstats}{If \code{TRUE}, keep the network statistics (as set by
the \code{nwstats.formula} parameter in \code{control.netsim}) from
the original \code{x} and \code{y} elements.}

\item{keep.other}{If \code{TRUE}, keep the other simulation elements (as set
by the \code{save.other} parameter in \code{control.netsim}) from the
original \code{x} and \code{y} elements.}

\item{param.error}{If \code{TRUE}, if \code{x} and \code{y} have different
params (in \code{\link{param.net}}) or controls (passed in
\code{\link{control.net}}) an error will prevent the merge. Use
\code{FALSE} to override that check.}

\item{keep.diss.stats}{If \code{TRUE}, keep \code{diss.stats} from the
original \code{x} and \code{y} objects.}

\item{...}{Additional merge arguments (not currently used).}
}
\value{
An \code{EpiModel} object of class \code{\link{netsim}} containing
        the data from both \code{x} and \code{y}.
}
\description{
Merges epidemiological data from two independent simulations of
             stochastic network models from \code{netsim}.
}
\details{
This merge function combines the results of two independent simulations of
\code{\link{netsim}} class models, simulated under separate function calls.
The model parameterization between the two calls must be exactly the same,
except for the number of simulations in each call. This allows for manual
parallelization of model simulations.

This merge function does not work the same as the default merge, which allows
for a combined object where the structure differs between the input elements.
Instead, the function checks that objects are identical in model
parameterization in every respect (except number of simulations) and binds
the results.
}
\examples{
# Network model
nw <- network_initialize(n = 100)
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 10)
est <- netest(nw, formation = ~edges, target.stats = 25,
              coef.diss = coef.diss, verbose = FALSE)

# Epidemic models
param <- param.net(inf.prob = 1)
init <- init.net(i.num = 1)
control <- control.net(type = "SI", nsteps = 20, nsims = 2,
                       save.nwstats = TRUE,
                       nwstats.formula = ~edges + degree(0),
                       verbose = FALSE)
x <- netsim(est, param, init, control)
y <- netsim(est, param, init, control)

# Merging
z <- merge(x, y)

# Examine separate and merged data
as.data.frame(x)
as.data.frame(y)
as.data.frame(z)

}
\keyword{extract}
