% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimRmcmc.R
\name{estimRmcmc}
\alias{estimRmcmc}
\title{Estimation of the reproduction number with Laplacian-P-splines via MCMC}
\usage{
estimRmcmc(incidence, si, K = 30, dates = NULL, niter = 5000, burnin = 2000,
 CoriR = FALSE, WTR = FALSE, priors = Rmodelpriors())
}
\arguments{
\item{incidence}{A vector containing the incidence time series. If
\code{incidence} contains NA values at certain time points, these are
replaced by the average of the left- and right neighbor counts. If the
right neighbor is NA, the left neighbor is used as a replacement value.}

\item{si}{The (discrete) serial interval distribution.}

\item{K}{Number of B-splines in the basis.}

\item{dates}{A vector of dates in format "YYYY-MM-DD" (optional).}

\item{niter}{The number of MCMC samples.}

\item{burnin}{The burn-in size.}

\item{CoriR}{Should the \eqn{R_t} estimate of Cori (2013) be also computed?}

\item{WTR}{Should the \eqn{R_t} estimate of Wallinga-Teunis (2004) be
also computed?}

\item{priors}{A list containing the prior specification of the model
hyperparameters as set in Rmodelpriors. See ?Rmodelpriors.}
}
\value{
A list with the following components:
\itemize{
 \item{incidence: }{The incidence time series.}
 \item{si: }{The serial interval distribution.}
 \item{RLPS: }{A data frame containing estimates of the reproduction number
   obtained with the Laplacian-P-splines methodology.}
 \item{thetahat: }{The estimated vector of B-spline coefficients.}
 \item{Sighat: }{The estimated variance-covariance matrix of the Laplace
   approximation to the conditional posterior distribution of
   the B-spline coefficients.}
 \item{RCori: }{A data frame containing the estimates of the reproduction
   obtained with the method of Cori (2013).}
 \item{RWT: }{A data frame containing the estimates of the reproduction
   obtained with the method of Wallinga-Teunis (2004).}
 \item{LPS_elapsed: }{The routine real elapsed time (in seconds) when estimation
   of the reproduction number is carried out with Laplacian-P-splines.}
 \item{penparam: }{The estimated penalty parameter related to the P-spline model.}
 \item{K: }{The number of B-splines used in the basis.}
 \item{NegBinoverdisp: }{The estimated overdispersion parameter of the negative
   binomial distribution for the incidence time series.}
 \item{optimconverged: }{Indicates whether the algorithm to maximize the
   posterior distribution of the hyperparameters has converged.}
 \item{method: }{The method to estimate the reproduction number with Laplacian-P-splines.}
 \item{optim_method: }{The chosen method to to maximize the posterior distribution
   of the hyperparameters.}
 \item{HPD90_Rt: }{The \eqn{90\%} HPD interval for Rt obtained with the LPS methodology.}
 \item{HPD95_Rt: }{The \eqn{95\%} HPD interval for Rt obtained with the LPS methodology.}
}
}
\description{
This routine estimates the instantaneous reproduction number \eqn{R_t};
 the mean number of secondary infections generated by an infected individual
 at time \eqn{t} (White et al. 2020); by using Bayesian P-splines and Laplace
 approximations (Gressani et al. 2022). The inference approach is fully
 stochastic with a Metropolis-adjusted Langevin algorithm. The
 \code{estimRmcmc()} routine estimates \eqn{R_t} based on a time series of
 incidence counts and a (discretized) serial interval distribution. The
 negative binomial distribution is used to model incidence count data and
 P-splines (Eilers and Marx, 1996) are used to smooth the epidemic curve.
 The link between the epidemic curve and the reproduction number is
 established via the renewal equation.
}
\examples{
# Illustration on the 2009 influenza pandemic in Pennsylvania.
data(influenza2009)
epifit_flu <- estimRmcmc(incidence = influenza2009$incidence, dates = influenza2009$dates,
                         si = influenza2009$si[-1], niter = 2500, burnin = 1500)
tail(epifit_flu$RLPS)
summary(epifit_flu)
plot(epifit_flu)

}
\references{
Gressani, O., Wallinga, J., Althaus, C. L., Hens, N. and Faes, C.
 (2022). EpiLPS: A fast and flexible Bayesian tool for estimation of the
 time-varying reproduction number. \emph{Plos Computational Biology},
 \strong{18(10): e1010618}.

Cori, A., Ferguson, N.M., Fraser, C., Cauchemez, S. (2013). A new
 framework and software to estimate time-varying reproduction numbers during
 epidemics. \emph{American Journal of Epidemiology}, \strong{178}(9):1505–1512.

Wallinga, J., & Teunis, P. (2004). Different epidemic curves for
severe acute respiratory syndrome reveal similar impacts of control measures.
\emph{American Journal of Epidemiology}, \strong{160}(6), 509-516.

White, L.F., Moser, C.B., Thompson, R.N., Pagano, M. (2021).
 Statistical estimation of the reproductive number from case notification
 data. \emph{American Journal of Epidemiology}, \strong{190}(4):611-620.

Eilers, P.H.C. and Marx, B.D. (1996). Flexible smoothing
 with B-splines and penalties. \emph{Statistical Science},
 \strong{11}(2):89-121.
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
