% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineSource.R
\name{lineSource}
\alias{lineSource}
\title{Distribution of emissions by streets}
\source{
OpenstreetMap data avaliable \url{https://www.openstreetmap.org/} and \url{https://download.geofabrik.de/}
}
\usage{
lineSource(s, grid, as_raster = F, verbose = T, type = "wrfinput",
  gcol = 100, grow = 100)
}
\arguments{
\item{s}{SpatialLinesDataFrame of SpatialLines object}

\item{grid}{grid object with the grid information}

\item{as_raster}{output format, TRUE for raster, FALSE for matrix}

\item{verbose}{display additional information}

\item{type}{"wrfinput", "geo", "sp" or "sf" for grid type}

\item{gcol}{grid points for a "sp" or "sf" type}

\item{grow}{grid points for a "sp" or "sf" type}
}
\description{
Create a distribution from sp spatial lines data frame or spatial lines.

Use "wrfinput" for a gridInfo from an output from real.exe and "geo" for a output from geog.exe

The "sf" (and "sp") uses a grid in SpatialPolygons format instead of create from a model input.
}
\examples{
\donttest{
roads <- osmar::get_osm(osmar::complete_file(),
                        source = osmar::osmsource_file(paste(system.file("extdata",
                        package="EmissV"),"/streets.osm.xz",sep="")))
road_lines <- osmar::as_sp(roads,what = "lines")
roads <- sf::st_as_sf(road_lines)

d3    <- gridInfo(paste0(system.file("extdata", package = "EmissV"),"/wrfinput_d03"))

roadLength <- lineSource(roads,d3,as_raster=TRUE)
sp::spplot(roadLength, scales = list(draw=TRUE), ylab="Lat", xlab="Lon",main="Length of roads",
           sp.layout=list("sp.lines", road_lines))
}


}
\seealso{
\code{\link{gridInfo}} and \code{\link{rasterSource}}
}
