% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcdf.R
\name{plotcdf}
\alias{plotcdf}
\title{Plots multivariate empirical joint distribution of bivariate data}
\usage{
plotcdf(data, type = "levelplot", angle = 60,
  main = paste("Bivariate CDF of", deparse(substitute(data))))
}
\arguments{
\item{data}{a numeric matrix / data frame of two variables.}

\item{type}{a character spicifies plot types. Must be one of "levelplot", "wireframe", or "multiple_wireframe".}

\item{angle}{a numeric scalar for z axis rotation. With default = 60 degrees.}

\item{main}{a character of plot title.}
}
\description{
This function plots empirical joint distribution (joint CDF) with levelplot, and 3D wireframes.
}
\details{
When type  = "multiple_wireframe", this function plots 8 wireframes of directions 0 to what parameter angle is.
This process takes longer.
When type = "levelplot", parameter angle has no effect.
}
\examples{

n = 10
set.seed(123)
x = rnorm(n)
y = x^2 + 0.1*rnorm(n)
data = cbind(x, y)
plotcdf(data, type = "multiple_wireframe")

}

