% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological-inference.R
\docType{class}
\name{EcologicalInferenceStrategyCalvoEtAl}
\alias{EcologicalInferenceStrategyCalvoEtAl}
\title{EcologicalInferenceStrategyCalvoEtAl}
\description{
EcologicalInferenceStrategyCalvoEtAl

EcologicalInferenceStrategyCalvoEtAl
}
\examples{
ein <- EcologicalInferenceStrategyCalvoEtAl$new()
# Cannot run without having a processor
# ein$runEcologicalInference(NULL, NULL)
}
\author{
ecalvo
}
\section{Super class}{
\code{\link[ElectionsLATAM:EcologicalInferenceStrategy]{ElectionsLATAM::EcologicalInferenceStrategy}} -> \code{EcologicalInferenceStrategyCalvoEtAl}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{estsPG}}{estimation parameters}

\item{\code{fracsPG}}{fractions}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{EcologicalInferenceStrategyCalvoEtAl$new()}}
\item \href{#method-callDifp}{\code{EcologicalInferenceStrategyCalvoEtAl$callDifp()}}
\item \href{#method-paramsEstim}{\code{EcologicalInferenceStrategyCalvoEtAl$paramsEstim()}}
\item \href{#method-calcFractions}{\code{EcologicalInferenceStrategyCalvoEtAl$calcFractions()}}
\item \href{#method-paramsBoot}{\code{EcologicalInferenceStrategyCalvoEtAl$paramsBoot()}}
\item \href{#method-runEcologicalInference}{\code{EcologicalInferenceStrategyCalvoEtAl$runEcologicalInference()}}
\item \href{#method-clone}{\code{EcologicalInferenceStrategyCalvoEtAl$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="ElectionsLATAM" data-topic="EcologicalInferenceStrategy" data-id="setProcessor">}\href{../../ElectionsLATAM/html/EcologicalInferenceStrategy.html#method-setProcessor}{\code{ElectionsLATAM::EcologicalInferenceStrategy$setProcessor()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceStrategyCalvoEtAl$new(seed = 143324)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-callDifp"></a>}}
\if{latex}{\out{\hypertarget{method-callDifp}{}}}
\subsection{Method \code{callDifp()}}{
CALL.DIFP
Calculates penalty for given parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceStrategyCalvoEtAl$callDifp(
  p,
  mx,
  my,
  covar,
  nR,
  nC,
  nP,
  const
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{- parameter vector R x (C-1)}

\item{\code{mx}}{- Column marginals}

\item{\code{my}}{- row marginals}

\item{\code{nR}}{- number of rows}

\item{\code{nC}}{- number of columns}

\item{\code{nP}}{- number of precincts}

\item{\code{const}}{- weight for penalty}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-paramsEstim"></a>}}
\if{latex}{\out{\hypertarget{method-paramsEstim}{}}}
\subsection{Method \code{paramsEstim()}}{
Ecological Inference in the RxC case
Penalized Least Square Minimizer
PARAMS.ESTIM
Estimates parameters minimizing the penalized least squares criterion
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceStrategyCalvoEtAl$paramsEstim(
  data,
  x = -1,
  nR,
  nC,
  const = 0.001,
  parSeed = -1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{- marginals (optionally with covariates)}

\item{\code{x}}{- index (optional, for bootstrapping)}

\item{\code{nR}}{- number of rows}

\item{\code{nC}}{- number of columns}

\item{\code{const}}{- weight for penalty}

\item{\code{parSeed}}{- Seed for parameters (optional)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-calcFractions"></a>}}
\if{latex}{\out{\hypertarget{method-calcFractions}{}}}
\subsection{Method \code{calcFractions()}}{
Calculate Fractions
CALC.FRACTIONS
Calculate fractions from the parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceStrategyCalvoEtAl$calcFractions(p, nR, nC, covar = F)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{- parameters}

\item{\code{nR}}{- number of rows}

\item{\code{nC}}{- number of columns}

\item{\code{covar}}{- (Optional) Vector of covariates}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-paramsBoot"></a>}}
\if{latex}{\out{\hypertarget{method-paramsBoot}{}}}
\subsection{Method \code{paramsBoot()}}{
Bootstrapping
PARAMS.BOOT
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceStrategyCalvoEtAl$paramsBoot(data, nR, nC, bootSamples)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{- marginals (optionally, with covariates)}

\item{\code{nR}}{- number of rows}

\item{\code{nC}}{- number of columns}

\item{\code{bootSamples}}{- number of bootstrap samples}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runEcologicalInference"></a>}}
\if{latex}{\out{\hypertarget{method-runEcologicalInference}{}}}
\subsection{Method \code{runEcologicalInference()}}{
runEcologicalInference
run ecological inference with current strategy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceStrategyCalvoEtAl$runEcologicalInference(
  input.shares.fields,
  output.shares.fields
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input.shares.fields}}{shares fields in input table}

\item{\code{output.shares.fields}}{shares fields in output table}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceStrategyCalvoEtAl$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
