% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bind_na.R
\name{arrange.vars}
\alias{arrange.vars}
\title{Re-ordering columns in dataframes:}
\usage{
arrange.vars(data, vars)
}
\arguments{
\item{data}{dataframe to be ordered}

\item{vars}{nammed vectors of new positions. See details.}
}
\value{
The dataframe with the desired colum order.
}
\description{
Re-ordering columns in dataframes:
}
\details{
This function provides an easy way to re-order the columns of a
  dataframe. The "vars" parameter must be a nammed numeric vectors with the
  names corresponding to the targeted columns and the numbers corresponding
  to their desired new positions.
}
\examples{
 #### Dummy data:
 dat <- data.frame("Fac1" = c(rep("A", 6), rep("B",6)),
                   "Var1" = rnorm(12, mean = 20, sd = 1),
                   "Fac2" = rep(c("Low","High","Low","High"),
                                each=3),
                   "Var2" = c(rnorm(3,7), rnorm(3,9),
                              rnorm(3,12), rnorm(3,15)))

 # factor columns at the begining.
 arrange.vars(dat, vars =c("Fac2" = 2))
 # factor columns at the end.
 arrange.vars(dat, vars =c("Fac1" = 3, "Fac2" = 4))

}
