% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{var_diff}
\alias{var_diff}
\title{VarDiff Size Overlap Ratio Metric}
\usage{
var_diff(m = runif(20))
}
\arguments{
\item{m}{a vector of non-negative trait measures, one for each species}
}
\value{
Returns the variance of the absolute difference between adjacent, ordered values.
}
\description{
Function to calculate the variance in size differences
between adjacent, ordered species. If there is a tendency towards a
constant absolute size difference between adjacent species, this
variance will be relatively small. Alternatively, if some adjacent species
are close in size, but others are very distant, this variance will be
large. Small variances might be indicative of assemblages in which
there is a competitively-based limit to similarity.
}
\examples{
SizeDifVar <- var_diff(rgamma(20,shape=3,scale=2))
}
\references{
Poole, R.W. and B.J. Rathcke. 1979. Regularity, randomness,
and aggregation in flowering phenologies. Science 203:470-471.

Simberloff, D. and W.J. Boecklen. 1981. Santa Rosalia reconsidered: size
ratios and competition. Evolution 35: 1206-1228.
}

