% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.breadth.R
\name{env.breadth}
\alias{env.breadth}
\title{Calculates breadth of a model in environment space using latin hypercube sampling}
\usage{
env.breadth(model, env, tolerance = 1e-04, max.reps = 10, chunk.size = 1e+05)
}
\arguments{
\item{model}{An enmtools.model object or a model object that can be projected using the predict() function}

\item{env}{A raster, raster stack of environmental data, or a list of minima and maxima for the environmental space to evaluate models over.}

\item{tolerance}{How close do successive overlap metrics have to be before we decide we're close enough to the final answer}

\item{max.reps}{Maximum number of attempts that will be made to find suitable starting conditions}

\item{chunk.size}{How many combinations of environmental variables to try at a time.  If your niche breadth in environment space is small, increasing this value may help you get a result.}
}
\value{
A list containing the environmental space version of the B2 metric and a plot of B2 estimates as a function of sample size, used as a convergence diagnostic.
}
\description{
Calculates breadth of a model in environment space using latin hypercube sampling
}
\examples{
\donttest{
cyreni <- iberolacerta.clade$species$cyreni
cyreni.glm <- enmtools.glm(cyreni, euro.worldclim, test.prop = 0.2,
f = pres ~ bio1 + bio12, nback = 500)
env.breadth(cyreni.glm,  euro.worldclim)
}
}
