% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{pkml}
\alias{pkml}
\alias{pkml,binClstPath-method}
\title{Generate a pointwise .kml file of a \link{binClstPath_instance}}
\usage{
pkml(obj, folder = "embcDocs", markerRadius = 15, display = FALSE, ...)

\S4method{pkml}{binClstPath}(obj, folder, markerRadius, display,
  showClst = numeric(), ...)
}
\arguments{
\item{obj}{A \link{binClstPath_instance}.}

\item{folder}{A character string indicating the name of the folder in which
the .kml file will be saved. If the folder does not exist it is
automatically created, (defaults to '~/embcDocs').}

\item{markerRadius}{A numeric value indicating the radius of the markers to
be plotted, (defaults to 5 pixels).}

\item{display}{A boolean value (defaults to FALSE) to automatically launch
Google-Earth from within R to visualize the generated .kml document.
(Google Earth must already be installed on the system. In Windows, it must
be associated with the .kml file type.)}

\item{...}{Parameters \code{folder}, \code{markerRadius}, \code{display} and
\code{showClst} are optional.}

\item{showClst}{A numeric vector indicating a subset of clusters to be shown.}
}
\value{
The path/name of the saved kml file.
}
\description{
\code{pkml} generates a pointwise KML file of a
  \link{binClstPath_instance}, which can be viewed using Google Earth or
  other GIS software.
}
\examples{
\dontrun{
# -- apply EMbC to the example path --
mybcp <- stbc(expth,info=-1)
# -- generate a pointwise .kml of the output --
pkml(mybcp)
# -- show only stopovers and automatically display the .kml document --
pkml(mybcp,showClst=c(1,2),display=TRUE)
}
}
\seealso{
\code{\link{bkml}}
}
