% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{binClstPath-class}
\alias{binClstPath-class}
\title{Binary Clustering Path Class}
\description{
\code{binClstPath} is a \code{binClst} subclass for fast and easy speed/turn-clustering of movement trajectories. The input trajectory is given as a data.frame with, at least, the columns (timeStamp,longitude,latitude). This format is described in detail in the class constructor \link{stbc}. As a \code{binClst} subclass, this class inherits all slots and functionality of its parent class.
}
\section{Slots}{

\describe{
\item{\code{pth}}{A data.frame with the trajectory timestamps and geolocation coordinates, plus eventual extra columns that were included in the input path data frame, (see the \link{stbc} constructor).}

\item{\code{spn}}{A numeric vector with the time intervals between locations (in seconds).}

\item{\code{dst}}{A numeric vector with the distances between locations (in meters). We use loxodromic computations.}

\item{\code{hdg}}{A numeric vector with local heading directions (in radians from North). We use loxodromic computations.}

\item{\code{bursted}}{A logical value indicating whether the \code{binClstPath} instance has already been bursted. As bursting can be computationally demanding for long trajectories, an instance is bursted only when a burst wise representation of the trajectory' is requested for the first time, (unless this value is changed to FALSE).}

\item{\code{tracks}}{If bursted=TRUE, a \code{SpatialLinesDataFrame} object ("sp" R-package) with the bursted track segments.}

\item{\code{midPoints}}{If bursted=TRUE, a \code{SpatialPointsDataFrame} object ("sp" R-package) with the bursted track midpoints.}
}}

