% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SavitzkyGolay.R
\name{SavitzkyGolay}
\alias{SavitzkyGolay}
\title{Savitzky-Golay filtering and derivatives}
\usage{
SavitzkyGolay(X, poly = 3, width = 11, deriv = 2)
}
\arguments{
\item{X}{\code{matrix} containing spectra as rows.}

\item{poly}{Polynomial degree of smoother.}

\item{width}{Window width of smoother, default = 11, must be an odd number.}

\item{deriv}{Derivative degree, can be 0, default = 2.}
}
\value{
A matrix of filtered spectra (possibly with derivatives)
}
\description{
Savitzky-Golay filtering and derivatives
}
\examples{
data(fishoil)
Raman    <- fishoil$Raman[, 850:3300]
SavGol   <- SavitzkyGolay(Raman)
old.par  <- par(mfrow = c(2,1), mar = c(4,4,1,1))
matplot(colnames(Raman), t(Raman), type = 'l',
        ylab = 'Relative intensity', xlab = 'Raw spectra')
matplot(colnames(Raman), t(SavGol), type = 'l',
        ylab = 'Relative intensity', xlab = 'Smoothed 2nd derivative')
par(old.par)
}
