% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/check.data.R
\name{check.data}
\alias{check.data}
\title{Function to check data consistency.}
\usage{
check.data(X, q, l, c, invisible = TRUE, ...)
}
\arguments{
\item{X}{Numeric matrix with m samples (rows) and n variables (columns).}

\item{q}{Numeric scalar with number of end-members to be modelled.}

\item{l}{Numeric scalar or vector specifying the weight transformation
limit, i.e.  quantile.}

\item{c}{Numeric scalar specifying the constant sum scaling parameter, e.g.
1, 100, 1000.}

\item{invisible}{Logical scalar setting visibility option.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
Character vector with test results.
}
\description{
The input data matrix (X), number of end-members (q), weight transformation
limits (l) and constant sum scaling parameter (c) are checked for
consistency. This includes checking for absence of missing values, columns
containing only zero-values and for numeric data type of variables.
Furthermore, a check tests if l is below the maximum possible value,
preventing numerical instability prior to factor rotation.
}
\examples{
## load example data set
data(X, envir = environment())

## perform data set check
check.data(X = X,
           q = 6,
           l = seq(from = 0,
                   to = 0.2,
                   by = 0.01),
           c = 1)
}
\author{
Michael Dietze, Elisabeth Dietze
}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{\link{EMMA}}
}
\keyword{EMMA}

