% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elm_surv.R
\name{elm_surv}
\alias{elm_surv}
\title{ELMSurv elm_surv}
\usage{
elm_surv(trainx, trainy, testx, Regularization_coefficient, kerneltype,
  Kernel_para)
}
\arguments{
\item{trainx}{The covariates(predictor variables) of training data.}

\item{trainy}{Survival time and censored status of training data. Must be a Surv  \code{survival} object}

\item{testx}{The covariates(predictor variables) of test data.}

\item{Regularization_coefficient}{Ridge or Tikhonov regularization parameter. Default value for \code{\link{ELMSurvEN}} is 10000. It need be set by the user here when using a single base ELM survival model. Also known as \eqn{C} in the ELM paper.}

\item{kerneltype}{Type of kernel matrix. kerneltype=1,a RBF kernel;kerneltype=2 , a linear kernel;kerneltype=3 ,a polynomial kernel;kerneltype=4, a sigmoid kernel.}

\item{Kernel_para}{Parameters for different types of kernels. A single value for kerneltype=1 or 2. A vector for kerneltype=3 or 4.}
}
\value{
List of returned values
  \tabular{ll}{
      \code{elmsurvfit}    \tab  Mean Square Error(MSE) on training data. \cr
      \code{newy} \tab Esitmated survival times of training data by the Buckley-James estimator. \cr
      \code{outputWeight} \tab Weights of the output layer in ELM. \cr
      \code{testpre} \tab The estimated survival times for \code{testx} data. \cr
  }
}
\description{
A Kernel Extreme Learning Machine Using the Buckley-James estimator
}
\examples{
set.seed(123)
require(ELMSurv)
require(survival)
#Lung DATA
data(lung)
lung=na.omit(lung)
lung[,3]=lung[,3]-1
n=dim(lung)[1]
L=sample(1:n,ceiling(n*0.5))
trset<-lung[L,]
teset<-lung[-L,]
rii=c(2,3)
#A kernel ELM base model
kerelmsurv=elm_surv(trset[,-rii],Surv(trset[,rii[1]], 
           trset[,rii[2]]),teset[,-c(rii)],10000,2,c(2,1))
#The traing MSE
tr_mse=kerelmsurv$trainMSE
#New survival times imputed for training data
trainy_impute=kerelmsurv$newy
}
\references{
\itemize{
  \item Hong Wang et al (2017). A Survival Ensemble of Extreme Learning Machine. Applied Intelligence, in press.
 }
}
\seealso{
\code{\link{ELMSurvEN}}
}
\author{
Hong Wang
}
