## ----setup, include=FALSE-----------------------------------------------------
library(here)
library(devtools)
knitr::opts_chunk$set(echo = TRUE)
devtools::load_all(here())

## -----------------------------------------------------------------------------
datahp <- financial()
datahs <- social()

## -----------------------------------------------------------------------------
fn <- datahp$poor_liq ~ Dcollege+Totalincome+Dunemp

## -----------------------------------------------------------------------------
q <- c(0.4,0.6) 
v <- matrix(c(-1,0,1))

## ----ei_gce-------------------------------------------------------------------
result <- ei_gce(fn,datahp,datahs,q=q,w=w,tol=NULL,method="BFGS",v=v)

## -----------------------------------------------------------------------------
library(dplyr)
summary(result)

## ----echo=TRUE----------------------------------------------------------------
plot(x=result,datahs$reg)

## -----------------------------------------------------------------------------
result2 <- ei_gce(fn,datahp,datahs,q=NULL,w=w,method="BFGS",v=NULL)
result2

## -----------------------------------------------------------------------------
result3 <- ei_gme (fn,datahp,datahs,w,tol=NULL,method="BFGS",v)

## -----------------------------------------------------------------------------
result3

## -----------------------------------------------------------------------------
summary(object=result3)


## ----echo=TRUE----------------------------------------------------------------
plot(x=result3, reg=datahs$reg)   

