% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualEGA.R
\name{residualEGA}
\alias{residualEGA}
\title{Residualized \code{\link[EGAnet]{EGA}}}
\usage{
residualEGA(data, manifests, lat, negative.items)
}
\arguments{
\item{data}{Matrix or data frame.
Includes the variables to be used in the \code{residualEGA} analysis}

\item{manifests}{Character vector.
Vector indicating the names of the variables (items) to be used in the analysis.}

\item{lat}{Numeric integer.
Number of latent factors to be estimated.
Only one substantive latent factor is recommended in the current version of the function.}

\item{negative.items}{Numeric vector
A numeric vector indicating the column of the negative items.}
}
\value{
Returns a list containing:

\item{openMx.model}{OpenMX model}

\item{openMx.result}{OpenMX results}

\item{openMx.std.par}{OpenMX standardized parameters}

\item{ResidualMatrix}{Residual matrix}

\item{EGA.Residuals}{Results of the residualized EGA}

\item{Fit}{Fit metrics of the network structure, calculated using the ggmfit function of the
\code{\link[qgraph]{qgraph}} package}

\item{WordLoads}{Loadings of the wording effects}
}
\description{
\code{residualEGA} Estimates the number of dimensions after controlling for wording effects.
EGA is applied in the residual of a random intercept item factor model (RIIFA) with one method factor and one substantive factor.
}
\examples{
# Load data
data <- optimism

\dontrun{
# Residual EGA example
opt.res <- residualEGA(data = data, manifests = colnames(optimism),
lat = 1, negative.items = c(3,7,9))

# Fit:
opt.res$Fit}

}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA
and \code{\link[EGAnet]{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Robert Moulder <rgm4fd@virginia.edu>
}
